# PySNMP SMI module. Autogenerated from smidump -f python APPN-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:38:42 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( IANAifType, ) = mibBuilder.importSymbols("IANAifType-MIB", "IANAifType")
( snanauMIB, ) = mibBuilder.importSymbols("SNA-NAU-MIB", "snanauMIB")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, Unsigned32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "Unsigned32")
( DateAndTime, DisplayString, RowPointer, TextualConvention, TimeStamp, TruthValue, VariablePointer, ) = mibBuilder.importSymbols("SNMPv2-TC", "DateAndTime", "DisplayString", "RowPointer", "TextualConvention", "TimeStamp", "TruthValue", "VariablePointer")

# Types

class AppnTgDelay(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(1,1)
    fixedLength = 1
    
class AppnTgDlcData(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,64)
    
class AppnTgEffectiveCapacity(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(1,1)
    fixedLength = 1
    
class AppnTgSecurity(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(192,128,64,160,32,96,1,)
    namedValues = NamedValues(("nonsecure", 1), ("guardedConduit", 128), ("encrypted", 160), ("guardedRadiation", 192), ("publicSwitchedNetwork", 32), ("undergroundCable", 64), ("secureConduit", 96), )
    
class AppnTopologyEntryTimeLeft(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,15)
    
class DisplayableDlcAddress(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,64)
    
class SnaClassOfServiceName(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,8)
    
class SnaControlPointName(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(3,17)
    
class SnaModeName(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,8)
    
class SnaNodeIdentification(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(8,8)
    fixedLength = 8
    
class SnaSenseData(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(8,8)
    fixedLength = 8
    
class AppnLinkStationCounter(Counter32):
    pass

class AppnNodeCounter(Counter32):
    pass

class AppnPortCounter(Counter32):
    pass


# Objects

appnMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 34, 4)).setRevisions(("1998-07-15 18:00","1998-05-26 18:00","1997-07-31 18:00","1997-03-31 18:00","1997-03-20 12:00",))
if mibBuilder.loadTexts: appnMIB.setOrganization("IETF SNA NAU MIB WG / AIW APPN MIBs SIG")
if mibBuilder.loadTexts: appnMIB.setContactInfo("\n\nBob Clouston\nCisco Systems\n7025 Kit Creek Road\nP.O. Box 14987\nResearch Triangle Park, NC 27709, USA\nTel:    1 919 472 2333\nE-mail: clouston@cisco.com\n\nBob Moore\nIBM Corporation\n4205 S. Miami Boulevard\nBRQA/501\nP.O. Box 12195\nResearch Triangle Park, NC 27709, USA\nTel:    1 919 254 4436\nE-mail: remoore@us.ibm.com")
if mibBuilder.loadTexts: appnMIB.setDescription("This is the MIB module for objects used to\nmanage network devices with APPN capabilities.")
appnObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1))
appnNode = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 1))
appnGeneralInfoAndCaps = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1))
appnNodeCpName = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 1), SnaControlPointName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeCpName.setDescription("Administratively assigned network name for this node.")
appnNodeMibVersion = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(11, 11)).setFixedLength(11)).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeMibVersion.setDescription("The value of LAST-UPDATED from this module's MODULE-IDENTITY\nmacro.  This object gives a Management Station an easy way of\ndetermining the level of the MIB supported by an agent.\n\nSince this object incorporates the Year 2000-unfriendly\n2-digit year specified in SMI for the LAST-UPDATED field, and\nsince it was not found to be particularly useful, it has been\ndeprecated.  No replacement object has been defined.")
appnNodeId = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 3), SnaNodeIdentification()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeId.setDescription("This node's Node Identification, which it sends in bytes\n2-5 of XID.")
appnNodeType = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,4,)).subtype(namedValues=NamedValues(("networkNode", 1), ("endNode", 2), ("t21len", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeType.setDescription("Type of APPN node:\n\nnetworkNode(1) - APPN network node\nendNode(2)     - APPN end node\nt21len(4)      - LEN end node\n\nNote:  A branch network node SHALL return endNode(2)\nas the value of this object.  A management application\ncan distinguish between a branch network node and an\nactual end node by retrieving the appnNodeBrNn object.")
appnNodeUpTime = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 5), TimeTicks()).setMaxAccess("readonly").setUnits("hundredths of a second")
if mibBuilder.loadTexts: appnNodeUpTime.setDescription("Amount of time (in hundredths of a second) since the APPN node\nwas last reinitialized.")
appnNodeParallelTg = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeParallelTg.setDescription("Indicates whether this node supports parallel TGs.")
appnNodeAdaptiveBindPacing = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 7), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeAdaptiveBindPacing.setDescription("Indicates whether this node supports adaptive bind pacing for\ndependent LUs.")
appnNodeHprSupport = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,3,4,)).subtype(namedValues=NamedValues(("noHprSupport", 1), ("hprBaseOnly", 2), ("rtpTower", 3), ("controlFlowsOverRtpTower", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeHprSupport.setDescription("Indicates this node's level of support for high-performance\nrouting (HPR):\n   noHprSupport(1)             - no HPR support\n   hprBaseOnly(2)              - HPR base (option set 1400)\n                                 supported\n   rtpTower(3)                 - HPR base and RTP tower\n                                 (option set 1401) supported\n   controlFlowsOverRtpTower(4) - HPR base, RTP tower, and\n                                 control flows over RTP\n                                 (option set 1402) supported\n\nThis object corresponds to cv4580, byte 9, bits 3-4.")
appnNodeMaxSessPerRtpConn = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 9), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeMaxSessPerRtpConn.setDescription("This object represents a configuration parameter indicating\nthe maximum number of sessions that the APPN node is to put on\nany HPR connection.  The value is zero if not applicable.")
appnNodeHprIntRteSetups = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 10), AppnNodeCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeHprIntRteSetups.setDescription("The total number of HPR route setups received for routes\npassing through this node since the node was last\nreinitialized.")
appnNodeHprIntRteRejects = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 11), AppnNodeCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeHprIntRteRejects.setDescription("The number of HPR route setups rejected by this node for\nroutes passing through it since the node was last\nreinitialized.")
appnNodeHprOrgRteSetups = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 12), AppnNodeCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeHprOrgRteSetups.setDescription("The total number of HPR route setups sent for routes\noriginating in this node since the node was last\nreinitialized.")
appnNodeHprOrgRteRejects = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 13), AppnNodeCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeHprOrgRteRejects.setDescription("The number of HPR route setups rejected by other nodes for\nroutes originating in this node since the node was last\nreinitialized.")
appnNodeHprEndRteSetups = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 14), AppnNodeCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeHprEndRteSetups.setDescription("The total number of HPR route setups received for routes\nending in this node since the node was last reinitialized.")
appnNodeHprEndRteRejects = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 15), AppnNodeCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeHprEndRteRejects.setDescription("The number of HPR route setups rejected by this node for\nroutes ending in it since the node was last reinitialized.")
appnNodeCounterDisconTime = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 16), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeCounterDisconTime.setDescription("The value of the sysUpTime object the last time the APPN node\nwas reinitialized.")
appnNodeLsCounterType = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 17), Integer().subtype(subtypeSpec=SingleValueConstraint(3,4,1,2,)).subtype(namedValues=NamedValues(("other", 1), ("noAnr", 2), ("anrForLocalNces", 3), ("allAnr", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeLsCounterType.setDescription("Indicates which ANR traffic, if any, the node includes in the\ncounts returned by the APPN link station counters\nappnLsInXidBytes, appnLsInMsgBytes, appnLsInXidFrames,\nappnLsInMsgFrames, appnLsOutXidBytes, appnLsOutMsgBytes,\nappnLsOutXidFrames, and appnLsOutMsgFrames.  These counters\nare always incremented for ISR traffic.\n\nThe following values are defined:\n\n   other(1)             - the node does something different\n                          from all the options listed below\n   noAnr(2)             - the node does not include any ANR\n                          traffic in these counts\n   anrForLocalNces(3)   - the node includes in these counts\n                          ANR traffic for RTP connections\n                          that terminate in this node, but\n                          not ANR traffic for RTP connections\n                          that pass through this node without\n                          terminating in it\n   allAnr(4)            - the node includes all ANR traffic\n                          in these counts.")
appnNodeBrNn = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 1, 18), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeBrNn.setDescription("Indicates whether this node is currently configured as a\nbranch network node.\n\nNote:  throughout the remainder of this MIB module, branch\nnetwork node is treated as a third node type, parallel to\nnetwork node and end node.  This is not how branch network\nnodes are treated in the base APPN architecture, but it\nincreases clarity to do it here.")
appnNnUniqueInfoAndCaps = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2))
appnNodeNnCentralDirectory = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 1), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeNnCentralDirectory.setDescription("Indicates whether this node supports central directory\nservices.\n\nThis object corresponds to cv4580, byte 8, bit 1.")
appnNodeNnTreeCache = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(2,3,1,)).subtype(namedValues=NamedValues(("noCache", 1), ("cacheNoIncrUpdate", 2), ("cacheWithIncrUpdate", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeNnTreeCache.setDescription("Indicates this node's level of support for caching of route\ntrees.  Three levels are specified:\n\n   noCache(1)             - caching of route trees is not\n                            supported\n   cacheNoIncrUpdate(2)   - caching of route trees is\n                            supported, but without incremental\n                            updates\n   cacheWithIncrUpdate(3) - caching of route trees with\n                            incremental updates is supported")
appnNodeNnRouteAddResist = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeNnRouteAddResist.setDescription("Route addition resistance.\n\nThis administratively assigned value indicates the relative\ndesirability of using this node for intermediate session\ntraffic.  The value, which can be any integer 0-255, is used\nin route computation.  The lower the value, the more\ndesirable the node is for intermediate routing.\n\nThis object corresponds to cv4580, byte 6.")
appnNodeNnIsr = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 4), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeNnIsr.setDescription("Indicates whether the node supports intermediate session\nrouting.\n\nThis object corresponds to cv4580, byte 8, bit 2.")
appnNodeNnFrsn = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeNnFrsn.setDescription("The last flow-reduction sequence number (FRSN) sent by this\nnode in a topology update to an adjacent network node.")
appnNodeNnPeriBorderSup = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeNnPeriBorderSup.setDescription("Indicates whether this node has peripheral border node\nsupport.\n\nThis object corresponds to cv4580, byte 9, bit 0.")
appnNodeNnInterchangeSup = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 7), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeNnInterchangeSup.setDescription("Indicates whether this node has interchange node support.\n\nThis object corresponds to cv4580, byte 9, bit 1.")
appnNodeNnExteBorderSup = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 8), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeNnExteBorderSup.setDescription("Indicates whether this node has extended border node support.\n\nThis object corresponds to cv4580, byte 9, bit 2.")
appnNodeNnSafeStoreFreq = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 32767))).setMaxAccess("readwrite").setUnits("TDUs")
if mibBuilder.loadTexts: appnNodeNnSafeStoreFreq.setDescription("The topology safe store frequency.\n\nIf this number is not zero, then the topology database is saved\neach time the total number of topology database updates (TDUs)\nreceived by this node increases by this number.  A value of\nzero indicates that the topology database is not being saved.")
appnNodeNnRsn = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 10), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeNnRsn.setDescription("Resource sequence number for this node, which it assigns and\ncontrols.\n\nThis object corresponds to the numeric value in cv4580, bytes\n2-5.")
appnNodeNnCongested = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 11), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeNnCongested.setDescription("Indicates whether this node is congested.  Other network nodes\nstop routing traffic to this node while this flag is on.\n\nThis object corresponds to cv4580, byte 7, bit 0.")
appnNodeNnIsrDepleted = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 12), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeNnIsrDepleted.setDescription("Indicate whether intermediated session routing resources are\ndepleted.  Other network nodes stop routing traffic through\nthis node while this flag is on.\n\nThis object corresponds to cv4580, byte 7, bit 1.")
appnNodeNnQuiescing = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 13), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeNnQuiescing.setDescription("Indicates whether the node is quiescing.\n\nThis object corresponds to cv4580, byte 7, bit 5.")
appnNodeNnGateway = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 2, 14), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeNnGateway.setDescription("Indicates whether the node has gateway services support.\n\nThis object corresponds to cv4580, byte 8, bit 0.")
appnEnUniqueCaps = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 3))
appnNodeEnModeCosMap = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 3, 1), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeEnModeCosMap.setDescription("Indicates whether this end node supports mode name to COS name\nmapping.")
appnNodeEnNnServer = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 3, 2), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(3,17),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeEnNnServer.setDescription("The fully qualified name of the current NN server for this end\nnode.  An NN server is identified using the format specified in\nthe SnaControlPointName textual convention.  The value is a\nzero-length string when there is no active NN server.\n\nA branch network node shall also implement this object.")
appnNodeEnLuSearch = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 3, 3), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNodeEnLuSearch.setDescription("Indicates whether the node is to be searched for LUs as part\nof a network broadcast search.\n\nA branch network node shall also implement this object.")
appnPortInformation = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4))
appnPortTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1))
if mibBuilder.loadTexts: appnPortTable.setDescription("The Port table describes the configuration and current status\nof the ports used by APPN.  When it is known to the APPN\ncomponent, an OBJECT IDENTIFIER pointing to additional\ninformation related to the port is included.  This may, but\nneed not, be a RowPointer to an ifTable entry for a DLC\ninterface immediately 'below' the port.")
appnPortEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1)).setIndexNames((0, "APPN-MIB", "appnPortName"))
if mibBuilder.loadTexts: appnPortEntry.setDescription("The port name is used as the index to this table.")
appnPortName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 1), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 10))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnPortName.setDescription("Administratively assigned name for this APPN port.")
appnPortCommand = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,4,2,)).subtype(namedValues=NamedValues(("deactivate", 1), ("activate", 2), ("recycle", 3), ("ready", 4), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: appnPortCommand.setDescription("Object by which a Management Station can activate, deactivate,\nor recycle (i.e., cause to be deactivated and then immediately\nactivated) a port, by setting the value to activate(1),\ndeactivate(2), or recycle(3), respectively.  The value ready(4)\nis returned on GET operations until a SET has been processed;\nafter that the value received on the most recent SET is\nreturned.")
appnPortOperState = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,4,)).subtype(namedValues=NamedValues(("inactive", 1), ("pendactive", 2), ("active", 3), ("pendinact", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnPortOperState.setDescription("Indicates the current state of this port:\n\ninactive(1)   - port is inactive\npendactive(2) - port is pending active\nactive(3)     - port is active\npendinact(4)  - port is pending inactive")
appnPortDlcType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 4), IANAifType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnPortDlcType.setDescription("The type of DLC interface, distinguished according to the\nprotocol immediately 'below' this layer.")
appnPortPortType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(3,2,1,)).subtype(namedValues=NamedValues(("leased", 1), ("switched", 2), ("sharedAccessFacilities", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnPortPortType.setDescription("Identifies the type of line used by this port:\n\nleased(1)                 - leased line\nswitched(2)               - switched line\nsharedAccessFacilities(3) - shared access facility, such\n                            as a LAN.")
appnPortSIMRIM = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnPortSIMRIM.setDescription("Indicates whether Set Initialization Mode (SIM) and Receive\nInitialization Mode (RIM) are supported for this port.")
appnPortLsRole = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 7), Integer().subtype(subtypeSpec=SingleValueConstraint(4,2,1,3,)).subtype(namedValues=NamedValues(("primary", 1), ("secondary", 2), ("negotiable", 3), ("abm", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnPortLsRole.setDescription("Initial role for link stations activated through this port.\nThe values map to the following settings in the initial XID,\nwhere 'ABM' indicates asynchronous balanced mode and 'NRM'\nindicated normal response mode:\n\n    primary(1):     ABM support = 0     ( = NRM)\n                    role = 01           ( = primary)\n    secondary(2):   ABM support = 0     ( = NRM)\n                    role = 00           ( = secondary)\n    negotiable(3):  ABM support = 0     ( = NRM)\n                    role = 11           ( = negotiable)\n    abm(4):         ABM support = 1     ( = ABM)\n                    role = 11           ( = negotiable)")
appnPortNegotLs = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 8), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnPortNegotLs.setDescription("Indicates whether the node supports negotiable link stations\nfor this port.")
appnPortDynamicLinkSupport = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 9), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnPortDynamicLinkSupport.setDescription("Indicates whether this node allows call-in on this port from\nnodes not defined locally.")
appnPortMaxRcvBtuSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(99, 32767))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnPortMaxRcvBtuSize.setDescription("Maximum Basic Transmission Unit (BTU) size that a link station\non this port can receive.\n\nThis object corresponds to bytes 21-22 of XID3.")
appnPortMaxIframeWindow = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 11), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnPortMaxIframeWindow.setDescription("Maximum number of I-frames that can be received by the XID\nsender before an acknowledgement is received.")
appnPortDefLsGoodXids = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 12), AppnPortCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnPortDefLsGoodXids.setDescription("The total number of successful XID exchanges that have\noccurred on all defined link stations on this port since the\nlast time this port was started.")
appnPortDefLsBadXids = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 13), AppnPortCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnPortDefLsBadXids.setDescription("The total number of unsuccessful XID exchanges that have\noccurred on all defined link stations on this port since the\nlast time this port was started.")
appnPortDynLsGoodXids = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 14), AppnPortCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnPortDynLsGoodXids.setDescription("The total number of successful XID exchanges that have\noccurred on all dynamic link stations on this port since the\nlast time this port was started.")
appnPortDynLsBadXids = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 15), AppnPortCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnPortDynLsBadXids.setDescription("The total number of unsuccessful XID exchanges that have\noccurred on all dynamic link stations on this port since the\nlast time this port was started.")
appnPortSpecific = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 16), RowPointer()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnPortSpecific.setDescription("Identifies the object, e.g., one in a DLC-specific MIB, that\ncan provide additional information related to this port.\n\nIf the agent is unable to identify such an object, the value\n0.0 is returned.")
appnPortDlcLocalAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 17), DisplayableDlcAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnPortDlcLocalAddr.setDescription("Local DLC address of this port.")
appnPortCounterDisconTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 4, 1, 1, 18), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnPortCounterDisconTime.setDescription("The value of the sysUpTime object the last time the port was\nstarted.")
appnLinkStationInformation = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5))
appnLsTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1))
if mibBuilder.loadTexts: appnLsTable.setDescription("This table contains detailed information about the link\nstation configuration and its current status.")
appnLsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1)).setIndexNames((0, "APPN-MIB", "appnLsName"))
if mibBuilder.loadTexts: appnLsEntry.setDescription("This table is indexed by the link station name.")
appnLsName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 1), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 10))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnLsName.setDescription("Administratively assigned name for the link station.\nThe name can be from one to ten characters.")
appnLsCommand = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,4,2,)).subtype(namedValues=NamedValues(("deactivate", 1), ("activate", 2), ("recycle", 3), ("ready", 4), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: appnLsCommand.setDescription("Object by which a Management Station can activate, deactivate,\nor recycle (i.e., cause to be deactivated and then immediately\nreactivated) a link station, by setting the value to\nactivate(1), deactivate(2), or recycle(3), respectively.  The\nvalue ready(4) is returned on GET operations until a SET has\nbeen processed; after that the value received on the most\nrecent SET is returned.")
appnLsOperState = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(10,8,1,5,7,4,2,6,3,9,11,)).subtype(namedValues=NamedValues(("inactive", 1), ("sentDiscImmed", 10), ("otherPendingInact", 11), ("sentConnectOut", 2), ("pendXidExch", 3), ("sendActAs", 4), ("sendSetMode", 5), ("otherPendingActive", 6), ("active", 7), ("sentDeactAsOrd", 8), ("sentDiscOrd", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsOperState.setDescription("State of this link station.  The comments map these more\ngranular states to the 'traditional' four states for SNA\nresources.  Values (2) through (5) represent the normal\nprogression of states when a link station is being activated.\nValue (6) represents some other state of a link station in\nthe process of being activated.  Values (8) through (10)\nrepresent different ways a link station can be deactivated.\nValue (11) represents some other state of a link station in\nthe process of being deactivated.")
appnLsPortName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 4), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 10))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsPortName.setDescription("Administratively assigned name for the port associated with\nthis link station.  The name can be from one to ten\ncharacters.")
appnLsDlcType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 5), IANAifType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsDlcType.setDescription("The type of DLC interface, distinguished according to the\nprotocol immediately 'below' this layer.")
appnLsDynamic = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsDynamic.setDescription("Identifies whether this is a dynamic link station.  Dynamic\nlink stations are created when links that have not been locally\ndefined are established by adjacent nodes.")
appnLsAdjCpName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 7), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(3,17),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsAdjCpName.setDescription("Fully qualified name of the adjacent node for this link\nstation.  An adjacent node is identified using the format\nspecified in the SnaControlPointName textual convention.\n\nThe value of this object is determined as follows:\n\n   1. If the adjacent node's name was received on XID, it\n      is returned.\n\n   2. If the adjacent node's name was not received on XID,\n      but a locally-defined value is available, it is\n      returned.\n\n   3. Otherwise a string of length 0 is returned, indicating\n      that no name is known for the adjacent node.")
appnLsAdjNodeType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(2,255,1,4,)).subtype(namedValues=NamedValues(("networkNode", 1), ("endNode", 2), ("unknown", 255), ("t21len", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsAdjNodeType.setDescription("Node type of the adjacent node on this link:\n\nnetworkNode(1) - APPN network node\nendNode(2)     - APPN end node\nt21len(4)      - LEN end node\nunknown(255)   - the agent does not know the node type\n                 of the adjacent node")
appnLsTgNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 256))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsTgNum.setDescription("Number associated with the TG to this link station, with a\nrange from 0 to 256.  A value of 256 indicates that the TG\nnumber has not been negotiated and is unknown at this time.")
appnLsLimResource = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 10), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsLimResource.setDescription("Indicates whether the link station is a limited resource.  A\nlink station that is a limited resource is deactivated when it\nis no longer in use.")
appnLsActOnDemand = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 11), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsActOnDemand.setDescription("Indicates whether the link station is activatable on demand.\n\nSuch a link station is reported in the topology as active\nregardless of its actual state, so that it can be considered in\nroute calculations.  If the link station is inactive and is\nchosen for a route, it will be activated at that time.")
appnLsMigration = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 12), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsMigration.setDescription("Indicates whether this link station will be used for\nconnections to down-level or migration partners.\n\nIn general, migration nodes do not append their CP names on\nXID3.  Such nodes:  (1) will not support parallel TGs, (2)\nshould be sent an ACTIVATE PHYSICAL UNIT (ACTPU), provided that\nthe partner supports ACTPUs, and (3) should not be sent\nsegmented BINDs.  However, if this node receives an XID3 with\nan appended CP name, then the partner node will not be treated\nas a migration node.\n\n In the case of DYNAMIC TGs this object should be set to 'no'.")
appnLsPartnerNodeId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 13), SnaNodeIdentification()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsPartnerNodeId.setDescription("The partner's Node Identification, from bytes 2-5 of the XID\nreceived from the partner.  If this value is not available,\nthen the characters '00000000' are returned.")
appnLsCpCpSessionSupport = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 14), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsCpCpSessionSupport.setDescription("Indicates whether CP-CP sessions are supported by this\nlink station.  For a dynamic link, this object represents\nthe default ('Admin') value.")
appnLsMaxSendBtuSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(99, 32767))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsMaxSendBtuSize.setDescription("Numeric value between 99 and 32767 inclusive indicating the\nmaximum number of bytes in a Basic Transmission Unit (BTU) sent\non this link.\n\nWhen the link state (returned by the appnLsOperState object) is\ninactive or pending active, the value configured at this node\nis returned.  When the link state is active, the value that was\nnegotiated for it is returned.  This negotiated value is the\nsmaller of the value configured at this node and the partner's\nmaximum receive BTU length, received in XID.")
appnLsInXidBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 16), AppnLinkStationCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsInXidBytes.setDescription("Number of XID bytes received.  All of the bytes in the SNA\nbasic transmission unit (BTU), i.e., all of the bytes in the\nDLC XID Information Field, are counted.")
appnLsInMsgBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 17), AppnLinkStationCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsInMsgBytes.setDescription("Number of message (I-frame) bytes received.  All of the bytes\nin the SNA basic transmission unit (BTU), including the\ntransmission header (TH), are counted.")
appnLsInXidFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 18), AppnLinkStationCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsInXidFrames.setDescription("Number of XID frames received.")
appnLsInMsgFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 19), AppnLinkStationCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsInMsgFrames.setDescription("Number of message (I-frame) frames received.")
appnLsOutXidBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 20), AppnLinkStationCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsOutXidBytes.setDescription("Number of XID bytes sent.  All of the bytes in the SNA basic\ntransmission unit (BTU), i.e., all of the bytes in the DLC XID\nInformation Field, are counted.")
appnLsOutMsgBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 21), AppnLinkStationCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsOutMsgBytes.setDescription("Number of message (I-frame) bytes sent.  All of the bytes\nin the SNA basic transmission unit (BTU), including the\ntransmission header (TH), are counted.")
appnLsOutXidFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 22), AppnLinkStationCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsOutXidFrames.setDescription("Number of XID frames sent.")
appnLsOutMsgFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 23), AppnLinkStationCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsOutMsgFrames.setDescription("Number of message (I-frame) frames sent.")
appnLsEchoRsps = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 24), AppnLinkStationCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsEchoRsps.setDescription("Number of echo responses returned from adjacent link station.\nA response should be returned for each test frame sent by this\nnode.  Test frames are sent to adjacent nodes periodically to\nverify connectivity and to measure the actual round trip time,\nthat is, the time interval from when the test frame is sent\nuntil when the response is received.")
appnLsCurrentDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 25), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsCurrentDelay.setDescription("The time that it took for the last test signal to be sent and\nreturned from this link station to the adjacent link station.\nThis time is represented in milliseconds.")
appnLsMaxDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 26), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsMaxDelay.setDescription("The longest time it took for a test signal to be sent and\nreturned from this link station to the adjacent link station.\nThis time is represented in milliseconds .\n\nThe value 0 is returned if no test signal has been sent and\nreturned.")
appnLsMinDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 27), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsMinDelay.setDescription("The shortest time it took for a test signal to be sent and\nreturned from this link station to the adjacent link station.\nThis time is represented in milliseconds.\n\nThe value 0 is returned if no test signal has been sent and\nreturned.")
appnLsMaxDelayTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 28), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsMaxDelayTime.setDescription("The time when the longest delay occurred.  This time can be\nused to identify when this high water mark occurred in relation\nto other events in the APPN node, for example, the time at\nwhich an APPC session was either terminated or failed to be\nestablished.  This latter time is available in the\nappcHistSessTime object in the APPC MIB.\n\nThe value 00000000 is returned if no test signal has been sent\nand returned.")
appnLsGoodXids = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 29), AppnLinkStationCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsGoodXids.setDescription("The total number of successful XID exchanges that have\noccurred on this link station since the time it was started.")
appnLsBadXids = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 30), AppnLinkStationCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsBadXids.setDescription("The total number of unsuccessful XID exchanges that have\noccurred on this link station since the time it was started.")
appnLsSpecific = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 31), RowPointer()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsSpecific.setDescription("Identifies the object, e.g., one in a DLC-specific MIB, that\ncan provide additional information related to this link\nstation.\n\nIf the agent is unable to identify such an object, the value\n0.0 is returned.")
appnLsActiveTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 32), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsActiveTime.setDescription("The cumulative amount of time since the node was last\nreinitialized, measured in hundredths of a second, that this\nlink station has been in the active state.  A zero value\nindicates that the link station has never been active since\nthe node was last reinitialized.")
appnLsCurrentStateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 33), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsCurrentStateTime.setDescription("The amount of time, measured in hundredths of a second, that\nthe link station has been in its current state.")
appnLsHprSup = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 34), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,3,4,)).subtype(namedValues=NamedValues(("noHprSupport", 1), ("hprBaseOnly", 2), ("rtpTower", 3), ("controlFlowsOverRtpTower", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsHprSup.setDescription("Indicates the level of high performance routing (HPR) support\nover this link:\n\n   noHprSupport(1)             - no HPR support\n   hprBaseOnly(2)              - HPR base (option set 1400)\n                                 supported\n   rtpTower(3)                 - HPR base and RTP tower\n                                 (option set 1401) supported\n   controlFlowsOverRtpTower(4) - HPR base, RTP tower, and\n                                 control flows over RTP\n                                 (option set 1402) supported\n\nIf the link is not active, the defined value is returned.")
appnLsErrRecoSup = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 35), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsErrRecoSup.setDescription("Indicates whether the link station is supporting\nHPR link-level error recovery.")
appnLsForAnrLabel = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 36), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsForAnrLabel.setDescription("The forward Automatic Network Routing (ANR) label for this\nlink station.  If the link does not support HPR or the value is\nunknown, a zero-length string is returned.")
appnLsRevAnrLabel = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 37), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsRevAnrLabel.setDescription("The reverse Automatic Network Routing (ANR) label for this\nlink station.  If the link does not support HPR or the value is\nunknown, a zero-length string is returned.")
appnLsCpCpNceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 38), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsCpCpNceId.setDescription("The network connection endpoint identifier (NCE ID) for CP-CP\nsessions if this node supports the HPR transport tower, a\nzero-length string if the value is unknown or not meaningful\nfor this node.")
appnLsRouteNceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 39), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsRouteNceId.setDescription("The network connection endpoint identifier (NCE ID) for Route\nSetup if this node supports the HPR transport tower, a zero-\nlength string if the value is unknown or not meaningful for\nthis node.")
appnLsBfNceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 40), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsBfNceId.setDescription("The network connection endpoint identifier (NCE ID) for the\nAPPN/HPR boundary function if this node supports the HPR\ntransport tower, a zero-length string if the value is unknown\nor not meaningful for this node.")
appnLsLocalAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 41), DisplayableDlcAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsLocalAddr.setDescription("Local address of this link station.")
appnLsRemoteAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 42), DisplayableDlcAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsRemoteAddr.setDescription("Address of the remote link station on this link.")
appnLsRemoteLsName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 43), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 10))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsRemoteLsName.setDescription("Remote link station discovered from the XID exchange.\nThe name can be from one to ten characters.  A zero-length\nstring indicates that the value is not known.")
appnLsCounterDisconTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 44), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsCounterDisconTime.setDescription("The value of the sysUpTime object the last time the link\nstation was started.")
appnLsMltgMember = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 1, 1, 45), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsMltgMember.setDescription("Indicates whether the link is a member of a multi-link TG.  If\nthe link's TG has been brought up as a multi-link TG, then the\nlink is reported as a member of a multi-link TG, even if it is\ncurrently the only active link in the TG.")
appnLsStatusTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2))
if mibBuilder.loadTexts: appnLsStatusTable.setDescription("This table contains information related to exceptional and\npotentially exceptional conditions that occurred during the\nactivation, XID exchange, and termination of a connection.  No\nentries are created when these activities proceed normally.\n\nIt is an implementation option when entries are removed from\nthis table.")
appnLsStatusEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1)).setIndexNames((0, "APPN-MIB", "appnLsStatusIndex"))
if mibBuilder.loadTexts: appnLsStatusEntry.setDescription("This table is indexed by the LsStatusIndex, which is an\ninteger that is continuously updated until it eventually\nwraps.")
appnLsStatusIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnLsStatusIndex.setDescription("Table index.  The value of the index begins at zero\nand is incremented up to a maximum value of 2**31-1\n(2,147,483,647) before wrapping.")
appnLsStatusTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 2), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsStatusTime.setDescription("Time when the exception condition occurred.  This time can be\nused to identify when this event occurred in relation to other\nevents in the APPN node, for example, the time at which an APPC\nsession was either terminated or failed to be established.\nThis latter time is available in the appcHistSessTime object in\nthe APPC MIB.")
appnLsStatusLsName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 10))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsStatusLsName.setDescription("Administratively assigned name for the link station\nexperiencing the condition.")
appnLsStatusCpName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 4), DisplayString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(3,17),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsStatusCpName.setDescription("Fully qualified name of the adjacent node for this link\nstation.  An adjacent node is identified using the format\nspecified in the SnaControlPointName textual convention.\n\nThe value of this object is determined as follows:\n\n   1. If the adjacent node's name was received on XID, it\n      is returned.\n\n   2. If the adjacent node's name was not received on XID,\n      but a locally-defined value is available, it is\n      returned.\n\n   3. Otherwise a string of length 0 is returned, indicating\n      that no name is known for the adjacent node.")
appnLsStatusPartnerId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 5), SnaNodeIdentification()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsStatusPartnerId.setDescription("The partner's Node Identification, from bytes 2-5 of the XID\nreceived from the partner.  If this value is not available,\nthen the characters '00000000' are returned.")
appnLsStatusTgNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 256))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsStatusTgNum.setDescription("Number associated with the TG to this link station, with a\nrange from 0 to 256.  A value of 256 indicates that the TG\nnumber was unknown at the time of the failure.")
appnLsStatusGeneralSense = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 7), SnaSenseData()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsStatusGeneralSense.setDescription("The error sense data associated with the start sequence of\nactivation of a link up to the beginning of the XID sequence.\n\nThis is the sense data that came from Configuration Services\nwhenever the link did not activate or when it went inactive.")
appnLsStatusRetry = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 8), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsStatusRetry.setDescription("Indicates whether the node will retry the start request to\nactivate the link.")
appnLsStatusEndSense = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 9), SnaSenseData()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsStatusEndSense.setDescription("The sense data associated with the termination of the link\nconnection to adjacent node.\n\nThis is the sense data that came from the DLC layer.")
appnLsStatusXidLocalSense = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 10), SnaSenseData()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsStatusXidLocalSense.setDescription("The sense data associated with the rejection of the XID.\n\nThis is the sense data that came from the local node (this\nnode) when it built the XID Negotiation Error control vector\n(cv22) to send to the remote node.")
appnLsStatusXidRemoteSense = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 11), SnaSenseData()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsStatusXidRemoteSense.setDescription("The sense data the adjacent node returned to this node\nindicating the reason the XID was rejected.\n\nThis is the sense data that came from the remote node in the\nXID Negotiation Error control vector (cv22) it sent to the\nlocal node (this node).")
appnLsStatusXidByteInError = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 12), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65536))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsStatusXidByteInError.setDescription("This object identifies the actual byte in the XID that caused\nthe error.  The value 65536 indicates that the object has no\nmeaning.\n\nFor values in the range 0-65535, this object corresponds to\nbytes 2-3 of the XID Negotiation (X'22') control vector.")
appnLsStatusXidBitInError = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 13), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsStatusXidBitInError.setDescription("This object identifies the actual bit in error (0 through 7)\nwithin the errored byte of the XID.  The value 8 indicates that\nthis object has no meaning.\n\nFor values in the range 0-7, this object corresponds to byte 4\nof the XID Negotiation (X'22') control vector.")
appnLsStatusDlcType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 14), IANAifType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsStatusDlcType.setDescription("The type of DLC interface, distinguished according to the\nprotocol immediately 'below' this layer.")
appnLsStatusLocalAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 15), DisplayableDlcAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsStatusLocalAddr.setDescription("Local address of this link station.")
appnLsStatusRemoteAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 5, 2, 1, 16), DisplayableDlcAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLsStatusRemoteAddr.setDescription("Address of the remote link station on this link.")
appnVrnInfo = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 6))
appnVrnTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 6, 1))
if mibBuilder.loadTexts: appnVrnTable.setDescription("This table relates a virtual routing node to an APPN port.")
appnVrnEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 6, 1, 1)).setIndexNames((0, "APPN-MIB", "appnVrnName"), (0, "APPN-MIB", "appnVrnTgNum"), (0, "APPN-MIB", "appnVrnPortName"))
if mibBuilder.loadTexts: appnVrnEntry.setDescription("This table is indexed by the virtual routing node name, TG\nnumber, and port name.  There will be a matching entry in the\nappnLocalTgTable to represent status and characteristics of the\nTG representing each virtual routing node definition.")
appnVrnName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 6, 1, 1, 1), SnaControlPointName()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnVrnName.setDescription("Administratively assigned name of the virtual routing node.\nThis is a fully qualified name, and matches the appnLocalTgDest\nname in the appnLocalTgTable.")
appnVrnTgNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 6, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnVrnTgNum.setDescription("Number associated with the transmission group representing\nthis virtual routing node definition.")
appnVrnPortName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 1, 6, 1, 1, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 10))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnVrnPortName.setDescription("The name of the port this virtual routing node definition is\ndefined to.")
appnNn = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 2))
appnNnTopo = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 1))
appnNnTopoMaxNodes = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 1, 1), Gauge32()).setMaxAccess("readonly").setUnits("node entries")
if mibBuilder.loadTexts: appnNnTopoMaxNodes.setDescription("Maximum number of node entries allowed in the APPN topology\ndatabase.  It is an implementation choice whether to count only\nnetwork-node entries, or to count all node entries.  If the\nnumber of node entries exceeds this value, APPN will issue an\nAlert and the node can no longer participate as a network node.\nThe value 0 indicates that the local node has no defined limit,\nand the number of node entries is bounded only by memory.")
appnNnTopoCurNumNodes = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 1, 2), Gauge32()).setMaxAccess("readonly").setUnits("node entries")
if mibBuilder.loadTexts: appnNnTopoCurNumNodes.setDescription("Current number of node entries in this node's topology\ndatabase.  It is an implementation choice whether to count only\nnetwork-node entries, or to count all node entries, but an\nimplementation must make the same choice here that it makes for\nthe appnNnTopoMaxNodes object.  If this value exceeds the\nmaximum number of nodes allowed (appnNnTopoMaxNodes, if that\nfield in not 0), APPN Alert CPDB002 is issued.")
appnNnTopoNodePurges = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 1, 3), AppnNodeCounter()).setMaxAccess("readonly").setUnits("node entries")
if mibBuilder.loadTexts: appnNnTopoNodePurges.setDescription("Total number of topology node records purged from this node's\ntopology database since the node was last reinitialized.")
appnNnTopoTgPurges = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 1, 4), AppnNodeCounter()).setMaxAccess("readonly").setUnits("TG entries")
if mibBuilder.loadTexts: appnNnTopoTgPurges.setDescription("Total number of topology TG records purged from this node's\ntopology database since the node was last reinitialized.")
appnNnTopoTotalTduWars = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 1, 5), AppnNodeCounter()).setMaxAccess("readonly").setUnits("TDU wars")
if mibBuilder.loadTexts: appnNnTopoTotalTduWars.setDescription("Number of TDU wars detected by this node since its last\ninitialization.")
appnNnTopology = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2))
appnNnTopologyFRTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3))
if mibBuilder.loadTexts: appnNnTopologyFRTable.setDescription("Portion of the APPN topology database that describes all of\nthe APPN network nodes and virtual routing nodes known to this\nnode.")
appnNnTopologyFREntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1)).setIndexNames((0, "APPN-MIB", "appnNnNodeFRFrsn"), (0, "APPN-MIB", "appnNnNodeFRName"))
if mibBuilder.loadTexts: appnNnTopologyFREntry.setDescription("The FRSN and the fully qualified node name are used to index\nthis table.")
appnNnNodeFRFrsn = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 1), Unsigned32()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnNnNodeFRFrsn.setDescription("Flow reduction sequence numbers (FRSNs) are associated with\nTopology Database Updates (TDUs) and are unique only within\neach APPN network node.  A TDU can be associated with multiple\nAPPN resources.  This FRSN indicates the last relative time\nthis resource was updated at the agent node.")
appnNnNodeFRName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 2), SnaControlPointName()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnNnNodeFRName.setDescription("Administratively assigned network name that is locally defined\nat each network node.")
appnNnNodeFREntryTimeLeft = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 3), AppnTopologyEntryTimeLeft()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnNodeFREntryTimeLeft.setDescription("Number of days before deletion of this network node entry.")
appnNnNodeFRType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,)).subtype(namedValues=NamedValues(("networkNode", 1), ("virtualRoutingNode", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnNodeFRType.setDescription("Type of APPN node.")
appnNnNodeFRRsn = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnNodeFRRsn.setDescription("Resource sequence number, which is assigned and controlled by\nthe network node that owns this resource.  An odd number\nindicates that information about the resource is inconsistent.\n\nThis object corresponds to the numeric value in cv4580, bytes\n2-5.")
appnNnNodeFRRouteAddResist = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnNodeFRRouteAddResist.setDescription("Route addition resistance.\n\nThis administratively assigned value indicates the relative\ndesirability of using this node for intermediate session\ntraffic.  The value, which can be any integer 0-255, is used\nin route computation.  The lower the value, the more\ndesirable the node is for intermediate routing.\n\nThis object corresponds to cv4580, byte 6.")
appnNnNodeFRCongested = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 7), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnNodeFRCongested.setDescription("Indicates whether this node is congested.  This node is not be\nincluded in route selection by other nodes when this congestion\nexists.\n\nThis object corresponds to cv4580, byte 7, bit 0.")
appnNnNodeFRIsrDepleted = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 8), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnNodeFRIsrDepleted.setDescription("Indicates whether intermediate session routing resources are\ndepleted.  This node is not included in intermediate route\nselection by other nodes when resources are depleted.\n\nThis object corresponds to cv4580, byte 7, bit 1.")
appnNnNodeFRQuiescing = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 9), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnNodeFRQuiescing.setDescription("Indicates whether the node is quiescing.  This node is not\nincluded in route selection by other nodes when the node is\nquiescing.\n\nThis object corresponds to cv4580, byte 7, bit 5.")
appnNnNodeFRGateway = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 10), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnNodeFRGateway.setDescription("Indicates whether the node provide gateway services.\n\nThis object corresponds to cv4580, byte 8, bit 0.")
appnNnNodeFRCentralDirectory = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 11), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnNodeFRCentralDirectory.setDescription("Indicates whether the node supports central directory\nservices.\n\nThis object corresponds to cv4580, byte 8, bit 1.")
appnNnNodeFRIsr = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 12), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnNodeFRIsr.setDescription("Indicates whether the node supports intermediate session\nrouting (ISR).\n\nThis object corresponds to cv4580, byte 8, bit 2.")
appnNnNodeFRGarbageCollect = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 13), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnNodeFRGarbageCollect.setDescription("Indicates whether the node has been marked for garbage\ncollection (deletion from the topology database) upon the next\ngarbage collection cycle.\n\nThis object corresponds to cv4580, byte 7, bit 3.")
appnNnNodeFRHprSupport = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 14), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,3,4,)).subtype(namedValues=NamedValues(("noHprSupport", 1), ("hprBaseOnly", 2), ("rtpTower", 3), ("controlFlowsOverRtpTower", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnNodeFRHprSupport.setDescription("Indicates the node's level of support for high-performance\nrouting (HPR):\n\n   noHprSupport(1)             - no HPR support\n   hprBaseOnly(2)              - HPR base (option set 1400)\n                                 supported\n   rtpTower(3)                 - HPR base and RTP tower\n                                 (option set 1401) supported\n   controlFlowsOverRtpTower(4) - HPR base, RTP tower, and\n                                 control flows over RTP\n                                 (option set 1402) supported\n\nThis object corresponds to cv4580, byte 9, bits 3-4.")
appnNnNodeFRPeriBorderSup = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 15), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnNodeFRPeriBorderSup.setDescription("Indicates whether this node has peripheral border node\nsupport.\n\nThis object corresponds to cv4580, byte 9, bit 0.")
appnNnNodeFRInterchangeSup = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 16), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnNodeFRInterchangeSup.setDescription("Indicates whether this node has interchange node support.\n\nThis object corresponds to cv4580, byte 9, bit 1.")
appnNnNodeFRExteBorderSup = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 17), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnNodeFRExteBorderSup.setDescription("Indicates whether this node has extended border node\nsupport.\n\nThis object corresponds to cv4580, byte 9, bit 2.")
appnNnNodeFRBranchAwareness = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 3, 1, 18), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnNodeFRBranchAwareness.setDescription("Indicates whether this node supports branch awareness.\n\nThis object corresponds to cv4580, byte 8, bit 4.")
appnNnTgTopologyFRTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4))
if mibBuilder.loadTexts: appnNnTgTopologyFRTable.setDescription("Portion of the APPN topology database that describes all of\nthe APPN transmissions groups between nodes in the database.")
appnNnTgTopologyFREntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1)).setIndexNames((0, "APPN-MIB", "appnNnTgFRFrsn"), (0, "APPN-MIB", "appnNnTgFROwner"), (0, "APPN-MIB", "appnNnTgFRDest"), (0, "APPN-MIB", "appnNnTgFRNum"))
if mibBuilder.loadTexts: appnNnTgTopologyFREntry.setDescription("This table is indexed by four columns:  FRSN, TG owner fully\nqualified node name, TG destination fully qualified node name,\nand TG number.")
appnNnTgFRFrsn = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 1), Unsigned32()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnNnTgFRFrsn.setDescription("Flow reduction sequence numbers (FRSNs) are associated with\nTopology Database Updates (TDUs) and are unique only within\neach APPN network node.  A TDU can be associated with multiple\nAPPN resources.  This FRSN indicates the last time this\nresource was updated at this node.")
appnNnTgFROwner = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 2), SnaControlPointName()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnNnTgFROwner.setDescription("Administratively assigned name for the originating node for\nthis TG.  This is the same name specified in the node table.")
appnNnTgFRDest = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 3), SnaControlPointName()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnNnTgFRDest.setDescription("Administratively assigned fully qualified network name for the\ndestination node for this TG.")
appnNnTgFRNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnNnTgFRNum.setDescription("Number associated with this transmission group.  Range is\n0-255.")
appnNnTgFREntryTimeLeft = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 5), AppnTopologyEntryTimeLeft()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnTgFREntryTimeLeft.setDescription("Number of days before deletion of this network node TG entry\nif it is not operational or has an odd (inconsistent) RSN.")
appnNnTgFRDestVirtual = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnTgFRDestVirtual.setDescription("Indicates whether the destination node is a virtual routing\nnode.")
appnNnTgFRDlcData = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 7), AppnTgDlcData()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnTgFRDlcData.setDescription("DLC-specific data related to a link connection network.")
appnNnTgFRRsn = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnTgFRRsn.setDescription("Current owning node's resource sequence number for this\nresource.  An odd number indicates that information about the\nresource is inconsistent.\n\nThis object corresponds to the numeric value in cv47, bytes\n2-5")
appnNnTgFROperational = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 9), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnTgFROperational.setDescription("Indicates whether the transmission group is operational.\n\nThis object corresponds to cv47, byte 6, bit 0.")
appnNnTgFRQuiescing = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 10), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnTgFRQuiescing.setDescription("Indicates whether the transmission group is quiescing.\n\nIf the TG owner is either an extended border node or a\nbranch-aware network node (indicated, respectively, by\nthe appnNnNodeFRExteBorderSup and appnNnNodeFRBranchAwareness\nobjects in the corresponding appnNnTopologyFREntry), then\nthis indicator is artificially set to TRUE in the APPN\ntopology database, to remove the TG from other nodes'\nroute calculations.  A management application can\ndetermine whether the TG is actually quiescing by\nexamining its appnLocalTgQuiescing object at the TG owner.\n\nThis object corresponds to cv47, byte 6, bit 2.")
appnNnTgFRCpCpSession = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 11), Integer().subtype(subtypeSpec=SingleValueConstraint(3,2,1,4,)).subtype(namedValues=NamedValues(("supportedUnknownStatus", 1), ("supportedActive", 2), ("notSupported", 3), ("supportedNotActive", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnTgFRCpCpSession.setDescription("Indicates whether CP-CP sessions are supported on this TG, and\nwhether the TG owner's contention-winner session is active on\nthis TG.  Some nodes in the network are not able to\ndifferentiate support and status of CP-CP sessions, and thus\nmay report the 'supportedUnknownStatus' value.\n\nThis object corresponds to cv47, byte 6, bits 3-4.")
appnNnTgFREffCap = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 12), AppnTgEffectiveCapacity()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnTgFREffCap.setDescription("Effective capacity for this TG.")
appnNnTgFRConnCost = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 13), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnTgFRConnCost.setDescription("Cost per connect time.\n\nThis is an administratively assigned value representing the\nrelative cost per unit of time to use this TG.  Range is from\n0, which means no cost, to 255, which indicates maximum cost.\n\nThis object corresponds to cv47, byte 13.")
appnNnTgFRByteCost = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 14), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnTgFRByteCost.setDescription("Cost per byte transmitted.\n\nThis is an administratively assigned value representing the\nrelative cost of transmitting a byte over this TG.  Range is\nfrom 0, which means no cost, to 255, which indicates maximum\ncost.\n\nThis object corresponds to cv47, byte 14.")
appnNnTgFRSecurity = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 15), AppnTgSecurity()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnTgFRSecurity.setDescription("Administratively assigned security level of this TG.\n\nThis object corresponds to cv47, byte 16.")
appnNnTgFRDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 16), AppnTgDelay()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnTgFRDelay.setDescription("Administratively assigned delay associated with this TG.\n\nThis object corresponds to cv47, byte 17.")
appnNnTgFRUsr1 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 17), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnTgFRUsr1.setDescription("First user-defined TG characteristic for this TG.  This is\nan administratively assigned value associated with the TG.\n\nThis object corresponds to cv47, byte 19.")
appnNnTgFRUsr2 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 18), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnTgFRUsr2.setDescription("Second user-defined TG characteristic for this TG.  This is\nan administratively assigned value associated with the TG.\n\nThis object corresponds to cv47, byte 20.")
appnNnTgFRUsr3 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 19), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnTgFRUsr3.setDescription("Third user-defined TG characteristic for this TG.  This is\nan administratively assigned value associated with the TG.\n\nThis object corresponds to cv47, byte 21.")
appnNnTgFRGarbageCollect = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 20), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnTgFRGarbageCollect.setDescription("Indicates whether the TG has been marked for garbage\ncollection (deletion from the topology database) upon the next\ngarbage collection cycle.\n\nThis object corresponds to cv47, byte 6, bit 1.")
appnNnTgFRSubareaNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 21), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnTgFRSubareaNum.setDescription("The subarea number associated with this TG.\n\nThis object corresponds to cv4680, bytes m+2 through m+5.")
appnNnTgFRHprSup = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 22), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnTgFRHprSup.setDescription("Indicates whether high performance routing (HPR)\nis supported over this TG.\n\nThis object corresponds to cv4680, byte m+1, bit 2.")
appnNnTgFRDestHprTrans = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 23), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnTgFRDestHprTrans.setDescription("Indicates whether the destination node supports\nhigh performance routing (HPR) transport tower.\n\nThis object corresponds to cv4680, byte m+1, bit 7.")
appnNnTgFRTypeIndicator = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 24), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,3,4,)).subtype(namedValues=NamedValues(("unknown", 1), ("appnOrBfTg", 2), ("interchangeTg", 3), ("virtualRouteTg", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnTgFRTypeIndicator.setDescription("Indicates the type of the TG.\n\nThis object corresponds to cv4680, byte m+1, bits 3-4.")
appnNnTgFRIntersubnet = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 25), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnTgFRIntersubnet.setDescription("Indicates whether the transmission group is an intersubnet TG,\nwhich defines a border between subnetworks.\n\nThis object corresponds to cv4680, byte m+1, bit 5.")
appnNnTgFRMltgLinkType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 26), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnTgFRMltgLinkType.setDescription("This object indicates whether the transmission group is a\nmulti-link TG.  A TG that has been brought up as a multi-link\nTG is reported as one, even if it currently has only one link\nactive.\n\nThis object corresponds to cv47, byte 6, bit 5.")
appnNnTgFRBranchTg = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 2, 2, 4, 1, 27), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnNnTgFRBranchTg.setDescription("Indicates whether the transmission group is a branch TG\n(equivalently, whether the destination of the transmission\ngroup is a branch network node).\n\nThis object corresponds to cv4680, byte m+1, bit 1.")
appnLocalTopology = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 3))
appnLocalTgTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1))
if mibBuilder.loadTexts: appnLocalTgTable.setDescription("TG Table describes all of the TGs owned by this node.  The TG\ndestination can be a virtual node, network node, LEN node, or\nend node.")
appnLocalTgEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1)).setIndexNames((0, "APPN-MIB", "appnLocalTgDest"), (0, "APPN-MIB", "appnLocalTgNum"))
if mibBuilder.loadTexts: appnLocalTgEntry.setDescription("This table is indexed by the destination CpName and the TG\nnumber.")
appnLocalTgDest = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 1), SnaControlPointName()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnLocalTgDest.setDescription("Administratively assigned name of the destination node for\nthis TG.  This is the fully qualified name of a network node,\nend node, LEN node, or virtual routing node.")
appnLocalTgNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnLocalTgNum.setDescription("Number associated with this transmission group.")
appnLocalTgDestVirtual = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 3), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalTgDestVirtual.setDescription("Indicates whether the destination node for this TG is a\nvirtual routing node.")
appnLocalTgDlcData = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 4), AppnTgDlcData()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalTgDlcData.setDescription("DLC-specific data related to a link connection network.")
appnLocalTgPortName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 5), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 10))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalTgPortName.setDescription("Administratively assigned name for the local port associated\nwith this TG.  A zero-length string indicates that this value\nis unknown.")
appnLocalTgQuiescing = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalTgQuiescing.setDescription("Indicates whether the transmission group is quiescing.")
appnLocalTgOperational = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 7), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalTgOperational.setDescription("Indicates whether the transmission group is operational.")
appnLocalTgCpCpSession = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(3,2,1,4,)).subtype(namedValues=NamedValues(("supportedUnknownStatus", 1), ("supportedActive", 2), ("notSupported", 3), ("supportedNotActive", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalTgCpCpSession.setDescription("Indicates whether CP-CP sessions are supported on this TG, and\nwhether the TG owner's contention-winner session is active on\nthis TG.  Some nodes in the network are not able to\ndifferentiate support and status of CP-CP sessions, and thus\nmay report the 'supportedUnknownStatus' value.")
appnLocalTgEffCap = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 9), AppnTgEffectiveCapacity()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalTgEffCap.setDescription("Effective capacity for this TG.")
appnLocalTgConnCost = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalTgConnCost.setDescription("Cost per connect time:  a value representing the relative cost\nper unit of time to use the TG.  Range is from 0, which means\nno cost, to 255.")
appnLocalTgByteCost = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 11), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalTgByteCost.setDescription("Relative cost of transmitting a byte over this link.\nRange is from 0 (lowest cost) to 255.")
appnLocalTgSecurity = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 12), AppnTgSecurity()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalTgSecurity.setDescription("Administratively assigned security level of this TG.")
appnLocalTgDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 13), AppnTgDelay()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalTgDelay.setDescription("Administratively assigned delay associated with this TG.")
appnLocalTgUsr1 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 14), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalTgUsr1.setDescription("First user-defined TG characteristic for this TG.  This is\nan administratively assigned value associated with the TG.")
appnLocalTgUsr2 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalTgUsr2.setDescription("Second user-defined TG characteristic for this TG.  This is\nan administratively assigned value associated with the TG.")
appnLocalTgUsr3 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 16), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalTgUsr3.setDescription("Third user-defined TG characteristic for this TG.  This is\nan administratively assigned value associated with the TG.")
appnLocalTgHprSup = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 17), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,3,4,)).subtype(namedValues=NamedValues(("noHprSupport", 1), ("hprBaseOnly", 2), ("rtpTower", 3), ("controlFlowsOverRtpTower", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalTgHprSup.setDescription("Indicates the level of high performance routing (HPR) support\nover this TG :\n\n   noHprSupport(1)             - no HPR support\n   hprBaseOnly(2)              - HPR base (option set 1400)\n                                 supported\n   rtpTower(3)                 - HPR base and RTP tower\n                                 (option set 1401) supported\n   controlFlowsOverRtpTower(4) - HPR base, RTP tower, and\n                                 control flows over RTP\n                                 (option set 1402) supported")
appnLocalTgIntersubnet = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 18), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalTgIntersubnet.setDescription("Indicates whether the transmission group is an intersubnet TG,\nwhich defines a border between subnetworks.")
appnLocalTgMltgLinkType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 19), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalTgMltgLinkType.setDescription("This object indicates whether the transmission group is a\nmulti-link TG.  A TG that has been brought up as a multi-link\nTG is reported as one, even if it currently has only one link\nactive.")
appnLocalTgBranchLinkType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 1, 1, 20), Integer().subtype(subtypeSpec=SingleValueConstraint(5,255,3,1,4,2,)).subtype(namedValues=NamedValues(("other", 1), ("uplink", 2), ("unknown", 255), ("downlink", 3), ("downlinkToBranchNetworkNode", 4), ("none", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalTgBranchLinkType.setDescription("Branch link type of this TG:\nother(1)             = the agent has determined the TG's\n                       branch link type to be a value other\n                       than branch uplink or branch\n                       downlink.  This is the value used\n                       for a connection network TG owned by\n                       a branch network node.\nuplink(2)            = the TG is a branch uplink.\ndownlink(3)          = the TG is a branch downlink to an\n                       end node.\ndownlinkToBranchNetworkNode(4) = the TG is a branch\n                       downlink to a cascaded branch\n                       network node.\nnone(5)              = the TG is not a branch TG.\nunknown(255)         = the agent cannot determine the\n                       branch link type of the TG.")
appnLocalEnTgTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2))
if mibBuilder.loadTexts: appnLocalEnTgTable.setDescription("Table describing all of the TGs owned by the end nodes known\nto this node via TG registration.  This node does not represent\nits own view of the TG on behalf of the partner node in this\ntable.  The TG destination can be a virtual routing node,\nnetwork node, or end node.")
appnLocalEnTgEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1)).setIndexNames((0, "APPN-MIB", "appnLocalEnTgOrigin"), (0, "APPN-MIB", "appnLocalEnTgDest"), (0, "APPN-MIB", "appnLocalEnTgNum"))
if mibBuilder.loadTexts: appnLocalEnTgEntry.setDescription("This table requires multiple indexes to uniquely identify each\nTG.  They are originating CPname, destination CPname, and the\nTG number.")
appnLocalEnTgOrigin = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 1), SnaControlPointName()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnLocalEnTgOrigin.setDescription("Administratively assigned name of the origin node for this\nTG.  This is a fully qualified network name.")
appnLocalEnTgDest = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 2), SnaControlPointName()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnLocalEnTgDest.setDescription("Administratively assigned name of the destination node for\nthis TG.  This is the fully qualified name of a network node,\nend node, LEN node, or virtual routing node.")
appnLocalEnTgNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnLocalEnTgNum.setDescription("Number associated with this transmission group.")
appnLocalEnTgEntryTimeLeft = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 4), AppnTopologyEntryTimeLeft()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalEnTgEntryTimeLeft.setDescription("Number of days before deletion of this end node TG entry.")
appnLocalEnTgDestVirtual = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 5), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalEnTgDestVirtual.setDescription("Indicates whether the destination node is a virtual routing\nnode.")
appnLocalEnTgDlcData = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 6), AppnTgDlcData()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalEnTgDlcData.setDescription("DLC-specific data related to a link connection network.")
appnLocalEnTgOperational = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 7), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalEnTgOperational.setDescription("Indicates whether the transmission group is operational.")
appnLocalEnTgCpCpSession = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(3,2,1,4,)).subtype(namedValues=NamedValues(("supportedUnknownStatus", 1), ("supportedActive", 2), ("notSupported", 3), ("supportedNotActive", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalEnTgCpCpSession.setDescription("Indicates whether CP-CP sessions are supported on this TG, and\nwhether the TG owner's contention-winner session is active on\nthis TG.  Some nodes in the network are not able to\ndifferentiate support and status of CP-CP sessions, and thus\nmay report the 'supportedUnknownStatus' value.")
appnLocalEnTgEffCap = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 9), AppnTgEffectiveCapacity()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalEnTgEffCap.setDescription("Effective capacity for this TG.")
appnLocalEnTgConnCost = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalEnTgConnCost.setDescription("Cost per connect time:  a value representing the relative cost\nper unit of time to use the TG.  Range is from 0, which means\nno cost, to 255.")
appnLocalEnTgByteCost = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 11), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalEnTgByteCost.setDescription("Relative cost of transmitting a byte over this link.\nRange is from 0, which means no cost, to 255.")
appnLocalEnTgSecurity = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 12), AppnTgSecurity()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalEnTgSecurity.setDescription("Administratively assigned security level of this TG.")
appnLocalEnTgDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 13), AppnTgDelay()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalEnTgDelay.setDescription("Administratively assigned delay associated with this TG.")
appnLocalEnTgUsr1 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 14), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalEnTgUsr1.setDescription("First user-defined TG characteristic for this TG.  This is\nan administratively assigned value associated with the TG.")
appnLocalEnTgUsr2 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalEnTgUsr2.setDescription("Second user-defined TG characteristic for this TG.  This is\nan administratively assigned value associated with the TG.")
appnLocalEnTgUsr3 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 16), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalEnTgUsr3.setDescription("Third user-defined TG characteristic for this TG.  This is\nan administratively assigned value associated with the TG.")
appnLocalEnTgMltgLinkType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 3, 2, 1, 17), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnLocalEnTgMltgLinkType.setDescription("This object indicates whether the transmission group is a\nmulti-link TG.  A TG that has been brought up as a multi-link\nTG is reported as one, even if it currently has only one link\nactive.")
appnDir = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 4))
appnDirPerf = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1))
appnDirMaxCaches = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1, 1), Unsigned32()).setMaxAccess("readonly").setUnits("directory entries")
if mibBuilder.loadTexts: appnDirMaxCaches.setDescription("Maximum number of cache entries allowed.  This is an\nadministratively assigned value.")
appnDirCurCaches = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1, 2), Gauge32()).setMaxAccess("readonly").setUnits("directory entries")
if mibBuilder.loadTexts: appnDirCurCaches.setDescription("Current number of cache entries.")
appnDirCurHomeEntries = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1, 3), Gauge32()).setMaxAccess("readonly").setUnits("directory entries")
if mibBuilder.loadTexts: appnDirCurHomeEntries.setDescription("Current number of home entries.")
appnDirRegEntries = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1, 4), Gauge32()).setMaxAccess("readonly").setUnits("directory entries")
if mibBuilder.loadTexts: appnDirRegEntries.setDescription("Current number of registered entries.")
appnDirInLocates = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1, 5), AppnNodeCounter()).setMaxAccess("readonly").setUnits("Locate messages")
if mibBuilder.loadTexts: appnDirInLocates.setDescription("Number of directed Locates received since the node was last\nreinitialized.")
appnDirInBcastLocates = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1, 6), AppnNodeCounter()).setMaxAccess("readonly").setUnits("Locate messages")
if mibBuilder.loadTexts: appnDirInBcastLocates.setDescription("Number of broadcast Locates received since the node was last\nreinitialized.")
appnDirOutLocates = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1, 7), AppnNodeCounter()).setMaxAccess("readonly").setUnits("Locate messages")
if mibBuilder.loadTexts: appnDirOutLocates.setDescription("Number of directed Locates sent since the node was last\nreinitialized.")
appnDirOutBcastLocates = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1, 8), AppnNodeCounter()).setMaxAccess("readonly").setUnits("Locate messages")
if mibBuilder.loadTexts: appnDirOutBcastLocates.setDescription("Number of broadcast Locates sent since the node was last\nreinitialized.")
appnDirNotFoundLocates = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1, 9), AppnNodeCounter()).setMaxAccess("readonly").setUnits("Locate messages")
if mibBuilder.loadTexts: appnDirNotFoundLocates.setDescription("Number of directed Locates returned with a 'not found' since\nthe node was last reinitialized.")
appnDirNotFoundBcastLocates = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1, 10), AppnNodeCounter()).setMaxAccess("readonly").setUnits("Locate messages")
if mibBuilder.loadTexts: appnDirNotFoundBcastLocates.setDescription("Number of broadcast Locates returned with a 'not found' since\nthe node was last reinitialized.")
appnDirLocateOutstands = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 1, 11), Gauge32()).setMaxAccess("readonly").setUnits("Locate messages")
if mibBuilder.loadTexts: appnDirLocateOutstands.setDescription("Current number of outstanding Locates, both directed and\nbroadcast.  This value varies.  A value of zero indicates\nthat no Locates are unanswered.")
appnDirTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 2))
if mibBuilder.loadTexts: appnDirTable.setDescription("Table containing information about all known LUs.")
appnDirEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 2, 1)).setIndexNames((0, "APPN-MIB", "appnDirLuName"))
if mibBuilder.loadTexts: appnDirEntry.setDescription("This table is indexed by the LU name.")
appnDirLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 2, 1, 1), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 17))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnDirLuName.setDescription("Fully qualified network LU name in the domain of the\nserving network node.  Entries take one of three forms:\n\n   - Explicit entries do not contain the character '*'.\n   - Partial wildcard entries have the form 'ccc*', where\n     'ccc' represents one to sixteen characters in a\n     legal SNA LuName.\n   - A full wildcard entry consists of the single\n     character '*'")
appnDirNnServerName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 2, 1, 2), SnaControlPointName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnDirNnServerName.setDescription("Fully qualified control point (CP) name of the network node\nserver.  For unassociated end node entries, a zero-length\nstring is returned.")
appnDirLuOwnerName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 2, 1, 3), SnaControlPointName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnDirLuOwnerName.setDescription("Fully qualified CP name of the node at which the LU is\nlocated.  This name is the same as the serving NN name when\nthe LU is located at a network node.  It is also the same as\nthe fully qualified LU name when this is the control point\nLU for this node.")
appnDirLuLocation = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 2, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(2,3,1,)).subtype(namedValues=NamedValues(("local", 1), ("domain", 2), ("xdomain", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnDirLuLocation.setDescription("Specifies the location of the LU with respect to the local\nnode.")
appnDirType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 2, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,2,)).subtype(namedValues=NamedValues(("home", 1), ("cache", 2), ("registered", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnDirType.setDescription("Directory types are:\n1 - Home\n      The LU is in the domain of the local node, and the LU\n      information has been configured at the local node.\n\n2 - Cache\n      The LU has previously been located by a broadcast\n      search, and the location information has been saved.\n3 - Registered\n      The LU is at an end node that is in the domain\n      of the local network node.  Registered entries\n      are registered by the served end node.")
appnDirApparentLuOwnerName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 4, 2, 1, 6), DisplayString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(3,17),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnDirApparentLuOwnerName.setDescription("Fully qualified CP name of the node at which the LU appears to\nbe located.  This object and the appnDirLuOwnerName object are\nrelated as follows:\n\nImplementations that support this object save in their\ndirectory database information about an LU's owning control\npoint that was communicated in two control vectors:\n\n     -  an Associated Resource Entry (X'3C') CV with resource\n        type X'00F4' (ENCP)\n\n     -  a Real Owning Control Point (X'4A') CV.\n\nThe X'4A' CV is created by a branch network node to preserve\nthe name of the real owning control point for an LU below the\nbranch network node, before it overwrites this name with its\nown name in the X'3C' CV.  The X'4A' CV is not present for LUs\nthat are not below branch network nodes.\n\nIf the information a node has about an LU's owning CP came only\nin a X'3C' CV, then the name from the X'3C' is returned in the\nappnDirLuOwnerName object, and a null string is returned in\nthis object.\n\nIf the information a node has about an LU's owning CP came in\nboth X'3C' and X'4A' CVs, then the name from the X'4A' is\nreturned in the appnDirLuOwnerName object, and the name from\nthe X'3C' (which will be the branch network node's name) is\nreturned in this object.")
appnCos = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 5))
appnCosModeTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 1))
if mibBuilder.loadTexts: appnCosModeTable.setDescription("Table representing all of the defined mode names for this\nnode.  The table contains the matching COS name for each\nmode name.")
appnCosModeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 1, 1)).setIndexNames((0, "APPN-MIB", "appnCosModeName"))
if mibBuilder.loadTexts: appnCosModeEntry.setDescription("This table is indexed by the mode name.")
appnCosModeName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 1, 1, 1), SnaModeName()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnCosModeName.setDescription("Administratively assigned name for this mode.")
appnCosModeCosName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 1, 1, 2), SnaClassOfServiceName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosModeCosName.setDescription("Administratively assigned name for this class of service.")
appnCosNameTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 2))
if mibBuilder.loadTexts: appnCosNameTable.setDescription("Table mapping all of the defined class-of-service names for\nthis node to their network transmission priorities.")
appnCosNameEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 2, 1)).setIndexNames((0, "APPN-MIB", "appnCosName"))
if mibBuilder.loadTexts: appnCosNameEntry.setDescription("The COS name is the index to this table.")
appnCosName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 2, 1, 1), SnaClassOfServiceName()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnCosName.setDescription("Administratively assigned name for this class of service.")
appnCosTransPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 2, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(3,4,2,1,)).subtype(namedValues=NamedValues(("low", 1), ("medium", 2), ("high", 3), ("network", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosTransPriority.setDescription("Transmission priority for this class of service:\n\nlow(1)     - (X'01'):  low priority\nmedium(2)  - (X'02'):  medium priority\nhigh(3)    - (X'03'):  high priority\nnetwork(4) - (X'04'):  network priority")
appnCosNodeRowTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 3))
if mibBuilder.loadTexts: appnCosNodeRowTable.setDescription("This table contains all node-row information for all classes\nof service defined in this node.")
appnCosNodeRowEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 3, 1)).setIndexNames((0, "APPN-MIB", "appnCosNodeRowName"), (0, "APPN-MIB", "appnCosNodeRowIndex"))
if mibBuilder.loadTexts: appnCosNodeRowEntry.setDescription("A node entry for a given class of service.")
appnCosNodeRowName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 3, 1, 1), SnaClassOfServiceName()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnCosNodeRowName.setDescription("Administratively assigned name for this class of service.")
appnCosNodeRowIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 3, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnCosNodeRowIndex.setDescription("Subindex under appnCosNodeRowName, corresponding to a row in\nthe node table for the class of service identified in\nappnCosNodeRowName.\n\nFor each class of service, this subindex orders rows in the\nappnCosNodeRowTable in the same order as that used for route\ncalculation in the APPN node.")
appnCosNodeRowWgt = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 3, 1, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosNodeRowWgt.setDescription("Weight to be associated with the nodes that fit the criteria\nspecified by this node row.\n\nThis value can either be a character representation of an\ninteger, or a formula for calculating the weight.")
appnCosNodeRowResistMin = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 3, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosNodeRowResistMin.setDescription("Minimum route addition resistance value for this node.\nRange of values is 0-255.  The lower the value, the more\ndesirable the node is for intermediate routing.")
appnCosNodeRowResistMax = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 3, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosNodeRowResistMax.setDescription("Maximum route addition resistance value for this node.\nRange of values is 0-255.  The lower the value, the more\ndesirable the node is for intermediate routing.")
appnCosNodeRowMinCongestAllow = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 3, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 1))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosNodeRowMinCongestAllow.setDescription("Indicates whether low congestion will be tolerated.  This\nobject and appnCosNodeRowMaxCongestAllow together delineate a\nrange of acceptable congestion states for a node.  For the\nordered pair (minimum congestion allowed, maximum congestion\nallowed), the values are interpreted as follows:\n\n - (0,0):  only low congestion is acceptable\n - (0,1):  either low or high congestion is acceptable\n - (1,1):  only high congestion is acceptable.\n\nNote that the combination (1,0) is not defined, since it\nwould identify a range whose lower bound was high congestion\nand whose upper bound was low congestion.")
appnCosNodeRowMaxCongestAllow = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 3, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 1))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosNodeRowMaxCongestAllow.setDescription("Indicates whether low congestion will be tolerated.  This\nobject and appnCosNodeRowMinCongestAllow together delineate a\nrange of acceptable congestion states for a node.  For the\nordered pair (minimum congestion allowed, maximum congestion\nallowed), the values are interpreted as follows:\n - (0,0):  only low congestion is acceptable\n - (0,1):  either low or high congestion is acceptable\n - (1,1):  only high congestion is acceptable.\n\nNote that the combination (1,0) is not defined, since it\nwould identify a range whose lower bound was high congestion\nand whose upper bound was low congestion.")
appnCosTgRowTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4))
if mibBuilder.loadTexts: appnCosTgRowTable.setDescription("Table containing all the TG-row information for all classes of\nservice defined in this node.")
appnCosTgRowEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1)).setIndexNames((0, "APPN-MIB", "appnCosTgRowName"), (0, "APPN-MIB", "appnCosTgRowIndex"))
if mibBuilder.loadTexts: appnCosTgRowEntry.setDescription("A TG entry for a given class of service.")
appnCosTgRowName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 1), SnaClassOfServiceName()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnCosTgRowName.setDescription("Administratively assigned name for this class of service.")
appnCosTgRowIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnCosTgRowIndex.setDescription("Subindex under appnCosTgRowName, corresponding to a row in the\nTG table for the class of service identified in\nappnCosTgRowName.\n\nFor each class of service, this subindex orders rows in the\nappnCosTgRowTable in the same order as that used for route\ncalculation in the APPN node.")
appnCosTgRowWgt = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosTgRowWgt.setDescription("Weight to be associated with the TGs that fit the criteria\nspecified by this TG row.\n\nThis value can either be a character representation of an\ninteger, or a formula for calculating the weight.")
appnCosTgRowEffCapMin = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 4), AppnTgEffectiveCapacity()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosTgRowEffCapMin.setDescription("Minimum acceptable capacity for this class of service.")
appnCosTgRowEffCapMax = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 5), AppnTgEffectiveCapacity()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosTgRowEffCapMax.setDescription("Maximum acceptable capacity for this class of service.")
appnCosTgRowConnCostMin = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosTgRowConnCostMin.setDescription("Minimum acceptable cost per connect time for this class of\nservice.\n\nCost per connect time:  a value representing the relative\ncost per unit of time to use this TG.  Range is from 0, which\nmeans no cost, to 255.")
appnCosTgRowConnCostMax = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosTgRowConnCostMax.setDescription("Maximum acceptable cost per connect time for this class of\nservice.\n\nCost per connect time:  a value representing the relative\ncost per unit of time to use this TG.  Range is from 0, which\nmeans no cost, to 255.")
appnCosTgRowByteCostMin = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosTgRowByteCostMin.setDescription("Minimum acceptable cost per byte transmitted for this class\nof service.\n\nCost per byte transmitted:  a value representing the relative\ncost per unit of time to use this TG.  Range is from 0, which\nmeans no cost, to 255.")
appnCosTgRowByteCostMax = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosTgRowByteCostMax.setDescription("Maximum acceptable cost per byte transmitted for this class\nof service.\n\nCost per byte transmitted:  a value representing the relative\ncost of transmitting a byte over this TG.  Range is from 0,\nwhich means no cost, to 255.")
appnCosTgRowSecurityMin = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 10), AppnTgSecurity()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosTgRowSecurityMin.setDescription("Minimum acceptable security for this class of service.")
appnCosTgRowSecurityMax = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 11), AppnTgSecurity()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosTgRowSecurityMax.setDescription("Maximum acceptable security for this class of service.")
appnCosTgRowDelayMin = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 12), AppnTgDelay()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosTgRowDelayMin.setDescription("Minimum acceptable propagation delay for this class of\nservice.")
appnCosTgRowDelayMax = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 13), AppnTgDelay()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosTgRowDelayMax.setDescription("Maximum acceptable propagation delay for this class of\nservice.")
appnCosTgRowUsr1Min = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 14), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosTgRowUsr1Min.setDescription("Minimum acceptable value for this user-defined\ncharacteristic.")
appnCosTgRowUsr1Max = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosTgRowUsr1Max.setDescription("Maximum acceptable value for this user-defined\ncharacteristic.")
appnCosTgRowUsr2Min = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 16), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosTgRowUsr2Min.setDescription("Minimum acceptable value for this user-defined\ncharacteristic.")
appnCosTgRowUsr2Max = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 17), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosTgRowUsr2Max.setDescription("Maximum acceptable value for this user-defined\ncharacteristic.")
appnCosTgRowUsr3Min = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 18), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosTgRowUsr3Min.setDescription("Minimum acceptable value for this user-defined\ncharacteristic.")
appnCosTgRowUsr3Max = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 5, 4, 1, 19), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnCosTgRowUsr3Max.setDescription("Maximum acceptable value for this user-defined\ncharacteristic.")
appnSessIntermediate = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 6))
appnIsInGlobal = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 1))
appnIsInGlobeCtrAdminStatus = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 1, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,3,)).subtype(namedValues=NamedValues(("notActive", 1), ("active", 2), ("ready", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: appnIsInGlobeCtrAdminStatus.setDescription("Object by which a Management Station can deactivate or\nactivate capture of intermediate-session counts and names, by\nsetting the value to notActive(1) or active(2), respectively.\nThe value ready(3) is returned on GET operations until a SET\nhas been processed; after that the value received on the most\nrecent SET is returned.\n\nThe counts referred to here are the eight objects in the\nAppnIsInTable, from appnIsInP2SFmdPius through\nappnIsInS2PNonFmdBytes.  The names are the four objects in this\ntable, from appnIsInPriLuName through appnIsInCosName.\n\nSetting this object to the following values has the following\neffects:\n\n    notActive(1)  stop collecting count data.  If a count\n                  is queried, it returns the value 0.\n                  Collection of names may, but need not be,\n                  disabled.\n    active(2)     start collecting count data.  If it is\n                  supported, collection of names is enabled.")
appnIsInGlobeCtrOperStatus = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("notActive", 1), ("active", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInGlobeCtrOperStatus.setDescription("Indicates whether or not the intermediate session counts\nare active.  The counts referred to here are the eight\nobjects in the AppnIsInTable, from appnIsInP2SFmdPius through\nappnIsInS2PNonFmdBytes.  These eight counts are of type\nUnsigned32 rather than Counter32 because when this object\nenters the notActive state, either because a Management\nStation has set appnInInGlobeCtrAdminStatus to notActive or\nbecause of a locally-initiated transition, the counts are\nall reset to 0.\n\nThe values for this object are:\n\n    notActive(1):  collection of counts is not active; if it\n                   is queried, a count returns the value 0.\n    active(2):     collection of counts is active.")
appnIsInGlobeCtrStatusTime = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 1, 3), TimeTicks()).setMaxAccess("readonly").setUnits("hundredths of a second")
if mibBuilder.loadTexts: appnIsInGlobeCtrStatusTime.setDescription("The time since the appnIsInGlobeCtrOperStatus object last\nchanged, measured in hundredths of a second.  This time can be\nused to identify when this change occurred in relation to other\nevents in the agent, such as the last time the APPN node was\nreinitialized.")
appnIsInGlobeRscv = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("notActive", 1), ("active", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: appnIsInGlobeRscv.setDescription("Indicates the current route selection control vector (RSCV)\ncollection option in effect, and allows a Management Station to\nchange the option.\n\nThe values for this object are:\n\n   notActive(1): collection of route selection control vectors\n                 is not active.\n   active(2):    collection of route selection control vectors\n                 is active.")
appnIsInGlobeRscvTime = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 1, 5), TimeTicks()).setMaxAccess("readonly").setUnits("hundredths of a second")
if mibBuilder.loadTexts: appnIsInGlobeRscvTime.setDescription("The time since the appnIsInGlobeRscv object last changed,\nmeasured in hundredths of a second.  This time can be used to\nidentify when this change occurred in relation to other events\nin the agent, such as the last time the APPN node was\nreinitialized.")
appnIsInGlobeActSess = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 1, 6), Gauge32()).setMaxAccess("readonly").setUnits("sessions")
if mibBuilder.loadTexts: appnIsInGlobeActSess.setDescription("The number of currently active intermediate sessions.")
appnIsInGlobeHprBfActSess = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 1, 7), Gauge32()).setMaxAccess("readonly").setUnits("sessions")
if mibBuilder.loadTexts: appnIsInGlobeHprBfActSess.setDescription("The number of currently active HPR intermediate sessions.")
appnIsInTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2))
if mibBuilder.loadTexts: appnIsInTable.setDescription("Intermediate Session Information Table")
appnIsInEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1)).setIndexNames((0, "APPN-MIB", "appnIsInFqCpName"), (0, "APPN-MIB", "appnIsInPcid"))
if mibBuilder.loadTexts: appnIsInEntry.setDescription("Entry of Intermediate Session Information Table.")
appnIsInFqCpName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 1), SnaControlPointName()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnIsInFqCpName.setDescription("The network-qualified control point name of the node at which\nthe session and PCID originated.  For APPN and LEN nodes, this\nis either CP name of the APPN node at which the origin LU is\nlocated or the CP name of the NN serving the LEN node at which\nthe origin LU is located.  For resources served by a dependent\nLU requester (DLUR), it is the name of the owning system\nservices control point (SSCP).")
appnIsInPcid = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 2), OctetString().subtype(subtypeSpec=ValueSizeConstraint(8, 8)).setFixedLength(8)).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnIsInPcid.setDescription("The procedure correlation identifier (PCID) of a session.  It\nis an 8-byte value assigned by the primary LU.")
appnIsInSessState = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,4,)).subtype(namedValues=NamedValues(("inactive", 1), ("pendactive", 2), ("active", 3), ("pendinact", 4), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: appnIsInSessState.setDescription("Indicates the state of the session:\n\ninactive(1)   - session is inactive\npendactive(2) - session is pending active\nactive(3)     - session is active\npendinact(4)  - session is pending inactive\n\nActive sessions can be deactivated by setting this object\nto inactive(1).")
appnIsInPriLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 4), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 17))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInPriLuName.setDescription("The primary LU name of the session.  A zero-length\nstring indicates that this name is not available.")
appnIsInSecLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 5), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 17))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInSecLuName.setDescription("The secondary LU name of the session.  A zero-length\nstring indicates that this name is not available.")
appnIsInModeName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 6), SnaModeName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInModeName.setDescription("The mode name used for this session.")
appnIsInCosName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 7), SnaClassOfServiceName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInCosName.setDescription("The Class of Service (COS) name used for this session.")
appnIsInTransPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(3,4,2,1,)).subtype(namedValues=NamedValues(("low", 1), ("medium", 2), ("high", 3), ("network", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInTransPriority.setDescription("Transmission priority for this class of service.  Values are:\n\nlow(1)     - (X'01'):  low priority\nmedium(2)  - (X'02'):  medium priority\nhigh(3)    - (X'03'):  high priority\nnetwork(4) - (X'04'):  network priority")
appnIsInSessType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 9), Integer().subtype(subtypeSpec=SingleValueConstraint(4,1,3,2,5,)).subtype(namedValues=NamedValues(("unknown", 1), ("lu62", 2), ("lu0thru3", 3), ("lu62dlur", 4), ("lu0thru3dlur", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInSessType.setDescription("The type of intermediate session.  Defined values are\n\nunknown      The session type is not known.\n\nlu62         A session between LUs of type 6.2\n             (as indicated by the LU type in Bind)\n\nlu0thru3     A session between LUs of type 0, 1, 2, or 3\n             (as indicated by the LU type in Bind)\n\nlu62dlur     A session between LUs of type 6.2\n             (as indicated by the LU type in Bind).\n             One of the LUs is a dependent LU supported\n             by the dependent LU requester (DLUR)\n             function at this node.\n\nlu0thru3dlur A session between LUs of type 0, 1, 2, or 3\n             (as indicated by the LU type in Bind)\n             One of the LUs is a dependent LU supported\n             by the dependent LU requester (DLUR)\n             function at this node.")
appnIsInSessUpTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 10), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInSessUpTime.setDescription("Length of time the session has been active, measured in\nhundredths of a second.")
appnIsInCtrUpTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 11), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInCtrUpTime.setDescription("Length of time the session counters have been active, measured\nin hundredths of a second.")
appnIsInP2SFmdPius = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 12), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInP2SFmdPius.setDescription("Number of function management data (FMD) path information\nunits (PIUs) sent from the Primary LU to the Secondary LU since\nthe counts were last activated.")
appnIsInS2PFmdPius = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 13), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInS2PFmdPius.setDescription("Number of FMD PIUs sent from the Secondary LU to the Primary\nLU since the counts were last activated.")
appnIsInP2SNonFmdPius = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 14), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInP2SNonFmdPius.setDescription("Number of non-FMD PIUs sent from the Primary LU to the\nSecondary LU since the counts were last activated.")
appnIsInS2PNonFmdPius = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 15), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInS2PNonFmdPius.setDescription("Number of non-FMD PIUs sent from the Secondary LU to the\nPrimary LU since the counts were last activated.")
appnIsInP2SFmdBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 16), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInP2SFmdBytes.setDescription("Number of FMD bytes sent from the Primary LU to the Secondary\nLU since the counts were last activated.")
appnIsInS2PFmdBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 17), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInS2PFmdBytes.setDescription("Number of FMD bytes sent from the Secondary LU to the Primary\nLU since the counts were last activated.")
appnIsInP2SNonFmdBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 18), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInP2SNonFmdBytes.setDescription("Number of non-FMD bytes sent from the Primary LU to the\nSecondary LU since the counts were last activated.")
appnIsInS2PNonFmdBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 19), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInS2PNonFmdBytes.setDescription("Number of non-FMD bytes sent from the Secondary LU to the\nPrimary LU since the counts were last activated.")
appnIsInPsAdjCpName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 20), SnaControlPointName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInPsAdjCpName.setDescription("The primary stage adjacent CP name of this session.  If the\nsession stage traverses an RTP connection, the CP name of the\nremote RTP endpoint is returned.")
appnIsInPsAdjTgNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 21), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 300))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInPsAdjTgNum.setDescription("The primary stage adjacent transmission group (TG) number\nassociated with this session.  If the session stage traverses\nan RTP connection, the value 256 is returned.\n\nValues between 257 and 300 are available for other possible\nTG 'stand-ins' that may be added to APPN in the future.")
appnIsInPsSendMaxBtuSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 22), Integer32().subtype(subtypeSpec=ValueRangeConstraint(99, 32767))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInPsSendMaxBtuSize.setDescription("The primary stage maximum basic transmission unit (BTU) size\nfor sending data.")
appnIsInPsSendPacingType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 23), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("fixed", 1), ("adaptive", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInPsSendPacingType.setDescription("The primary stage type of pacing being used for sending data.")
appnIsInPsSendRpc = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 24), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInPsSendRpc.setDescription("The primary stage send residual pace count.  This represents\nthe primary stage number of message units (MUs) that can still\nbe sent in the current session window.")
appnIsInPsSendNxWndwSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 25), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInPsSendNxWndwSize.setDescription("The primary stage size of the next window which will be used\nto send data.")
appnIsInPsRecvPacingType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 26), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("fixed", 1), ("adaptive", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInPsRecvPacingType.setDescription("The primary stage type of pacing being used for receiving\ndata.")
appnIsInPsRecvRpc = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 27), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInPsRecvRpc.setDescription("The primary stage receive residual pace count.  This\nrepresents the primary stage number of message units (MUs) that\ncan still be received in the current session window.")
appnIsInPsRecvNxWndwSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 28), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInPsRecvNxWndwSize.setDescription("The primary stage size of the next window which will be used\nto receive data.")
appnIsInSsAdjCpName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 29), SnaControlPointName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInSsAdjCpName.setDescription("The secondary stage adjacent CP name of this session.  If the\nsession stage traverses an RTP connection, the CP name of the\nremote RTP endpoint is returned.")
appnIsInSsAdjTgNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 30), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 300))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInSsAdjTgNum.setDescription("The secondary stage adjacent transmission group (TG) number\nassociated with this session.  If the session stage traverses\nan RTP connection, the value 256 is returned.\n\nValues between 257 and 300 are available for other possible\nTG 'stand-ins' that may be added to APPN in the future.")
appnIsInSsSendMaxBtuSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 31), Integer32().subtype(subtypeSpec=ValueRangeConstraint(99, 32767))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInSsSendMaxBtuSize.setDescription("The secondary stage maximum basic transmission unit (BTU) size\nfor sending data.")
appnIsInSsSendPacingType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 32), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("fixed", 1), ("adaptive", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInSsSendPacingType.setDescription("The secondary stage type of pacing being used for sending\ndata.")
appnIsInSsSendRpc = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 33), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInSsSendRpc.setDescription("The secondary stage send residual pace count.  This represents\nthe secondary stage number of message units (MUs) that can\nstill be sent in the current session window.")
appnIsInSsSendNxWndwSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 34), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInSsSendNxWndwSize.setDescription("The secondary stage size of the next window which will be used\nto send data.")
appnIsInSsRecvPacingType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 35), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("fixed", 1), ("adaptive", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInSsRecvPacingType.setDescription("The secondary stage type of pacing being used for receiving\ndata.")
appnIsInSsRecvRpc = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 36), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInSsRecvRpc.setDescription("The secondary stage receive residual pace count.  This\nrepresents the secondary stage number of message units (MUs)\nthat can still be received in the current session window.")
appnIsInSsRecvNxWndwSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 37), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInSsRecvNxWndwSize.setDescription("The secondary stage size of the next window which will be used\nto receive data.")
appnIsInRouteInfo = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 38), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInRouteInfo.setDescription("The route selection control vector (RSCV X'2B') used for this\nsession.  It is present for APPN nodes; but is not present for\nLEN nodes.  The format of this vector is described in SNA\nFormats.  If no RSCV is available, a zero-length string is\nreturned.")
appnIsInRtpNceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 39), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInRtpNceId.setDescription("The HPR local Network Connection Endpoint of the session.")
appnIsInRtpTcid = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 2, 1, 40), OctetString().subtype(subtypeSpec=ValueSizeConstraint(8, 8)).setFixedLength(8)).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsInRtpTcid.setDescription("The RTP connection local TCID of the session.")
appnIsRtpTable = MibTable((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 3))
if mibBuilder.loadTexts: appnIsRtpTable.setDescription("A table indicating how many ISR sessions are transported by\neach RTP connection.")
appnIsRtpEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 3, 1)).setIndexNames((0, "APPN-MIB", "appnIsRtpNceId"), (0, "APPN-MIB", "appnIsRtpTcid"))
if mibBuilder.loadTexts: appnIsRtpEntry.setDescription("Entry of Intermediate Session RTP Table.")
appnIsRtpNceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 3, 1, 1), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 8))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnIsRtpNceId.setDescription("The local Network Connection Endpoint of the RTP connection.")
appnIsRtpTcid = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 3, 1, 2), OctetString().subtype(subtypeSpec=ValueSizeConstraint(8, 8)).setFixedLength(8)).setMaxAccess("noaccess")
if mibBuilder.loadTexts: appnIsRtpTcid.setDescription("The local TCID of the RTP connection.")
appnIsRtpSessions = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 4, 1, 6, 3, 1, 3), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: appnIsRtpSessions.setDescription("The number of intermediate sessions using this RTP\nconnection.")
appnTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 2))
alertIdNumber = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 2, 2), OctetString().subtype(subtypeSpec=ValueSizeConstraint(4, 4)).setFixedLength(4)).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: alertIdNumber.setDescription("A 32-bit SNA Management Services (SNA/MS) Alert ID Number, as\nspecified in SNA/MS Formats.")
affectedObject = MibScalar((1, 3, 6, 1, 2, 1, 34, 4, 2, 3), VariablePointer()).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: affectedObject.setDescription("The MIB object associated with the Alert condition, if there\nis an object associated with it.  If no associated object can\nbe identified, the value 0.0 is passed in the trap.")
appnConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 3))
appnCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 3, 1))
appnGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 4, 3, 2))

# Augmentions

# Notifications

alertTrap = NotificationType((1, 3, 6, 1, 2, 1, 34, 4, 2, 1)).setObjects(*(("APPN-MIB", "alertIdNumber"), ("APPN-MIB", "affectedObject"), ) )
if mibBuilder.loadTexts: alertTrap.setDescription("This trap carries a 32-bit SNA Management Services (SNA/MS)\nAlert ID Number, as specified in SNA/MS Formats.")

# Groups

appnGeneralConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 1)).setObjects(*(("APPN-MIB", "appnNodeAdaptiveBindPacing"), ("APPN-MIB", "appnNodeType"), ("APPN-MIB", "appnNodeCpName"), ("APPN-MIB", "appnNodeHprSupport"), ("APPN-MIB", "appnNodeParallelTg"), ("APPN-MIB", "appnNodeMibVersion"), ("APPN-MIB", "appnNodeCounterDisconTime"), ("APPN-MIB", "appnNodeUpTime"), ("APPN-MIB", "appnNodeId"), ) )
if mibBuilder.loadTexts: appnGeneralConfGroup.setDescription("A collection of objects providing the instrumentation of\nAPPN general information and capabilities.\n\nThis RFC 2155-level group was deprecated when the\nappnNodeMibVersion object was removed and the\nappnNodeLsCounterType and appnNodeBrNn objects were added.")
appnPortConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 2)).setObjects(*(("APPN-MIB", "appnPortMaxIframeWindow"), ("APPN-MIB", "appnPortOperState"), ("APPN-MIB", "appnPortCommand"), ("APPN-MIB", "appnPortLsRole"), ("APPN-MIB", "appnPortPortType"), ("APPN-MIB", "appnPortDynamicLinkSupport"), ("APPN-MIB", "appnPortDlcType"), ("APPN-MIB", "appnPortDynLsBadXids"), ("APPN-MIB", "appnPortDefLsGoodXids"), ("APPN-MIB", "appnPortNegotLs"), ("APPN-MIB", "appnPortSpecific"), ("APPN-MIB", "appnPortDefLsBadXids"), ("APPN-MIB", "appnPortSIMRIM"), ("APPN-MIB", "appnPortMaxRcvBtuSize"), ("APPN-MIB", "appnPortDlcLocalAddr"), ("APPN-MIB", "appnPortDynLsGoodXids"), ("APPN-MIB", "appnPortCounterDisconTime"), ) )
if mibBuilder.loadTexts: appnPortConfGroup.setDescription("A collection of objects providing the instrumentation of\nAPPN port information.")
appnLinkConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 3)).setObjects(*(("APPN-MIB", "appnLsLimResource"), ("APPN-MIB", "appnLsCurrentDelay"), ("APPN-MIB", "appnLsLocalAddr"), ("APPN-MIB", "appnLsStatusLsName"), ("APPN-MIB", "appnLsCounterDisconTime"), ("APPN-MIB", "appnLsCurrentStateTime"), ("APPN-MIB", "appnLsPartnerNodeId"), ("APPN-MIB", "appnLsOutXidFrames"), ("APPN-MIB", "appnLsStatusXidBitInError"), ("APPN-MIB", "appnLsAdjCpName"), ("APPN-MIB", "appnLsStatusXidRemoteSense"), ("APPN-MIB", "appnLsMinDelay"), ("APPN-MIB", "appnLsStatusRetry"), ("APPN-MIB", "appnLsAdjNodeType"), ("APPN-MIB", "appnLsCpCpSessionSupport"), ("APPN-MIB", "appnLsStatusGeneralSense"), ("APPN-MIB", "appnLsInXidFrames"), ("APPN-MIB", "appnLsMaxSendBtuSize"), ("APPN-MIB", "appnLsCommand"), ("APPN-MIB", "appnLsDynamic"), ("APPN-MIB", "appnLsSpecific"), ("APPN-MIB", "appnLsGoodXids"), ("APPN-MIB", "appnLsTgNum"), ("APPN-MIB", "appnLsStatusXidByteInError"), ("APPN-MIB", "appnLsDlcType"), ("APPN-MIB", "appnLsStatusDlcType"), ("APPN-MIB", "appnLsPortName"), ("APPN-MIB", "appnLsOutMsgFrames"), ("APPN-MIB", "appnLsOutXidBytes"), ("APPN-MIB", "appnLsBadXids"), ("APPN-MIB", "appnLsMaxDelay"), ("APPN-MIB", "appnLsStatusXidLocalSense"), ("APPN-MIB", "appnLsStatusEndSense"), ("APPN-MIB", "appnLsStatusPartnerId"), ("APPN-MIB", "appnLsRemoteLsName"), ("APPN-MIB", "appnLsMigration"), ("APPN-MIB", "appnLsStatusRemoteAddr"), ("APPN-MIB", "appnLsOperState"), ("APPN-MIB", "appnLsStatusTime"), ("APPN-MIB", "appnLsStatusTgNum"), ("APPN-MIB", "appnLsMaxDelayTime"), ("APPN-MIB", "appnLsEchoRsps"), ("APPN-MIB", "appnLsActiveTime"), ("APPN-MIB", "appnLsStatusLocalAddr"), ("APPN-MIB", "appnLsInXidBytes"), ("APPN-MIB", "appnLsStatusCpName"), ("APPN-MIB", "appnLsHprSup"), ("APPN-MIB", "appnLsInMsgBytes"), ("APPN-MIB", "appnLsActOnDemand"), ("APPN-MIB", "appnLsInMsgFrames"), ("APPN-MIB", "appnLsOutMsgBytes"), ("APPN-MIB", "appnLsRemoteAddr"), ) )
if mibBuilder.loadTexts: appnLinkConfGroup.setDescription("A collection of objects providing the instrumentation of\nAPPN link information.\n\nThis RFC 2155-level group was deprecated when the\nappnLsMltgMember object was added.")
appnLocalTgConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 4)).setObjects(*(("APPN-MIB", "appnLocalTgOperational"), ("APPN-MIB", "appnLocalTgQuiescing"), ("APPN-MIB", "appnLocalTgPortName"), ("APPN-MIB", "appnLocalTgUsr3"), ("APPN-MIB", "appnLocalTgIntersubnet"), ("APPN-MIB", "appnLocalTgDlcData"), ("APPN-MIB", "appnLocalTgEffCap"), ("APPN-MIB", "appnLocalTgUsr2"), ("APPN-MIB", "appnLocalTgConnCost"), ("APPN-MIB", "appnLocalTgHprSup"), ("APPN-MIB", "appnLocalTgByteCost"), ("APPN-MIB", "appnLocalTgDestVirtual"), ("APPN-MIB", "appnLocalTgCpCpSession"), ("APPN-MIB", "appnLocalTgSecurity"), ("APPN-MIB", "appnLocalTgDelay"), ("APPN-MIB", "appnLocalTgUsr1"), ) )
if mibBuilder.loadTexts: appnLocalTgConfGroup.setDescription("A collection of objects providing the instrumentation of\nAPPN local TG information.\n\nThis RFC 2155-level group was deprecated when the\nappnLocalTgMltgLinkType object was added.")
appnDirTableConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 5)).setObjects(*(("APPN-MIB", "appnDirType"), ("APPN-MIB", "appnDirNnServerName"), ("APPN-MIB", "appnDirLuOwnerName"), ("APPN-MIB", "appnDirLuLocation"), ) )
if mibBuilder.loadTexts: appnDirTableConfGroup.setDescription("A collection of objects providing the instrumentation of the\nAPPN directory database.\n\nThis RFC 2155-level group was deprecated when the\nappnDirApparentLuOwnerName object was added.")
appnNnUniqueConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 6)).setObjects(*(("APPN-MIB", "appnNodeNnIsr"), ("APPN-MIB", "appnNodeNnCentralDirectory"), ("APPN-MIB", "appnNodeNnIsrDepleted"), ("APPN-MIB", "appnNodeNnRouteAddResist"), ("APPN-MIB", "appnNodeNnInterchangeSup"), ("APPN-MIB", "appnNodeNnPeriBorderSup"), ("APPN-MIB", "appnNodeNnRsn"), ("APPN-MIB", "appnNodeNnQuiescing"), ("APPN-MIB", "appnNodeNnSafeStoreFreq"), ("APPN-MIB", "appnNodeNnExteBorderSup"), ("APPN-MIB", "appnNodeNnTreeCache"), ("APPN-MIB", "appnNodeNnFrsn"), ("APPN-MIB", "appnNodeNnCongested"), ("APPN-MIB", "appnNodeNnGateway"), ) )
if mibBuilder.loadTexts: appnNnUniqueConfGroup.setDescription("A collection of objects providing instrumentation unique\nto APPN network nodes.")
appnEnUniqueConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 7)).setObjects(*(("APPN-MIB", "appnNodeEnModeCosMap"), ("APPN-MIB", "appnNodeEnLuSearch"), ("APPN-MIB", "appnNodeEnNnServer"), ) )
if mibBuilder.loadTexts: appnEnUniqueConfGroup.setDescription("A collection of objects providing instrumentation for\nAPPN end nodes.  Some of these objects also appear in the\ninstrumentation for a branch network node.")
appnVrnConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 8)).setObjects(*(("APPN-MIB", "appnVrnPortName"), ) )
if mibBuilder.loadTexts: appnVrnConfGroup.setDescription("An object providing the instrumentation for virtual\nrouting node support in an APPN node.")
appnNnTopoConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 9)).setObjects(*(("APPN-MIB", "appnNnTgFRDestHprTrans"), ("APPN-MIB", "appnNnTgFRDestVirtual"), ("APPN-MIB", "appnNnTgFREntryTimeLeft"), ("APPN-MIB", "appnNnNodeFRRouteAddResist"), ("APPN-MIB", "appnNnTgFRRsn"), ("APPN-MIB", "appnNnNodeFRQuiescing"), ("APPN-MIB", "appnNnNodeFRCentralDirectory"), ("APPN-MIB", "appnNnTgFRUsr3"), ("APPN-MIB", "appnNnTopoTgPurges"), ("APPN-MIB", "appnNnTgFREffCap"), ("APPN-MIB", "appnNnNodeFRGateway"), ("APPN-MIB", "appnNnTopoCurNumNodes"), ("APPN-MIB", "appnNnTgFRSecurity"), ("APPN-MIB", "appnNnNodeFRIsrDepleted"), ("APPN-MIB", "appnNnTgFRHprSup"), ("APPN-MIB", "appnNnTgFRTypeIndicator"), ("APPN-MIB", "appnNnTgFRUsr1"), ("APPN-MIB", "appnNnNodeFRHprSupport"), ("APPN-MIB", "appnNnTgFRIntersubnet"), ("APPN-MIB", "appnNnNodeFRPeriBorderSup"), ("APPN-MIB", "appnNnTgFRDlcData"), ("APPN-MIB", "appnNnNodeFRRsn"), ("APPN-MIB", "appnNnTopoMaxNodes"), ("APPN-MIB", "appnNnTgFRGarbageCollect"), ("APPN-MIB", "appnNnNodeFRGarbageCollect"), ("APPN-MIB", "appnNnTgFROperational"), ("APPN-MIB", "appnNnTgFRUsr2"), ("APPN-MIB", "appnNnTgFRByteCost"), ("APPN-MIB", "appnNnTgFRCpCpSession"), ("APPN-MIB", "appnNnTopoNodePurges"), ("APPN-MIB", "appnNnTgFRSubareaNum"), ("APPN-MIB", "appnNnTopoTotalTduWars"), ("APPN-MIB", "appnNnNodeFREntryTimeLeft"), ("APPN-MIB", "appnNnNodeFRInterchangeSup"), ("APPN-MIB", "appnNnTgFRDelay"), ("APPN-MIB", "appnNnNodeFRType"), ("APPN-MIB", "appnNnNodeFRIsr"), ("APPN-MIB", "appnNnNodeFRCongested"), ("APPN-MIB", "appnNnTgFRConnCost"), ("APPN-MIB", "appnNnNodeFRExteBorderSup"), ("APPN-MIB", "appnNnTgFRQuiescing"), ) )
if mibBuilder.loadTexts: appnNnTopoConfGroup.setDescription("The appnNnTopoConfGroup is mandatory only for network\nnodes.\n\nThis RFC 2155-level group was deprecated when the\nappnNnNodeFRBranchAwareness, appnNnTgFRMltgLinkType, and\nappnNnFRBranchTg objects were added.")
appnLocalEnTopoConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 10)).setObjects(*(("APPN-MIB", "appnLocalEnTgDestVirtual"), ("APPN-MIB", "appnLocalEnTgDlcData"), ("APPN-MIB", "appnLocalEnTgDelay"), ("APPN-MIB", "appnLocalEnTgConnCost"), ("APPN-MIB", "appnLocalEnTgEntryTimeLeft"), ("APPN-MIB", "appnLocalEnTgCpCpSession"), ("APPN-MIB", "appnLocalEnTgUsr3"), ("APPN-MIB", "appnLocalEnTgUsr2"), ("APPN-MIB", "appnLocalEnTgUsr1"), ("APPN-MIB", "appnLocalEnTgEffCap"), ("APPN-MIB", "appnLocalEnTgByteCost"), ("APPN-MIB", "appnLocalEnTgOperational"), ("APPN-MIB", "appnLocalEnTgSecurity"), ) )
if mibBuilder.loadTexts: appnLocalEnTopoConfGroup.setDescription("The appnLocalEnTopoConfGroup is mandatory only for network\nnodes.\n\nThis RFC 2155-level group was deprecated when the\nappnLocalEnTgMltgLinkType object was added.")
appnLocalDirPerfConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 11)).setObjects(*(("APPN-MIB", "appnDirInBcastLocates"), ("APPN-MIB", "appnDirCurHomeEntries"), ("APPN-MIB", "appnDirNotFoundBcastLocates"), ("APPN-MIB", "appnDirMaxCaches"), ("APPN-MIB", "appnDirRegEntries"), ("APPN-MIB", "appnDirCurCaches"), ("APPN-MIB", "appnDirNotFoundLocates"), ("APPN-MIB", "appnDirInLocates"), ("APPN-MIB", "appnDirLocateOutstands"), ("APPN-MIB", "appnDirOutBcastLocates"), ("APPN-MIB", "appnDirOutLocates"), ) )
if mibBuilder.loadTexts: appnLocalDirPerfConfGroup.setDescription("The appnLocalDirPerfConfGroup is mandatory only for APPN\nnetwork nodes and end nodes.")
appnCosConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 12)).setObjects(*(("APPN-MIB", "appnCosTgRowEffCapMin"), ("APPN-MIB", "appnCosTgRowUsr3Min"), ("APPN-MIB", "appnCosTgRowSecurityMax"), ("APPN-MIB", "appnCosTransPriority"), ("APPN-MIB", "appnCosTgRowConnCostMax"), ("APPN-MIB", "appnCosTgRowSecurityMin"), ("APPN-MIB", "appnCosTgRowUsr2Max"), ("APPN-MIB", "appnCosNodeRowWgt"), ("APPN-MIB", "appnCosTgRowConnCostMin"), ("APPN-MIB", "appnCosTgRowUsr1Min"), ("APPN-MIB", "appnCosTgRowDelayMin"), ("APPN-MIB", "appnCosNodeRowMaxCongestAllow"), ("APPN-MIB", "appnCosNodeRowResistMax"), ("APPN-MIB", "appnCosTgRowByteCostMin"), ("APPN-MIB", "appnCosTgRowUsr2Min"), ("APPN-MIB", "appnCosNodeRowResistMin"), ("APPN-MIB", "appnCosModeCosName"), ("APPN-MIB", "appnCosTgRowDelayMax"), ("APPN-MIB", "appnCosTgRowUsr1Max"), ("APPN-MIB", "appnCosTgRowEffCapMax"), ("APPN-MIB", "appnCosTgRowUsr3Max"), ("APPN-MIB", "appnCosTgRowByteCostMax"), ("APPN-MIB", "appnCosNodeRowMinCongestAllow"), ("APPN-MIB", "appnCosTgRowWgt"), ) )
if mibBuilder.loadTexts: appnCosConfGroup.setDescription("The appnCosConfGroup is mandatory only for APPN network\nnodes and end nodes.")
appnIntSessConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 13)).setObjects(*(("APPN-MIB", "appnIsInGlobeCtrOperStatus"), ("APPN-MIB", "appnIsInSsAdjCpName"), ("APPN-MIB", "appnIsInGlobeCtrStatusTime"), ("APPN-MIB", "appnIsInSessType"), ("APPN-MIB", "appnIsInP2SNonFmdPius"), ("APPN-MIB", "appnIsInGlobeCtrAdminStatus"), ("APPN-MIB", "appnIsInSecLuName"), ("APPN-MIB", "appnIsInSsRecvRpc"), ("APPN-MIB", "appnIsInP2SNonFmdBytes"), ("APPN-MIB", "appnIsInPsSendPacingType"), ("APPN-MIB", "appnIsInSsAdjTgNum"), ("APPN-MIB", "appnIsInCtrUpTime"), ("APPN-MIB", "appnIsInPriLuName"), ("APPN-MIB", "appnIsInGlobeActSess"), ("APPN-MIB", "appnIsInPsRecvPacingType"), ("APPN-MIB", "appnIsInModeName"), ("APPN-MIB", "appnIsInP2SFmdPius"), ("APPN-MIB", "appnIsInS2PNonFmdBytes"), ("APPN-MIB", "appnIsInS2PFmdBytes"), ("APPN-MIB", "appnIsInPsRecvNxWndwSize"), ("APPN-MIB", "appnIsInPsSendMaxBtuSize"), ("APPN-MIB", "appnIsInSsRecvPacingType"), ("APPN-MIB", "appnIsInS2PNonFmdPius"), ("APPN-MIB", "appnIsInSsSendNxWndwSize"), ("APPN-MIB", "appnIsInPsRecvRpc"), ("APPN-MIB", "appnIsInGlobeRscvTime"), ("APPN-MIB", "appnIsInSessState"), ("APPN-MIB", "appnIsInS2PFmdPius"), ("APPN-MIB", "appnIsInSsRecvNxWndwSize"), ("APPN-MIB", "appnIsInPsSendNxWndwSize"), ("APPN-MIB", "appnIsInP2SFmdBytes"), ("APPN-MIB", "appnIsInPsSendRpc"), ("APPN-MIB", "appnIsInSsSendPacingType"), ("APPN-MIB", "appnIsInPsAdjTgNum"), ("APPN-MIB", "appnIsInSsSendMaxBtuSize"), ("APPN-MIB", "appnIsInCosName"), ("APPN-MIB", "appnIsInSessUpTime"), ("APPN-MIB", "appnIsInSsSendRpc"), ("APPN-MIB", "appnIsInGlobeRscv"), ("APPN-MIB", "appnIsInPsAdjCpName"), ("APPN-MIB", "appnIsInRouteInfo"), ("APPN-MIB", "appnIsInTransPriority"), ) )
if mibBuilder.loadTexts: appnIntSessConfGroup.setDescription("The appnIntSessConfGroup is mandatory only for network\nnodes.")
appnHprBaseConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 14)).setObjects(*(("APPN-MIB", "appnNodeHprIntRteRejects"), ("APPN-MIB", "appnLsRevAnrLabel"), ("APPN-MIB", "appnLsErrRecoSup"), ("APPN-MIB", "appnNodeHprIntRteSetups"), ("APPN-MIB", "appnLsForAnrLabel"), ) )
if mibBuilder.loadTexts: appnHprBaseConfGroup.setDescription("The appnHprBaseConfGroup is mandatory only for nodes that\nimplement the HPR base (APPN option set 1400).")
appnHprRtpConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 15)).setObjects(*(("APPN-MIB", "appnNodeHprOrgRteRejects"), ("APPN-MIB", "appnNodeHprOrgRteSetups"), ("APPN-MIB", "appnLsBfNceId"), ("APPN-MIB", "appnNodeHprEndRteRejects"), ("APPN-MIB", "appnNodeHprEndRteSetups"), ("APPN-MIB", "appnNodeMaxSessPerRtpConn"), ) )
if mibBuilder.loadTexts: appnHprRtpConfGroup.setDescription("The appnHprRtpConfGroup is mandatory only for nodes that\nimplement the HPR RTP tower (APPN option set 1401).")
appnHprCtrlFlowsRtpConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 16)).setObjects(*(("APPN-MIB", "appnLsCpCpNceId"), ("APPN-MIB", "appnLsRouteNceId"), ) )
if mibBuilder.loadTexts: appnHprCtrlFlowsRtpConfGroup.setDescription("The appnHprCtrlFlowsRtpConfGroup is mandatory only for nodes\nthat implement the HPR Control Flows over RTP tower (APPN\noption set 1402).")
appnHprBfConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 17)).setObjects(*(("APPN-MIB", "appnIsInGlobeHprBfActSess"), ("APPN-MIB", "appnIsRtpSessions"), ("APPN-MIB", "appnIsInRtpTcid"), ("APPN-MIB", "appnIsInRtpNceId"), ) )
if mibBuilder.loadTexts: appnHprBfConfGroup.setDescription("The appnHprBfConfGroup is mandatory only for nodes that\nimplement the APPN/HPR boundary function.")
appnTrapConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 18)).setObjects(*(("APPN-MIB", "alertIdNumber"), ("APPN-MIB", "affectedObject"), ) )
if mibBuilder.loadTexts: appnTrapConfGroup.setDescription("The appnTrapConfGroup is optional for all APPN nodes.  Nodes\nimplementing this group shall also implement the\nappnTrapNotifGroup.")
appnTrapNotifGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 19)).setObjects(*(("APPN-MIB", "alertTrap"), ) )
if mibBuilder.loadTexts: appnTrapNotifGroup.setDescription("The appnTrapNotifGroup is optional for all APPN nodes.\nNodes implementing this group shall also implement the\nappnTrapConfGroup.")
appnBrNnConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 20)).setObjects(*(("APPN-MIB", "appnNodeEnLuSearch"), ("APPN-MIB", "appnLocalTgBranchLinkType"), ("APPN-MIB", "appnNodeEnNnServer"), ) )
if mibBuilder.loadTexts: appnBrNnConfGroup.setDescription("A collection of objects providing instrumentation for\nbranch network nodes.  Some of these objects also appear\nin the instrumentation for an end node.\n\nNote:  A branch network node always returns endNode(2)\nas the value of the appnNodeType object from the\nappnGeneralConfGroup2 conformance group.")
appnGeneralConfGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 26)).setObjects(*(("APPN-MIB", "appnNodeAdaptiveBindPacing"), ("APPN-MIB", "appnNodeType"), ("APPN-MIB", "appnNodeCpName"), ("APPN-MIB", "appnNodeHprSupport"), ("APPN-MIB", "appnNodeParallelTg"), ("APPN-MIB", "appnNodeUpTime"), ("APPN-MIB", "appnNodeCounterDisconTime"), ("APPN-MIB", "appnNodeBrNn"), ("APPN-MIB", "appnNodeId"), ("APPN-MIB", "appnNodeLsCounterType"), ) )
if mibBuilder.loadTexts: appnGeneralConfGroup2.setDescription("A collection of objects providing the instrumentation of\nAPPN general information and capabilities.")
appnLinkConfGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 27)).setObjects(*(("APPN-MIB", "appnLsLimResource"), ("APPN-MIB", "appnLsCurrentDelay"), ("APPN-MIB", "appnLsLocalAddr"), ("APPN-MIB", "appnLsStatusLsName"), ("APPN-MIB", "appnLsCounterDisconTime"), ("APPN-MIB", "appnLsCurrentStateTime"), ("APPN-MIB", "appnLsPartnerNodeId"), ("APPN-MIB", "appnLsOutXidFrames"), ("APPN-MIB", "appnLsStatusXidBitInError"), ("APPN-MIB", "appnLsAdjCpName"), ("APPN-MIB", "appnLsStatusXidRemoteSense"), ("APPN-MIB", "appnLsMinDelay"), ("APPN-MIB", "appnLsStatusRetry"), ("APPN-MIB", "appnLsAdjNodeType"), ("APPN-MIB", "appnLsCpCpSessionSupport"), ("APPN-MIB", "appnLsStatusGeneralSense"), ("APPN-MIB", "appnLsInXidFrames"), ("APPN-MIB", "appnLsMaxSendBtuSize"), ("APPN-MIB", "appnLsCommand"), ("APPN-MIB", "appnLsDynamic"), ("APPN-MIB", "appnLsSpecific"), ("APPN-MIB", "appnLsGoodXids"), ("APPN-MIB", "appnLsTgNum"), ("APPN-MIB", "appnLsStatusXidByteInError"), ("APPN-MIB", "appnLsDlcType"), ("APPN-MIB", "appnLsStatusDlcType"), ("APPN-MIB", "appnLsPortName"), ("APPN-MIB", "appnLsOutMsgFrames"), ("APPN-MIB", "appnLsOutXidBytes"), ("APPN-MIB", "appnLsMltgMember"), ("APPN-MIB", "appnLsBadXids"), ("APPN-MIB", "appnLsMaxDelay"), ("APPN-MIB", "appnLsStatusXidLocalSense"), ("APPN-MIB", "appnLsStatusEndSense"), ("APPN-MIB", "appnLsStatusPartnerId"), ("APPN-MIB", "appnLsRemoteLsName"), ("APPN-MIB", "appnLsMigration"), ("APPN-MIB", "appnLsStatusRemoteAddr"), ("APPN-MIB", "appnLsOperState"), ("APPN-MIB", "appnLsStatusTime"), ("APPN-MIB", "appnLsStatusTgNum"), ("APPN-MIB", "appnLsMaxDelayTime"), ("APPN-MIB", "appnLsEchoRsps"), ("APPN-MIB", "appnLsActiveTime"), ("APPN-MIB", "appnLsStatusLocalAddr"), ("APPN-MIB", "appnLsInXidBytes"), ("APPN-MIB", "appnLsStatusCpName"), ("APPN-MIB", "appnLsHprSup"), ("APPN-MIB", "appnLsInMsgBytes"), ("APPN-MIB", "appnLsActOnDemand"), ("APPN-MIB", "appnLsInMsgFrames"), ("APPN-MIB", "appnLsOutMsgBytes"), ("APPN-MIB", "appnLsRemoteAddr"), ) )
if mibBuilder.loadTexts: appnLinkConfGroup2.setDescription("A collection of objects providing the instrumentation of\nAPPN link information.")
appnLocalTgConfGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 28)).setObjects(*(("APPN-MIB", "appnLocalTgOperational"), ("APPN-MIB", "appnLocalTgQuiescing"), ("APPN-MIB", "appnLocalTgPortName"), ("APPN-MIB", "appnLocalTgUsr3"), ("APPN-MIB", "appnLocalTgIntersubnet"), ("APPN-MIB", "appnLocalTgDlcData"), ("APPN-MIB", "appnLocalTgEffCap"), ("APPN-MIB", "appnLocalTgMltgLinkType"), ("APPN-MIB", "appnLocalTgUsr2"), ("APPN-MIB", "appnLocalTgConnCost"), ("APPN-MIB", "appnLocalTgHprSup"), ("APPN-MIB", "appnLocalTgByteCost"), ("APPN-MIB", "appnLocalTgDestVirtual"), ("APPN-MIB", "appnLocalTgCpCpSession"), ("APPN-MIB", "appnLocalTgSecurity"), ("APPN-MIB", "appnLocalTgDelay"), ("APPN-MIB", "appnLocalTgUsr1"), ) )
if mibBuilder.loadTexts: appnLocalTgConfGroup2.setDescription("A collection of objects providing the instrumentation of\nAPPN local TG information.")
appnDirTableConfGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 29)).setObjects(*(("APPN-MIB", "appnDirType"), ("APPN-MIB", "appnDirNnServerName"), ("APPN-MIB", "appnDirApparentLuOwnerName"), ("APPN-MIB", "appnDirLuOwnerName"), ("APPN-MIB", "appnDirLuLocation"), ) )
if mibBuilder.loadTexts: appnDirTableConfGroup2.setDescription("A collection of objects providing the instrumentation of the\nAPPN directory database.")
appnNnTopoConfGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 30)).setObjects(*(("APPN-MIB", "appnNnNodeFRRouteAddResist"), ("APPN-MIB", "appnNnTgFRHprSup"), ("APPN-MIB", "appnNnTgFRBranchTg"), ("APPN-MIB", "appnNnTgFREffCap"), ("APPN-MIB", "appnNnTopoCurNumNodes"), ("APPN-MIB", "appnNnNodeFRIsrDepleted"), ("APPN-MIB", "appnNnTgFRMltgLinkType"), ("APPN-MIB", "appnNnTgFRGarbageCollect"), ("APPN-MIB", "appnNnTgFRDestVirtual"), ("APPN-MIB", "appnNnTgFRSubareaNum"), ("APPN-MIB", "appnNnTgFRDestHprTrans"), ("APPN-MIB", "appnNnNodeFRCentralDirectory"), ("APPN-MIB", "appnNnNodeFRGateway"), ("APPN-MIB", "appnNnTgFRByteCost"), ("APPN-MIB", "appnNnTopoTotalTduWars"), ("APPN-MIB", "appnNnNodeFREntryTimeLeft"), ("APPN-MIB", "appnNnTgFRIntersubnet"), ("APPN-MIB", "appnNnTgFRRsn"), ("APPN-MIB", "appnNnTgFRSecurity"), ("APPN-MIB", "appnNnTgFRTypeIndicator"), ("APPN-MIB", "appnNnTgFRDlcData"), ("APPN-MIB", "appnNnTgFREntryTimeLeft"), ("APPN-MIB", "appnNnNodeFRGarbageCollect"), ("APPN-MIB", "appnNnTgFROperational"), ("APPN-MIB", "appnNnTgFRUsr2"), ("APPN-MIB", "appnNnTgFRUsr3"), ("APPN-MIB", "appnNnTgFRUsr1"), ("APPN-MIB", "appnNnTgFRConnCost"), ("APPN-MIB", "appnNnTgFRDelay"), ("APPN-MIB", "appnNnNodeFRType"), ("APPN-MIB", "appnNnNodeFRIsr"), ("APPN-MIB", "appnNnTgFRQuiescing"), ("APPN-MIB", "appnNnNodeFRRsn"), ("APPN-MIB", "appnNnNodeFRInterchangeSup"), ("APPN-MIB", "appnNnNodeFRQuiescing"), ("APPN-MIB", "appnNnTopoTgPurges"), ("APPN-MIB", "appnNnNodeFRHprSupport"), ("APPN-MIB", "appnNnNodeFRPeriBorderSup"), ("APPN-MIB", "appnNnTopoMaxNodes"), ("APPN-MIB", "appnNnTgFRCpCpSession"), ("APPN-MIB", "appnNnTopoNodePurges"), ("APPN-MIB", "appnNnNodeFRBranchAwareness"), ("APPN-MIB", "appnNnNodeFRCongested"), ("APPN-MIB", "appnNnNodeFRExteBorderSup"), ) )
if mibBuilder.loadTexts: appnNnTopoConfGroup2.setDescription("The appnNnTopoConfGroup is mandatory only for network\nnodes.")
appnLocalEnTopoConfGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 4, 3, 2, 31)).setObjects(*(("APPN-MIB", "appnLocalEnTgDestVirtual"), ("APPN-MIB", "appnLocalEnTgDlcData"), ("APPN-MIB", "appnLocalEnTgDelay"), ("APPN-MIB", "appnLocalEnTgConnCost"), ("APPN-MIB", "appnLocalEnTgEntryTimeLeft"), ("APPN-MIB", "appnLocalEnTgMltgLinkType"), ("APPN-MIB", "appnLocalEnTgCpCpSession"), ("APPN-MIB", "appnLocalEnTgUsr3"), ("APPN-MIB", "appnLocalEnTgUsr2"), ("APPN-MIB", "appnLocalEnTgUsr1"), ("APPN-MIB", "appnLocalEnTgEffCap"), ("APPN-MIB", "appnLocalEnTgByteCost"), ("APPN-MIB", "appnLocalEnTgOperational"), ("APPN-MIB", "appnLocalEnTgSecurity"), ) )
if mibBuilder.loadTexts: appnLocalEnTopoConfGroup2.setDescription("A collection of objects providing the instrumentation\nof the information that a network node possesses about\nthe end nodes directly attached to it.")

# Compliances

appnCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 34, 4, 3, 1, 1)).setObjects(*(("APPN-MIB", "appnTrapNotifGroup"), ("APPN-MIB", "appnLocalDirPerfConfGroup"), ("APPN-MIB", "appnEnUniqueConfGroup"), ("APPN-MIB", "appnHprBfConfGroup"), ("APPN-MIB", "appnNnTopoConfGroup"), ("APPN-MIB", "appnIntSessConfGroup"), ("APPN-MIB", "appnLinkConfGroup"), ("APPN-MIB", "appnGeneralConfGroup"), ("APPN-MIB", "appnCosConfGroup"), ("APPN-MIB", "appnLocalTgConfGroup"), ("APPN-MIB", "appnNnUniqueConfGroup"), ("APPN-MIB", "appnHprCtrlFlowsRtpConfGroup"), ("APPN-MIB", "appnVrnConfGroup"), ("APPN-MIB", "appnPortConfGroup"), ("APPN-MIB", "appnHprRtpConfGroup"), ("APPN-MIB", "appnDirTableConfGroup"), ("APPN-MIB", "appnTrapConfGroup"), ("APPN-MIB", "appnLocalEnTopoConfGroup"), ("APPN-MIB", "appnHprBaseConfGroup"), ) )
if mibBuilder.loadTexts: appnCompliance.setDescription("The compliance statement for the SNMPv2 entities that\nimplement the APPN MIB.\n\nThis is the compliance statement for the RFC 2155-level version\nof the APPN MIB.  It was deprecated as new objects were added\nto the MIB for MLTG, branch network node, and other extensions\nto the APPN architecture.")
appnCompliance2 = ModuleCompliance((1, 3, 6, 1, 2, 1, 34, 4, 3, 1, 3)).setObjects(*(("APPN-MIB", "appnTrapNotifGroup"), ("APPN-MIB", "appnLocalDirPerfConfGroup"), ("APPN-MIB", "appnEnUniqueConfGroup"), ("APPN-MIB", "appnHprBfConfGroup"), ("APPN-MIB", "appnBrNnConfGroup"), ("APPN-MIB", "appnHprBaseConfGroup"), ("APPN-MIB", "appnGeneralConfGroup2"), ("APPN-MIB", "appnTrapConfGroup"), ("APPN-MIB", "appnLocalTgConfGroup2"), ("APPN-MIB", "appnCosConfGroup"), ("APPN-MIB", "appnIntSessConfGroup"), ("APPN-MIB", "appnHprCtrlFlowsRtpConfGroup"), ("APPN-MIB", "appnNnUniqueConfGroup"), ("APPN-MIB", "appnLinkConfGroup2"), ("APPN-MIB", "appnVrnConfGroup"), ("APPN-MIB", "appnLocalEnTopoConfGroup2"), ("APPN-MIB", "appnPortConfGroup"), ("APPN-MIB", "appnHprRtpConfGroup"), ("APPN-MIB", "appnNnTopoConfGroup2"), ("APPN-MIB", "appnDirTableConfGroup2"), ) )
if mibBuilder.loadTexts: appnCompliance2.setDescription("The compliance statement for the SNMPv2 entities that\nimplement the APPN MIB.\n\nIn the descriptions for the conditionally mandatory groups that\nfollow, the branch network node is treated as a third node type,\nparallel to network node and end node.  This is not how branch\nnetwork nodes are treated in the base APPN architecture, but it\nincreases clarity here to do it.")

# Exports

# Module identity
mibBuilder.exportSymbols("APPN-MIB", PYSNMP_MODULE_ID=appnMIB)

# Types
mibBuilder.exportSymbols("APPN-MIB", AppnTgDelay=AppnTgDelay, AppnTgDlcData=AppnTgDlcData, AppnTgEffectiveCapacity=AppnTgEffectiveCapacity, AppnTgSecurity=AppnTgSecurity, AppnTopologyEntryTimeLeft=AppnTopologyEntryTimeLeft, DisplayableDlcAddress=DisplayableDlcAddress, SnaClassOfServiceName=SnaClassOfServiceName, SnaControlPointName=SnaControlPointName, SnaModeName=SnaModeName, SnaNodeIdentification=SnaNodeIdentification, SnaSenseData=SnaSenseData, AppnLinkStationCounter=AppnLinkStationCounter, AppnNodeCounter=AppnNodeCounter, AppnPortCounter=AppnPortCounter)

# Objects
mibBuilder.exportSymbols("APPN-MIB", appnMIB=appnMIB, appnObjects=appnObjects, appnNode=appnNode, appnGeneralInfoAndCaps=appnGeneralInfoAndCaps, appnNodeCpName=appnNodeCpName, appnNodeMibVersion=appnNodeMibVersion, appnNodeId=appnNodeId, appnNodeType=appnNodeType, appnNodeUpTime=appnNodeUpTime, appnNodeParallelTg=appnNodeParallelTg, appnNodeAdaptiveBindPacing=appnNodeAdaptiveBindPacing, appnNodeHprSupport=appnNodeHprSupport, appnNodeMaxSessPerRtpConn=appnNodeMaxSessPerRtpConn, appnNodeHprIntRteSetups=appnNodeHprIntRteSetups, appnNodeHprIntRteRejects=appnNodeHprIntRteRejects, appnNodeHprOrgRteSetups=appnNodeHprOrgRteSetups, appnNodeHprOrgRteRejects=appnNodeHprOrgRteRejects, appnNodeHprEndRteSetups=appnNodeHprEndRteSetups, appnNodeHprEndRteRejects=appnNodeHprEndRteRejects, appnNodeCounterDisconTime=appnNodeCounterDisconTime, appnNodeLsCounterType=appnNodeLsCounterType, appnNodeBrNn=appnNodeBrNn, appnNnUniqueInfoAndCaps=appnNnUniqueInfoAndCaps, appnNodeNnCentralDirectory=appnNodeNnCentralDirectory, appnNodeNnTreeCache=appnNodeNnTreeCache, appnNodeNnRouteAddResist=appnNodeNnRouteAddResist, appnNodeNnIsr=appnNodeNnIsr, appnNodeNnFrsn=appnNodeNnFrsn, appnNodeNnPeriBorderSup=appnNodeNnPeriBorderSup, appnNodeNnInterchangeSup=appnNodeNnInterchangeSup, appnNodeNnExteBorderSup=appnNodeNnExteBorderSup, appnNodeNnSafeStoreFreq=appnNodeNnSafeStoreFreq, appnNodeNnRsn=appnNodeNnRsn, appnNodeNnCongested=appnNodeNnCongested, appnNodeNnIsrDepleted=appnNodeNnIsrDepleted, appnNodeNnQuiescing=appnNodeNnQuiescing, appnNodeNnGateway=appnNodeNnGateway, appnEnUniqueCaps=appnEnUniqueCaps, appnNodeEnModeCosMap=appnNodeEnModeCosMap, appnNodeEnNnServer=appnNodeEnNnServer, appnNodeEnLuSearch=appnNodeEnLuSearch, appnPortInformation=appnPortInformation, appnPortTable=appnPortTable, appnPortEntry=appnPortEntry, appnPortName=appnPortName, appnPortCommand=appnPortCommand, appnPortOperState=appnPortOperState, appnPortDlcType=appnPortDlcType, appnPortPortType=appnPortPortType, appnPortSIMRIM=appnPortSIMRIM, appnPortLsRole=appnPortLsRole, appnPortNegotLs=appnPortNegotLs, appnPortDynamicLinkSupport=appnPortDynamicLinkSupport, appnPortMaxRcvBtuSize=appnPortMaxRcvBtuSize, appnPortMaxIframeWindow=appnPortMaxIframeWindow, appnPortDefLsGoodXids=appnPortDefLsGoodXids, appnPortDefLsBadXids=appnPortDefLsBadXids, appnPortDynLsGoodXids=appnPortDynLsGoodXids, appnPortDynLsBadXids=appnPortDynLsBadXids, appnPortSpecific=appnPortSpecific, appnPortDlcLocalAddr=appnPortDlcLocalAddr, appnPortCounterDisconTime=appnPortCounterDisconTime, appnLinkStationInformation=appnLinkStationInformation, appnLsTable=appnLsTable, appnLsEntry=appnLsEntry, appnLsName=appnLsName, appnLsCommand=appnLsCommand, appnLsOperState=appnLsOperState, appnLsPortName=appnLsPortName, appnLsDlcType=appnLsDlcType, appnLsDynamic=appnLsDynamic, appnLsAdjCpName=appnLsAdjCpName, appnLsAdjNodeType=appnLsAdjNodeType, appnLsTgNum=appnLsTgNum, appnLsLimResource=appnLsLimResource, appnLsActOnDemand=appnLsActOnDemand, appnLsMigration=appnLsMigration, appnLsPartnerNodeId=appnLsPartnerNodeId, appnLsCpCpSessionSupport=appnLsCpCpSessionSupport, appnLsMaxSendBtuSize=appnLsMaxSendBtuSize, appnLsInXidBytes=appnLsInXidBytes, appnLsInMsgBytes=appnLsInMsgBytes, appnLsInXidFrames=appnLsInXidFrames, appnLsInMsgFrames=appnLsInMsgFrames, appnLsOutXidBytes=appnLsOutXidBytes, appnLsOutMsgBytes=appnLsOutMsgBytes, appnLsOutXidFrames=appnLsOutXidFrames, appnLsOutMsgFrames=appnLsOutMsgFrames, appnLsEchoRsps=appnLsEchoRsps, appnLsCurrentDelay=appnLsCurrentDelay, appnLsMaxDelay=appnLsMaxDelay, appnLsMinDelay=appnLsMinDelay, appnLsMaxDelayTime=appnLsMaxDelayTime, appnLsGoodXids=appnLsGoodXids, appnLsBadXids=appnLsBadXids, appnLsSpecific=appnLsSpecific, appnLsActiveTime=appnLsActiveTime, appnLsCurrentStateTime=appnLsCurrentStateTime, appnLsHprSup=appnLsHprSup, appnLsErrRecoSup=appnLsErrRecoSup, appnLsForAnrLabel=appnLsForAnrLabel, appnLsRevAnrLabel=appnLsRevAnrLabel, appnLsCpCpNceId=appnLsCpCpNceId, appnLsRouteNceId=appnLsRouteNceId, appnLsBfNceId=appnLsBfNceId, appnLsLocalAddr=appnLsLocalAddr, appnLsRemoteAddr=appnLsRemoteAddr, appnLsRemoteLsName=appnLsRemoteLsName, appnLsCounterDisconTime=appnLsCounterDisconTime, appnLsMltgMember=appnLsMltgMember, appnLsStatusTable=appnLsStatusTable, appnLsStatusEntry=appnLsStatusEntry, appnLsStatusIndex=appnLsStatusIndex, appnLsStatusTime=appnLsStatusTime, appnLsStatusLsName=appnLsStatusLsName, appnLsStatusCpName=appnLsStatusCpName, appnLsStatusPartnerId=appnLsStatusPartnerId, appnLsStatusTgNum=appnLsStatusTgNum, appnLsStatusGeneralSense=appnLsStatusGeneralSense, appnLsStatusRetry=appnLsStatusRetry, appnLsStatusEndSense=appnLsStatusEndSense, appnLsStatusXidLocalSense=appnLsStatusXidLocalSense, appnLsStatusXidRemoteSense=appnLsStatusXidRemoteSense, appnLsStatusXidByteInError=appnLsStatusXidByteInError, appnLsStatusXidBitInError=appnLsStatusXidBitInError, appnLsStatusDlcType=appnLsStatusDlcType)
mibBuilder.exportSymbols("APPN-MIB", appnLsStatusLocalAddr=appnLsStatusLocalAddr, appnLsStatusRemoteAddr=appnLsStatusRemoteAddr, appnVrnInfo=appnVrnInfo, appnVrnTable=appnVrnTable, appnVrnEntry=appnVrnEntry, appnVrnName=appnVrnName, appnVrnTgNum=appnVrnTgNum, appnVrnPortName=appnVrnPortName, appnNn=appnNn, appnNnTopo=appnNnTopo, appnNnTopoMaxNodes=appnNnTopoMaxNodes, appnNnTopoCurNumNodes=appnNnTopoCurNumNodes, appnNnTopoNodePurges=appnNnTopoNodePurges, appnNnTopoTgPurges=appnNnTopoTgPurges, appnNnTopoTotalTduWars=appnNnTopoTotalTduWars, appnNnTopology=appnNnTopology, appnNnTopologyFRTable=appnNnTopologyFRTable, appnNnTopologyFREntry=appnNnTopologyFREntry, appnNnNodeFRFrsn=appnNnNodeFRFrsn, appnNnNodeFRName=appnNnNodeFRName, appnNnNodeFREntryTimeLeft=appnNnNodeFREntryTimeLeft, appnNnNodeFRType=appnNnNodeFRType, appnNnNodeFRRsn=appnNnNodeFRRsn, appnNnNodeFRRouteAddResist=appnNnNodeFRRouteAddResist, appnNnNodeFRCongested=appnNnNodeFRCongested, appnNnNodeFRIsrDepleted=appnNnNodeFRIsrDepleted, appnNnNodeFRQuiescing=appnNnNodeFRQuiescing, appnNnNodeFRGateway=appnNnNodeFRGateway, appnNnNodeFRCentralDirectory=appnNnNodeFRCentralDirectory, appnNnNodeFRIsr=appnNnNodeFRIsr, appnNnNodeFRGarbageCollect=appnNnNodeFRGarbageCollect, appnNnNodeFRHprSupport=appnNnNodeFRHprSupport, appnNnNodeFRPeriBorderSup=appnNnNodeFRPeriBorderSup, appnNnNodeFRInterchangeSup=appnNnNodeFRInterchangeSup, appnNnNodeFRExteBorderSup=appnNnNodeFRExteBorderSup, appnNnNodeFRBranchAwareness=appnNnNodeFRBranchAwareness, appnNnTgTopologyFRTable=appnNnTgTopologyFRTable, appnNnTgTopologyFREntry=appnNnTgTopologyFREntry, appnNnTgFRFrsn=appnNnTgFRFrsn, appnNnTgFROwner=appnNnTgFROwner, appnNnTgFRDest=appnNnTgFRDest, appnNnTgFRNum=appnNnTgFRNum, appnNnTgFREntryTimeLeft=appnNnTgFREntryTimeLeft, appnNnTgFRDestVirtual=appnNnTgFRDestVirtual, appnNnTgFRDlcData=appnNnTgFRDlcData, appnNnTgFRRsn=appnNnTgFRRsn, appnNnTgFROperational=appnNnTgFROperational, appnNnTgFRQuiescing=appnNnTgFRQuiescing, appnNnTgFRCpCpSession=appnNnTgFRCpCpSession, appnNnTgFREffCap=appnNnTgFREffCap, appnNnTgFRConnCost=appnNnTgFRConnCost, appnNnTgFRByteCost=appnNnTgFRByteCost, appnNnTgFRSecurity=appnNnTgFRSecurity, appnNnTgFRDelay=appnNnTgFRDelay, appnNnTgFRUsr1=appnNnTgFRUsr1, appnNnTgFRUsr2=appnNnTgFRUsr2, appnNnTgFRUsr3=appnNnTgFRUsr3, appnNnTgFRGarbageCollect=appnNnTgFRGarbageCollect, appnNnTgFRSubareaNum=appnNnTgFRSubareaNum, appnNnTgFRHprSup=appnNnTgFRHprSup, appnNnTgFRDestHprTrans=appnNnTgFRDestHprTrans, appnNnTgFRTypeIndicator=appnNnTgFRTypeIndicator, appnNnTgFRIntersubnet=appnNnTgFRIntersubnet, appnNnTgFRMltgLinkType=appnNnTgFRMltgLinkType, appnNnTgFRBranchTg=appnNnTgFRBranchTg, appnLocalTopology=appnLocalTopology, appnLocalTgTable=appnLocalTgTable, appnLocalTgEntry=appnLocalTgEntry, appnLocalTgDest=appnLocalTgDest, appnLocalTgNum=appnLocalTgNum, appnLocalTgDestVirtual=appnLocalTgDestVirtual, appnLocalTgDlcData=appnLocalTgDlcData, appnLocalTgPortName=appnLocalTgPortName, appnLocalTgQuiescing=appnLocalTgQuiescing, appnLocalTgOperational=appnLocalTgOperational, appnLocalTgCpCpSession=appnLocalTgCpCpSession, appnLocalTgEffCap=appnLocalTgEffCap, appnLocalTgConnCost=appnLocalTgConnCost, appnLocalTgByteCost=appnLocalTgByteCost, appnLocalTgSecurity=appnLocalTgSecurity, appnLocalTgDelay=appnLocalTgDelay, appnLocalTgUsr1=appnLocalTgUsr1, appnLocalTgUsr2=appnLocalTgUsr2, appnLocalTgUsr3=appnLocalTgUsr3, appnLocalTgHprSup=appnLocalTgHprSup, appnLocalTgIntersubnet=appnLocalTgIntersubnet, appnLocalTgMltgLinkType=appnLocalTgMltgLinkType, appnLocalTgBranchLinkType=appnLocalTgBranchLinkType, appnLocalEnTgTable=appnLocalEnTgTable, appnLocalEnTgEntry=appnLocalEnTgEntry, appnLocalEnTgOrigin=appnLocalEnTgOrigin, appnLocalEnTgDest=appnLocalEnTgDest, appnLocalEnTgNum=appnLocalEnTgNum, appnLocalEnTgEntryTimeLeft=appnLocalEnTgEntryTimeLeft, appnLocalEnTgDestVirtual=appnLocalEnTgDestVirtual, appnLocalEnTgDlcData=appnLocalEnTgDlcData, appnLocalEnTgOperational=appnLocalEnTgOperational, appnLocalEnTgCpCpSession=appnLocalEnTgCpCpSession, appnLocalEnTgEffCap=appnLocalEnTgEffCap, appnLocalEnTgConnCost=appnLocalEnTgConnCost, appnLocalEnTgByteCost=appnLocalEnTgByteCost, appnLocalEnTgSecurity=appnLocalEnTgSecurity, appnLocalEnTgDelay=appnLocalEnTgDelay, appnLocalEnTgUsr1=appnLocalEnTgUsr1, appnLocalEnTgUsr2=appnLocalEnTgUsr2, appnLocalEnTgUsr3=appnLocalEnTgUsr3, appnLocalEnTgMltgLinkType=appnLocalEnTgMltgLinkType, appnDir=appnDir, appnDirPerf=appnDirPerf, appnDirMaxCaches=appnDirMaxCaches, appnDirCurCaches=appnDirCurCaches, appnDirCurHomeEntries=appnDirCurHomeEntries, appnDirRegEntries=appnDirRegEntries, appnDirInLocates=appnDirInLocates, appnDirInBcastLocates=appnDirInBcastLocates, appnDirOutLocates=appnDirOutLocates, appnDirOutBcastLocates=appnDirOutBcastLocates, appnDirNotFoundLocates=appnDirNotFoundLocates, appnDirNotFoundBcastLocates=appnDirNotFoundBcastLocates, appnDirLocateOutstands=appnDirLocateOutstands, appnDirTable=appnDirTable, appnDirEntry=appnDirEntry, appnDirLuName=appnDirLuName, appnDirNnServerName=appnDirNnServerName, appnDirLuOwnerName=appnDirLuOwnerName, appnDirLuLocation=appnDirLuLocation, appnDirType=appnDirType)
mibBuilder.exportSymbols("APPN-MIB", appnDirApparentLuOwnerName=appnDirApparentLuOwnerName, appnCos=appnCos, appnCosModeTable=appnCosModeTable, appnCosModeEntry=appnCosModeEntry, appnCosModeName=appnCosModeName, appnCosModeCosName=appnCosModeCosName, appnCosNameTable=appnCosNameTable, appnCosNameEntry=appnCosNameEntry, appnCosName=appnCosName, appnCosTransPriority=appnCosTransPriority, appnCosNodeRowTable=appnCosNodeRowTable, appnCosNodeRowEntry=appnCosNodeRowEntry, appnCosNodeRowName=appnCosNodeRowName, appnCosNodeRowIndex=appnCosNodeRowIndex, appnCosNodeRowWgt=appnCosNodeRowWgt, appnCosNodeRowResistMin=appnCosNodeRowResistMin, appnCosNodeRowResistMax=appnCosNodeRowResistMax, appnCosNodeRowMinCongestAllow=appnCosNodeRowMinCongestAllow, appnCosNodeRowMaxCongestAllow=appnCosNodeRowMaxCongestAllow, appnCosTgRowTable=appnCosTgRowTable, appnCosTgRowEntry=appnCosTgRowEntry, appnCosTgRowName=appnCosTgRowName, appnCosTgRowIndex=appnCosTgRowIndex, appnCosTgRowWgt=appnCosTgRowWgt, appnCosTgRowEffCapMin=appnCosTgRowEffCapMin, appnCosTgRowEffCapMax=appnCosTgRowEffCapMax, appnCosTgRowConnCostMin=appnCosTgRowConnCostMin, appnCosTgRowConnCostMax=appnCosTgRowConnCostMax, appnCosTgRowByteCostMin=appnCosTgRowByteCostMin, appnCosTgRowByteCostMax=appnCosTgRowByteCostMax, appnCosTgRowSecurityMin=appnCosTgRowSecurityMin, appnCosTgRowSecurityMax=appnCosTgRowSecurityMax, appnCosTgRowDelayMin=appnCosTgRowDelayMin, appnCosTgRowDelayMax=appnCosTgRowDelayMax, appnCosTgRowUsr1Min=appnCosTgRowUsr1Min, appnCosTgRowUsr1Max=appnCosTgRowUsr1Max, appnCosTgRowUsr2Min=appnCosTgRowUsr2Min, appnCosTgRowUsr2Max=appnCosTgRowUsr2Max, appnCosTgRowUsr3Min=appnCosTgRowUsr3Min, appnCosTgRowUsr3Max=appnCosTgRowUsr3Max, appnSessIntermediate=appnSessIntermediate, appnIsInGlobal=appnIsInGlobal, appnIsInGlobeCtrAdminStatus=appnIsInGlobeCtrAdminStatus, appnIsInGlobeCtrOperStatus=appnIsInGlobeCtrOperStatus, appnIsInGlobeCtrStatusTime=appnIsInGlobeCtrStatusTime, appnIsInGlobeRscv=appnIsInGlobeRscv, appnIsInGlobeRscvTime=appnIsInGlobeRscvTime, appnIsInGlobeActSess=appnIsInGlobeActSess, appnIsInGlobeHprBfActSess=appnIsInGlobeHprBfActSess, appnIsInTable=appnIsInTable, appnIsInEntry=appnIsInEntry, appnIsInFqCpName=appnIsInFqCpName, appnIsInPcid=appnIsInPcid, appnIsInSessState=appnIsInSessState, appnIsInPriLuName=appnIsInPriLuName, appnIsInSecLuName=appnIsInSecLuName, appnIsInModeName=appnIsInModeName, appnIsInCosName=appnIsInCosName, appnIsInTransPriority=appnIsInTransPriority, appnIsInSessType=appnIsInSessType, appnIsInSessUpTime=appnIsInSessUpTime, appnIsInCtrUpTime=appnIsInCtrUpTime, appnIsInP2SFmdPius=appnIsInP2SFmdPius, appnIsInS2PFmdPius=appnIsInS2PFmdPius, appnIsInP2SNonFmdPius=appnIsInP2SNonFmdPius, appnIsInS2PNonFmdPius=appnIsInS2PNonFmdPius, appnIsInP2SFmdBytes=appnIsInP2SFmdBytes, appnIsInS2PFmdBytes=appnIsInS2PFmdBytes, appnIsInP2SNonFmdBytes=appnIsInP2SNonFmdBytes, appnIsInS2PNonFmdBytes=appnIsInS2PNonFmdBytes, appnIsInPsAdjCpName=appnIsInPsAdjCpName, appnIsInPsAdjTgNum=appnIsInPsAdjTgNum, appnIsInPsSendMaxBtuSize=appnIsInPsSendMaxBtuSize, appnIsInPsSendPacingType=appnIsInPsSendPacingType, appnIsInPsSendRpc=appnIsInPsSendRpc, appnIsInPsSendNxWndwSize=appnIsInPsSendNxWndwSize, appnIsInPsRecvPacingType=appnIsInPsRecvPacingType, appnIsInPsRecvRpc=appnIsInPsRecvRpc, appnIsInPsRecvNxWndwSize=appnIsInPsRecvNxWndwSize, appnIsInSsAdjCpName=appnIsInSsAdjCpName, appnIsInSsAdjTgNum=appnIsInSsAdjTgNum, appnIsInSsSendMaxBtuSize=appnIsInSsSendMaxBtuSize, appnIsInSsSendPacingType=appnIsInSsSendPacingType, appnIsInSsSendRpc=appnIsInSsSendRpc, appnIsInSsSendNxWndwSize=appnIsInSsSendNxWndwSize, appnIsInSsRecvPacingType=appnIsInSsRecvPacingType, appnIsInSsRecvRpc=appnIsInSsRecvRpc, appnIsInSsRecvNxWndwSize=appnIsInSsRecvNxWndwSize, appnIsInRouteInfo=appnIsInRouteInfo, appnIsInRtpNceId=appnIsInRtpNceId, appnIsInRtpTcid=appnIsInRtpTcid, appnIsRtpTable=appnIsRtpTable, appnIsRtpEntry=appnIsRtpEntry, appnIsRtpNceId=appnIsRtpNceId, appnIsRtpTcid=appnIsRtpTcid, appnIsRtpSessions=appnIsRtpSessions, appnTraps=appnTraps, alertIdNumber=alertIdNumber, affectedObject=affectedObject, appnConformance=appnConformance, appnCompliances=appnCompliances, appnGroups=appnGroups)

# Notifications
mibBuilder.exportSymbols("APPN-MIB", alertTrap=alertTrap)

# Groups
mibBuilder.exportSymbols("APPN-MIB", appnGeneralConfGroup=appnGeneralConfGroup, appnPortConfGroup=appnPortConfGroup, appnLinkConfGroup=appnLinkConfGroup, appnLocalTgConfGroup=appnLocalTgConfGroup, appnDirTableConfGroup=appnDirTableConfGroup, appnNnUniqueConfGroup=appnNnUniqueConfGroup, appnEnUniqueConfGroup=appnEnUniqueConfGroup, appnVrnConfGroup=appnVrnConfGroup, appnNnTopoConfGroup=appnNnTopoConfGroup, appnLocalEnTopoConfGroup=appnLocalEnTopoConfGroup, appnLocalDirPerfConfGroup=appnLocalDirPerfConfGroup, appnCosConfGroup=appnCosConfGroup, appnIntSessConfGroup=appnIntSessConfGroup, appnHprBaseConfGroup=appnHprBaseConfGroup, appnHprRtpConfGroup=appnHprRtpConfGroup, appnHprCtrlFlowsRtpConfGroup=appnHprCtrlFlowsRtpConfGroup, appnHprBfConfGroup=appnHprBfConfGroup, appnTrapConfGroup=appnTrapConfGroup, appnTrapNotifGroup=appnTrapNotifGroup, appnBrNnConfGroup=appnBrNnConfGroup, appnGeneralConfGroup2=appnGeneralConfGroup2, appnLinkConfGroup2=appnLinkConfGroup2, appnLocalTgConfGroup2=appnLocalTgConfGroup2, appnDirTableConfGroup2=appnDirTableConfGroup2, appnNnTopoConfGroup2=appnNnTopoConfGroup2, appnLocalEnTopoConfGroup2=appnLocalEnTopoConfGroup2)

# Compliances
mibBuilder.exportSymbols("APPN-MIB", appnCompliance=appnCompliance, appnCompliance2=appnCompliance2)
