# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_discriminator, rest_field
from ._enums import ReportTypeEnum, ResponseDataTypeEnum

if TYPE_CHECKING:
    from .. import models as _models


class CarbonEmissionData(_model_base.Model):
    """The basic response for different query report, all query report result will have these
    information.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CarbonEmissionItemDetailData, CarbonEmissionMonthlySummaryData,
    CarbonEmissionOverallSummaryData, ResourceGroupCarbonEmissionItemDetailData,
    ResourceGroupCarbonEmissionTopItemMonthlySummaryData,
    ResourceGroupCarbonEmissionTopItemsSummaryData, ResourceCarbonEmissionItemDetailData,
    ResourceCarbonEmissionTopItemMonthlySummaryData, ResourceCarbonEmissionTopItemsSummaryData,
    CarbonEmissionTopItemMonthlySummaryData, CarbonEmissionTopItemsSummaryData

    :ivar data_type: The data type of the query result, indicating the format of the returned
     response. Required. Known values are: "OverallSummaryData", "MonthlySummaryData",
     "TopItemsSummaryData", "ResourceTopItemsSummaryData", "ResourceGroupTopItemsSummaryData",
     "TopItemsMonthlySummaryData", "ResourceTopItemsMonthlySummaryData",
     "ResourceGroupTopItemsMonthlySummaryData", "ItemDetailsData", "ResourceItemDetailsData", and
     "ResourceGroupItemDetailsData".
    :vartype data_type: str or ~azure.mgmt.carbonoptimization.models.ResponseDataTypeEnum
    :ivar latest_month_emissions: Total carbon emissions for the specified query parameters,
     measured in kgCO2E. This value represents total emissions over the specified date range (e.g.,
     March-June). Required.
    :vartype latest_month_emissions: float
    :ivar previous_month_emissions: Total carbon emissions for the previous month’s date range,
     which is the same period as the specified date range but shifted left by one month (e.g., if
     the specified range is March - June, the previous month’s range will be Feb - May). The value
     is measured in kgCO2E. Required.
    :vartype previous_month_emissions: float
    :ivar month_over_month_emissions_change_ratio: The percentage change in carbon emissions
     between the current and previous DateRange. This is calculated as: (latestMonthEmissions -
     previousMonthEmissions) / previousMonthEmissions.
    :vartype month_over_month_emissions_change_ratio: float
    :ivar monthly_emissions_change_value: The change in carbon emissions between the current and
     previous period, calculated as: latestMonthEmissions - previousMonthEmissions.
    :vartype monthly_emissions_change_value: float
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    data_type: str = rest_discriminator(name="dataType", visibility=["read", "create", "update", "delete", "query"])
    """The data type of the query result, indicating the format of the returned response. Required.
     Known values are: \"OverallSummaryData\", \"MonthlySummaryData\", \"TopItemsSummaryData\",
     \"ResourceTopItemsSummaryData\", \"ResourceGroupTopItemsSummaryData\",
     \"TopItemsMonthlySummaryData\", \"ResourceTopItemsMonthlySummaryData\",
     \"ResourceGroupTopItemsMonthlySummaryData\", \"ItemDetailsData\", \"ResourceItemDetailsData\",
     and \"ResourceGroupItemDetailsData\"."""
    latest_month_emissions: float = rest_field(
        name="latestMonthEmissions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total carbon emissions for the specified query parameters, measured in kgCO2E. This value
     represents total emissions over the specified date range (e.g., March-June). Required."""
    previous_month_emissions: float = rest_field(
        name="previousMonthEmissions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total carbon emissions for the previous month’s date range, which is the same period as the
     specified date range but shifted left by one month (e.g., if the specified range is March -
     June, the previous month’s range will be Feb - May). The value is measured in kgCO2E. Required."""
    month_over_month_emissions_change_ratio: Optional[float] = rest_field(
        name="monthOverMonthEmissionsChangeRatio", visibility=["read", "create", "update", "delete", "query"]
    )
    """The percentage change in carbon emissions between the current and previous DateRange. This is
     calculated as: (latestMonthEmissions - previousMonthEmissions) / previousMonthEmissions."""
    monthly_emissions_change_value: Optional[float] = rest_field(
        name="monthlyEmissionsChangeValue", visibility=["read", "create", "update", "delete", "query"]
    )
    """The change in carbon emissions between the current and previous period, calculated as:
     latestMonthEmissions - previousMonthEmissions."""

    @overload
    def __init__(
        self,
        *,
        data_type: str,
        latest_month_emissions: float,
        previous_month_emissions: float,
        month_over_month_emissions_change_ratio: Optional[float] = None,
        monthly_emissions_change_value: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CarbonEmissionDataAvailableDateRange(_model_base.Model):
    """Response for available date range of carbon emission data.

    :ivar start_date: Start date parameter, format is yyyy-MM-dd. Required.
    :vartype start_date: str
    :ivar end_date: End date parameter, format is yyyy-MM-dd. Required.
    :vartype end_date: str
    """

    start_date: str = rest_field(name="startDate", visibility=["read", "create", "update", "delete", "query"])
    """Start date parameter, format is yyyy-MM-dd. Required."""
    end_date: str = rest_field(name="endDate", visibility=["read", "create", "update", "delete", "query"])
    """End date parameter, format is yyyy-MM-dd. Required."""

    @overload
    def __init__(
        self,
        *,
        start_date: str,
        end_date: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CarbonEmissionDataListResult(_model_base.Model):
    """List of carbon emission results.

    :ivar value: The CarbonEmissionData items on this page. Required.
    :vartype value: list[~azure.mgmt.carbonoptimization.models.CarbonEmissionData]
    :ivar skip_token: The pagination token to fetch next page data, it's null or empty if it
     doesn't have next page data.
    :vartype skip_token: str
    :ivar subscription_access_decision_list: The access decision list for each input subscription.
    :vartype subscription_access_decision_list:
     list[~azure.mgmt.carbonoptimization.models.SubscriptionAccessDecision]
    """

    value: List["_models.CarbonEmissionData"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The CarbonEmissionData items on this page. Required."""
    skip_token: Optional[str] = rest_field(name="skipToken", visibility=["read", "create", "update", "delete", "query"])
    """The pagination token to fetch next page data, it's null or empty if it doesn't have next page
     data."""
    subscription_access_decision_list: Optional[List["_models.SubscriptionAccessDecision"]] = rest_field(
        name="subscriptionAccessDecisionList", visibility=["read", "create", "update", "delete", "query"]
    )
    """The access decision list for each input subscription."""

    @overload
    def __init__(
        self,
        *,
        value: List["_models.CarbonEmissionData"],
        skip_token: Optional[str] = None,
        subscription_access_decision_list: Optional[List["_models.SubscriptionAccessDecision"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CarbonEmissionItemDetailData(CarbonEmissionData, discriminator="ItemDetailsData"):
    """Response for detailed carbon emissions.

    :ivar latest_month_emissions: Total carbon emissions for the specified query parameters,
     measured in kgCO2E. This value represents total emissions over the specified date range (e.g.,
     March-June). Required.
    :vartype latest_month_emissions: float
    :ivar previous_month_emissions: Total carbon emissions for the previous month’s date range,
     which is the same period as the specified date range but shifted left by one month (e.g., if
     the specified range is March - June, the previous month’s range will be Feb - May). The value
     is measured in kgCO2E. Required.
    :vartype previous_month_emissions: float
    :ivar month_over_month_emissions_change_ratio: The percentage change in carbon emissions
     between the current and previous DateRange. This is calculated as: (latestMonthEmissions -
     previousMonthEmissions) / previousMonthEmissions.
    :vartype month_over_month_emissions_change_ratio: float
    :ivar monthly_emissions_change_value: The change in carbon emissions between the current and
     previous period, calculated as: latestMonthEmissions - previousMonthEmissions.
    :vartype monthly_emissions_change_value: float
    :ivar data_type: Item details data. Required. The response data type for ItemDetailsReport
    :vartype data_type: str or ~azure.mgmt.carbonoptimization.models.ITEM_DETAILS_DATA
    :ivar item_name: Item name, it can be resource name, resource type name, location, resource
     group name or subscriptionId. It depends on category type. Required.
    :vartype item_name: str
    :ivar category_type: Item category, see supported type value defined in CategoryTypeEnum.
     Required. Known values are: "Subscription", "ResourceGroup", "Location", "Resource", and
     "ResourceType".
    :vartype category_type: str or ~azure.mgmt.carbonoptimization.models.CategoryTypeEnum
    """

    data_type: Literal[ResponseDataTypeEnum.ITEM_DETAILS_DATA] = rest_discriminator(name="dataType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Item details data. Required. The response data type for ItemDetailsReport"""
    item_name: str = rest_field(name="itemName", visibility=["read", "create", "update", "delete", "query"])
    """Item name, it can be resource name, resource type name, location, resource group name or
     subscriptionId. It depends on category type. Required."""
    category_type: Union[str, "_models.CategoryTypeEnum"] = rest_field(
        name="categoryType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Item category, see supported type value defined in CategoryTypeEnum. Required. Known values
     are: \"Subscription\", \"ResourceGroup\", \"Location\", \"Resource\", and \"ResourceType\"."""

    @overload
    def __init__(
        self,
        *,
        latest_month_emissions: float,
        previous_month_emissions: float,
        item_name: str,
        category_type: Union[str, "_models.CategoryTypeEnum"],
        month_over_month_emissions_change_ratio: Optional[float] = None,
        monthly_emissions_change_value: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, data_type=ResponseDataTypeEnum.ITEM_DETAILS_DATA, **kwargs)


class CarbonEmissionMonthlySummaryData(CarbonEmissionData, discriminator="MonthlySummaryData"):
    """Response for Monthly Carbon Emissions Summary.

    :ivar latest_month_emissions: Total carbon emissions for the specified query parameters,
     measured in kgCO2E. This value represents total emissions over the specified date range (e.g.,
     March-June). Required.
    :vartype latest_month_emissions: float
    :ivar previous_month_emissions: Total carbon emissions for the previous month’s date range,
     which is the same period as the specified date range but shifted left by one month (e.g., if
     the specified range is March - June, the previous month’s range will be Feb - May). The value
     is measured in kgCO2E. Required.
    :vartype previous_month_emissions: float
    :ivar month_over_month_emissions_change_ratio: The percentage change in carbon emissions
     between the current and previous DateRange. This is calculated as: (latestMonthEmissions -
     previousMonthEmissions) / previousMonthEmissions.
    :vartype month_over_month_emissions_change_ratio: float
    :ivar monthly_emissions_change_value: The change in carbon emissions between the current and
     previous period, calculated as: latestMonthEmissions - previousMonthEmissions.
    :vartype monthly_emissions_change_value: float
    :ivar data_type: Monthly summary data. Required. The response data type for
     MonthlySummaryReport
    :vartype data_type: str or ~azure.mgmt.carbonoptimization.models.MONTHLY_SUMMARY_DATA
    :ivar date: The date, representing the month, for which the emissions data is reported,
     formatted as yyyy-MM-dd (e.g., 2024-03-01). Required.
    :vartype date: str
    :ivar carbon_intensity: Carbon intensity for the specified month, typically in units of kgCO2E
     per unit of normalized usage. Required.
    :vartype carbon_intensity: float
    """

    data_type: Literal[ResponseDataTypeEnum.MONTHLY_SUMMARY_DATA] = rest_discriminator(name="dataType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Monthly summary data. Required. The response data type for MonthlySummaryReport"""
    date: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The date, representing the month, for which the emissions data is reported, formatted as
     yyyy-MM-dd (e.g., 2024-03-01). Required."""
    carbon_intensity: float = rest_field(
        name="carbonIntensity", visibility=["read", "create", "update", "delete", "query"]
    )
    """Carbon intensity for the specified month, typically in units of kgCO2E per unit of normalized
     usage. Required."""

    @overload
    def __init__(
        self,
        *,
        latest_month_emissions: float,
        previous_month_emissions: float,
        date: str,
        carbon_intensity: float,
        month_over_month_emissions_change_ratio: Optional[float] = None,
        monthly_emissions_change_value: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, data_type=ResponseDataTypeEnum.MONTHLY_SUMMARY_DATA, **kwargs)


class CarbonEmissionOverallSummaryData(CarbonEmissionData, discriminator="OverallSummaryData"):
    """Response for Overall Carbon Emissions Summary.

    :ivar latest_month_emissions: Total carbon emissions for the specified query parameters,
     measured in kgCO2E. This value represents total emissions over the specified date range (e.g.,
     March-June). Required.
    :vartype latest_month_emissions: float
    :ivar previous_month_emissions: Total carbon emissions for the previous month’s date range,
     which is the same period as the specified date range but shifted left by one month (e.g., if
     the specified range is March - June, the previous month’s range will be Feb - May). The value
     is measured in kgCO2E. Required.
    :vartype previous_month_emissions: float
    :ivar month_over_month_emissions_change_ratio: The percentage change in carbon emissions
     between the current and previous DateRange. This is calculated as: (latestMonthEmissions -
     previousMonthEmissions) / previousMonthEmissions.
    :vartype month_over_month_emissions_change_ratio: float
    :ivar monthly_emissions_change_value: The change in carbon emissions between the current and
     previous period, calculated as: latestMonthEmissions - previousMonthEmissions.
    :vartype monthly_emissions_change_value: float
    :ivar data_type: Overall summary data. Required. The response data type for
     OverallSummaryReport
    :vartype data_type: str or ~azure.mgmt.carbonoptimization.models.OVERALL_SUMMARY_DATA
    """

    data_type: Literal[ResponseDataTypeEnum.OVERALL_SUMMARY_DATA] = rest_discriminator(name="dataType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Overall summary data. Required. The response data type for OverallSummaryReport"""

    @overload
    def __init__(
        self,
        *,
        latest_month_emissions: float,
        previous_month_emissions: float,
        month_over_month_emissions_change_ratio: Optional[float] = None,
        monthly_emissions_change_value: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, data_type=ResponseDataTypeEnum.OVERALL_SUMMARY_DATA, **kwargs)


class CarbonEmissionTopItemMonthlySummaryData(CarbonEmissionData, discriminator="TopItemsMonthlySummaryData"):
    """Response for Top Items Carbon Emissions by Month.

    :ivar latest_month_emissions: Total carbon emissions for the specified query parameters,
     measured in kgCO2E. This value represents total emissions over the specified date range (e.g.,
     March-June). Required.
    :vartype latest_month_emissions: float
    :ivar previous_month_emissions: Total carbon emissions for the previous month’s date range,
     which is the same period as the specified date range but shifted left by one month (e.g., if
     the specified range is March - June, the previous month’s range will be Feb - May). The value
     is measured in kgCO2E. Required.
    :vartype previous_month_emissions: float
    :ivar month_over_month_emissions_change_ratio: The percentage change in carbon emissions
     between the current and previous DateRange. This is calculated as: (latestMonthEmissions -
     previousMonthEmissions) / previousMonthEmissions.
    :vartype month_over_month_emissions_change_ratio: float
    :ivar monthly_emissions_change_value: The change in carbon emissions between the current and
     previous period, calculated as: latestMonthEmissions - previousMonthEmissions.
    :vartype monthly_emissions_change_value: float
    :ivar data_type: Top items Monthly summary data. Required. The response data type for
     TopItemsMonthlySummaryReport
    :vartype data_type: str or ~azure.mgmt.carbonoptimization.models.TOP_ITEMS_MONTHLY_SUMMARY_DATA
    :ivar item_name: Item name, it can be resource name, resource type name, location, resource
     group name or subscriptionId. It depends on category type. Required.
    :vartype item_name: str
    :ivar category_type: Item category, see supported type value defined in CategoryTypeEnum.
     Required. Known values are: "Subscription", "ResourceGroup", "Location", "Resource", and
     "ResourceType".
    :vartype category_type: str or ~azure.mgmt.carbonoptimization.models.CategoryTypeEnum
    :ivar date: The date, representing the month, for which the emissions data is reported,
     formatted as yyyy-MM-dd (e.g., 2024-03-01). Required.
    :vartype date: str
    """

    data_type: Literal[ResponseDataTypeEnum.TOP_ITEMS_MONTHLY_SUMMARY_DATA] = rest_discriminator(name="dataType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Top items Monthly summary data. Required. The response data type for
     TopItemsMonthlySummaryReport"""
    item_name: str = rest_field(name="itemName", visibility=["read", "create", "update", "delete", "query"])
    """Item name, it can be resource name, resource type name, location, resource group name or
     subscriptionId. It depends on category type. Required."""
    category_type: Union[str, "_models.CategoryTypeEnum"] = rest_field(
        name="categoryType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Item category, see supported type value defined in CategoryTypeEnum. Required. Known values
     are: \"Subscription\", \"ResourceGroup\", \"Location\", \"Resource\", and \"ResourceType\"."""
    date: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The date, representing the month, for which the emissions data is reported, formatted as
     yyyy-MM-dd (e.g., 2024-03-01). Required."""

    @overload
    def __init__(
        self,
        *,
        latest_month_emissions: float,
        previous_month_emissions: float,
        item_name: str,
        category_type: Union[str, "_models.CategoryTypeEnum"],
        date: str,
        month_over_month_emissions_change_ratio: Optional[float] = None,
        monthly_emissions_change_value: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, data_type=ResponseDataTypeEnum.TOP_ITEMS_MONTHLY_SUMMARY_DATA, **kwargs)


class CarbonEmissionTopItemsSummaryData(CarbonEmissionData, discriminator="TopItemsSummaryData"):
    """Response for Top Items by Category Type.

    :ivar latest_month_emissions: Total carbon emissions for the specified query parameters,
     measured in kgCO2E. This value represents total emissions over the specified date range (e.g.,
     March-June). Required.
    :vartype latest_month_emissions: float
    :ivar previous_month_emissions: Total carbon emissions for the previous month’s date range,
     which is the same period as the specified date range but shifted left by one month (e.g., if
     the specified range is March - June, the previous month’s range will be Feb - May). The value
     is measured in kgCO2E. Required.
    :vartype previous_month_emissions: float
    :ivar month_over_month_emissions_change_ratio: The percentage change in carbon emissions
     between the current and previous DateRange. This is calculated as: (latestMonthEmissions -
     previousMonthEmissions) / previousMonthEmissions.
    :vartype month_over_month_emissions_change_ratio: float
    :ivar monthly_emissions_change_value: The change in carbon emissions between the current and
     previous period, calculated as: latestMonthEmissions - previousMonthEmissions.
    :vartype monthly_emissions_change_value: float
    :ivar data_type: Top items summary data. Required. The response data type for
     TopItemsSummaryReport
    :vartype data_type: str or ~azure.mgmt.carbonoptimization.models.TOP_ITEMS_SUMMARY_DATA
    :ivar item_name: The identifier of the item being reported on, which could refer to the
     resource name, resource type name, location, resource group name, or subscription ID, depending
     on the specified category type. Required.
    :vartype item_name: str
    :ivar category_type: The category type of the item. This defines which dimension the emissions
     are aggregated by, and the supported values are defined in CategoryTypeEnum (e.g.,
     Subscription, ResourceGroup, Resource, etc.). Required. Known values are: "Subscription",
     "ResourceGroup", "Location", "Resource", and "ResourceType".
    :vartype category_type: str or ~azure.mgmt.carbonoptimization.models.CategoryTypeEnum
    """

    data_type: Literal[ResponseDataTypeEnum.TOP_ITEMS_SUMMARY_DATA] = rest_discriminator(name="dataType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Top items summary data. Required. The response data type for TopItemsSummaryReport"""
    item_name: str = rest_field(name="itemName", visibility=["read", "create", "update", "delete", "query"])
    """The identifier of the item being reported on, which could refer to the resource name, resource
     type name, location, resource group name, or subscription ID, depending on the specified
     category type. Required."""
    category_type: Union[str, "_models.CategoryTypeEnum"] = rest_field(
        name="categoryType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The category type of the item. This defines which dimension the emissions are aggregated by,
     and the supported values are defined in CategoryTypeEnum (e.g., Subscription, ResourceGroup,
     Resource, etc.). Required. Known values are: \"Subscription\", \"ResourceGroup\", \"Location\",
     \"Resource\", and \"ResourceType\"."""

    @overload
    def __init__(
        self,
        *,
        latest_month_emissions: float,
        previous_month_emissions: float,
        item_name: str,
        category_type: Union[str, "_models.CategoryTypeEnum"],
        month_over_month_emissions_change_ratio: Optional[float] = None,
        monthly_emissions_change_value: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, data_type=ResponseDataTypeEnum.TOP_ITEMS_SUMMARY_DATA, **kwargs)


class DateRange(_model_base.Model):
    """Date range to be used with QueryParameter, it should be within 12 months between start and end
    date. In certain cases, start and end dates must be the same date.

    :ivar start: Start date parameter in yyyy-MM-01 format. Only the first day of each month is
     accepted. Required.
    :vartype start: ~datetime.date
    :ivar end: End date parameter in yyyy-MM-01 format. Only the first day of each month is
     accepted. Required.
    :vartype end: ~datetime.date
    """

    start: datetime.date = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Start date parameter in yyyy-MM-01 format. Only the first day of each month is accepted.
     Required."""
    end: datetime.date = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """End date parameter in yyyy-MM-01 format. Only the first day of each month is accepted.
     Required."""

    @overload
    def __init__(
        self,
        *,
        start: datetime.date,
        end: datetime.date,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_model_base.Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_model_base.Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.carbonoptimization.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.carbonoptimization.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_model_base.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.carbonoptimization.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QueryFilter(_model_base.Model):
    """Shared query filter parameter to configure carbon emissions data queries for all different
    report type defined in ReportTypeEnum.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ItemDetailsQueryFilter, MonthlySummaryReportQueryFilter, OverallSummaryReportQueryFilter,
    TopItemsMonthlySummaryReportQueryFilter, TopItemsSummaryReportQueryFilter

    :ivar report_type: The ReportType requested for carbon emissions data. Required. Specifies how
     data is aggregated and displayed in the output, as explained in the ReportTypeEnum. Required.
     Known values are: "OverallSummaryReport", "MonthlySummaryReport", "TopItemsSummaryReport",
     "TopItemsMonthlySummaryReport", and "ItemDetailsReport".
    :vartype report_type: str or ~azure.mgmt.carbonoptimization.models.ReportTypeEnum
    :ivar date_range: The start and end dates for carbon emissions data. Required. For
     ItemDetailsReport and TopItemsSummaryReport, only one month of data is supported at a time, so
     start and end dates should be equal within DateRange (e.g., start: 2024-06-01 and end:
     2024-06-01). Required.
    :vartype date_range: ~azure.mgmt.carbonoptimization.models.DateRange
    :ivar subscription_list: List of subscription IDs for which carbon emissions data is requested.
     Required. Each subscription ID should be in lowercase format. The max length of list is 100.
     Required.
    :vartype subscription_list: list[str]
    :ivar resource_group_url_list: List of resource group URLs for carbon emissions data. Optional.
     Each URL must follow the format
     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroup}', and should be in all
     lowercase.
    :vartype resource_group_url_list: list[str]
    :ivar resource_type_list: List of resource types for carbon emissions data. Optional. Each
     resource type should be specified in lowercase, following the format
     'microsoft.{service}/{resourceType}', e.g., 'microsoft.storage/storageaccounts'.
    :vartype resource_type_list: list[str]
    :ivar location_list: List of locations(Azure Region Display Name) for carbon emissions data,
     with each location specified in lowercase (e.g., 'east us'). Optional. You can use the command
     'az account list-locations -o table' to find Azure Region Display Names.
    :vartype location_list: list[str]
    :ivar carbon_scope_list: List of carbon emission scopes. Required. Accepts one or more values
     from EmissionScopeEnum (e.g., Scope1, Scope2, Scope3) in list form. The output will include the
     total emissions for the specified scopes. Required.
    :vartype carbon_scope_list: list[str or
     ~azure.mgmt.carbonoptimization.models.EmissionScopeEnum]
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    report_type: str = rest_discriminator(name="reportType", visibility=["read", "create", "update", "delete", "query"])
    """The ReportType requested for carbon emissions data. Required. Specifies how data is aggregated
     and displayed in the output, as explained in the ReportTypeEnum. Required. Known values are:
     \"OverallSummaryReport\", \"MonthlySummaryReport\", \"TopItemsSummaryReport\",
     \"TopItemsMonthlySummaryReport\", and \"ItemDetailsReport\"."""
    date_range: "_models.DateRange" = rest_field(
        name="dateRange", visibility=["read", "create", "update", "delete", "query"]
    )
    """The start and end dates for carbon emissions data. Required. For ItemDetailsReport and
     TopItemsSummaryReport, only one month of data is supported at a time, so start and end dates
     should be equal within DateRange (e.g., start: 2024-06-01 and end: 2024-06-01). Required."""
    subscription_list: List[str] = rest_field(
        name="subscriptionList", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of subscription IDs for which carbon emissions data is requested. Required. Each
     subscription ID should be in lowercase format. The max length of list is 100. Required."""
    resource_group_url_list: Optional[List[str]] = rest_field(
        name="resourceGroupUrlList", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of resource group URLs for carbon emissions data. Optional. Each URL must follow the
     format '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroup}', and should be in all
     lowercase."""
    resource_type_list: Optional[List[str]] = rest_field(
        name="resourceTypeList", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of resource types for carbon emissions data. Optional. Each resource type should be
     specified in lowercase, following the format 'microsoft.{service}/{resourceType}', e.g.,
     'microsoft.storage/storageaccounts'."""
    location_list: Optional[List[str]] = rest_field(
        name="locationList", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of locations(Azure Region Display Name) for carbon emissions data, with each location
     specified in lowercase (e.g., 'east us'). Optional. You can use the command 'az account
     list-locations -o table' to find Azure Region Display Names."""
    carbon_scope_list: List[Union[str, "_models.EmissionScopeEnum"]] = rest_field(
        name="carbonScopeList", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of carbon emission scopes. Required. Accepts one or more values from EmissionScopeEnum
     (e.g., Scope1, Scope2, Scope3) in list form. The output will include the total emissions for
     the specified scopes. Required."""

    @overload
    def __init__(
        self,
        *,
        report_type: str,
        date_range: "_models.DateRange",
        subscription_list: List[str],
        carbon_scope_list: List[Union[str, "_models.EmissionScopeEnum"]],
        resource_group_url_list: Optional[List[str]] = None,
        resource_type_list: Optional[List[str]] = None,
        location_list: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ItemDetailsQueryFilter(QueryFilter, discriminator="ItemDetailsReport"):
    """Query Parameters for ItemDetailsReport.

    :ivar date_range: The start and end dates for carbon emissions data. Required. For
     ItemDetailsReport and TopItemsSummaryReport, only one month of data is supported at a time, so
     start and end dates should be equal within DateRange (e.g., start: 2024-06-01 and end:
     2024-06-01). Required.
    :vartype date_range: ~azure.mgmt.carbonoptimization.models.DateRange
    :ivar subscription_list: List of subscription IDs for which carbon emissions data is requested.
     Required. Each subscription ID should be in lowercase format. The max length of list is 100.
     Required.
    :vartype subscription_list: list[str]
    :ivar resource_group_url_list: List of resource group URLs for carbon emissions data. Optional.
     Each URL must follow the format
     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroup}', and should be in all
     lowercase.
    :vartype resource_group_url_list: list[str]
    :ivar resource_type_list: List of resource types for carbon emissions data. Optional. Each
     resource type should be specified in lowercase, following the format
     'microsoft.{service}/{resourceType}', e.g., 'microsoft.storage/storageaccounts'.
    :vartype resource_type_list: list[str]
    :ivar location_list: List of locations(Azure Region Display Name) for carbon emissions data,
     with each location specified in lowercase (e.g., 'east us'). Optional. You can use the command
     'az account list-locations -o table' to find Azure Region Display Names.
    :vartype location_list: list[str]
    :ivar carbon_scope_list: List of carbon emission scopes. Required. Accepts one or more values
     from EmissionScopeEnum (e.g., Scope1, Scope2, Scope3) in list form. The output will include the
     total emissions for the specified scopes. Required.
    :vartype carbon_scope_list: list[str or
     ~azure.mgmt.carbonoptimization.models.EmissionScopeEnum]
    :ivar report_type: Specifies that the report type is an item details report for granular carbon
     emissions data. This is a paginated report. Required. ItemDetailsReport provides a granular
     list of items based on the specified CategoryType (e.g., Resource, ResourceGroup, ResourceType,
     Location, or Subscription) for the query filter. This report can be queried for only one month
     at a time, requiring the same values in the start and end fields within DateRange.
    :vartype report_type: str or ~azure.mgmt.carbonoptimization.models.ITEM_DETAILS_REPORT
    :ivar category_type: Specifies the category type for detailed emissions data, such as Resource,
     ResourceGroup, ResourceType, Location, or Subscription. See supported types in
     CategoryTypeEnum. Required. Known values are: "Subscription", "ResourceGroup", "Location",
     "Resource", and "ResourceType".
    :vartype category_type: str or ~azure.mgmt.carbonoptimization.models.CategoryTypeEnum
    :ivar order_by: The column name to order the results by. See supported values in
     OrderByColumnEnum. Required. Known values are: "ItemName", "LatestMonthEmissions",
     "PreviousMonthEmissions", "MonthOverMonthEmissionsChangeRatio", "MonthlyEmissionsChangeValue",
     and "ResourceGroup".
    :vartype order_by: str or ~azure.mgmt.carbonoptimization.models.OrderByColumnEnum
    :ivar sort_direction: Direction for sorting results. See supported values in SortDirectionEnum.
     Required. Known values are: "Desc" and "Asc".
    :vartype sort_direction: str or ~azure.mgmt.carbonoptimization.models.SortDirectionEnum
    :ivar page_size: Number of items to return in one request, max value is 5000. Required.
    :vartype page_size: int
    :ivar skip_token: Pagination token for fetching the next page of data. This token is nullable
     and will be returned in the previous response if additional data pages are available.
    :vartype skip_token: str
    """

    report_type: Literal[ReportTypeEnum.ITEM_DETAILS_REPORT] = rest_discriminator(name="reportType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Specifies that the report type is an item details report for granular carbon emissions data.
     This is a paginated report. Required. ItemDetailsReport provides a granular list of items based
     on the specified CategoryType (e.g., Resource, ResourceGroup, ResourceType, Location, or
     Subscription) for the query filter. This report can be queried for only one month at a time,
     requiring the same values in the start and end fields within DateRange."""
    category_type: Union[str, "_models.CategoryTypeEnum"] = rest_field(
        name="categoryType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the category type for detailed emissions data, such as Resource, ResourceGroup,
     ResourceType, Location, or Subscription. See supported types in CategoryTypeEnum. Required.
     Known values are: \"Subscription\", \"ResourceGroup\", \"Location\", \"Resource\", and
     \"ResourceType\"."""
    order_by: Union[str, "_models.OrderByColumnEnum"] = rest_field(
        name="orderBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The column name to order the results by. See supported values in OrderByColumnEnum. Required.
     Known values are: \"ItemName\", \"LatestMonthEmissions\", \"PreviousMonthEmissions\",
     \"MonthOverMonthEmissionsChangeRatio\", \"MonthlyEmissionsChangeValue\", and \"ResourceGroup\"."""
    sort_direction: Union[str, "_models.SortDirectionEnum"] = rest_field(
        name="sortDirection", visibility=["read", "create", "update", "delete", "query"]
    )
    """Direction for sorting results. See supported values in SortDirectionEnum. Required. Known
     values are: \"Desc\" and \"Asc\"."""
    page_size: int = rest_field(name="pageSize", visibility=["read", "create", "update", "delete", "query"])
    """Number of items to return in one request, max value is 5000. Required."""
    skip_token: Optional[str] = rest_field(name="skipToken", visibility=["read", "create", "update", "delete", "query"])
    """Pagination token for fetching the next page of data. This token is nullable and will be
     returned in the previous response if additional data pages are available."""

    @overload
    def __init__(
        self,
        *,
        date_range: "_models.DateRange",
        subscription_list: List[str],
        carbon_scope_list: List[Union[str, "_models.EmissionScopeEnum"]],
        category_type: Union[str, "_models.CategoryTypeEnum"],
        order_by: Union[str, "_models.OrderByColumnEnum"],
        sort_direction: Union[str, "_models.SortDirectionEnum"],
        page_size: int,
        resource_group_url_list: Optional[List[str]] = None,
        resource_type_list: Optional[List[str]] = None,
        location_list: Optional[List[str]] = None,
        skip_token: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, report_type=ReportTypeEnum.ITEM_DETAILS_REPORT, **kwargs)


class MonthlySummaryReportQueryFilter(QueryFilter, discriminator="MonthlySummaryReport"):
    """Query filter parameter to configure MonthlySummaryReport queries.

    :ivar date_range: The start and end dates for carbon emissions data. Required. For
     ItemDetailsReport and TopItemsSummaryReport, only one month of data is supported at a time, so
     start and end dates should be equal within DateRange (e.g., start: 2024-06-01 and end:
     2024-06-01). Required.
    :vartype date_range: ~azure.mgmt.carbonoptimization.models.DateRange
    :ivar subscription_list: List of subscription IDs for which carbon emissions data is requested.
     Required. Each subscription ID should be in lowercase format. The max length of list is 100.
     Required.
    :vartype subscription_list: list[str]
    :ivar resource_group_url_list: List of resource group URLs for carbon emissions data. Optional.
     Each URL must follow the format
     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroup}', and should be in all
     lowercase.
    :vartype resource_group_url_list: list[str]
    :ivar resource_type_list: List of resource types for carbon emissions data. Optional. Each
     resource type should be specified in lowercase, following the format
     'microsoft.{service}/{resourceType}', e.g., 'microsoft.storage/storageaccounts'.
    :vartype resource_type_list: list[str]
    :ivar location_list: List of locations(Azure Region Display Name) for carbon emissions data,
     with each location specified in lowercase (e.g., 'east us'). Optional. You can use the command
     'az account list-locations -o table' to find Azure Region Display Names.
    :vartype location_list: list[str]
    :ivar carbon_scope_list: List of carbon emission scopes. Required. Accepts one or more values
     from EmissionScopeEnum (e.g., Scope1, Scope2, Scope3) in list form. The output will include the
     total emissions for the specified scopes. Required.
    :vartype carbon_scope_list: list[str or
     ~azure.mgmt.carbonoptimization.models.EmissionScopeEnum]
    :ivar report_type: Specifies that the report type is a monthly summary report for carbon
     emissions data. Required. MonthlySummaryReport provides carbon emissions data by month for the
     specified query parameters. This report type can accept different values in the start and end
     fields within DateRange (e.g., start: 2024-03-01 and end: 2024-06-01).
    :vartype report_type: str or ~azure.mgmt.carbonoptimization.models.MONTHLY_SUMMARY_REPORT
    """

    report_type: Literal[ReportTypeEnum.MONTHLY_SUMMARY_REPORT] = rest_discriminator(name="reportType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Specifies that the report type is a monthly summary report for carbon emissions data. Required.
     MonthlySummaryReport provides carbon emissions data by month for the specified query
     parameters. This report type can accept different values in the start and end fields within
     DateRange (e.g., start: 2024-03-01 and end: 2024-06-01)."""

    @overload
    def __init__(
        self,
        *,
        date_range: "_models.DateRange",
        subscription_list: List[str],
        carbon_scope_list: List[Union[str, "_models.EmissionScopeEnum"]],
        resource_group_url_list: Optional[List[str]] = None,
        resource_type_list: Optional[List[str]] = None,
        location_list: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, report_type=ReportTypeEnum.MONTHLY_SUMMARY_REPORT, **kwargs)


class Operation(_model_base.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.carbonoptimization.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.carbonoptimization.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.carbonoptimization.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_model_base.Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class OverallSummaryReportQueryFilter(QueryFilter, discriminator="OverallSummaryReport"):
    """Query filter parameter to configure OverallSummaryReport queries.

    :ivar date_range: The start and end dates for carbon emissions data. Required. For
     ItemDetailsReport and TopItemsSummaryReport, only one month of data is supported at a time, so
     start and end dates should be equal within DateRange (e.g., start: 2024-06-01 and end:
     2024-06-01). Required.
    :vartype date_range: ~azure.mgmt.carbonoptimization.models.DateRange
    :ivar subscription_list: List of subscription IDs for which carbon emissions data is requested.
     Required. Each subscription ID should be in lowercase format. The max length of list is 100.
     Required.
    :vartype subscription_list: list[str]
    :ivar resource_group_url_list: List of resource group URLs for carbon emissions data. Optional.
     Each URL must follow the format
     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroup}', and should be in all
     lowercase.
    :vartype resource_group_url_list: list[str]
    :ivar resource_type_list: List of resource types for carbon emissions data. Optional. Each
     resource type should be specified in lowercase, following the format
     'microsoft.{service}/{resourceType}', e.g., 'microsoft.storage/storageaccounts'.
    :vartype resource_type_list: list[str]
    :ivar location_list: List of locations(Azure Region Display Name) for carbon emissions data,
     with each location specified in lowercase (e.g., 'east us'). Optional. You can use the command
     'az account list-locations -o table' to find Azure Region Display Names.
    :vartype location_list: list[str]
    :ivar carbon_scope_list: List of carbon emission scopes. Required. Accepts one or more values
     from EmissionScopeEnum (e.g., Scope1, Scope2, Scope3) in list form. The output will include the
     total emissions for the specified scopes. Required.
    :vartype carbon_scope_list: list[str or
     ~azure.mgmt.carbonoptimization.models.EmissionScopeEnum]
    :ivar report_type: Specifies that the report type is a overall summary report for carbon
     emissions data. Required. Overall summary report provides total carbon emissions for the
     specified date range and query parameters, as well as comparative values for a high-level
     overview. This report type can accept different values in the start and end fields within
     DateRange (e.g., start: 2024-03-01 and end: 2024-06-01).
    :vartype report_type: str or ~azure.mgmt.carbonoptimization.models.OVERALL_SUMMARY_REPORT
    """

    report_type: Literal[ReportTypeEnum.OVERALL_SUMMARY_REPORT] = rest_discriminator(name="reportType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Specifies that the report type is a overall summary report for carbon emissions data. Required.
     Overall summary report provides total carbon emissions for the specified date range and query
     parameters, as well as comparative values for a high-level overview. This report type can
     accept different values in the start and end fields within DateRange (e.g., start: 2024-03-01
     and end: 2024-06-01)."""

    @overload
    def __init__(
        self,
        *,
        date_range: "_models.DateRange",
        subscription_list: List[str],
        carbon_scope_list: List[Union[str, "_models.EmissionScopeEnum"]],
        resource_group_url_list: Optional[List[str]] = None,
        resource_type_list: Optional[List[str]] = None,
        location_list: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, report_type=ReportTypeEnum.OVERALL_SUMMARY_REPORT, **kwargs)


class ResourceCarbonEmissionItemDetailData(CarbonEmissionData, discriminator="ResourceItemDetailsData"):
    """Response for Resource detailed carbon emissions.

    :ivar latest_month_emissions: Total carbon emissions for the specified query parameters,
     measured in kgCO2E. This value represents total emissions over the specified date range (e.g.,
     March-June). Required.
    :vartype latest_month_emissions: float
    :ivar previous_month_emissions: Total carbon emissions for the previous month’s date range,
     which is the same period as the specified date range but shifted left by one month (e.g., if
     the specified range is March - June, the previous month’s range will be Feb - May). The value
     is measured in kgCO2E. Required.
    :vartype previous_month_emissions: float
    :ivar month_over_month_emissions_change_ratio: The percentage change in carbon emissions
     between the current and previous DateRange. This is calculated as: (latestMonthEmissions -
     previousMonthEmissions) / previousMonthEmissions.
    :vartype month_over_month_emissions_change_ratio: float
    :ivar monthly_emissions_change_value: The change in carbon emissions between the current and
     previous period, calculated as: latestMonthEmissions - previousMonthEmissions.
    :vartype monthly_emissions_change_value: float
    :ivar data_type: ResourceGroup's item details data. Required. The response data type for
     Resource's ItemDetailsReport
    :vartype data_type: str or ~azure.mgmt.carbonoptimization.models.RESOURCE_ITEM_DETAILS_DATA
    :ivar item_name: It's resource name. Required.
    :vartype item_name: str
    :ivar category_type: Resource Item category, see supported value defined in CategoryTypeEnum.
     Required. Known values are: "Subscription", "ResourceGroup", "Location", "Resource", and
     "ResourceType".
    :vartype category_type: str or ~azure.mgmt.carbonoptimization.models.CategoryTypeEnum
    :ivar subscription_id: Subscription Id. Required.
    :vartype subscription_id: str
    :ivar resource_group: Resource Group. Required.
    :vartype resource_group: str
    :ivar resource_id: The fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
     Required.
    :vartype resource_id: str
    :ivar location: Resource Location (e.g., 'east us').
    :vartype location: str
    :ivar resource_type: The type of resource, for example: microsoft.storage/storageaccounts.
    :vartype resource_type: str
    """

    data_type: Literal[ResponseDataTypeEnum.RESOURCE_ITEM_DETAILS_DATA] = rest_discriminator(name="dataType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """ResourceGroup's item details data. Required. The response data type for Resource's
     ItemDetailsReport"""
    item_name: str = rest_field(name="itemName", visibility=["read", "create", "update", "delete", "query"])
    """It's resource name. Required."""
    category_type: Union[str, "_models.CategoryTypeEnum"] = rest_field(
        name="categoryType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource Item category, see supported value defined in CategoryTypeEnum. Required. Known values
     are: \"Subscription\", \"ResourceGroup\", \"Location\", \"Resource\", and \"ResourceType\"."""
    subscription_id: str = rest_field(name="subscriptionId", visibility=["read", "create", "update", "delete", "query"])
    """Subscription Id. Required."""
    resource_group: str = rest_field(name="resourceGroup", visibility=["read", "create", "update", "delete", "query"])
    """Resource Group. Required."""
    resource_id: str = rest_field(name="resourceId", visibility=["read", "create", "update", "delete", "query"])
    """The fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
     Required."""
    location: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource Location (e.g., 'east us')."""
    resource_type: Optional[str] = rest_field(
        name="resourceType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of resource, for example: microsoft.storage/storageaccounts."""

    @overload
    def __init__(
        self,
        *,
        latest_month_emissions: float,
        previous_month_emissions: float,
        item_name: str,
        category_type: Union[str, "_models.CategoryTypeEnum"],
        subscription_id: str,
        resource_group: str,
        resource_id: str,
        month_over_month_emissions_change_ratio: Optional[float] = None,
        monthly_emissions_change_value: Optional[float] = None,
        location: Optional[str] = None,
        resource_type: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, data_type=ResponseDataTypeEnum.RESOURCE_ITEM_DETAILS_DATA, **kwargs)


class ResourceCarbonEmissionTopItemMonthlySummaryData(
    CarbonEmissionData, discriminator="ResourceTopItemsMonthlySummaryData"
):  # pylint: disable=name-too-long
    """Response for top items carbon emissions by month for resource.

    :ivar latest_month_emissions: Total carbon emissions for the specified query parameters,
     measured in kgCO2E. This value represents total emissions over the specified date range (e.g.,
     March-June). Required.
    :vartype latest_month_emissions: float
    :ivar previous_month_emissions: Total carbon emissions for the previous month’s date range,
     which is the same period as the specified date range but shifted left by one month (e.g., if
     the specified range is March - June, the previous month’s range will be Feb - May). The value
     is measured in kgCO2E. Required.
    :vartype previous_month_emissions: float
    :ivar month_over_month_emissions_change_ratio: The percentage change in carbon emissions
     between the current and previous DateRange. This is calculated as: (latestMonthEmissions -
     previousMonthEmissions) / previousMonthEmissions.
    :vartype month_over_month_emissions_change_ratio: float
    :ivar monthly_emissions_change_value: The change in carbon emissions between the current and
     previous period, calculated as: latestMonthEmissions - previousMonthEmissions.
    :vartype monthly_emissions_change_value: float
    :ivar data_type: Resource top items Monthly summary data. Required. The response data type for
     Resource's TopItemsMonthlySummaryReport
    :vartype data_type: str or
     ~azure.mgmt.carbonoptimization.models.RESOURCE_TOP_ITEMS_MONTHLY_SUMMARY_DATA
    :ivar item_name: The resource name of resource for Resource Category. Required.
    :vartype item_name: str
    :ivar category_type: Resource Item category. Required. Known values are: "Subscription",
     "ResourceGroup", "Location", "Resource", and "ResourceType".
    :vartype category_type: str or ~azure.mgmt.carbonoptimization.models.CategoryTypeEnum
    :ivar date: Monthly date string, format is yyyy-MM-dd. Required.
    :vartype date: str
    :ivar subscription_id: Subscription Id. Required.
    :vartype subscription_id: str
    :ivar resource_group: Resource Group. Required.
    :vartype resource_group: str
    :ivar resource_id: The fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
     Required.
    :vartype resource_id: str
    """

    data_type: Literal[ResponseDataTypeEnum.RESOURCE_TOP_ITEMS_MONTHLY_SUMMARY_DATA] = rest_discriminator(name="dataType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Resource top items Monthly summary data. Required. The response data type for Resource's
     TopItemsMonthlySummaryReport"""
    item_name: str = rest_field(name="itemName", visibility=["read", "create", "update", "delete", "query"])
    """The resource name of resource for Resource Category. Required."""
    category_type: Union[str, "_models.CategoryTypeEnum"] = rest_field(
        name="categoryType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource Item category. Required. Known values are: \"Subscription\", \"ResourceGroup\",
     \"Location\", \"Resource\", and \"ResourceType\"."""
    date: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Monthly date string, format is yyyy-MM-dd. Required."""
    subscription_id: str = rest_field(name="subscriptionId", visibility=["read", "create", "update", "delete", "query"])
    """Subscription Id. Required."""
    resource_group: str = rest_field(name="resourceGroup", visibility=["read", "create", "update", "delete", "query"])
    """Resource Group. Required."""
    resource_id: str = rest_field(name="resourceId", visibility=["read", "create", "update", "delete", "query"])
    """The fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
     Required."""

    @overload
    def __init__(
        self,
        *,
        latest_month_emissions: float,
        previous_month_emissions: float,
        item_name: str,
        category_type: Union[str, "_models.CategoryTypeEnum"],
        date: str,
        subscription_id: str,
        resource_group: str,
        resource_id: str,
        month_over_month_emissions_change_ratio: Optional[float] = None,
        monthly_emissions_change_value: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, data_type=ResponseDataTypeEnum.RESOURCE_TOP_ITEMS_MONTHLY_SUMMARY_DATA, **kwargs)


class ResourceCarbonEmissionTopItemsSummaryData(
    CarbonEmissionData, discriminator="ResourceTopItemsSummaryData"
):  # pylint: disable=name-too-long
    """Response for Top Items For Resource Category.

    :ivar latest_month_emissions: Total carbon emissions for the specified query parameters,
     measured in kgCO2E. This value represents total emissions over the specified date range (e.g.,
     March-June). Required.
    :vartype latest_month_emissions: float
    :ivar previous_month_emissions: Total carbon emissions for the previous month’s date range,
     which is the same period as the specified date range but shifted left by one month (e.g., if
     the specified range is March - June, the previous month’s range will be Feb - May). The value
     is measured in kgCO2E. Required.
    :vartype previous_month_emissions: float
    :ivar month_over_month_emissions_change_ratio: The percentage change in carbon emissions
     between the current and previous DateRange. This is calculated as: (latestMonthEmissions -
     previousMonthEmissions) / previousMonthEmissions.
    :vartype month_over_month_emissions_change_ratio: float
    :ivar monthly_emissions_change_value: The change in carbon emissions between the current and
     previous period, calculated as: latestMonthEmissions - previousMonthEmissions.
    :vartype monthly_emissions_change_value: float
    :ivar data_type: Data for the top items carbon emissions summary report specific to resource
     category. Required. The response data type for Resource's TopItemsSummaryReport
    :vartype data_type: str or
     ~azure.mgmt.carbonoptimization.models.RESOURCE_TOP_ITEMS_SUMMARY_DATA
    :ivar item_name: The resource name of the resource for the Resource Category. Required.
    :vartype item_name: str
    :ivar category_type: The category type of the item. This defines which dimension the emissions
     are aggregated by, and the supported values are defined in CategoryTypeEnum (e.g.,
     Subscription, ResourceGroup, Resource, etc.). Required. Known values are: "Subscription",
     "ResourceGroup", "Location", "Resource", and "ResourceType".
    :vartype category_type: str or ~azure.mgmt.carbonoptimization.models.CategoryTypeEnum
    :ivar subscription_id: Subscription Id. Required.
    :vartype subscription_id: str
    :ivar resource_group: Resource group name. Required.
    :vartype resource_group: str
    :ivar resource_id: Resource Id, The URI of the resource for the Resource Category. This
     identifies the resource being reported. Required.
    :vartype resource_id: str
    """

    data_type: Literal[ResponseDataTypeEnum.RESOURCE_TOP_ITEMS_SUMMARY_DATA] = rest_discriminator(name="dataType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Data for the top items carbon emissions summary report specific to resource category. Required.
     The response data type for Resource's TopItemsSummaryReport"""
    item_name: str = rest_field(name="itemName", visibility=["read", "create", "update", "delete", "query"])
    """The resource name of the resource for the Resource Category. Required."""
    category_type: Union[str, "_models.CategoryTypeEnum"] = rest_field(
        name="categoryType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The category type of the item. This defines which dimension the emissions are aggregated by,
     and the supported values are defined in CategoryTypeEnum (e.g., Subscription, ResourceGroup,
     Resource, etc.). Required. Known values are: \"Subscription\", \"ResourceGroup\", \"Location\",
     \"Resource\", and \"ResourceType\"."""
    subscription_id: str = rest_field(name="subscriptionId", visibility=["read", "create", "update", "delete", "query"])
    """Subscription Id. Required."""
    resource_group: str = rest_field(name="resourceGroup", visibility=["read", "create", "update", "delete", "query"])
    """Resource group name. Required."""
    resource_id: str = rest_field(name="resourceId", visibility=["read", "create", "update", "delete", "query"])
    """Resource Id, The URI of the resource for the Resource Category. This identifies the resource
     being reported. Required."""

    @overload
    def __init__(
        self,
        *,
        latest_month_emissions: float,
        previous_month_emissions: float,
        item_name: str,
        category_type: Union[str, "_models.CategoryTypeEnum"],
        subscription_id: str,
        resource_group: str,
        resource_id: str,
        month_over_month_emissions_change_ratio: Optional[float] = None,
        monthly_emissions_change_value: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, data_type=ResponseDataTypeEnum.RESOURCE_TOP_ITEMS_SUMMARY_DATA, **kwargs)


class ResourceGroupCarbonEmissionItemDetailData(
    CarbonEmissionData, discriminator="ResourceGroupItemDetailsData"
):  # pylint: disable=name-too-long
    """Response for Resource Group detailed carbon emissions.

    :ivar latest_month_emissions: Total carbon emissions for the specified query parameters,
     measured in kgCO2E. This value represents total emissions over the specified date range (e.g.,
     March-June). Required.
    :vartype latest_month_emissions: float
    :ivar previous_month_emissions: Total carbon emissions for the previous month’s date range,
     which is the same period as the specified date range but shifted left by one month (e.g., if
     the specified range is March - June, the previous month’s range will be Feb - May). The value
     is measured in kgCO2E. Required.
    :vartype previous_month_emissions: float
    :ivar month_over_month_emissions_change_ratio: The percentage change in carbon emissions
     between the current and previous DateRange. This is calculated as: (latestMonthEmissions -
     previousMonthEmissions) / previousMonthEmissions.
    :vartype month_over_month_emissions_change_ratio: float
    :ivar monthly_emissions_change_value: The change in carbon emissions between the current and
     previous period, calculated as: latestMonthEmissions - previousMonthEmissions.
    :vartype monthly_emissions_change_value: float
    :ivar data_type: ResourceGroup item details data. Required. The response data type for
     ResourceGroup's ItemDetailsReport
    :vartype data_type: str or
     ~azure.mgmt.carbonoptimization.models.RESOURCE_GROUP_ITEM_DETAILS_DATA
    :ivar item_name: It's resource group name. Required.
    :vartype item_name: str
    :ivar category_type: ResourceGroup Item category. Required. Known values are: "Subscription",
     "ResourceGroup", "Location", "Resource", and "ResourceType".
    :vartype category_type: str or ~azure.mgmt.carbonoptimization.models.CategoryTypeEnum
    :ivar subscription_id: Subscription Id. Required.
    :vartype subscription_id: str
    :ivar resource_group_url: Resource Group url, value format is
     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroup}'. Required.
    :vartype resource_group_url: str
    """

    data_type: Literal[ResponseDataTypeEnum.RESOURCE_GROUP_ITEM_DETAILS_DATA] = rest_discriminator(name="dataType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """ResourceGroup item details data. Required. The response data type for ResourceGroup's
     ItemDetailsReport"""
    item_name: str = rest_field(name="itemName", visibility=["read", "create", "update", "delete", "query"])
    """It's resource group name. Required."""
    category_type: Union[str, "_models.CategoryTypeEnum"] = rest_field(
        name="categoryType", visibility=["read", "create", "update", "delete", "query"]
    )
    """ResourceGroup Item category. Required. Known values are: \"Subscription\", \"ResourceGroup\",
     \"Location\", \"Resource\", and \"ResourceType\"."""
    subscription_id: str = rest_field(name="subscriptionId", visibility=["read", "create", "update", "delete", "query"])
    """Subscription Id. Required."""
    resource_group_url: str = rest_field(
        name="resourceGroupUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource Group url, value format is
     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroup}'. Required."""

    @overload
    def __init__(
        self,
        *,
        latest_month_emissions: float,
        previous_month_emissions: float,
        item_name: str,
        category_type: Union[str, "_models.CategoryTypeEnum"],
        subscription_id: str,
        resource_group_url: str,
        month_over_month_emissions_change_ratio: Optional[float] = None,
        monthly_emissions_change_value: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, data_type=ResponseDataTypeEnum.RESOURCE_GROUP_ITEM_DETAILS_DATA, **kwargs)


class ResourceGroupCarbonEmissionTopItemMonthlySummaryData(
    CarbonEmissionData, discriminator="ResourceGroupTopItemsMonthlySummaryData"
):  # pylint: disable=name-too-long
    """Response for top items carbon emissions by month for resource group.

    :ivar latest_month_emissions: Total carbon emissions for the specified query parameters,
     measured in kgCO2E. This value represents total emissions over the specified date range (e.g.,
     March-June). Required.
    :vartype latest_month_emissions: float
    :ivar previous_month_emissions: Total carbon emissions for the previous month’s date range,
     which is the same period as the specified date range but shifted left by one month (e.g., if
     the specified range is March - June, the previous month’s range will be Feb - May). The value
     is measured in kgCO2E. Required.
    :vartype previous_month_emissions: float
    :ivar month_over_month_emissions_change_ratio: The percentage change in carbon emissions
     between the current and previous DateRange. This is calculated as: (latestMonthEmissions -
     previousMonthEmissions) / previousMonthEmissions.
    :vartype month_over_month_emissions_change_ratio: float
    :ivar monthly_emissions_change_value: The change in carbon emissions between the current and
     previous period, calculated as: latestMonthEmissions - previousMonthEmissions.
    :vartype monthly_emissions_change_value: float
    :ivar data_type: Resource group top items Monthly summary data. Required. The response data
     type for ResourceGroup's TopItemsMonthlySummaryReport
    :vartype data_type: str or
     ~azure.mgmt.carbonoptimization.models.RESOURCE_GROUP_TOP_ITEMS_MONTHLY_SUMMARY_DATA
    :ivar item_name: It's resource group name for ResourceGroup category. Required.
    :vartype item_name: str
    :ivar category_type: ResourceGroup Item category. Required. Known values are: "Subscription",
     "ResourceGroup", "Location", "Resource", and "ResourceType".
    :vartype category_type: str or ~azure.mgmt.carbonoptimization.models.CategoryTypeEnum
    :ivar date: Monthly date string, format is yyyy-MM-dd. Required.
    :vartype date: str
    :ivar subscription_id: Subscription Id. Required.
    :vartype subscription_id: str
    :ivar resource_group_url: Resource Group url, the format is
     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroup}'. Required.
    :vartype resource_group_url: str
    """

    data_type: Literal[ResponseDataTypeEnum.RESOURCE_GROUP_TOP_ITEMS_MONTHLY_SUMMARY_DATA] = rest_discriminator(name="dataType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Resource group top items Monthly summary data. Required. The response data type for
     ResourceGroup's TopItemsMonthlySummaryReport"""
    item_name: str = rest_field(name="itemName", visibility=["read", "create", "update", "delete", "query"])
    """It's resource group name for ResourceGroup category. Required."""
    category_type: Union[str, "_models.CategoryTypeEnum"] = rest_field(
        name="categoryType", visibility=["read", "create", "update", "delete", "query"]
    )
    """ResourceGroup Item category. Required. Known values are: \"Subscription\", \"ResourceGroup\",
     \"Location\", \"Resource\", and \"ResourceType\"."""
    date: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Monthly date string, format is yyyy-MM-dd. Required."""
    subscription_id: str = rest_field(name="subscriptionId", visibility=["read", "create", "update", "delete", "query"])
    """Subscription Id. Required."""
    resource_group_url: str = rest_field(
        name="resourceGroupUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource Group url, the format is
     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroup}'. Required."""

    @overload
    def __init__(
        self,
        *,
        latest_month_emissions: float,
        previous_month_emissions: float,
        item_name: str,
        category_type: Union[str, "_models.CategoryTypeEnum"],
        date: str,
        subscription_id: str,
        resource_group_url: str,
        month_over_month_emissions_change_ratio: Optional[float] = None,
        monthly_emissions_change_value: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, data_type=ResponseDataTypeEnum.RESOURCE_GROUP_TOP_ITEMS_MONTHLY_SUMMARY_DATA, **kwargs)


class ResourceGroupCarbonEmissionTopItemsSummaryData(
    CarbonEmissionData, discriminator="ResourceGroupTopItemsSummaryData"
):  # pylint: disable=name-too-long
    """Response for Top Items For ResourceGroup.

    :ivar latest_month_emissions: Total carbon emissions for the specified query parameters,
     measured in kgCO2E. This value represents total emissions over the specified date range (e.g.,
     March-June). Required.
    :vartype latest_month_emissions: float
    :ivar previous_month_emissions: Total carbon emissions for the previous month’s date range,
     which is the same period as the specified date range but shifted left by one month (e.g., if
     the specified range is March - June, the previous month’s range will be Feb - May). The value
     is measured in kgCO2E. Required.
    :vartype previous_month_emissions: float
    :ivar month_over_month_emissions_change_ratio: The percentage change in carbon emissions
     between the current and previous DateRange. This is calculated as: (latestMonthEmissions -
     previousMonthEmissions) / previousMonthEmissions.
    :vartype month_over_month_emissions_change_ratio: float
    :ivar monthly_emissions_change_value: The change in carbon emissions between the current and
     previous period, calculated as: latestMonthEmissions - previousMonthEmissions.
    :vartype monthly_emissions_change_value: float
    :ivar data_type: Resource group top items summary data. Required. The response data type for
     ResourceGroup's TopItemsSummaryReport
    :vartype data_type: str or
     ~azure.mgmt.carbonoptimization.models.RESOURCE_GROUP_TOP_ITEMS_SUMMARY_DATA
    :ivar item_name: The resourceGroup name of the resource for ResourceGroup Category. Required.
    :vartype item_name: str
    :ivar category_type: ResourceGroup Item category. Required. Known values are: "Subscription",
     "ResourceGroup", "Location", "Resource", and "ResourceType".
    :vartype category_type: str or ~azure.mgmt.carbonoptimization.models.CategoryTypeEnum
    :ivar subscription_id: Subscription Id. Required.
    :vartype subscription_id: str
    :ivar resource_group_url: Resource Group url, value format is
     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroup}'. Required.
    :vartype resource_group_url: str
    """

    data_type: Literal[ResponseDataTypeEnum.RESOURCE_GROUP_TOP_ITEMS_SUMMARY_DATA] = rest_discriminator(name="dataType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Resource group top items summary data. Required. The response data type for ResourceGroup's
     TopItemsSummaryReport"""
    item_name: str = rest_field(name="itemName", visibility=["read", "create", "update", "delete", "query"])
    """The resourceGroup name of the resource for ResourceGroup Category. Required."""
    category_type: Union[str, "_models.CategoryTypeEnum"] = rest_field(
        name="categoryType", visibility=["read", "create", "update", "delete", "query"]
    )
    """ResourceGroup Item category. Required. Known values are: \"Subscription\", \"ResourceGroup\",
     \"Location\", \"Resource\", and \"ResourceType\"."""
    subscription_id: str = rest_field(name="subscriptionId", visibility=["read", "create", "update", "delete", "query"])
    """Subscription Id. Required."""
    resource_group_url: str = rest_field(
        name="resourceGroupUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource Group url, value format is
     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroup}'. Required."""

    @overload
    def __init__(
        self,
        *,
        latest_month_emissions: float,
        previous_month_emissions: float,
        item_name: str,
        category_type: Union[str, "_models.CategoryTypeEnum"],
        subscription_id: str,
        resource_group_url: str,
        month_over_month_emissions_change_ratio: Optional[float] = None,
        monthly_emissions_change_value: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, data_type=ResponseDataTypeEnum.RESOURCE_GROUP_TOP_ITEMS_SUMMARY_DATA, **kwargs)


class SubscriptionAccessDecision(_model_base.Model):
    """Access Decision for each Subscription.

    :ivar subscription_id: Id of Subscription. Required.
    :vartype subscription_id: str
    :ivar decision: Access decision to subscription. Required. Known values are: "Allowed" and
     "Denied".
    :vartype decision: str or ~azure.mgmt.carbonoptimization.models.AccessDecisionEnum
    :ivar denial_reason: The reason why access request got denied.
    :vartype denial_reason: str
    """

    subscription_id: str = rest_field(name="subscriptionId", visibility=["read", "create", "update", "delete", "query"])
    """Id of Subscription. Required."""
    decision: Union[str, "_models.AccessDecisionEnum"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Access decision to subscription. Required. Known values are: \"Allowed\" and \"Denied\"."""
    denial_reason: Optional[str] = rest_field(
        name="denialReason", visibility=["read", "create", "update", "delete", "query"]
    )
    """The reason why access request got denied."""

    @overload
    def __init__(
        self,
        *,
        subscription_id: str,
        decision: Union[str, "_models.AccessDecisionEnum"],
        denial_reason: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TopItemsMonthlySummaryReportQueryFilter(QueryFilter, discriminator="TopItemsMonthlySummaryReport"):
    """Query filter parameter to configure TopItemsMonthlySummaryReport queries.

    :ivar date_range: The start and end dates for carbon emissions data. Required. For
     ItemDetailsReport and TopItemsSummaryReport, only one month of data is supported at a time, so
     start and end dates should be equal within DateRange (e.g., start: 2024-06-01 and end:
     2024-06-01). Required.
    :vartype date_range: ~azure.mgmt.carbonoptimization.models.DateRange
    :ivar subscription_list: List of subscription IDs for which carbon emissions data is requested.
     Required. Each subscription ID should be in lowercase format. The max length of list is 100.
     Required.
    :vartype subscription_list: list[str]
    :ivar resource_group_url_list: List of resource group URLs for carbon emissions data. Optional.
     Each URL must follow the format
     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroup}', and should be in all
     lowercase.
    :vartype resource_group_url_list: list[str]
    :ivar resource_type_list: List of resource types for carbon emissions data. Optional. Each
     resource type should be specified in lowercase, following the format
     'microsoft.{service}/{resourceType}', e.g., 'microsoft.storage/storageaccounts'.
    :vartype resource_type_list: list[str]
    :ivar location_list: List of locations(Azure Region Display Name) for carbon emissions data,
     with each location specified in lowercase (e.g., 'east us'). Optional. You can use the command
     'az account list-locations -o table' to find Azure Region Display Names.
    :vartype location_list: list[str]
    :ivar carbon_scope_list: List of carbon emission scopes. Required. Accepts one or more values
     from EmissionScopeEnum (e.g., Scope1, Scope2, Scope3) in list form. The output will include the
     total emissions for the specified scopes. Required.
    :vartype carbon_scope_list: list[str or
     ~azure.mgmt.carbonoptimization.models.EmissionScopeEnum]
    :ivar report_type: Specifies that the report type is a top items monthly summary report for
     carbon emissions data. Required. TopItemsMonthlyReport provides the N highest-emitting items by
     month for the specified query filter. Returns emissions data for the top N items by month
     within the given date range. A maximum of N=10 items can be returned at a time.
    :vartype report_type: str or
     ~azure.mgmt.carbonoptimization.models.TOP_ITEMS_MONTHLY_SUMMARY_REPORT
    :ivar category_type: Specifies the category type to retrieve top-emitting items, aggregated by
     month. See supported types in CategoryTypeEnum. Required. Known values are: "Subscription",
     "ResourceGroup", "Location", "Resource", and "ResourceType".
    :vartype category_type: str or ~azure.mgmt.carbonoptimization.models.CategoryTypeEnum
    :ivar top_items: The number of top items to return, based on emissions. Must be between 1 and
     10. Required.
    :vartype top_items: int
    """

    report_type: Literal[ReportTypeEnum.TOP_ITEMS_MONTHLY_SUMMARY_REPORT] = rest_discriminator(name="reportType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Specifies that the report type is a top items monthly summary report for carbon emissions data.
     Required. TopItemsMonthlyReport provides the N highest-emitting items by month for the
     specified query filter. Returns emissions data for the top N items by month within the given
     date range. A maximum of N=10 items can be returned at a time."""
    category_type: Union[str, "_models.CategoryTypeEnum"] = rest_field(
        name="categoryType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the category type to retrieve top-emitting items, aggregated by month. See supported
     types in CategoryTypeEnum. Required. Known values are: \"Subscription\", \"ResourceGroup\",
     \"Location\", \"Resource\", and \"ResourceType\"."""
    top_items: int = rest_field(name="topItems", visibility=["read", "create", "update", "delete", "query"])
    """The number of top items to return, based on emissions. Must be between 1 and 10. Required."""

    @overload
    def __init__(
        self,
        *,
        date_range: "_models.DateRange",
        subscription_list: List[str],
        carbon_scope_list: List[Union[str, "_models.EmissionScopeEnum"]],
        category_type: Union[str, "_models.CategoryTypeEnum"],
        top_items: int,
        resource_group_url_list: Optional[List[str]] = None,
        resource_type_list: Optional[List[str]] = None,
        location_list: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, report_type=ReportTypeEnum.TOP_ITEMS_MONTHLY_SUMMARY_REPORT, **kwargs)


class TopItemsSummaryReportQueryFilter(QueryFilter, discriminator="TopItemsSummaryReport"):
    """Query filter parameter to configure TopItemsSummaryReport queries.

    :ivar date_range: The start and end dates for carbon emissions data. Required. For
     ItemDetailsReport and TopItemsSummaryReport, only one month of data is supported at a time, so
     start and end dates should be equal within DateRange (e.g., start: 2024-06-01 and end:
     2024-06-01). Required.
    :vartype date_range: ~azure.mgmt.carbonoptimization.models.DateRange
    :ivar subscription_list: List of subscription IDs for which carbon emissions data is requested.
     Required. Each subscription ID should be in lowercase format. The max length of list is 100.
     Required.
    :vartype subscription_list: list[str]
    :ivar resource_group_url_list: List of resource group URLs for carbon emissions data. Optional.
     Each URL must follow the format
     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroup}', and should be in all
     lowercase.
    :vartype resource_group_url_list: list[str]
    :ivar resource_type_list: List of resource types for carbon emissions data. Optional. Each
     resource type should be specified in lowercase, following the format
     'microsoft.{service}/{resourceType}', e.g., 'microsoft.storage/storageaccounts'.
    :vartype resource_type_list: list[str]
    :ivar location_list: List of locations(Azure Region Display Name) for carbon emissions data,
     with each location specified in lowercase (e.g., 'east us'). Optional. You can use the command
     'az account list-locations -o table' to find Azure Region Display Names.
    :vartype location_list: list[str]
    :ivar carbon_scope_list: List of carbon emission scopes. Required. Accepts one or more values
     from EmissionScopeEnum (e.g., Scope1, Scope2, Scope3) in list form. The output will include the
     total emissions for the specified scopes. Required.
    :vartype carbon_scope_list: list[str or
     ~azure.mgmt.carbonoptimization.models.EmissionScopeEnum]
    :ivar report_type: Specifies that the report type is a top items summary report for carbon
     emissions data, aggregated by category type. Required. TopItemsSummaryReport provides the N
     highest-emitting items for the specified query filters. This report returns data for a single
     month at a time, so it requires the same values for the start and end fields within DateRange.
     A maximum of N=10 items can be returned at a time.
    :vartype report_type: str or ~azure.mgmt.carbonoptimization.models.TOP_ITEMS_SUMMARY_REPORT
    :ivar category_type: Specifies the category type for which to retrieve top-emitting items. See
     supported values defined in CategoryTypeEnum. Required. Known values are: "Subscription",
     "ResourceGroup", "Location", "Resource", and "ResourceType".
    :vartype category_type: str or ~azure.mgmt.carbonoptimization.models.CategoryTypeEnum
    :ivar top_items: The number of top items to return, based on emissions. This value must be
     between 1 and 10. Required.
    :vartype top_items: int
    """

    report_type: Literal[ReportTypeEnum.TOP_ITEMS_SUMMARY_REPORT] = rest_discriminator(name="reportType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Specifies that the report type is a top items summary report for carbon emissions data,
     aggregated by category type. Required. TopItemsSummaryReport provides the N highest-emitting
     items for the specified query filters. This report returns data for a single month at a time,
     so it requires the same values for the start and end fields within DateRange. A maximum of N=10
     items can be returned at a time."""
    category_type: Union[str, "_models.CategoryTypeEnum"] = rest_field(
        name="categoryType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the category type for which to retrieve top-emitting items. See supported values
     defined in CategoryTypeEnum. Required. Known values are: \"Subscription\", \"ResourceGroup\",
     \"Location\", \"Resource\", and \"ResourceType\"."""
    top_items: int = rest_field(name="topItems", visibility=["read", "create", "update", "delete", "query"])
    """The number of top items to return, based on emissions. This value must be between 1 and 10.
     Required."""

    @overload
    def __init__(
        self,
        *,
        date_range: "_models.DateRange",
        subscription_list: List[str],
        carbon_scope_list: List[Union[str, "_models.EmissionScopeEnum"]],
        category_type: Union[str, "_models.CategoryTypeEnum"],
        top_items: int,
        resource_group_url_list: Optional[List[str]] = None,
        resource_type_list: Optional[List[str]] = None,
        location_list: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, report_type=ReportTypeEnum.TOP_ITEMS_SUMMARY_REPORT, **kwargs)
