// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A type of [SourceCodeType] that specifies a code diff between a source and destination branch
// in an associated repository.
//
// [SourceCodeType]: https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType
type BranchDiffSourceCodeType struct {

	// The destination branch for a diff in an associated repository.
	//
	// This member is required.
	DestinationBranchName *string

	// The source branch for a diff in an associated repository.
	//
	// This member is required.
	SourceBranchName *string

	noSmithyDocumentSerde
}

// Code artifacts are source code artifacts and build artifacts used in a
// repository analysis or a pull request review.
//
//   - Source code artifacts are source code files in a Git repository that are
//     compressed into a .zip file.
//
//   - Build artifacts are .jar or .class files that are compressed in a .zip file.
type CodeArtifacts struct {

	// The S3 object key for a source code .zip file. This is required for all code
	// reviews.
	//
	// This member is required.
	SourceCodeArtifactsObjectKey *string

	// The S3 object key for a build artifacts .zip file that contains .jar or .class
	// files. This is required for a code review with security analysis. For more
	// information, see [Create code reviews with GitHub Actions]in the Amazon CodeGuru Reviewer User Guide.
	//
	// [Create code reviews with GitHub Actions]: https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/working-with-cicd.html
	BuildArtifactsObjectKey *string

	noSmithyDocumentSerde
}

// Information about an Amazon Web Services CodeCommit repository. The CodeCommit
// repository must be in the same Amazon Web Services Region and Amazon Web
// Services account where its CodeGuru Reviewer code reviews are configured.
type CodeCommitRepository struct {

	// The name of the Amazon Web Services CodeCommit repository. For more
	// information, see [repositoryName]in the Amazon Web Services CodeCommit API Reference.
	//
	// [repositoryName]: https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetRepository.html#CodeCommit-GetRepository-request-repositoryName
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Information about a code review. A code review belongs to the associated
// repository that contains the reviewed code.
type CodeReview struct {

	// The types of analysis performed during a repository analysis or a pull request
	// review. You can specify either Security , CodeQuality , or both.
	AnalysisTypes []AnalysisType

	// The Amazon Resource Name (ARN) of the [RepositoryAssociation] that contains the reviewed source code.
	// You can retrieve associated repository ARNs by calling [ListRepositoryAssociations].
	//
	// [ListRepositoryAssociations]: https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html
	// [RepositoryAssociation]: https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html
	AssociationArn *string

	// The Amazon Resource Name (ARN) of the [CodeReview] object.
	//
	// [CodeReview]: https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html
	CodeReviewArn *string

	// The state of the aws-codeguru-reviewer.yml configuration file that allows the
	// configuration of the CodeGuru Reviewer analysis. The file either exists, doesn't
	// exist, or exists with errors at the root directory of your repository.
	ConfigFileState ConfigFileState

	// The time, in milliseconds since the epoch, when the code review was created.
	CreatedTimeStamp *time.Time

	// The time, in milliseconds since the epoch, when the code review was last
	// updated.
	LastUpdatedTimeStamp *time.Time

	// The statistics from the code review.
	Metrics *Metrics

	// The name of the code review.
	Name *string

	// The owner of the repository. For an Amazon Web Services CodeCommit repository,
	// this is the Amazon Web Services account ID of the account that owns the
	// repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository,
	// this is the username for the account that owns the repository. For an S3
	// repository, it can be the username or Amazon Web Services account ID.
	Owner *string

	// The type of repository that contains the reviewed code (for example, GitHub or
	// Bitbucket).
	ProviderType ProviderType

	// The pull request ID for the code review.
	PullRequestId *string

	// The name of the repository.
	RepositoryName *string

	// The type of the source code for the code review.
	SourceCodeType *SourceCodeType

	// The valid code review states are:
	//
	//   - Completed : The code review is complete.
	//
	//   - Pending : The code review started and has not completed or failed.
	//
	//   - Failed : The code review failed.
	//
	//   - Deleting : The code review is being deleted.
	State JobState

	// The reason for the state of the code review.
	StateReason *string

	// The type of code review.
	Type Type

	noSmithyDocumentSerde
}

// Information about the summary of the code review.
type CodeReviewSummary struct {

	// The Amazon Resource Name (ARN) of the [CodeReview] object.
	//
	// [CodeReview]: https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html
	CodeReviewArn *string

	// The time, in milliseconds since the epoch, when the code review was created.
	CreatedTimeStamp *time.Time

	// The time, in milliseconds since the epoch, when the code review was last
	// updated.
	LastUpdatedTimeStamp *time.Time

	// The statistics from the code review.
	MetricsSummary *MetricsSummary

	// The name of the code review.
	Name *string

	// The owner of the repository. For an Amazon Web Services CodeCommit repository,
	// this is the Amazon Web Services account ID of the account that owns the
	// repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository,
	// this is the username for the account that owns the repository. For an S3
	// repository, it can be the username or Amazon Web Services account ID.
	Owner *string

	// The provider type of the repository association.
	ProviderType ProviderType

	// The pull request ID for the code review.
	PullRequestId *string

	// The name of the repository.
	RepositoryName *string

	// Specifies the source code that is analyzed in a code review.
	SourceCodeType *SourceCodeType

	// The state of the code review.
	//
	// The valid code review states are:
	//
	//   - Completed : The code review is complete.
	//
	//   - Pending : The code review started and has not completed or failed.
	//
	//   - Failed : The code review failed.
	//
	//   - Deleting : The code review is being deleted.
	State JobState

	// The type of the code review.
	Type Type

	noSmithyDocumentSerde
}

// The type of a code review. There are two code review types:
//
//   - PullRequest - A code review that is automatically triggered by a pull
//     request on an associated repository.
//
//   - RepositoryAnalysis - A code review that analyzes all code under a specified
//     branch in an associated repository. The associated repository is specified using
//     its ARN in [CreateCodeReview].
//
// [CreateCodeReview]: https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CreateCodeReview
type CodeReviewType struct {

	// A code review that analyzes all code under a specified branch in an associated
	// repository. The associated repository is specified using its ARN in [CreateCodeReview].
	//
	// [CreateCodeReview]: https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CreateCodeReview
	//
	// This member is required.
	RepositoryAnalysis *RepositoryAnalysis

	// They types of analysis performed during a repository analysis or a pull request
	// review. You can specify either Security , CodeQuality , or both.
	AnalysisTypes []AnalysisType

	noSmithyDocumentSerde
}

// A type of [SourceCodeType] that specifies the commit diff for a pull request on an associated
// repository. The SourceCommit and DestinationCommit fields are required to do a
// pull request code review.
//
// [SourceCodeType]: https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType
type CommitDiffSourceCodeType struct {

	// The SHA of the destination commit used to generate a commit diff. This field is
	// required for a pull request code review.
	DestinationCommit *string

	// The SHA of the merge base of a commit.
	MergeBaseCommit *string

	// The SHA of the source commit used to generate a commit diff. This field is
	// required for a pull request code review.
	SourceCommit *string

	noSmithyDocumentSerde
}

// Information about an event. The event might be a push, pull request, scheduled
// request, or another type of event.
type EventInfo struct {

	// The name of the event. The possible names are pull_request , workflow_dispatch ,
	// schedule , and push
	Name *string

	// The state of an event. The state might be open, closed, or another state.
	State *string

	noSmithyDocumentSerde
}

// An object that contains:
//
//   - The encryption option for a repository association. It is either owned by
//     Amazon Web Services Key Management Service (KMS) ( AWS_OWNED_CMK ) or customer
//     managed ( CUSTOMER_MANAGED_CMK ).
//
//   - The ID of the Amazon Web Services KMS key that is associated with a
//     repository association.
type KMSKeyDetails struct {

	// The encryption option for a repository association. It is either owned by
	// Amazon Web Services Key Management Service (KMS) ( AWS_OWNED_CMK ) or customer
	// managed ( CUSTOMER_MANAGED_CMK ).
	EncryptionOption EncryptionOption

	// The ID of the Amazon Web Services KMS key that is associated with a repository
	// association.
	KMSKeyId *string

	noSmithyDocumentSerde
}

// Information about the statistics from the code review.
type Metrics struct {

	// Total number of recommendations found in the code review.
	FindingsCount *int64

	// MeteredLinesOfCodeCount is the number of lines of code in the repository where
	// the code review happened. This does not include non-code lines such as comments
	// and blank lines.
	MeteredLinesOfCodeCount *int64

	// SuppressedLinesOfCodeCount is the number of lines of code in the repository
	// where the code review happened that CodeGuru Reviewer did not analyze. The lines
	// suppressed in the analysis is based on the excludeFiles variable in the
	// aws-codeguru-reviewer.yml file. This number does not include non-code lines such
	// as comments and blank lines.
	SuppressedLinesOfCodeCount *int64

	noSmithyDocumentSerde
}

// Information about metrics summaries.
type MetricsSummary struct {

	// Total number of recommendations found in the code review.
	FindingsCount *int64

	// Lines of code metered in the code review. For the initial code review pull
	// request and all subsequent revisions, this includes all lines of code in the
	// files added to the pull request. In subsequent revisions, for files that already
	// existed in the pull request, this includes only the changed lines of code. In
	// both cases, this does not include non-code lines such as comments and import
	// statements. For example, if you submit a pull request containing 5 files, each
	// with 500 lines of code, and in a subsequent revision you added a new file with
	// 200 lines of code, and also modified a total of 25 lines across the initial 5
	// files, MeteredLinesOfCodeCount includes the first 5 files (5 * 500 = 2,500
	// lines), the new file (200 lines) and the 25 changed lines of code for a total of
	// 2,725 lines of code.
	MeteredLinesOfCodeCount *int64

	// Lines of code suppressed in the code review based on the excludeFiles element
	// in the aws-codeguru-reviewer.yml file. For full repository analyses, this
	// number includes all lines of code in the files that are suppressed. For pull
	// requests, this number only includes the changed lines of code that are
	// suppressed. In both cases, this number does not include non-code lines such as
	// comments and import statements. For example, if you initiate a full repository
	// analysis on a repository containing 5 files, each file with 100 lines of code,
	// and 2 files are listed as excluded in the aws-codeguru-reviewer.yml file, then
	// SuppressedLinesOfCodeCount returns 200 (2 * 100) as the total number of lines of
	// code suppressed. However, if you submit a pull request for the same repository,
	// then SuppressedLinesOfCodeCount only includes the lines in the 2 files that
	// changed. If only 1 of the 2 files changed in the pull request, then
	// SuppressedLinesOfCodeCount returns 100 (1 * 100) as the total number of lines of
	// code suppressed.
	SuppressedLinesOfCodeCount *int64

	noSmithyDocumentSerde
}

// Information about the recommendation feedback.
type RecommendationFeedback struct {

	// The Amazon Resource Name (ARN) of the [CodeReview] object.
	//
	// [CodeReview]: https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html
	CodeReviewArn *string

	// The time at which the feedback was created.
	CreatedTimeStamp *time.Time

	// The time at which the feedback was last updated.
	LastUpdatedTimeStamp *time.Time

	// List for storing reactions. Reactions are utf-8 text code for emojis. You can
	// send an empty list to clear off all your feedback.
	Reactions []Reaction

	// The recommendation ID that can be used to track the provided recommendations.
	// Later on it can be used to collect the feedback.
	RecommendationId *string

	// The ID of the user that made the API call.
	//
	// The UserId is an IAM principal that can be specified as an Amazon Web Services
	// account ID or an Amazon Resource Name (ARN). For more information, see [Specifying a Principal]in the
	// Amazon Web Services Identity and Access Management User Guide.
	//
	// [Specifying a Principal]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying
	UserId *string

	noSmithyDocumentSerde
}

// Information about recommendation feedback summaries.
type RecommendationFeedbackSummary struct {

	// List for storing reactions. Reactions are utf-8 text code for emojis.
	Reactions []Reaction

	// The recommendation ID that can be used to track the provided recommendations.
	// Later on it can be used to collect the feedback.
	RecommendationId *string

	// The ID of the user that gave the feedback.
	//
	// The UserId is an IAM principal that can be specified as an Amazon Web Services
	// account ID or an Amazon Resource Name (ARN). For more information, see [Specifying a Principal]in the
	// Amazon Web Services Identity and Access Management User Guide.
	//
	// [Specifying a Principal]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying
	UserId *string

	noSmithyDocumentSerde
}

// Information about recommendations.
type RecommendationSummary struct {

	// A description of the recommendation generated by CodeGuru Reviewer for the
	// lines of code between the start line and the end line.
	Description *string

	// Last line where the recommendation is applicable in the source commit or source
	// branch. For a single line comment the start line and end line values are the
	// same.
	EndLine *int32

	// Name of the file on which a recommendation is provided.
	FilePath *string

	// The type of a recommendation.
	RecommendationCategory RecommendationCategory

	// The recommendation ID that can be used to track the provided recommendations.
	// Later on it can be used to collect the feedback.
	RecommendationId *string

	// Metadata about a rule. Rule metadata includes an ID, a name, a list of tags,
	// and a short and long description. CodeGuru Reviewer uses rules to analyze code.
	// A rule's recommendation is included in analysis results if code is detected that
	// violates the rule.
	RuleMetadata *RuleMetadata

	// The severity of the issue in the code that generated this recommendation.
	Severity Severity

	// Start line from where the recommendation is applicable in the source commit or
	// source branch.
	StartLine *int32

	noSmithyDocumentSerde
}

// Information about an associated Amazon Web Services CodeCommit repository or an
// associated repository that is managed by Amazon Web Services CodeStar
// Connections (for example, Bitbucket). This Repository object is not used if
// your source code is in an associated GitHub repository.
type Repository struct {

	//  Information about a Bitbucket repository.
	Bitbucket *ThirdPartySourceRepository

	// Information about an Amazon Web Services CodeCommit repository.
	CodeCommit *CodeCommitRepository

	// Information about a GitHub Enterprise Server repository.
	GitHubEnterpriseServer *ThirdPartySourceRepository

	// Information about a repository in an S3 bucket.
	S3Bucket *S3Repository

	noSmithyDocumentSerde
}

// A code review type that analyzes all code under a specified branch in an
// associated repository. The associated repository is specified using its ARN when
// you call [CreateCodeReview].
//
// [CreateCodeReview]: https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CreateCodeReview
type RepositoryAnalysis struct {

	// A [SourceCodeType] that specifies the tip of a branch in an associated repository.
	//
	// [SourceCodeType]: https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType
	RepositoryHead *RepositoryHeadSourceCodeType

	// Specifies the source code that is analyzed in a code review.
	SourceCodeType *SourceCodeType

	noSmithyDocumentSerde
}

// Information about a repository association. The [DescribeRepositoryAssociation] operation returns a
// RepositoryAssociation object.
//
// [DescribeRepositoryAssociation]: https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_DescribeRepositoryAssociation.html
type RepositoryAssociation struct {

	// The Amazon Resource Name (ARN) identifying the repository association.
	AssociationArn *string

	// The ID of the repository association.
	AssociationId *string

	// The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections
	// connection. Its format is
	// arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id .
	// For more information, see [Connection]in the Amazon Web Services CodeStar Connections API
	// Reference.
	//
	// [Connection]: https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html
	ConnectionArn *string

	// The time, in milliseconds since the epoch, when the repository association was
	// created.
	CreatedTimeStamp *time.Time

	// A KMSKeyDetails object that contains:
	//
	//   - The encryption option for this repository association. It is either owned
	//   by Amazon Web Services Key Management Service (KMS) ( AWS_OWNED_CMK ) or
	//   customer managed ( CUSTOMER_MANAGED_CMK ).
	//
	//   - The ID of the Amazon Web Services KMS key that is associated with this
	//   repository association.
	KMSKeyDetails *KMSKeyDetails

	// The time, in milliseconds since the epoch, when the repository association was
	// last updated.
	LastUpdatedTimeStamp *time.Time

	// The name of the repository.
	Name *string

	// The owner of the repository. For an Amazon Web Services CodeCommit repository,
	// this is the Amazon Web Services account ID of the account that owns the
	// repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository,
	// this is the username for the account that owns the repository. For an S3
	// repository, it can be the username or Amazon Web Services account ID.
	Owner *string

	// The provider type of the repository association.
	ProviderType ProviderType

	// Specifies the name of an S3 bucket and a CodeArtifacts object that contains the
	// S3 object keys for a source code .zip file and for a build artifacts .zip file
	// that contains .jar or .class files.
	S3RepositoryDetails *S3RepositoryDetails

	// The state of the repository association.
	//
	// The valid repository association states are:
	//
	//   - Associated: The repository association is complete.
	//
	//   - Associating: CodeGuru Reviewer is:
	//
	//   - Setting up pull request notifications. This is required for pull requests
	//   to trigger a CodeGuru Reviewer review.
	//
	// If your repository ProviderType is GitHub , GitHub Enterprise Server , or
	//   Bitbucket , CodeGuru Reviewer creates webhooks in your repository to trigger
	//   CodeGuru Reviewer reviews. If you delete these webhooks, reviews of code in your
	//   repository cannot be triggered.
	//
	//   - Setting up source code access. This is required for CodeGuru Reviewer to
	//   securely clone code in your repository.
	//
	//   - Failed: The repository failed to associate or disassociate.
	//
	//   - Disassociating: CodeGuru Reviewer is removing the repository's pull request
	//   notifications and source code access.
	//
	//   - Disassociated: CodeGuru Reviewer successfully disassociated the repository.
	//   You can create a new association with this repository if you want to review
	//   source code in it later. You can control access to code reviews created in
	//   anassociated repository with tags after it has been disassociated. For more
	//   information, see [Using tags to control access to associated repositories]in the Amazon CodeGuru Reviewer User Guide.
	//
	// [Using tags to control access to associated repositories]: https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html
	State RepositoryAssociationState

	// A description of why the repository association is in the current state.
	StateReason *string

	noSmithyDocumentSerde
}

// Summary information about a repository association. The [ListRepositoryAssociations] operation returns a
// list of RepositoryAssociationSummary objects.
//
// [ListRepositoryAssociations]: https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html
type RepositoryAssociationSummary struct {

	// The Amazon Resource Name (ARN) of the [RepositoryAssociation] object. You can retrieve this ARN by
	// calling [ListRepositoryAssociations].
	//
	// [ListRepositoryAssociations]: https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html
	// [RepositoryAssociation]: https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html
	AssociationArn *string

	// The repository association ID.
	AssociationId *string

	// The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections
	// connection. Its format is
	// arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id .
	// For more information, see [Connection]in the Amazon Web Services CodeStar Connections API
	// Reference.
	//
	// [Connection]: https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html
	ConnectionArn *string

	// The time, in milliseconds since the epoch, since the repository association was
	// last updated.
	LastUpdatedTimeStamp *time.Time

	// The name of the repository association.
	Name *string

	// The owner of the repository. For an Amazon Web Services CodeCommit repository,
	// this is the Amazon Web Services account ID of the account that owns the
	// repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository,
	// this is the username for the account that owns the repository. For an S3
	// repository, it can be the username or Amazon Web Services account ID.
	Owner *string

	// The provider type of the repository association.
	ProviderType ProviderType

	// The state of the repository association.
	//
	// The valid repository association states are:
	//
	//   - Associated: The repository association is complete.
	//
	//   - Associating: CodeGuru Reviewer is:
	//
	//   - Setting up pull request notifications. This is required for pull requests
	//   to trigger a CodeGuru Reviewer review.
	//
	// If your repository ProviderType is GitHub , GitHub Enterprise Server , or
	//   Bitbucket , CodeGuru Reviewer creates webhooks in your repository to trigger
	//   CodeGuru Reviewer reviews. If you delete these webhooks, reviews of code in your
	//   repository cannot be triggered.
	//
	//   - Setting up source code access. This is required for CodeGuru Reviewer to
	//   securely clone code in your repository.
	//
	//   - Failed: The repository failed to associate or disassociate.
	//
	//   - Disassociating: CodeGuru Reviewer is removing the repository's pull request
	//   notifications and source code access.
	//
	//   - Disassociated: CodeGuru Reviewer successfully disassociated the repository.
	//   You can create a new association with this repository if you want to review
	//   source code in it later. You can control access to code reviews created in
	//   anassociated repository with tags after it has been disassociated. For more
	//   information, see [Using tags to control access to associated repositories]in the Amazon CodeGuru Reviewer User Guide.
	//
	// [Using tags to control access to associated repositories]: https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html
	State RepositoryAssociationState

	noSmithyDocumentSerde
}

// A [SourceCodeType] that specifies the tip of a branch in an associated repository.
//
// [SourceCodeType]: https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType
type RepositoryHeadSourceCodeType struct {

	// The name of the branch in an associated repository. The
	// RepositoryHeadSourceCodeType specifies the tip of this branch.
	//
	// This member is required.
	BranchName *string

	noSmithyDocumentSerde
}

// Metadata that is associated with a code review. This applies to both pull
// request and repository analysis code reviews.
type RequestMetadata struct {

	// Information about the event associated with a code review.
	EventInfo *EventInfo

	// The ID of the request. This is required for a pull request code review.
	RequestId *string

	// An identifier, such as a name or account ID, that is associated with the
	// requester. The Requester is used to capture the author/actor name of the event
	// request.
	Requester *string

	// The name of the repository vendor used to upload code to an S3 bucket for a
	// CI/CD code review. For example, if code and artifacts are uploaded to an S3
	// bucket for a CI/CD code review by GitHub scripts from a GitHub repository, then
	// the repository association's ProviderType is S3Bucket and the CI/CD repository
	// vendor name is GitHub. For more information, see the definition for ProviderType
	// in [RepositoryAssociation].
	//
	// [RepositoryAssociation]: https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html
	VendorName VendorName

	noSmithyDocumentSerde
}

// Metadata about a rule. Rule metadata includes an ID, a name, a list of tags,
// and a short and long description. CodeGuru Reviewer uses rules to analyze code.
// A rule's recommendation is included in analysis results if code is detected that
// violates the rule.
type RuleMetadata struct {

	// A long description of the rule.
	LongDescription *string

	// The ID of the rule.
	RuleId *string

	// The name of the rule.
	RuleName *string

	// Tags that are associated with the rule.
	RuleTags []string

	// A short description of the rule.
	ShortDescription *string

	noSmithyDocumentSerde
}

// Information about an associated repository in an S3 bucket. The associated
// repository contains a source code .zip file and a build artifacts .zip file that
// contains .jar or .class files.
type S3BucketRepository struct {

	// The name of the repository when the ProviderType is S3Bucket .
	//
	// This member is required.
	Name *string

	// An S3RepositoryDetails object that specifies the name of an S3 bucket and a
	// CodeArtifacts object. The CodeArtifacts object includes the S3 object keys for
	// a source code .zip file and for a build artifacts .zip file.
	Details *S3RepositoryDetails

	noSmithyDocumentSerde
}

// Information about a repository in an S3 bucket.
type S3Repository struct {

	// The name of the S3 bucket used for associating a new S3 repository. It must
	// begin with codeguru-reviewer- .
	//
	// This member is required.
	BucketName *string

	// The name of the repository in the S3 bucket.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Specifies the name of an S3 bucket and a CodeArtifacts object that contains the
// S3 object keys for a source code .zip file and for a build artifacts .zip file
// that contains .jar or .class files.
type S3RepositoryDetails struct {

	// The name of the S3 bucket used for associating a new S3 repository. It must
	// begin with codeguru-reviewer- .
	BucketName *string

	// A CodeArtifacts object. The CodeArtifacts object includes the S3 object key for
	// a source code .zip file and for a build artifacts .zip file that contains .jar
	// or .class files.
	CodeArtifacts *CodeArtifacts

	noSmithyDocumentSerde
}

// Specifies the source code that is analyzed in a code review.
type SourceCodeType struct {

	// A type of [SourceCodeType] that specifies a source branch name and a destination branch name in
	// an associated repository.
	//
	// [SourceCodeType]: https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType
	BranchDiff *BranchDiffSourceCodeType

	// A [SourceCodeType] that specifies a commit diff created by a pull request on an associated
	// repository.
	//
	// [SourceCodeType]: https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType
	CommitDiff *CommitDiffSourceCodeType

	// A [SourceCodeType] that specifies the tip of a branch in an associated repository.
	//
	// [SourceCodeType]: https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType
	RepositoryHead *RepositoryHeadSourceCodeType

	// Metadata that is associated with a code review. This applies to any type of
	// code review supported by CodeGuru Reviewer. The RequestMetadaa field captures
	// any event metadata. For example, it might capture metadata associated with an
	// event trigger, such as a push or a pull request.
	RequestMetadata *RequestMetadata

	// Information about an associated repository in an S3 bucket that includes its
	// name and an S3RepositoryDetails object. The S3RepositoryDetails object includes
	// the name of an S3 bucket, an S3 key for a source code .zip file, and an S3 key
	// for a build artifacts .zip file. S3BucketRepository is required in [SourceCodeType] for
	// S3BucketRepository based code reviews.
	//
	// [SourceCodeType]: https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType
	S3BucketRepository *S3BucketRepository

	noSmithyDocumentSerde
}

// Information about a third-party source repository connected to CodeGuru
// Reviewer.
type ThirdPartySourceRepository struct {

	// The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections
	// connection. Its format is
	// arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id .
	// For more information, see [Connection]in the Amazon Web Services CodeStar Connections API
	// Reference.
	//
	// [Connection]: https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html
	//
	// This member is required.
	ConnectionArn *string

	// The name of the third party source repository.
	//
	// This member is required.
	Name *string

	// The owner of the repository. For a GitHub, GitHub Enterprise, or Bitbucket
	// repository, this is the username for the account that owns the repository. For
	// an S3 repository, this can be the username or Amazon Web Services account ID
	//
	// This member is required.
	Owner *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
