// Code generated by smithy-go-codegen DO NOT EDIT.

package autoscaling

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/autoscaling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Starts a new instance refresh operation. An instance refresh performs a rolling
// replacement of all or some instances in an Auto Scaling group. Each instance is
// terminated first and then replaced, which temporarily reduces the capacity
// available within your Auto Scaling group. This operation is part of the instance
// refresh feature
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
// in Amazon EC2 Auto Scaling, which helps you update instances in your Auto
// Scaling group. This feature is helpful, for example, when you have a new AMI or
// a new user data script. You just need to create a new launch template that
// specifies the new AMI or user data script. Then start an instance refresh to
// immediately begin the process of updating instances in the group. If the call
// succeeds, it creates a new instance refresh request with a unique ID that you
// can use to track its progress. To query its status, call the
// DescribeInstanceRefreshes API. To describe the instance refreshes that have
// already run, call the DescribeInstanceRefreshes API. To cancel an instance
// refresh operation in progress, use the CancelInstanceRefresh API.
func (c *Client) StartInstanceRefresh(ctx context.Context, params *StartInstanceRefreshInput, optFns ...func(*Options)) (*StartInstanceRefreshOutput, error) {
	if params == nil {
		params = &StartInstanceRefreshInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartInstanceRefresh", params, optFns, c.addOperationStartInstanceRefreshMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartInstanceRefreshOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartInstanceRefreshInput struct {

	// The name of the Auto Scaling group.
	//
	// This member is required.
	AutoScalingGroupName *string

	// The desired configuration. For example, the desired configuration can specify a
	// new launch template or a new version of the current launch template. Once the
	// instance refresh succeeds, Amazon EC2 Auto Scaling updates the settings of the
	// Auto Scaling group to reflect the new desired configuration. When you specify a
	// new launch template or a new version of the current launch template for your
	// desired configuration, consider enabling the SkipMatching property in
	// preferences. If it's enabled, Amazon EC2 Auto Scaling skips replacing instances
	// that already use the specified launch template and version. This can help you
	// reduce the number of replacements that are required to apply updates.
	DesiredConfiguration *types.DesiredConfiguration

	// Set of preferences associated with the instance refresh request. If not
	// provided, the default values are used.
	Preferences *types.RefreshPreferences

	// The strategy to use for the instance refresh. The only valid value is Rolling. A
	// rolling update helps you update your instances gradually. A rolling update can
	// fail due to failed health checks or if instances are on standby or are protected
	// from scale in. If the rolling update process fails, any instances that are
	// replaced are not rolled back to their previous configuration.
	Strategy types.RefreshStrategy

	noSmithyDocumentSerde
}

type StartInstanceRefreshOutput struct {

	// A unique ID for tracking the progress of the request.
	InstanceRefreshId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartInstanceRefreshMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsquery_serializeOpStartInstanceRefresh{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpStartInstanceRefresh{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpStartInstanceRefreshValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartInstanceRefresh(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartInstanceRefresh(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "autoscaling",
		OperationName: "StartInstanceRefresh",
	}
}
