#! /bin/csh -f
#
# Copyright (c) 2001-2003 The Trustees of Indiana University.  
#                         All rights reserved.
# Copyright (c) 1998-2001 University of Notre Dame. 
#                         All rights reserved.
# Copyright (c) 1994-1998 The Ohio State University.  
#                         All rights reserved.
# 
# This file is part of the XMPI software package.  For license
# information, see the LICENSE file in the top level directory of the
# XMPI source distribution.
#
# $Id: distscript.csh,v 1.11 2003/08/23 15:07:03 jsquyres Exp $
#

set distdir="$1"

set config_guess="/l/osl/Students/lamteam/nightly-tarball/config.guess"
set config_sub="/l/osl/Students/lamteam/nightly-tarball/config.sub"

set start=`date`
cat <<EOF
 
Creating XMPI distribution
In directory: `pwd`
Started: $start
 
EOF

umask 022
set p="`pwd`"

#########################################################
# VERY IMPORTANT: Now go into the new distribution tree #
#########################################################

cd $distdir

set ver="`cat VERSION`"
set lamver="`lamboot -V | grep LAM | cut -f 2 -d ' '`"

echo got version $ver
if ("$lamver" == "") then
  echo "Could not get LAM version.  Aborting."
  exit 0
endif

#
# Get the latest config.guess and config.sub from ftp.gnu.org
#

echo "*** Downloading latest config.sub/config.guess from ftp.gnu.org..."
rm -f config.guess
wget ftp://ftp.gnu.org/gnu/config/config.guess
rm -f config.sub
wget ftp://ftp.gnu.org/gnu/config/config.sub

# Recently, ftp.gnu.org has had zero-legnth config.guess / config.sub
# files, which causes the automated nightly CVS snapshot tarball to
# fail to be made correctly.  This is a primitive attempt to fix that.
# If we got zero-length files from wget, use a config.guess /
# config.sub from a known location that is more recent than what ships
# in the current generation of auto* tools.

if (! -f config.guess || ! -s config.guess) then
    echo " - WARNING: Got BAD config.guess from ftp.gnu.org"
    if (-f $config_guess) then
	echo " - WARNING: using known version"
	cp $config_guess config
    else
	echo " - WARNING: using included version"
    endif
    chmod +x config/config.guess
endif
if (! -f config.sub || ! -s config.sub) then
    echo " - WARNING: Got BAD config.sub from ftp.gnu.org"
    if (-f $config_sub) then
	echo " - WARNING: using known version"
	cp $config_sub config
    else
	echo " - WARNING: using included version"
    endif
    chmod +x config/config.sub
endif

#
# Put the release version number in the README & INSTALL.  NEWS is
# already checked to match with latest version number by Automake #
#

echo "*** Updating version number in README & INSTALL..."
foreach file (README INSTALL)
    echo " - Setting $file"
    if (-f $file) then
	sed -e "s/XMPIRV/$ver/" $file > out-1.$$
	sed -e "s/LAMRV/$lamver/" out-1.$$ > out-2.$$
	mv -f out-2.$$ $file
	rm out-1.$$
    endif
end

#
# Set social Unix perms
#
 
echo "*** Setting social Unix permissions..."
chmod +x 	config/config.guess config/config.sub \
	config/install-sh \
	config/missing config/mkinstalldirs

cat <<EOF
*** XMPI version $ver distribution created
 
Started: $start
Ended:   `date`
 
EOF

