# Valentina

[![Project status](https://img.shields.io/badge/Status-Active-green)]()
[![Maintainer](https://img.shields.io/badge/Maintainer-Roman_Telezhynskyi-blue)]()
[![GitLab Last Commit](https://img.shields.io/gitlab/last-commit/smart-pattern%2Fvalentina?style=flat)]()
[![Discord](https://img.shields.io/discord/1209739539816517692?logo=discord&logoColor=white)](https://discord.gg/XUxKFQuQ)
[![Stable version](https://img.shields.io/badge/Stable-v0.6.1-blue)](https://smart-pattern.com.ua/valentina/version/0.6.1/)
[![Dev version](https://img.shields.io/badge/Dev-v0.7.53-yellow)](https://smart-pattern.com.ua/valentina/version/0.7.53/)
[![Build Status](https://api.cirrus-ci.com/github/dismine/valentina.svg)](https://cirrus-ci.com/github/dismine/valentina)
[![Build status](https://ci.appveyor.com/api/projects/status/m505f1pfs19j81nt/branch/develop?svg=true)](https://ci.appveyor.com/project/dismi_/valentina)
[![Quality Gate Status](https://sonarcloud.io/api/project_badges/measure?project=dismine_valentina&metric=alert_status)](https://sonarcloud.io/summary/new_code?id=dismine_valentina)
[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)

Welcome to [Valentina](https://smart-pattern.com.ua/), a versatile cross-platform patternmaking program designed for creating and modeling clothing patterns. Whether you prefer using standard sizing tables or individual measurements, this software provides a flexible environment for pattern creation. Valentina seamlessly integrates modern technologies with traditional methods to offer a comprehensive patternmaking tool.

Key features:

1. **Versatile Pattern Creation:**
   - Create intricate clothing patterns with ease, accommodating both standard sizing tables and personalized measurements.

2. **Intuitive Interface:**
   - Enjoy a user-friendly design that caters to both beginners and experienced designers, making the patternmaking process accessible and efficient.

3. **Technology meets Tradition:**
   - Seamlessly blend cutting-edge technologies with traditional patternmaking methods, providing a dynamic and efficient toolset for designers.

4. **Cross-Platform Compatibility:**
   - Work seamlessly across various operating systems, including Windows, macOS, and Linux, ensuring a consistent experience for users.

5. **Collaborative Design:**
   - Facilitate collaboration by sharing patterns effortlessly, enabling teamwork and creative cooperation among team members or clients.

6. **Precision and Accuracy:**
   - Utilize Valentina's precision tools to ensure accurate and finely-tailored patterns, suitable for personal projects or professional collections.

## Installation

To install Valentina, please visit our website [Valentina Website] and download the version that best suits your needs. Valentina supports two branches: `stable` and `dev`. Version numbers follow a specific pattern to indicate stability and development status:

- **Stable Version:**
  - Version numbers with even digits (e.g., 0.6) are reserved for stable releases.
  - Stable versions receive bug fixes to ensure a reliable and stable user experience.

- **Dev Version:**
  - Version numbers with odd digits (e.g., 0.7) represent the development branch.
  - The dev version is actively developed and receives bug fixes and new features, providing a more feature-rich experience.
  - While stable versions are suitable for initial checks, we recommend the dev branch for professional use due to its more advanced functionality.

Select the platform you use, and then choose the version most appropriate for your operating system. Versions marked with a "+" symbol indicate compatibility with the specified version of the OS and higher.

We recommend using the `dev` branch for professional use to take advantage of the latest features and improvements. If you encounter any issues, please refer to the **Support** section for assistance.  

## Compilation

For advanced users and developers who want to compile Valentina from the source code, detailed instructions can be found in our [Wiki](https://gitlab.com/smart-pattern/valentina/-/wikis/home). The wiki provides step-by-step guidance on compiling Valentina on various platforms and includes information on dependencies and build configurations.

Please visit the [Wiki](https://gitlab.com/smart-pattern/valentina/-/wikis/home) for comprehensive instructions tailored to your development environment.

## Support

We value your experience with Valentina and are here to assist you at every step. For any questions, issues, or collaborative discussions, explore the various support channels available:

1. **Telegram Chat:**

   Join our Telegram chat for real-time assistance and community support. Users engage in discussions, seek help, and share valuable feedback. The chat is available in English and Ukrainian.  
   [![Chat on Telegram](https://img.shields.io/badge/Chat-on_Telegram-green?logo=telegram)](https://t.me/valentina_project)

2. **Telegram Channel:**

   Stay updated with the latest news and announcements about the Valentina project by subscribing to our Telegram channel. Get insights into new features, releases, and project developments.  
   [![Chat on Telegram](https://img.shields.io/badge/Channel-on_Telegram-green?logo=telegram)](https://t.me/smart_pattern)

3. **Discord Server:**

   Join our Discord server to connect with the Valentina community, get support, and participate in discussions. Stay updated with the latest developments and engage with like-minded individuals.  
   [![Discord](https://img.shields.io/discord/1209739539816517692?logo=discord&logoColor=white)](https://discord.gg/XUxKFQuQ)      

4. **Instagram Accounts:**

   Follow our Instagram accounts for visual updates and behind-the-scenes content. We have separate accounts for English and Ukrainian users, providing a diverse range of content related to Valentina.  
   [![Instagram En](https://img.shields.io/badge/Follow-on_Instagram_(En)-green?style=social&logo=instagram
)](https://www.instagram.com/smart_pattern/)
   [![Instagram Uk](https://img.shields.io/badge/Follow-on_Instagram_(Uk)-green?style=social&logo=instagram
)](https://www.instagram.com/valentina_project/)

5. **Facebook Groups:**

   Engage with our community through Facebook groups. Join the English group for discussions and updates, or connect with the French-speaking community in our dedicated group.  
   [![Facebook Group - English](https://img.shields.io/badge/Follow-on_Facebook_(En,_It,_De)-green?style=social&logo=facebook
)](https://facebook.com/groups/valentina.en.it.de/?ref=share)
   [![Facebook Group - French](https://img.shields.io/badge/Follow-on_Facebook_(Fr)-green?style=social&logo=facebook
)](https://facebook.com/groups/valentina.france/?ref=share)

6. **Issue Tracker:**

   Report bugs, suggest improvements, and contribute to the ongoing development of Valentina by visiting our Issue Tracker. Your feedback is crucial in enhancing the user experience.  
   [![GitLab Issues](https://img.shields.io/gitlab/issues/open/smart-pattern%2Fvalentina)](https://gitlab.com/smart-pattern/valentina/-/issues/)

7. **User Manual and Shop:**

   Visit our shop to explore the user manual, a valuable resource for mastering Valentina's features. By purchasing the manual, you not only gain in-depth insights but also contribute to supporting the continued development of the project.  
   [![Shop](https://img.shields.io/badge/Shop-now-informational)
](https://smart-pattern.com.ua/en/catalogue/)

If you prefer private communication, feel free to reach out through one of the following methods:

  - **Email:**

    Reach the maintainer, Roman directly at ![Mail maintainer](https://img.shields.io/badge/Mail-dismine@gmail.com-green?logo=gmail)

  - **Telegram:**

    Contact us privately on Telegram: [![Chat with maintainer](https://img.shields.io/badge/Chat-on_Telegram-green?logo=telegram)](https://t.me/crazy_snail)

  - **Viber:**

    Connect with us on Viber: [![Chat with maintainer](https://img.shields.io/badge/Chat-on_Viber-green?logo=viber&logoColor=white)](viber://chat?number=0380983467136)

  - **WhatsApp:**

    Chat with us on WhatsApp: [![Chat with maintainer](https://img.shields.io/badge/Chat-on_WhatsApp-green?logo=whatsapp)](https://wa.me/0380983467136)

  - **Threema:**

    Chat with us on Threema: [![Chat with maintainer](https://img.shields.io/badge/Chat-on_Threema-green?logo=threema)](https://threema.id/WVDPXTJC?text=)  

We appreciate your active participation and feedback. Your involvement in the Valentina community is essential in shaping the future of our patternmaking tool.

## Contributing

Valentina welcomes contributions from the community, and your involvement can make a significant impact. Here are various ways you can contribute to the development and improvement of Valentina:

1. **Bug Reports:**
   If you encounter any bugs or unexpected behavior, please report them on our [Issue Tracker](https://gitlab.com/smart-pattern/valentina/-/issues/). Provide detailed information about the issue, including steps to reproduce it and the operating system you're using. Your bug reports are crucial in enhancing the stability and performance of Valentina.  
   [![GitLab Issues](https://img.shields.io/gitlab/issues/open/smart-pattern%2Fvalentina)](https://gitlab.com/smart-pattern/valentina/-/issues/)

2. **Feature Suggestions:**

   Share your ideas for new features or improvements to existing ones on the [Issue Tracker](https://gitlab.com/smart-pattern/valentina/-/issues/). We value your input and appreciate suggestions that can enhance the functionality and user experience of Valentina.  
   [![Feature proposal](https://img.shields.io/badge/Feature-propose-green)
](https://gitlab.com/smart-pattern/valentina/-/issues/new)

3. **Localization on Transifex:**

   Help us make Valentina accessible to a global audience by contributing to localization efforts on [Transifex](https://explore.transifex.com/valentina/valentina-project/). Contribute translations, review existing ones, or suggest improvements to ensure that Valentina is available in multiple languages.  
     [![Translation](https://img.shields.io/badge/Translate-on_Transifex-green?logo=transifex)](
   https://explore.transifex.com/valentina/valentina-project/)

4. **Code Contributions:**
   If you're a developer and want to contribute code to Valentina, please follow our [Contribution Guidelines]. Your contributions can include bug fixes, new features, or improvements to the existing codebase.

5. **Community Involvement:**

   Engage with the Valentina community on our Telegram Chat and Facebook Groups. Share your experiences, help fellow users, and participate in discussions about the future development of Valentina.

6. **Exclusive Expert Group:**

   For deeply involved users interested in shaping the future of Valentina, consider joining our special group of experts. Contact us to request an invite and contribute to influential decisions about the direction of Valentina.

We appreciate your contributions and look forward to building a vibrant and collaborative community around Valentina.

## License
Valentina is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Valentina is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

See LICENSE_GPL.txt file for further information

Other components released under:
* QMuParser - BSD license
* VPropertyExplorer - LGPLv2.1 license

## Links

* [Web site](https://smart-pattern.com.ua/)
* [Shop](https://smart-pattern.com.ua/catalogue/)
* [Chat Telegram](https://t.me/valentina_project/)
* [Chat Discord](https://discord.gg/XUxKFQuQ)
* [Issue tracker](https://gitlab.com/smart-pattern/valentina/-/issues/)
* [Source code](https://gitlab.com/smart-pattern/valentina/)
