-- Topal: GPG/GnuPG and Alpine/Pine integration
-- Copyright (C) 2001--2018  Phillip J. Brooke
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License version 3 as
-- published by the Free Software Foundation.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

with Globals;               use Globals;

package Invocation is

   type Run_Modes is (Help_Text,
                      Inline_Display, Mime_Display, Old_Mime_Display,
                      Pipe_Display,
                      Inline_Send, Mime_Send, Actual_Send, Nonpine_Send,
                      Clear_Temp, Clear_Cache, Clear_All,
                      Dump_Default_Config, Dump_Current_Config,
                      Interactive_Config,
                      Fix_Email, Fix_Folders,
		      Check_Send_Token,
                      Server, Remote_Send, Remote_Mime_Send,
                      Remote_Decrypt, Remote_Mime_Decrypt,
		      Raw_Input
                      );

   Run_Mode : Run_Modes := Help_Text;

   Tmpfile       : UBS;
   Resultfile    : UBS;
   RVfile        : UBS;
   Infile        : UBS;
   Content_Type  : UBS;
   Mimefile      : UBS;
   Recipients    : UBS_Array_Pointer;
   Folders       : UBS_Array_Pointer;
   CST_Token     : UBS;
   Remaining     : UBS_Array_Pointer;

   procedure Parse_Command_Line;

end Invocation;
