// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2020 - Samuel GOUGEON
//
// This file is hereby licensed under the terms of the GNU GPL v2.0,
// pursuant to article 5.3.4 of the CeCILL v.2.1.
// This file was originally licensed under the terms of the CeCILL v2.1,
// and continues to be available under such terms.
// For more information, see the COPYING file which you should have received
// along with this program.

function pname = getPropName(property)
    // See properties defined in m2sci.sci and Type.sci

    if type(property)==10
        if isnum(property)
            pname = PropertyNames(property)
        else
            pname = property
        end
    elseif type(property)==1
        pname = msprintf("%d\n", property)
        if or(property==[-1 0 1 4 5 10 11 13 130])
            pname = PropertyNames(pname)
        end
    else
        pname = string(property)
    end
endfunction
