/*
 *                            COPYRIGHT
 *
 *  sch-rnd - modular/flexible schematics editor - eeschema file format support
 *  Copyright (C) 2024..2025 Aron Barath
 *  Copyright (C) 2022..2024 Tibor 'Igor2' Palinkas
 *
 *  (Supported by NLnet NGI0 Entrust Fund in 2024)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 *  Contact:
 *    Project page: http://repo.hu/projects/sch-rnd
 *    contact lead developer: http://www.repo.hu/projects/sch-rnd/contact.html
 *    mailing list: http://www.repo.hu/projects/sch-rnd/contact.html
 */

struct paper_dim
{
	const char* name;
	float w;
	float h;
};

#define inch(x) ((x)*2.54)

static const struct paper_dim paper_dims[] =
{
	{ "A5", 210, 148 },
	{ "A4", 297, 210 },
	{ "A3", 420, 297 },
	{ "A2", 594, 420 },
	{ "A1", 841, 594 },
	{ "A0", 1189, 841 },
	{ "A", inch(11), inch(8.5) },
	{ "B", inch(17), inch(11) },
	{ "C", inch(22), inch(17) },
	{ "D", inch(34), inch(22) },
	{ "E", inch(44), inch(34) },
	{ "USLetter", inch(11), inch(8.5) },
	{ "USLegal", inch(14), inch(8.5) },
	{ "USLedger", inch(17), inch(11) },
	{ 0 }
};

#undef inch

static const struct paper_dim* paper_dim_lookup(const char* const name)
{
	const struct paper_dim* dim = paper_dims;

	for(;dim->name;++dim)
	{
		if(strcmp(dim->name, name)==0)
		{
			return dim;
		}
	}

	return NULL;
}
