# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AADBasedSecurityPrincipal(_serialization.Model):
    """AAD based security principal with associated Ledger RoleName.

    :ivar principal_id: UUID/GUID based Principal Id of the Security Principal.
    :vartype principal_id: str
    :ivar tenant_id: UUID/GUID based Tenant Id of the Security Principal.
    :vartype tenant_id: str
    :ivar ledger_role_name: LedgerRole associated with the Security Principal of Ledger. Known
     values are: "Reader", "Contributor", and "Administrator".
    :vartype ledger_role_name: str or ~azure.mgmt.confidentialledger.models.LedgerRoleName
    """

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "ledger_role_name": {"key": "ledgerRoleName", "type": "str"},
    }

    def __init__(
        self,
        *,
        principal_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        ledger_role_name: Optional[Union[str, "_models.LedgerRoleName"]] = None,
        **kwargs
    ):
        """
        :keyword principal_id: UUID/GUID based Principal Id of the Security Principal.
        :paramtype principal_id: str
        :keyword tenant_id: UUID/GUID based Tenant Id of the Security Principal.
        :paramtype tenant_id: str
        :keyword ledger_role_name: LedgerRole associated with the Security Principal of Ledger. Known
         values are: "Reader", "Contributor", and "Administrator".
        :paramtype ledger_role_name: str or ~azure.mgmt.confidentialledger.models.LedgerRoleName
        """
        super().__init__(**kwargs)
        self.principal_id = principal_id
        self.tenant_id = tenant_id
        self.ledger_role_name = ledger_role_name


class CertBasedSecurityPrincipal(_serialization.Model):
    """Cert based security principal with Ledger RoleName.

    :ivar cert: Public key of the user cert (.pem or .cer).
    :vartype cert: str
    :ivar ledger_role_name: LedgerRole associated with the Security Principal of Ledger. Known
     values are: "Reader", "Contributor", and "Administrator".
    :vartype ledger_role_name: str or ~azure.mgmt.confidentialledger.models.LedgerRoleName
    """

    _attribute_map = {
        "cert": {"key": "cert", "type": "str"},
        "ledger_role_name": {"key": "ledgerRoleName", "type": "str"},
    }

    def __init__(
        self,
        *,
        cert: Optional[str] = None,
        ledger_role_name: Optional[Union[str, "_models.LedgerRoleName"]] = None,
        **kwargs
    ):
        """
        :keyword cert: Public key of the user cert (.pem or .cer).
        :paramtype cert: str
        :keyword ledger_role_name: LedgerRole associated with the Security Principal of Ledger. Known
         values are: "Reader", "Contributor", and "Administrator".
        :paramtype ledger_role_name: str or ~azure.mgmt.confidentialledger.models.LedgerRoleName
        """
        super().__init__(**kwargs)
        self.cert = cert
        self.ledger_role_name = ledger_role_name


class Tags(_serialization.Model):
    """Tags for Confidential Ledger Resource.

    :ivar tags: Additional tags for Confidential Ledger.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Additional tags for Confidential Ledger.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class Location(_serialization.Model):
    """Location of the ARM Resource.

    :ivar location: The Azure location where the Confidential Ledger is running.
    :vartype location: str
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: Optional[str] = None, **kwargs):
        """
        :keyword location: The Azure location where the Confidential Ledger is running.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.location = location


class Resource(_serialization.Model):
    """An Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the Resource.
    :vartype name: str
    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.confidentialledger.models.SystemData
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.id = None
        self.type = None
        self.system_data = None


class ConfidentialLedger(Resource, Location, Tags):
    """Confidential Ledger. Contains the properties of Confidential Ledger Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Additional tags for Confidential Ledger.
    :vartype tags: dict[str, str]
    :ivar location: The Azure location where the Confidential Ledger is running.
    :vartype location: str
    :ivar name: Name of the Resource.
    :vartype name: str
    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.confidentialledger.models.SystemData
    :ivar properties: Properties of Confidential Ledger Resource.
    :vartype properties: ~azure.mgmt.confidentialledger.models.LedgerProperties
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "LedgerProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        properties: Optional["_models.LedgerProperties"] = None,
        **kwargs
    ):
        """
        :keyword tags: Additional tags for Confidential Ledger.
        :paramtype tags: dict[str, str]
        :keyword location: The Azure location where the Confidential Ledger is running.
        :paramtype location: str
        :keyword properties: Properties of Confidential Ledger Resource.
        :paramtype properties: ~azure.mgmt.confidentialledger.models.LedgerProperties
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.tags = tags
        self.location = location
        self.properties = properties
        self.name = None
        self.id = None
        self.type = None
        self.system_data = None


class ConfidentialLedgerList(_serialization.Model):
    """Object that includes an array of Confidential Ledgers and a possible link for next set.

    :ivar value: List of Confidential Ledgers.
    :vartype value: list[~azure.mgmt.confidentialledger.models.ConfidentialLedger]
    :ivar next_link: The URL the client should use to fetch the next page (per server side paging).
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ConfidentialLedger]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ConfidentialLedger"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: List of Confidential Ledgers.
        :paramtype value: list[~azure.mgmt.confidentialledger.models.ConfidentialLedger]
        :keyword next_link: The URL the client should use to fetch the next page (per server side
         paging).
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.confidentialledger.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.confidentialledger.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.confidentialledger.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.confidentialledger.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class LedgerProperties(_serialization.Model):
    """Additional Confidential Ledger properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ledger_name: Unique name for the Confidential Ledger.
    :vartype ledger_name: str
    :ivar ledger_uri: Endpoint for calling Ledger Service.
    :vartype ledger_uri: str
    :ivar identity_service_uri: Endpoint for accessing network identity.
    :vartype identity_service_uri: str
    :ivar ledger_internal_namespace: Internal namespace for the Ledger.
    :vartype ledger_internal_namespace: str
    :ivar ledger_storage_account: Name of the Blob Storage Account for saving ledger files.
    :vartype ledger_storage_account: str
    :ivar ledger_type: Type of Confidential Ledger. Known values are: "Unknown", "Public", and
     "Private".
    :vartype ledger_type: str or ~azure.mgmt.confidentialledger.models.LedgerType
    :ivar provisioning_state: Provisioning state of Ledger Resource. Known values are: "Unknown",
     "Succeeded", "Failed", "Canceled", "Creating", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.confidentialledger.models.ProvisioningState
    :ivar aad_based_security_principals: Array of all AAD based Security Principals.
    :vartype aad_based_security_principals:
     list[~azure.mgmt.confidentialledger.models.AADBasedSecurityPrincipal]
    :ivar cert_based_security_principals: Array of all cert based Security Principals.
    :vartype cert_based_security_principals:
     list[~azure.mgmt.confidentialledger.models.CertBasedSecurityPrincipal]
    """

    _validation = {
        "ledger_name": {"readonly": True},
        "ledger_uri": {"readonly": True},
        "identity_service_uri": {"readonly": True},
        "ledger_internal_namespace": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "ledger_name": {"key": "ledgerName", "type": "str"},
        "ledger_uri": {"key": "ledgerUri", "type": "str"},
        "identity_service_uri": {"key": "identityServiceUri", "type": "str"},
        "ledger_internal_namespace": {"key": "ledgerInternalNamespace", "type": "str"},
        "ledger_storage_account": {"key": "ledgerStorageAccount", "type": "str"},
        "ledger_type": {"key": "ledgerType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "aad_based_security_principals": {"key": "aadBasedSecurityPrincipals", "type": "[AADBasedSecurityPrincipal]"},
        "cert_based_security_principals": {
            "key": "certBasedSecurityPrincipals",
            "type": "[CertBasedSecurityPrincipal]",
        },
    }

    def __init__(
        self,
        *,
        ledger_storage_account: Optional[str] = None,
        ledger_type: Optional[Union[str, "_models.LedgerType"]] = None,
        aad_based_security_principals: Optional[List["_models.AADBasedSecurityPrincipal"]] = None,
        cert_based_security_principals: Optional[List["_models.CertBasedSecurityPrincipal"]] = None,
        **kwargs
    ):
        """
        :keyword ledger_storage_account: Name of the Blob Storage Account for saving ledger files.
        :paramtype ledger_storage_account: str
        :keyword ledger_type: Type of Confidential Ledger. Known values are: "Unknown", "Public", and
         "Private".
        :paramtype ledger_type: str or ~azure.mgmt.confidentialledger.models.LedgerType
        :keyword aad_based_security_principals: Array of all AAD based Security Principals.
        :paramtype aad_based_security_principals:
         list[~azure.mgmt.confidentialledger.models.AADBasedSecurityPrincipal]
        :keyword cert_based_security_principals: Array of all cert based Security Principals.
        :paramtype cert_based_security_principals:
         list[~azure.mgmt.confidentialledger.models.CertBasedSecurityPrincipal]
        """
        super().__init__(**kwargs)
        self.ledger_name = None
        self.ledger_uri = None
        self.identity_service_uri = None
        self.ledger_internal_namespace = None
        self.ledger_storage_account = ledger_storage_account
        self.ledger_type = ledger_type
        self.provisioning_state = None
        self.aad_based_security_principals = aad_based_security_principals
        self.cert_based_security_principals = cert_based_security_principals


class ResourceProviderOperationDefinition(_serialization.Model):
    """Describes the Resource Provider Operation.

    :ivar name: Resource provider operation name.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is data action or not.
    :vartype is_data_action: bool
    :ivar display: Details about the operations.
    :vartype display: ~azure.mgmt.confidentialledger.models.ResourceProviderOperationDisplay
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "ResourceProviderOperationDisplay"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["_models.ResourceProviderOperationDisplay"] = None,
        **kwargs
    ):
        """
        :keyword name: Resource provider operation name.
        :paramtype name: str
        :keyword is_data_action: Indicates whether the operation is data action or not.
        :paramtype is_data_action: bool
        :keyword display: Details about the operations.
        :paramtype display: ~azure.mgmt.confidentialledger.models.ResourceProviderOperationDisplay
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display


class ResourceProviderOperationDisplay(_serialization.Model):
    """Describes the properties of the Operation.

    :ivar provider: Name of the resource provider.
    :vartype provider: str
    :ivar resource: Name of the resource type.
    :vartype resource: str
    :ivar operation: Name of the resource provider operation.
    :vartype operation: str
    :ivar description: Description of the resource provider operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Name of the resource provider.
        :paramtype provider: str
        :keyword resource: Name of the resource type.
        :paramtype resource: str
        :keyword operation: Name of the resource provider operation.
        :paramtype operation: str
        :keyword description: Description of the resource provider operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class ResourceProviderOperationList(_serialization.Model):
    """List containing this Resource Provider's available operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Resource provider operations list.
    :vartype value: list[~azure.mgmt.confidentialledger.models.ResourceProviderOperationDefinition]
    :ivar next_link: The URI that can be used to request the next page for list of Azure
     operations.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceProviderOperationDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.confidentialledger.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.confidentialledger.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.confidentialledger.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.confidentialledger.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
