/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wbs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamColors;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.ugraphic.color.HColor;

final class WElement {
    private final HColor backColor;
    private final Display label;
    private final int level;
    private final String stereotype;
    private final WElement parent;
    private final StyleBuilder styleBuilder;
    private final List<WElement> childrenLeft = new ArrayList<WElement>();
    private final List<WElement> childrenRight = new ArrayList<WElement>();
    private final IdeaShape shape;

    private StyleSignature getDefaultStyleDefinitionNode(int level) {
        String depth = SName.depth(level);
        if (level == 0) {
            return StyleSignature.of(SName.root, SName.element, SName.wbsDiagram, SName.node, SName.rootNode).add(this.stereotype).add(depth);
        }
        if (this.shape == IdeaShape.NONE && this.isLeaf()) {
            return StyleSignature.of(SName.root, SName.element, SName.wbsDiagram, SName.node, SName.leafNode, SName.boxless).add(this.stereotype).add(depth);
        }
        if (this.isLeaf()) {
            return StyleSignature.of(SName.root, SName.element, SName.wbsDiagram, SName.node, SName.leafNode).add(this.stereotype).add(depth);
        }
        if (this.shape == IdeaShape.NONE) {
            return StyleSignature.of(SName.root, SName.element, SName.wbsDiagram, SName.node, SName.boxless).add(this.stereotype).add(depth);
        }
        return StyleSignature.of(SName.root, SName.element, SName.wbsDiagram, SName.node).add(this.stereotype).add(depth);
    }

    public ISkinParam withBackColor(ISkinParam skinParam) {
        if (this.backColor == null) {
            return skinParam;
        }
        return new SkinParamColors(skinParam, Colors.empty().add(ColorType.BACK, this.backColor));
    }

    public Style getStyle() {
        Style result = this.getDefaultStyleDefinitionNode(this.level).getMergedStyle(this.styleBuilder);
        WElement up = this.parent;
        while (up != null) {
            StyleSignature ss = up.getDefaultStyleDefinitionNode(this.level).addStar();
            Style p = ss.getMergedStyle(this.styleBuilder);
            result = result.mergeWith(p);
            up = up.parent;
        }
        return result;
    }

    public WElement(HColor backColor, Display label, String stereotype, StyleBuilder styleBuilder, IdeaShape shape) {
        this(backColor, 0, label, stereotype, null, shape, styleBuilder);
    }

    private WElement(HColor backColor, int level, Display label, String stereotype, WElement parent, IdeaShape shape, StyleBuilder styleBuilder) {
        this.label = label;
        this.backColor = backColor;
        this.level = level;
        this.parent = parent;
        this.shape = shape;
        this.styleBuilder = styleBuilder;
        this.stereotype = stereotype;
    }

    public boolean isLeaf() {
        return this.childrenLeft.size() == 0 && this.childrenRight.size() == 0;
    }

    public WElement createElement(HColor backColor, int newLevel, Display newLabel, String stereotype, Direction direction, IdeaShape shape, StyleBuilder styleBuilder) {
        WElement result = new WElement(backColor, newLevel, newLabel, stereotype, this, shape, styleBuilder);
        if (direction == Direction.LEFT) {
            this.childrenLeft.add(result);
        } else {
            this.childrenRight.add(result);
        }
        return result;
    }

    public String toString() {
        return this.label.toString();
    }

    public final int getLevel() {
        return this.level;
    }

    public final Display getLabel() {
        return this.label;
    }

    public Collection<WElement> getChildren(Direction direction) {
        if (direction == Direction.LEFT) {
            return Collections.unmodifiableList(this.childrenLeft);
        }
        return Collections.unmodifiableList(this.childrenRight);
    }

    public WElement getParent() {
        return this.parent;
    }

    public final IdeaShape getShape() {
        return this.shape;
    }

    public final StyleBuilder getStyleBuilder() {
        return this.styleBuilder;
    }
}

