// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef FILEOPENOPTIONS_H
#define FILEOPENOPTIONS_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>

class DBOptionsAttributes;
#include <DBPluginInfoAttributes.h>

// ****************************************************************************
// Class: FileOpenOptions
//
// Purpose:
//    This class contains the file opening options for all the database plugins.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API FileOpenOptions : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    FileOpenOptions();
    FileOpenOptions(const FileOpenOptions &obj);
protected:
    // These constructors are for objects derived from this class
    FileOpenOptions(private_tmfs_t tmfs);
    FileOpenOptions(const FileOpenOptions &obj, private_tmfs_t tmfs);
public:
    virtual ~FileOpenOptions();

    virtual FileOpenOptions& operator = (const FileOpenOptions &obj);
    virtual bool operator == (const FileOpenOptions &obj) const;
    virtual bool operator != (const FileOpenOptions &obj) const;
private:
    void Init();
    void Copy(const FileOpenOptions &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectTypeNames();
    void SelectTypeIDs();
    void SelectOpenOptions();
    void SelectEnabled();
    void SelectPreferredIDs();

    // Property setting methods
    void SetTypeNames(const stringVector &typeNames_);
    void SetTypeIDs(const stringVector &typeIDs_);
    void SetEnabled(const intVector &Enabled_);
    void SetPreferredIDs(const stringVector &preferredIDs_);

    // Property getting methods
    const stringVector &GetTypeNames() const;
          stringVector &GetTypeNames();
    const stringVector &GetTypeIDs() const;
          stringVector &GetTypeIDs();
    const AttributeGroupVector &GetOpenOptions() const;
          AttributeGroupVector &GetOpenOptions();
    const intVector    &GetEnabled() const;
          intVector    &GetEnabled();
    const stringVector &GetPreferredIDs() const;
          stringVector &GetPreferredIDs();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Attributegroup convenience methods
    void AddOpenOptions(const DBOptionsAttributes &);
    void ClearOpenOptions();
    void RemoveOpenOptions(int i);
    int  GetNumOpenOptions() const;
    DBOptionsAttributes &GetOpenOptions(int i);
    const DBOptionsAttributes &GetOpenOptions(int i) const;

    DBOptionsAttributes &operator [] (int i);
    const DBOptionsAttributes &operator [] (int i) const;


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    void MergeNewFromPluginInfo(const DBPluginInfoAttributes*);
    void AddAssumedFormatsToPreferred(const stringVector &formats);
    void AddFallbackFormatsToPreferred(const stringVector &given);
    const DBOptionsAttributes *GetOpenOptionsForID(const std::string&);
    bool IsIDEnabled(const std::string&);

    // IDs that can be used to identify fields in case statements
    enum {
        ID_typeNames = 0,
        ID_typeIDs,
        ID_openOptions,
        ID_Enabled,
        ID_preferredIDs,
        ID__LAST
    };

protected:
    AttributeGroup *CreateSubAttributeGroup(int index);
private:
    stringVector         typeNames;
    stringVector         typeIDs;
    AttributeGroupVector openOptions;
    intVector            Enabled;
    stringVector         preferredIDs;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define FILEOPENOPTIONS_TMFS "s*s*a*i*s*"

#endif
