! -*- fortran -*-
!
! Copyright (c) 2004-2006 The Trustees of Indiana University and Indiana
!                         University Research and Technology
!                         Corporation.  All rights reserved.
! Copyright (c) 2004-2005 The University of Tennessee and The University
!                         of Tennessee Research Foundation.  All rights
!                         reserved.
! Copyright (c) 2004-2005 High Performance Computing Center Stuttgart,
!                         University of Stuttgart.  All rights reserved.
! Copyright (c) 2004-2005 The Regents of the University of California.
!                         All rights reserved.
! Copyright (c) 2006-2014 Cisco Systems, Inc.  All rights reserved.
! Copyright (c) 2016      Research Organization for Information Science
!                         and Technology (RIST). All rights reserved.
! $COPYRIGHT$
!
! Additional copyrights may follow
!
! $HEADER$
!

interface PMPI_File_call_errhandler

subroutine PMPI_File_call_errhandler(fh, errorcode, ierror)
  integer, intent(in) :: fh
  integer, intent(in) :: errorcode
  integer, intent(out) :: ierror
end subroutine PMPI_File_call_errhandler

end interface


interface PMPI_File_close

subroutine PMPI_File_close(fh, ierror)
  integer, intent(inout) :: fh
  integer, intent(out) :: ierror
end subroutine PMPI_File_close

end interface


interface PMPI_File_create_errhandler

subroutine PMPI_File_create_errhandler(function, errhandler, ierror)
  external :: function
  integer, intent(out) :: errhandler
  integer, intent(out) :: ierror
end subroutine PMPI_File_create_errhandler

end interface


interface PMPI_File_delete

subroutine PMPI_File_delete(filename, info, ierror)
  character(len=*), intent(in) :: filename
  integer, intent(in) :: info
  integer, intent(out) :: ierror
end subroutine PMPI_File_delete

end interface


interface PMPI_File_get_amode

subroutine PMPI_File_get_amode(fh, amode, ierror)
  integer, intent(in) :: fh
  integer, intent(out) :: amode
  integer, intent(out) :: ierror
end subroutine PMPI_File_get_amode

end interface


interface PMPI_File_get_atomicity

subroutine PMPI_File_get_atomicity(fh, flag, ierror)
  integer, intent(in) :: fh
  logical, intent(out) :: flag
  integer, intent(out) :: ierror
end subroutine PMPI_File_get_atomicity

end interface


interface PMPI_File_get_byte_offset

subroutine PMPI_File_get_byte_offset(fh, offset, disp, ierror)
  include 'mpif-config.h'
  integer, intent(in) :: fh
  integer(kind=MPI_OFFSET_KIND), intent(in) :: offset
  integer(kind=MPI_OFFSET_KIND), intent(out) :: disp
  integer, intent(out) :: ierror
end subroutine PMPI_File_get_byte_offset

end interface


interface PMPI_File_get_errhandler

subroutine PMPI_File_get_errhandler(file, errhandler, ierror)
  integer, intent(in) :: file
  integer, intent(out) :: errhandler
  integer, intent(out) :: ierror
end subroutine PMPI_File_get_errhandler

end interface


interface PMPI_File_get_group

subroutine PMPI_File_get_group(fh, group, ierror)
  integer, intent(in) :: fh
  integer, intent(out) :: group
  integer, intent(out) :: ierror
end subroutine PMPI_File_get_group

end interface


interface PMPI_File_get_info

subroutine PMPI_File_get_info(fh, info_used, ierror)
  integer, intent(in) :: fh
  integer, intent(out) :: info_used
  integer, intent(out) :: ierror
end subroutine PMPI_File_get_info

end interface


interface PMPI_File_get_position

subroutine PMPI_File_get_position(fh, offset, ierror)
  include 'mpif-config.h'
  integer, intent(in) :: fh
  integer(kind=MPI_OFFSET_KIND), intent(out) :: offset
  integer, intent(out) :: ierror
end subroutine PMPI_File_get_position

end interface


interface PMPI_File_get_position_shared

subroutine PMPI_File_get_position_shared(fh, offset, ierror)
  include 'mpif-config.h'
  integer, intent(in) :: fh
  integer(kind=MPI_OFFSET_KIND), intent(out) :: offset
  integer, intent(out) :: ierror
end subroutine PMPI_File_get_position_shared

end interface


interface PMPI_File_get_size

subroutine PMPI_File_get_size(fh, size, ierror)
  include 'mpif-config.h'
  integer, intent(in) :: fh
  integer(kind=MPI_OFFSET_KIND), intent(out) :: size
  integer, intent(out) :: ierror
end subroutine PMPI_File_get_size

end interface


interface PMPI_File_get_type_extent

subroutine PMPI_File_get_type_extent(fh, datatype, extent, ierror)
  include 'mpif-config.h'
  integer, intent(in) :: fh
  integer, intent(in) :: datatype
  integer(kind=MPI_ADDRESS_KIND), intent(out) :: extent
  integer, intent(out) :: ierror
end subroutine PMPI_File_get_type_extent

end interface


interface PMPI_File_get_view

subroutine PMPI_File_get_view(fh, disp, etype, filetype, datarep&
        , ierror)
  include 'mpif-config.h'
  integer, intent(in) :: fh
  integer(kind=MPI_OFFSET_KIND), intent(out) :: disp
  integer, intent(out) :: etype
  integer, intent(out) :: filetype
  character(len=*), intent(out) :: datarep
  integer, intent(out) :: ierror
end subroutine PMPI_File_get_view

end interface


interface PMPI_File_open

subroutine PMPI_File_open(comm, filename, amode, info, fh&
        , ierror)
  integer, intent(in) :: comm
  character(len=*), intent(in) :: filename
  integer, intent(in) :: amode
  integer, intent(in) :: info
  integer, intent(out) :: fh
  integer, intent(out) :: ierror
end subroutine PMPI_File_open

end interface


interface PMPI_File_preallocate

subroutine PMPI_File_preallocate(fh, size, ierror)
  include 'mpif-config.h'
  integer, intent(in) :: fh
  integer(kind=MPI_OFFSET_KIND), intent(in) :: size
  integer, intent(out) :: ierror
end subroutine PMPI_File_preallocate

end interface


interface PMPI_File_seek

subroutine PMPI_File_seek(fh, offset, whence, ierror)
  include 'mpif-config.h'
  integer, intent(in) :: fh
  integer(kind=MPI_OFFSET_KIND), intent(in) :: offset
  integer, intent(in) :: whence
  integer, intent(out) :: ierror
end subroutine PMPI_File_seek

end interface


interface PMPI_File_seek_shared

subroutine PMPI_File_seek_shared(fh, offset, whence, ierror)
  include 'mpif-config.h'
  integer, intent(in) :: fh
  integer(kind=MPI_OFFSET_KIND), intent(in) :: offset
  integer, intent(in) :: whence
  integer, intent(out) :: ierror
end subroutine PMPI_File_seek_shared

end interface


interface PMPI_File_set_atomicity

subroutine PMPI_File_set_atomicity(fh, flag, ierror)
  integer, intent(in) :: fh
  logical, intent(in) :: flag
  integer, intent(out) :: ierror
end subroutine PMPI_File_set_atomicity

end interface


interface PMPI_File_set_errhandler

subroutine PMPI_File_set_errhandler(file, errhandler, ierror)
  integer, intent(in) :: file
  integer, intent(in) :: errhandler
  integer, intent(out) :: ierror
end subroutine PMPI_File_set_errhandler

end interface


interface PMPI_File_set_info

subroutine PMPI_File_set_info(fh, info, ierror)
  integer, intent(in) :: fh
  integer, intent(in) :: info
  integer, intent(out) :: ierror
end subroutine PMPI_File_set_info

end interface


interface PMPI_File_set_size

subroutine PMPI_File_set_size(fh, size, ierror)
  include 'mpif-config.h'
  integer, intent(in) :: fh
  integer(kind=MPI_OFFSET_KIND), intent(in) :: size
  integer, intent(out) :: ierror
end subroutine PMPI_File_set_size

end interface


interface PMPI_File_set_view

subroutine PMPI_File_set_view(fh, disp, etype, filetype, datarep, &
        info, ierror)
  include 'mpif-config.h'
  integer, intent(in) :: fh
  integer(kind=MPI_OFFSET_KIND), intent(in) :: disp
  integer, intent(in) :: etype
  integer, intent(in) :: filetype
  character(len=*), intent(in) :: datarep
  integer, intent(in) :: info
  integer, intent(out) :: ierror
end subroutine PMPI_File_set_view

end interface


interface PMPI_File_sync

subroutine PMPI_File_sync(fh, ierror)
  integer, intent(in) :: fh
  integer, intent(out) :: ierror
end subroutine PMPI_File_sync

end interface
