#!/bin/bash
#This tests hybrid (lexical/numeric) comparison using locale rules.
msort -j -q -l -w -c h -s en_US < HybridComparisonTest02.data > HybridComparisonTest02.result
echo -n "HybridComparisonTest02		" >> LocaleTestResults;
if cmp -s HybridComparisonTest02.result HybridComparisonTest02.norm
then echo "PASSED" >> LocaleTestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> LocaleTestResults;
fi
msort -j -q -l -n 1 -c m -s en_US -n 2 -c n < MonthNameTest01.data > MonthNameTest01.result
echo -n "MonthNameTest01			" >> LocaleTestResults;
if cmp -s MonthNameTest01.result MonthNameTest01.norm
then echo "PASSED" >> LocaleTestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> LocaleTestResults;
fi
#This tests month name sorting using locale data in a non-UTF-8 locale
msort -j -q -l -n 1 -c m -s ja_JP.EUC-JP < MonthNameTest03.data > MonthNameTest03.result
echo -n "MonthNameTest03			" >> LocaleTestResults;
if cmp -s MonthNameTest03.result MonthNameTest03.norm
then echo "PASSED" >> LocaleTestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> LocaleTestResults;
fi
#This tests month name sorting using locale data in a non-UTF-8 locale
msort -j -q -l -n 1 -c m -s fr_FR < MonthNameTest04.data > MonthNameTest04.result
echo -n "MonthNameTest04			" >> LocaleTestResults;
if cmp -s MonthNameTest04.result MonthNameTest04.norm
then echo "PASSED" >> LocaleTestResults;
else echo $'\x1b[1m\x1b[31mFAILED\x1b[0m' >> LocaleTestResults;
fi




