# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.pass_input_type_algorithm import PassInputTypeAlgorithm


class MergeVectorComponents(PassInputTypeAlgorithm):
    r"""
    MergeVectorComponents - merge components of many single-component
    arrays into one vector
    
    Superclass: PassInputTypeAlgorithm
    
    MergeVectorComponents is a filter that merges three
    single-component arrays into one vector. This is accomplished by
    creating one output vector with 3 components. The type of the output
    vector is DoubleArray. The user needs to define the names of the
    single-component arrays and the attribute-type of the arrays, i.e.
    point-data or cell-data.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMergeVectorComponents, obj, update, **traits)
    
    attribute_type = tvtk_base.RevPrefixMap({'point_data': 0, 'cell_data': 1}, default_value='point_data', desc=\
        r"""
        Control which attribute_type the filter operates on (point data or
        cell data for DataSets). The default value is
        DataObject::POINT. The input value for this function should be
        either DataObject::POINT or DataObject::CELL.
        """
    )

    def _attribute_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAttributeType,
                        self.attribute_type_)

    output_vector_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Set the name of the output combination vector. If name is
        undefined, the output vector will be named, "combinationVector".
        """
    )

    def _output_vector_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputVectorName,
                        self.output_vector_name)

    x_array_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Set the name of the array to use as the X component of the
        combination vector
        """
    )

    def _x_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetXArrayName,
                        self.x_array_name)

    y_array_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Set the name of the array to use as the Y component of the
        combination vector
        """
    )

    def _y_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetYArrayName,
                        self.y_array_name)

    z_array_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Set the name of the array to use as the Z attribute of the
        combination vector
        """
    )

    def _z_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetZArrayName,
                        self.z_array_name)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('attribute_type', 'GetAttributeType'), ('output_vector_name',
    'GetOutputVectorName'), ('x_array_name', 'GetXArrayName'),
    ('y_array_name', 'GetYArrayName'), ('z_array_name', 'GetZArrayName'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'attribute_type', 'output_vector_name',
    'progress_text', 'x_array_name', 'y_array_name', 'z_array_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(MergeVectorComponents, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit MergeVectorComponents properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], ['attribute_type'], ['output_vector_name', 'x_array_name',
            'y_array_name', 'z_array_name']),
            title='Edit MergeVectorComponents properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit MergeVectorComponents properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

