# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class FitToHeightMapFilter(PolyDataAlgorithm):
    r"""
    FitToHeightMapFilter - adjust polydata to fit image height map
    
    Superclass: PolyDataAlgorithm
    
    FitToHeightMapFilter "drapes" or "covers" a height map image by
    determining new point coordinates of an input polydata by projecting
    (in the z-direction) onto the height map. Different projection
    approaches can be used including projecting points, or averaging /
    taking the minimum / taking the maximum of the cell's points or
    sampled interior points.  The filter passes the input to the output,
    however new new point coordinates are generated, and point normals
    are not passed through. Note that the draping supports verts, lines,
    polygons, and triangle strips.
    
    @warning
    Since new point coordinates are generated, planar polygons may become
    non-planar. To guarantee planarity, use a triangle mesh as input.
    Also note that strategies based on averaging across a cell, or the
    points of a cell, set the z-value for all of the cell's points to the
    same value. However, as currently written, depending on the order in
    which cells are processed, the last z-value set is the final value
    (since points may be shared by multiple cells). Thus the filter works
    best with triangle meshes, or if cells are topologically disconnected
    (i.e., points are only used by one cell - use ShrinkFilter to
    topologically disconnect the cells in a mesh).
    
    @warning
    The point normals are not passed through to the output as the
    projection process may distort the projected polydata surface.
    
    @warning
    The interior cell sampling is currently carried out by triangulating
    the cells, and then taking the centroid of each resulting triangle.
    Thus the number of samples for each cell is (number of cell points -
    2). Future implementations may use a different sampling strategy.
    
    @warning
    Points outside of the height map image are clamped to the boundary of
    the height map. This may produce unexpected behavior in some cases.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    TrimmedExtrusionFilter ShrinkFilter ShrinkPolyData
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkFitToHeightMapFilter, obj, update, **traits)
    
    use_height_map_offset = tvtk_base.true_bool_trait(desc=\
        r"""
        Indicate whether the z-offset from the image height map should be
        added to the final result. Some height map images are offset in
        z-coordinate which is independent of the height map values. By
        default this value is true.
        """
    )

    def _use_height_map_offset_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseHeightMapOffset,
                        self.use_height_map_offset_)

    fitting_strategy = tvtk_base.RevPrefixMap({'point_projection': 0, 'average_height': 3, 'cell_average_height': 6, 'cell_maximum_height': 5, 'cell_minimum_height': 4, 'point_maximum_height': 2, 'point_minimum_height': 1}, default_value='point_projection', desc=\
        r"""
        Specify a strategy for fitting, or projecting, the polydata to
        the height field.  By default the points of the polydata are
        projected onto the height field (POINT_PROJECTION).  However, to
        preserve planarity, or to fit the polydata cells at the
        average/minimum/maximum height to the height field, different
        strategies can be used (i.e., placing the cells). The point-based
        strategies (e.g, POINT_MINIMUM_HEIGHT) set the cell at the
        minimum height of the cell's points (and so on). The cell-based
        strategies (e.g., CELL_MINIMUM_HEIGHT) sample the interior of the
        cell and place the cell at the minimum height (and so on) of the
        cell's sampled interior points.
        """
    )

    def _fitting_strategy_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFittingStrategy,
                        self.fitting_strategy_)

    def _get_height_map(self):
        return wrap_vtk(self._vtk_obj.GetHeightMap())
    height_map = traits.Property(_get_height_map, desc=\
        r"""
        Get a pointer to the height map.
        """
    )

    def get_height_map(self, *args):
        """
        get_height_map(self) -> ImageData
        C++: ImageData *get_height_map()
        get_height_map(self, sourceInfo:InformationVector)
            -> ImageData
        C++: ImageData *get_height_map(InformationVector *sourceInfo)
        Get a pointer to the height map.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetHeightMap, *my_args)
        return wrap_vtk(ret)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def set_height_map_connection(self, *args):
        """
        set_height_map_connection(self, algOutput:AlgorithmOutput) -> None
        C++: void set_height_map_connection(AlgorithmOutput *algOutput)
        Specify the pipeline connection to the height map.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetHeightMapConnection, *my_args)
        return ret

    def set_height_map_data(self, *args):
        """
        set_height_map_data(self, idata:ImageData) -> None
        C++: void set_height_map_data(ImageData *idata)
        Set the height map for the filter.  Note that this method does
        not connect the pipeline. The algorithm will work on the input
        data as it is without updating the producer of the data.  See
        set_height_map_connection() for connecting the pipeline.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetHeightMapData, *my_args)
        return ret

    _updateable_traits_ = \
    (('use_height_map_offset', 'GetUseHeightMapOffset'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('fitting_strategy',
    'GetFittingStrategy'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'use_height_map_offset', 'fitting_strategy',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(FitToHeightMapFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit FitToHeightMapFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['use_height_map_offset'], ['fitting_strategy'], []),
            title='Edit FitToHeightMapFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit FitToHeightMapFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

