/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once


/////////////////////// Local includes
#include "MsXpS/libXpertMassCore/globals.hpp"
#include "MsXpS/libXpertMassCore/FragmentationPathway.hpp"


namespace MsXpS
{
namespace libXpertMassCore
{


class DECLSPEC FragmentationConfig : public FragmentationPathway
{
  public:
  FragmentationConfig(PolChemDefCstSPtr pol_chem_def_csp,
                      const QString &name,
                      const QString &formula,
                      Enums::FragEnd frag_end       = Enums::FragEnd::NE,
                      const QString &comment = QString(),
                      bool sequence_embedded = false);

  FragmentationConfig(const FragmentationPathway &fragmentationPathway,
                      int start_index        = 0,
                      int stop_index         = 0,
                      bool sequence_embedded = false);

  FragmentationConfig(const FragmentationConfig &other);

  ~FragmentationConfig();

  FragmentationConfig &operator=(const FragmentationConfig &other);

  void setStartIonizeLevel(std::size_t index);
  std::size_t getStartIonizeLevel() const;

  void setStopIonizeLevel(std::size_t index);
  std::size_t getStopIonizeLevel() const;

  void setIonizeLevels(std::size_t start, std::size_t stop);

  void setStartIndex(std::size_t value);
  std::size_t getStartIndex() const;

  void setStopIndex(std::size_t value);
  std::size_t getStopIndex() const;

  bool addFormula(const Formula &formula);
  bool addFormula(const QString &formula_string);
  const std::vector<Formula> &getFormulasCstRef() const;
  std::vector<Formula> &getFormulasRef();

  void setSequenceEmbedded(bool);
  bool isSequenceEmbedded() const;

  QString toString() const;

  protected:
  std::size_t m_startIndex = 0;
  std::size_t m_stopIndex = 0;

  // These two values have to be both positive and in increasing order
  // or equal. That is m_stopIonizeLevel >= m_startIonizeLevel. Only
  // use access functions to set their values.
  // // Have to be 1 and not 0, otherwise the setting functions ensuring
  // that m_startIonizeLevel>=m_stopIonizeLevel will bug.
  std::size_t m_startIonizeLevel = 1;
  std::size_t m_stopIonizeLevel  = 1;

  bool m_sequenceEmbedded;

  std::vector<Formula> m_formulas;
};


} // namespace libXpertMassCore
} // namespace MsXpS
