/* ----- core/multsntrup653, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_multsntrup653_checksums[] = {
  "426661f4ba18f29eae9e2b7d4d6c1569e9f91db693cafb76ede67fba9873b64b",
  "5f42341ecdbb0e13b2d071ecc75f874ae3b0fa913f8b62fcf93fcb13d01b417c",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_multsntrup653_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_multsntrup653_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_multsntrup653_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_multsntrup653_CONSTBYTES

static void *storage_core_multsntrup653_h;
static unsigned char *test_core_multsntrup653_h;
static void *storage_core_multsntrup653_n;
static unsigned char *test_core_multsntrup653_n;
static void *storage_core_multsntrup653_k;
static unsigned char *test_core_multsntrup653_k;
static void *storage_core_multsntrup653_c;
static unsigned char *test_core_multsntrup653_c;
static void *storage_core_multsntrup653_h2;
static unsigned char *test_core_multsntrup653_h2;
static void *storage_core_multsntrup653_n2;
static unsigned char *test_core_multsntrup653_n2;
static void *storage_core_multsntrup653_k2;
static unsigned char *test_core_multsntrup653_k2;
static void *storage_core_multsntrup653_c2;
static unsigned char *test_core_multsntrup653_c2;

#define precomputed_core_multsntrup653_NUM 4

static const unsigned char precomputed_core_multsntrup653_h[precomputed_core_multsntrup653_NUM][crypto_core_OUTPUTBYTES] = {
  {94,6,224,4,178,0,189,248,229,4,154,0,161,250,252,8,239,5,180,4,172,254,141,7,35,255,196,3,19,248,18,3,176,7,250,2,87,2,77,7,24,0,86,7,33,248,178,248,43,253,14,1,134,0,80,6,148,4,44,3,230,254,203,4,73,247,13,7,239,0,182,248,184,247,149,1,142,4,225,254,160,250,118,249,50,255,168,254,227,7,215,5,137,3,245,250,77,4,39,0,37,2,165,255,98,247,122,254,232,253,244,248,190,8,131,255,151,6,190,255,155,7,6,2,70,251,148,5,254,250,169,251,34,253,92,7,255,254,148,5,234,2,178,250,26,248,228,4,94,3,119,8,31,2,35,250,12,0,203,248,56,250,203,6,229,248,114,8,228,247,5,1,160,250,168,8,200,247,86,5,150,5,0,0,224,7,224,0,203,3,31,251,171,1,174,5,64,1,162,2,118,255,229,254,50,249,13,4,150,250,4,3,117,3,157,6,62,5,215,1,181,1,52,0,224,2,82,247,225,5,234,5,151,3,139,250,11,1,45,3,223,1,234,8,135,4,66,0,238,4,68,4,54,1,190,250,123,3,61,7,164,1,70,0,51,251,99,254,60,8,126,248,47,250,92,247,112,0,121,6,9,254,157,8,251,4,167,250,136,250,187,249,124,1,221,252,177,6,204,8,193,248,217,5,228,251,52,249,193,249,158,3,59,249,171,8,161,252,24,248,77,6,28,251,41,5,67,0,66,251,22,255,100,2,118,251,10,6,182,3,154,4,224,1,129,1,214,252,106,4,163,248,214,248,132,1,5,247,13,248,129,8,182,248,87,0,201,253,55,254,230,5,146,251,50,250,182,253,51,3,83,247,117,3,125,0,3,247,26,4,189,3,253,255,254,5,24,251,106,248,208,4,203,0,192,4,123,1,70,2,119,249,126,2,161,5,241,252,218,255,253,255,144,250,115,253,132,249,252,8,44,2,223,7,191,7,67,254,109,6,232,249,82,253,56,253,230,1,98,249,168,6,85,5,241,4,202,251,171,2,226,2,230,0,4,251,139,254,54,3,107,8,140,0,81,0,209,250,18,3,17,251,8,249,251,255,164,247,235,254,107,8,166,250,97,5,172,5,225,252,255,252,54,255,233,3,123,3,6,0,56,249,199,247,228,7,174,253,87,5,5,251,12,1,130,254,60,0,53,251,9,3,168,249,241,2,42,6,193,4,146,4,248,255,198,254,62,251,218,5,27,2,25,2,126,6,72,3,192,253,9,248,23,7,180,252,175,7,71,2,99,2,154,7,91,5,246,6,252,251,147,253,122,249,75,250,222,1,255,247,81,5,88,3,93,2,232,248,20,3,22,4,33,248,191,0,195,252,98,253,62,4,188,0,163,6,112,255,44,254,194,4,130,252,44,5,83,0,36,4,70,251,41,0,23,0,47,251,36,249,176,3,236,0,37,1,157,247,91,3,133,1,204,2,200,253,199,5,229,4,100,4,27,248,1,9,230,255,103,4,2,251,124,3,94,249,231,4,219,4,220,247,105,5,201,249,223,254,182,255,172,4,15,7,159,7,8,254,207,255,111,5,128,254,245,255,67,253,87,2,177,8,240,7,153,250,128,255,244,251,197,254,61,252,88,6,12,252,253,6,234,7,252,255,207,0,118,247,107,0,221,4,85,254,27,7,137,3,156,2,145,251,232,4,3,247,180,251,237,6,158,250,231,8,203,253,16,250,148,252,176,249,170,255,154,1,100,254,210,4,247,254,25,4,211,251,35,0,28,254,105,4,94,1,141,248,34,4,160,5,74,6,137,255,227,5,237,254,187,255,82,248,8,8,130,254,199,6,143,8,86,250,43,7,60,255,103,250,220,5,1,7,225,5,58,252,201,248,176,2,163,3,40,4,191,249,107,248,200,1,202,7,227,247,93,248,54,4,157,3,131,0,24,250,170,255,109,252,79,248,191,251,112,6,143,247,86,251,111,255,224,1,128,250,157,6,171,1,73,254,254,255,159,3,147,4,49,253,198,3,43,4,194,255,219,248,215,254,196,1,130,248,77,7,5,0,195,254,190,4,172,250,9,251,89,6,219,251,179,3,137,248,229,253,171,6,206,252,67,252,14,251,250,3,211,6,106,255,75,1,70,3,61,5,80,4,157,1,145,5,207,6,85,252,66,8,124,5,128,253,229,1,29,250,148,4,48,2,192,4,100,1,1,6,199,254,200,253,147,3,237,247,74,251,156,3,81,250,130,247,235,253,102,7,116,252,227,247,229,252,15,1,221,250,239,249,210,4,167,3,59,7,247,250,60,7,38,3,140,248,96,7,247,252,236,1,230,254,167,253,43,255,154,6,45,248,124,253,108,7,234,8,121,247,253,246,246,4,19,6,181,2,205,0,185,5,71,4,170,254,163,0,12,250,144,7,10,253,19,251,4,6,202,249,7,250,241,253,8,8,64,0,74,7,141,254,20,247,150,250,188,7,16,4,196,247,154,253,184,249,107,248,28,251,157,254,165,247,132,0,130,250,0,8,119,1,228,2,246,255,37,251,247,250,109,247,202,255,168,247,86,247,181,249,230,252,162,254,255,248,102,8,148,251,34,247,133,255,39,249,95,255,179,255,104,4,51,1,68,2,21,255,110,251,61,250,214,254,66,5,179,0,5,5,65,251,163,247,65,2,234,253,226,253,153,249,139,3,66,253,86,252,17,0,223,252,225,251,165,3,151,248,118,8,133,0,93,7,231,1,136,249,216,3,47,255,59,5,0,0,54,247,59,247,48,247,244,4,109,6,141,8,226,253,107,253,82,5,217,1,160,252,198,250,70,248,166,247,140,2,158,5,67,252,149,1,140,7,54,3,61,250,29,253,168,250,109,252,142,8,108,252,110,251,83,5,89,7,72,247,139,253,89,5,58,0,151,251,13,254,98,1,55,5,214,7},
  {94,253,98,3,126,247,87,6,142,2,81,250,195,249,105,255,69,250,15,247,72,253,164,248,116,2,107,247,31,7,70,5,23,254,99,248,56,254,115,251,128,247,208,1,9,249,132,252,182,5,37,253,123,255,229,248,122,5,56,2,194,247,43,3,152,251,1,8,6,251,44,251,120,1,208,249,173,251,59,248,166,7,105,248,79,0,124,1,17,250,1,254,139,249,20,7,201,4,246,3,194,2,158,248,30,251,244,6,94,254,151,4,57,6,191,1,47,0,87,249,158,7,57,254,76,2,83,8,2,8,152,248,22,247,95,4,5,1,66,255,147,255,34,247,207,2,165,255,141,6,190,251,167,252,99,253,28,248,233,252,142,4,172,4,209,253,110,8,227,6,22,248,152,250,105,253,37,5,252,246,87,249,57,250,57,3,61,255,54,249,100,247,191,251,20,8,93,3,89,2,107,247,10,3,202,5,11,7,80,7,58,6,180,3,165,0,61,252,213,251,204,4,107,7,112,250,166,250,70,252,240,249,187,252,22,254,87,251,165,250,98,254,196,6,225,4,238,250,112,255,161,3,131,255,246,0,132,2,73,2,170,253,91,248,214,247,215,3,40,253,42,8,136,247,56,254,100,4,186,253,185,251,12,252,59,252,207,251,114,254,162,248,73,251,198,0,53,6,211,6,200,248,125,249,157,253,62,247,56,254,116,254,44,247,253,247,17,249,49,250,164,7,238,6,81,3,195,3,191,251,250,253,148,1,1,4,213,5,37,252,62,247,188,7,31,252,56,248,59,247,146,1,199,254,87,247,159,4,219,1,148,4,66,0,43,0,240,253,124,251,30,6,5,5,59,7,124,7,7,255,185,249,184,253,197,252,210,250,228,1,79,8,26,3,27,253,171,0,81,2,226,4,59,3,173,249,100,6,201,249,147,255,49,254,0,2,84,253,203,5,99,4,53,1,2,8,36,5,182,1,77,252,154,7,168,7,170,254,143,5,63,250,64,1,116,251,34,2,136,8,184,249,62,3,91,253,125,3,165,1,245,249,28,5,72,7,40,4,7,249,150,0,157,4,122,252,74,249,100,3,213,255,178,253,75,253,210,2,208,249,162,247,69,2,228,253,234,250,196,247,104,3,39,254,13,0,181,5,62,252,19,248,254,251,6,4,43,6,178,247,44,253,97,248,154,255,49,7,226,5,234,5,223,8,193,0,139,6,140,255,194,8,151,8,147,250,78,1,208,0,195,7,92,253,161,6,102,6,255,0,152,252,72,0,154,252,152,251,100,251,173,254,206,1,125,2,166,251,221,4,57,2,90,1,40,249,13,0,24,8,215,1,184,252,112,254,249,251,217,6,120,254,202,250,116,8,168,5,1,255,169,6,113,2,132,6,31,253,44,250,99,3,5,253,162,251,81,2,64,4,138,252,64,250,174,5,6,254,117,1,83,251,25,255,250,4,125,254,119,255,123,254,120,255,210,8,197,254,223,254,215,3,209,251,58,255,248,4,82,2,18,7,241,250,7,248,134,255,83,6,147,252,45,7,62,248,133,5,91,7,104,0,3,3,210,1,149,255,155,3,142,251,253,4,126,249,111,0,255,1,194,254,161,2,143,251,253,250,59,255,44,253,155,8,197,6,65,0,246,251,206,254,6,1,230,251,79,7,234,1,52,249,136,251,186,254,188,2,205,2,237,8,17,8,122,252,132,0,42,251,170,8,252,250,204,8,101,1,189,250,174,249,126,1,38,3,188,247,12,247,235,3,80,3,208,253,136,250,217,4,122,3,41,251,115,254,9,250,169,249,113,251,54,247,175,3,74,249,98,4,125,1,210,0,233,253,128,253,55,251,145,255,93,248,112,5,79,5,185,254,139,8,138,248,230,247,246,251,217,253,92,1,86,254,74,1,70,0,191,249,66,3,182,1,145,252,254,0,85,251,114,8,19,3,133,0,254,250,220,3,104,254,102,7,159,8,66,0,173,252,215,247,61,3,179,255,170,255,57,2,114,2,103,253,248,253,241,250,108,8,193,250,189,0,233,3,190,8,187,249,210,248,205,253,221,248,145,8,179,4,47,249,82,248,74,1,144,247,215,3,76,247,201,251,20,3,246,250,127,5,151,1,167,3,68,253,226,2,187,249,134,251,115,252,70,251,88,0,249,250,74,5,226,253,88,8,16,247,204,5,173,2,199,250,40,249,177,1,196,3,226,249,50,253,40,3,5,248,41,0,216,2,108,255,52,6,80,252,24,2,76,0,68,8,74,250,129,247,249,254,240,4,137,252,230,0,18,8,194,253,192,0,202,2,207,248,255,247,126,249,21,255,27,254,255,2,143,3,138,255,71,5,143,8,168,6,116,248,46,249,20,254,4,250,92,5,231,254,195,252,179,4,108,251,115,2,76,4,211,254,57,250,93,3,148,255,199,255,173,2,70,0,194,250,107,2,119,255,205,6,186,6,73,252,27,2,112,249,160,8,57,4,90,253,88,248,181,248,37,253,207,0,192,250,143,1,21,3,126,0,129,3,46,8,214,2,52,5,41,247,242,250,115,5,14,247,219,251,76,4,103,253,75,249,34,247,106,7,54,4,48,248,189,0,248,1,218,6,15,8,53,0,53,8,251,247,62,255,87,5,166,2,175,2,98,250,168,7,193,250,130,254,219,7,120,3,56,5,207,247,239,253,179,254,230,249,22,7,143,247,131,252,17,250,140,3,58,0,52,254,224,249,170,255,108,5,50,1,48,3,246,251,243,2,7,4,114,250,102,255,160,6,32,247,235,252,205,248,65,251,65,5,246,8,141,8,79,250,231,2,47,255,162,247,121,249,161,252,219,253,155,255,99,255,129,8,2,0,84,248,209,3,66,249,66,8,211,247,59,250,210,255,24,1,254,252,141,247,97,8,127,7,8,0,47,254,28,8,35,3,92,253,32,247,210,2},
  {86,2,202,0,185,6,69,254,245,8,95,6,1,8,235,253,171,2,208,7,224,250,181,8,226,248,132,8,152,254,15,250,230,2,238,4,90,2,217,5,74,249,78,1,78,248,189,3,84,255,65,249,174,1,62,1,16,249,43,254,105,254,15,8,144,6,189,247,77,7,5,255,234,251,109,255,224,8,103,248,67,253,247,251,45,5,51,1,65,251,182,8,158,5,178,255,162,7,239,3,151,6,248,8,122,249,138,248,17,5,189,1,26,250,202,3,5,6,27,248,39,2,88,250,188,6,145,255,251,3,87,250,149,1,30,6,107,3,122,253,212,2,46,8,28,251,25,1,11,0,80,1,243,253,84,248,73,3,5,9,78,252,84,255,206,1,69,249,139,7,40,3,42,1,28,253,115,254,2,8,104,5,45,252,122,5,41,247,67,253,111,254,194,249,223,254,42,250,206,8,107,2,249,8,9,253,244,8,113,5,37,2,40,0,175,251,203,1,131,250,183,249,217,8,163,248,139,251,42,4,21,250,190,7,4,252,110,252,153,5,68,255,63,1,153,4,151,0,204,2,144,251,197,247,27,254,76,4,170,251,242,7,250,252,94,3,40,7,137,247,227,6,253,253,105,6,159,251,231,252,179,6,8,0,215,7,27,7,231,1,140,7,71,255,176,251,161,6,241,3,85,6,63,250,75,7,85,8,254,0,225,8,245,251,186,8,122,2,180,247,243,1,171,247,130,250,131,251,102,248,191,251,246,254,200,2,43,5,58,251,6,9,8,255,126,252,45,254,59,3,79,4,220,2,75,1,0,8,111,4,14,253,60,1,13,253,253,6,223,7,240,1,193,252,6,5,25,254,181,2,62,4,173,2,207,251,43,255,49,254,92,6,233,249,211,250,65,0,138,247,188,3,23,252,108,2,219,2,211,1,5,4,239,4,39,2,80,251,58,249,1,1,64,6,220,8,253,4,74,1,39,249,146,2,221,0,233,7,220,254,0,249,139,251,103,8,226,248,194,253,43,247,156,1,171,249,187,248,67,254,214,6,224,250,12,250,255,3,217,249,17,255,173,1,56,0,155,2,245,8,56,2,56,251,121,1,248,247,182,7,84,7,61,7,210,2,60,254,238,6,189,254,129,251,65,252,255,2,3,253,253,4,248,8,184,249,90,3,43,250,132,7,179,253,245,0,159,2,18,4,183,6,222,253,21,5,157,5,44,6,56,3,61,3,48,4,60,7,26,254,40,6,126,251,235,248,193,247,63,247,114,8,249,2,41,249,212,6,62,250,227,254,103,250,5,2,46,253,197,8,180,6,1,3,67,255,39,0,167,7,180,1,143,3,95,249,1,6,164,8,114,1,70,1,172,4,27,253,9,5,153,247,226,2,37,254,179,8,37,249,193,3,112,255,216,3,77,248,173,247,26,249,15,5,31,255,87,1,185,253,20,5,221,4,142,255,76,6,41,248,190,254,190,249,162,7,186,2,202,4,194,7,82,7,12,248,59,253,199,250,242,3,34,1,220,1,243,255,73,249,127,4,183,8,15,1,220,253,5,249,6,253,182,252,152,0,36,0,194,1,26,251,37,247,220,248,1,0,63,6,106,6,208,250,29,253,114,1,160,247,21,250,197,248,173,252,234,5,152,5,167,3,162,8,202,1,167,5,192,0,33,252,45,2,8,247,216,254,216,3,254,249,118,247,248,1,5,6,131,8,91,3,125,4,125,1,15,5,134,5,218,252,118,6,38,252,192,6,44,254,41,1,11,249,59,5,153,2,77,249,171,253,45,255,68,254,111,6,87,253,246,255,244,0,82,7,170,0,23,7,167,4,58,255,181,3,106,251,10,6,228,254,69,255,41,4,126,248,178,5,155,248,180,7,172,4,110,250,55,6,170,0,34,250,4,0,247,7,27,2,185,5,0,249,123,248,150,2,226,1,138,3,158,6,124,3,36,5,24,1,92,4,193,6,13,249,215,1,76,0,240,4,44,8,225,8,216,250,37,6,197,252,3,251,78,249,242,7,218,0,236,2,80,248,15,3,196,0,226,0,20,252,150,0,209,2,16,251,78,4,78,0,245,251,49,6,19,1,85,255,71,250,205,250,27,4,28,249,88,247,22,4,82,254,35,4,249,249,204,255,67,251,72,3,197,248,97,3,80,7,208,249,53,253,132,7,207,5,167,253,115,253,0,252,50,253,230,253,212,5,89,251,127,251,175,254,173,254,45,5,6,2,92,0,37,247,57,254,143,247,193,1,71,251,91,4,157,251,158,255,116,254,104,254,146,247,211,8,153,251,235,0,11,8,24,252,157,0,203,2,235,251,2,255,49,3,35,255,170,7,73,255,60,248,69,0,167,249,210,249,152,3,40,5,199,0,30,251,220,250,194,7,176,251,109,251,92,248,162,253,48,3,123,254,120,254,240,6,32,254,50,8,158,254,153,3,170,252,18,8,253,5,244,4,50,251,192,251,80,247,230,5,82,253,14,251,35,6,225,3,107,250,49,7,163,251,179,5,154,249,213,254,228,253,138,250,174,251,164,6,140,247,212,252,215,7,157,249,63,2,143,7,59,251,147,2,5,4,204,252,147,253,124,255,147,248,174,2,197,5,148,253,165,5,163,248,19,254,204,7,42,3,197,248,18,252,6,253,9,5,157,254,183,3,188,250,61,252,169,248,129,2,97,3,139,5,236,4,108,247,136,4,26,252,166,251,158,251,167,4,31,2,236,251,112,8,251,250,140,254,203,5,210,247,142,252,83,4,167,253,2,8,153,1,0,7,26,1,124,5,95,250,155,8,215,8,224,8,34,248,91,248,68,255,189,248,133,2,122,1,238,253,215,5,108,0,20,1,46,3,140,4,245,1,216,249,54,255,76,254,213,253,183,255,39,4,146,247,25,3,226,254,183,3,79,249,32,251,96,247,4,9,130,251,85,2},
  {98,8,171,255,161,4,108,4,198,1,111,6,71,1,139,250,30,248,191,250,152,247,86,249,46,249,57,249,149,5,182,8,225,2,73,255,65,247,169,248,40,250,16,249,247,249,75,1,160,3,1,3,207,255,54,7,248,1,127,249,159,6,170,252,232,3,51,251,67,6,110,0,40,251,47,6,51,255,253,250,135,7,67,2,24,7,109,4,93,8,26,4,180,255,84,248,111,248,201,249,159,253,66,253,145,247,116,249,120,2,31,2,154,251,58,250,163,252,208,248,36,7,232,252,131,251,5,1,47,7,44,2,89,6,107,254,190,251,7,5,5,249,8,247,99,250,177,247,39,4,252,251,100,4,151,0,88,1,196,4,53,254,39,254,93,255,135,249,50,254,228,3,198,4,203,5,188,4,5,248,17,255,59,253,54,2,248,255,255,4,117,7,151,4,214,0,18,254,232,250,10,2,71,249,214,3,99,1,153,7,113,249,89,249,31,8,120,6,37,2,164,253,196,251,136,4,213,1,92,252,222,6,63,253,255,0,221,255,139,254,91,0,66,4,254,252,157,254,85,3,76,8,124,3,70,252,176,247,89,255,238,250,34,3,111,6,188,250,201,252,87,8,159,250,10,255,148,250,120,4,55,0,67,0,54,0,146,252,184,0,6,247,51,250,84,3,36,2,66,254,137,255,193,1,115,5,21,252,214,0,46,251,245,252,50,0,109,1,94,255,231,250,129,3,224,252,180,2,63,4,54,250,195,4,22,7,125,254,123,247,208,5,83,0,38,255,85,248,170,251,13,2,236,247,104,249,225,7,222,253,42,7,103,253,141,1,133,253,147,2,45,255,97,248,77,250,74,249,162,253,217,3,187,7,89,4,23,1,46,251,71,6,53,249,168,7,185,251,218,250,74,250,194,0,200,4,100,5,252,6,116,2,95,8,105,254,218,248,111,252,232,1,174,250,245,8,128,248,106,255,25,4,123,7,227,250,244,249,189,248,176,253,36,253,3,3,124,250,123,249,128,3,125,247,38,249,107,252,69,251,205,249,77,255,135,1,197,7,219,1,86,248,117,6,62,250,103,251,157,1,71,6,70,4,13,254,50,2,7,248,10,3,144,6,6,252,178,248,128,4,97,251,77,4,209,6,98,1,204,8,14,247,195,254,240,249,53,0,65,1,204,248,184,250,247,248,231,255,171,3,193,254,97,248,241,4,117,253,177,254,241,249,251,248,130,253,77,5,51,248,5,2,233,4,29,0,132,6,99,251,209,253,43,5,64,1,11,255,27,250,185,5,117,248,191,2,238,6,122,7,121,8,80,252,3,253,37,247,250,8,189,255,94,0,246,249,75,251,169,7,33,251,246,7,249,6,70,255,173,7,149,247,40,254,65,254,13,1,39,5,57,8,4,6,23,0,214,253,27,255,125,6,110,250,143,252,113,248,43,5,176,248,106,5,209,254,254,246,139,4,214,6,131,248,125,250,96,5,159,252,53,8,127,4,106,252,162,251,162,8,49,8,140,5,96,249,254,6,84,3,230,247,37,254,183,0,17,5,11,250,154,5,32,7,203,8,176,8,172,5,66,254,66,247,88,249,88,8,164,5,31,253,193,247,101,248,68,248,177,2,42,251,94,252,135,250,79,6,188,5,38,249,8,7,34,4,213,2,180,254,72,5,164,251,221,255,210,1,129,0,137,247,157,251,164,253,21,251,114,253,246,254,144,5,148,247,88,253,235,7,227,251,154,4,39,249,145,248,125,250,191,7,54,248,9,5,239,252,93,247,91,255,139,1,52,251,148,253,121,254,252,3,156,248,202,7,147,253,150,6,117,1,203,4,161,5,189,4,212,4,198,252,191,3,238,249,190,1,86,2,165,250,58,254,54,4,229,8,75,251,135,248,99,254,98,254,55,253,194,6,0,253,36,255,175,6,12,250,68,248,37,255,142,0,48,6,134,7,83,250,221,7,154,250,53,8,115,251,185,249,177,1,15,4,242,247,18,3,97,2,178,249,101,247,247,0,177,2,44,8,193,3,225,254,62,252,104,3,75,247,58,7,206,1,28,0,207,7,92,252,4,7,39,8,102,5,185,8,204,2,246,252,13,0,70,4,223,248,184,248,91,4,4,253,86,2,217,0,121,0,190,7,72,251,123,251,214,250,255,252,70,249,204,249,47,6,40,5,50,4,213,253,249,251,46,0,215,248,19,248,219,2,9,255,35,249,94,255,71,247,53,5,139,6,231,4,37,3,247,4,116,252,218,247,59,252,0,6,154,255,201,252,53,248,136,7,10,250,101,250,165,0,95,7,154,5,59,8,214,251,17,255,118,254,111,5,43,0,107,2,45,3,86,249,53,5,171,7,170,251,174,253,213,248,112,7,148,6,182,7,251,254,247,255,169,0,94,5,158,6,112,4,215,1,198,247,7,248,161,252,27,251,132,251,128,0,183,255,250,8,138,255,79,255,22,2,32,3,148,251,22,0,224,7,121,251,247,6,4,255,87,2,184,1,28,247,156,6,188,0,116,1,67,6,70,1,214,255,32,247,104,3,236,254,212,2,186,249,76,2,83,2,91,0,133,251,46,0,207,255,174,0,119,4,239,254,20,250,3,255,161,0,2,2,202,0,80,252,118,250,5,250,185,255,211,248,26,4,96,252,110,3,251,0,154,6,149,250,132,2,92,250,131,250,65,252,220,254,164,249,37,250,156,251,7,249,204,247,213,0,75,0,214,3,201,1,108,2,162,249,122,1,21,250,88,7,232,252,184,253,207,7,67,250,128,255,61,5,246,249,53,252,149,1,132,8,193,247,249,3,40,1,242,5,179,247,103,252,66,252,32,5,53,1,33,4,62,251,120,6,197,7,49,252,66,255,133,254,239,3,121,2,168,253,172,4,51,2,240,253,0,250,203,1,214,6,76,7,63,0,151,250,211,252,151,251},
} ;

static const unsigned char precomputed_core_multsntrup653_n[precomputed_core_multsntrup653_NUM][crypto_core_INPUTBYTES] = {
  {162,148,76,22,5,64,112,4,5,85,247,229,249,61,46,219,120,157,206,49,188,162,246,167,236,0,15,40,4,12,58,219,116,93,232,216,64,80,48,180,88,72,146,56,199,19,195,10,143,97,126,26,92,147,236,41,187,2,106,181,57,36,62,147,152,88,250,254,44,65,218,57,112,229,225,134,184,135,130,217,87,186,73,129,16,80,237,210,236,209,109,87,95,66,243,248,246,21,247,156,224,81,6,109,147,52,167,144,120,14,232,91,121,54,188,171,93,72,245,47,128,190,141,97,137,22,19,14,136,8,2,209,141,192,204,11,103,8,246,249,39,68,181,220,135,214,183,120,238,75,169,13,221,108,225,249,95,249,37,57,163,124,139,156,192,131,1,166,23,76,37,32,11,121,26,85,58,53,41,155,120,216,57,90,102,84,201,170,14,80,207,137,132,55,14,88,191,241,227,192,130,117,177,83,195,146,180,145,248,159,33,214,248,173,18,117,24,217,30,205,152,159,166,125,90,186,171,255,105,77,184,199,100,144,187,255,165,192,226,46,206,16,231,122,2,195,40,132,25,175,98,82,217,212,186,253,241,116,156,190,210,218,41,89,221,179,87,206,73,8,103,220,209,175,182,81,185,0,113,215,58,55,165,39,100,169,189,68,183,16,24,165,103,141,170,200,133,216,184,47,79,8,192,202,45,161,157,233,93,95,240,201,179,206,4,97,198,51,66,90,44,139,217,74,24,43,30,159,102,63,177,75,209,56,47,35,207,134,161,69,42,155,67,61,142,98,231,199,223,238,156,200,131,178,18,127,21,176,227,84,9,34,244,167,222,89,246,103,15,80,21,74,58,35,103,40,177,95,62,213,125,116,113,40,122,186,126,162,43,23,123,92,131,11,140,116,217,120,101,105,53,152,89,86,23,215,13,137,2,183,92,171,152,233,109,111,236,100,34,251,57,57,169,57,200,100,202,252,57,193,236,61,211,177,102,74,73,42,11,158,226,187,11,72,7,42,70,215,44,234,214,115,89,5,123,183,129,172,95,45,150,199,157,185,40,136,73,4,52,235,36,26,48,223,203,197,253,134,198,33,25,252,86,255,11,214,55,240,176,174,228,235,181,252,14,106,219,105,237,148,219,104,5,80,2,209,110,219,138,82,240,54,202,72,111,33,114,40,166,186,103,223,7,43,208,9,30,165,181,229,65,69,49,180,207,225,152,133,234,47,238,155,196,188,157,248,26,236,124,31,51,220,167,151,231,126,210,243,81,65,161,200,151,194,210,232,232,226,30,45,69,14,226,65,105,90,182,254,71,150,211,23,93,173,15,180,241,78,69,154,168,68,205,110,244,22,95,4,85,181,150,121,40,218,213,205,68,241,4,82,160,48,25,111,71,193,140,0,208,29,85,96,222,212,194,232,23,68,87,238,26,2,251,176,202,11,182,221,51,38,174,35,92,205,211,163,113,120,150,187,103,210,167,139,35,115,123,67,32,24,97,27,187,55,208,75,218,110,66,199,107,247,149,226,68,241,2,39,143,119,196,220,145,103,49,138,117,159,64,241,130,189,168,112,133,12,50,234,112,202,93,82,202,18,135,255,0,216,40,98,5,103,94,148,239,211,155,123,222,109,87,166,122,252,7,166,8,244,46,175,101,130,41,126,153,123,39,116,115,94,69,27,124,63,17,179,115,181,11,34,78,116,223,152,30,224,18,124,98,35,46,9,67,70,246,227,112,59,208,155,113,61,76,211,136,161,189,36,116,101,119,113,203,7,88,210,231,247,219,216,143,1,136,142,91,7,106,219,159,194,57,234,168,246,127,210,206,1,247,14,51,42,91,165,44,204,179,7,93,232,102,94,168,159,192,106,151,253,55,121,155,16,14,26,197,24,13,163,97,83,181,229,72,87,155,224,8,230,201,82,40,85,161,83,77,33,28,224,43,203,73,182,141,159,41,197,34,106,152,35,254,83,183,246,44,226,210,129,121,246,105,41,44,181,44,84,165,227,199,121,91,250,156,4,94,174,29,212,57,43,142,195,215,224,21,17,24,151,121,107,10,184,141,116,173,118,158,128,177,147,131,225,87,53,180,172,159,106,105,228,172,68,176,202,9,82,97,132,135,247,46,75,42,172,185,58,123,157,212,56,115,92,245,142,180,17,89,152,13,252,57,142,114,106,172,223,145,112,51,20,42,212,26,42,183,130,7,15,97,129,178,52,116,198,247,113,188,248,210,85,116,206,23,210,37,115,19,196,51,208,162,231,68,112,107,221,215,189,103,175,153,200,36,16,210,225,223,14,67,127,210,212,232,211,214,246,112,74,122,209,61,59,213,115,198,37,112,31,206,200,70,216,43,100,148,234,170,86,22,164,117,169,129,0,206,51,189,155,26,139,97,187,226,52,5,37,132,147,10,114,227,24,246,18,127,218,209,6,14,43,96,143,105,156,75,181,140,73,192,115,106,45,217,245,79,165,161,183,184,3,195,139,4,221,81,26,134,98,209,18,175,176,49,40,143,120,12,164,18,53,46,181,214,228,0,60,199,96,24,250,79,37,109,90,38,96,100,103,63,242,66,41,110,56,178,11,154,235,151,28,34,107,85,204,116,80,253,174,157,151,6,192,246,78,202,66,131,0,114,73,187,226,144,56,60,12,228,237,31,179,77,171,158,182,18,196,58,11,107,67,166,1,115,176,47,17,223,145,113,135,137,152,149,27,210,122,221,137,205,67,29,154,89,37,116,189,174,237,169,49,245,15,96,0,26,175,59,250,16,204,236,66,103,102,220,24,238,1,114,97,134,189,120,106,101,130,191,127,121,240,15,152,216,178,29,130,3,40,158,158,109,237,136,249,223,136,105,177,36,192,135,67,78,24,161,174,136,152,4,15,130,144,96,68,207,131,7,143,145,76,63,79,148,160,172,94,140,87,235,202,129,45,221,177,159,106},
  {227,192,63,93,107,172,131,142,209,239,187,210,148,236,250,166,235,42,17,154,160,10,148,132,76,92,77,220,148,96,166,205,239,66,198,121,125,76,248,201,145,56,179,177,251,254,239,28,195,131,15,152,60,6,198,11,66,146,144,171,101,174,224,208,112,78,254,130,107,50,99,61,212,192,246,223,156,131,204,11,154,251,71,234,59,54,162,190,81,96,190,175,192,140,70,38,6,89,111,39,23,97,131,24,178,238,98,118,219,90,244,89,212,135,211,3,95,131,211,39,214,21,59,229,244,101,92,246,230,57,149,133,101,149,77,237,118,178,124,116,174,91,17,192,77,141,111,102,127,101,101,185,137,87,56,21,98,147,44,134,53,45,116,148,88,91,138,134,170,210,242,40,49,252,105,148,12,108,85,189,137,2,27,66,106,109,163,157,198,30,98,64,56,224,217,190,166,120,114,183,210,148,59,172,95,81,138,122,174,120,150,48,245,192,177,210,68,65,52,122,110,175,155,188,251,23,23,73,68,234,110,154,172,13,132,3,142,33,253,63,21,108,68,25,209,16,98,28,170,217,211,237,127,178,134,93,208,143,187,106,24,102,246,233,162,81,176,94,184,14,235,210,220,66,51,196,89,76,107,233,96,193,233,142,202,137,217,129,93,136,30,181,27,98,192,85,122,61,58,87,77,87,95,91,194,27,159,115,31,216,160,127,175,52,48,114,15,42,177,208,253,168,238,39,47,122,112,204,181,182,151,248,113,181,99,112,86,164,54,70,8,51,22,122,240,61,123,98,64,226,62,169,194,233,4,0,30,113,33,231,18,166,60,245,47,56,142,86,176,97,64,251,141,92,172,136,66,140,80,95,67,122,187,132,30,236,73,110,32,157,111,0,95,131,81,226,240,160,144,180,74,188,243,240,77,102,153,10,215,240,13,153,196,146,16,253,154,59,247,133,113,213,99,36,142,134,53,32,136,0,92,178,79,125,193,4,155,180,23,247,217,228,60,124,27,108,182,105,178,106,82,229,48,214,114,194,22,189,10,252,13,15,26,170,184,18,36,79,10,48,56,163,171,38,160,4,201,24,137,1,72,49,35,232,243,145,64,116,80,43,182,72,71,179,77,196,77,176,70,213,192,81,15,108,202,238,60,87,44,114,208,246,78,76,82,5,58,86,199,26,219,89,209,141,11,16,137,47,62,63,154,37,4,177,177,149,142,65,230,161,229,30,17,53,246,139,29,190,35,58,88,160,14,203,24,102,204,123,3,30,149,5,165,222,94,251,66,239,45,46,182,14,37,44,204,49,255,99,94,148,185,7,254,98,244,58,162,241,183,149,231,32,214,97,67,20,120,119,201,49,47,28,38,12,76,57,4,61,33,24,58,234,2,77,80,199,104,30,150,101,236,47,49,33,5,24,39,35,135,231,100,169,87,200,162,109,94,58,249,84,209,198,52,210,58,21,46,70,155,96,251,178,101,131,72,178,244,160,118,128,36,245,17,206,37,116,80,134,86,147,6,89,224,4,121,189,42,81,70,135,191,126,156,169,214,10,16,116,232,66,96,133,85,116,225,76,97,138,138,120,216,59,182,147,51,14,226,237,82,65,54,243,151,251,169,222,90,127,100,128,67,102,233,216,204,168,129,171,206,235,20,251,198,3,92,211,130,52,127,134,160,207,38,29,161,89,169,89,1,81,9,242,198,159,146,183,29,19,29,58,181,74,129,190,149,150,19,29,105,49,38,39,55,163,239,210,236,213,104,146,52,141,53,34,66,206,144,38,13,96,159,172,6,248,249,111,218,95,190,162,41,27,1,234,160,101,187,13,35,75,16,219,185,26,194,237,34,207,51,40,0,6,198,31,4,111,134,188,95,146,250,154,124,174,177,115,25,185,38,28,209,245,194,172,40,240,122,169,175,81,49,193,141,118,25,65,218,193,190,153,230,76,29,254,94,223,29,52,206,222,90,195,33,1,69,180,153,22,61,130,8,210,117,187,60,28,166,33,238,152,192,204,74,244,169,107,49,90,146,216,80,243,180,141,6,238,237,13,222,224,114,242,185,132,241,170,74,173,104,127,177,204,125,24,223,128,68,3,35,97,231,46,251,151,102,90,81,37,154,140,145,159,91,158,139,166,152,75,252,30,24,49,79,92,65,229,78,254,71,74,184,244,113,165,216,35,156,244,63,170,247,177,219,178,197,24,175,157,84,99,4,28,21,202,131,1,118,205,163,32,151,52,231,230,177,34,216,94,226,4,6,76,104,40,232,34,149,74,174,55,193,171,88,65,116,131,229,202,37,19,154,69,121,217,198,220,134,2,133,98,161,193,26,253,41,18,219,35,88,39,166,151,138,10,9,160,232,208,90,67,9,28,232,103,114,34,74,155,251,230,246,114,39,223,54,205,255,239,207,28,105,82,43,255,153,75,24,38,237,149,105,200,25,177,6,23,197,154,225,214,96,248,214,151,16,93,14,126,201,114,4,12,198,0,183,127,22,60,89,192,123,45,184,189,126,48,248,120,170,238,221,45,143,94,55,201,34,170,60,128,205,112,153,201,17,206,45,100,68,170,172,174,8,189,207,187,197,154,134,154,150,72,111,54,182,2,104,122,179,206,135,133,90,75,75,105,186,57,110,128,227,212,161,135,240,23,247,249,73,74,109,44,50,38,43,123,235,128,89,115,8,238,30,145,16,162,158,221,86,127,242,212,185,55,29,81,160,1,163,224,175,72,13,71,243,86,31,184,248,132,13,145,128,28,100,7,74,106,148,189,21,118,117,173,138,193,53,201,148,83,70,140,244,6,191,4,30,210,108,141,110,105,29,112,91,31,155,106,30,31,3,210,125,119,229,8,4,25,45,227,140,227,21,210,186,129,97,230,155,249,56,109,229,109,40,64,249,159,14,54,211,231,86,255,27,175,19,2,37,161,126,49,84,16,208,21},
  {94,182,143,105,116,224,241,37,196,114,243,184,176,55,131,212,40,180,208,230,2,77,92,166,131,97,67,34,77,59,98,82,61,251,31,211,104,140,94,160,36,137,27,114,236,243,25,212,123,76,228,37,15,19,181,89,107,76,42,129,110,186,180,4,231,130,53,199,147,59,218,122,93,195,164,254,91,72,12,152,35,24,43,3,228,212,174,223,89,74,157,91,195,152,107,40,216,161,30,181,155,253,193,76,136,69,52,58,2,199,77,178,187,248,5,56,186,30,115,230,89,176,29,59,108,156,182,112,93,55,76,191,79,141,9,203,223,41,118,45,245,128,201,112,163,96,78,75,230,219,21,125,202,23,7,233,53,58,90,166,153,71,171,172,249,39,61,220,229,156,188,71,61,143,49,96,209,225,3,127,188,245,57,159,92,65,167,163,22,147,215,13,63,215,84,218,109,24,123,90,203,42,137,87,241,6,251,88,131,225,230,166,18,64,237,10,196,249,157,39,121,156,160,86,132,8,206,197,106,251,0,253,51,103,76,72,222,121,143,79,237,119,74,105,255,89,236,213,238,172,145,54,229,144,203,42,160,194,250,39,40,70,203,71,10,159,49,200,36,223,86,137,134,93,161,120,61,146,220,118,231,42,56,158,194,127,48,54,210,189,115,57,0,3,200,122,35,189,33,151,114,5,171,74,235,166,48,114,35,35,66,231,150,123,112,98,71,193,239,196,63,153,97,27,205,140,156,162,97,84,165,166,218,193,102,21,251,165,42,34,200,167,251,39,30,163,2,246,118,85,148,37,161,233,232,1,11,25,184,3,211,189,109,109,180,204,140,98,105,63,229,52,172,111,220,170,66,115,70,117,72,211,58,77,250,149,103,80,84,186,67,171,216,38,208,156,99,186,117,26,175,248,88,46,85,28,220,66,214,88,144,236,164,164,55,59,217,164,3,153,162,73,191,122,164,42,65,251,7,212,77,223,149,146,100,48,168,108,250,138,190,215,223,77,33,72,115,212,83,10,61,204,19,73,78,252,105,151,125,148,148,36,143,205,159,147,187,203,114,85,202,202,106,199,19,59,48,183,188,140,112,240,46,39,108,48,118,107,146,225,10,72,98,144,22,246,200,173,165,73,149,166,107,209,245,147,175,6,204,36,38,77,255,86,115,219,158,179,207,142,255,174,164,234,178,254,97,9,247,105,221,92,49,189,74,83,42,209,198,182,77,211,124,136,124,224,59,182,82,73,53,219,194,166,33,19,222,116,179,152,166,27,172,180,224,218,174,68,148,71,47,202,128,56,61,216,77,163,216,55,243,142,169,75,90,86,236,216,39,73,4,199,4,197,127,249,60,167,151,225,129,87,98,125,93,187,129,167,175,131,22,85,185,243,20,121,134,120,62,187,41,213,67,13,60,220,191,234,44,83,84,196,141,82,189,173,47,247,159,121,195,240,162,7,176,110,140,63,78,15,141,212,190,112,185,189,189,202,69,6,83,93,198,183,201,240,139,212,48,161,7,33,194,62,147,251,4,162,11,88,125,164,178,164,47,167,177,218,169,235,179,184,184,255,111,241,178,98,143,86,170,83,190,97,86,130,79,123,239,59,226,186,195,248,186,241,124,176,153,146,181,144,107,231,132,81,34,47,135,75,38,75,127,189,124,157,140,39,25,240,224,138,129,136,234,197,170,88,68,96,52,155,219,123,60,86,92,141,157,170,59,190,23,6,61,79,155,129,151,32,25,206,0,96,158,76,119,88,251,80,116,179,98,109,20,130,187,166,125,159,80,18,38,146,196,60,73,146,52,104,16,119,38,254,236,248,126,245,93,100,46,123,58,114,187,97,1,214,5,71,162,42,9,179,83,60,152,181,192,88,78,249,112,227,5,68,69,108,219,44,61,183,20,71,126,217,23,32,240,58,189,174,152,182,108,8,9,73,74,26,193,77,97,133,47,70,207,139,35,172,230,6,54,96,235,91,209,87,201,213,80,103,23,201,64,9,16,59,71,12,176,85,113,74,141,218,108,155,150,108,136,85,2,2,14,52,244,51,125,4,75,50,229,10,245,6,188,48,96,119,48,126,236,141,234,116,18,202,106,164,141,159,43,39,59,250,158,113,230,242,159,9,31,191,123,123,241,233,179,167,115,167,68,30,47,204,88,32,11,63,39,39,219,14,181,145,152,185,146,224,213,111,131,134,67,183,174,28,68,125,157,160,10,175,187,255,194,45,130,108,30,130,162,66,125,195,238,0,170,212,157,75,246,2,2,80,149,185,233,98,224,243,175,20,244,94,243,199,109,6,96,96,69,191,250,125,209,165,191,128,175,234,100,198,11,29,187,73,56,189,117,10,255,48,240,12,111,243,9,152,179,204,91,73,100,177,241,243,239,168,177,121,214,202,112,233,108,142,129,50,148,66,50,150,16,74,117,144,231,245,65,113,143,245,151,9,117,109,225,5,121,214,154,17,142,21,219,134,5,104,149,108,66,59,126,19,137,19,115,192,69,152,158,59,234,101,194,35,179,199,238,229,182,57,238,220,140,38,104,52,219,9,81,80,185,93,237,109,97,247,11,137,199,149,18,146,73,78,109,242,27,177,164,217,97,127,164,102,194,13,255,216,195,155,88,58,30,72,90,103,5,91,35,39,176,53,63,125,126,169,236,122,229,225,192,250,215,30,10,138,126,247,34,75,68,243,210,195,137,204,91,78,87,126,111,47,192,180,158,214,171,141,118,111,153,87,129,81,81,204,227,206,64,158,251,143,190,131,176,48,9,126,33,200,3,236,245,244,49,194,191,218,85,24,241,239,137,181,39,149,78,125,208,186,106,65,103,242,43,20,107,187,120,98,113,114,219,255,0,51,160,120,114,6,250,167,80,252,111,195,4,69,157,178,3,166,211,221,29,204,210,157,103,179,23,120,218,48,150,73,56,62,236,125,230,72},
  {42,3,185,191,41,119,55,89,221,204,115,75,110,20,25,138,242,101,187,113,27,178,91,65,71,89,104,169,36,244,59,98,194,33,10,146,157,118,153,160,3,228,37,26,18,105,147,44,95,127,127,80,62,38,120,181,12,48,143,19,238,6,203,59,9,202,130,138,175,53,238,173,95,112,37,199,93,220,137,173,232,208,125,140,193,237,27,33,22,177,5,122,125,158,37,138,136,102,144,228,6,132,27,113,159,194,104,12,35,25,211,8,121,206,110,212,162,128,231,140,97,29,155,234,94,223,154,62,225,118,68,56,242,148,53,1,185,66,97,184,194,14,98,12,248,226,19,47,253,194,6,128,142,251,9,196,255,255,114,176,53,32,129,69,212,5,75,167,223,104,241,9,217,237,16,208,163,244,0,133,88,15,166,28,209,163,214,213,157,114,223,94,8,105,159,216,154,193,252,100,231,134,153,13,253,122,171,79,243,154,36,37,90,8,94,12,241,143,131,119,150,8,157,156,134,166,177,232,74,126,108,91,104,182,104,168,209,237,157,77,204,155,87,211,153,209,59,34,48,134,163,109,97,33,116,96,166,59,155,0,26,203,121,160,209,4,163,243,70,102,25,209,235,168,71,193,10,174,72,110,45,137,165,49,130,1,231,206,78,75,174,189,92,176,246,76,149,93,174,146,118,247,200,19,6,148,195,110,94,114,161,20,195,128,41,63,148,56,4,232,162,6,179,75,188,22,44,197,159,20,13,102,217,173,62,84,25,161,34,126,157,17,110,32,221,67,52,122,203,189,21,141,27,187,156,149,255,190,98,56,191,56,168,232,230,223,200,233,32,91,74,84,91,55,228,160,254,59,218,208,200,17,80,217,46,118,232,210,222,62,74,2,79,44,17,165,114,134,36,30,90,239,92,196,127,24,164,80,11,151,50,18,164,15,115,234,201,2,253,182,22,0,166,60,163,137,139,15,84,140,236,153,179,196,244,53,219,73,63,116,200,97,176,44,19,152,243,147,213,121,41,35,204,227,240,108,174,168,85,173,94,27,173,99,16,219,157,229,162,53,1,37,214,203,28,141,62,51,107,95,146,180,249,236,235,165,124,212,220,29,233,14,219,62,32,8,166,121,163,135,10,154,12,151,199,233,249,135,219,15,100,186,68,192,58,115,6,48,134,51,57,70,45,159,57,233,196,85,250,162,176,4,99,182,18,108,231,128,120,219,189,117,117,32,217,234,163,109,170,134,253,225,81,183,138,207,211,193,194,189,103,2,176,218,250,129,57,221,78,15,15,43,55,241,22,143,43,195,205,152,80,58,91,202,242,198,237,68,130,228,226,165,118,112,157,159,71,3,15,13,169,41,224,64,54,229,251,246,238,104,119,123,104,171,123,251,214,193,55,27,204,51,155,172,174,101,193,144,153,95,189,31,10,143,136,35,118,61,197,14,82,1,178,158,224,103,211,204,52,192,154,63,25,240,101,200,251,60,47,82,209,159,156,213,82,135,188,124,88,158,108,152,35,71,12,25,248,3,254,82,188,153,150,8,172,218,135,184,255,177,228,206,248,102,101,21,64,103,86,69,231,255,209,156,10,67,170,240,195,12,87,160,11,234,161,253,198,140,91,223,150,110,182,179,189,114,252,44,158,46,28,156,172,24,156,215,98,247,161,221,230,45,34,2,244,49,8,64,204,191,26,138,31,127,163,60,43,149,103,246,243,98,191,2,157,45,23,171,248,179,149,152,205,235,219,35,178,20,74,120,103,196,247,140,92,191,155,58,33,201,113,159,103,130,25,55,6,96,138,33,25,240,66,156,31,31,94,233,43,0,44,83,16,89,20,14,159,8,236,236,5,182,182,184,157,49,84,179,174,239,119,121,250,200,245,160,79,178,171,245,43,90,222,131,126,2,103,35,227,231,221,17,37,169,201,244,183,118,69,215,59,178,142,236,0,219,179,76,69,181,129,181,221,110,104,46,43,24,12,83,32,252,26,30,109,252,204,10,13,65,172,105,120,22,79,81,252,127,16,5,227,87,174,73,237,21,171,175,129,58,207,79,197,59,158,23,20,24,20,55,51,23,137,253,130,72,171,163,78,125,61,16,242,41,167,36,52,4,94,250,65,68,98,173,233,161,31,32,132,172,51,173,209,50,70,37,183,210,144,21,115,80,72,92,122,57,210,106,94,248,203,89,209,27,55,171,150,199,93,51,253,111,1,172,190,164,197,44,221,47,163,19,135,127,67,23,224,111,56,120,94,86,99,195,142,123,72,109,72,234,45,194,179,2,193,22,112,81,64,183,180,126,239,104,74,131,97,10,196,181,176,151,32,182,251,1,202,252,197,105,24,94,37,42,119,50,89,162,243,55,54,19,95,123,49,94,63,93,159,81,212,205,6,120,226,126,235,131,64,58,161,55,190,192,255,201,186,243,12,68,83,177,145,54,152,23,241,65,41,215,68,79,11,156,60,194,228,20,176,242,194,64,224,56,14,62,3,77,234,219,138,234,108,206,78,4,138,143,101,192,111,217,180,66,189,160,168,161,1,184,120,255,186,226,122,26,221,5,133,71,86,72,110,82,40,110,102,17,216,178,138,5,85,208,100,32,69,191,26,122,132,204,45,133,99,41,10,247,100,32,88,224,208,179,14,53,139,61,232,107,128,151,73,79,56,52,201,202,249,173,242,140,211,190,147,106,49,213,206,119,44,170,28,136,153,159,255,120,37,79,4,40,133,139,188,234,33,29,135,228,154,117,120,166,239,241,75,249,9,178,100,0,133,181,143,56,190,89,51,222,97,224,192,117,32,54,145,252,115,33,89,40,212,78,172,83,135,65,171,231,139,182,163,83,144,167,86,59,42,93,73,199,184,131,217,248,108,14,174,162,201,231,178,203,183,220,122,208,30,128,194,59,89,47,30,197,119,203,234,205,74,169,238,133,159,167},
} ;

static const unsigned char precomputed_core_multsntrup653_k[precomputed_core_multsntrup653_NUM][crypto_core_KEYBYTES] = {
  {0,0,0,0,0,0,-1,0,-1,0,1,-1,-1,-1,0,0,-1,-1,0,0,-1,-1,1,0,1,-1,1,1,-1,1,0,-1,0,0,0,-1,1,-1,-1,0,0,0,0,0,0,0,1,0,0,1,1,-1,-1,-1,-1,1,0,0,-1,1,0,1,1,0,1,0,-1,0,0,-1,1,1,0,1,0,0,0,0,-1,1,-1,0,-1,1,0,0,-1,0,0,0,-1,0,1,1,1,-1,1,-1,-1,1,0,0,1,1,1,0,1,-1,1,-1,0,0,0,0,1,1,-1,1,0,-1,0,-1,0,0,0,0,0,1,-1,-1,0,1,0,0,1,0,0,0,1,-1,0,-1,1,-1,0,1,0,1,0,0,1,0,-1,0,-1,-1,-1,0,1,0,0,-1,0,-1,0,1,1,-1,-1,0,-1,-1,1,-1,0,0,-1,-1,0,1,0,0,0,1,1,0,0,1,1,-1,-1,1,1,1,0,1,-1,1,1,0,0,0,1,0,-1,0,0,0,-1,0,0,0,-1,0,0,1,0,1,1,0,0,0,-1,0,0,1,1,0,0,1,0,0,-1,0,-1,1,0,0,1,0,0,-1,0,1,0,0,0,1,0,0,0,0,0,-1,0,0,0,-1,1,-1,-1,-1,-1,1,-1,0,1,1,1,0,-1,1,0,0,-1,0,0,-1,1,1,1,0,1,-1,1,1,1,0,-1,0,0,0,0,1,-1,-1,0,0,0,0,0,0,0,1,1,0,0,-1,0,0,0,0,1,1,1,0,-1,0,-1,1,-1,-1,1,-1,1,1,1,0,0,0,0,-1,1,-1,0,1,0,0,0,1,1,0,0,1,0,0,1,0,0,0,0,0,1,-1,1,0,1,-1,1,0,0,0,1,0,0,0,0,0,0,1,-1,1,0,0,-1,0,-1,0,1,-1,0,1,1,-1,-1,0,0,-1,1,1,0,-1,0,0,-1,1,1,0,0,1,-1,0,-1,1,-1,0,0,-1,0,0,-1,-1,-1,0,0,0,1,0,0,-1,0,-1,0,-1,0,-1,0,0,-1,0,-1,0,1,-1,0,0,0,1,0,0,-1,-1,-1,0,1,-1,0,1,0,0,1,0,0,-1,1,1,0,0,-1,0,0,-1,1,0,1,0,0,0,-1,0,-1,0,-1,0,-1,1,1,0,1,0,0,1,0,0,-1,0,0,0,-1,0,1,1,0,0,-1,0,-1,-1,1,-1,1,0,1,0,-1,0,-1,1,0,1,0,-1,0,1,1,0,1,0,-1,1,1,1,0,1,-1,0,1,0,1,-1,0,0,-1,1,1,0,-1,-1,0,1,0,0,0,-1,0,0,0,1,-1,-1,1,0,-1,0,0,0,-1,1,-1,-1,0,0,-1,0,-1,-1,-1,1,0,1,0,0,-1,-1,-1,-1,1,0,1,0,0,1,0,-1,1,-1,0,-1,0,0,-1,0,1,0,0,0,1,1,-1,0,0,-1,-1,0,0,0,-1,0,0,0,-1,0,0,0,1,0,-1,0,-1,1,-1,-1,1,0,0,0,-1,-1,-1,0,-1,0,-1,1,1,1,1,-1,-1,-1,0,0,1,-1,1,0,0,0,0,1,1,1,0},
  {0,0,1,1,1,0,-1,1,0,1,-1,-1,1,1,1,-1,0,-1,-1,1,0,-1,-1,-1,1,1,0,0,0,0,-1,0,0,-1,-1,1,0,0,0,1,-1,1,1,0,0,1,0,1,-1,1,0,0,0,-1,0,1,0,0,-1,1,1,0,-1,1,-1,0,1,-1,0,0,0,-1,0,1,-1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,-1,-1,0,-1,1,0,0,0,0,1,0,1,0,0,1,0,1,-1,1,1,0,1,-1,0,0,-1,0,-1,1,0,-1,0,1,1,0,-1,0,0,0,1,1,-1,0,1,1,1,0,0,0,-1,-1,1,1,0,1,0,0,0,1,1,1,-1,1,-1,0,-1,0,0,0,-1,1,0,0,-1,0,0,1,0,1,0,1,-1,0,-1,-1,1,-1,1,0,1,1,1,0,0,-1,1,0,-1,1,0,1,1,0,1,1,0,0,1,-1,0,0,-1,0,-1,1,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,-1,0,0,-1,1,-1,-1,-1,0,0,0,-1,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,0,1,-1,1,1,0,-1,0,0,1,1,0,0,0,0,0,1,-1,-1,1,1,1,1,0,1,1,0,1,0,1,1,-1,-1,0,0,0,0,0,-1,0,0,0,0,0,-1,0,-1,0,1,1,0,1,-1,1,-1,1,0,0,0,0,0,1,1,0,0,0,-1,-1,-1,0,0,0,-1,0,0,-1,-1,0,0,0,1,-1,1,1,-1,1,0,0,0,0,0,1,1,1,0,-1,0,0,1,1,1,-1,0,1,-1,0,-1,0,0,0,0,0,1,0,-1,1,-1,1,-1,1,1,0,-1,-1,-1,-1,0,0,-1,-1,1,-1,-1,1,0,0,1,0,-1,-1,0,-1,1,0,0,-1,0,0,0,1,-1,-1,0,0,1,1,1,1,1,0,0,1,0,-1,1,0,0,-1,0,0,0,-1,0,0,-1,-1,1,-1,0,0,-1,0,-1,0,-1,1,0,0,0,0,1,-1,0,0,-1,1,0,1,1,0,-1,0,0,0,0,1,0,0,1,0,0,1,1,0,0,0,0,0,0,-1,0,1,-1,0,1,0,0,0,0,0,0,-1,1,0,0,0,0,-1,0,0,-1,-1,0,0,1,1,0,1,1,-1,1,0,1,1,0,0,-1,1,0,-1,0,0,-1,-1,-1,0,0,0,1,0,1,-1,1,0,-1,0,0,-1,0,-1,0,0,-1,0,0,-1,0,0,0,-1,-1,0,-1,0,0,0,0,1,-1,0,0,0,0,0,0,-1,-1,0,1,0,-1,-1,-1,-1,1,-1,-1,-1,-1,0,1,1,-1,0,1,0,0,0,0,0,0,1,0,1,1,-1,-1,-1,1,1,-1,-1,0,1,1,0,1,0,0,0,-1,0,0,0,0,1,0,1,1,1,1,0,0,0,0,-1,0,0,0,1,0,-1,1,0,1,-1,1,1,1,0,0,0,1,-1,0,0,0,1,-1,0,0,0,-1,-1,0,1,0,0},
  {1,-1,0,1,0,1,-1,0,0,1,0,0,1,0,0,-1,0,0,-1,0,0,-1,-1,0,-1,0,1,1,0,1,0,0,-1,1,0,0,-1,0,0,0,1,1,0,0,0,1,1,-1,1,0,0,0,0,0,0,0,0,1,0,0,0,1,0,-1,0,0,1,0,0,0,-1,0,-1,0,1,-1,-1,1,0,-1,1,0,0,0,-1,1,0,1,0,1,-1,-1,0,0,0,0,0,0,0,0,1,0,0,1,0,-1,0,1,0,0,0,1,0,1,0,1,0,1,1,1,-1,0,0,0,0,0,1,-1,0,0,0,1,0,0,-1,1,0,1,-1,1,-1,1,1,1,0,1,-1,0,1,0,-1,0,0,0,1,0,-1,0,0,0,1,-1,0,0,0,0,1,-1,0,0,0,1,-1,1,0,-1,-1,0,-1,-1,0,0,0,0,0,-1,-1,1,0,0,0,0,0,0,1,-1,-1,0,1,0,-1,0,-1,-1,0,0,0,0,0,0,-1,1,0,-1,0,0,1,1,-1,0,1,1,0,-1,-1,0,-1,1,-1,1,0,-1,1,1,0,0,0,0,-1,-1,-1,0,-1,0,-1,0,1,0,1,0,-1,0,1,-1,0,0,0,1,0,0,0,0,-1,1,0,-1,0,0,0,0,1,0,0,0,0,0,0,1,-1,-1,0,0,0,-1,0,1,1,-1,0,1,-1,0,0,0,-1,-1,-1,-1,1,1,-1,-1,1,1,-1,1,-1,1,1,0,-1,-1,1,-1,1,0,0,0,0,0,1,-1,-1,1,1,1,-1,-1,0,0,-1,0,0,0,0,0,1,-1,-1,0,-1,0,1,0,1,1,1,-1,1,0,0,-1,1,1,0,0,0,0,0,0,0,0,-1,1,-1,0,-1,-1,0,-1,1,1,0,0,-1,0,-1,1,1,0,1,1,0,0,0,-1,0,0,1,1,0,-1,0,0,0,1,0,0,0,-1,0,0,1,1,1,0,-1,0,0,0,-1,0,0,-1,1,1,0,1,0,0,1,0,-1,0,0,0,0,0,0,0,0,-1,0,1,1,0,-1,0,-1,-1,-1,0,0,1,0,0,0,1,0,0,-1,1,0,0,-1,1,0,0,0,-1,-1,1,0,0,1,0,0,0,0,-1,1,1,0,-1,1,0,-1,-1,1,0,0,1,0,-1,0,-1,0,0,0,0,-1,0,-1,-1,0,0,1,1,1,0,-1,-1,1,0,0,0,1,1,0,0,1,1,0,-1,1,-1,-1,1,-1,0,-1,1,0,1,0,0,1,1,0,0,0,1,-1,1,-1,0,0,-1,1,1,0,-1,0,-1,0,1,1,0,1,0,0,0,0,0,-1,-1,1,0,0,1,1,0,-1,0,-1,0,-1,-1,-1,1,1,1,-1,-1,1,-1,0,0,1,0,-1,0,-1,0,0,-1,1,0,0,0,-1,0,1,0,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,-1,-1,-1,1,-1,0,-1,0,0,1,0,0,1,-1,1,-1,-1,1,-1,0,-1,0,0,0,0,0,1,1,1,1,0,-1,1,-1,1,0,0,-1,0,0,0,1,-1,1},
  {0,0,1,0,0,0,0,-1,0,1,1,-1,1,0,0,1,-1,0,0,1,1,-1,1,0,0,1,0,0,-1,0,0,-1,0,0,1,-1,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,-1,0,-1,-1,0,-1,1,-1,-1,1,0,-1,1,-1,0,0,0,0,1,-1,-1,0,1,-1,1,-1,-1,0,0,0,0,1,0,0,0,1,0,0,0,-1,0,-1,0,0,-1,0,0,1,0,-1,-1,1,1,-1,-1,0,0,0,1,-1,-1,0,-1,0,0,0,1,0,0,1,0,0,0,1,-1,1,0,0,0,0,0,1,0,0,-1,-1,-1,-1,0,0,0,0,1,0,0,1,0,1,0,-1,0,0,1,-1,0,0,0,0,-1,1,-1,0,1,0,0,0,0,1,0,-1,1,0,1,1,0,-1,1,0,0,-1,0,0,1,1,0,0,-1,0,-1,-1,-1,0,0,1,-1,0,0,0,1,-1,0,1,0,0,0,0,0,0,0,0,0,0,-1,0,1,0,1,1,0,-1,0,0,0,-1,1,1,-1,1,-1,0,-1,0,1,0,-1,-1,0,1,-1,-1,1,1,-1,1,0,-1,1,-1,-1,-1,-1,0,0,1,1,0,1,-1,0,1,-1,0,0,0,0,-1,1,1,0,-1,0,1,1,0,0,-1,0,0,0,1,0,1,0,1,0,0,0,0,0,-1,0,1,1,0,1,0,0,0,-1,-1,1,0,0,-1,1,1,0,0,1,-1,-1,0,-1,1,-1,0,0,-1,-1,-1,0,1,1,0,-1,0,0,0,0,-1,0,-1,0,-1,-1,0,0,1,-1,0,0,-1,0,0,-1,0,-1,1,-1,0,-1,1,0,0,-1,0,0,0,-1,0,1,0,1,1,0,0,0,1,0,0,0,-1,0,1,0,0,1,-1,0,-1,1,0,0,0,1,-1,-1,1,-1,-1,0,0,0,-1,0,-1,-1,1,0,0,0,0,1,0,1,1,1,-1,-1,0,0,0,0,0,-1,0,-1,0,0,0,0,-1,-1,-1,1,0,1,1,-1,1,1,0,1,-1,0,1,1,-1,1,-1,1,0,1,0,0,-1,1,0,-1,1,-1,1,0,0,1,-1,0,0,1,0,0,0,0,-1,0,1,0,0,-1,0,0,0,0,0,1,0,0,0,-1,-1,0,0,0,-1,-1,0,0,1,1,0,0,0,0,0,-1,-1,1,-1,-1,0,1,0,1,1,-1,0,0,0,-1,0,0,-1,-1,1,0,0,-1,0,0,0,-1,0,1,0,0,0,0,1,0,1,0,0,1,0,-1,0,-1,1,0,0,0,1,-1,0,1,0,-1,1,0,-1,1,-1,-1,-1,-1,1,0,1,0,0,1,1,1,0,0,-1,-1,1,0,0,0,0,-1,0,0,0,0,1,1,0,-1,1,-1,1,0,0,0,0,-1,1,0,1,0,0,1,0,1,1,0,0,1,1,0,1,1,0,0,0,1,1,1,1,-1,-1,0,1,0,0,1,0,-1,0,0,0,0,0,0,1,0,1,1,1,0,1,0,0,0,-1,0,-1,0,0,1,0,-1,-1,0,-1,0,0,0,-1},
} ;

static const unsigned char precomputed_core_multsntrup653_c[precomputed_core_multsntrup653_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
} ;

static void test_core_multsntrup653_impl(long long impl)
{
  unsigned char *h = test_core_multsntrup653_h;
  unsigned char *n = test_core_multsntrup653_n;
  unsigned char *k = test_core_multsntrup653_k;
  unsigned char *c = test_core_multsntrup653_c;
  unsigned char *h2 = test_core_multsntrup653_h2;
  unsigned char *n2 = test_core_multsntrup653_n2;
  unsigned char *k2 = test_core_multsntrup653_k2;
  unsigned char *c2 = test_core_multsntrup653_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_multsntrup653_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_multsntrup653(impl);
    printf("core_multsntrup653 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_multsntrup653_implementation(impl),ntruprime_dispatch_core_multsntrup653_compiler(impl));
  } else {
    crypto_core = ntruprime_core_multsntrup653;
    printf("core_multsntrup653 selected implementation %s compiler %s\n",ntruprime_core_multsntrup653_implementation(),ntruprime_core_multsntrup653_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(n2,n2,k,c);
      public(n2,hlen);
      public(k,klen);
      public(c,clen);
      if (memcmp(n2,h,hlen) != 0) fail("failure: crypto_core does not handle n=h overlap\n");
      memcpy(n2,n,nlen);
      secret(n,nlen);
      secret(k2,klen);
      secret(c,clen);
      crypto_core(k2,n,k2,c);
      public(k2,hlen);
      public(n,nlen);
      public(c,clen);
      if (memcmp(k2,h,hlen) != 0) fail("failure: crypto_core does not handle k=h overlap\n");
      memcpy(k2,k,klen);
      secret(n,nlen);
      secret(k,klen);
      secret(c2,clen);
      crypto_core(c2,n,k,c2);
      public(c2,hlen);
      public(n,nlen);
      public(k,klen);
      if (memcmp(c2,h,hlen) != 0) fail("failure: crypto_core does not handle c=h overlap\n");
      memcpy(c2,c,clen);
    }
    checksum_expected(core_multsntrup653_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_multsntrup653_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_multsntrup653_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_multsntrup653_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_multsntrup653_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_multsntrup653_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_multsntrup653_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_multsntrup653_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_multsntrup653_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_multsntrup653_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_multsntrup653(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"multsntrup653")) return;
  storage_core_multsntrup653_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_multsntrup653_h = aligned(storage_core_multsntrup653_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_multsntrup653_n = callocplus(crypto_core_INPUTBYTES);
  test_core_multsntrup653_n = aligned(storage_core_multsntrup653_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_multsntrup653_k = callocplus(crypto_core_KEYBYTES);
  test_core_multsntrup653_k = aligned(storage_core_multsntrup653_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_multsntrup653_c = callocplus(crypto_core_CONSTBYTES);
  test_core_multsntrup653_c = aligned(storage_core_multsntrup653_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_multsntrup653_h2 = callocplus(maxalloc);
  test_core_multsntrup653_h2 = aligned(storage_core_multsntrup653_h2,crypto_core_OUTPUTBYTES);
  storage_core_multsntrup653_n2 = callocplus(maxalloc);
  test_core_multsntrup653_n2 = aligned(storage_core_multsntrup653_n2,crypto_core_INPUTBYTES);
  storage_core_multsntrup653_k2 = callocplus(maxalloc);
  test_core_multsntrup653_k2 = aligned(storage_core_multsntrup653_k2,crypto_core_KEYBYTES);
  storage_core_multsntrup653_c2 = callocplus(maxalloc);
  test_core_multsntrup653_c2 = aligned(storage_core_multsntrup653_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_multsntrup653 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_multsntrup653();++impl)
      forked(test_core_multsntrup653_impl,impl);
    ++test_core_multsntrup653_h;
    ++test_core_multsntrup653_n;
    ++test_core_multsntrup653_k;
    ++test_core_multsntrup653_c;
    ++test_core_multsntrup653_h2;
    ++test_core_multsntrup653_n2;
    ++test_core_multsntrup653_k2;
    ++test_core_multsntrup653_c2;
  }
  free(storage_core_multsntrup653_c2);
  free(storage_core_multsntrup653_k2);
  free(storage_core_multsntrup653_n2);
  free(storage_core_multsntrup653_h2);
  free(storage_core_multsntrup653_c);
  free(storage_core_multsntrup653_k);
  free(storage_core_multsntrup653_n);
  free(storage_core_multsntrup653_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

