#ifndef HAVE_SOA_RR_H
#define HAVE_SOA_RR_H

#include "adns_rr.h"

namespace ADNS {

	public ref class SOA_RR : ResourceRecord 
	{
	private:
		DOMAIN_NAME^ mname;
		DOMAIN_NAME^ rname;
		UInt32 serial;
		UInt32 refresh;
		UInt32 retry;
		UInt32 expire;
		UInt32 minimum;
		Void UpdateRdata();

	public:

		SOA_RR();
		DOMAIN_NAME^ GetMname();
		Void SetMname(DOMAIN_NAME^ dn);
		DOMAIN_NAME^ GetRname();
		Void SetRname(DOMAIN_NAME^ dn);
		UInt32 GetSerial();
		UInt32 GetRefresh();
		UInt32 GetRetry();
		UInt32 GetExpire();
		UInt32 GetMinimum();
		Void SetSerial(UInt32 n);
		Void SetRefresh(UInt32 n);
		Void SetRetry(UInt32 n);
		Void SetExpire(UInt32 n);
		Void SetMinimum(UInt32 n);
		String^ Print();
		Void ToCanonical();
		SOA_RR^ Clone();
		static ResourceRecord^ ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start);
		static String^ PrintRR(ResourceRecord^ rec);
		static ResourceRecord^ CloneRR(ResourceRecord^ rec);

	};

}

#endif