
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAbstractSocket.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAbstractSocket>
#include <QAuthenticator>
#include <QEvent>
#include <QHostAddress>
#include <QMetaMethod>
#include <QNetworkProxy>
#include <QObject>
#include <QThread>
#include "gsiQt.h"
#include "gsiQtNetworkCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAbstractSocket

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAbstractSocket::staticMetaObject);
}


//  Constructor QAbstractSocket::QAbstractSocket(QAbstractSocket::SocketType socketType, QObject *parent)


static void _init_ctor_QAbstractSocket_4299 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("socketType");
  decl->add_arg<const qt_gsi::Converter<QAbstractSocket::SocketType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QAbstractSocket> ();
}

static void _call_ctor_QAbstractSocket_4299 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractSocket::SocketType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAbstractSocket::SocketType>::target_type & >() (args, heap);
  QObject *arg2 = gsi::arg_reader<QObject * >() (args, heap);
  ret.write<QAbstractSocket *> (new QAbstractSocket (qt_gsi::QtToCppAdaptor<QAbstractSocket::SocketType>(arg1).cref(), arg2));
}


// void QAbstractSocket::abort()


static void _init_f_abort_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_abort_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractSocket *)cls)->abort ();
}


// bool QAbstractSocket::bind(const QHostAddress &address, quint16 port, QFlags<QAbstractSocket::BindFlag> mode)


static void _init_f_bind_6927 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("address");
  decl->add_arg<const QHostAddress & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("port", true, "0");
  decl->add_arg<quint16 > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "QAbstractSocket::DefaultForPlatform");
  decl->add_arg<QFlags<QAbstractSocket::BindFlag> > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_bind_6927 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QHostAddress &arg1 = gsi::arg_reader<const QHostAddress & >() (args, heap);
  quint16 arg2 = args ? gsi::arg_reader<quint16 >() (args, heap) : gsi::arg_maker<quint16 >() (0, heap);
  QFlags<QAbstractSocket::BindFlag> arg3 = args ? gsi::arg_reader<QFlags<QAbstractSocket::BindFlag> >() (args, heap) : gsi::arg_maker<QFlags<QAbstractSocket::BindFlag> >() (QAbstractSocket::DefaultForPlatform, heap);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->bind (arg1, arg2, arg3));
}


// bool QAbstractSocket::bind(quint16 port, QFlags<QAbstractSocket::BindFlag> mode)


static void _init_f_bind_4517 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("port", true, "0");
  decl->add_arg<quint16 > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QAbstractSocket::DefaultForPlatform");
  decl->add_arg<QFlags<QAbstractSocket::BindFlag> > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_bind_4517 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  quint16 arg1 = args ? gsi::arg_reader<quint16 >() (args, heap) : gsi::arg_maker<quint16 >() (0, heap);
  QFlags<QAbstractSocket::BindFlag> arg2 = args ? gsi::arg_reader<QFlags<QAbstractSocket::BindFlag> >() (args, heap) : gsi::arg_maker<QFlags<QAbstractSocket::BindFlag> >() (QAbstractSocket::DefaultForPlatform, heap);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->bind (arg1, arg2));
}


// qint64 QAbstractSocket::bytesAvailable()


static void _init_f_bytesAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_bytesAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAbstractSocket *)cls)->bytesAvailable ());
}


// qint64 QAbstractSocket::bytesToWrite()


static void _init_f_bytesToWrite_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_bytesToWrite_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAbstractSocket *)cls)->bytesToWrite ());
}


// void QAbstractSocket::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractSocket *)cls)->close ();
}


// void QAbstractSocket::connectToHost(const QString &hostName, quint16 port, QFlags<QIODeviceBase::OpenModeFlag> mode, QAbstractSocket::NetworkLayerProtocol protocol)


static void _init_f_connectToHost_10597 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hostName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("port");
  decl->add_arg<quint16 > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "QIODeviceBase::ReadWrite");
  decl->add_arg<QFlags<QIODeviceBase::OpenModeFlag> > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("protocol", true, "QAbstractSocket::AnyIPProtocol");
  decl->add_arg<const qt_gsi::Converter<QAbstractSocket::NetworkLayerProtocol>::target_type & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_connectToHost_10597 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  quint16 arg2 = gsi::arg_reader<quint16 >() (args, heap);
  QFlags<QIODeviceBase::OpenModeFlag> arg3 = args ? gsi::arg_reader<QFlags<QIODeviceBase::OpenModeFlag> >() (args, heap) : gsi::arg_maker<QFlags<QIODeviceBase::OpenModeFlag> >() (QIODeviceBase::ReadWrite, heap);
  const qt_gsi::Converter<QAbstractSocket::NetworkLayerProtocol>::target_type & arg4 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractSocket::NetworkLayerProtocol>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractSocket::NetworkLayerProtocol>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractSocket::NetworkLayerProtocol>(heap, QAbstractSocket::AnyIPProtocol), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractSocket *)cls)->connectToHost (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QAbstractSocket::NetworkLayerProtocol>(arg4).cref());
}


// void QAbstractSocket::connectToHost(const QHostAddress &address, quint16 port, QFlags<QIODeviceBase::OpenModeFlag> mode)


static void _init_f_connectToHost_7023 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("address");
  decl->add_arg<const QHostAddress & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("port");
  decl->add_arg<quint16 > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "QIODeviceBase::ReadWrite");
  decl->add_arg<QFlags<QIODeviceBase::OpenModeFlag> > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_connectToHost_7023 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QHostAddress &arg1 = gsi::arg_reader<const QHostAddress & >() (args, heap);
  quint16 arg2 = gsi::arg_reader<quint16 >() (args, heap);
  QFlags<QIODeviceBase::OpenModeFlag> arg3 = args ? gsi::arg_reader<QFlags<QIODeviceBase::OpenModeFlag> >() (args, heap) : gsi::arg_maker<QFlags<QIODeviceBase::OpenModeFlag> >() (QIODeviceBase::ReadWrite, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractSocket *)cls)->connectToHost (arg1, arg2, arg3);
}


// void QAbstractSocket::disconnectFromHost()


static void _init_f_disconnectFromHost_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_disconnectFromHost_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractSocket *)cls)->disconnectFromHost ();
}


// QAbstractSocket::SocketError QAbstractSocket::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAbstractSocket::SocketError>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAbstractSocket::SocketError>::target_type > ((qt_gsi::Converter<QAbstractSocket::SocketError>::target_type)qt_gsi::CppToQtAdaptor<QAbstractSocket::SocketError>(((QAbstractSocket *)cls)->error ()));
}


// void QAbstractSocket::errorOccurred(QAbstractSocket::SocketError)


static void _init_f_errorOccurred_3209 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QAbstractSocket::SocketError>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_errorOccurred_3209 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractSocket::SocketError>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAbstractSocket::SocketError>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractSocket *)cls)->errorOccurred (qt_gsi::QtToCppAdaptor<QAbstractSocket::SocketError>(arg1).cref());
}


// bool QAbstractSocket::flush()


static void _init_f_flush_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_flush_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->flush ());
}


// bool QAbstractSocket::isSequential()


static void _init_f_isSequential_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSequential_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->isSequential ());
}


// bool QAbstractSocket::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->isValid ());
}


// QHostAddress QAbstractSocket::localAddress()


static void _init_f_localAddress_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QHostAddress > ();
}

static void _call_f_localAddress_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QHostAddress > ((QHostAddress)((QAbstractSocket *)cls)->localAddress ());
}


// quint16 QAbstractSocket::localPort()


static void _init_f_localPort_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<quint16 > ();
}

static void _call_f_localPort_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<quint16 > ((quint16)((QAbstractSocket *)cls)->localPort ());
}


// QFlags<QAbstractSocket::PauseMode> QAbstractSocket::pauseMode()


static void _init_f_pauseMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QAbstractSocket::PauseMode> > ();
}

static void _call_f_pauseMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QAbstractSocket::PauseMode> > ((QFlags<QAbstractSocket::PauseMode>)((QAbstractSocket *)cls)->pauseMode ());
}


// QHostAddress QAbstractSocket::peerAddress()


static void _init_f_peerAddress_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QHostAddress > ();
}

static void _call_f_peerAddress_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QHostAddress > ((QHostAddress)((QAbstractSocket *)cls)->peerAddress ());
}


// QString QAbstractSocket::peerName()


static void _init_f_peerName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_peerName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QAbstractSocket *)cls)->peerName ());
}


// quint16 QAbstractSocket::peerPort()


static void _init_f_peerPort_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<quint16 > ();
}

static void _call_f_peerPort_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<quint16 > ((quint16)((QAbstractSocket *)cls)->peerPort ());
}


// QString QAbstractSocket::protocolTag()


static void _init_f_protocolTag_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_protocolTag_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QAbstractSocket *)cls)->protocolTag ());
}


// QNetworkProxy QAbstractSocket::proxy()


static void _init_f_proxy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QNetworkProxy > ();
}

static void _call_f_proxy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QNetworkProxy > ((QNetworkProxy)((QAbstractSocket *)cls)->proxy ());
}


// qint64 QAbstractSocket::readBufferSize()


static void _init_f_readBufferSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_readBufferSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAbstractSocket *)cls)->readBufferSize ());
}


// void QAbstractSocket::resume()


static void _init_f_resume_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resume_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractSocket *)cls)->resume ();
}


// void QAbstractSocket::setPauseMode(QFlags<QAbstractSocket::PauseMode> pauseMode)


static void _init_f_setPauseMode_3665 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pauseMode");
  decl->add_arg<QFlags<QAbstractSocket::PauseMode> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPauseMode_3665 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QAbstractSocket::PauseMode> arg1 = gsi::arg_reader<QFlags<QAbstractSocket::PauseMode> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractSocket *)cls)->setPauseMode (arg1);
}


// void QAbstractSocket::setProtocolTag(const QString &tag)


static void _init_f_setProtocolTag_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tag");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setProtocolTag_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractSocket *)cls)->setProtocolTag (arg1);
}


// void QAbstractSocket::setProxy(const QNetworkProxy &networkProxy)


static void _init_f_setProxy_2686 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("networkProxy");
  decl->add_arg<const QNetworkProxy & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setProxy_2686 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkProxy &arg1 = gsi::arg_reader<const QNetworkProxy & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractSocket *)cls)->setProxy (arg1);
}


// void QAbstractSocket::setReadBufferSize(qint64 size)


static void _init_f_setReadBufferSize_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setReadBufferSize_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractSocket *)cls)->setReadBufferSize (arg1);
}


// bool QAbstractSocket::setSocketDescriptor(QIntegerForSizeof<void *>::Signed socketDescriptor, QAbstractSocket::SocketState state, QFlags<QIODeviceBase::OpenModeFlag> openMode)


static void _init_f_setSocketDescriptor_10219 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("socketDescriptor");
  decl->add_arg<QIntegerForSizeof<void *>::Signed > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("state", true, "QAbstractSocket::ConnectedState");
  decl->add_arg<const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("openMode", true, "QIODeviceBase::ReadWrite");
  decl->add_arg<QFlags<QIODeviceBase::OpenModeFlag> > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_setSocketDescriptor_10219 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIntegerForSizeof<void *>::Signed arg1 = gsi::arg_reader<QIntegerForSizeof<void *>::Signed >() (args, heap);
  const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractSocket::SocketState>(heap, QAbstractSocket::ConnectedState), heap);
  QFlags<QIODeviceBase::OpenModeFlag> arg3 = args ? gsi::arg_reader<QFlags<QIODeviceBase::OpenModeFlag> >() (args, heap) : gsi::arg_maker<QFlags<QIODeviceBase::OpenModeFlag> >() (QIODeviceBase::ReadWrite, heap);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->setSocketDescriptor (arg1, qt_gsi::QtToCppAdaptor<QAbstractSocket::SocketState>(arg2).cref(), arg3));
}


// void QAbstractSocket::setSocketOption(QAbstractSocket::SocketOption option, const QVariant &value)


static void _init_f_setSocketOption_5331 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setSocketOption_5331 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractSocket *)cls)->setSocketOption (qt_gsi::QtToCppAdaptor<QAbstractSocket::SocketOption>(arg1).cref(), arg2);
}


// QIntegerForSizeof<void *>::Signed QAbstractSocket::socketDescriptor()


static void _init_f_socketDescriptor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIntegerForSizeof<void *>::Signed > ();
}

static void _call_f_socketDescriptor_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QIntegerForSizeof<void *>::Signed > ((QIntegerForSizeof<void *>::Signed)((QAbstractSocket *)cls)->socketDescriptor ());
}


// QVariant QAbstractSocket::socketOption(QAbstractSocket::SocketOption option)


static void _init_f_socketOption_3320 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_socketOption_3320 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & >() (args, heap);
  ret.write<QVariant > ((QVariant)((QAbstractSocket *)cls)->socketOption (qt_gsi::QtToCppAdaptor<QAbstractSocket::SocketOption>(arg1).cref()));
}


// QAbstractSocket::SocketType QAbstractSocket::socketType()


static void _init_f_socketType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAbstractSocket::SocketType>::target_type > ();
}

static void _call_f_socketType_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAbstractSocket::SocketType>::target_type > ((qt_gsi::Converter<QAbstractSocket::SocketType>::target_type)qt_gsi::CppToQtAdaptor<QAbstractSocket::SocketType>(((QAbstractSocket *)cls)->socketType ()));
}


// QAbstractSocket::SocketState QAbstractSocket::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAbstractSocket::SocketState>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAbstractSocket::SocketState>::target_type > ((qt_gsi::Converter<QAbstractSocket::SocketState>::target_type)qt_gsi::CppToQtAdaptor<QAbstractSocket::SocketState>(((QAbstractSocket *)cls)->state ()));
}


// bool QAbstractSocket::waitForBytesWritten(int msecs)


static void _init_f_waitForBytesWritten_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForBytesWritten_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (30000, heap);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->waitForBytesWritten (arg1));
}


// bool QAbstractSocket::waitForConnected(int msecs)


static void _init_f_waitForConnected_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForConnected_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (30000, heap);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->waitForConnected (arg1));
}


// bool QAbstractSocket::waitForDisconnected(int msecs)


static void _init_f_waitForDisconnected_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForDisconnected_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (30000, heap);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->waitForDisconnected (arg1));
}


// bool QAbstractSocket::waitForReadyRead(int msecs)


static void _init_f_waitForReadyRead_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForReadyRead_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (30000, heap);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->waitForReadyRead (arg1));
}


// static QString QAbstractSocket::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAbstractSocket::tr (arg1, arg2, arg3));
}



namespace gsi
{

static gsi::Methods methods_QAbstractSocket () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAbstractSocket::QAbstractSocket(QAbstractSocket::SocketType socketType, QObject *parent)\nThis method creates an object of class QAbstractSocket.", &_init_ctor_QAbstractSocket_4299, &_call_ctor_QAbstractSocket_4299);
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("abort", "@brief Method void QAbstractSocket::abort()\n", false, &_init_f_abort_0, &_call_f_abort_0);
  methods += new qt_gsi::GenericMethod ("bind", "@brief Method bool QAbstractSocket::bind(const QHostAddress &address, quint16 port, QFlags<QAbstractSocket::BindFlag> mode)\n", false, &_init_f_bind_6927, &_call_f_bind_6927);
  methods += new qt_gsi::GenericMethod ("bind", "@brief Method bool QAbstractSocket::bind(quint16 port, QFlags<QAbstractSocket::BindFlag> mode)\n", false, &_init_f_bind_4517, &_call_f_bind_4517);
  methods += new qt_gsi::GenericMethod ("bytesAvailable", "@brief Method qint64 QAbstractSocket::bytesAvailable()\nThis is a reimplementation of QIODevice::bytesAvailable", true, &_init_f_bytesAvailable_c0, &_call_f_bytesAvailable_c0);
  methods += new qt_gsi::GenericMethod ("bytesToWrite", "@brief Method qint64 QAbstractSocket::bytesToWrite()\nThis is a reimplementation of QIODevice::bytesToWrite", true, &_init_f_bytesToWrite_c0, &_call_f_bytesToWrite_c0);
  methods += new qt_gsi::GenericMethod ("close", "@brief Method void QAbstractSocket::close()\nThis is a reimplementation of QIODevice::close", false, &_init_f_close_0, &_call_f_close_0);
  methods += new qt_gsi::GenericMethod ("connectToHost", "@brief Method void QAbstractSocket::connectToHost(const QString &hostName, quint16 port, QFlags<QIODeviceBase::OpenModeFlag> mode, QAbstractSocket::NetworkLayerProtocol protocol)\n", false, &_init_f_connectToHost_10597, &_call_f_connectToHost_10597);
  methods += new qt_gsi::GenericMethod ("connectToHost", "@brief Method void QAbstractSocket::connectToHost(const QHostAddress &address, quint16 port, QFlags<QIODeviceBase::OpenModeFlag> mode)\n", false, &_init_f_connectToHost_7023, &_call_f_connectToHost_7023);
  methods += new qt_gsi::GenericMethod ("disconnectFromHost", "@brief Method void QAbstractSocket::disconnectFromHost()\n", false, &_init_f_disconnectFromHost_0, &_call_f_disconnectFromHost_0);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method QAbstractSocket::SocketError QAbstractSocket::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("errorOccurred", "@brief Method void QAbstractSocket::errorOccurred(QAbstractSocket::SocketError)\n", false, &_init_f_errorOccurred_3209, &_call_f_errorOccurred_3209);
  methods += new qt_gsi::GenericMethod ("flush", "@brief Method bool QAbstractSocket::flush()\n", false, &_init_f_flush_0, &_call_f_flush_0);
  methods += new qt_gsi::GenericMethod ("isSequential?", "@brief Method bool QAbstractSocket::isSequential()\nThis is a reimplementation of QIODevice::isSequential", true, &_init_f_isSequential_c0, &_call_f_isSequential_c0);
  methods += new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QAbstractSocket::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
  methods += new qt_gsi::GenericMethod ("localAddress", "@brief Method QHostAddress QAbstractSocket::localAddress()\n", true, &_init_f_localAddress_c0, &_call_f_localAddress_c0);
  methods += new qt_gsi::GenericMethod ("localPort", "@brief Method quint16 QAbstractSocket::localPort()\n", true, &_init_f_localPort_c0, &_call_f_localPort_c0);
  methods += new qt_gsi::GenericMethod (":pauseMode", "@brief Method QFlags<QAbstractSocket::PauseMode> QAbstractSocket::pauseMode()\n", true, &_init_f_pauseMode_c0, &_call_f_pauseMode_c0);
  methods += new qt_gsi::GenericMethod ("peerAddress", "@brief Method QHostAddress QAbstractSocket::peerAddress()\n", true, &_init_f_peerAddress_c0, &_call_f_peerAddress_c0);
  methods += new qt_gsi::GenericMethod ("peerName", "@brief Method QString QAbstractSocket::peerName()\n", true, &_init_f_peerName_c0, &_call_f_peerName_c0);
  methods += new qt_gsi::GenericMethod ("peerPort", "@brief Method quint16 QAbstractSocket::peerPort()\n", true, &_init_f_peerPort_c0, &_call_f_peerPort_c0);
  methods += new qt_gsi::GenericMethod ("protocolTag", "@brief Method QString QAbstractSocket::protocolTag()\n", true, &_init_f_protocolTag_c0, &_call_f_protocolTag_c0);
  methods += new qt_gsi::GenericMethod (":proxy", "@brief Method QNetworkProxy QAbstractSocket::proxy()\n", true, &_init_f_proxy_c0, &_call_f_proxy_c0);
  methods += new qt_gsi::GenericMethod (":readBufferSize", "@brief Method qint64 QAbstractSocket::readBufferSize()\n", true, &_init_f_readBufferSize_c0, &_call_f_readBufferSize_c0);
  methods += new qt_gsi::GenericMethod ("resume", "@brief Method void QAbstractSocket::resume()\n", false, &_init_f_resume_0, &_call_f_resume_0);
  methods += new qt_gsi::GenericMethod ("setPauseMode|pauseMode=", "@brief Method void QAbstractSocket::setPauseMode(QFlags<QAbstractSocket::PauseMode> pauseMode)\n", false, &_init_f_setPauseMode_3665, &_call_f_setPauseMode_3665);
  methods += new qt_gsi::GenericMethod ("setProtocolTag", "@brief Method void QAbstractSocket::setProtocolTag(const QString &tag)\n", false, &_init_f_setProtocolTag_2025, &_call_f_setProtocolTag_2025);
  methods += new qt_gsi::GenericMethod ("setProxy|proxy=", "@brief Method void QAbstractSocket::setProxy(const QNetworkProxy &networkProxy)\n", false, &_init_f_setProxy_2686, &_call_f_setProxy_2686);
  methods += new qt_gsi::GenericMethod ("setReadBufferSize|readBufferSize=", "@brief Method void QAbstractSocket::setReadBufferSize(qint64 size)\n", false, &_init_f_setReadBufferSize_986, &_call_f_setReadBufferSize_986);
  methods += new qt_gsi::GenericMethod ("setSocketDescriptor", "@brief Method bool QAbstractSocket::setSocketDescriptor(QIntegerForSizeof<void *>::Signed socketDescriptor, QAbstractSocket::SocketState state, QFlags<QIODeviceBase::OpenModeFlag> openMode)\n", false, &_init_f_setSocketDescriptor_10219, &_call_f_setSocketDescriptor_10219);
  methods += new qt_gsi::GenericMethod ("setSocketOption", "@brief Method void QAbstractSocket::setSocketOption(QAbstractSocket::SocketOption option, const QVariant &value)\n", false, &_init_f_setSocketOption_5331, &_call_f_setSocketOption_5331);
  methods += new qt_gsi::GenericMethod ("socketDescriptor", "@brief Method QIntegerForSizeof<void *>::Signed QAbstractSocket::socketDescriptor()\n", true, &_init_f_socketDescriptor_c0, &_call_f_socketDescriptor_c0);
  methods += new qt_gsi::GenericMethod ("socketOption", "@brief Method QVariant QAbstractSocket::socketOption(QAbstractSocket::SocketOption option)\n", false, &_init_f_socketOption_3320, &_call_f_socketOption_3320);
  methods += new qt_gsi::GenericMethod ("socketType", "@brief Method QAbstractSocket::SocketType QAbstractSocket::socketType()\n", true, &_init_f_socketType_c0, &_call_f_socketType_c0);
  methods += new qt_gsi::GenericMethod ("state", "@brief Method QAbstractSocket::SocketState QAbstractSocket::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
  methods += new qt_gsi::GenericMethod ("waitForBytesWritten", "@brief Method bool QAbstractSocket::waitForBytesWritten(int msecs)\nThis is a reimplementation of QIODevice::waitForBytesWritten", false, &_init_f_waitForBytesWritten_767, &_call_f_waitForBytesWritten_767);
  methods += new qt_gsi::GenericMethod ("waitForConnected", "@brief Method bool QAbstractSocket::waitForConnected(int msecs)\n", false, &_init_f_waitForConnected_767, &_call_f_waitForConnected_767);
  methods += new qt_gsi::GenericMethod ("waitForDisconnected", "@brief Method bool QAbstractSocket::waitForDisconnected(int msecs)\n", false, &_init_f_waitForDisconnected_767, &_call_f_waitForDisconnected_767);
  methods += new qt_gsi::GenericMethod ("waitForReadyRead", "@brief Method bool QAbstractSocket::waitForReadyRead(int msecs)\nThis is a reimplementation of QIODevice::waitForReadyRead", false, &_init_f_waitForReadyRead_767, &_call_f_waitForReadyRead_767);
  methods += gsi::qt_signal ("aboutToClose()", "aboutToClose", "@brief Signal declaration for QAbstractSocket::aboutToClose()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<qint64 > ("bytesWritten(qint64)", "bytesWritten", gsi::arg("bytes"), "@brief Signal declaration for QAbstractSocket::bytesWritten(qint64 bytes)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, qint64 > ("channelBytesWritten(int, qint64)", "channelBytesWritten", gsi::arg("channel"), gsi::arg("bytes"), "@brief Signal declaration for QAbstractSocket::channelBytesWritten(int channel, qint64 bytes)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("channelReadyRead(int)", "channelReadyRead", gsi::arg("channel"), "@brief Signal declaration for QAbstractSocket::channelReadyRead(int channel)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("connected()", "connected", "@brief Signal declaration for QAbstractSocket::connected()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QAbstractSocket::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("disconnected()", "disconnected", "@brief Signal declaration for QAbstractSocket::disconnected()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("hostFound()", "hostFound", "@brief Signal declaration for QAbstractSocket::hostFound()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QAbstractSocket::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QNetworkProxy &, QAuthenticator * > ("proxyAuthenticationRequired(const QNetworkProxy &, QAuthenticator *)", "proxyAuthenticationRequired", gsi::arg("proxy"), gsi::arg("authenticator"), "@brief Signal declaration for QAbstractSocket::proxyAuthenticationRequired(const QNetworkProxy &proxy, QAuthenticator *authenticator)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("readChannelFinished()", "readChannelFinished", "@brief Signal declaration for QAbstractSocket::readChannelFinished()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("readyRead()", "readyRead", "@brief Signal declaration for QAbstractSocket::readyRead()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type & > ("stateChanged(QAbstractSocket::SocketState)", "stateChanged", gsi::arg("arg1"), "@brief Signal declaration for QAbstractSocket::stateChanged(QAbstractSocket::SocketState)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractSocket::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QIODevice> &qtdecl_QIODevice ();

qt_gsi::QtNativeClass<QAbstractSocket> decl_QAbstractSocket (qtdecl_QIODevice (), "QtNetwork", "QAbstractSocket",
  methods_QAbstractSocket (),
  "@qt\n@brief Binding of QAbstractSocket");


GSI_QTNETWORK_PUBLIC gsi::Class<QAbstractSocket> &qtdecl_QAbstractSocket () { return decl_QAbstractSocket; }

}


//  Implementation of the enum wrapper class for QAbstractSocket::BindFlag
namespace qt_gsi
{

static gsi::Enum<QAbstractSocket::BindFlag> decl_QAbstractSocket_BindFlag_Enum ("QtNetwork", "QAbstractSocket_BindFlag",
    gsi::enum_const ("DefaultForPlatform", QAbstractSocket::DefaultForPlatform, "@brief Enum constant QAbstractSocket::DefaultForPlatform") +
    gsi::enum_const ("ShareAddress", QAbstractSocket::ShareAddress, "@brief Enum constant QAbstractSocket::ShareAddress") +
    gsi::enum_const ("DontShareAddress", QAbstractSocket::DontShareAddress, "@brief Enum constant QAbstractSocket::DontShareAddress") +
    gsi::enum_const ("ReuseAddressHint", QAbstractSocket::ReuseAddressHint, "@brief Enum constant QAbstractSocket::ReuseAddressHint"),
  "@qt\n@brief This class represents the QAbstractSocket::BindFlag enum");

static gsi::QFlagsClass<QAbstractSocket::BindFlag > decl_QAbstractSocket_BindFlag_Enums ("QtNetwork", "QAbstractSocket_QFlags_BindFlag",
  "@qt\n@brief This class represents the QFlags<QAbstractSocket::BindFlag> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractSocket> inject_QAbstractSocket_BindFlag_Enum_in_parent (decl_QAbstractSocket_BindFlag_Enum.defs ());
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_BindFlag_Enum_as_child (decl_QAbstractSocket_BindFlag_Enum, "BindFlag");
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_BindFlag_Enums_as_child (decl_QAbstractSocket_BindFlag_Enums, "QFlags_BindFlag");

}


//  Implementation of the enum wrapper class for QAbstractSocket::NetworkLayerProtocol
namespace qt_gsi
{

static gsi::Enum<QAbstractSocket::NetworkLayerProtocol> decl_QAbstractSocket_NetworkLayerProtocol_Enum ("QtNetwork", "QAbstractSocket_NetworkLayerProtocol",
    gsi::enum_const ("IPv4Protocol", QAbstractSocket::IPv4Protocol, "@brief Enum constant QAbstractSocket::IPv4Protocol") +
    gsi::enum_const ("IPv6Protocol", QAbstractSocket::IPv6Protocol, "@brief Enum constant QAbstractSocket::IPv6Protocol") +
    gsi::enum_const ("AnyIPProtocol", QAbstractSocket::AnyIPProtocol, "@brief Enum constant QAbstractSocket::AnyIPProtocol") +
    gsi::enum_const ("UnknownNetworkLayerProtocol", QAbstractSocket::UnknownNetworkLayerProtocol, "@brief Enum constant QAbstractSocket::UnknownNetworkLayerProtocol"),
  "@qt\n@brief This class represents the QAbstractSocket::NetworkLayerProtocol enum");

static gsi::QFlagsClass<QAbstractSocket::NetworkLayerProtocol > decl_QAbstractSocket_NetworkLayerProtocol_Enums ("QtNetwork", "QAbstractSocket_QFlags_NetworkLayerProtocol",
  "@qt\n@brief This class represents the QFlags<QAbstractSocket::NetworkLayerProtocol> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractSocket> inject_QAbstractSocket_NetworkLayerProtocol_Enum_in_parent (decl_QAbstractSocket_NetworkLayerProtocol_Enum.defs ());
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_NetworkLayerProtocol_Enum_as_child (decl_QAbstractSocket_NetworkLayerProtocol_Enum, "NetworkLayerProtocol");
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_NetworkLayerProtocol_Enums_as_child (decl_QAbstractSocket_NetworkLayerProtocol_Enums, "QFlags_NetworkLayerProtocol");

}


//  Implementation of the enum wrapper class for QAbstractSocket::PauseMode
namespace qt_gsi
{

static gsi::Enum<QAbstractSocket::PauseMode> decl_QAbstractSocket_PauseMode_Enum ("QtNetwork", "QAbstractSocket_PauseMode",
    gsi::enum_const ("PauseNever", QAbstractSocket::PauseNever, "@brief Enum constant QAbstractSocket::PauseNever") +
    gsi::enum_const ("PauseOnSslErrors", QAbstractSocket::PauseOnSslErrors, "@brief Enum constant QAbstractSocket::PauseOnSslErrors"),
  "@qt\n@brief This class represents the QAbstractSocket::PauseMode enum");

static gsi::QFlagsClass<QAbstractSocket::PauseMode > decl_QAbstractSocket_PauseMode_Enums ("QtNetwork", "QAbstractSocket_QFlags_PauseMode",
  "@qt\n@brief This class represents the QFlags<QAbstractSocket::PauseMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractSocket> inject_QAbstractSocket_PauseMode_Enum_in_parent (decl_QAbstractSocket_PauseMode_Enum.defs ());
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_PauseMode_Enum_as_child (decl_QAbstractSocket_PauseMode_Enum, "PauseMode");
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_PauseMode_Enums_as_child (decl_QAbstractSocket_PauseMode_Enums, "QFlags_PauseMode");

}


//  Implementation of the enum wrapper class for QAbstractSocket::SocketError
namespace qt_gsi
{

static gsi::Enum<QAbstractSocket::SocketError> decl_QAbstractSocket_SocketError_Enum ("QtNetwork", "QAbstractSocket_SocketError",
    gsi::enum_const ("ConnectionRefusedError", QAbstractSocket::ConnectionRefusedError, "@brief Enum constant QAbstractSocket::ConnectionRefusedError") +
    gsi::enum_const ("RemoteHostClosedError", QAbstractSocket::RemoteHostClosedError, "@brief Enum constant QAbstractSocket::RemoteHostClosedError") +
    gsi::enum_const ("HostNotFoundError", QAbstractSocket::HostNotFoundError, "@brief Enum constant QAbstractSocket::HostNotFoundError") +
    gsi::enum_const ("SocketAccessError", QAbstractSocket::SocketAccessError, "@brief Enum constant QAbstractSocket::SocketAccessError") +
    gsi::enum_const ("SocketResourceError", QAbstractSocket::SocketResourceError, "@brief Enum constant QAbstractSocket::SocketResourceError") +
    gsi::enum_const ("SocketTimeoutError", QAbstractSocket::SocketTimeoutError, "@brief Enum constant QAbstractSocket::SocketTimeoutError") +
    gsi::enum_const ("DatagramTooLargeError", QAbstractSocket::DatagramTooLargeError, "@brief Enum constant QAbstractSocket::DatagramTooLargeError") +
    gsi::enum_const ("NetworkError", QAbstractSocket::NetworkError, "@brief Enum constant QAbstractSocket::NetworkError") +
    gsi::enum_const ("AddressInUseError", QAbstractSocket::AddressInUseError, "@brief Enum constant QAbstractSocket::AddressInUseError") +
    gsi::enum_const ("SocketAddressNotAvailableError", QAbstractSocket::SocketAddressNotAvailableError, "@brief Enum constant QAbstractSocket::SocketAddressNotAvailableError") +
    gsi::enum_const ("UnsupportedSocketOperationError", QAbstractSocket::UnsupportedSocketOperationError, "@brief Enum constant QAbstractSocket::UnsupportedSocketOperationError") +
    gsi::enum_const ("UnfinishedSocketOperationError", QAbstractSocket::UnfinishedSocketOperationError, "@brief Enum constant QAbstractSocket::UnfinishedSocketOperationError") +
    gsi::enum_const ("ProxyAuthenticationRequiredError", QAbstractSocket::ProxyAuthenticationRequiredError, "@brief Enum constant QAbstractSocket::ProxyAuthenticationRequiredError") +
    gsi::enum_const ("SslHandshakeFailedError", QAbstractSocket::SslHandshakeFailedError, "@brief Enum constant QAbstractSocket::SslHandshakeFailedError") +
    gsi::enum_const ("ProxyConnectionRefusedError", QAbstractSocket::ProxyConnectionRefusedError, "@brief Enum constant QAbstractSocket::ProxyConnectionRefusedError") +
    gsi::enum_const ("ProxyConnectionClosedError", QAbstractSocket::ProxyConnectionClosedError, "@brief Enum constant QAbstractSocket::ProxyConnectionClosedError") +
    gsi::enum_const ("ProxyConnectionTimeoutError", QAbstractSocket::ProxyConnectionTimeoutError, "@brief Enum constant QAbstractSocket::ProxyConnectionTimeoutError") +
    gsi::enum_const ("ProxyNotFoundError", QAbstractSocket::ProxyNotFoundError, "@brief Enum constant QAbstractSocket::ProxyNotFoundError") +
    gsi::enum_const ("ProxyProtocolError", QAbstractSocket::ProxyProtocolError, "@brief Enum constant QAbstractSocket::ProxyProtocolError") +
    gsi::enum_const ("OperationError", QAbstractSocket::OperationError, "@brief Enum constant QAbstractSocket::OperationError") +
    gsi::enum_const ("SslInternalError", QAbstractSocket::SslInternalError, "@brief Enum constant QAbstractSocket::SslInternalError") +
    gsi::enum_const ("SslInvalidUserDataError", QAbstractSocket::SslInvalidUserDataError, "@brief Enum constant QAbstractSocket::SslInvalidUserDataError") +
    gsi::enum_const ("TemporaryError", QAbstractSocket::TemporaryError, "@brief Enum constant QAbstractSocket::TemporaryError") +
    gsi::enum_const ("UnknownSocketError", QAbstractSocket::UnknownSocketError, "@brief Enum constant QAbstractSocket::UnknownSocketError"),
  "@qt\n@brief This class represents the QAbstractSocket::SocketError enum");

static gsi::QFlagsClass<QAbstractSocket::SocketError > decl_QAbstractSocket_SocketError_Enums ("QtNetwork", "QAbstractSocket_QFlags_SocketError",
  "@qt\n@brief This class represents the QFlags<QAbstractSocket::SocketError> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractSocket> inject_QAbstractSocket_SocketError_Enum_in_parent (decl_QAbstractSocket_SocketError_Enum.defs ());
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_SocketError_Enum_as_child (decl_QAbstractSocket_SocketError_Enum, "SocketError");
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_SocketError_Enums_as_child (decl_QAbstractSocket_SocketError_Enums, "QFlags_SocketError");

}


//  Implementation of the enum wrapper class for QAbstractSocket::SocketOption
namespace qt_gsi
{

static gsi::Enum<QAbstractSocket::SocketOption> decl_QAbstractSocket_SocketOption_Enum ("QtNetwork", "QAbstractSocket_SocketOption",
    gsi::enum_const ("LowDelayOption", QAbstractSocket::LowDelayOption, "@brief Enum constant QAbstractSocket::LowDelayOption") +
    gsi::enum_const ("KeepAliveOption", QAbstractSocket::KeepAliveOption, "@brief Enum constant QAbstractSocket::KeepAliveOption") +
    gsi::enum_const ("MulticastTtlOption", QAbstractSocket::MulticastTtlOption, "@brief Enum constant QAbstractSocket::MulticastTtlOption") +
    gsi::enum_const ("MulticastLoopbackOption", QAbstractSocket::MulticastLoopbackOption, "@brief Enum constant QAbstractSocket::MulticastLoopbackOption") +
    gsi::enum_const ("TypeOfServiceOption", QAbstractSocket::TypeOfServiceOption, "@brief Enum constant QAbstractSocket::TypeOfServiceOption") +
    gsi::enum_const ("SendBufferSizeSocketOption", QAbstractSocket::SendBufferSizeSocketOption, "@brief Enum constant QAbstractSocket::SendBufferSizeSocketOption") +
    gsi::enum_const ("ReceiveBufferSizeSocketOption", QAbstractSocket::ReceiveBufferSizeSocketOption, "@brief Enum constant QAbstractSocket::ReceiveBufferSizeSocketOption") +
    gsi::enum_const ("PathMtuSocketOption", QAbstractSocket::PathMtuSocketOption, "@brief Enum constant QAbstractSocket::PathMtuSocketOption"),
  "@qt\n@brief This class represents the QAbstractSocket::SocketOption enum");

static gsi::QFlagsClass<QAbstractSocket::SocketOption > decl_QAbstractSocket_SocketOption_Enums ("QtNetwork", "QAbstractSocket_QFlags_SocketOption",
  "@qt\n@brief This class represents the QFlags<QAbstractSocket::SocketOption> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractSocket> inject_QAbstractSocket_SocketOption_Enum_in_parent (decl_QAbstractSocket_SocketOption_Enum.defs ());
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_SocketOption_Enum_as_child (decl_QAbstractSocket_SocketOption_Enum, "SocketOption");
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_SocketOption_Enums_as_child (decl_QAbstractSocket_SocketOption_Enums, "QFlags_SocketOption");

}


//  Implementation of the enum wrapper class for QAbstractSocket::SocketState
namespace qt_gsi
{

static gsi::Enum<QAbstractSocket::SocketState> decl_QAbstractSocket_SocketState_Enum ("QtNetwork", "QAbstractSocket_SocketState",
    gsi::enum_const ("UnconnectedState", QAbstractSocket::UnconnectedState, "@brief Enum constant QAbstractSocket::UnconnectedState") +
    gsi::enum_const ("HostLookupState", QAbstractSocket::HostLookupState, "@brief Enum constant QAbstractSocket::HostLookupState") +
    gsi::enum_const ("ConnectingState", QAbstractSocket::ConnectingState, "@brief Enum constant QAbstractSocket::ConnectingState") +
    gsi::enum_const ("ConnectedState", QAbstractSocket::ConnectedState, "@brief Enum constant QAbstractSocket::ConnectedState") +
    gsi::enum_const ("BoundState", QAbstractSocket::BoundState, "@brief Enum constant QAbstractSocket::BoundState") +
    gsi::enum_const ("ListeningState", QAbstractSocket::ListeningState, "@brief Enum constant QAbstractSocket::ListeningState") +
    gsi::enum_const ("ClosingState", QAbstractSocket::ClosingState, "@brief Enum constant QAbstractSocket::ClosingState"),
  "@qt\n@brief This class represents the QAbstractSocket::SocketState enum");

static gsi::QFlagsClass<QAbstractSocket::SocketState > decl_QAbstractSocket_SocketState_Enums ("QtNetwork", "QAbstractSocket_QFlags_SocketState",
  "@qt\n@brief This class represents the QFlags<QAbstractSocket::SocketState> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractSocket> inject_QAbstractSocket_SocketState_Enum_in_parent (decl_QAbstractSocket_SocketState_Enum.defs ());
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_SocketState_Enum_as_child (decl_QAbstractSocket_SocketState_Enum, "SocketState");
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_SocketState_Enums_as_child (decl_QAbstractSocket_SocketState_Enums, "QFlags_SocketState");

}


//  Implementation of the enum wrapper class for QAbstractSocket::SocketType
namespace qt_gsi
{

static gsi::Enum<QAbstractSocket::SocketType> decl_QAbstractSocket_SocketType_Enum ("QtNetwork", "QAbstractSocket_SocketType",
    gsi::enum_const ("TcpSocket", QAbstractSocket::TcpSocket, "@brief Enum constant QAbstractSocket::TcpSocket") +
    gsi::enum_const ("UdpSocket", QAbstractSocket::UdpSocket, "@brief Enum constant QAbstractSocket::UdpSocket") +
    gsi::enum_const ("SctpSocket", QAbstractSocket::SctpSocket, "@brief Enum constant QAbstractSocket::SctpSocket") +
    gsi::enum_const ("UnknownSocketType", QAbstractSocket::UnknownSocketType, "@brief Enum constant QAbstractSocket::UnknownSocketType"),
  "@qt\n@brief This class represents the QAbstractSocket::SocketType enum");

static gsi::QFlagsClass<QAbstractSocket::SocketType > decl_QAbstractSocket_SocketType_Enums ("QtNetwork", "QAbstractSocket_QFlags_SocketType",
  "@qt\n@brief This class represents the QFlags<QAbstractSocket::SocketType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractSocket> inject_QAbstractSocket_SocketType_Enum_in_parent (decl_QAbstractSocket_SocketType_Enum.defs ());
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_SocketType_Enum_as_child (decl_QAbstractSocket_SocketType_Enum, "SocketType");
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_SocketType_Enums_as_child (decl_QAbstractSocket_SocketType_Enums, "QFlags_SocketType");

}

