# Implemented by Duncan Hanson
import six
import os
import numpy as np
from copy import deepcopy
from itertools import chain

import unittest

import healpy as hp

import warnings

# disable new order warnings in tests
warnings.filterwarnings("ignore")

nside_precomputed = 4
lmax_precomputed = 8

galm = np.array(
    [
        -0.60749536999999998 + 0j,
        0.83559932999999997 + 0j,
        -1.0174608599999999 + 0j,
        1.0993299999999999 + 0j,
        -1.0415247299999999 + 0j,
        0.98637741999999995 + 0j,
        -1.2327712799999999 + 0j,
        -0.65081703999999996 + 0j,
        -1.1239971900000001 + 0j,
        0.96501168000000004 - 2.3554313900000001j,
        -0.40474513000000001 - 0.65564383000000004j,
        0.15638859999999999 - 0.23621884000000001j,
        0.28043983 - 0.39658116999999998j,
        -0.26163387999999999 - 0.077809699999999996j,
        0.20287720000000001 - 0.06082216j,
        0.052013629999999998 + 0.073047849999999998j,
        0.68909047999999995 + 0.65423257999999995j,
        0.48747127000000001 + 0.30760153000000001j,
        -0.35432469999999999 - 1.0799235300000001j,
        0.43819587999999998 - 0.22769086999999999j,
        -0.57252002000000002 - 0.13502544j,
        0.63900029000000003 - 0.59585710000000003j,
        -1.16030893 - 0.25760955000000002j,
        0.37504869000000002 + 0.058102309999999997j,
        -0.98924601000000001 - 0.46924109000000003j,
        0.71031016000000002 - 0.90896836000000003j,
        -0.43448922000000001 - 0.12677451000000001j,
        -0.77544904000000003 - 0.25176252999999998j,
        -0.01721661 - 0.94948701000000002j,
        0.85474141000000003 - 0.051103330000000002j,
        -0.60520565999999998 + 0.87760647999999997j,
        -0.77864944000000003 - 0.79208626999999998j,
        -1.08657508 - 0.59487055j,
        0.21367211 - 1.5110769900000001j,
        -0.16784056999999999 + 0.80020639000000005j,
        -1.1339041000000001 - 0.32197503999999999j,
        0.19618954 + 1.08100252j,
        0.43866369 - 0.47475267999999998j,
        0.11857266 - 0.049022839999999998j,
        -0.40366523999999998 + 0.85542658000000005j,
        0.56154870999999995 - 0.77527478999999999j,
        0.48146275999999999 + 0.16245443000000001j,
        -0.68355484 - 0.22983015000000001j,
        -0.061040659999999997 - 0.13420304999999999j,
        0.27255975999999998 - 0.75328077999999998j,
    ]
)

calm = np.array(
    [
        1.0718601933803977 + 0j,
        -1.5182685950801673 + 0j,
        -0.39119975933464429 + 0j,
        -0.6620552667513403 + 0j,
        0.42674481653281382 + 0j,
        1.3799470126677567 + 0j,
        -1.4604721504544589 + 0j,
        -1.1136471151307403 + 0j,
        -1.647392955477013 + 0j,
        0.71919252212426499 - 0.39773236587790972j,
        1.1884542365155342 - 0.02640806030381616j,
        -0.040937417189905477 + 0.41096619318378996j,
        0.19575829981467366 - 0.9285256561788201j,
        -0.81538492817093389 - 0.35929021939020905j,
        0.46870617235542178 - 0.16617809319149193j,
        0.23640105395174835 + 0.20199283448907013j,
        -0.4326244206185022 - 0.59306323217984414j,
        0.70410703555897491 + 1.1105121855564981j,
        -0.25795284664102419 - 1.2596368643912992j,
        -0.32298608901330822 + 0.28961247423501457j,
        0.86075337105780647 + 0.11654277740017273j,
        0.61549312276703594 - 0.10703912813862339j,
        0.18586512296424443 - 0.19025963131317278j,
        -1.0133508690870945 + 0.37723661046981605j,
        0.81779407406185822 + 0.079623471577802724j,
        -0.36878503033040533 - 0.2898255702618146j,
        -0.13864500443953851 + 0.99443154731355876j,
        -0.18473645501235322 - 0.27320195658100321j,
        -0.59576170002379292 + 0.82900875927708351j,
        -0.42589567337148737 - 0.4359073358803493j,
        -1.0071527860797036 + 0.94936616398900131j,
        0.52681818118587864 - 0.14360294581437408j,
        0.92619570387111039 + 0.051664002362596051j,
        0.75431992804310644 - 0.25779974392362176j,
        -0.89919787406938079 + 0.4989749264182417j,
        0.50889483979981087 + 0.80485052548180069j,
        1.0832061738848424 - 0.70024088919678606j,
        -0.81326057995656997 + 1.0871815291974078j,
        0.66115253781072936 - 1.1579428341478799j,
        -0.25669790905903495 + 0.031910894413264487j,
        -0.055840352620168392 - 0.27126620265309953j,
        0.77754873311978667 + 0.1677199540737199j,
        -0.2428367232543345 + 0.058222152917874435j,
        -0.35655343174399751 + 0.28585938716743436j,
        0.44494756551095588 + 0.17931771534010477j,
    ]
)

maps = {
    1: np.array(
        [
            1.1743580943750218 + 1.0162508812596662j,
            -1.7545991014514022 + 3.9632546003544267j,
            3.4755301242047865 + 3.6205268666848651j,
            3.463772051893852 - 0.16092758895196169j,
            1.6137200258556599 + 0.73266613851658846j,
            -0.78408695644456827 - 0.017688408927465843j,
            -3.2331912918298711 + 1.0423682626399753j,
            -2.4967573102249689 + 5.4249205744223872j,
            1.9618186881421982 + 4.9309708160236383j,
            3.0923993499620077 - 0.4894899405424642j,
            3.8802145016214444 - 1.7023962410322717j,
            1.6609384663419748 - 1.907262230594307j,
            0.48237984905359593 - 1.7832620041462326j,
            -0.91903915540372738 - 1.4797023464820716j,
            -3.3079615434500242 - 0.87195141293021572j,
            -3.2711896733834713 + 0.12177676469629328j,
            -1.4919533733781134 - 1.6435471612444656j,
            -2.6523233433871019 + 4.2474564187420576j,
            0.91780925153179838 + 4.9570523962893001j,
            0.42584487195441895 - 1.8426545772598648j,
            0.23225332448920533 - 3.4181823103655073j,
            1.4984860851219615 - 0.98863554278420129j,
            -0.35246834799111726 - 3.3771616282380563j,
            -1.5062845496910013 - 3.4935340751923691j,
            0.13099914430749093 - 2.0149335831137503j,
            -0.99476127813711768 - 1.9875208527665134j,
            -1.1508757672399341 - 1.1170925992609697j,
            -2.2800860488149857 + 2.5337276570280665j,
            -2.0227144551955485 + 4.4062547882406582j,
            0.85159759341389984 - 0.25969432494507549j,
            0.10617879436802691 - 1.4704556654073533j,
            -0.74056700667340003 + 3.9958069996884769j,
            1.8376229758120008 + 4.8939057972543516j,
            0.56097592637522953 + 1.1962336897882726j,
            -1.3522314207704584 - 2.3788885700721187j,
            -0.3910200060975908 - 2.0276298492296441j,
            1.1696744495267888 + 2.4194144879695001j,
            0.61111633566009804 + 1.9810226991014681j,
            -1.2570081724109712 - 2.4256572995991448j,
            -2.0379607424382673 - 2.3401230961329462j,
            -0.11895117415507916 - 0.20168228572033531j,
            -1.1721585258230467 - 0.40434726332170645j,
            -0.87007913988881902 + 1.0470079216653014j,
            1.0632956396927513 + 0.86183414835909822j,
            -0.38580133850999232 + 4.9648768523408924j,
            -1.1378511659644674 + 3.5600642062343684j,
            0.059277285920489975 + 2.2071682852740224j,
            0.32981878804494424 + 2.0708756974471436j,
            1.5954797850952303 + 3.9506597955061187j,
            1.113967802900363 + 3.8105501539801976j,
            -0.34187488675854677 + 3.0267213287624557j,
            0.18662232048160876 - 1.2571845658067642j,
            2.7139610044225382 + 0.69222466212540557j,
            1.4373026138501541 + 3.902110493851922j,
            2.3082293966444007 + 2.2987716217551775j,
            1.3462006391244148 - 0.10182718246119304j,
            -1.0329879104957191 - 1.0590332100623074j,
            -3.0810859363267094 + 3.1945037345098988j,
            0.77362743359084163 + 0.84013578687826662j,
            1.0464890345883808 - 0.72771732260634059j,
            -0.51744859070890492 - 0.81451970371406568j,
            -2.9428700854575434 + 2.762899585992368j,
            -0.40115243174986093 + 3.8372871200581486j,
            0.96128270685925343 + 0.93840717545663799j,
            0.41639434446527768 + 2.5331280325752732j,
            -0.519386987039123 + 4.2723375559049348j,
            0.52495944959322849 + 0.8116227621810026j,
            2.5244086242304857 - 1.89004339281529j,
            2.0195410343451292 + 0.21295550110166039j,
            -1.8684314756711684 + 2.3019863570099734j,
            4.0113534030248825 + 2.4322957453578007j,
            2.5067778456719454 + 1.3635087014727825j,
            1.8581737323759087 - 1.1755871365622586j,
            -3.278606394868425 - 0.74168306105753778j,
            -1.6581650987018286 + 3.4206773381711715j,
            -0.20328962742120149 - 2.6517323129301227j,
            0.11939427685928439 - 3.914762222637826j,
            -1.1719762486786653 - 3.6258016903482262j,
            -1.9695972814337694 + 4.7844819781500254j,
            0.70410051090004111 - 0.63082142973243238j,
            0.58203862242748194 + 0.17092305557744025j,
            -1.0446335319978968 + 2.2194447533251744j,
            0.15655310887242035 + 0.86561734274560376j,
            0.31563746550827387 - 2.9298241668860747j,
            2.7860378031530235 - 1.0136028592766184j,
            -4.3782229028819648 - 0.33971568537612828j,
            -3.0909568032763324 + 2.5513031796814909j,
            4.6737413708938655 + 2.7302786045020038j,
            0.13272621959023939 - 4.1711765732663011j,
            -2.2749762169482466 + 0.25421841905327258j,
            -0.50489760751634882 - 0.91377903881434097j,
            -2.287069616277897 - 1.0631181589973533j,
            0.7972895323203042 - 3.4207848305117969j,
            -0.23326908605637886 + 1.089382332171946j,
            0.0098601007056405704 + 1.4586475390991032j,
            1.0365833871785477 - 2.4620420564717742j,
            0.36572720828156252 + 1.6541853704371952j,
            -0.51430469009147317 - 0.049252228418473765j,
            -0.62145289699741391 - 3.375619986564951j,
            0.35466808756859192 - 1.3690595024956109j,
            -0.25322914773962185 + 0.32316646758647627j,
            -7.4892488525844554 + 1.1525104561324868j,
            -0.12392585470999483 + 2.4297661937947765j,
            4.2905861596881323 + 0.67018882572843463j,
            2.3390789232929543 - 2.3191321695784399j,
            -0.44619718489570181 - 3.8333096552555777j,
            0.51352876521471524 - 1.6804333968219132j,
            -1.7025201697344337 - 0.1008347592396226j,
            -1.477972480809314 + 4.2322266421353856j,
            1.399058406997034 + 0.63203496833525186j,
            -0.039998736140595348 + 3.1534667411092578j,
            0.001699954715300489 - 1.6894128318777268j,
            1.8608282629517956 + 0.54462233467286736j,
            0.022347730866276339 + 0.94097808664808924j,
            -0.97565390581191991 - 2.0043597662134327j,
            -0.85205216583024623 - 2.2679689843892588j,
            0.53947735206622338 + 0.92108210028888182j,
            -2.5670596443819931 + 0.38871863049383093j,
            -2.934869851153608 + 1.2511147622702086j,
            2.0825683383127727 + 0.45929928305134715j,
            0.37898448820629005 - 2.6841486733486013j,
            1.0120152854590612 - 1.6425972444002646j,
            0.7776935701538118 - 1.952106003854329j,
            -1.2780368759454575 + 4.6651596443819408j,
            -0.039206971051687134 + 5.265018964377389j,
            -0.54489461163081254 + 2.8671152905341284j,
            -1.636083304638287 + 1.8615197052158607j,
            1.4325345827348386 - 0.58443769148648628j,
            1.8893019352323406 + 0.93513602825308595j,
            -2.139093319814994 + 0.49456047669865844j,
            0.033273312452318238 - 0.67524051231226145j,
            0.0018165800924796471 + 0.24539790830842012j,
            -1.830677860003034 - 0.88907276825821402j,
            0.23881421516801424 - 0.71660110558242596j,
            1.4607757935805321 - 0.20332350008812516j,
            0.31479988117869262 - 1.4797543881405799j,
            -1.4700646395419654 - 2.3412000314939014j,
            1.3630043099840954 + 1.0459288308034624j,
            1.0366509002025306 + 1.4017065365354837j,
            0.5324643362883491 - 0.19564285336892207j,
            0.86203010112261591 + 3.8589883704164376j,
            -1.4871335108899939 + 3.2965305219683243j,
            -3.506476212648844 + 3.1925528967103802j,
            0.15264175448604056 + 0.431490908418659j,
            4.2777064175487407 - 1.2512757866202306j,
            -1.1870189698038707 + 0.75501344481612265j,
            -1.839602146399741 + 1.4963403982128953j,
            2.3099273465758903 + 1.2697775493766699j,
            -4.3475497187867314 - 0.32036886085994221j,
            -3.3064040751562334 - 2.9625087732893531j,
            3.6141886575697248 - 0.0099341031074851038j,
            0.0048861040277541345 - 0.6295182389123023j,
            1.5000073794953357 - 0.88609288760098115j,
            2.2323719937100908 + 5.4902541505729845j,
            -0.2585807286071018 + 2.5584952206368938j,
            1.7769833707262548 - 0.3408851516775957j,
            0.37978034270511074 + 2.9026249163611726j,
            -4.6921406543266571 + 4.3678134780358526j,
            -2.4462636775404958 + 1.4523419567722944j,
            5.2941943690732423 - 2.6008774047519228j,
            3.4595406699843201 - 0.99129783569826058j,
            -3.4841770617209473 + 1.2717869796731138j,
            0.13850539692866526 + 0.94282786052434553j,
            -2.1789230651774014 + 1.6415064719591206j,
            -8.811149558407779 - 0.86858984219214674j,
            -0.98048863671795994 + 0.035234022992954195j,
            2.3501190627193562 + 2.7317457688466678j,
            -1.5421024919985193 - 1.7186736892960668j,
            2.139635096504529 - 1.8367715460959313j,
            0.41669207038592981 + 3.3753865855933527j,
            0.42812877807536154 + 0.88267208286037602j,
            -1.6620756081654045 + 5.368686741364268j,
            -5.4496694415397027 + 3.4393514966821126j,
            3.2274980963579551 - 2.6154731433818244j,
            1.2325162367548854 + 0.25900311819665534j,
            -4.9927575224429273 - 0.77655205094166613j,
            -3.9137002256716968 - 0.87208435187132305j,
            -5.8396208197376538 - 0.033400550471304857j,
            0.88165596824067283 + 3.3402495465420188j,
            -0.77813555128307499 - 0.49824566884112964j,
            -1.2569589183195746 - 3.992299237539171j,
            -0.55073556348169195 - 0.99367233232065755j,
            -3.1361715966867241 + 3.8990411125610152j,
            -1.2479889140797951 - 0.86728888508048596j,
            -3.438346192247995 + 0.75427470765301274j,
            -5.8362598289444767 - 3.7106623335656881j,
            -1.6220739622888261 - 0.85412380326550341j,
            -2.3618246988425389 + 0.10262957279861007j,
            -2.0128151752491599 - 5.2483459258638678j,
            -0.28798741542347162 + 0.082139772535972211j,
            -4.4336542047160892 - 0.12984758528642848j,
            -3.0452434904226706 - 0.34940617145697844j,
        ]
    ),
    2: np.array(
        [
            -1.1165046042602529 + 0.74756586618731813j,
            2.9563864696268687 + 1.016510598068517j,
            -1.7273931284275377 + 1.684970250530498j,
            2.1374510755011236 + 1.3953489111135389j,
            1.264058043394483 + 1.0656402139582337j,
            0.59206130659344847 + 2.8140992156732278j,
            0.062093775185857902 + 2.0904994744842891j,
            2.9429778836437221 + 1.7128991560692999j,
            -2.6110141508418021 + 1.1140285432863466j,
            2.326165567157239 + 3.2728054144888676j,
            2.6626908823784907 + 0.52728366204875832j,
            3.5908021600075641 + 0.96903781804179978j,
            0.90571149765085535 + 0.24081124592692693j,
            0.72871814828353709 + 1.332418563783788j,
            0.60164374752130945 + 0.15445148430884423j,
            -2.5529506354313782 - 2.3304064585375239j,
            -1.8879418959660019 + 2.682343033625215j,
            2.1668168490952775 + 1.4157064593061692j,
            -3.1636708644108649 + 0.64742953025658889j,
            -1.4210029334653473 + 2.6334896788286049j,
            3.6902066347461573 + 0.13892873924238483j,
            2.9575090399303945 - 2.6325502244852719j,
            0.17878513667675777 - 1.1585078531329858j,
            2.1237001808101663 - 1.323323837586023j,
            -0.16120044138369383 - 1.2121424743269673j,
            0.8624452370473753 - 1.0686957121793859j,
            -0.51467053641764826 - 1.1945130365136154j,
            -0.18418165278174148 - 0.59116856193750777j,
            -2.6169185838042068 - 2.4146314558175046j,
            -2.7622714373457917 - 2.3797351683439834j,
            0.073910048482292545 + 0.16496145279596552j,
            0.80910813851825103 + 0.56242050573198998j,
            -1.9584133243280075 + 1.0892351163388432j,
            -2.1814162287477559 + 0.61054532617299695j,
            -1.5169577705416253 - 1.0235623545618981j,
            1.9895718538585976 - 1.8211523939205545j,
            2.4118671091811361 - 1.9453281674321252j,
            -1.3835825480021706 - 2.94255319882138j,
            -3.3831677322689044 - 2.4580709837790149j,
            -1.0643850899431524 - 2.7522668625312905j,
            -1.9640650365404291 - 0.35711187195874783j,
            2.0439239983559903 - 0.31240155157933036j,
            -0.22521863704724376 - 3.4584160218021305j,
            -0.51534527570261424 + 1.0301056642659554j,
            -0.81562474322987222 + 3.7503264056978267j,
            -0.060726807609905009 + 1.8031960877879551j,
            0.86667213746967398 - 2.9028917378472125j,
            -0.15387539712023934 + 0.13908261984620263j,
            0.45953137238099684 + 2.2626118142274105j,
            0.62744200989512788 + 1.9272207054022881j,
            -2.3255110017526608 - 0.53695630414710283j,
            -1.5190658716876777 - 0.9208472578106438j,
            2.137223495429847 + 0.68320323689351148j,
            3.1584401529074442 + 1.7321545691722557j,
            -1.1125695286320998 - 3.2076280088399511j,
            -3.7060965836044932 - 1.9780143459066473j,
            -0.0012842332451774574 + 3.2452953615132838j,
            2.2855371052053712 - 1.1752563745986131j,
            -1.7649471509112493 - 0.88061905568140997j,
            0.75495292840738937 + 3.6278072525475187j,
            -0.49646600004863894 + 5.9486839669421894j,
            2.9426274856719101 + 1.0146400853383064j,
            -1.5434946162364205 - 1.1288427968038663j,
            0.1004948003661843 + 2.7446408233087585j,
            1.6891184209589296 + 3.1297213004998374j,
            -0.05236089581184955 + 1.9379909861717084j,
            -2.5137867334898658 + 1.4249473105986246j,
            1.649739972413804 - 0.1284157001992281j,
            3.8737660306719093 + 4.4058712012072778j,
            5.5734334582390925 - 0.01859570677500616j,
            0.034418186067761702 - 3.7863468040480583j,
            -3.6185785482837716 + 0.87492996512854082j,
            -3.523709866409459 + 3.8351231556344709j,
            1.9035220821258987 + 3.5762696257910473j,
            -1.3355317211315365 - 0.12437729138156417j,
            0.27233720824024044 + 0.62568960888382408j,
            -0.087131156071871274 - 0.010324624464344678j,
            1.4827889367880731 + 2.2703868481775364j,
            -0.27368753287508718 - 0.23035237674465425j,
            -2.3786689738351767 + 1.4567486754553038j,
            1.4386131990647175 + 2.4034598349374283j,
            0.066680160631143237 + 2.7232295144266274j,
            -1.666407419777012 + 2.9083944127863561j,
            1.3023780882542342 + 0.52194039596842601j,
            3.3146056296510493 + 0.66745607226026649j,
            4.2456604060579677 + 3.8969561221755749j,
            4.1998262021248625 - 4.0793461167911262j,
            -0.76421358406766027 - 1.2315027885578802j,
            -1.5357398471693586 + 3.7748327293868642j,
            0.095984948174640872 + 2.2104973139657291j,
            -1.4588631998320354 + 1.134201407450617j,
            1.6387745345036606 - 3.8466513697644413j,
            -0.73057877816794492 - 4.655134203127945j,
            1.6085189126683648 - 0.21988000108022218j,
            -3.1142178896816564 + 0.091923489293964877j,
            0.62820278401392149 + 0.1889975872022136j,
            -0.16120633228908154 + 1.9707163592075072j,
            -1.235116936758984 + 2.1482450245585314j,
            -0.021985008426573249 + 1.1038279261596868j,
            3.6413478144793245 - 1.5615567405467394j,
            1.836327464800555 + 2.8541227399557041j,
            0.93919940461177709 + 0.14620058990910742j,
            0.95456236801488359 - 3.2026192357315972j,
            -1.7481075885435755 + 1.6730186360367643j,
            -0.84626775726936276 + 1.6575377579793631j,
            -0.26164286832258099 + 0.76088427278556803j,
            -1.2966015229936554 + 0.97676041471092478j,
            1.6124370820759013 - 0.58585228456899752j,
            -0.21994376085816314 - 6.2532282013448075j,
            0.8353593803854652 - 3.6420691105508212j,
            -0.03824087822866562 - 0.054729642257138833j,
            -1.3319497354973748 - 2.0327095379389153j,
            0.75662881948485083 + 0.30541845281794644j,
            -0.76757214187579981 + 2.2787455111432591j,
            -0.455100077730823 - 0.55830706795474327j,
            1.3313718654711193 - 1.5460827721627417j,
            2.9912065916181261 + 0.77182516673656876j,
            -0.52278090407902422 + 2.7877639036769803j,
            -2.3528997632544266 - 1.2308866273244197j,
            0.27817666198979296 + 0.059213451422733376j,
            0.45875812556331846 - 1.2692467729246268j,
            -0.45874375601474504 - 2.3686526493885238j,
            0.479232709947924 - 0.3060902759460391j,
            1.4895902195529662 - 0.41735115244048793j,
            -0.85025677044974457 - 2.3693856367193904j,
            2.0718452260590321 - 0.54927604975188671j,
            -1.176356516666446 - 1.9392922793319025j,
            -0.79423474673281291 - 2.1390403821586896j,
            0.25372445079390721 + 3.1629513441654384j,
            0.54044572189189222 + 0.18770434833000893j,
            -0.32776474396893496 - 2.9986158756129355j,
            1.8555964580559503 + 0.64523330354515551j,
            2.6163923211891467 + 2.0073816231373094j,
            -0.96827837897054836 - 0.20669532105285635j,
            -1.6161700297890988 + 0.058760459668895204j,
            1.0388341083117685 + 1.0343083372958142j,
            0.8171690777526357 - 1.0241901711901955j,
            1.161178491272123 - 3.3193021589202116j,
            -0.65705952284124769 - 2.909740964518341j,
            1.0464027137937968 - 0.28516514967891382j,
            0.31407614249026861 + 2.0789914726795806j,
            0.89249898217038592 + 0.74504430864132187j,
            0.46653627607511738 - 1.2535459455441251j,
            -2.8759949933021893 - 3.4253168189020871j,
            -0.55004579155281808 + 1.4416964251162601j,
            1.3842770119914176 + 3.7499085234789105j,
            0.73300538480603206 - 2.3651197461061306j,
            1.2610841999098341 - 0.04478569409858002j,
            2.2663256193995895 + 2.6893001805232006j,
            3.2282105473513854 - 3.089294872359758j,
            1.0246687806608903 - 2.1329916398440454j,
            -0.79719171443068326 + 1.1114942772440388j,
            2.3820851781718693 - 1.9138147704390083j,
            1.478151603469551 + 0.15364879065364989j,
            -1.5233345516736922 - 1.3099212472909443j,
            1.5072515797375459 - 0.57475142166442117j,
            2.1228188430644579 + 2.0096979974944369j,
            0.16349467160657194 - 0.13019412026157573j,
            -2.8501863703427208 - 4.0570052570082602j,
            -1.0157135917807159 - 2.6825682466889411j,
            2.3253206740804364 + 4.1263405715172157j,
            1.5487387410680176 + 2.2318083306172714j,
            3.3480777012584348 - 0.30034799964836079j,
            2.7011245606581289 + 4.7335734563336729j,
            0.57254668180230106 - 1.6139253460404996j,
            3.903853955673366 - 6.6991967093618143j,
            0.64492682991521111 - 0.31017629667123225j,
            -2.1607929176337426 - 0.16857297635682733j,
            4.8098868433499913 + 0.41785061609925878j,
            1.1564314939094591 + 4.3710892388226963j,
            1.8224691599081939 - 0.63910766786442408j,
            2.6435565518448572 + 2.9094520705913056j,
            -3.7780259549880189 - 2.1074067076770948j,
            1.5393672791948894 - 5.2619312349734786j,
            4.5356550511622213 + 4.2698512297085127j,
            2.3969803974124391 + 1.9571123112588573j,
            3.6061144615068086 + 4.3736176949628423j,
            -0.39324476338149617 - 1.9082883633012435j,
            3.026448300108715 - 1.7428825416966158j,
            -1.9045802882682787 + 0.4426906193634812j,
            5.0241978704119958 + 1.9445871037916549j,
            2.6831636546598459 + 3.0839149450548007j,
            -1.4019967581265769 + 5.0027949271902887j,
            -0.0031667657498008206 - 5.3402188332400726j,
            2.9517714615379806 + 4.0246422636276797j,
            1.4785600380549067 + 0.51660087996842741j,
            2.7856553478477579 - 0.88532969501753778j,
            0.2673738444085586 + 2.2859423305476705j,
            2.7550882281445315 + 0.58476661154179221j,
            -3.2828096156515181 + 0.45102580026710948j,
            -1.8220345108884464 - 0.00054247733982548674j,
            3.2007680062608741 + 2.4615774393552337j,
        ]
    ),
    3: np.array(
        [
            -0.66999593287202142 + 0.46243708757420809j,
            0.82115988275196528 - 1.6643038327885704j,
            0.67399713542071471 - 2.3955600817810208j,
            2.215439913637927 + 0.72446638537859487j,
            0.93108120226407332 + 0.064033670430578393j,
            -0.92739574739897401 + 2.2493044552029375j,
            4.0678984753394341 + 3.2507085430096483j,
            -1.3168389222564625 - 0.80923697224245794j,
            2.4067925151982705 + 0.92813675598570766j,
            -2.0493109031701429 - 0.49108376461287684j,
            1.6349441369388815 + 4.1340925667887625j,
            2.5312429669372829 + 0.44393295017157475j,
            2.2198800992090253 - 0.20688768772829413j,
            -0.053776255855561117 + 2.1684193251401833j,
            -0.74507569207418511 + 2.0534600226420934j,
            1.0590676473818048 + 3.4665027379637494j,
            2.5831500212178433 + 0.10767106535418591j,
            -0.81172453742230211 + 1.5135115252098388j,
            0.51675313192529826 + 1.7364523664094207j,
            0.017777040747489425 + 0.33054862825595765j,
            -0.031923375391498365 - 0.03647474837162834j,
            0.75627328628012946 + 2.5870613579433228j,
            4.0854570875479279 + 2.1694354582233544j,
            3.5281541314540927 + 0.20192676958354183j,
            1.2898229939329962 - 2.8439309558484345j,
            -1.4676716747053 + 1.2550839973056764j,
            1.4660283077695149 + 1.250015105410669j,
            -0.24960947184476789 - 1.274656996015006j,
            -2.105841001070178 - 2.0766118645037839j,
            -2.4893754811904127 - 0.40574540171916373j,
            1.1819182474823142 + 1.2543311034554072j,
            0.66112124774937775 + 0.73421234301293936j,
            -1.5435321344721677 + 0.2405604201908027j,
            -2.5174124636556181 + 1.1618925572216374j,
            0.69011465007947015 - 0.52483143713649749j,
            1.5464610264677234 - 2.6451243970838227j,
            -0.097592832333731394 - 2.1470448648923481j,
            -1.7790027249170768 + 1.4929022997757122j,
            2.1060693685955689 + 0.72313993979877744j,
            3.1638994698726481 - 2.1269139943415407j,
            2.2107279234732862 - 5.0404555730899059j,
            -2.5209363703464924 - 3.302312046473193j,
            0.12059012761921761 + 1.3587818158227796j,
            1.8826126043065536 - 1.5865310833153738j,
            -0.57070268838796012 - 1.585154256627491j,
            -4.7784601734110614 - 3.8493106222543396j,
            -1.4421251579517258 + 0.98946495072189533j,
            3.1612898053286718 - 0.44422399561859394j,
            -0.27830641044372373 - 0.94412748500393695j,
            -2.6942690780226708 + 0.22023121586779437j,
            -1.2938276668529529 - 0.06583465169229219j,
            -0.18392187376248736 - 3.6374010616991139j,
            1.3907294398416794 - 3.5152092057270137j,
            -4.2456806268120735 - 2.3371824677843467j,
            -4.5174367628342278 + 3.0159027596758059j,
            1.4569480295154498 - 0.40481687203522998j,
            0.24452064515296237 - 5.5529329980953808j,
            -2.1273220239180053 - 0.73593942867713091j,
            1.595151423023013 - 1.1401776866728879j,
            0.15780690321442792 + 2.2661324101587246j,
            -0.74933288055404634 + 1.3749431486856962j,
            -3.0816809779382717 + 0.23742643682485964j,
            2.8994367119049036 + 0.7396921744800089j,
            1.4994335029613002 - 1.2798108792722671j,
            -0.16539584890629019 + 0.48010791918853934j,
            -0.89194363806978616 + 0.7170467910739301j,
            -2.1293682627235322 - 2.5845385071231268j,
            -0.63427315935121464 - 2.1595594356167398j,
            0.99308347169563682 - 1.8514493405763055j,
            -5.4450584092937877 + 0.97902894760670878j,
            -1.0604698602513214 + 3.2312043227524949j,
            2.3124452902496664 - 1.3950895449462946j,
            1.3201823408003734 - 1.6028209931750983j,
            -0.87616516312961035 - 2.1465631953543003j,
            -0.34056443490530253 - 0.35013249591511048j,
            -1.2364508408450898 + 0.13781313196431211j,
            0.038609534515580135 + 6.8698762949471899j,
            0.12380533905802339 + 2.7921341862952316j,
            0.54660167417157157 + 2.7346629269827281j,
            1.6952037866074647 - 0.33387389764274045j,
            0.94628165540958409 + 1.2037205024287594j,
            0.68176721298456666 + 1.3320274860427599j,
            -1.497001928100073 + 0.16859140871709216j,
            -2.9208164653643847 - 2.013262526262011j,
            2.23493624166204 + 0.38888195090814426j,
            0.083266882937527834 + 0.042519190431531406j,
            -0.81622472526299195 + 1.602983850729655j,
            1.9107865697855551 + 1.8860940491210119j,
            -0.5161686146069725 + 0.1067286365498733j,
            -0.56830015109909349 + 1.5080358150275226j,
            -1.9977061163459469 - 1.2634518707513132j,
            -2.7762791817204802 + 2.8410553962536476j,
            1.5348104323655993 + 3.8209466359027746j,
            1.0447821110316866 + 2.8953941140696262j,
            -0.16156969418429323 + 2.1568137355441648j,
            1.1423882118876016 + 0.80959057152946856j,
            1.2184203681166248 + 1.6431143641185439j,
            -1.3333936354073923 + 1.3051448172275528j,
            -2.2003497621202652 + 0.034485634672569598j,
            0.48305931966908489 - 1.0059947680083925j,
            2.4240719735430218 + 1.520434513132964j,
            0.14152780483805999 + 0.38291838819136248j,
            2.6247680254133194 - 0.34273750279620985j,
            0.5170632044924367 + 1.5591723010537319j,
            -1.964084322524609 + 2.2043273581641452j,
            -1.1123693520916111 + 2.9076285022885537j,
            -1.0205304639064758 + 1.726462948906172j,
            -3.0513199493069254 - 1.3262259566094576j,
            -1.1782640915309317 - 0.13290415044827952j,
            2.2282976599379309 - 0.72321887567511034j,
            -0.60179533239909233 + 3.307433985055094j,
            0.16788252783154045 + 1.0362178538533637j,
            2.6706953553371453 + 0.77074105928608427j,
            -1.8533672105796244 + 0.35596405935487074j,
            -2.6147380869392443 + 1.6093046768585832j,
            0.37759170296150524 - 1.5083149569782319j,
            1.8716643004532001 - 0.35801239552465747j,
            -1.1450981234973723 + 3.042261086804297j,
            0.44452106639608746 - 0.69350503725695845j,
            1.4879090143200902 - 0.64776217405327741j,
            -2.8205775502795389 + 2.641687352135917j,
            -0.93692044263706187 + 3.0048923877610507j,
            -0.426546964943878 + 0.013344667316707221j,
            -1.4443525828613666 - 1.7131214807111499j,
            -0.14354399201917334 - 4.0206831461274337j,
            0.83443104253838163 + 0.29432217858366894j,
            -0.93252862665525393 + 2.9364673343460126j,
            3.4431983705905731 - 0.3251990454994399j,
            0.43806792303059483 - 0.70784096193188306j,
            -4.4119004072708137 + 0.24052114921567447j,
            -0.98891595175430935 - 0.46079086925838275j,
            1.7417334974194558 - 2.9208658301095776j,
            -1.5454462711687187 + 2.5296917145427482j,
            -3.3282492610480996 + 4.156447539050224j,
            0.40902409375307852 - 0.76847358054292236j,
            -0.56330685439900319 + 0.69661436668049836j,
            -1.8762485869816681 + 0.64778551016479047j,
            -2.4393425483279865 + 0.85171074321319784j,
            -0.209819964163376 + 0.099157970328755729j,
            1.2392961839922023 - 0.64639270138790006j,
            -1.1641752459378989 - 1.4971678104463564j,
            -0.56703471832581931 - 2.1716088946899359j,
            -0.16437097090423169 + 3.1220884585750146j,
            1.3539163377460306 + 1.1869107505913261j,
            2.9491476787185125 - 1.2808347797003192j,
            -3.2908684053012207 - 0.88608324309025921j,
            -4.1007674458331485 - 1.4527729940313197j,
            0.44035311401335531 - 3.1365712871936395j,
            -1.0141686129277752 - 0.63568191152634734j,
            -3.4102891864012639 + 4.2247127971259122j,
            -1.1836594760112424 + 3.781939963215049j,
            0.51422023588565446 + 0.57579154063617177j,
            -2.0246664119505891 - 2.237040145119146j,
            -2.2053210495403732 - 1.3846005574579319j,
            -1.1160865960532751 - 2.5475738207830227j,
            0.50275220925239728 - 1.2519481985598606j,
            -1.2100185502945444 - 0.16812837098982908j,
            -0.59983421887255994 + 1.6027230741262604j,
            -0.52478938635633754 + 2.458183305060198j,
            1.5028757257080834 - 0.72420113128118369j,
            -0.31146843994891138 - 0.27135667939274499j,
            -5.1133106827158112 - 1.8113241566448617j,
            -1.5548284863229618 - 4.0468311536026844j,
            -0.73513228831134692 - 0.50030377688003924j,
            -4.1474633033600306 + 0.067247755883021731j,
            0.21758777097351378 + 1.278485302383952j,
            1.2889426032473679 + 3.3676304645801252j,
            -1.6413393543174832 - 0.091092522462874137j,
            -0.40598559211980501 - 3.5363616320930467j,
            -4.4770433756596688 - 1.0937535548777739j,
            -1.2734316477554803 - 5.4194063797821297j,
            0.97449379705901817 + 0.49671560815912308j,
            -2.4145658013036444 + 1.063978254382109j,
            0.99809956584583803 - 2.5020372804114697j,
            -0.12266974796697871 + 1.5896940246064126j,
            -2.8686854657724843 - 3.1801933594238334j,
            -0.082981417033829663 + 1.7518152509849325j,
            -5.3524188522498743 - 2.1053297170691661j,
            2.5900259839505644 - 0.061488539624564797j,
            -3.4408514291718109 - 0.25659858369140398j,
            1.1709160532948188 - 1.3230248129652447j,
            -2.9408323582582936 - 4.5277551603690283j,
            -0.28478178944932209 + 2.5139667584019603j,
            0.28384136446055264 - 6.2274346660954141j,
            1.0139856934187432 + 3.7690735174469179j,
            -0.0078974510283624788 + 1.2194467618092526j,
            -2.7712491346368346 - 2.8279715184334919j,
            -2.992529715098045 + 0.56058068732562871j,
            0.84316411435805716 - 0.86466988408221113j,
            -5.5804660954223984 - 2.9335962670233511j,
            -2.5482718063619298 + 3.9524532393702518j,
            1.0516464424971148 + 1.578274341181523j,
        ]
    ),
}

glms = {
    1: np.array(
        [
            0.0,
            0.84319998566330767 + 0j,
            -1.0248100911568008 + 0j,
            1.110961761523819 + 0j,
            -1.0626942039579403 + 0j,
            0.99145170493860635 + 0j,
            -1.2628244164642952 + 0j,
            -0.63157305188622881 + 0j,
            -1.1573098411259166 + 0j,
            0.98774392762746244 - 2.3324463135047853j,
            -0.42041547702109927 - 0.6638941892709691j,
            0.17949892445575544 - 0.18716973000962853j,
            0.26430768591955539 - 0.40505260468553134j,
            -0.24063674747596783 - 0.01667629102507856j,
            0.20243814807193189 - 0.061501040558063963j,
            0.074181600901263869 + 0.13110650173965177j,
            0.70925473188372479 + 0.65335194343646219j,
            0.4879926917946677 + 0.31352391256853401j,
            -0.35809352192298388 - 1.0728322735956963j,
            0.4533725297757551 - 0.22559691758977207j,
            -0.60038286724379097 - 0.11246033971793468j,
            0.66825095356633812 - 0.60076635444258042j,
            -1.1946567473464309 - 0.22635664737160516j,
            0.40228588081801298 + 0.068430477904664722j,
            -0.9882729303598855 - 0.46953404636080764j,
            0.71188035470148237 - 0.92234375063488339j,
            -0.42665812492162319 - 0.12577894001454354j,
            -0.76472165401579706 - 0.26752959905101342j,
            -0.0060656639141563051 - 0.93138763769826982j,
            0.89415079943278952 - 0.066507100471720232j,
            -0.61447982075563323 + 0.87348984596560353j,
            -0.78070473872335344 - 0.78753205263021409j,
            -1.1191256017366982 - 0.60047283637051052j,
            0.2133088567364409 - 1.464647765466137j,
            -0.23425203712922088 + 0.80569933612650535j,
            -1.1366303557443924 - 0.32263741303024324j,
            0.2041593807964231 + 1.0927143488558069j,
            0.43611791501355668 - 0.46222719965613662j,
            0.13160849960684828 - 0.025453022150853984j,
            -0.39955107839159809 + 0.85522030725234566j,
            0.55636294499207284 - 0.77063085552936683j,
            0.50643037413406744 + 0.15921955235797908j,
            -0.67794895826681578 - 0.2302258170581491j,
            -0.057766506371200475 - 0.13606392096680481j,
            0.2681214210068823 - 0.75888465889983925j,
        ]
    ),
    2: np.array(
        [
            0.0,
            0.0,
            -1.0146369650118083 + 0j,
            1.11121557988063 + 0j,
            -1.0268187317357511 + 0j,
            0.98244234543551479 + 0j,
            -1.2007880041682084 + 0j,
            -0.69447547017176625 + 0j,
            -1.0726374658022424 + 0j,
            0.0,
            -0.40253474561900393 - 0.65784721719896422j,
            0.15199112969379647 - 0.24330956005348325j,
            0.28523253658954206 - 0.3981266584575725j,
            -0.26845152711149062 - 0.083593980089662734j,
            0.19959571779331189 - 0.057385723112071435j,
            0.048274474287257146 + 0.05571849108314867j,
            0.66612416673860797 + 0.66489298075894143j,
            0.47445092525264315 + 0.33233327925496392j,
            -0.33978651546110278 - 1.0700406529115529j,
            0.42170150945972673 - 0.20638423667056441j,
            -0.5630841470957999 - 0.12922848005411802j,
            0.61971326220555945 - 0.56144750223866158j,
            -1.1423916258591016 - 0.25581299034320437j,
            0.34730218633923393 + 0.10618832232762943j,
            -0.99822733104115735 - 0.4682367163596412j,
            0.70620977727778933 - 0.90938188008554444j,
            -0.44219516027124856 - 0.13493822626962626j,
            -0.78951918570902713 - 0.23576709704052287j,
            -0.014428235772776353 - 0.97751697894267986j,
            0.81909761987552843 - 0.032145061525208574j,
            -0.59959900791799092 + 0.87660510575181094j,
            -0.77968569605966409 - 0.81916479783758211j,
            -1.0543271356804378 - 0.59294085416609699j,
            0.21451468853321071 - 1.575924063487286j,
            -0.097584235980056111 + 0.79606153258991741j,
            -1.1425268084073952 - 0.33343881952558124j,
            0.20815667516194364 + 1.0864812143836942j,
            0.42124636529500581 - 0.49483794628510092j,
            0.12538155362131775 - 0.054095442648732069j,
            -0.40820405930119319 + 0.85936840188813757j,
            0.57774999828224061 - 0.79228000632060525j,
            0.45984172555887304 + 0.1760761108040782j,
            -0.69197600035251772 - 0.22762901382604028j,
            -0.068152714393202821 - 0.13031971412287957j,
            0.28004810987754036 - 0.74648931403104868j,
        ]
    ),
    3: np.array(
        [
            0.0,
            0.0,
            0.0,
            1.1040780794436231 + 0j,
            -1.0554780343915136 + 0j,
            1.003760955073254 + 0j,
            -1.2565856441338645 + 0j,
            -0.62932602562674234 + 0j,
            -1.160067204424214 + 0j,
            0.0,
            0.0,
            0.15865387620507715 - 0.23612586328728333j,
            0.27391824074536975 - 0.40229821680653666j,
            -0.24904217061890843 - 0.066454748333335312j,
            0.19465514972961681 - 0.071603817219522803j,
            0.07585111789946225 + 0.10671255623789123j,
            0.67521859645108184 + 0.63791014584128802j,
            0.0,
            -0.34816350138864738 - 1.084783542403446j,
            0.43615290425078285 - 0.22284828128529358j,
            -0.57324320239356563 - 0.14126286640853886j,
            0.65304426498325374 - 0.6000904287578529j,
            -1.165079833528107 - 0.26540336287320754j,
            0.38879888788337164 + 0.049892403597867507j,
            -0.95196155755809375 - 0.46240128463150965j,
            0.66010872131183373 - 0.89379242001828385j,
            -0.38155334031368932 - 0.11319555736108271j,
            -0.83737598920187895 - 0.23689666124954797j,
            0.036024621196599382 - 0.93058744213774647j,
            0.79480395548872762 - 0.042441974598074916j,
            -0.61480456309191522 + 0.88772972943182071j,
            -0.77889262539414239 - 0.76334259507894808j,
            -1.1118023694151189 - 0.59375535579172312j,
            0.21015147536095025 - 1.4894366921848528j,
            -0.20540486553192566 + 0.80716874886526713j,
            -1.1317123907310076 - 0.32257306660406088j,
            0.18948788955123907 + 1.0757829951402618j,
            0.45816121337749072 - 0.46825028118838685j,
            0.094048425004741185 - 0.062988484577269799j,
            -0.40021838153849576 + 0.85629510171370782j,
            0.54773135746681112 - 0.76849935301866623j,
            0.49872929242448694 + 0.14779843610587595j,
            -0.67415810187311553 - 0.22910004410769433j,
            -0.05652956808223264 - 0.13895923733616072j,
            0.26192691834998399 - 0.75985770223080795j,
        ]
    ),
}

clms = {
    1: np.array(
        [
            0.0,
            -1.5258173689739127 + 0j,
            -0.38321729790014736 + 0j,
            -0.67468807400536313 + 0j,
            0.42460653551185651 + 0j,
            1.3828469966900694 + 0j,
            -1.4606906476867365 + 0j,
            -1.1024802895292889 + 0j,
            -1.6258480748456989 + 0j,
            0.72184388572247027 - 0.40980679076163978j,
            1.155123366597125 - 0.00025652164718847903j,
            -0.046798126366738545 + 0.38718565377077507j,
            0.14209457945669973 - 0.89695521394655509j,
            -0.81580217823771384 - 0.40181448848956358j,
            0.41047881458968138 - 0.1152355464248823j,
            0.25214366009371275 + 0.13596558218505578j,
            -0.48642804026342107 - 0.51921699092205253j,
            0.70318282623713557 + 1.1149229917786518j,
            -0.2620711198443052 - 1.2608592875108899j,
            -0.32886228833465481 + 0.28343506891478615j,
            0.87116700915729073 + 0.12201153895105338j,
            0.61061947387230175 - 0.13255341818790078j,
            0.20682058643208909 - 0.18157727548793343j,
            -1.012535222212142 + 0.35770276797463263j,
            0.82344404513932368 + 0.081123452026155174j,
            -0.36925633394180285 - 0.28239296801331859j,
            -0.13701971130554524 + 1.0015322075605051j,
            -0.17636539799409506 - 0.23987373576395629j,
            -0.61110525471621113 + 0.8387900954265588j,
            -0.38131027712597904 - 0.36432117739386211j,
            -1.0079042770692939 + 0.9484888310663222j,
            0.53963333913487466 - 0.15889892563621916j,
            0.90252874051924248 + 0.047882748600954872j,
            0.77742302026156063 - 0.28243856974519727j,
            -0.9721760087917013 + 0.49058350689687308j,
            0.50365618535953161 + 0.8080725210109363j,
            1.0815686965383575 - 0.70497162383482825j,
            -0.83122125861324603 + 1.0900112211266584j,
            0.63134176691035382 - 1.1506771025986287j,
            -0.25413053864796836 + 0.029385890444217244j,
            -0.056623996602004172 - 0.26225905883112283j,
            0.79047827545371763 + 0.14640251150139555j,
            -0.24482352824373257 + 0.055856847996116454j,
            -0.34090568518036446 + 0.31363733143816142j,
            0.4367718299537125 + 0.17676151335880672j,
        ]
    ),
    2: np.array(
        [
            0.0,
            0.0,
            -0.38326814027750383 + 0j,
            -0.65418849087307329 + 0j,
            0.4365892671577063 + 0j,
            1.3803202920785584 + 0j,
            -1.4916247379419461 + 0j,
            -1.1324277132571721 + 0j,
            -1.718185868626174 + 0j,
            0.0,
            1.1956968215533583 - 0.030205892584907437j,
            -0.046100534504420865 + 0.41807122036767436j,
            0.20782483037951727 - 0.94246433056743517j,
            -0.83529709861832213 - 0.33903347515975163j,
            0.48223350794745773 - 0.1926218400020257j,
            0.21761499886653402 + 0.23961747977479567j,
            -0.41751923193484447 - 0.6353671827291465j,
            0.69260449292859827 + 1.130305228894001j,
            -0.27954119293120033 - 1.2766279639264633j,
            -0.33817969510878398 + 0.30951969744288232j,
            0.83742868793014358 + 0.091212369129396176j,
            0.58571691217352817 - 0.070712873379824182j,
            0.14679306846624376 - 0.21513933832793367j,
            -1.0638029100403115 + 0.41792437931719256j,
            0.8237611915825912 + 0.077755997607020733j,
            -0.37108969890984272 - 0.30238750878485998j,
            -0.14723325508395391 + 0.9932281688841047j,
            -0.19383569442563495 - 0.29295381202435722j,
            -0.60670529686130736 + 0.83380243303561374j,
            -0.45917079393130283 - 0.47912168797908361j,
            -0.99345730695253176 + 0.94820175796661454j,
            0.52649034820916507 - 0.12783909225900825j,
            0.95924022156146393 + 0.055538327979596458j,
            0.75064860942575096 - 0.21370815773918539j,
            -0.84586566942124497 + 0.51342826175108991j,
            0.50395723769037315 + 0.813189467153421j,
            1.1022997429292671 - 0.71579859067105911j,
            -0.81673852639172906 + 1.1007947378391343j,
            0.68458074409331271 - 1.1856051362879017j,
            -0.25008109729217404 + 0.039905637802000099j,
            -0.062189175604629054 - 0.28221196312220687j,
            0.78892563532515847 + 0.20103962113750989j,
            -0.2427808848517484 + 0.05747362398942496j,
            -0.36648874880005772 + 0.26046556342439908j,
            0.46087686583398435 + 0.18234525262036616j,
        ]
    ),
    3: np.array(
        [
            0.0,
            0.0,
            0.0,
            -0.65872355978145192 + 0j,
            0.43111157992422688 + 0j,
            1.3933719902449626 + 0j,
            -1.4337104872664086 + 0j,
            -1.0953871385562564 + 0j,
            -1.592919216965424 + 0j,
            0.0,
            0.0,
            -0.037750501706858508 + 0.4056437707216613j,
            0.19266431434449349 - 0.92413738054154204j,
            -0.80624682077443821 - 0.3750231326847116j,
            0.44820402588981811 - 0.14801697141861184j,
            0.25229035881318124 + 0.17607723506064732j,
            -0.47384685147145073 - 0.54847200740427982j,
            0.0,
            -0.26403005654710615 - 1.2664841194732137j,
            -0.31764611275074489 + 0.29566346120804393j,
            0.85876964582432236 + 0.11833464087123241j,
            0.62548078652733941 - 0.10502140662441077j,
            0.18551399493477491 - 0.18721874018509277j,
            -0.9828066043226521 + 0.38082405462307395j,
            0.80637975865752387 + 0.038495909743214873j,
            -0.37901190842236099 - 0.24290178119622488j,
            -0.15681111690711577 + 0.93523746819782994j,
            -0.19823080090222214 - 0.21435654151321781j,
            -0.61995793538329469 + 0.75489242177728544j,
            -0.4291786442205881 - 0.3647575706316637j,
            -1.036373422481776 + 0.9498490485674238j,
            0.52091939787694486 - 0.16079466106792323j,
            0.90447971944064343 + 0.049384983566628349j,
            0.76161216915691299 - 0.28843184314201131j,
            -0.921447188295894 + 0.49222438394413293j,
            0.50972830882201325 + 0.80496870972031798j,
            1.0799130050305059 - 0.69042579996889542j,
            -0.80230481303668388 + 1.0710316308031511j,
            0.65228711481346291 - 1.1285250709486818j,
            -0.25636616152524505 + 0.027205860798986677j,
            -0.052885291187932219 - 0.26226354597662616j,
            0.76408397668509698 + 0.13719891764968475j,
            -0.24129807401981906 + 0.059572855113709577j,
            -0.35702076334353117 + 0.30851416270921495j,
            0.42377772250897539 + 0.17587202874134827j,
        ]
    ),
}


class TestSpinFunc(unittest.TestCase):
    def setUp(self):
        self.nside = 64
        self.lmax = self.nside

        seed = 12345
        np.random.seed(seed)
        self.mapr = hp.synfast(
            np.ones(self.lmax + 1), self.nside, pixwin=False, fwhm=0.0, sigma=None
        )
        self.mapi = hp.synfast(
            np.ones(self.lmax + 1), self.nside, pixwin=False, fwhm=0.0, sigma=None
        )

        self.almg = hp.synalm(np.ones(self.lmax + 1), self.lmax)
        self.almc = hp.synalm(np.ones(self.lmax + 1), self.lmax)

    def test_der1(self):
        """ compare output of alm2map_der1 with the equivalent spin-1 transform using alm2map_spin """

        m, dt_der1, dp_der1 = hp.alm2map_der1(self.almg, self.nside)

        alm_spin = hp.almxfl(
            self.almg,
            np.array(
                [np.sqrt(l * (l + 1.0)) for l in six.moves.xrange(0, self.lmax + 1)]
            ),
            inplace=False,
        )
        dt_spin, dp_spin = hp.alm2map_spin(
            [alm_spin, alm_spin * 0.0], self.nside, 1, self.lmax
        )

        np.testing.assert_array_almost_equal(dt_der1, dt_spin, decimal=8)
        np.testing.assert_array_almost_equal(dp_der1, dp_spin, decimal=8)

    def test_spin0(self):
        m1 = hp.alm2map(self.almg, self.nside, self.lmax)
        m2_r, m2_i = hp.alm2map_spin(
            [self.almg, 0.0 * self.almg], self.nside, 0, self.lmax
        )

        np.testing.assert_array_almost_equal(m1, m2_r, decimal=8)
        np.testing.assert_array_almost_equal(m1 * 0.0, m2_i, decimal=8)

    def test_alm2map_spin_precomputed(self):
        """ compare alm2map_spin outputs to some precomputed results for spin=1,2,3 """

        for spin in [1, 2, 3]:
            rmap, imap = hp.alm2map_spin(
                [galm, calm], nside_precomputed, spin, lmax_precomputed
            )
            np.testing.assert_array_almost_equal(rmap, maps[spin].real, decimal=7)
            np.testing.assert_array_almost_equal(imap, maps[spin].imag, decimal=7)

    def test_map2alm_spin_spin_precomputed(self):
        """ compare map2alm_spin outputs to some precomputed results for spin=1,2,3 """

        for spin in [1, 2, 3]:
            tglm, tclm = hp.map2alm_spin(
                [maps[spin].real, maps[spin].imag], spin, lmax_precomputed
            )
            np.testing.assert_array_almost_equal(glms[spin], tglm, decimal=7)
            np.testing.assert_array_almost_equal(clms[spin], tclm, decimal=7)

    def test_forward_backward_spin(self):
        """ compare map2alm_spin outputs to alm2map_spin inputs. tolerances are very loose. """
        for spin in [1, 2, 3]:
            tcl = np.ones(self.lmax + 1)
            tcl[0:spin] = 0.0
            almg = hp.almxfl(self.almg, tcl, inplace=False)
            almc = hp.almxfl(self.almc, tcl, inplace=False)

            rmap, imap = hp.alm2map_spin([almg, almc], self.nside, spin, self.lmax)
            tglm, tclm = hp.map2alm_spin([rmap, imap], spin, self.lmax)
            np.testing.assert_allclose(almg, tglm, rtol=1.0e-2, atol=1.0e-2)
            np.testing.assert_allclose(almc, tclm, rtol=1.0e-2, atol=1.0e-2)


if __name__ == "__main__":
    unittest.main()
