#pragma once
/*
 *  $Id: sanity.h 28234 2025-07-16 10:47:20Z yeti-dn $
 *  Copyright (C) 2024 David Necas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYAPP_SANITY_H__
#define __GWYAPP_SANITY_H__

#include <gtk/gtk.h>
#include <libgwyui/utils.h>

G_BEGIN_DECLS

/* I want icon names validated *compile time*!  Why in hell can't GTK+ provide macros for the standard icon names to
 * make sure valid names are used?
 * XXX: We may actually turn this to an enum and have our function which returns the icon (if it exists) try
 * multiple things like gtk-close and dialog-close. Some of them exist only in Mint or something. Some have reasonable
 * variants in hicolor, but called differently. It is a mess. */

/* These generally do not exist and we pack them. */
#define GWY_ICON_GTK_APPLY         "gtk-apply"
#define GWY_ICON_GTK_CANCEL        "gtk-cancel"
#define GWY_ICON_GTK_OK            "gtk-ok"
#define GWY_ICON_GTK_EDIT          "gtk-edit"

/* These generally do not exist and we should pack them. */
#define GWY_ICON_GTK_INFO          "gtk-info"
#define GWY_ICON_GTK_QUIT          "gtk-quit"

/* These are kind of standard and probably exist. */
#define GWY_ICON_GTK_ABOUT         "help-about"
#define GWY_ICON_GTK_ADD           "list-add"
#define GWY_ICON_GTK_CLEAR         "edit-clear"
#define GWY_ICON_GTK_CLOSE         "window-close"
#define GWY_ICON_GTK_COPY          "edit-copy"
#define GWY_ICON_GTK_DELETE        "edit-delete"
#define GWY_ICON_GTK_EXECUTE       "system-run"
#define GWY_ICON_GTK_FIND          "edit-find"
#define GWY_ICON_GTK_GO_DOWN       "go-down"
#define GWY_ICON_GTK_GO_UP         "go-up"
#define GWY_ICON_GTK_HELP          "help-contents"
#define GWY_ICON_GTK_MISSING_IMAGE "image-missing"
#define GWY_ICON_GTK_NEW           "document-new"
#define GWY_ICON_GTK_OPEN          "document-open"
#define GWY_ICON_GTK_REDO          "edit-redo"
#define GWY_ICON_GTK_REMOVE        "list-remove"
#define GWY_ICON_GTK_SAVE_AS       "document-save-as"
#define GWY_ICON_GTK_SAVE          "document-save"
#define GWY_ICON_GTK_UNDO          "edit-undo"

/* FIXME */
#define GWY_ICON_RESET NULL

/* But we may simply provide our own icon set. */

/* Button labels matching GTK+, including accels. Again, why can't GTK+ provide a standard Cancel label which is then
 * guarantted to be consistent? */
#define GWY_STOCK_APPLY  _("_Apply")
#define GWY_STOCK_CANCEL _("_Cancel")
#define GWY_STOCK_CLEAR  _("Clea_r")
#define GWY_STOCK_CLOSE  _("_Close")
#define GWY_STOCK_COPY   _("_Copy")
#define GWY_STOCK_DELETE _("_Delete")
#define GWY_STOCK_EXPORT _("_Export")
#define GWY_STOCK_HELP   _("_Help")
#define GWY_STOCK_HIDE   C_("verb", "Hide")
#define GWY_STOCK_NEW    _("_New")
#define GWY_STOCK_OK     _("_OK")
#define GWY_STOCK_OPEN   _("_Open")
#define GWY_STOCK_RESET  _("_Reset")
#define GWY_STOCK_SAVE   _("_Save")
#define GWY_STOCK_UPDATE _("_Update")

#define GWY_STOCKN_APPLY  N_("_Apply")
#define GWY_STOCKN_CANCEL N_("_Cancel")
#define GWY_STOCKN_CLEAR  N_("Clea_r")
#define GWY_STOCKN_CLOSE  N_("_Close")
#define GWY_STOCKN_COPY   N_("_Copy")
#define GWY_STOCKN_DELETE N_("_Delete")
#define GWY_STOCKN_EXPORT N_("_Export")
#define GWY_STOCKN_HELP   N_("_Help")
#define GWY_STOCKN_HIDE   NC_("verb", "Hide")
#define GWY_STOCKN_NEW    N_("_New")
#define GWY_STOCKN_OK     N_("_OK")
#define GWY_STOCKN_OPEN   N_("_Open")
#define GWY_STOCKN_RESET  N_("_Reset")
#define GWY_STOCKN_SAVE   N_("_Save")
#define GWY_STOCKN_UPDATE N_("_Update")

static inline GtkWidget*
gwy_add_ok_button_to_dialog(GtkDialog *dialog)
{
    return gwy_add_button_to_dialog(dialog, GWY_STOCK_OK, GWY_ICON_GTK_OK, GTK_RESPONSE_OK);
}

static inline GtkWidget*
gwy_add_cancel_button_to_dialog(GtkDialog *dialog)
{
    return gwy_add_button_to_dialog(dialog, GWY_STOCK_CANCEL, GWY_ICON_GTK_CANCEL, GTK_RESPONSE_CANCEL);
}

static inline GtkWidget*
gwy_add_apply_button_to_dialog(GtkDialog *dialog)
{
    return gwy_add_button_to_dialog(dialog, GWY_STOCK_APPLY, GWY_ICON_GTK_APPLY, GTK_RESPONSE_APPLY);
}

static inline GtkWidget*
gwy_add_close_button_to_dialog(GtkDialog *dialog)
{
    return gwy_add_button_to_dialog(dialog, GWY_STOCK_CLOSE, GWY_ICON_GTK_CLOSE, GTK_RESPONSE_CLOSE);
}

static inline GtkWidget*
gwy_add_hide_button_to_dialog(GtkDialog *dialog)
{
    return gwy_add_button_to_dialog(dialog, GWY_STOCK_HIDE, GWY_ICON_GTK_CLOSE, GTK_RESPONSE_DELETE_EVENT);
}

static inline GtkWidget*
gwy_add_save_button_to_dialog(GtkDialog *dialog)
{
    return gwy_add_button_to_dialog(dialog, GWY_STOCK_SAVE, GWY_ICON_GTK_SAVE, GTK_RESPONSE_OK);
}

static inline GtkWidget*
gwy_add_clear_button_to_dialog(GtkDialog *dialog)
{
    return gwy_add_button_to_dialog(dialog, GWY_STOCK_CLEAR, GWY_ICON_GTK_CLEAR, GWY_RESPONSE_CLEAR);
}

static inline GtkWidget*
gwy_add_update_button_to_dialog(GtkDialog *dialog)
{
    return gwy_add_button_to_dialog(dialog, GWY_STOCK_UPDATE, GWY_ICON_GTK_EXECUTE, GWY_RESPONSE_UPDATE);
}

static inline GtkWidget*
gwy_add_reset_button_to_dialog(GtkDialog *dialog)
{
    return gwy_add_button_to_dialog(dialog, GWY_STOCK_RESET, GWY_ICON_RESET, GWY_RESPONSE_RESET);
}

static inline gboolean
gwy_get_screen_workarea(GtkWidget *widget, GdkRectangle *workarea)
{
    GdkDisplay *display = NULL;
    GdkWindow *window = NULL;
    GdkMonitor *monitor = NULL;

    if (widget) {
        display = gtk_widget_get_display(widget);
        window = gtk_widget_get_window(widget);
    }
    else {
        /* XXX: This can still be NULL. */
        display = gdk_display_get_default();
    }

    if (display && window)
        monitor = gdk_display_get_monitor_at_window(display, window);
    else if (display)
        monitor = gdk_display_get_primary_monitor(display);

    if (monitor) {
        gdk_monitor_get_workarea(monitor, workarea);
        return TRUE;
    }

    return FALSE;
}

static inline gint
gwy_get_screen_width(GtkWidget *widget)
{
    GdkRectangle workarea;

    if (gwy_get_screen_workarea(widget, &workarea))
        return workarea.width;

    /* Whatever */
    return 1024;
}

static inline gint
gwy_get_screen_height(GtkWidget *widget)
{
    GdkRectangle workarea;

    if (gwy_get_screen_workarea(widget, &workarea))
        return workarea.height;

    /* Whatever */
    return 768;
}

/* Pass -1 for margins we do not want to change. */
static inline void
gwy_set_widget_padding(GtkWidget *widget, gint left, gint right, gint top, gint bottom)
{
    if (left >= 0)
        gtk_widget_set_margin_start(widget, left);
    if (right >= 0)
        gtk_widget_set_margin_end(widget, right);
    if (top >= 0)
        gtk_widget_set_margin_top(widget, top);
    if (bottom >= 0)
        gtk_widget_set_margin_bottom(widget, bottom);
}

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
