// Code generated by gen_tests.py and process_polyglot.py.
// Do not edit this file directly.
// The template for this file is located at:
// ../template.go.tpl
package reql_tests

import (
	"testing"
	"time"

	"github.com/stretchr/testify/suite"
	r "gopkg.in/rethinkdb/rethinkdb-go.v6"
	"gopkg.in/rethinkdb/rethinkdb-go.v6/internal/compare"
)

// Tests meta queries for creating and deleting tables
func TestMetaTableSuite(t *testing.T) {
	suite.Run(t, new(MetaTableSuite))
}

type MetaTableSuite struct {
	suite.Suite

	session *r.Session
}

func (suite *MetaTableSuite) SetupTest() {
	suite.T().Log("Setting up MetaTableSuite")
	// Use imports to prevent errors
	_ = time.Time{}
	_ = compare.AnythingIsFine

	session, err := r.Connect(r.ConnectOpts{
		Address: url,
	})
	suite.Require().NoError(err, "Error returned when connecting to server")
	suite.session = session

	r.DBDrop("db_mtable").Exec(suite.session)
	err = r.DBCreate("db_mtable").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("db_mtable").Wait().Exec(suite.session)
	suite.Require().NoError(err)

}

func (suite *MetaTableSuite) TearDownSuite() {
	suite.T().Log("Tearing down MetaTableSuite")

	if suite.session != nil {
		r.DB("rethinkdb").Table("_debug_scratch").Delete().Exec(suite.session)
		r.DBDrop("db_mtable").Exec(suite.session)

		suite.session.Close()
	}
}

func (suite *MetaTableSuite) TestCases() {
	suite.T().Log("Running MetaTableSuite: Tests meta queries for creating and deleting tables")

	// meta/table.yaml line #4
	// db = r.db('test')
	suite.T().Log("Possibly executing: var db r.Term = r.DB('test')")

	db := r.DB("db_mtable")
	_ = db // Prevent any noused variable errors

	{
		// meta/table.yaml line #6
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* db.table_list() */

		suite.T().Log("About to run line #6: db.TableList()")

		runAndAssert(suite.Suite, expected_, db.TableList(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #6")
	}

	{
		// meta/table.yaml line #9
		/* ({'type':'DB','name':'rethinkdb','id':null}) */
		var expected_ = compare.PartialMatch(map[interface{}]interface{}{"type": "DB", "name": "rethinkdb"})
		/* r.db('rethinkdb').info() */

		suite.T().Log("About to run line #9: r.DB('rethinkdb').Info()")

		runAndAssert(suite.Suite, expected_, r.DB("rethinkdb").Info(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #9")
	}

	{
		// meta/table.yaml line #12
		/* partial({'db':{'type':'DB','name':'rethinkdb','id':null},
		'type':'TABLE','id':null,'name':'stats',
		'indexes':[],'primary_key':'id'}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"db": map[interface{}]interface{}{"type": "DB", "name": "rethinkdb"}, "type": "TABLE", "name": "stats", "indexes": []interface{}{}, "primary_key": "id"})
		/* r.db('rethinkdb').table('stats').info() */

		suite.T().Log("About to run line #12: r.DB('rethinkdb').Table('stats').Info()")

		runAndAssert(suite.Suite, expected_, r.DB("rethinkdb").Table("stats").Info(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #12")
	}

	{
		// meta/table.yaml line #18
		/* partial({'tables_created':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_created": 1})
		/* db.table_create('a') */

		suite.T().Log("About to run line #18: db.TableCreate('a')")

		runAndAssert(suite.Suite, expected_, db.TableCreate("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #18")
	}

	{
		// meta/table.yaml line #21
		/* ['a'] */
		var expected_ []interface{} = []interface{}{"a"}
		/* db.table_list() */

		suite.T().Log("About to run line #21: db.TableList()")

		runAndAssert(suite.Suite, expected_, db.TableList(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #21")
	}

	{
		// meta/table.yaml line #24
		/* partial({'tables_created':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_created": 1})
		/* db.table_create('b') */

		suite.T().Log("About to run line #24: db.TableCreate('b')")

		runAndAssert(suite.Suite, expected_, db.TableCreate("b"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #24")
	}

	{
		// meta/table.yaml line #27
		/* bag(['a', 'b']) */
		var expected_ compare.Expected = compare.UnorderedMatch([]interface{}{"a", "b"})
		/* db.table_list() */

		suite.T().Log("About to run line #27: db.TableList()")

		runAndAssert(suite.Suite, expected_, db.TableList(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #27")
	}

	{
		// meta/table.yaml line #31
		/* partial({'tables_dropped':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_dropped": 1})
		/* db.table_drop('a') */

		suite.T().Log("About to run line #31: db.TableDrop('a')")

		runAndAssert(suite.Suite, expected_, db.TableDrop("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #31")
	}

	{
		// meta/table.yaml line #34
		/* ['b'] */
		var expected_ []interface{} = []interface{}{"b"}
		/* db.table_list() */

		suite.T().Log("About to run line #34: db.TableList()")

		runAndAssert(suite.Suite, expected_, db.TableList(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #34")
	}

	{
		// meta/table.yaml line #37
		/* partial({'tables_dropped':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_dropped": 1})
		/* db.table_drop('b') */

		suite.T().Log("About to run line #37: db.TableDrop('b')")

		runAndAssert(suite.Suite, expected_, db.TableDrop("b"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #37")
	}

	{
		// meta/table.yaml line #40
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* db.table_list() */

		suite.T().Log("About to run line #40: db.TableList()")

		runAndAssert(suite.Suite, expected_, db.TableList(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #40")
	}

	{
		// meta/table.yaml line #44
		/* partial({'tables_created':1,'config_changes':[partial({'new_val':partial({'durability':'soft'})})]}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_created": 1, "config_changes": []interface{}{compare.PartialMatch(map[interface{}]interface{}{"new_val": compare.PartialMatch(map[interface{}]interface{}{"durability": "soft"})})}})
		/* db.table_create('ab', durability='soft') */

		suite.T().Log("About to run line #44: db.TableCreate('ab').OptArgs(r.TableCreateOpts{Durability: 'soft', })")

		runAndAssert(suite.Suite, expected_, db.TableCreate("ab").OptArgs(r.TableCreateOpts{Durability: "soft"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #44")
	}

	{
		// meta/table.yaml line #49
		/* partial({'tables_dropped':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_dropped": 1})
		/* db.table_drop('ab') */

		suite.T().Log("About to run line #49: db.TableDrop('ab')")

		runAndAssert(suite.Suite, expected_, db.TableDrop("ab"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #49")
	}

	{
		// meta/table.yaml line #52
		/* partial({'tables_created':1,'config_changes':[partial({'new_val':partial({'durability':'hard'})})]}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_created": 1, "config_changes": []interface{}{compare.PartialMatch(map[interface{}]interface{}{"new_val": compare.PartialMatch(map[interface{}]interface{}{"durability": "hard"})})}})
		/* db.table_create('ab', durability='hard') */

		suite.T().Log("About to run line #52: db.TableCreate('ab').OptArgs(r.TableCreateOpts{Durability: 'hard', })")

		runAndAssert(suite.Suite, expected_, db.TableCreate("ab").OptArgs(r.TableCreateOpts{Durability: "hard"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #52")
	}

	{
		// meta/table.yaml line #57
		/* partial({'tables_dropped':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_dropped": 1})
		/* db.table_drop('ab') */

		suite.T().Log("About to run line #57: db.TableDrop('ab')")

		runAndAssert(suite.Suite, expected_, db.TableDrop("ab"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #57")
	}

	{
		// meta/table.yaml line #60
		/* err('ReqlQueryLogicError', 'Durability option `fake` unrecognized (options are "hard" and "soft").') */
		var expected_ Err = err("ReqlQueryLogicError", "Durability option `fake` unrecognized (options are \"hard\" and \"soft\").")
		/* db.table_create('ab', durability='fake') */

		suite.T().Log("About to run line #60: db.TableCreate('ab').OptArgs(r.TableCreateOpts{Durability: 'fake', })")

		runAndAssert(suite.Suite, expected_, db.TableCreate("ab").OptArgs(r.TableCreateOpts{Durability: "fake"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #60")
	}

	{
		// meta/table.yaml line #65
		/* partial({'tables_created':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_created": 1})
		/* db.table_create('ab', primary_key='bar', shards=2, replicas=1) */

		suite.T().Log("About to run line #65: db.TableCreate('ab').OptArgs(r.TableCreateOpts{PrimaryKey: 'bar', Shards: 2, Replicas: 1, })")

		runAndAssert(suite.Suite, expected_, db.TableCreate("ab").OptArgs(r.TableCreateOpts{PrimaryKey: "bar", Shards: 2, Replicas: 1}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #65")
	}

	{
		// meta/table.yaml line #70
		/* partial({'tables_dropped':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_dropped": 1})
		/* db.table_drop('ab') */

		suite.T().Log("About to run line #70: db.TableDrop('ab')")

		runAndAssert(suite.Suite, expected_, db.TableDrop("ab"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #70")
	}

	{
		// meta/table.yaml line #73
		/* partial({'tables_created':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_created": 1})
		/* db.table_create('ab', primary_key='bar', primary_replica_tag='default') */

		suite.T().Log("About to run line #73: db.TableCreate('ab').OptArgs(r.TableCreateOpts{PrimaryKey: 'bar', PrimaryReplicaTag: 'default', })")

		runAndAssert(suite.Suite, expected_, db.TableCreate("ab").OptArgs(r.TableCreateOpts{PrimaryKey: "bar", PrimaryReplicaTag: "default"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #73")
	}

	{
		// meta/table.yaml line #78
		/* partial({'tables_dropped':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_dropped": 1})
		/* db.table_drop('ab') */

		suite.T().Log("About to run line #78: db.TableDrop('ab')")

		runAndAssert(suite.Suite, expected_, db.TableDrop("ab"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #78")
	}

	{
		// meta/table.yaml line #81
		/* partial({'tables_created':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_created": 1})
		/* db.table_create('ab', nonvoting_replica_tags=['default']) */

		suite.T().Log("About to run line #81: db.TableCreate('ab').OptArgs(r.TableCreateOpts{NonVotingReplicaTags: []interface{}{'default'}, })")

		runAndAssert(suite.Suite, expected_, db.TableCreate("ab").OptArgs(r.TableCreateOpts{NonVotingReplicaTags: []interface{}{"default"}}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #81")
	}

	{
		// meta/table.yaml line #86
		/* partial({'tables_dropped':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_dropped": 1})
		/* db.table_drop('ab') */

		suite.T().Log("About to run line #86: db.TableDrop('ab')")

		runAndAssert(suite.Suite, expected_, db.TableDrop("ab"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #86")
	}

	{
		// meta/table.yaml line #90
		/* partial({'tables_created':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_created": 1})
		/* db.table_create('a') */

		suite.T().Log("About to run line #90: db.TableCreate('a')")

		runAndAssert(suite.Suite, expected_, db.TableCreate("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #90")
	}

	{
		// meta/table.yaml line #93
		/* partial({'reconfigured':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"reconfigured": 1})
		/* db.table('a').reconfigure(shards=1, replicas=1) */

		suite.T().Log("About to run line #93: db.Table('a').Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: 1, })")

		runAndAssert(suite.Suite, expected_, db.Table("a").Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: 1}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #93")
	}

	{
		// meta/table.yaml line #98
		/* partial({'reconfigured':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"reconfigured": 1})
		/* db.table('a').reconfigure(shards=1, replicas={"default":1}, nonvoting_replica_tags=['default'], primary_replica_tag='default') */

		suite.T().Log("About to run line #98: db.Table('a').Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: map[interface{}]interface{}{'default': 1, }, NonVotingReplicaTags: []interface{}{'default'}, PrimaryReplicaTag: 'default', })")

		runAndAssert(suite.Suite, expected_, db.Table("a").Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: map[interface{}]interface{}{"default": 1}, NonVotingReplicaTags: []interface{}{"default"}, PrimaryReplicaTag: "default"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #98")
	}

	{
		// meta/table.yaml line #103
		/* partial({'reconfigured':0}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"reconfigured": 0})
		/* db.table('a').reconfigure(shards=1, replicas=1, dry_run=True) */

		suite.T().Log("About to run line #103: db.Table('a').Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: 1, DryRun: true, })")

		runAndAssert(suite.Suite, expected_, db.Table("a").Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: 1, DryRun: true}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #103")
	}

	{
		// meta/table.yaml line #108
		/* err('ReqlOpFailedError', 'This table doesn\'t need to be repaired.', []) */
		var expected_ Err = err("ReqlOpFailedError", "This table doesn't need to be repaired.")
		/* db.table('a').reconfigure(emergency_repair="unsafe_rollback") */

		suite.T().Log("About to run line #108: db.Table('a').Reconfigure().OptArgs(r.ReconfigureOpts{EmergencyRepair: 'unsafe_rollback', })")

		runAndAssert(suite.Suite, expected_, db.Table("a").Reconfigure().OptArgs(r.ReconfigureOpts{EmergencyRepair: "unsafe_rollback"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #108")
	}

	{
		// meta/table.yaml line #113
		/* err('ReqlOpFailedError', 'This table doesn\'t need to be repaired.', []) */
		var expected_ Err = err("ReqlOpFailedError", "This table doesn't need to be repaired.")
		/* db.table('a').reconfigure(emergency_repair="unsafe_rollback", dry_run=True) */

		suite.T().Log("About to run line #113: db.Table('a').Reconfigure().OptArgs(r.ReconfigureOpts{EmergencyRepair: 'unsafe_rollback', DryRun: true, })")

		runAndAssert(suite.Suite, expected_, db.Table("a").Reconfigure().OptArgs(r.ReconfigureOpts{EmergencyRepair: "unsafe_rollback", DryRun: true}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #113")
	}

	{
		// meta/table.yaml line #118
		/* err('ReqlOpFailedError', 'This table doesn\'t need to be repaired.', []) */
		var expected_ Err = err("ReqlOpFailedError", "This table doesn't need to be repaired.")
		/* db.table('a').reconfigure(emergency_repair="unsafe_rollback_or_erase") */

		suite.T().Log("About to run line #118: db.Table('a').Reconfigure().OptArgs(r.ReconfigureOpts{EmergencyRepair: 'unsafe_rollback_or_erase', })")

		runAndAssert(suite.Suite, expected_, db.Table("a").Reconfigure().OptArgs(r.ReconfigureOpts{EmergencyRepair: "unsafe_rollback_or_erase"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #118")
	}

	{
		// meta/table.yaml line #123
		/* partial({'reconfigured':0}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"reconfigured": 0})
		/* db.table('a').reconfigure(emergency_repair=None, shards=1, replicas=1, dry_run=True) */

		suite.T().Log("About to run line #123: db.Table('a').Reconfigure().OptArgs(r.ReconfigureOpts{EmergencyRepair: nil, Shards: 1, Replicas: 1, DryRun: true, })")

		runAndAssert(suite.Suite, expected_, db.Table("a").Reconfigure().OptArgs(r.ReconfigureOpts{EmergencyRepair: nil, Shards: 1, Replicas: 1, DryRun: true}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #123")
	}

	{
		// meta/table.yaml line #128
		/* partial({'tables_dropped':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_dropped": 1})
		/* db.table_drop('a') */

		suite.T().Log("About to run line #128: db.TableDrop('a')")

		runAndAssert(suite.Suite, expected_, db.TableDrop("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #128")
	}

	{
		// meta/table.yaml line #132
		/* partial({'tables_created':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_created": 1})
		/* db.table_create('foo') */

		suite.T().Log("About to run line #132: db.TableCreate('foo')")

		runAndAssert(suite.Suite, expected_, db.TableCreate("foo"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #132")
	}

	{
		// meta/table.yaml line #135
		/* err('ReqlOpFailedError', 'Table `test.foo` already exists.', [0]) */
		var expected_ Err = err("ReqlOpFailedError", "Table `db_mtable.foo` already exists.")
		/* db.table_create('foo') */

		suite.T().Log("About to run line #135: db.TableCreate('foo')")

		runAndAssert(suite.Suite, expected_, db.TableCreate("foo"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #135")
	}

	{
		// meta/table.yaml line #138
		/* partial({'tables_dropped':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_dropped": 1})
		/* db.table_drop('foo') */

		suite.T().Log("About to run line #138: db.TableDrop('foo')")

		runAndAssert(suite.Suite, expected_, db.TableDrop("foo"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #138")
	}

	{
		// meta/table.yaml line #141
		/* err('ReqlOpFailedError', 'Table `test.foo` does not exist.', [0]) */
		var expected_ Err = err("ReqlOpFailedError", "Table `db_mtable.foo` does not exist.")
		/* db.table_drop('foo') */

		suite.T().Log("About to run line #141: db.TableDrop('foo')")

		runAndAssert(suite.Suite, expected_, db.TableDrop("foo"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #141")
	}

	{
		// meta/table.yaml line #158
		/* partial({'tables_created':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_created": 1})
		/* db.table_create('a') */

		suite.T().Log("About to run line #158: db.TableCreate('a')")

		runAndAssert(suite.Suite, expected_, db.TableCreate("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #158")
	}

	{
		// meta/table.yaml line #161
		/* err('ReqlQueryLogicError', 'Every table must have at least one shard.', []) */
		var expected_ Err = err("ReqlQueryLogicError", "Every table must have at least one shard.")
		/* db.table('a').reconfigure(shards=0, replicas=1) */

		suite.T().Log("About to run line #161: db.Table('a').Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 0, Replicas: 1, })")

		runAndAssert(suite.Suite, expected_, db.Table("a").Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 0, Replicas: 1}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #161")
	}

	{
		// meta/table.yaml line #166
		/* err('ReqlOpFailedError', 'Can\'t use server tag `foo` for primary replicas because you specified no replicas in server tag `foo`.', []) */
		var expected_ Err = err("ReqlOpFailedError", "Can't use server tag `foo` for primary replicas because you specified no replicas in server tag `foo`.")
		/* db.table('a').reconfigure(shards=1, replicas={"default":1}, primary_replica_tag="foo") */

		suite.T().Log("About to run line #166: db.Table('a').Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: map[interface{}]interface{}{'default': 1, }, PrimaryReplicaTag: 'foo', })")

		runAndAssert(suite.Suite, expected_, db.Table("a").Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: map[interface{}]interface{}{"default": 1}, PrimaryReplicaTag: "foo"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #166")
	}

	{
		// meta/table.yaml line #171
		/* err('ReqlOpFailedError', 'You specified that the replicas in server tag `foo` should be non-voting, but you didn\'t specify a number of replicas in server tag `foo`.', []) */
		var expected_ Err = err("ReqlOpFailedError", "You specified that the replicas in server tag `foo` should be non-voting, but you didn't specify a number of replicas in server tag `foo`.")
		/* db.table('a').reconfigure(shards=1, replicas={"default":1}, primary_replica_tag="default", nonvoting_replica_tags=["foo"]) */

		suite.T().Log("About to run line #171: db.Table('a').Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: map[interface{}]interface{}{'default': 1, }, PrimaryReplicaTag: 'default', NonVotingReplicaTags: []interface{}{'foo'}, })")

		runAndAssert(suite.Suite, expected_, db.Table("a").Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: map[interface{}]interface{}{"default": 1}, PrimaryReplicaTag: "default", NonVotingReplicaTags: []interface{}{"foo"}}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #171")
	}

	{
		// meta/table.yaml line #176
		/* err('ReqlOpFailedError', 'You must set `replicas` to at least one. `replicas` includes the primary replica; if there are zero replicas, there is nowhere to put the data.', []) */
		var expected_ Err = err("ReqlOpFailedError", "You must set `replicas` to at least one. `replicas` includes the primary replica; if there are zero replicas, there is nowhere to put the data.")
		/* db.table('a').reconfigure(shards=1, replicas={"foo":0}, primary_replica_tag="foo") */

		suite.T().Log("About to run line #176: db.Table('a').Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: map[interface{}]interface{}{'foo': 0, }, PrimaryReplicaTag: 'foo', })")

		runAndAssert(suite.Suite, expected_, db.Table("a").Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: map[interface{}]interface{}{"foo": 0}, PrimaryReplicaTag: "foo"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #176")
	}

	{
		// meta/table.yaml line #181
		/* err('ReqlQueryLogicError', '`primary_replica_tag` must be specified when `replicas` is an OBJECT.', []) */
		var expected_ Err = err("ReqlQueryLogicError", "`primary_replica_tag` must be specified when `replicas` is an OBJECT.")
		/* db.table('a').reconfigure(shards=1, replicas={"default":0}) */

		suite.T().Log("About to run line #181: db.Table('a').Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: map[interface{}]interface{}{'default': 0, }, })")

		runAndAssert(suite.Suite, expected_, db.Table("a").Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: map[interface{}]interface{}{"default": 0}}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #181")
	}

	{
		// meta/table.yaml line #186
		/* err('ReqlQueryLogicError', 'Can\'t have a negative number of replicas', []) */
		var expected_ Err = err("ReqlQueryLogicError", "Can't have a negative number of replicas")
		/* db.table('a').reconfigure(shards=1, replicas={"default":-3}, primary_replica_tag='default') */

		suite.T().Log("About to run line #186: db.Table('a').Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: map[interface{}]interface{}{'default': -3, }, PrimaryReplicaTag: 'default', })")

		runAndAssert(suite.Suite, expected_, db.Table("a").Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: map[interface{}]interface{}{"default": -3}, PrimaryReplicaTag: "default"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #186")
	}

	{
		// meta/table.yaml line #191
		/* err('ReqlQueryLogicError', '`replicas` must be an OBJECT if `primary_replica_tag` is specified.', []) */
		var expected_ Err = err("ReqlQueryLogicError", "`replicas` must be an OBJECT if `primary_replica_tag` is specified.")
		/* db.table('a').reconfigure(shards=1, replicas=3, primary_replica_tag='foo') */

		suite.T().Log("About to run line #191: db.Table('a').Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: 3, PrimaryReplicaTag: 'foo', })")

		runAndAssert(suite.Suite, expected_, db.Table("a").Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: 3, PrimaryReplicaTag: "foo"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #191")
	}

	{
		// meta/table.yaml line #196
		/* err('ReqlQueryLogicError', '`replicas` must be an OBJECT if `nonvoting_replica_tags` is specified.', []) */
		var expected_ Err = err("ReqlQueryLogicError", "`replicas` must be an OBJECT if `nonvoting_replica_tags` is specified.")
		/* db.table('a').reconfigure(shards=1, replicas=3, nonvoting_replica_tags=['foo']) */

		suite.T().Log("About to run line #196: db.Table('a').Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: 3, NonVotingReplicaTags: []interface{}{'foo'}, })")

		runAndAssert(suite.Suite, expected_, db.Table("a").Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: 3, NonVotingReplicaTags: []interface{}{"foo"}}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #196")
	}

	{
		// meta/table.yaml line #201
		/* err('ReqlQueryLogicError', 'Can\'t emergency repair an entire database at once; instead you should run `reconfigure()` on each table individually.') */
		var expected_ Err = err("ReqlQueryLogicError", "Can't emergency repair an entire database at once; instead you should run `reconfigure()` on each table individually.")
		/* db.reconfigure(emergency_repair="unsafe_rollback") */

		suite.T().Log("About to run line #201: db.Reconfigure().OptArgs(r.ReconfigureOpts{EmergencyRepair: 'unsafe_rollback', })")

		runAndAssert(suite.Suite, expected_, db.Reconfigure().OptArgs(r.ReconfigureOpts{EmergencyRepair: "unsafe_rollback"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #201")
	}

	{
		// meta/table.yaml line #206
		/* err('ReqlQueryLogicError', '`emergency_repair` should be "unsafe_rollback" or "unsafe_rollback_or_erase"', []) */
		var expected_ Err = err("ReqlQueryLogicError", "`emergency_repair` should be \"unsafe_rollback\" or \"unsafe_rollback_or_erase\"")
		/* db.table('a').reconfigure(emergency_repair="foo") */

		suite.T().Log("About to run line #206: db.Table('a').Reconfigure().OptArgs(r.ReconfigureOpts{EmergencyRepair: 'foo', })")

		runAndAssert(suite.Suite, expected_, db.Table("a").Reconfigure().OptArgs(r.ReconfigureOpts{EmergencyRepair: "foo"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #206")
	}

	{
		// meta/table.yaml line #211
		/* err('ReqlQueryLogicError', 'In emergency repair mode, you can\'t specify shards, replicas, etc.') */
		var expected_ Err = err("ReqlQueryLogicError", "In emergency repair mode, you can't specify shards, replicas, etc.")
		/* db.table('a').reconfigure(emergency_repair="unsafe_rollback", shards=1, replicas=1) */

		suite.T().Log("About to run line #211: db.Table('a').Reconfigure().OptArgs(r.ReconfigureOpts{EmergencyRepair: 'unsafe_rollback', Shards: 1, Replicas: 1, })")

		runAndAssert(suite.Suite, expected_, db.Table("a").Reconfigure().OptArgs(r.ReconfigureOpts{EmergencyRepair: "unsafe_rollback", Shards: 1, Replicas: 1}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #211")
	}

	{
		// meta/table.yaml line #217
		/* partial({'reconfigured':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"reconfigured": 1})
		/* db.table('a').reconfigure(shards=2, replicas=1) */

		suite.T().Log("About to run line #217: db.Table('a').Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 2, Replicas: 1, })")

		runAndAssert(suite.Suite, expected_, db.Table("a").Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 2, Replicas: 1}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #217")
	}

	{
		// meta/table.yaml line #222
		/* {"ready":1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"ready": 1}
		/* db.table('a').wait(wait_for="all_replicas_ready") */

		suite.T().Log("About to run line #222: db.Table('a').Wait().OptArgs(r.WaitOpts{WaitFor: 'all_replicas_ready', })")

		runAndAssert(suite.Suite, expected_, db.Table("a").Wait().OptArgs(r.WaitOpts{WaitFor: "all_replicas_ready"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #222")
	}

	{
		// meta/table.yaml line #228
		/* partial({"inserted":4}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"inserted": 4})
		/* db.table('a').insert([{"id":1}, {"id":2}, {"id":3}, {"id":4}]) */

		suite.T().Log("About to run line #228: db.Table('a').Insert([]interface{}{map[interface{}]interface{}{'id': 1, }, map[interface{}]interface{}{'id': 2, }, map[interface{}]interface{}{'id': 3, }, map[interface{}]interface{}{'id': 4, }})")

		runAndAssert(suite.Suite, expected_, db.Table("a").Insert([]interface{}{map[interface{}]interface{}{"id": 1}, map[interface{}]interface{}{"id": 2}, map[interface{}]interface{}{"id": 3}, map[interface{}]interface{}{"id": 4}}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #228")
	}

	{
		// meta/table.yaml line #233
		/* partial({'reconfigured':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"reconfigured": 1})
		/* db.table('a').reconfigure(shards=2, replicas=1) */

		suite.T().Log("About to run line #233: db.Table('a').Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 2, Replicas: 1, })")

		runAndAssert(suite.Suite, expected_, db.Table("a").Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 2, Replicas: 1}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #233")
	}

	{
		// meta/table.yaml line #238
		/* err('ReqlOpFailedError', 'Can\'t put 2 replicas on servers with the tag `default` because there are only 1 servers with the tag `default`. It\'s impossible to have more replicas of the data than there are servers.', []) */
		var expected_ Err = err("ReqlOpFailedError", "Can't put 2 replicas on servers with the tag `default` because there are only 1 servers with the tag `default`. It's impossible to have more replicas of the data than there are servers.")
		/* db.table('a').reconfigure(shards=1, replicas=2) */

		suite.T().Log("About to run line #238: db.Table('a').Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: 2, })")

		runAndAssert(suite.Suite, expected_, db.Table("a").Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: 2}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #238")
	}

	{
		// meta/table.yaml line #244
		/* {"ready":1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"ready": 1}
		/* db.table('a').wait(wait_for="all_replicas_ready") */

		suite.T().Log("About to run line #244: db.Table('a').Wait().OptArgs(r.WaitOpts{WaitFor: 'all_replicas_ready', })")

		runAndAssert(suite.Suite, expected_, db.Table("a").Wait().OptArgs(r.WaitOpts{WaitFor: "all_replicas_ready"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #244")
	}

	{
		// meta/table.yaml line #248
		/* partial({'rebalanced':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"rebalanced": 1})
		/* db.table('a').rebalance() */

		suite.T().Log("About to run line #248: db.Table('a').Rebalance()")

		runAndAssert(suite.Suite, expected_, db.Table("a").Rebalance(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #248")
	}

	{
		// meta/table.yaml line #251
		/* {"ready":1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"ready": 1}
		/* db.wait(wait_for="all_replicas_ready") */

		suite.T().Log("About to run line #251: db.Wait().OptArgs(r.WaitOpts{WaitFor: 'all_replicas_ready', })")

		runAndAssert(suite.Suite, expected_, db.Wait().OptArgs(r.WaitOpts{WaitFor: "all_replicas_ready"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #251")
	}

	{
		// meta/table.yaml line #255
		/* partial({'rebalanced':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"rebalanced": 1})
		/* db.rebalance() */

		suite.T().Log("About to run line #255: db.Rebalance()")

		runAndAssert(suite.Suite, expected_, db.Rebalance(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #255")
	}

	{
		// meta/table.yaml line #271
		/* partial({'tables_dropped':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_dropped": 1})
		/* db.table_drop('a') */

		suite.T().Log("About to run line #271: db.TableDrop('a')")

		runAndAssert(suite.Suite, expected_, db.TableDrop("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #271")
	}

	{
		// meta/table.yaml line #275
		/* AnythingIsFine */
		var expected_ string = compare.AnythingIsFine
		/* db.table_create('a') */

		suite.T().Log("About to run line #275: db.TableCreate('a')")

		runAndAssert(suite.Suite, expected_, db.TableCreate("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #275")
	}

	{
		// meta/table.yaml line #276
		/* AnythingIsFine */
		var expected_ string = compare.AnythingIsFine
		/* db.table_create('b') */

		suite.T().Log("About to run line #276: db.TableCreate('b')")

		runAndAssert(suite.Suite, expected_, db.TableCreate("b"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #276")
	}

	{
		// meta/table.yaml line #277
		/* AnythingIsFine */
		var expected_ string = compare.AnythingIsFine
		/* db.table_create('c') */

		suite.T().Log("About to run line #277: db.TableCreate('c')")

		runAndAssert(suite.Suite, expected_, db.TableCreate("c"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #277")
	}

	{
		// meta/table.yaml line #279
		/* err('ReqlQueryLogicError', 'Every table must have at least one shard.', []) */
		var expected_ Err = err("ReqlQueryLogicError", "Every table must have at least one shard.")
		/* db.reconfigure(shards=0, replicas=1) */

		suite.T().Log("About to run line #279: db.Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 0, Replicas: 1, })")

		runAndAssert(suite.Suite, expected_, db.Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 0, Replicas: 1}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #279")
	}

	{
		// meta/table.yaml line #284
		/* err('ReqlQueryLogicError', '`primary_replica_tag` must be specified when `replicas` is an OBJECT.', []) */
		var expected_ Err = err("ReqlQueryLogicError", "`primary_replica_tag` must be specified when `replicas` is an OBJECT.")
		/* db.reconfigure(shards=1, replicas={"default":0}) */

		suite.T().Log("About to run line #284: db.Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: map[interface{}]interface{}{'default': 0, }, })")

		runAndAssert(suite.Suite, expected_, db.Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: map[interface{}]interface{}{"default": 0}}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #284")
	}

	{
		// meta/table.yaml line #289
		/* err('ReqlQueryLogicError', 'Can\'t have a negative number of replicas', []) */
		var expected_ Err = err("ReqlQueryLogicError", "Can't have a negative number of replicas")
		/* db.reconfigure(shards=1, replicas={"default":-3}, primary_replica_tag='default') */

		suite.T().Log("About to run line #289: db.Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: map[interface{}]interface{}{'default': -3, }, PrimaryReplicaTag: 'default', })")

		runAndAssert(suite.Suite, expected_, db.Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: map[interface{}]interface{}{"default": -3}, PrimaryReplicaTag: "default"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #289")
	}

	{
		// meta/table.yaml line #294
		/* err('ReqlQueryLogicError', '`replicas` must be an OBJECT if `primary_replica_tag` is specified.', []) */
		var expected_ Err = err("ReqlQueryLogicError", "`replicas` must be an OBJECT if `primary_replica_tag` is specified.")
		/* db.reconfigure(shards=1, replicas=3, primary_replica_tag='foo') */

		suite.T().Log("About to run line #294: db.Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: 3, PrimaryReplicaTag: 'foo', })")

		runAndAssert(suite.Suite, expected_, db.Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 1, Replicas: 3, PrimaryReplicaTag: "foo"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #294")
	}

	{
		// meta/table.yaml line #299
		/* partial({'reconfigured':3}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"reconfigured": 3})
		/* db.reconfigure(shards=2, replicas=1) */

		suite.T().Log("About to run line #299: db.Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 2, Replicas: 1, })")

		runAndAssert(suite.Suite, expected_, db.Reconfigure().OptArgs(r.ReconfigureOpts{Shards: 2, Replicas: 1}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #299")
	}

	{
		// meta/table.yaml line #304
		/* partial({'tables_dropped':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_dropped": 1})
		/* db.table_drop('a') */

		suite.T().Log("About to run line #304: db.TableDrop('a')")

		runAndAssert(suite.Suite, expected_, db.TableDrop("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #304")
	}

	{
		// meta/table.yaml line #306
		/* partial({'tables_dropped':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_dropped": 1})
		/* db.table_drop('b') */

		suite.T().Log("About to run line #306: db.TableDrop('b')")

		runAndAssert(suite.Suite, expected_, db.TableDrop("b"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #306")
	}

	{
		// meta/table.yaml line #308
		/* partial({'tables_dropped':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_dropped": 1})
		/* db.table_drop('c') */

		suite.T().Log("About to run line #308: db.TableDrop('c')")

		runAndAssert(suite.Suite, expected_, db.TableDrop("c"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #308")
	}

	{
		// meta/table.yaml line #312
		/* partial({'dbs_created':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"dbs_created": 1})
		/* r.db_create("test2") */

		suite.T().Log("About to run line #312: r.DBCreate('test2')")

		runAndAssert(suite.Suite, expected_, r.DBCreate("test2"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #312")
	}

	// meta/table.yaml line #315
	// db2 = r.db("test2")
	suite.T().Log("Possibly executing: var db2 r.Term = r.DB('test2')")

	db2 := r.DB("test2")
	_ = db2 // Prevent any noused variable errors

	{
		// meta/table.yaml line #317
		/* partial({'tables_created':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_created": 1})
		/* db.table_create("testA") */

		suite.T().Log("About to run line #317: db.TableCreate('testA')")

		runAndAssert(suite.Suite, expected_, db.TableCreate("testA"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #317")
	}

	{
		// meta/table.yaml line #319
		/* partial({'tables_created':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_created": 1})
		/* db.table_create("testB") */

		suite.T().Log("About to run line #319: db.TableCreate('testB')")

		runAndAssert(suite.Suite, expected_, db.TableCreate("testB"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #319")
	}

	{
		// meta/table.yaml line #321
		/* partial({'tables_created':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_created": 1})
		/* db2.table_create("test2B") */

		suite.T().Log("About to run line #321: db2.TableCreate('test2B')")

		runAndAssert(suite.Suite, expected_, db2.TableCreate("test2B"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #321")
	}

	{
		// meta/table.yaml line #324
		/* {'db':'test','name':'testA'} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"db": "db_mtable", "name": "testA"}
		/* r.table('testA').config().pluck('db','name') */

		suite.T().Log("About to run line #324: r.Table('testA').Config().Pluck('db', 'name')")

		runAndAssert(suite.Suite, expected_, db.Table("testA").Config().Pluck("db", "name"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #324")
	}

	{
		// meta/table.yaml line #327
		/* err('ReqlOpFailedError', 'Table `test.doesntexist` does not exist.', []) */
		var expected_ Err = err("ReqlOpFailedError", "Table `test.doesntexist` does not exist.")
		/* r.table('doesntexist').config() */

		suite.T().Log("About to run line #327: r.Table('doesntexist').Config()")

		runAndAssert(suite.Suite, expected_, r.Table("doesntexist").Config(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #327")
	}

	{
		// meta/table.yaml line #330
		/* err('ReqlOpFailedError', 'Table `test.test2B` does not exist.', []) */
		var expected_ Err = err("ReqlOpFailedError", "Table `test.test2B` does not exist.")
		/* r.table('test2B').config() */

		suite.T().Log("About to run line #330: r.Table('test2B').Config()")

		runAndAssert(suite.Suite, expected_, r.Table("test2B").Config(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #330")
	}

	{
		// meta/table.yaml line #333
		/* True */
		var expected_ bool = true
		/* r.db('rethinkdb').table('table_config').filter({'name':'testA'}).nth(0).eq(r.table('testA').config()) */

		suite.T().Log("About to run line #333: r.DB('rethinkdb').Table('table_config').Filter(map[interface{}]interface{}{'name': 'testA', }).Nth(0).Eq(r.Table('testA').Config())")

		runAndAssert(suite.Suite, expected_, r.DB("rethinkdb").Table("table_config").Filter(map[interface{}]interface{}{"name": "testA"}).Nth(0).Eq(db.Table("testA").Config()), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #333")
	}

	{
		// meta/table.yaml line #336
		/* True */
		var expected_ bool = true
		/* r.db('rethinkdb').table('table_status').filter({'name':'testA'}).nth(0).eq(r.table('testA').status()) */

		suite.T().Log("About to run line #336: r.DB('rethinkdb').Table('table_status').Filter(map[interface{}]interface{}{'name': 'testA', }).Nth(0).Eq(r.Table('testA').Status())")

		runAndAssert(suite.Suite, expected_, r.DB("rethinkdb").Table("table_status").Filter(map[interface{}]interface{}{"name": "testA"}).Nth(0).Eq(db.Table("testA").Status()), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #336")
	}

	{
		// meta/table.yaml line #339
		/* uuid() */
		var expected_ compare.Regex = compare.IsUUID()
		/* r.db('rethinkdb').table('table_config', identifier_format='uuid').nth(0)["db"] */

		suite.T().Log("About to run line #339: r.DB('rethinkdb').Table('table_config').OptArgs(r.TableOpts{IdentifierFormat: 'uuid', }).Nth(0).AtIndex('db')")

		runAndAssert(suite.Suite, expected_, r.DB("rethinkdb").Table("table_config").OptArgs(r.TableOpts{IdentifierFormat: "uuid"}).Nth(0).AtIndex("db"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #339")
	}

	{
		// meta/table.yaml line #344
		/* 0 */
		var expected_ int = 0
		/* r.table('testA', identifier_format='uuid').count() */

		suite.T().Log("About to run line #344: r.Table('testA').OptArgs(r.TableOpts{IdentifierFormat: 'uuid', }).Count()")

		runAndAssert(suite.Suite, expected_, db.Table("testA").OptArgs(r.TableOpts{IdentifierFormat: "uuid"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #344")
	}

	{
		// meta/table.yaml line #358
		/* partial({'tables_dropped':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_dropped": 1})
		/* db.table_drop('testA') */

		suite.T().Log("About to run line #358: db.TableDrop('testA')")

		runAndAssert(suite.Suite, expected_, db.TableDrop("testA"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #358")
	}

	{
		// meta/table.yaml line #361
		/* partial({'tables_dropped':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_dropped": 1})
		/* db.table_drop('testB') */

		suite.T().Log("About to run line #361: db.TableDrop('testB')")

		runAndAssert(suite.Suite, expected_, db.TableDrop("testB"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #361")
	}

	{
		// meta/table.yaml line #364
		/* partial({'dbs_dropped':1,'tables_dropped':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"dbs_dropped": 1, "tables_dropped": 1})
		/* r.db_drop('test2') */

		suite.T().Log("About to run line #364: r.DBDrop('test2')")

		runAndAssert(suite.Suite, expected_, r.DBDrop("test2"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #364")
	}
}
