//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/batch/armbatch/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// PrivateLinkResourceServer is a fake server for instances of the armbatch.PrivateLinkResourceClient type.
type PrivateLinkResourceServer struct {
	// Get is the fake for method PrivateLinkResourceClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, accountName string, privateLinkResourceName string, options *armbatch.PrivateLinkResourceClientGetOptions) (resp azfake.Responder[armbatch.PrivateLinkResourceClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByBatchAccountPager is the fake for method PrivateLinkResourceClient.NewListByBatchAccountPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByBatchAccountPager func(resourceGroupName string, accountName string, options *armbatch.PrivateLinkResourceClientListByBatchAccountOptions) (resp azfake.PagerResponder[armbatch.PrivateLinkResourceClientListByBatchAccountResponse])
}

// NewPrivateLinkResourceServerTransport creates a new instance of PrivateLinkResourceServerTransport with the provided implementation.
// The returned PrivateLinkResourceServerTransport instance is connected to an instance of armbatch.PrivateLinkResourceClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPrivateLinkResourceServerTransport(srv *PrivateLinkResourceServer) *PrivateLinkResourceServerTransport {
	return &PrivateLinkResourceServerTransport{
		srv:                        srv,
		newListByBatchAccountPager: newTracker[azfake.PagerResponder[armbatch.PrivateLinkResourceClientListByBatchAccountResponse]](),
	}
}

// PrivateLinkResourceServerTransport connects instances of armbatch.PrivateLinkResourceClient to instances of PrivateLinkResourceServer.
// Don't use this type directly, use NewPrivateLinkResourceServerTransport instead.
type PrivateLinkResourceServerTransport struct {
	srv                        *PrivateLinkResourceServer
	newListByBatchAccountPager *tracker[azfake.PagerResponder[armbatch.PrivateLinkResourceClientListByBatchAccountResponse]]
}

// Do implements the policy.Transporter interface for PrivateLinkResourceServerTransport.
func (p *PrivateLinkResourceServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PrivateLinkResourceClient.Get":
		resp, err = p.dispatchGet(req)
	case "PrivateLinkResourceClient.NewListByBatchAccountPager":
		resp, err = p.dispatchNewListByBatchAccountPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PrivateLinkResourceServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Batch/batchAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateLinkResources/(?P<privateLinkResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	privateLinkResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateLinkResourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), resourceGroupNameParam, accountNameParam, privateLinkResourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PrivateLinkResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateLinkResourceServerTransport) dispatchNewListByBatchAccountPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListByBatchAccountPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByBatchAccountPager not implemented")}
	}
	newListByBatchAccountPager := p.newListByBatchAccountPager.get(req)
	if newListByBatchAccountPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Batch/batchAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateLinkResources`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		maxresultsUnescaped, err := url.QueryUnescape(qp.Get("maxresults"))
		if err != nil {
			return nil, err
		}
		maxresultsParam, err := parseOptional(maxresultsUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armbatch.PrivateLinkResourceClientListByBatchAccountOptions
		if maxresultsParam != nil {
			options = &armbatch.PrivateLinkResourceClientListByBatchAccountOptions{
				Maxresults: maxresultsParam,
			}
		}
		resp := p.srv.NewListByBatchAccountPager(resourceGroupNameParam, accountNameParam, options)
		newListByBatchAccountPager = &resp
		p.newListByBatchAccountPager.add(req, newListByBatchAccountPager)
		server.PagerResponderInjectNextLinks(newListByBatchAccountPager, req, func(page *armbatch.PrivateLinkResourceClientListByBatchAccountResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByBatchAccountPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListByBatchAccountPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByBatchAccountPager) {
		p.newListByBatchAccountPager.remove(req)
	}
	return resp, nil
}
