/*
 * fhist - file history and comparison tools
 * Copyright (C) 2000, 2002, 2004, 2008, 2010, 2012 Peter Miller
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include <common/ac/stddef.h>
#include <common/ac/stdio.h>
#include <common/ac/sys/stat.h>
#include <libexplain/fflush.h>
#include <libexplain/fwrite.h>
#include <libexplain/putchar.h>

#include <common/fcheck.h>
#include <common/output/private.h>
#include <common/output/stdout.h>
#include <common/str.h>
#include <common/error_intl.h>


typedef struct output_stdout_ty output_stdout_ty;
struct output_stdout_ty
{
    output_ty       inherited;
};


static const char *
standard_output(void)
{
    return "standard output";
}


static void
destructor(output_ty *this)
{
    (void)this;
    explain_fflush_or_die(stdout);
}


static const char *
filename(output_ty *this)
{
    (void)this;
    return standard_output();
}


static long
otell(output_ty *this)
{
    (void)this;
    return ftell(stdout);
}


static void
oputc(output_ty *fp, int c)
{
    (void)fp;
    explain_putchar_or_die(c);
}


static void
owrite(output_ty *fp, const void *data, size_t len)
{
    (void)fp;
    explain_fwrite_or_die(data, 1, len, stdout);
}


static void
oflush(output_ty *this)
{
    (void)this;
    explain_fflush_or_die(stdout);
}


static output_vtbl_ty vtbl =
{
    sizeof(output_stdout_ty),
    destructor,
    filename,
    otell,
    oputc,
    output_generic_fputs,
    owrite,
    oflush,
    "stdout",
};


output_ty *
output_stdout(void)
{
    output_ty       *result;

    result = output_new(&vtbl);
    return result;
}


/* vim: set ts=8 sw=4 et : */
