/* doscan - Denial Of Service Capable Auditing of Networks
 * Copyright (C) 2003 Florian Weimer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef TICKS_H
#define TICKS_H

#include "config.h"

typedef uint32_t ticks_t;
/* Time is measured in milliseconds since call to ticks_init(). */

#define TICKS_LAST (0xFFFFFFFF)

void ticks_init (void);
/* Record the process-specific epoch value. */

ticks_t ticks_get (void);
/* Return current ticks, updates cache. */

ticks_t ticks_get_cached (void);
/* Return ticks from cache (but does not update it). */

typedef char ticks_string_t[70];

void ticks_to_string_local (ticks_t, ticks_string_t);
/* Converts a ticks value to its string representation, local time. */

void ticks_to_string_utc (ticks_t, ticks_string_t);
/* Converts a ticks value to its string representation, UTC. */

#endif
