#ifndef H_CDW_FS_BROWSER
#define H_CDW_FS_BROWSER





#include "cdw_list_display.h"
#include "cdw_file.h"
#include "cdw_ncurses.h"





typedef struct  {
	cdw_widget_t widget;

	int parent_begin_y;
	int parent_begin_x;
	int parent_n_lines;
	int parent_n_cols;

	CDW_LIST_DISPLAY *display;
} cdw_fs_browser_t;





#ifndef NDEBUG
#define cdw_fs_browser_debug_report_current_fullpath(macro_browser, macro_message) \
	{								\
		char *macro_f = cdw_fs_browser_get_current_fullpath(macro_browser); \
		cdw_vdm ("INFO: %s, current fullpath = \"%s\"\n", macro_message, macro_f); \
		free(macro_f);						\
		macro_f = (char *) NULL;				\
	}
#else
#define cdw_fs_browser_debug_report_current_fullpath(macro_browser, macro_message)
#endif





cdw_fs_browser_t *cdw_fs_browser_new(WINDOW *parent, char const * initial_fullpath);
void              cdw_fs_browser_delete(cdw_fs_browser_t **browser);
int               cdw_fs_browser_driver(cdw_fs_browser_t *browser);

int cdw_fs_browser_browse_to(cdw_fs_browser_t *browser, char const * fullpath);
int cdw_fs_browser_browse_into_dir(cdw_fs_browser_t *browser, char const * dirpath);
int cdw_fs_browser_browse_to_file(cdw_fs_browser_t *browser, char const * fullpath);

void cdw_fs_browser_add_return_keys(cdw_fs_browser_t *browser, ...);

cdw_file_t *cdw_fs_browser_get_current_file(cdw_fs_browser_t const * browser);
char       *cdw_fs_browser_get_current_dirpath(cdw_fs_browser_t const * browser);
char       *cdw_fs_browser_get_current_printable_dirpath(cdw_fs_browser_t *browser);
char       *cdw_fs_browser_get_current_fullpath(cdw_fs_browser_t *browser);

bool cdw_fs_browser_is_vscroll_key(int key);
bool cdw_fs_browser_is_fs_navigation_key(int key);
bool cdw_fs_browser_is_return_key(cdw_fs_browser_t *browser, int key);

void cdw_fs_browser_help_window(cdw_fs_browser_t *browser);





#endif /* #ifndef H_CDW_FS_BROWSER */
