dnl Che
dnl currently needed only by ffmpeg
dnl AC_FUNC_LRINTF([ACTION-IF-FOUND-LRINTF [, ACTION-IF-NOT-FOUND-LRINTF]])
dnl
AC_DEFUN([AC_FUNC_LRINTF],
[
    AC_CACHE_CHECK([whether system declares lrintf function in math.h],
		   ac_cv_val_have_lrintf,
		   [ac_save_CFLAGS=$CFLAGS
		   ac_save_LIBS=$LIBS
		   CFLAGS="$CFLAGS -O2"
		   LIBS="$LIBS -lm"
		   AC_RUN_IFELSE(AC_LANG_SOURCE([
		    #define _ISOC99_SOURCE  1
		    #include <math.h>
		    int main( void ) { return (lrintf(3.999f) > 0)?0:1; }]),
		    ac_cv_val_have_lrintf=yes, ac_cv_val_have_lrintf=no,
		    [ echo $ac_n "cross compiling; assumed OK... $ac_c" ])
		   CFLAGS=$ac_save_CFLAGS
		   LIBS=$ac_save_LIBS
		   ])
    if test "$ac_cv_val_have_lrintf" = yes; then
	ifelse([$1], , :, [$1])
    else
	ifelse([$2], , :, [$2])
    fi
])

dnl
dnl AC_CHECK_IPV6([ACTION-IF-FOUND-IPV6 [, ACTION-IF-NOT-FOUND-IPV6]])
dnl
AC_DEFUN([AC_CHECK_IPV6],
[
    AC_CACHE_CHECK([whether system supports IPv6],
		   ac_cv_val_have_ipv6,
		   AC_COMPILE_IFELSE(AC_LANG_PROGRAM([
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
		   ], [
  struct sockaddr_storage saddr;
  struct ipv6_mreq mreq6;
  getaddrinfo(0,0,0,0);
  getnameinfo(0,0,0,0,0,0,0);
  IN6_IS_ADDR_MULTICAST((const struct in6_addr *)0);
		   ]), ac_cv_val_have_ipv6=yes, ac_cv_val_have_ipv6=no)
		   )
    if test "$ac_cv_val_have_ipv6" = yes; then
	ifelse([$1], , :, [$1])
    else
	ifelse([$2], , :, [$2])
    fi
])

dnl Usage:
dnl AM_PATH_FFMPEG([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for ffmpeg, and define FFMPEG_CFLAGS and FFMPEG_LIBS

AC_DEFUN([AM_PATH_FFMPEG],
[
    AC_FUNC_LRINTF([
	AC_DEFINE(HAVE_LRINTF, 1, [Define if you have lrintf on your system.])
# HACK - add detection
	AC_DEFINE(HAVE_LLRINT, 1, [llrint])
	AC_DEFINE(HAVE_LRINT, 1, [lrint])
	AC_DEFINE(HAVE_LRINTF, 1, [lrint])
	AC_DEFINE(HAVE_ROUND, 1, [round])
	AC_DEFINE(HAVE_ROUNDF, 1, [roundf])
	AC_DEFINE(HAVE_TRUNCF, 1, [roundf])
    ])

    AC_CHECK_FUNCS(mkstemp)

    AC_CHECK_ALIGN_POWER([
	AC_DEFINE(ASMALIGN(ZEROBITS), [".align " #ZEROBITS "\n\t"],
		   [ffmpeg Define if your .align arg is power-of-two.])],[
	AC_DEFINE(ASMALIGN(ZEROBITS), [".align 1<<" #ZEROBITS "\n\t"],
		   [ffmpeg Define if your .align arg is not power-of-two.])
    ])

    AC_CACHE_CHECK([for socklen_t], ac_cv_val_socklen_t,
	AC_COMPILE_IFELSE(AC_LANG_PROGRAM([#include <sys/socket.h>], [ socklen_t slen ]),
	 ac_cv_val_socklen_t=yes, ac_cv_val_socklen_t=no)
    )
    if test "$ac_cv_val_socklen_t" = yes; then
	AC_DEFINE(HAVE_SOCKLEN_T, 1, [Define if you have socklen_t in <sys/socket.h> header file.])
    fi

    AC_CHECK_RESTRICT_KEYWORD(AC_DEFINE_UNQUOTED(restrict, $have_restrict_keyword, [Define restrict keyword.]))

    AC_CHECK_HEADERS(poll.h termios.h conio.h sys/resource.h)

    dnl !!! - it really sucks - Makefile.am can not be optimized even by
    dnl !!! preparing some extra variable forward
    dnl !!! FFAVFORMAT_SRC=

    ac_enablef_mmx=0
    ac_enablef_arm=0
    ac_enablef_mlib=0
    ac_enablef_vis=0
    ac_enablef_sparc=0
    ac_enablef_alpha=0
    ac_enablef_ppc=0
    ac_enablef_mmi=0
    ac_enablef_sh4=0
    ac_enablef_bfin=0
    case "$target" in
	i?86*|ia64*|x86_64*|amd64*) ac_enablef_mmx=1 ;;
	alpha*) ac_enablef_alpha=1 ;;
	arm*) ac_enablef_arm=1 ;;
	sparc*) ac_enablef_vis=1 ;;
	mips*) ac_enablef_mmi=1 ;;
	ppc*|powerpc*) ac_enablef_ppc=1 ;;
    esac

    AC_DEFINE_UNQUOTED(HAVE_MMX, $ac_enablef_mmx, [ffmpeg])
    AC_DEFINE_UNQUOTED(HAVE_SSE, $ac_enablef_mmx, [ffmpeg])
    AC_DEFINE_UNQUOTED(ARCH_ARM, $ac_enablef_arm, [ffmpeg])
    AC_DEFINE_UNQUOTED(CONFIG_MLIB, $ac_enablef_mlib, [ffmpeg])
    AC_DEFINE_UNQUOTED(HAVE_VIS, $ac_enablef_vis, [ffmpeg])
    AC_DEFINE_UNQUOTED(ARCH_ALPHA, $ac_enablef_alpha, [ffmpeg])
    AC_DEFINE_UNQUOTED(ARCH_PPC, $ac_enablef_ppc, [ffmpeg])
    AC_DEFINE_UNQUOTED(HAVE_MMI, $ac_enablef_mmi, [ffmpeg])
    AC_DEFINE_UNQUOTED(ARCH_SH4, $ac_enablef_sh4, [ffmpeg])
    AC_DEFINE_UNQUOTED(ARCH_BFIN, $ac_enablef_bfin, [ffmpeg])

dnl these should be checked
    AC_DEFINE(HAVE_EBX_AVAILABLE, 0, [ffmpeg])
    AC_DEFINE(HAVE_EBP_AVAILABLE, 0, [ffmpeg])
dnl AC_DEFINE(BROKEN_RELOCATION, 1, [ffmpeg])
    AC_DEFINE(HAVE_CMOV, 1, [ffmpeg])
    AC_DEFINE(HAVE_FAST_CMOV, 1, [ffmpeg])

    AC_DEFINE(CONFIG_ENCODERS, 1, [ffmpeg Define if you want to build encoders.])
    AC_DEFINE(CONFIG_DECODERS, 1, [ffmpeg Define if you want to build decoders.])
    AC_DEFINE(CONFIG_MUXERS, 1, [ffmpeg Define if you want to build muxers.])
    AC_DEFINE(CONFIG_DEMUXERS, 1, [ffmpeg Define if you want to build demuxers.])
    AC_DEFINE(CONFIG_SMALL, 0, [ffmpeg Define if you want to optimize for size.])
    AC_DEFINE(CONFIG_GRAY, 0, [ffmpeg Define if you want to full grayscale support.])

dnl GPL
    AC_ARG_ENABLE(ffmpeg_gpl, [  --disable-ffmpeg-gpl	disable GPL code in ffmpeg. [[enabled]]],
		  [], enable_ffmpeg_gpl=yes)
    if test "$enable_ffmpeg_gpl" = yes; then
	AC_DEFINE(CONFIG_GPL, 1, [ffmpeg])
    fi
    AC_DEFINE(RUNTIME_CPUDETECT, 1, [ffmpeg for libpostprocess and libswscale])

dnl SMALL
    AC_ARG_ENABLE(ffmpeg_small, [  --enable-ffmpeg-small   optimize ffmpeg for size. [[disabled]]],
		  [], enable_ffmpeg_small=no)
    if test "$enable_ffmpeg_small" = yes; then
	ac_enablef_small=1
    else
	ac_enablef_small=0
    fi
    AC_DEFINE_UNQUOTED(ENABLE_SMALL, $ac_enablef_small, [ffmpeg])

dnl GRAY
    AC_ARG_ENABLE(ffmpeg_gray, [  --enable-ffmpeg-gray	 enable full grayscale support (slower color). [[disabled]]],
		  [], enable_ffmpeg_gray=no)
    if test "$enable_ffmpeg_gray" = yes; then
	ac_enablef_gray=1
    else
	ac_enablef_gray=0
    fi
    AC_DEFINE_UNQUOTED(ENABLE_GRAY, $ac_enablef_gray, [ffmpeg])

dnl THREADS
    AC_ARG_ENABLE(ffmpeg_threads, [  --disable-ffmpeg-threads	support threads in ffmpeg. [[enabled]]],
		  [], enable_ffmpeg_threads=yes)
    if test "$enable_ffmpeg_threads" = yes; then
	AC_DEFINE(HAVE_THREADS, 1, [ffmpeg Define if you want to use threads.])
    fi

dnl DV1394
    AC_ARG_ENABLE(ffmpeg_dv1394, [  --disable-ffmpeg-dv1394 disable ffmpeg DV1394 support. [[enabled]]],
		  [], enable_ffmpeg_dv1394=yes)
    if test "$enable_ffmpeg_dv1394" = yes; then
	enablef_dv1394=1
    else
	enablef_dv1394=0
    fi
    AC_DEFINE_UNQUOTED(CONFIG_DV1394_DEMUXER, $enablef_dv1394, [ffmpeg Define if you want to have DV1394 support compiled.])

dnl LIBDC1394
    AC_ARG_ENABLE(ffmpeg_dc1394, [  --enable-ffmpeg-dc1394 ffmpeg DC1394 support. [[disabled]]],
		  [], enable_ffmpeg_dc1394=no)
    enablef_dc1394=0
    if test "$enable_ffmpeg_dc1394" = yes; then
	AM_PATH_DC1394([enablef_dc1394=1], [])
    fi
    AC_DEFINE_UNQUOTED(CONFIG_LIBDC1394_DEMUXER, $enablef_dc1394, [ffmpeg Define if you want to have DV1394 support compiled.])

dnl LIBFAAD
    AC_REQUIRE([AM_PATH_FAAD])
    if test "$have_faad" = yes; then
	enablef_aac=1
dnl fix ffmpeg - mov.c needs libfaad
	AC_ARG_ENABLE(ffmpeg_faadbin, [  --disable-ffmpeg-faadbin do not build ffmpeg with FAAD bin.support. [[enabled]]],
		      [], enable_ffmpeg_faadbin=yes)
	if test "$enable_ffmpeg_faadbin" = yes; then
	    AC_DEFINE(CONFIG_LIBFAADBIN, 1, [ffmpeg Define if you want to build support for runtime linked libfaad.])
	fi
    else
	enablef_aac=0
    fi
    AC_DEFINE_UNQUOTED(CONFIG_LIBFAAD_DECODER, $enablef_aac, [ffmpeg Define if you want to have LibFAAD decoder compiled.])

dnl OpenJPEG
    AC_ARG_ENABLE(ffmpeg_openjpeg, [  --enable-ffmpeg-openjpeg ffmpeg OpenJPEG support. [[disabled]]],
		  [], enable_ffmpeg_openjpeg=no)
    enablef_openjpeg=0
    if test "$enable_ffmpeg_openjpeg" = yes; then
dnl	AM_PATH_OPENJPEG([enablef_openjpeg=1], [])
	enablef_openjpeg=1
    fi
    AC_DEFINE_UNQUOTED(CONFIG_LIBOPENJPEG_DECODER, $enablef_openjpeg, [ffmpeg Define if you want to have OpenJPEG decoder.])

dnl OSS audio
    AC_REQUIRE([AC_CHECK_OSS])
    if test "$enable_oss" = yes; then
	enablef_audio=1
    else
	enablef_audio=0
    fi
    AC_DEFINE_UNQUOTED(CONFIG_OSS_DEMUXER, $enablef_audio, [ffmpeg Define if you want to have OSS audio demuxer.])
    AC_DEFINE_UNQUOTED(CONFIG_OSS_MUXER, $enablef_audio, [ffmpeg Define if you want to have OSS audio demuxer.])

dnl UNUSED!!!
    AC_ARG_ENABLE(ffmpeg_pp, [	--disable-ffmpeg-pp	disable postprocessing support in ffmpeg. [[enabled]]],
		  [], enable_ffmpeg_pp=yes)
    if test "$enable_ffmpeg_pp" = yes; then
	AC_DEFINE(CONFIG_PP, 1, [ffmpeg Define if you want to build with PP support.])
    fi

    AC_ARG_ENABLE(ffmpeg_swscaler, [  --enable-ffmpeg-swscaler build ffmpeg with SWScaler. [[disabled]]],
		  [], enable_ffmpeg_swscaler=no)
    if test "$enable_ffmpeg_swscaler" = yes; then
	AC_DEFINE(CONFIG_SWSCALER, 1, [ffmpeg Define if you want to build with SWScaler.])
    fi

    AC_ARG_ENABLE(ffmpeg_mpegaudiohp, [  --disable-ffmpeg-mpegaudiohp build ffmpeg with MPEG HighPrecision. [[enabled]]],
		  [], enable_ffmpeg_mpegaudiohp=yes)
    if test "$enable_ffmpeg_mpegaudiohp" = yes; then
	AC_DEFINE(CONFIG_MPEGAUDIO_HP, 1, [ffmpeg Define if you want to have highprecision mpeg audio support compiled.])
    fi

    AC_REQUIRE([AC_CHECK_V4L])
    if test "$enable_v4l" = yes; then
	AC_DEFINE(CONFIG_VIDEO4LINUX, 1, [ffmpeg Define if you have video4linux device.])
    fi

    AC_REQUIRE([AC_CHECK_V4L2])
    if test "$enable_v4l2" = yes; then
	AC_DEFINE(CONFIG_VIDEO4LINUX2, 1, [ffmpeg Define if you have video4linux2 device.])
    fi

    AC_ARG_ENABLE(ffmpeg_network, [  --disable-ffmpeg-network disable network support. [[enabled]]],
		  [], enable_ffmpeg_network=yes)
    if test "$enable_ffmpeg_network" = yes; then
	AC_DEFINE(CONFIG_NETWORK, 1, [ffmpeg Define if you want to build with network support.])
    fi

    AC_CHECK_IPV6([
       if test "$enable_ffmpeg_network" = yes; then
	    AC_DEFINE(CONFIG_IPV6, 1, [ffmpeg Define if you want to build with IPv6 support.])
       fi], [])

    AC_ARG_ENABLE(ffmpeg_protocol, [  --disable-ffmpeg-protocol disable ffmpeg protocol support. [[enabled]]],
		  [], enable_ffmpeg_protocol=yes)
    if test "$enable_ffmpeg_protocol" = yes; then
	AC_DEFINE(CONFIG_PROTOCOLS, 1, [ffmpeg Define if you want to build with protocols registered.])
    fi

    AC_REQUIRE([AC_FIND_ZLIB])
    if	test "$have_zlib" = yes; then
	enablef_zlib=1
	AC_DEFINE(CONFIG_ZLIB, 1, [ffmpeg Define if you have z library (-lz)])
    else
	enablef_zlib=0
    fi

    AC_DEFINE_UNQUOTED(CONFIG_DXA_DECODER, $enablef_zlib, [ffmpeg])
    AC_DEFINE_UNQUOTED(CONFIG_FLASHSV_DECODER, $enablef_zlib, [ffmpeg])
    AC_DEFINE_UNQUOTED(CONFIG_FLASHSV_ENCODER, $enablef_zlib, [ffmpeg])
    AC_DEFINE_UNQUOTED(CONFIG_PNG_DECODER, $enablef_zlib, [ffmpeg])
    AC_DEFINE_UNQUOTED(CONFIG_PNG_ENCODER, $enablef_zlib, [ffmpeg])
    AC_DEFINE_UNQUOTED(CONFIG_TSCC_DECODER, $enablef_zlib, [ffmpeg])
    AC_DEFINE_UNQUOTED(CONFIG_ZMBV_DECODER, $enablef_zlib, [ffmpeg])
    AC_DEFINE_UNQUOTED(CONFIG_ZMBV_ENCODER, $enablef_zlib, [ffmpeg])

    AC_DEFINE(CONFIG_FFSERVER, 1, [ffmpeg Define if you want to build server.])

    AC_DEFINE(SIMPLE_IDCT, 1, [ffmpeg Define if you want to build with simples idct.])
    AC_DEFINE(HAVE_PTHREADS, 1, [ffmpeg Define if you want to have pthread support compiled.])
    AC_DEFINE_UNQUOTED(EXTERN_PREFIX, "", [ffmpeg Define for extern prefix.])

    AC_CHECK_GNU_VECTOR(FFMPEG_OPTFLAGS="$FFMPEG_OPTFLAGS -msse";
			AC_DEFINE(HAVE_BUILTIN_VECTOR, 1, [ffmpeg Define if your compiler supports vector builtins (MMX).]), [])
    AC_SUBST(FFMPEG_OPTFLAGS)

    case "$target" in
    i?86*) FFMPEG_PREFERNONPIC="-prefer-non-pic" ;;
    *)	   FFMPEG_PREFERNONPIC="" ;;
    esac
    AC_SUBST(FFMPEG_PREFERNONPIC)

    AC_SUBST(FFMPEG_CFLAGS)
    AC_SUBST(FFMPEG_LIBS)

dnl ffmpeg_x86opt=
dnl test x$enable_x86opt = xno && ffmpeg_x86opt="--disable-mmx"
dnl AC_MSG_RESULT([=== configuring ffmpeg ===])
dnl    ( cd $srcdir/ffmpeg ; \
dnl	 ./configure --prefix=$prefix --cc=$CC \
dnl		$ffmpeg_cpu \
dnl		$ffmpeg_x86opt --disable-mp3lib \
dnl		--enable-simple_idct )
])
