/*
    $Id: unicodedata.c 2947 2022-12-29 12:36:12Z soci $

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

#include "unicodedata.h"

const int16_t usequences[2073] = {
    0, 65, -768, 65, -769, 65, -770, 65,
    -771, 65, -776, 65, -778, 67, -807, 69,
    -768, 69, -769, 69, -770, 69, -776, 73,
    -768, 73, -769, 73, -770, 73, -776, 78,
    -771, 79, -768, 79, -769, 79, -770, 79,
    -771, 79, -776, 85, -768, 85, -769, 85,
    -770, 85, -776, 89, -769, 97, -768, 97,
    -769, 97, -770, 97, -771, 97, -776, 97,
    -778, 99, -807, 101, -768, 101, -769, 101,
    -770, 101, -776, 105, -768, 105, -769, 105,
    -770, 105, -776, 110, -771, 111, -768, 111,
    -769, 111, -770, 111, -771, 111, -776, 117,
    -768, 117, -769, 117, -770, 117, -776, 121,
    -769, 121, -776, 65, -772, 97, -772, 65,
    -774, 97, -774, 65, -808, 97, -808, 67,
    -769, 99, -769, 67, -770, 99, -770, 67,
    -775, 99, -775, 67, -780, 99, -780, 68,
    -780, 100, -780, 69, -772, 101, -772, 69,
    -774, 101, -774, 69, -775, 101, -775, 69,
    -808, 101, -808, 69, -780, 101, -780, 71,
    -770, 103, -770, 71, -774, 103, -774, 71,
    -775, 103, -775, 71, -807, 103, -807, 72,
    -770, 104, -770, 73, -771, 105, -771, 73,
    -772, 105, -772, 73, -774, 105, -774, 73,
    -808, 105, -808, 73, -775, 74, -770, 106,
    -770, 75, -807, 107, -807, 76, -769, 108,
    -769, 76, -807, 108, -807, 76, -780, 108,
    -780, 78, -769, 110, -769, 78, -807, 110,
    -807, 78, -780, 110, -780, 79, -772, 111,
    -772, 79, -774, 111, -774, 79, -779, 111,
    -779, 82, -769, 114, -769, 82, -807, 114,
    -807, 82, -780, 114, -780, 83, -769, 115,
    -769, 83, -770, 115, -770, 83, -807, 115,
    -807, 83, -780, 115, -780, 84, -807, 116,
    -807, 84, -780, 116, -780, 85, -771, 117,
    -771, 85, -772, 117, -772, 85, -774, 117,
    -774, 85, -778, 117, -778, 85, -779, 117,
    -779, 85, -808, 117, -808, 87, -770, 119,
    -770, 89, -770, 121, -770, 89, -776, 90,
    -769, 122, -769, 90, -775, 122, -775, 90,
    -780, 122, -780, 79, -795, 111, -795, 85,
    -795, 117, -795, 65, -780, 97, -780, 73,
    -780, 105, -780, 79, -780, 111, -780, 85,
    -780, 117, -780, 220, -772, 252, -772, 220,
    -769, 252, -769, 220, -780, 252, -780, 220,
    -768, 252, -768, 196, -772, 228, -772, 550,
    -772, 551, -772, 198, -772, 230, -772, 71,
    -780, 103, -780, 75, -780, 107, -780, 79,
    -808, 111, -808, 490, -772, 491, -772, 439,
    -780, 658, -780, 106, -780, 71, -769, 103,
    -769, 78, -768, 110, -768, 197, -769, 229,
    -769, 198, -769, 230, -769, 216, -769, 248,
    -769, 65, -783, 97, -783, 65, -785, 97,
    -785, 69, -783, 101, -783, 69, -785, 101,
    -785, 73, -783, 105, -783, 73, -785, 105,
    -785, 79, -783, 111, -783, 79, -785, 111,
    -785, 82, -783, 114, -783, 82, -785, 114,
    -785, 85, -783, 117, -783, 85, -785, 117,
    -785, 83, -806, 115, -806, 84, -806, 116,
    -806, 72, -780, 104, -780, 65, -775, 97,
    -775, 69, -807, 101, -807, 214, -772, 246,
    -772, 213, -772, 245, -772, 79, -775, 111,
    -775, 558, -772, 559, -772, 89, -772, 121,
    -772, 776, -769, 168, -769, 913, -769, 917,
    -769, 919, -769, 921, -769, 927, -769, 933,
    -769, 937, -769, 970, -769, 921, -776, 933,
    -776, 945, -769, 949, -769, 951, -769, 953,
    -769, 971, -769, 953, -776, 965, -776, 959,
    -769, 965, -769, 969, -769, 978, -769, 978,
    -776, 1045, -768, 1045, -776, 1043, -769, 1030,
    -776, 1050, -769, 1048, -768, 1059, -774, 1048,
    -774, 1080, -774, 1077, -768, 1077, -776, 1075,
    -769, 1110, -776, 1082, -769, 1080, -768, 1091,
    -774, 1140, -783, 1141, -783, 1046, -774, 1078,
    -774, 1040, -774, 1072, -774, 1040, -776, 1072,
    -776, 1045, -774, 1077, -774, 1240, -776, 1241,
    -776, 1046, -776, 1078, -776, 1047, -776, 1079,
    -776, 1048, -772, 1080, -772, 1048, -776, 1080,
    -776, 1054, -776, 1086, -776, 1256, -776, 1257,
    -776, 1069, -776, 1101, -776, 1059, -772, 1091,
    -772, 1059, -776, 1091, -776, 1059, -779, 1091,
    -779, 1063, -776, 1095, -776, 1067, -776, 1099,
    -776, 1575, -1619, 1575, -1620, 1608, -1620, 1575,
    -1621, 1610, -1620, 1749, -1620, 1729, -1620, 1746,
    -1620, 2344, -2364, 2352, -2364, 2355, -2364, 2325,
    -2364, 2326, -2364, 2327, -2364, 2332, -2364, 2337,
    -2364, 2338, -2364, 2347, -2364, 2351, -2364, 2503,
    -2494, 2503, -2519, 2465, -2492, 2466, -2492, 2479,
    -2492, 2610, -2620, 2616, -2620, 2582, -2620, 2583,
    -2620, 2588, -2620, 2603, -2620, 2887, -2902, 2887,
    -2878, 2887, -2903, 2849, -2876, 2850, -2876, 2962,
    -3031, 3014, -3006, 3015, -3006, 3014, -3031, 3142,
    -3158, 3263, -3285, 3270, -3285, 3270, -3286, 3270,
    -3266, 3274, -3285, 3398, -3390, 3399, -3390, 3398,
    -3415, 3545, -3530, 3545, -3535, 3548, -3530, 3545,
    -3551, 3906, -4023, 3916, -4023, 3921, -4023, 3926,
    -4023, 3931, -4023, 3904, -4021, 3953, -3954, 3953,
    -3956, 4018, -3968, 4019, -3968, 3953, -3968, 3986,
    -4023, 3996, -4023, 4001, -4023, 4006, -4023, 4011,
    -4023, 3984, -4021, 4133, -4142, 6917, -6965, 6919,
    -6965, 6921, -6965, 6923, -6965, 6925, -6965, 6929,
    -6965, 6970, -6965, 6972, -6965, 6974, -6965, 6975,
    -6965, 6978, -6965, 65, -805, 97, -805, 66,
    -775, 98, -775, 66, -803, 98, -803, 66,
    -817, 98, -817, 199, -769, 231, -769, 68,
    -775, 100, -775, 68, -803, 100, -803, 68,
    -817, 100, -817, 68, -807, 100, -807, 68,
    -813, 100, -813, 274, -768, 275, -768, 274,
    -769, 275, -769, 69, -813, 101, -813, 69,
    -816, 101, -816, 552, -774, 553, -774, 70,
    -775, 102, -775, 71, -772, 103, -772, 72,
    -775, 104, -775, 72, -803, 104, -803, 72,
    -776, 104, -776, 72, -807, 104, -807, 72,
    -814, 104, -814, 73, -816, 105, -816, 207,
    -769, 239, -769, 75, -769, 107, -769, 75,
    -803, 107, -803, 75, -817, 107, -817, 76,
    -803, 108, -803, 7734, -772, 7735, -772, 76,
    -817, 108, -817, 76, -813, 108, -813, 77,
    -769, 109, -769, 77, -775, 109, -775, 77,
    -803, 109, -803, 78, -775, 110, -775, 78,
    -803, 110, -803, 78, -817, 110, -817, 78,
    -813, 110, -813, 213, -769, 245, -769, 213,
    -776, 245, -776, 332, -768, 333, -768, 332,
    -769, 333, -769, 80, -769, 112, -769, 80,
    -775, 112, -775, 82, -775, 114, -775, 82,
    -803, 114, -803, 7770, -772, 7771, -772, 82,
    -817, 114, -817, 83, -775, 115, -775, 83,
    -803, 115, -803, 346, -775, 347, -775, 352,
    -775, 353, -775, 7778, -775, 7779, -775, 84,
    -775, 116, -775, 84, -803, 116, -803, 84,
    -817, 116, -817, 84, -813, 116, -813, 85,
    -804, 117, -804, 85, -816, 117, -816, 85,
    -813, 117, -813, 360, -769, 361, -769, 362,
    -776, 363, -776, 86, -771, 118, -771, 86,
    -803, 118, -803, 87, -768, 119, -768, 87,
    -769, 119, -769, 87, -776, 119, -776, 87,
    -775, 119, -775, 87, -803, 119, -803, 88,
    -775, 120, -775, 88, -776, 120, -776, 89,
    -775, 121, -775, 90, -770, 122, -770, 90,
    -803, 122, -803, 90, -817, 122, -817, 104,
    -817, 116, -776, 119, -778, 121, -778, 383,
    -775, 65, -803, 97, -803, 65, -777, 97,
    -777, 194, -769, 226, -769, 194, -768, 226,
    -768, 194, -777, 226, -777, 194, -771, 226,
    -771, 7840, -770, 7841, -770, 258, -769, 259,
    -769, 258, -768, 259, -768, 258, -777, 259,
    -777, 258, -771, 259, -771, 7840, -774, 7841,
    -774, 69, -803, 101, -803, 69, -777, 101,
    -777, 69, -771, 101, -771, 202, -769, 234,
    -769, 202, -768, 234, -768, 202, -777, 234,
    -777, 202, -771, 234, -771, 7864, -770, 7865,
    -770, 73, -777, 105, -777, 73, -803, 105,
    -803, 79, -803, 111, -803, 79, -777, 111,
    -777, 212, -769, 244, -769, 212, -768, 244,
    -768, 212, -777, 244, -777, 212, -771, 244,
    -771, 7884, -770, 7885, -770, 416, -769, 417,
    -769, 416, -768, 417, -768, 416, -777, 417,
    -777, 416, -771, 417, -771, 416, -803, 417,
    -803, 85, -803, 117, -803, 85, -777, 117,
    -777, 431, -769, 432, -769, 431, -768, 432,
    -768, 431, -777, 432, -777, 431, -771, 432,
    -771, 431, -803, 432, -803, 89, -768, 121,
    -768, 89, -803, 121, -803, 89, -777, 121,
    -777, 89, -771, 121, -771, 945, -787, 945,
    -788, 7936, -768, 7937, -768, 7936, -769, 7937,
    -769, 7936, -834, 7937, -834, 913, -787, 913,
    -788, 7944, -768, 7945, -768, 7944, -769, 7945,
    -769, 7944, -834, 7945, -834, 949, -787, 949,
    -788, 7952, -768, 7953, -768, 7952, -769, 7953,
    -769, 917, -787, 917, -788, 7960, -768, 7961,
    -768, 7960, -769, 7961, -769, 951, -787, 951,
    -788, 7968, -768, 7969, -768, 7968, -769, 7969,
    -769, 7968, -834, 7969, -834, 919, -787, 919,
    -788, 7976, -768, 7977, -768, 7976, -769, 7977,
    -769, 7976, -834, 7977, -834, 953, -787, 953,
    -788, 7984, -768, 7985, -768, 7984, -769, 7985,
    -769, 7984, -834, 7985, -834, 921, -787, 921,
    -788, 7992, -768, 7993, -768, 7992, -769, 7993,
    -769, 7992, -834, 7993, -834, 959, -787, 959,
    -788, 8000, -768, 8001, -768, 8000, -769, 8001,
    -769, 927, -787, 927, -788, 8008, -768, 8009,
    -768, 8008, -769, 8009, -769, 965, -787, 965,
    -788, 8016, -768, 8017, -768, 8016, -769, 8017,
    -769, 8016, -834, 8017, -834, 933, -788, 8025,
    -768, 8025, -769, 8025, -834, 969, -787, 969,
    -788, 8032, -768, 8033, -768, 8032, -769, 8033,
    -769, 8032, -834, 8033, -834, 937, -787, 937,
    -788, 8040, -768, 8041, -768, 8040, -769, 8041,
    -769, 8040, -834, 8041, -834, 945, -768, 949,
    -768, 951, -768, 953, -768, 959, -768, 965,
    -768, 969, -768, 7936, -837, 7937, -837, 7938,
    -837, 7939, -837, 7940, -837, 7941, -837, 7942,
    -837, 7943, -837, 7944, -837, 7945, -837, 7946,
    -837, 7947, -837, 7948, -837, 7949, -837, 7950,
    -837, 7951, -837, 7968, -837, 7969, -837, 7970,
    -837, 7971, -837, 7972, -837, 7973, -837, 7974,
    -837, 7975, -837, 7976, -837, 7977, -837, 7978,
    -837, 7979, -837, 7980, -837, 7981, -837, 7982,
    -837, 7983, -837, 8032, -837, 8033, -837, 8034,
    -837, 8035, -837, 8036, -837, 8037, -837, 8038,
    -837, 8039, -837, 8040, -837, 8041, -837, 8042,
    -837, 8043, -837, 8044, -837, 8045, -837, 8046,
    -837, 8047, -837, 945, -774, 945, -772, 8048,
    -837, 945, -837, 940, -837, 945, -834, 8118,
    -837, 913, -774, 913, -772, 913, -768, 913,
    -837, 168, -834, 8052, -837, 951, -837, 942,
    -837, 951, -834, 8134, -837, 917, -768, 919,
    -768, 919, -837, 8127, -768, 8127, -769, 8127,
    -834, 953, -774, 953, -772, 970, -768, 953,
    -834, 970, -834, 921, -774, 921, -772, 921,
    -768, 8190, -768, 8190, -769, 8190, -834, 965,
    -774, 965, -772, 971, -768, 961, -787, 961,
    -788, 965, -834, 971, -834, 933, -774, 933,
    -772, 933, -768, 929, -788, 168, -768, 8060,
    -837, 969, -837, 974, -837, 969, -834, 8182,
    -837, 927, -768, 937, -768, 937, -837, 8592,
    -824, 8594, -824, 8596, -824, 8656, -824, 8660,
    -824, 8658, -824, 8707, -824, 8712, -824, 8715,
    -824, 8739, -824, 8741, -824, 8764, -824, 8771,
    -824, 8773, -824, 8776, -824, 61, -824, 8801,
    -824, 8781, -824, 60, -824, 62, -824, 8804,
    -824, 8805, -824, 8818, -824, 8819, -824, 8822,
    -824, 8823, -824, 8826, -824, 8827, -824, 8834,
    -824, 8835, -824, 8838, -824, 8839, -824, 8866,
    -824, 8872, -824, 8873, -824, 8875, -824, 8828,
    -824, 8829, -824, 8849, -824, 8850, -824, 8882,
    -824, 8883, -824, 8884, -824, 8885, -824, 10973,
    -824, 12363, -12441, 12365, -12441, 12367, -12441, 12369,
    -12441, 12371, -12441, 12373, -12441, 12375, -12441, 12377,
    -12441, 12379, -12441, 12381, -12441, 12383, -12441, 12385,
    -12441, 12388, -12441, 12390, -12441, 12392, -12441, 12399,
    -12441, 12399, -12442, 12402, -12441, 12402, -12442, 12405,
    -12441, 12405, -12442, 12408, -12441, 12408, -12442, 12411,
    -12441, 12411, -12442, 12358, -12441, 12445, -12441, 12459,
    -12441, 12461, -12441, 12463, -12441, 12465, -12441, 12467,
    -12441, 12469, -12441, 12471, -12441, 12473, -12441, 12475,
    -12441, 12477, -12441, 12479, -12441, 12481, -12441, 12484,
    -12441, 12486, -12441, 12488, -12441, 12495, -12441, 12495,
    -12442, 12498, -12441, 12498, -12442, 12501, -12441, 12501,
    -12442, 12504, -12441, 12504, -12442, 12507, -12441, 12507,
    -12442, 12454, -12441, 12527, -12441, 12528, -12441, 12529,
    -12441, 12530, -12441, 12541, -12441, 1497, -1460, 1522,
    -1463, 1513, -1473, 1513, -1474, 1488, -1463, 1488,
    -1464, 1488, -1468, 1489, -1468, 1490, -1468, 1491,
    -1468, 1492, -1468, 1493, -1468, 1494, -1468, 1496,
    -1468, 1497, -1468, 1498, -1468, 1499, -1468, 1500,
    -1468, 1502, -1468, 1504, -1468, 1505, -1468, 1507,
    -1468, 1508, -1468, 1510, -1468, 1511, -1468, 1512,
    -1468, 1513, -1468, 1514, -1468, 1493, -1465, 1489,
    -1471, 1499, -1471, 1508, -1471, 115, -115, 105,
    -775, 7936, -953, 7937, -953, 7938, -953, 7939,
    -953, 7940, -953, 7941, -953, 7942, -953, 7943,
    -953, 7968, -953, 7969, -953, 7970, -953, 7971,
    -953, 7972, -953, 7973, -953, 7974, -953, 7975,
    -953, 8032, -953, 8033, -953, 8034, -953, 8035,
    -953, 8036, -953, 8037, -953, 8038, -953, 8039,
    -953, 8048, -953, 945, -953, 940, -953, 8118,
    -953, 8052, -953, 951, -953, 942, -953, 8134,
    -953, 8060, -953, 969, -953, 974, -953, 8182,
    -953,
};

const int32_t usequences2[393] = {
    0, -35912, -36554, -36040, -40860, -37329, -34367, -34746,
    -35064, -37007, -33853, -37226, -39409, -34349, -40478, -34253,
    -35172, -33240, -34847, -37070, -32769, -34310, -34396, -36335,
    -38706, -39791, -40442, -33737, -37636, -40575, -35542, -32894,
    -36034, -38647, -38475, -32907, -33777, -38517, -35712, -35582,
    -33865, -35498, -36784, -33509, -33391, -35538, -37327, -38317,
    -39530, -40599, -40654, -36706, -32879, -36646, -34030, -36899,
    -37706, -35010, -32838, -37428, -38646, -38728, -38936, -37300,
    -38584, -34044, -36988, -40845, -38446, -39006, -38520, -36650,
    -38534, -35023, -35041, -37324, -38626, -34298, -38563, -40023,
    -40607, -33256, -35672, -33590, -36667, -34892, -38477, -35211,
    -38742, -34322, -35576, -36920, -37117, -39151, -39164, -39208,
    -40372, -37086, -38583, -32773, -33261, -33401, -33879, -35088,
    -35222, -35585, -35641, -36051, -36104, -36790, -38627, -38911,
    -38971, -148206, -33304, -33618, -33775, -34681, -35137, -35206,
    -35519, -35531, -35565, -35722, -36664, -36978, -37273, -37494,
    -38524, -38875, -38923, -39698, -141386, -141380, -144341, -152137,
    -154832, -163539, -40771, -40846, 64329, -1473, 64329, -1474,
    69785, -69818, 69787, -69818, 69797, -69818, 69937, -69927,
    69938, -69927, 70471, -70462, 70471, -70487, 70841, -70842,
    70841, -70832, 70841, -70845, 71096, -71087, 71097, -71087,
    71989, -71984, 119127, -119141, 119128, -119141, 119135, -119150,
    119135, -119151, 119135, -119152, 119135, -119153, 119135, -119154,
    119225, -119141, 119226, -119141, 119227, -119150, 119228, -119150,
    119227, -119151, 119228, -119151, -131362, -132666, -132380, -132427,
    -168415, -133676, -133987, -136420, -136872, -136938, -137672, -138008,
    -138724, -138726, -139651, -172946, -140081, -33281, -144056, -156122,
    -141012, -142092, -142321, -143370, -32941, -144323, -144493, -145059,
    -145575, -146061, -138507, -146170, -146620, -146718, -147153, -147294,
    -147342, -132389, -148067, -148395, -149000, -149301, -149524, -150582,
    -150674, -139679, -151457, -151480, -151620, -151795, -151794, -151833,
    -151859, -152605, -153126, -153242, -153285, -153980, -154279, -154539,
    -154752, -155526, -156200, -156231, -156377, -156478, -156890, -156963,
    -32864, -157096, -32880, -144223, -32946, -33027, -33086, -157607,
    -157621, -144275, -144284, -33284, -36766, -33425, -33419, -33437,
    -33457, -33459, -33469, -33510, -158524, -33565, -33635, -33709,
    -33571, -33725, -33767, -33619, -33738, -33740, -33756, -158774,
    -159083, -158933, -34033, -34035, -34070, -160714, -34148, -159532,
    -159665, -159954, -34384, -34407, -34409, -34473, -34440, -34574,
    -34530, -34600, -34667, -34694, -34785, -34817, -34912, -34915,
    -161383, -35031, -35038, -35066, -161966, -162150, -35488, -35925,
    -162984, -36011, -36033, -36123, -36215, -163631, -133124, -36299,
    -36284, -36336, -133342, -36564, -165330, -165357, -37012, -37105,
    -37137, -165678, -37147, -37432, -37591, -37592, -37500, -37881,
    -37909, -166906, -38283, -38327, -167287, -38595, -38691, -168261,
    -168474, -38880, -168970, -169110, -38953, -169398, -39138, -39209,
    -39335, -39362, -39422, -170800, -40000, -40189, -40295, -172238,
    -172293, -172558, -172689, -40635, -40697, -40702, -40709, -40719,
    -40726, -40763, -173568, -42899, -42937, -42947, -42900, -42952,
    -42954,
};

const uint8_t upropshash1[788] = {
    4, 5, 6, 7, 8, 9, 10, 11,
    12, 13, 14, 15, 16, 17, 18, 19,
    20, 21, 22, 23, 0, 0, 0, 24,
    25, 26, 27, 28, 29, 30, 31, 32,
    33, 34, 35, 36, 37, 0, 0, 0,
    0, 0, 38, 0, 39, 40, 41, 42,
    43, 44, 45, 2, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 46, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 47,
    0, 0, 0, 0, 0, 0, 48, 49,
    50, 51, 52, 53, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 54,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 55, 56, 57, 2, 58, 59, 60,
    0, 61, 62, 63, 0, 0, 0, 0,
    0, 0, 64, 0, 0, 65, 66, 67,
    68, 69, 70, 71, 72, 73, 74, 75,
    76, 77, 78, 0, 79, 80, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 81, 3, 0, 0, 0, 82,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 83, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 84, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 85, 86, 0, 87, 88, 89, 90,
    0, 0, 0, 0, 0, 0, 0, 0,
    91, 3, 92, 0, 0, 0, 0, 0,
    93, 94, 0, 0, 0, 0, 95, 0,
    0, 96, 97, 0, 0, 0, 0, 0,
    0, 0, 0, 98, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 99, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 100,
    101, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 102, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 103, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    104, 105, 106, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 107,
};

const uint16_t upropshash2[108][256] = {
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1},
    {2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 0, 0, 120, 121, 122, 0,
    0, 123, 124, 125, 126, 127, 128, 129,
    130, 131, 132, 133, 134, 135, 136, 137,
    138, 139, 140, 141, 142, 143, 144, 145,
    146, 147, 148, 0, 0, 0, 0, 3,
    0, 149, 150, 151, 152, 153, 154, 155,
    156, 157, 158, 159, 160, 161, 162, 163,
    164, 1, 165, 166, 167, 168, 169, 170,
    171, 172, 173, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 0, 0, 0, 0, 0, 0, 0,
    174, 0, 2, 0, 0, 0, 0, 2,
    0, 0, 2, 2, 2, 2, 0, 0,
    2, 2, 2, 0, 2, 2, 2, 0,
    175, 176, 177, 178, 179, 180, 181, 182,
    183, 184, 185, 186, 187, 188, 189, 190,
    191, 192, 193, 194, 195, 196, 197, 0,
    198, 199, 200, 201, 202, 203, 204, 36,
    205, 206, 207, 208, 209, 210, 211, 212,
    213, 214, 215, 216, 217, 218, 219, 220,
    1, 221, 222, 223, 224, 225, 226, 0,
    227, 228, 229, 230, 231, 232, 1, 233},
    {234, 235, 236, 237, 238, 239, 240, 241,
    242, 243, 244, 245, 246, 247, 248, 249,
    250, 1, 251, 252, 253, 254, 255, 256,
    257, 258, 259, 260, 261, 262, 263, 264,
    265, 266, 267, 268, 269, 270, 271, 1,
    272, 273, 274, 275, 276, 277, 278, 279,
    280, 1, 2, 2, 281, 282, 283, 284,
    1, 285, 286, 287, 288, 289, 290, 2,
    2, 291, 1, 292, 293, 294, 295, 296,
    297, 2, 298, 1, 299, 300, 301, 302,
    303, 304, 305, 1, 306, 307, 308, 309,
    310, 311, 312, 313, 314, 315, 316, 317,
    318, 319, 320, 321, 322, 323, 324, 1,
    325, 326, 327, 328, 329, 330, 331, 332,
    333, 334, 335, 336, 337, 338, 339, 340,
    341, 342, 343, 344, 345, 346, 347, 348,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 349,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    350, 351, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 352,
    353, 0, 0, 0, 0, 0, 0, 354,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 355, 356, 357,
    358, 359, 360, 361, 362, 363, 364, 365,
    366, 367, 368, 369, 370, 0, 371, 372,
    373, 374, 375, 376, 0, 0, 377, 378,
    379, 380, 381, 382, 383, 384, 385, 386,
    387, 2, 2, 2, 388, 389, 0, 0,
    390, 391, 392, 393, 394, 395, 396, 397},
    {398, 399, 400, 401, 402, 403, 404, 405,
    406, 407, 408, 409, 410, 411, 412, 413,
    414, 415, 416, 417, 418, 419, 420, 421,
    422, 423, 424, 425, 0, 0, 426, 427,
    0, 0, 0, 0, 0, 0, 428, 429,
    430, 431, 432, 433, 434, 435, 436, 437,
    438, 439, 440, 441, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 442, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 0, 0, 1, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 0, 0,
    2, 2, 2, 2, 2, 0, 0, 0,
    0, 0, 0, 0, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {443, 444, 445, 446, 447, 4, 448, 449,
    450, 451, 452, 453, 454, 4, 4, 455,
    11, 456, 4, 457, 458, 15, 5, 5,
    5, 5, 15, 459, 5, 5, 5, 5,
    5, 23, 23, 460, 461, 462, 463, 464,
    465, 5, 5, 5, 5, 466, 467, 5,
    468, 469, 5, 5, 8, 470, 8, 8,
    471, 16, 5, 5, 5, 4, 4, 4,
    472, 473, 474, 475, 476, 477, 4, 5,
    5, 5, 4, 4, 4, 5, 5, 0,
    4, 4, 4, 5, 5, 5, 5, 4,
    15, 5, 5, 4, 19, 17, 17, 19,
    17, 17, 19, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    0, 0, 0, 0, 478, 0, 0, 0,
    0, 0, 2, 1, 1, 1, 479, 0,
    0, 0, 0, 0, 2, 480, 481, 482,
    483, 484, 485, 0, 486, 0, 487, 488,
    489, 490, 491, 492, 493, 494, 495, 496,
    497, 498, 499, 500, 501, 502, 503, 504,
    505, 506, 0, 37, 507, 508, 509, 510,
    511, 512, 513, 514, 515, 516, 517, 518,
    519, 520, 1, 1, 1, 521, 1, 522,
    1, 523, 1, 1, 1, 1, 1, 524,
    1, 525, 37, 1, 1, 526, 1, 1,
    1, 527, 528, 529, 530, 531, 532, 0,
    2, 2, 533, 534, 535, 2, 2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 0, 2, 2, 0, 0,
    0, 2, 0, 0, 1, 536, 537, 538},
    {539, 540, 541, 542, 543, 544, 545, 546,
    547, 548, 549, 550, 551, 552, 553, 554,
    555, 556, 557, 558, 559, 560, 561, 562,
    563, 564, 565, 566, 567, 568, 569, 570,
    571, 572, 573, 574, 575, 576, 577, 578,
    579, 580, 581, 582, 583, 584, 585, 586,
    587, 1, 1, 588, 1, 589, 590, 591,
    592, 593, 594, 1, 1, 1, 595, 1,
    1, 1, 1, 596, 1, 1, 1, 597,
    1, 1, 1, 598, 1, 599, 1, 1,
    600, 601, 1, 602, 1, 1, 603, 604,
    1, 1, 1, 1, 605, 606, 607, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 608, 609, 610, 611,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 4, 4, 4, 4, 4,
    0, 0, 612, 1, 613, 1, 614, 1,
    615, 1, 616, 1, 617, 1, 618, 1,
    619, 1, 620, 1, 621, 1, 622, 1,
    623, 1, 624, 1, 625, 1, 626, 1,
    627, 1, 628, 1, 629, 1, 630, 1,
    631, 1, 632, 1, 633, 1, 634, 1,
    635, 1, 636, 1, 637, 1, 638, 1,
    639, 640, 641, 642, 1, 643, 1, 644,
    1, 645, 1, 646, 1, 647, 1, 1,
    648, 649, 650, 651, 652, 1, 653, 654,
    655, 656, 657, 658, 659, 660, 661, 662,
    663, 1, 664, 665, 666, 667, 668, 669,
    670, 671, 672, 673, 674, 675, 676, 677,
    678, 679, 680, 681, 682, 683, 684, 1,
    685, 686, 687, 1, 688, 1, 689, 1},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    690, 1, 691, 1, 692, 1, 693, 1,
    694, 1, 695, 1, 696, 1, 697, 1,
    698, 1, 699, 1, 700, 1, 701, 1,
    702, 1, 0, 0, 0, 0, 703, 1,
    0, 704, 705, 706, 707, 708, 709, 710,
    711, 712, 713, 714, 715, 716, 717, 718,
    719, 720, 721, 722, 723, 724, 725, 726,
    727, 728, 729, 730, 731, 732, 733, 734,
    735, 736, 737, 738, 739, 740, 741, 0,
    0, 1, 0, 0, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 5, 4, 4, 4, 4, 5, 4,
    4, 4, 20, 5, 4, 4, 4, 4,
    4, 4, 5, 5, 5, 5, 5, 5,
    4, 4, 5, 4, 4, 20, 18, 4,
    742, 743, 744, 745, 746, 747, 748, 749,
    38, 39, 39, 750, 751, 752, 0, 753,
    0, 754, 755, 0, 4, 5, 0, 38,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 1,
    1, 1, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    756, 757, 758, 0, 0, 0, 0, 0,
    1, 1, 759, 760, 761, 762, 763, 764,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    0, 1, 1, 1, 1, 1, 1, 1,
    765, 1, 766, 767, 768, 769, 770, 771,
    772, 773, 774, 775, 776, 777, 5, 4,
    4, 4, 4, 4, 5, 4, 4, 5,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 0, 0, 0, 0, 0, 0,
    778, 1, 1, 0, 1, 2, 2, 2,
    2, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    779, 780, 781, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 782, 783, 0, 784, 4, 4,
    4, 4, 4, 4, 4, 0, 0, 4,
    4, 4, 4, 5, 4, 1, 1, 4,
    4, 0, 5, 4, 4, 5, 1, 1,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 1, 1, 1, 0, 0, 1},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 785, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 5, 4, 4, 5, 4, 4, 5,
    5, 5, 4, 5, 5, 4, 5, 4,
    4, 4, 5, 4, 5, 4, 5, 4,
    5, 4, 4, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 4, 4, 4, 4, 4,
    4, 4, 5, 4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 5, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 4, 4,
    4, 4, 0, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 0, 4, 4, 4,
    0, 4, 4, 4, 4, 4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 5, 5, 5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 0, 0,
    0, 0, 1, 0, 0, 0, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 5, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 0, 5, 4, 4, 5, 4,
    4, 5, 4, 4, 4, 5, 5, 5,
    786, 787, 788, 4, 4, 4, 5, 4,
    4, 5, 5, 4, 4, 4, 4, 4},
    {0, 3, 3, 3, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    789, 790, 1, 1, 1, 1, 1, 1,
    791, 792, 1, 793, 794, 1, 1, 1,
    1, 1, 3, 3, 795, 1, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 10, 0, 3,
    1, 4, 5, 4, 4, 0, 3, 3,
    796, 797, 798, 799, 800, 801, 802, 803,
    1, 1, 3, 3, 0, 0, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3,
    0, 1, 1, 1, 1, 1, 1, 1,
    0, 1, 1, 1, 1, 1, 1, 1,
    0, 3, 3, 3, 0, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 0, 1,
    1, 0, 0, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 0, 0, 0, 1, 1,
    1, 1, 0, 0, 12, 1, 804, 3,
    3, 3, 3, 3, 3, 0, 0, 805,
    3, 0, 0, 806, 807, 10, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 808,
    0, 0, 0, 0, 809, 810, 0, 811,
    1, 1, 3, 3, 0, 0, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3,
    1, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 11, 0},
    {0, 3, 3, 3, 0, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 1,
    1, 0, 0, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 812, 0, 1, 813, 0,
    1, 1, 0, 0, 12, 0, 3, 3,
    3, 3, 3, 0, 0, 0, 0, 3,
    3, 0, 0, 3, 3, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 814, 815, 816, 1, 0, 817, 0,
    0, 0, 0, 0, 0, 0, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 1, 1, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 3, 3, 3, 0, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 1,
    1, 1, 0, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 0, 1, 1, 1,
    1, 1, 0, 0, 12, 1, 3, 3,
    3, 3, 3, 3, 3, 3, 0, 3,
    3, 3, 0, 3, 3, 10, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 3, 3, 0, 0, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 3, 3, 3, 3, 3, 3},
    {0, 3, 3, 3, 0, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 0, 1,
    1, 0, 0, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 0, 1, 1, 1,
    1, 1, 0, 0, 12, 1, 818, 3,
    3, 3, 3, 3, 0, 0, 0, 819,
    820, 0, 0, 821, 822, 10, 0, 0,
    0, 0, 0, 0, 0, 3, 823, 824,
    0, 0, 0, 0, 825, 826, 0, 1,
    1, 1, 0, 0, 0, 0, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3,
    0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 3, 1, 0, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 1, 1,
    1, 0, 827, 1, 828, 1, 0, 0,
    0, 1, 1, 0, 1, 0, 1, 1,
    0, 0, 0, 1, 1, 0, 0, 0,
    1, 1, 1, 0, 0, 0, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 0, 0, 0, 0, 829, 3,
    3, 3, 3, 0, 0, 0, 830, 831,
    3, 0, 832, 833, 834, 10, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 835,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 3, 3, 3, 3, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 1, 1,
    1, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 0, 1, 1, 1,
    1, 1, 0, 0, 0, 1, 3, 3,
    3, 3, 3, 3, 3, 0, 836, 3,
    837, 0, 3, 3, 3, 10, 0, 0,
    0, 0, 0, 0, 0, 838, 839, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 0, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 3, 3, 0, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 1, 1,
    1, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 0, 1, 1, 1,
    1, 1, 0, 0, 12, 1, 3, 840,
    841, 3, 842, 3, 3, 0, 843, 844,
    845, 0, 846, 847, 3, 10, 0, 0,
    0, 0, 0, 0, 0, 848, 849, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 3, 3, 0, 0, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3,
    0, 1, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {3, 0, 3, 3, 0, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 1, 1,
    1, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 7, 7, 1, 850, 3,
    3, 3, 3, 3, 0, 0, 851, 852,
    3, 0, 853, 854, 855, 10, 1, 0,
    0, 0, 0, 0, 1, 1, 1, 856,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 0, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 1, 1, 1, 1, 1,
    0, 0, 3, 3, 0, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 0,
    0, 1, 1, 1, 1, 1, 1, 0,
    0, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 0, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 0, 1, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    0, 0, 857, 0, 0, 0, 0, 858,
    3, 3, 3, 3, 3, 0, 3, 0,
    3, 859, 860, 3, 861, 862, 863, 864,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 3, 1, 2, 3, 3, 3, 3,
    40, 40, 10, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 3,
    21, 21, 21, 21, 3, 3, 3, 0,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 1, 0, 1, 0, 1, 1,
    1, 1, 1, 0, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 0, 1, 0, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 3, 1, 2, 3, 3, 3, 3,
    41, 41, 10, 3, 3, 1, 0, 0,
    1, 1, 1, 1, 1, 0, 1, 0,
    22, 22, 22, 22, 3, 3, 0, 0,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 0, 0, 2, 2, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5, 5, 0, 0, 0, 0, 0, 0,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 16, 0, 16,
    0, 13, 0, 0, 0, 0, 3, 3,
    1, 1, 1, 865, 1, 1, 1, 1,
    0, 1, 1, 1, 1, 866, 1, 1,
    1, 1, 867, 1, 1, 1, 1, 868,
    1, 1, 1, 1, 869, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 870, 1, 1, 1, 0, 0, 0,
    0, 871, 14, 872, 873, 874, 875, 2,
    876, 2, 14, 14, 14, 14, 3, 3,
    14, 877, 11, 11, 10, 0, 11, 11,
    1, 1, 1, 1, 1, 3, 3, 3,
    3, 3, 3, 878, 3, 3, 3, 3,
    0, 3, 3, 3, 3, 879, 3, 3,
    3, 3, 880, 3, 3, 3, 3, 881,
    3, 3, 3, 3, 882, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 883, 3, 3, 3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 16, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 884, 885, 1,
    1, 1, 1, 3, 3, 3, 886, 3,
    3, 3, 3, 3, 3, 3, 3, 12,
    3, 10, 10, 3, 3, 3, 3, 1,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 3, 3,
    3, 3, 1, 1, 1, 1, 3, 3,
    3, 1, 3, 3, 3, 1, 1, 3,
    3, 3, 3, 3, 3, 3, 1, 1,
    1, 3, 3, 3, 3, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 16, 1, 3,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 887,
    0, 0, 0, 0, 0, 888, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 0, 0, 0, 0, 0, 1,
    1, 1, 1, 0, 2, 1, 1, 1},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 0, 1, 1, 1, 1, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 0, 1, 1, 1, 1, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 0, 0, 11, 11, 11,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 0, 0, 1, 1, 1,
    0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 0, 0, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 0, 0, 0, 0, 0,
    0, 0, 10, 0, 0, 0, 0, 1,
    0, 0, 0, 0, 1, 4, 0, 0,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 18, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 20, 4, 5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 4,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    7, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 4, 4, 4,
    4, 4, 4, 4, 4, 0, 0, 5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 4, 4, 4, 4, 5, 5, 5,
    5, 5, 5, 4, 4, 5, 0, 5,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 889, 890, 891,
    892, 893, 894, 895, 896, 897, 898, 0,
    0, 899, 900, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 9, 901, 0, 0,
    0, 0, 902, 903, 904, 905, 906, 907,
    908, 909, 910, 911, 7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 4, 5, 4, 4, 4,
    4, 4, 4, 4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7, 7, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 9, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7, 7, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 9,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    912, 913, 914, 915, 916, 917, 918, 919,
    920, 921, 922, 923, 924, 925, 926, 927,
    928, 929, 930, 931, 932, 933, 934, 935,
    936, 937, 938, 939, 940, 941, 942, 943,
    944, 945, 946, 947, 948, 949, 950, 951,
    952, 953, 954, 0, 0, 955, 956, 957,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 4, 4, 0, 8, 5, 5, 5,
    5, 5, 4, 4, 5, 5, 5, 5,
    4, 0, 8, 8, 8, 8, 8, 8,
    8, 0, 0, 0, 0, 5, 0, 0,
    0, 0, 0, 0, 4, 0, 0, 0,
    4, 4, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, 2, 2, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 0, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 0, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    4, 4, 5, 4, 4, 4, 4, 4,
    4, 4, 5, 4, 4, 17, 958, 5,
    23, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 15, 18,
    18, 5, 0, 4, 19, 5, 4, 5},
    {959, 960, 961, 962, 963, 964, 965, 966,
    967, 968, 969, 970, 971, 972, 973, 974,
    975, 976, 977, 978, 979, 980, 981, 982,
    983, 984, 985, 986, 987, 988, 989, 990,
    991, 992, 993, 994, 995, 996, 997, 998,
    999, 1000, 1001, 1002, 1003, 1004, 1005, 1006,
    1007, 1008, 1009, 1010, 1011, 1012, 1013, 1014,
    1015, 1016, 1017, 1018, 1019, 1020, 1021, 1022,
    1023, 1024, 1025, 1026, 1027, 1028, 1029, 1030,
    1031, 1032, 1033, 1034, 1035, 1036, 1037, 1038,
    1039, 1040, 1041, 1042, 1043, 1044, 1045, 1046,
    1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054,
    1055, 1056, 1057, 1058, 1059, 1060, 1061, 1062,
    1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070,
    1071, 1072, 1073, 1074, 1075, 1076, 1077, 1078,
    1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086,
    1087, 1088, 1089, 1090, 1091, 1092, 1093, 1094,
    1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102,
    1103, 1104, 1105, 1106, 1107, 1108, 1109, 1110,
    1111, 1112, 2, 1113, 0, 0, 36, 0,
    1114, 1115, 1116, 1117, 1118, 1119, 1120, 1121,
    1122, 1123, 1124, 1125, 1126, 1127, 1128, 1129,
    1130, 1131, 1132, 1133, 1134, 1135, 1136, 1137,
    1138, 1139, 1140, 1141, 1142, 1143, 1144, 1145,
    1146, 1147, 1148, 1149, 1150, 1151, 1152, 1153,
    1154, 1155, 1156, 1157, 1158, 1159, 1160, 1161,
    1162, 1163, 1164, 1165, 1166, 1167, 1168, 1169,
    1170, 1171, 1172, 1173, 1174, 1175, 1176, 1177,
    1178, 1179, 1180, 1181, 1182, 1183, 1184, 1185,
    1186, 1187, 1188, 1189, 1190, 1191, 1192, 1193,
    1194, 1195, 1196, 1197, 1198, 1199, 1200, 1201,
    1202, 1203, 0, 0, 0, 0, 0, 0},
    {1204, 1205, 1206, 1207, 1208, 1209, 1210, 1211,
    1212, 1213, 1214, 1215, 1216, 1217, 1218, 1219,
    1220, 1221, 1222, 1223, 1224, 1225, 0, 0,
    1226, 1227, 1228, 1229, 1230, 1231, 0, 0,
    1232, 1233, 1234, 1235, 1236, 1237, 1238, 1239,
    1240, 1241, 1242, 1243, 1244, 1245, 1246, 1247,
    1248, 1249, 1250, 1251, 1252, 1253, 1254, 1255,
    1256, 1257, 1258, 1259, 1260, 1261, 1262, 1263,
    1264, 1265, 1266, 1267, 1268, 1269, 0, 0,
    1270, 1271, 1272, 1273, 1274, 1275, 0, 0,
    1276, 1277, 1278, 1279, 1280, 1281, 1282, 1283,
    0, 1284, 0, 1285, 0, 1286, 0, 1287,
    1288, 1289, 1290, 1291, 1292, 1293, 1294, 1295,
    1296, 1297, 1298, 1299, 1300, 1301, 1302, 1303,
    1304, 1305, 1306, 1307, 1308, 1309, 1310, 1311,
    1312, 1313, 1314, 1315, 1316, 1317, 0, 0,
    1318, 1319, 1320, 1321, 1322, 1323, 1324, 1325,
    1326, 1327, 1328, 1329, 1330, 1331, 1332, 1333,
    1334, 1335, 1336, 1337, 1338, 1339, 1340, 1341,
    1342, 1343, 1344, 1345, 1346, 1347, 1348, 1349,
    1350, 1351, 1352, 1353, 1354, 1355, 1356, 1357,
    1358, 1359, 1360, 1361, 1362, 1363, 1364, 1365,
    1366, 1367, 1368, 1369, 1370, 0, 1371, 1372,
    1373, 1374, 1375, 1376, 1377, 2, 1378, 1379,
    2, 1380, 1381, 1382, 1383, 0, 1384, 1385,
    1386, 1387, 1388, 1389, 1390, 1391, 1392, 1393,
    1394, 1395, 1396, 1397, 0, 0, 1398, 1399,
    1400, 1401, 1402, 1403, 0, 1404, 1405, 1406,
    1407, 1408, 1409, 1410, 1411, 1412, 1413, 1414,
    1415, 1416, 1417, 1418, 1419, 1420, 1421, 1422,
    0, 0, 1423, 1424, 1425, 0, 1426, 1427,
    1428, 1429, 1430, 1431, 1432, 1433, 1434, 0},
    {1435, 1436, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 0, 0, 0, 0, 0,
    0, 2, 0, 0, 0, 0, 0, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, 2, 2, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    0, 0, 0, 2, 2, 0, 2, 2,
    0, 0, 0, 0, 2, 0, 2, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    2, 2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    0, 0, 0, 0, 0, 0, 0, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 0, 0, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 4, 8, 8, 4, 4, 4, 4,
    8, 8, 8, 4, 4, 0, 0, 0,
    0, 4, 0, 0, 0, 8, 8, 4,
    5, 4, 8, 8, 5, 5, 5, 5,
    4, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {2, 2, 2, 2, 0, 2, 2, 2,
    0, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 0, 2, 2, 0,
    0, 2, 2, 2, 2, 2, 0, 0,
    2, 2, 2, 0, 2, 0, 1437, 0,
    2, 0, 1438, 1439, 2, 2, 0, 2,
    2, 2, 0, 2, 2, 2, 2, 2,
    2, 2, 0, 2, 2, 2, 2, 2,
    2, 0, 0, 0, 0, 2, 2, 2,
    2, 2, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 0, 0, 0, 0, 0,
    1440, 0, 1441, 0, 1442, 0, 0, 0,
    0, 0, 1443, 1444, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1445, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1446, 1447, 1448,
    1449, 0, 1450, 0, 1451, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 1452, 1453, 0, 0, 0,
    1454, 1455, 0, 1456, 1457, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1458, 1459, 1460, 1461, 0,
    0, 0, 0, 0, 2, 2, 0, 2,
    2, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1462, 0, 0, 0,
    0, 1463, 0, 1464, 1465, 1466, 0, 1467,
    1468, 1469, 0, 0, 0, 1470, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1471, 1472, 1473, 0, 1474, 1475, 0, 0,
    0, 0, 0, 0, 0, 1476, 1477, 1478,
    1479, 1480, 1481, 1482, 1483, 1484, 1485, 1486,
    1487, 1488, 1489, 1490, 1491, 1492, 0, 0,
    1493, 1494, 1495, 1496, 1497, 1498, 1499, 1500,
    1501, 1502, 0, 0, 0, 0, 0, 0,
    0, 1503, 1504, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1505, 0, 0, 0, 0, 0,
    1506, 1507, 0, 1508, 1509, 1510, 1511, 1512,
    0, 0, 1513, 1514, 1515, 1516, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1517, 1518, 1519, 1520, 0, 0, 0, 0,
    0, 0, 1521, 1522, 1523, 1524, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1525, 1526, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, 2, 2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1527, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, 2, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 4,
    4, 4, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 7,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {2, 0, 0, 0, 0, 1, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1528, 18, 15, 20, 42, 42,
    0, 0, 0, 0, 0, 0, 2, 0,
    2, 2, 2, 0, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 1, 1529, 1,
    1, 1, 1, 1530, 1531, 1532, 1533, 1534,
    1535, 1536, 1537, 1538, 1539, 1540, 1541, 1542,
    1543, 1544, 1545, 1546, 1547, 1548, 1549, 1550,
    1551, 1552, 1553, 1, 1554, 1555, 1556, 1557,
    1558, 1559, 1, 1, 1, 1, 1, 1560,
    1561, 1562, 1563, 1564, 1565, 1566, 1567, 1568,
    1569, 1570, 1571, 1572, 1573, 1574, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1575, 1, 1, 0,
    0, 1576, 1577, 2, 2, 1578, 1579, 2,
    0, 1, 1, 1, 1, 1, 1580, 1,
    1, 1, 1, 1581, 1582, 1583, 1584, 1585,
    1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593,
    1594, 1595, 1596, 1597, 1598, 1599, 1600, 1601,
    1602, 1603, 1604, 1, 1605, 1606, 1607, 1608,
    1609, 1610, 1, 1, 1, 1, 1, 1611,
    1612, 1613, 1614, 1615, 1616, 1617, 1618, 1619,
    1620, 1621, 1622, 1623, 1624, 1625, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1626,
    1627, 1628, 1629, 1, 1630, 1, 1, 1631,
    1632, 1633, 1634, 0, 1, 1635, 1636, 2},
    {0, 0, 0, 0, 0, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 1,
    0, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 0,
    0, 0, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 4,
    0, 0, 0, 0, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, 2, 4, 4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 4, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 1637, 0, 0,
    0, 0, 1638, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1639, 0, 0, 0, 1640, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1641, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 1642, 1, 1643, 1644, 1645, 1646,
    1, 1647, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 7, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 5, 5, 5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 9, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    7, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 1, 1, 1, 1, 1, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 0,
    0, 0, 1, 3, 3, 3, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 0, 4, 4, 5, 0, 0, 4,
    4, 0, 0, 0, 0, 0, 4, 4,
    0, 4, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 7, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 1, 1, 1, 1, 1, 1, 0,
    0, 1, 1, 1, 1, 1, 1, 0,
    0, 1, 1, 1, 1, 1, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, 2, 2, 2,
    0, 0, 0, 0, 0, 0, 1, 1,
    0, 2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 7, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1648, 1649, 1650, 1651, 1652, 1653, 1654, 24,
    24, 1655, 1656, 1657, 1658, 43, 1659, 1660,
    1661, 1662, 1663, 1664, 25, 1665, 1666, 1667,
    1668, 1669, 1670, 1671, 1672, 1673, 1674, 1675,
    1676, 1677, 1678, 1679, 1680, 1681, 1682, 1683,
    44, 26, 1684, 1685, 1686, 1687, 1688, 1689,
    1690, 1691, 1692, 1693, 1694, 1695, 45, 1696,
    1697, 1698, 1699, 46, 1700, 1701, 1702, 1703,
    1704, 1705, 1706, 1707, 1708, 1709, 1710, 1711,
    1712, 1713, 1714, 1715, 1716, 1717, 1718, 1719,
    1720, 1721, 1722, 1723, 1724, 1725, 1726, 1727,
    1728, 1729, 1730, 1731, 25, 47, 1732, 27,
    1733, 48, 49, 50, 1734, 1735, 1736, 1737,
    1738, 1739, 1740, 1741, 1742, 1743, 1744, 51,
    28, 1745, 1746, 1747, 52, 1748, 1749, 1750,
    1751, 1752, 1753, 1754, 1755, 1756, 1757, 1758,
    1759, 1760, 1761, 1762, 1763, 1764, 1765, 1766,
    1767, 1768, 1769, 1770, 1771, 1772, 1773, 1774,
    1775, 1776, 1777, 1778, 1779, 1780, 29, 1781,
    1782, 1783, 1784, 1785, 1786, 1787, 1788, 1789,
    1790, 51, 1791, 1792, 1793, 1794, 1795, 1796,
    1797, 1798, 27, 1799, 1800, 1801, 1802, 1803,
    1804, 1805, 1806, 1807, 1808, 1809, 1810, 1811,
    1812, 1813, 1814, 1815, 1816, 1817, 1818, 25,
    1819, 1820, 1821, 1822, 1823, 1824, 1825, 1826,
    1827, 1828, 30, 1829, 1830, 1831, 1832, 1833,
    1834, 1835, 1836, 1837, 1838, 1839, 1840, 1841,
    1842, 1843, 1844, 48, 1845, 1846, 1847, 1848,
    1849, 1850, 1851, 1852, 1853, 1854, 1855, 1856,
    1857, 1858, 1859, 1860, 1861, 1862, 1863, 1864,
    1865, 1866, 1867, 1868, 1869, 1870, 1871, 1872,
    1873, 1874, 1875, 1876, 1877, 1878, 1879, 1880},
    {53, 1881, 1882, 1883, 1884, 1885, 1886, 1887,
    1888, 1889, 1890, 1891, 1892, 1893, 1, 1,
    54, 1, 55, 1, 1, 1894, 56, 57,
    1895, 1896, 1897, 58, 59, 1898, 1899, 1,
    1900, 1, 60, 1, 1, 61, 1901, 1,
    1, 1, 1902, 1903, 1904, 1905, 1906, 1907,
    62, 63, 64, 65, 66, 67, 68, 69,
    1908, 1909, 1910, 1911, 70, 71, 1912, 31,
    32, 72, 1913, 73, 74, 75, 1914, 76,
    77, 1915, 1916, 1917, 1918, 1919, 1920, 1921,
    78, 1922, 1923, 1924, 79, 1925, 80, 29,
    1926, 1927, 1928, 33, 1929, 81, 81, 82,
    1930, 83, 84, 85, 1931, 86, 1932, 61,
    87, 88, 89, 1933, 1934, 1935, 0, 0,
    1936, 90, 1937, 1938, 1939, 1940, 91, 92,
    68, 1941, 93, 1942, 54, 1943, 1944, 1945,
    1946, 1947, 1948, 1949, 1950, 1951, 1952, 94,
    1953, 31, 1954, 32, 1955, 1956, 1957, 1958,
    1959, 55, 26, 95, 1960, 1961, 28, 30,
    1962, 96, 76, 97, 77, 1963, 98, 1964,
    56, 99, 1965, 1966, 1967, 1968, 57, 1969,
    100, 101, 1970, 102, 1971, 80, 1972, 1973,
    29, 1974, 33, 1975, 1976, 103, 1977, 1978,
    83, 1979, 60, 1980, 84, 47, 104, 85,
    105, 86, 106, 1981, 1982, 1983, 1984, 87,
    59, 1985, 88, 34, 89, 107, 24, 1986,
    1987, 1988, 108, 1989, 109, 1990, 1991, 1992,
    1993, 1994, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {2, 2, 2, 2, 2, 2, 2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2, 2, 2, 2, 2,
    0, 0, 0, 0, 0, 1995, 1996, 1997,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 1998, 1999, 2000, 2001, 2002, 2003,
    2004, 2005, 2006, 2007, 2008, 2009, 2010, 0,
    2011, 2012, 2013, 2014, 2015, 0, 2016, 0,
    2017, 2018, 0, 2019, 2020, 0, 2021, 2022,
    2023, 2024, 2025, 2026, 2027, 2028, 2029, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2},
    {2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    0, 0, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 0, 0, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 5,
    5, 5, 5, 5, 5, 5, 4, 4,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 0, 0, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 0, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 0,
    2, 2, 2, 2, 0, 0, 0, 0,
    2, 2, 2, 0, 2, 0, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 0, 0, 0},
    {0, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 0,
    0, 0, 2, 2, 2, 2, 2, 2,
    0, 0, 2, 2, 2, 2, 2, 2,
    0, 0, 2, 2, 2, 2, 2, 2,
    0, 0, 2, 2, 2, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 0,
    2, 2, 2, 2, 2, 2, 2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 5, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 5, 0, 4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 8, 5, 0, 0, 0, 0, 7,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 4, 5, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 4, 4, 4, 4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 4, 4, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 5, 5,
    4, 4, 4, 5, 4, 5, 5, 5,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 7, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 7,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2030, 2031, 2032, 2033, 0, 0, 0,
    0, 0, 0, 0, 0, 2034, 0, 0,
    0, 0, 0, 2035, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 7, 2036, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {4, 4, 4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2037,
    0, 0, 0, 0, 0, 0, 2038, 2039,
    0, 2040, 2041, 7, 7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 9, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    7, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 9, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 7, 9, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 9, 7, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 3, 0, 3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 12, 12, 0, 2042, 0,
    0, 0, 0, 0, 0, 0, 0, 2043,
    0, 0, 0, 2044, 2045, 7, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2046,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 0, 0, 0,
    4, 4, 4, 4, 4, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7, 0, 0, 0, 9, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 4, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2047, 0, 0, 0, 0, 0, 0, 0,
    0, 2048, 2049, 2050, 2051, 2052, 2053, 0,
    0, 0, 7, 9, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2054,
    0, 0, 0, 0, 0, 0, 0, 0,
    2055, 2056, 2057, 2058, 0, 0, 0, 7,
    9, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 7,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 7, 9,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 7, 9, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2059, 0, 0, 0, 0, 2060, 0, 0,
    2061, 0, 0, 0, 0, 7, 7, 0,
    0, 0, 0, 9, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    7, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 7,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 7, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 7,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 9, 0, 7, 7, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 7,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    8, 8, 8, 8, 8, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    110, 110, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 1, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 2062, 2063,
    2064, 2065, 2066, 2067, 2068, 13, 13, 8,
    8, 8, 0, 0, 0, 2069, 13, 13,
    13, 13, 13, 0, 0, 0, 0, 0,
    0, 0, 0, 5, 5, 5, 5, 5,
    5, 5, 5, 0, 0, 4, 4, 4,
    4, 4, 5, 5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 4, 4, 4, 4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2070, 2071, 2072, 2073, 2074,
    2075, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 4, 4, 4, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 0, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 0, 2, 2,
    0, 0, 2, 0, 0, 2, 2, 0,
    0, 2, 2, 2, 2, 0, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 2, 0, 2, 2, 2,
    2, 2, 2, 2, 0, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2},
    {2, 2, 2, 2, 2, 2, 0, 2,
    2, 2, 2, 0, 0, 2, 2, 2,
    2, 2, 2, 2, 2, 0, 2, 2,
    2, 2, 2, 2, 2, 0, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 2, 2, 2, 2, 0,
    2, 2, 2, 2, 2, 0, 2, 0,
    0, 0, 2, 2, 2, 2, 2, 2,
    2, 0, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2},
    {2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2},
    {2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 0, 0, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2},
    {4, 4, 4, 4, 4, 4, 4, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 0, 0, 4, 4, 4, 4, 4,
    4, 4, 0, 4, 4, 0, 4, 4,
    4, 4, 4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 4, 4, 4, 4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5, 5, 5, 5, 5, 5, 5, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 4, 4, 4, 4,
    4, 4, 9, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {2, 2, 2, 2, 0, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    0, 2, 2, 0, 2, 0, 0, 2,
    0, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 0, 2, 2, 2, 2,
    0, 2, 0, 2, 0, 0, 0, 0,
    0, 0, 2, 0, 0, 0, 0, 2,
    0, 2, 0, 2, 0, 2, 2, 2,
    0, 2, 2, 0, 2, 0, 0, 2,
    0, 2, 0, 2, 0, 2, 0, 2,
    0, 2, 2, 0, 2, 0, 0, 2,
    2, 2, 2, 0, 2, 2, 2, 2,
    2, 2, 2, 0, 2, 2, 2, 2,
    0, 2, 2, 2, 2, 0, 2, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 0, 0, 0, 0,
    0, 2, 2, 2, 0, 2, 2, 2,
    2, 2, 0, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 2, 2, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {2, 2, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {2076, 2077, 2078, 2079, 2080, 62, 2081, 2082,
    2083, 2084, 63, 2085, 2086, 2087, 64, 2088,
    2089, 2090, 2091, 2092, 2093, 2094, 2095, 2096,
    2097, 2098, 2099, 90, 2100, 2101, 2102, 2103,
    2104, 2105, 2106, 2107, 2108, 91, 65, 66,
    92, 2109, 2110, 50, 2111, 67, 2112, 2113,
    2114, 35, 35, 35, 2115, 2116, 2117, 2118,
    2119, 2120, 2121, 2122, 2123, 2124, 2125, 2126,
    2127, 2128, 2129, 2130, 2131, 111, 111, 93,
    2132, 2133, 2134, 2135, 69, 2136, 2137, 2138,
    53, 2139, 2140, 2141, 2142, 2143, 2144, 2145,
    2146, 2147, 2148, 2149, 2150, 2151, 2152, 2153,
    2154, 2155, 2156, 2157, 2158, 2159, 2160, 2161,
    2162, 2163, 112, 112, 2164, 2165, 2166, 27,
    2167, 2168, 2169, 2170, 2171, 2172, 2173, 2174,
    70, 2175, 2176, 2177, 2178, 2179, 2180, 2181,
    2182, 2183, 2184, 2185, 2186, 2187, 2188, 2189,
    2190, 2191, 2192, 2193, 2194, 2195, 44, 2196,
    2197, 113, 113, 114, 115, 115, 2198, 2199,
    2200, 2201, 2202, 2203, 2204, 2205, 2206, 2207,
    2208, 2209, 2210, 71, 2211, 2212, 2213, 116,
    94, 116, 2214, 31, 2215, 2216, 2217, 2218,
    32, 43, 2219, 2220, 2221, 2222, 2223, 2224,
    2225, 2226, 2227, 2228, 2229, 2230, 2231, 2232,
    2233, 2234, 2235, 2236, 2237, 2238, 2239, 2240,
    72, 2241, 2242, 2243, 2244, 2245, 2246, 73,
    2247, 2248, 2249, 2250, 2251, 2252, 2253, 2254,
    26, 95, 2255, 2256, 2257, 2258, 2259, 2260,
    2261, 2262, 74, 2263, 2264, 2265, 2266, 108,
    2267, 2268, 2269, 2270, 2271, 2272, 2273, 2274,
    2275, 2276, 2277, 2278, 2279, 28, 2280, 2281,
    2282, 2283, 2284, 2285, 2286, 2287, 2288, 2289},
    {2290, 75, 30, 2291, 2292, 2293, 2294, 2295,
    2296, 2297, 2298, 96, 2299, 2300, 2301, 2302,
    2303, 2304, 2305, 2306, 97, 2307, 2308, 2309,
    2310, 2311, 2312, 2313, 2314, 2315, 2316, 2317,
    2318, 98, 2319, 2320, 2321, 2322, 2323, 2324,
    2325, 2326, 2327, 2328, 117, 117, 2329, 2330,
    99, 2331, 2332, 2333, 2334, 2335, 2336, 2337,
    49, 2338, 2339, 2340, 2341, 2342, 2343, 2344,
    100, 2345, 2346, 2347, 2348, 2349, 118, 118,
    101, 109, 2350, 2351, 2352, 2353, 2354, 46,
    102, 2355, 2356, 78, 2357, 2358, 58, 2359,
    2360, 79, 2361, 2362, 2363, 119, 119, 2364,
    2365, 2366, 2367, 2368, 2369, 2370, 2371, 2372,
    2373, 2374, 2375, 2376, 2377, 2378, 2379, 2380,
    2381, 2382, 2383, 2384, 2385, 2386, 2387, 2388,
    2389, 2390, 33, 2391, 2392, 2393, 2394, 2395,
    2396, 2397, 2398, 2399, 2400, 2401, 2402, 2403,
    2404, 2405, 2406, 114, 2407, 2408, 2409, 2410,
    2411, 2412, 2413, 2414, 2415, 2416, 2417, 2418,
    52, 2419, 2420, 2421, 2422, 2423, 2424, 82,
    2425, 2426, 2427, 2428, 2429, 2430, 2431, 2432,
    2433, 2434, 2435, 2436, 2437, 2438, 2439, 2440,
    2441, 2442, 2443, 2444, 45, 2445, 2446, 2447,
    2448, 2449, 2450, 103, 2451, 2452, 2453, 2454,
    2455, 2456, 2457, 2458, 2459, 2460, 2461, 2462,
    2463, 2464, 2465, 2466, 2467, 2468, 2469, 2470,
    104, 105, 2471, 2472, 2473, 2474, 2475, 2476,
    2477, 2478, 2479, 2480, 2481, 2482, 2483, 106,
    2484, 2485, 2486, 2487, 2488, 2489, 2490, 2491,
    2492, 2493, 2494, 2495, 2496, 2497, 2498, 2499,
    2500, 2501, 2502, 2503, 2504, 2505, 2506, 2507,
    2508, 2509, 2510, 2511, 2512, 2513, 34, 34},
    {2514, 2515, 2516, 2517, 2518, 2519, 2520, 2521,
    2522, 2523, 107, 2524, 2525, 2526, 2527, 2528,
    2529, 2530, 2531, 2532, 2533, 2534, 2535, 2536,
    2537, 2538, 2539, 2540, 2541, 2542, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
    {1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0},
};

const struct properties_s uproperties[2543] = {
    {0, 0, 0, 0, 0},
    {0, 0, 0, 0, id_Start},
    {0, 0, 0, 0, pr_compat},
    {0, 0, 0, 0, id_Continue},
    {0, 0, 0, 230, 0},
    {0, 0, 0, 220, 0},
    {0, 0, 0, 0, qc_M},
    {0, 0, 0, 9, 0},
    {0, 0, 0, 1, 0},
    {0, 0, 0, 7, 0},
    {0, 0, 0, 9, id_Continue},
    {0, 0, 0, 230, id_Continue},
    {0, 0, 0, 7, id_Continue},
    {0, 0, 0, 216, 0},
    {0, 0, 0, 130, id_Continue},
    {0, 0, 0, 232, 0},
    {0, 0, 0, 220, id_Continue},
    {0, 0, 0, 234, 0},
    {0, 0, 0, 228, 0},
    {0, 0, 0, 233, 0},
    {0, 0, 0, 222, 0},
    {0, 0, 0, 107, id_Continue},
    {0, 0, 0, 122, id_Continue},
    {0, 0, 0, 202, 0},
    {-16388, 0, 0, 0, qc_N},
    {27138, 0, 0, 0, qc_N},
    {26391, 0, 0, 0, qc_N},
    {23527, 0, 0, 0, qc_N},
    {27578, 0, 0, 0, qc_N},
    {32244, 0, 0, 0, qc_N},
    {27969, 0, 0, 0, qc_N},
    {24974, 0, 0, 0, qc_N},
    {25074, 0, 0, 0, qc_N},
    {-16483, 0, 0, 0, qc_N},
    {-16514, 0, 0, 0, qc_N},
    {21375, 0, 0, 0, qc_N},
    {0, -1997, 0, 0, id_Start},
    {0, 963, 0, 0, id_Start},
    {0, 0, 0, 18, 0},
    {0, 0, 0, 19, 0},
    {0, 0, 0, 103, id_Continue},
    {0, 0, 0, 118, id_Continue},
    {0, 0, 0, 224, 0},
    {25078, 0, 0, 0, qc_N},
    {24266, 0, 0, 0, qc_N},
    {-16406, 0, 0, 0, qc_N},
    {30860, 0, 0, 0, qc_N},
    {-16423, 0, 0, 0, qc_N},
    {29575, 0, 0, 0, qc_N},
    {30064, 0, 0, 0, qc_N},
    {21271, 0, 0, 0, qc_N},
    {-16425, 0, 0, 0, qc_N},
    {-16427, 0, 0, 0, qc_N},
    {20999, 0, 0, 0, qc_N},
    {22618, 0, 0, 0, qc_N},
    {26228, 0, 0, 0, qc_N},
    {29482, 0, 0, 0, qc_N},
    {30410, 0, 0, 0, qc_N},
    {31119, 0, 0, 0, qc_N},
    {-16472, 0, 0, 0, qc_N},
    {-16474, 0, 0, 0, qc_N},
    {-16475, 0, 0, 0, qc_N},
    {20398, 0, 0, 0, qc_N},
    {20711, 0, 0, 0, qc_N},
    {20813, 0, 0, 0, qc_N},
    {21193, 0, 0, 0, qc_N},
    {21220, 0, 0, 0, qc_N},
    {21329, 0, 0, 0, qc_N},
    {21917, 0, 0, 0, qc_N},
    {22022, 0, 0, 0, qc_N},
    {23662, 0, 0, 0, qc_N},
    {24724, 0, 0, 0, qc_N},
    {25935, 0, 0, 0, qc_N},
    {26257, 0, 0, 0, qc_N},
    {26757, 0, 0, 0, qc_N},
    {28023, 0, 0, 0, qc_N},
    {28450, 0, 0, 0, qc_N},
    {29038, 0, 0, 0, qc_N},
    {31062, 0, 0, 0, qc_N},
    {31296, 0, 0, 0, qc_N},
    {31680, 0, 0, 0, qc_N},
    {-16485, 0, 0, 0, qc_N},
    {-16486, 0, 0, 0, qc_N},
    {-16488, 0, 0, 0, qc_N},
    {-16489, 0, 0, 0, qc_N},
    {-16490, 0, 0, 0, qc_N},
    {-16492, 0, 0, 0, qc_N},
    {-16494, 0, 0, 0, qc_N},
    {-16495, 0, 0, 0, qc_N},
    {-16496, 0, 0, 0, qc_N},
    {20917, 0, 0, 0, qc_N},
    {21191, 0, 0, 0, qc_N},
    {21242, 0, 0, 0, qc_N},
    {21913, 0, 0, 0, qc_N},
    {24910, 0, 0, 0, qc_N},
    {26395, 0, 0, 0, qc_N},
    {28363, 0, 0, 0, qc_N},
    {28702, 0, 0, 0, qc_N},
    {29237, 0, 0, 0, qc_N},
    {29809, 0, 0, 0, qc_N},
    {30452, 0, 0, 0, qc_N},
    {30538, 0, 0, 0, qc_N},
    {30924, 0, 0, 0, qc_N},
    {-16501, 0, 0, 0, qc_N},
    {-16506, 0, 0, 0, qc_N},
    {-16507, 0, 0, 0, qc_N},
    {-16508, 0, 0, 0, qc_N},
    {-16515, 0, 0, 0, qc_N},
    {15261, 0, 0, 0, qc_N},
    {16441, 0, 0, 0, qc_N},
    {0, 0, 0, 6, id_Continue},
    {21892, 0, 0, 0, qc_N},
    {23358, 0, 0, 0, qc_N},
    {-16596, 0, 0, 0, qc_N},
    {-16597, 0, 0, 0, qc_N},
    {24354, 0, 0, 0, qc_N},
    {24908, 0, 0, 0, qc_N},
    {16056, 0, 0, 0, qc_N},
    {30495, 0, 0, 0, qc_N},
    {-16638, 0, 0, 0, qc_N},
    {0, 0, 4537, 0, 0},
    {0, 0, 4348, 0, 0},
    {0, 0, 4600, 0, 0},
    {0, 97, 1, 0, id_Start},
    {0, 98, 15499, 0, id_Start},
    {0, 99, 64, 0, id_Start},
    {0, 100, 1009, 0, id_Start},
    {0, 101, 127, 0, id_Start},
    {0, 102, 16003, 0, id_Start},
    {0, 103, 1135, 0, id_Start},
    {0, 104, 1261, 0, id_Start},
    {0, 105, 190, 0, id_Start},
    {0, 106, 1387, 0, id_Start},
    {0, 107, 1513, 0, id_Start},
    {0, 108, 1639, 0, id_Start},
    {0, 109, 16381, 0, id_Start},
    {0, 110, 253, 0, id_Start},
    {0, 111, 316, 0, id_Start},
    {0, 112, 16633, 0, id_Start},
    {0, 113, 0, 0, id_Start},
    {0, 114, 1765, 0, id_Start},
    {0, 115, 1891, 0, id_Start},
    {0, 116, 2017, 0, id_Start},
    {0, 117, 379, 0, id_Start},
    {0, 118, 17515, 0, id_Start},
    {0, 119, 2143, 0, id_Start},
    {0, 120, 17641, 0, id_Start},
    {0, 121, 442, 0, id_Start},
    {0, 122, 2269, 0, id_Start},
    {0, 0, 505, 0, id_Start},
    {0, 0, 15562, 0, id_Start},
    {0, 0, 568, 0, id_Start},
    {0, 0, 1072, 0, id_Start},
    {0, 0, 631, 0, id_Start},
    {0, 0, 16066, 0, id_Start},
    {0, 0, 1198, 0, id_Start},
    {0, 0, 1324, 0, id_Start},
    {0, 0, 694, 0, id_Start},
    {0, 0, 1450, 0, id_Start},
    {0, 0, 1576, 0, id_Start},
    {0, 0, 1702, 0, id_Start},
    {0, 0, 16444, 0, id_Start},
    {0, 0, 757, 0, id_Start},
    {0, 0, 820, 0, id_Start},
    {0, 0, 16696, 0, id_Start},
    {0, 0, 1828, 0, id_Start},
    {0, 0, 1954, 0, id_Start},
    {0, 0, 2080, 0, id_Start},
    {0, 0, 883, 0, id_Start},
    {0, 0, 17578, 0, id_Start},
    {0, 0, 2206, 0, id_Start},
    {0, 0, 17704, 0, id_Start},
    {0, 0, 946, 0, id_Start},
    {0, 0, 2332, 0, id_Start},
    {0, 0, 6175, 0, pr_compat},
    {-1, 224, 0, 0, id_Start},
    {-3, 225, 0, 0, id_Start},
    {-5, 226, 17830, 0, id_Start},
    {-7, 227, 0, 0, id_Start},
    {-9, 228, 2710, 0, id_Start},
    {-11, 229, 3340, 0, id_Start},
    {0, 230, 2962, 0, id_Start},
    {-13, 231, 15625, 0, id_Start},
    {-15, 232, 0, 0, id_Start},
    {-17, 233, 0, 0, id_Start},
    {-19, 234, 18208, 0, id_Start},
    {-21, 235, 0, 0, id_Start},
    {-23, 236, 0, 0, id_Start},
    {-25, 237, 0, 0, id_Start},
    {-27, 238, 0, 0, id_Start},
    {-29, 239, 16129, 0, id_Start},
    {0, 240, 0, 0, id_Start},
    {-31, 241, 0, 0, id_Start},
    {-33, 242, 0, 0, id_Start},
    {-35, 243, 0, 0, id_Start},
    {-37, 244, 18460, 0, id_Start},
    {-39, 245, 3844, 0, id_Start},
    {-41, 246, 3718, 0, id_Start},
    {0, 248, 3466, 0, id_Start},
    {-43, 249, 0, 0, id_Start},
    {-45, 250, 0, 0, id_Start},
    {-47, 251, 0, 0, id_Start},
    {-49, 252, 2584, 0, id_Start},
    {-51, 253, 0, 0, id_Start},
    {0, 254, 0, 0, id_Start},
    {-53, 0, 0, 0, id_Start},
    {-55, 0, 0, 0, id_Start},
    {-57, 0, 17893, 0, id_Start},
    {-59, 0, 0, 0, id_Start},
    {-61, 0, 2773, 0, id_Start},
    {-63, 0, 3403, 0, id_Start},
    {0, 0, 3025, 0, id_Start},
    {-65, 0, 15688, 0, id_Start},
    {-67, 0, 0, 0, id_Start},
    {-69, 0, 0, 0, id_Start},
    {-71, 0, 18271, 0, id_Start},
    {-73, 0, 0, 0, id_Start},
    {-75, 0, 0, 0, id_Start},
    {-77, 0, 0, 0, id_Start},
    {-79, 0, 0, 0, id_Start},
    {-81, 0, 16192, 0, id_Start},
    {-83, 0, 0, 0, id_Start},
    {-85, 0, 0, 0, id_Start},
    {-87, 0, 0, 0, id_Start},
    {-89, 0, 18523, 0, id_Start},
    {-91, 0, 3907, 0, id_Start},
    {-93, 0, 3781, 0, id_Start},
    {0, 0, 3529, 0, id_Start},
    {-95, 0, 0, 0, id_Start},
    {-97, 0, 0, 0, id_Start},
    {-99, 0, 0, 0, id_Start},
    {-101, 0, 2647, 0, id_Start},
    {-103, 0, 0, 0, id_Start},
    {-105, 0, 0, 0, id_Start},
    {-107, 257, 0, 0, id_Start},
    {-109, 0, 0, 0, id_Start},
    {-111, 259, 18082, 0, id_Start},
    {-113, 0, 18145, 0, id_Start},
    {-115, 261, 0, 0, id_Start},
    {-117, 0, 0, 0, id_Start},
    {-119, 263, 0, 0, id_Start},
    {-121, 0, 0, 0, id_Start},
    {-123, 265, 0, 0, id_Start},
    {-125, 0, 0, 0, id_Start},
    {-127, 267, 0, 0, id_Start},
    {-129, 0, 0, 0, id_Start},
    {-131, 269, 0, 0, id_Start},
    {-133, 0, 0, 0, id_Start},
    {-135, 271, 0, 0, id_Start},
    {-137, 0, 0, 0, id_Start},
    {0, 273, 0, 0, id_Start},
    {-139, 275, 15751, 0, id_Start},
    {-141, 0, 15814, 0, id_Start},
    {-143, 277, 0, 0, id_Start},
    {-145, 0, 0, 0, id_Start},
    {-147, 279, 0, 0, id_Start},
    {-149, 0, 0, 0, id_Start},
    {-151, 281, 0, 0, id_Start},
    {-153, 0, 0, 0, id_Start},
    {-155, 283, 0, 0, id_Start},
    {-157, 0, 0, 0, id_Start},
    {-159, 285, 0, 0, id_Start},
    {-161, 0, 0, 0, id_Start},
    {-163, 287, 0, 0, id_Start},
    {-165, 0, 0, 0, id_Start},
    {-167, 289, 0, 0, id_Start},
    {-169, 0, 0, 0, id_Start},
    {-171, 291, 0, 0, id_Start},
    {-173, 0, 0, 0, id_Start},
    {-175, 293, 0, 0, id_Start},
    {-177, 0, 0, 0, id_Start},
    {0, 295, 0, 0, id_Start},
    {-179, 297, 0, 0, id_Start},
    {-181, 0, 0, 0, id_Start},
    {-183, 299, 0, 0, id_Start},
    {-185, 0, 0, 0, id_Start},
    {-187, 301, 0, 0, id_Start},
    {-189, 0, 0, 0, id_Start},
    {-191, 303, 0, 0, id_Start},
    {-193, 0, 0, 0, id_Start},
    {-195, -1999, 0, 0, id_Start},
    {-197, 309, 0, 0, id_Start},
    {-199, 0, 0, 0, id_Start},
    {-201, 311, 0, 0, id_Start},
    {-203, 0, 0, 0, id_Start},
    {-205, 314, 0, 0, id_Start},
    {-207, 0, 0, 0, id_Start},
    {-209, 316, 0, 0, id_Start},
    {-211, 0, 0, 0, id_Start},
    {-213, 318, 0, 0, id_Start},
    {-215, 0, 0, 0, id_Start},
    {0, 322, 0, 0, id_Start},
    {-217, 324, 0, 0, id_Start},
    {-219, 0, 0, 0, id_Start},
    {-221, 326, 0, 0, id_Start},
    {-223, 0, 0, 0, id_Start},
    {-225, 328, 0, 0, id_Start},
    {-227, 0, 0, 0, id_Start},
    {0, 331, 0, 0, id_Start},
    {-229, 333, 16507, 0, id_Start},
    {-231, 0, 16570, 0, id_Start},
    {-233, 335, 0, 0, id_Start},
    {-235, 0, 0, 0, id_Start},
    {-237, 337, 0, 0, id_Start},
    {-239, 0, 0, 0, id_Start},
    {0, 339, 0, 0, id_Start},
    {-241, 341, 0, 0, id_Start},
    {-243, 0, 0, 0, id_Start},
    {-245, 343, 0, 0, id_Start},
    {-247, 0, 0, 0, id_Start},
    {-249, 345, 0, 0, id_Start},
    {-251, 0, 0, 0, id_Start},
    {-253, 347, 16885, 0, id_Start},
    {-255, 0, 16948, 0, id_Start},
    {-257, 349, 0, 0, id_Start},
    {-259, 0, 0, 0, id_Start},
    {-261, 351, 0, 0, id_Start},
    {-263, 0, 0, 0, id_Start},
    {-265, 353, 17011, 0, id_Start},
    {-267, 0, 17074, 0, id_Start},
    {-269, 355, 0, 0, id_Start},
    {-271, 0, 0, 0, id_Start},
    {-273, 357, 0, 0, id_Start},
    {-275, 0, 0, 0, id_Start},
    {0, 359, 0, 0, id_Start},
    {-277, 361, 17263, 0, id_Start},
    {-279, 0, 17326, 0, id_Start},
    {-281, 363, 17389, 0, id_Start},
    {-283, 0, 17452, 0, id_Start},
    {-285, 365, 0, 0, id_Start},
    {-287, 0, 0, 0, id_Start},
    {-289, 367, 0, 0, id_Start},
    {-291, 0, 0, 0, id_Start},
    {-293, 369, 0, 0, id_Start},
    {-295, 0, 0, 0, id_Start},
    {-297, 371, 0, 0, id_Start},
    {-299, 0, 0, 0, id_Start},
    {-301, 373, 0, 0, id_Start},
    {-303, 0, 0, 0, id_Start},
    {-305, 375, 0, 0, id_Start},
    {-307, 0, 0, 0, id_Start},
    {-309, 255, 0, 0, id_Start},
    {-311, 378, 0, 0, id_Start},
    {-313, 0, 0, 0, id_Start},
    {-315, 380, 0, 0, id_Start},
    {-317, 0, 0, 0, id_Start},
    {-319, 382, 0, 0, id_Start},
    {-321, 0, 0, 0, id_Start},
    {0, 0, 17767, 0, pr_compat},
    {0, 601, 0, 0, id_Start},
    {-323, 417, 18712, 0, id_Start},
    {-325, 0, 18775, 0, id_Start},
    {-327, 432, 18838, 0, id_Start},
    {-329, 0, 18901, 0, id_Start},
    {0, 0, 3214, 0, 0},
    {-331, 462, 0, 0, id_Start},
    {-333, 0, 0, 0, id_Start},
    {-335, 464, 0, 0, id_Start},
    {-337, 0, 0, 0, id_Start},
    {-339, 466, 0, 0, id_Start},
    {-341, 0, 0, 0, id_Start},
    {-343, 468, 0, 0, id_Start},
    {-345, 0, 0, 0, id_Start},
    {-347, 470, 0, 0, id_Start},
    {-349, 0, 0, 0, id_Start},
    {-351, 472, 0, 0, id_Start},
    {-353, 0, 0, 0, id_Start},
    {-355, 474, 0, 0, id_Start},
    {-357, 0, 0, 0, id_Start},
    {-359, 476, 0, 0, id_Start},
    {-361, 0, 0, 0, id_Start},
    {-363, 479, 0, 0, id_Start},
    {-365, 0, 0, 0, id_Start},
    {-367, 481, 0, 0, id_Start},
    {-369, 0, 0, 0, id_Start},
    {-371, 483, 0, 0, id_Start},
    {-373, 0, 0, 0, id_Start},
    {-375, 487, 0, 0, id_Start},
    {-377, 0, 0, 0, id_Start},
    {-379, 489, 0, 0, id_Start},
    {-381, 0, 0, 0, id_Start},
    {-383, 491, 3088, 0, id_Start},
    {-385, 0, 3151, 0, id_Start},
    {-387, 493, 0, 0, id_Start},
    {-389, 0, 0, 0, id_Start},
    {-391, 495, 0, 0, id_Start},
    {-393, 0, 0, 0, id_Start},
    {-395, 0, 0, 0, id_Start},
    {-397, 501, 0, 0, id_Start},
    {-399, 0, 0, 0, id_Start},
    {-401, 505, 0, 0, id_Start},
    {-403, 0, 0, 0, id_Start},
    {-405, 507, 0, 0, id_Start},
    {-407, 0, 0, 0, id_Start},
    {-409, 509, 0, 0, id_Start},
    {-411, 0, 0, 0, id_Start},
    {-413, 511, 0, 0, id_Start},
    {-415, 0, 0, 0, id_Start},
    {-417, 513, 0, 0, id_Start},
    {-419, 0, 0, 0, id_Start},
    {-421, 515, 0, 0, id_Start},
    {-423, 0, 0, 0, id_Start},
    {-425, 517, 0, 0, id_Start},
    {-427, 0, 0, 0, id_Start},
    {-429, 519, 0, 0, id_Start},
    {-431, 0, 0, 0, id_Start},
    {-433, 521, 0, 0, id_Start},
    {-435, 0, 0, 0, id_Start},
    {-437, 523, 0, 0, id_Start},
    {-439, 0, 0, 0, id_Start},
    {-441, 525, 0, 0, id_Start},
    {-443, 0, 0, 0, id_Start},
    {-445, 527, 0, 0, id_Start},
    {-447, 0, 0, 0, id_Start},
    {-449, 529, 0, 0, id_Start},
    {-451, 0, 0, 0, id_Start},
    {-453, 531, 0, 0, id_Start},
    {-455, 0, 0, 0, id_Start},
    {-457, 533, 0, 0, id_Start},
    {-459, 0, 0, 0, id_Start},
    {-461, 535, 0, 0, id_Start},
    {-463, 0, 0, 0, id_Start},
    {-465, 537, 0, 0, id_Start},
    {-467, 0, 0, 0, id_Start},
    {-469, 539, 0, 0, id_Start},
    {-471, 0, 0, 0, id_Start},
    {-473, 543, 0, 0, id_Start},
    {-475, 0, 0, 0, id_Start},
    {-477, 551, 2836, 0, id_Start},
    {-479, 0, 2899, 0, id_Start},
    {-481, 553, 15877, 0, id_Start},
    {-483, 0, 15940, 0, id_Start},
    {-485, 555, 0, 0, id_Start},
    {-487, 0, 0, 0, id_Start},
    {-489, 557, 0, 0, id_Start},
    {-491, 0, 0, 0, id_Start},
    {-493, 559, 3970, 0, id_Start},
    {-495, 0, 4033, 0, id_Start},
    {-497, 561, 0, 0, id_Start},
    {-499, 0, 0, 0, id_Start},
    {-501, 563, 0, 0, id_Start},
    {-503, 0, 0, 0, id_Start},
    {0, 0, 3277, 0, 0},
    {0, 0, -1, 230, id_Continue | qc_M},
    {0, 0, -2, 230, id_Continue | qc_M},
    {0, 0, -3, 230, id_Continue | qc_M},
    {0, 0, -4, 230, id_Continue | qc_M},
    {0, 0, -8, 230, id_Continue | qc_M},
    {0, 0, -9, 230, id_Continue | qc_M},
    {0, 0, -11, 230, id_Continue | qc_M},
    {0, 0, -5, 230, id_Continue | qc_M},
    {0, 0, -59, 230, id_Continue | qc_M},
    {0, 0, -6, 230, id_Continue | qc_M},
    {0, 0, -13, 230, id_Continue | qc_M},
    {0, 0, -12, 230, id_Continue | qc_M},
    {0, 0, -16, 230, id_Continue | qc_M},
    {0, 0, -17, 230, id_Continue | qc_M},
    {0, 0, -60, 230, id_Continue | qc_M},
    {0, 0, -61, 230, id_Continue | qc_M},
    {0, 0, -15, 216, id_Continue | qc_M},
    {0, 0, -53, 220, id_Continue | qc_M},
    {0, 0, -58, 220, id_Continue | qc_M},
    {0, 0, -52, 220, id_Continue | qc_M},
    {0, 0, -18, 220, id_Continue | qc_M},
    {0, 0, -7, 202, id_Continue | qc_M},
    {0, 0, -10, 202, id_Continue | qc_M},
    {0, 0, -55, 220, id_Continue | qc_M},
    {0, 0, -57, 220, id_Continue | qc_M},
    {0, 0, -56, 220, id_Continue | qc_M},
    {0, 0, -54, 220, id_Continue | qc_M},
    {0, 0, 0, 1, id_Continue},
    {0, 0, -14, 1, id_Continue | qc_M},
    {768, 0, 0, 230, qc_N},
    {769, 0, 0, 230, qc_N},
    {0, 0, -62, 230, id_Continue | qc_M},
    {787, 0, 0, 230, qc_N},
    {-505, 0, 0, 230, qc_N},
    {0, 953, -63, 240, id_Continue | qc_M},
    {697, 0, 0, 0, qc_N},
    {59, 0, 0, 0, qc_N},
    {-507, 0, 0, 0, 0},
    {-509, 940, 0, 0, id_Start},
    {183, 0, 0, 0, qc_N},
    {-511, 941, 0, 0, id_Start},
    {-513, 942, 0, 0, id_Start},
    {-515, 943, 0, 0, id_Start},
    {-517, 972, 0, 0, id_Start},
    {-519, 973, 0, 0, id_Start},
    {-521, 974, 0, 0, id_Start},
    {-523, 0, 0, 0, id_Start},
    {0, 945, 6238, 0, id_Start},
    {0, 946, 0, 0, id_Start},
    {0, 947, 0, 0, id_Start},
    {0, 948, 0, 0, id_Start},
    {0, 949, 6301, 0, id_Start},
    {0, 950, 0, 0, id_Start},
    {0, 951, 6364, 0, id_Start},
    {0, 952, 0, 0, id_Start},
    {0, 953, 6427, 0, id_Start},
    {0, 954, 0, 0, id_Start},
    {0, 955, 0, 0, id_Start},
    {0, 956, 0, 0, id_Start},
    {0, 957, 0, 0, id_Start},
    {0, 958, 0, 0, id_Start},
    {0, 959, 6490, 0, id_Start},
    {0, 960, 0, 0, id_Start},
    {0, 961, 23500, 0, id_Start},
    {0, 964, 0, 0, id_Start},
    {0, 965, 6553, 0, id_Start},
    {0, 966, 0, 0, id_Start},
    {0, 967, 0, 0, id_Start},
    {0, 968, 0, 0, id_Start},
    {0, 969, 6616, 0, id_Start},
    {-525, 970, 0, 0, id_Start},
    {-527, 971, 0, 0, id_Start},
    {-529, 0, 22996, 0, id_Start},
    {-531, 0, 0, 0, id_Start},
    {-533, 0, 23185, 0, id_Start},
    {-535, 0, 0, 0, id_Start},
    {-537, 0, 0, 0, id_Start},
    {0, 0, 6742, 0, id_Start},
    {0, 0, 6805, 0, id_Start},
    {0, 0, 6868, 0, id_Start},
    {0, 0, 6931, 0, id_Start},
    {0, 0, 7120, 0, id_Start},
    {0, 0, 23437, 0, id_Start},
    {0, 0, 7057, 0, id_Start},
    {0, 0, 7183, 0, id_Start},
    {-539, 0, 6679, 0, id_Start},
    {-541, 0, 6994, 0, id_Start},
    {-543, 0, 0, 0, id_Start},
    {-545, 0, 0, 0, id_Start},
    {-547, 0, 23626, 0, id_Start},
    {0, 0, 7246, 0, pr_compat},
    {-549, 0, 0, 0, 0},
    {-551, 0, 0, 0, 0},
    {0, 891, 0, 0, id_Start},
    {0, 892, 0, 0, id_Start},
    {0, 893, 0, 0, id_Start},
    {-553, 1104, 0, 0, id_Start},
    {-555, 1105, 0, 0, id_Start},
    {0, 1106, 0, 0, id_Start},
    {-557, 1107, 0, 0, id_Start},
    {0, 1108, 0, 0, id_Start},
    {0, 1109, 0, 0, id_Start},
    {0, 1110, 7435, 0, id_Start},
    {-559, 1111, 0, 0, id_Start},
    {0, 1112, 0, 0, id_Start},
    {0, 1113, 0, 0, id_Start},
    {0, 1114, 0, 0, id_Start},
    {0, 1115, 0, 0, id_Start},
    {-561, 1116, 0, 0, id_Start},
    {-563, 1117, 0, 0, id_Start},
    {-565, 1118, 0, 0, id_Start},
    {0, 1119, 0, 0, id_Start},
    {0, 1072, 8317, 0, id_Start},
    {0, 1073, 0, 0, id_Start},
    {0, 1074, 0, 0, id_Start},
    {0, 1075, 7372, 0, id_Start},
    {0, 1076, 0, 0, id_Start},
    {0, 1077, 7309, 0, id_Start},
    {0, 1078, 8191, 0, id_Start},
    {0, 1079, 8569, 0, id_Start},
    {0, 1080, 7561, 0, id_Start},
    {-567, 1081, 0, 0, id_Start},
    {0, 1082, 7498, 0, id_Start},
    {0, 1083, 0, 0, id_Start},
    {0, 1084, 0, 0, id_Start},
    {0, 1085, 0, 0, id_Start},
    {0, 1086, 8695, 0, id_Start},
    {0, 1087, 0, 0, id_Start},
    {0, 1088, 0, 0, id_Start},
    {0, 1089, 0, 0, id_Start},
    {0, 1090, 0, 0, id_Start},
    {0, 1091, 7624, 0, id_Start},
    {0, 1092, 0, 0, id_Start},
    {0, 1093, 0, 0, id_Start},
    {0, 1094, 0, 0, id_Start},
    {0, 1095, 9073, 0, id_Start},
    {0, 1096, 0, 0, id_Start},
    {0, 1097, 0, 0, id_Start},
    {0, 1098, 0, 0, id_Start},
    {0, 1099, 9199, 0, id_Start},
    {0, 1100, 0, 0, id_Start},
    {0, 1101, 8947, 0, id_Start},
    {0, 1102, 0, 0, id_Start},
    {0, 1103, 0, 0, id_Start},
    {0, 0, 8380, 0, id_Start},
    {0, 0, 7813, 0, id_Start},
    {0, 0, 7750, 0, id_Start},
    {0, 0, 8254, 0, id_Start},
    {0, 0, 8632, 0, id_Start},
    {0, 0, 7687, 0, id_Start},
    {-569, 0, 0, 0, id_Start},
    {0, 0, 7939, 0, id_Start},
    {0, 0, 8758, 0, id_Start},
    {0, 0, 8002, 0, id_Start},
    {0, 0, 9136, 0, id_Start},
    {0, 0, 9262, 0, id_Start},
    {0, 0, 9010, 0, id_Start},
    {-571, 0, 0, 0, id_Start},
    {-573, 0, 0, 0, id_Start},
    {-575, 0, 0, 0, id_Start},
    {0, 0, 7876, 0, id_Start},
    {-577, 0, 0, 0, id_Start},
    {-579, 0, 0, 0, id_Start},
    {-581, 0, 0, 0, id_Start},
    {-583, 0, 0, 0, id_Start},
    {0, 0, 8065, 0, 0},
    {0, 0, 8128, 0, 0},
    {-585, 0, 0, 0, 0},
    {-587, 0, 0, 0, 0},
    {0, 1163, 0, 0, id_Start},
    {0, 1165, 0, 0, id_Start},
    {0, 1167, 0, 0, id_Start},
    {0, 1169, 0, 0, id_Start},
    {0, 1171, 0, 0, id_Start},
    {0, 1173, 0, 0, id_Start},
    {0, 1175, 0, 0, id_Start},
    {0, 1177, 0, 0, id_Start},
    {0, 1179, 0, 0, id_Start},
    {0, 1181, 0, 0, id_Start},
    {0, 1183, 0, 0, id_Start},
    {0, 1185, 0, 0, id_Start},
    {0, 1187, 0, 0, id_Start},
    {0, 1189, 0, 0, id_Start},
    {0, 1191, 0, 0, id_Start},
    {0, 1193, 0, 0, id_Start},
    {0, 1195, 0, 0, id_Start},
    {0, 1197, 0, 0, id_Start},
    {0, 1199, 0, 0, id_Start},
    {0, 1201, 0, 0, id_Start},
    {0, 1203, 0, 0, id_Start},
    {0, 1205, 0, 0, id_Start},
    {0, 1207, 0, 0, id_Start},
    {0, 1209, 0, 0, id_Start},
    {0, 1211, 0, 0, id_Start},
    {0, 1213, 0, 0, id_Start},
    {0, 1215, 0, 0, id_Start},
    {0, 1231, 0, 0, id_Start},
    {-589, 1218, 0, 0, id_Start},
    {-591, 0, 0, 0, id_Start},
    {0, 1220, 0, 0, id_Start},
    {0, 1222, 0, 0, id_Start},
    {0, 1224, 0, 0, id_Start},
    {0, 1226, 0, 0, id_Start},
    {0, 1228, 0, 0, id_Start},
    {0, 1230, 0, 0, id_Start},
    {-593, 1233, 0, 0, id_Start},
    {-595, 0, 0, 0, id_Start},
    {-597, 1235, 0, 0, id_Start},
    {-599, 0, 0, 0, id_Start},
    {0, 1237, 0, 0, id_Start},
    {-601, 1239, 0, 0, id_Start},
    {-603, 0, 0, 0, id_Start},
    {0, 1241, 8443, 0, id_Start},
    {0, 0, 8506, 0, id_Start},
    {-605, 1243, 0, 0, id_Start},
    {-607, 0, 0, 0, id_Start},
    {-609, 1245, 0, 0, id_Start},
    {-611, 0, 0, 0, id_Start},
    {-613, 1247, 0, 0, id_Start},
    {-615, 0, 0, 0, id_Start},
    {0, 1249, 0, 0, id_Start},
    {-617, 1251, 0, 0, id_Start},
    {-619, 0, 0, 0, id_Start},
    {-621, 1253, 0, 0, id_Start},
    {-623, 0, 0, 0, id_Start},
    {-625, 1255, 0, 0, id_Start},
    {-627, 0, 0, 0, id_Start},
    {0, 1257, 8821, 0, id_Start},
    {0, 0, 8884, 0, id_Start},
    {-629, 1259, 0, 0, id_Start},
    {-631, 0, 0, 0, id_Start},
    {-633, 1261, 0, 0, id_Start},
    {-635, 0, 0, 0, id_Start},
    {-637, 1263, 0, 0, id_Start},
    {-639, 0, 0, 0, id_Start},
    {-641, 1265, 0, 0, id_Start},
    {-643, 0, 0, 0, id_Start},
    {-645, 1267, 0, 0, id_Start},
    {-647, 0, 0, 0, id_Start},
    {-649, 1269, 0, 0, id_Start},
    {-651, 0, 0, 0, id_Start},
    {0, 1271, 0, 0, id_Start},
    {-653, 1273, 0, 0, id_Start},
    {-655, 0, 0, 0, id_Start},
    {0, 1275, 0, 0, id_Start},
    {0, 1277, 0, 0, id_Start},
    {0, 1279, 0, 0, id_Start},
    {0, 1297, 0, 0, id_Start},
    {0, 1299, 0, 0, id_Start},
    {0, 1301, 0, 0, id_Start},
    {0, 1303, 0, 0, id_Start},
    {0, 1305, 0, 0, id_Start},
    {0, 1307, 0, 0, id_Start},
    {0, 1309, 0, 0, id_Start},
    {0, 1311, 0, 0, id_Start},
    {0, 1313, 0, 0, id_Start},
    {0, 1315, 0, 0, id_Start},
    {0, 1317, 0, 0, id_Start},
    {0, 1319, 0, 0, id_Start},
    {0, 1321, 0, 0, id_Start},
    {0, 1327, 0, 0, id_Start},
    {0, 1377, 0, 0, id_Start},
    {0, 1378, 0, 0, id_Start},
    {0, 1379, 0, 0, id_Start},
    {0, 1380, 0, 0, id_Start},
    {0, 1381, 0, 0, id_Start},
    {0, 1382, 0, 0, id_Start},
    {0, 1383, 0, 0, id_Start},
    {0, 1384, 0, 0, id_Start},
    {0, 1385, 0, 0, id_Start},
    {0, 1386, 0, 0, id_Start},
    {0, 1387, 0, 0, id_Start},
    {0, 1388, 0, 0, id_Start},
    {0, 1389, 0, 0, id_Start},
    {0, 1390, 0, 0, id_Start},
    {0, 1391, 0, 0, id_Start},
    {0, 1392, 0, 0, id_Start},
    {0, 1393, 0, 0, id_Start},
    {0, 1394, 0, 0, id_Start},
    {0, 1395, 0, 0, id_Start},
    {0, 1396, 0, 0, id_Start},
    {0, 1397, 0, 0, id_Start},
    {0, 1398, 0, 0, id_Start},
    {0, 1399, 0, 0, id_Start},
    {0, 1400, 0, 0, id_Start},
    {0, 1401, 0, 0, id_Start},
    {0, 1402, 0, 0, id_Start},
    {0, 1403, 0, 0, id_Start},
    {0, 1404, 0, 0, id_Start},
    {0, 1405, 0, 0, id_Start},
    {0, 1406, 0, 0, id_Start},
    {0, 1407, 0, 0, id_Start},
    {0, 1408, 0, 0, id_Start},
    {0, 1409, 0, 0, id_Start},
    {0, 1410, 0, 0, id_Start},
    {0, 1411, 0, 0, id_Start},
    {0, 1412, 0, 0, id_Start},
    {0, 1413, 0, 0, id_Start},
    {0, 1414, 0, 0, id_Start},
    {0, 0, 0, 10, 0},
    {0, 0, 0, 11, 0},
    {0, 0, 0, 12, 0},
    {0, 0, 0, 13, 0},
    {0, 0, 0, 14, id_Continue},
    {0, 0, 0, 15, 0},
    {0, 0, 0, 16, 0},
    {0, 0, 0, 17, 0},
    {0, 0, 0, 20, 0},
    {0, 0, 0, 21, 0},
    {0, 0, 0, 22, 0},
    {0, 0, 0, 23, 0},
    {0, 0, 0, 24, 0},
    {0, 0, 0, 25, 0},
    {0, 0, 0, 30, 0},
    {0, 0, 0, 31, 0},
    {0, 0, 0, 32, 0},
    {-657, 0, 0, 0, id_Start},
    {-659, 0, 0, 0, id_Start},
    {-661, 0, 0, 0, id_Start},
    {-663, 0, 0, 0, id_Start},
    {-665, 0, 0, 0, id_Start},
    {0, 0, 9325, 0, id_Start},
    {0, 0, 9388, 0, id_Start},
    {0, 0, 9451, 0, id_Start},
    {0, 0, 0, 27, id_Continue},
    {0, 0, 0, 28, id_Continue},
    {0, 0, 0, 29, id_Continue},
    {0, 0, 0, 30, id_Continue},
    {0, 0, 0, 31, id_Continue},
    {0, 0, 0, 32, id_Continue},
    {0, 0, 0, 33, id_Continue},
    {0, 0, 0, 34, id_Continue},
    {0, 0, -19, 230, id_Continue | qc_M},
    {0, 0, -20, 230, id_Continue | qc_M},
    {0, 0, -21, 220, id_Continue | qc_M},
    {0, 0, 0, 35, id_Continue},
    {-667, 0, 0, 0, id_Start},
    {0, 0, 9577, 0, id_Start},
    {-669, 0, 0, 0, id_Start},
    {0, 0, 9640, 0, id_Start},
    {-671, 0, 0, 0, id_Start},
    {0, 0, 9514, 0, id_Start},
    {0, 0, 0, 36, 0},
    {0, 0, 0, 27, 0},
    {0, 0, 0, 28, 0},
    {0, 0, 0, 29, 0},
    {0, 0, 9703, 0, id_Start},
    {-673, 0, 0, 0, id_Start},
    {0, 0, 9766, 0, id_Start},
    {-675, 0, 0, 0, id_Start},
    {0, 0, 9829, 0, id_Start},
    {-677, 0, 0, 0, id_Start},
    {0, 0, -22, 7, id_Continue | qc_M},
    {-679, 0, 0, 0, qc_N},
    {-681, 0, 0, 0, qc_N},
    {-683, 0, 0, 0, qc_N},
    {-685, 0, 0, 0, qc_N},
    {-687, 0, 0, 0, qc_N},
    {-689, 0, 0, 0, qc_N},
    {-691, 0, 0, 0, qc_N},
    {-693, 0, 0, 0, qc_N},
    {0, 0, -23, 0, id_Continue | qc_M},
    {0, 0, 9892, 0, id_Continue},
    {-695, 0, 0, 0, id_Continue},
    {-697, 0, 0, 0, id_Continue},
    {0, 0, -24, 0, id_Continue | qc_M},
    {-699, 0, 0, 0, qc_N},
    {-701, 0, 0, 0, qc_N},
    {-703, 0, 0, 0, qc_N},
    {-705, 0, 0, 0, qc_N},
    {-707, 0, 0, 0, qc_N},
    {-709, 0, 0, 0, qc_N},
    {-711, 0, 0, 0, qc_N},
    {-713, 0, 0, 0, qc_N},
    {-715, 0, 0, 0, qc_N},
    {0, 0, -26, 0, id_Continue | qc_M},
    {0, 0, 10144, 0, id_Continue},
    {-717, 0, 0, 0, id_Continue},
    {-719, 0, 0, 0, id_Continue},
    {-721, 0, 0, 0, id_Continue},
    {0, 0, -25, 0, id_Continue | qc_M},
    {0, 0, -27, 0, id_Continue | qc_M},
    {-723, 0, 0, 0, qc_N},
    {-725, 0, 0, 0, qc_N},
    {0, 0, 10207, 0, id_Start},
    {-727, 0, 0, 0, id_Start},
    {0, 0, -29, 0, id_Continue | qc_M},
    {0, 0, 10270, 0, id_Continue},
    {0, 0, 10333, 0, id_Continue},
    {-729, 0, 0, 0, id_Continue},
    {-731, 0, 0, 0, id_Continue},
    {-733, 0, 0, 0, id_Continue},
    {0, 0, -28, 0, id_Continue | qc_M},
    {0, 0, 10522, 0, id_Continue},
    {-735, 0, 0, 0, id_Continue},
    {0, 0, 0, 84, id_Continue},
    {0, 0, -30, 91, id_Continue | qc_M},
    {0, 0, 10648, 0, id_Continue},
    {-737, 0, 0, 0, id_Continue},
    {0, 0, -33, 0, id_Continue | qc_M},
    {0, 0, 10711, 0, id_Continue},
    {-739, 0, 0, 0, id_Continue},
    {-741, 0, 0, 0, id_Continue},
    {-743, 0, 10774, 0, id_Continue},
    {-745, 0, 0, 0, id_Continue},
    {0, 0, -31, 0, id_Continue | qc_M},
    {0, 0, -32, 0, id_Continue | qc_M},
    {0, 0, -34, 0, id_Continue | qc_M},
    {0, 0, 10837, 0, id_Continue},
    {0, 0, 10900, 0, id_Continue},
    {-747, 0, 0, 0, id_Continue},
    {-749, 0, 0, 0, id_Continue},
    {-751, 0, 0, 0, id_Continue},
    {0, 0, -35, 0, id_Continue | qc_M},
    {0, 0, -36, 9, id_Continue | qc_M},
    {0, 0, -37, 0, id_Continue | qc_M},
    {0, 0, 10963, 0, id_Continue},
    {-753, 0, 0, 0, id_Continue},
    {-755, 0, 11026, 0, id_Continue},
    {-757, 0, 0, 0, id_Continue},
    {-759, 0, 0, 0, id_Continue},
    {0, 0, -38, 0, qc_M},
    {-761, 0, 0, 0, qc_N},
    {-763, 0, 0, 0, qc_N},
    {-765, 0, 0, 0, qc_N},
    {-767, 0, 0, 0, qc_N},
    {-769, 0, 0, 0, qc_N},
    {-771, 0, 0, 0, qc_N},
    {0, 0, 0, 129, id_Continue},
    {-773, 0, 0, 0, qc_N},
    {0, 0, 0, 132, id_Continue},
    {-775, 0, 0, 0, qc_N},
    {-777, 0, 0, 0, qc_N},
    {-779, 0, 0, 0, qc_N},
    {-781, 0, 0, 0, qc_N},
    {-783, 0, 0, 0, qc_N},
    {-785, 0, 0, 0, qc_N},
    {-787, 0, 0, 0, qc_N},
    {-789, 0, 0, 0, qc_N},
    {-791, 0, 0, 0, qc_N},
    {-793, 0, 0, 0, qc_N},
    {0, 0, 11089, 0, id_Start},
    {-795, 0, 0, 0, id_Start},
    {0, 0, -39, 0, id_Continue | qc_M},
    {0, 11559, 0, 0, id_Start},
    {0, 11565, 0, 0, id_Start},
    {0, 0, 14806, 0, 0},
    {-797, 0, 0, 0, 0},
    {0, 0, 14869, 0, 0},
    {-799, 0, 0, 0, 0},
    {0, 0, 14932, 0, 0},
    {-801, 0, 0, 0, 0},
    {0, 0, 14995, 0, 0},
    {-803, 0, 0, 0, 0},
    {0, 0, 15058, 0, 0},
    {-805, 0, 0, 0, 0},
    {0, 0, 15121, 0, 0},
    {-807, 0, 0, 0, 0},
    {0, 0, -51, 0, qc_M},
    {0, 0, 15184, 0, 0},
    {-809, 0, 0, 0, 0},
    {0, 0, 15247, 0, 0},
    {-811, 0, 0, 0, 0},
    {0, 0, 15310, 0, 0},
    {0, 0, 15373, 0, 0},
    {-813, 0, 0, 0, 0},
    {-815, 0, 0, 0, 0},
    {0, 0, 15436, 0, 0},
    {-817, 0, 0, 0, 0},
    {0, 4304, 0, 0, id_Start},
    {0, 4305, 0, 0, id_Start},
    {0, 4306, 0, 0, id_Start},
    {0, 4307, 0, 0, id_Start},
    {0, 4308, 0, 0, id_Start},
    {0, 4309, 0, 0, id_Start},
    {0, 4310, 0, 0, id_Start},
    {0, 4311, 0, 0, id_Start},
    {0, 4312, 0, 0, id_Start},
    {0, 4313, 0, 0, id_Start},
    {0, 4314, 0, 0, id_Start},
    {0, 4315, 0, 0, id_Start},
    {0, 4316, 0, 0, id_Start},
    {0, 4317, 0, 0, id_Start},
    {0, 4318, 0, 0, id_Start},
    {0, 4319, 0, 0, id_Start},
    {0, 4320, 0, 0, id_Start},
    {0, 4321, 0, 0, id_Start},
    {0, 4322, 0, 0, id_Start},
    {0, 4323, 0, 0, id_Start},
    {0, 4324, 0, 0, id_Start},
    {0, 4325, 0, 0, id_Start},
    {0, 4326, 0, 0, id_Start},
    {0, 4327, 0, 0, id_Start},
    {0, 4328, 0, 0, id_Start},
    {0, 4329, 0, 0, id_Start},
    {0, 4330, 0, 0, id_Start},
    {0, 4331, 0, 0, id_Start},
    {0, 4332, 0, 0, id_Start},
    {0, 4333, 0, 0, id_Start},
    {0, 4334, 0, 0, id_Start},
    {0, 4335, 0, 0, id_Start},
    {0, 4336, 0, 0, id_Start},
    {0, 4337, 0, 0, id_Start},
    {0, 4338, 0, 0, id_Start},
    {0, 4339, 0, 0, id_Start},
    {0, 4340, 0, 0, id_Start},
    {0, 4341, 0, 0, id_Start},
    {0, 4342, 0, 0, id_Start},
    {0, 4343, 0, 0, id_Start},
    {0, 4344, 0, 0, id_Start},
    {0, 4345, 0, 0, id_Start},
    {0, 4346, 0, 0, id_Start},
    {0, 4349, 0, 0, id_Start},
    {0, 4350, 0, 0, id_Start},
    {0, 4351, 0, 0, id_Start},
    {0, 0, 0, 214, 0},
    {-819, 7681, 0, 0, id_Start},
    {-821, 0, 0, 0, id_Start},
    {-823, 7683, 0, 0, id_Start},
    {-825, 0, 0, 0, id_Start},
    {-827, 7685, 0, 0, id_Start},
    {-829, 0, 0, 0, id_Start},
    {-831, 7687, 0, 0, id_Start},
    {-833, 0, 0, 0, id_Start},
    {-835, 7689, 0, 0, id_Start},
    {-837, 0, 0, 0, id_Start},
    {-839, 7691, 0, 0, id_Start},
    {-841, 0, 0, 0, id_Start},
    {-843, 7693, 0, 0, id_Start},
    {-845, 0, 0, 0, id_Start},
    {-847, 7695, 0, 0, id_Start},
    {-849, 0, 0, 0, id_Start},
    {-851, 7697, 0, 0, id_Start},
    {-853, 0, 0, 0, id_Start},
    {-855, 7699, 0, 0, id_Start},
    {-857, 0, 0, 0, id_Start},
    {-859, 7701, 0, 0, id_Start},
    {-861, 0, 0, 0, id_Start},
    {-863, 7703, 0, 0, id_Start},
    {-865, 0, 0, 0, id_Start},
    {-867, 7705, 0, 0, id_Start},
    {-869, 0, 0, 0, id_Start},
    {-871, 7707, 0, 0, id_Start},
    {-873, 0, 0, 0, id_Start},
    {-875, 7709, 0, 0, id_Start},
    {-877, 0, 0, 0, id_Start},
    {-879, 7711, 0, 0, id_Start},
    {-881, 0, 0, 0, id_Start},
    {-883, 7713, 0, 0, id_Start},
    {-885, 0, 0, 0, id_Start},
    {-887, 7715, 0, 0, id_Start},
    {-889, 0, 0, 0, id_Start},
    {-891, 7717, 0, 0, id_Start},
    {-893, 0, 0, 0, id_Start},
    {-895, 7719, 0, 0, id_Start},
    {-897, 0, 0, 0, id_Start},
    {-899, 7721, 0, 0, id_Start},
    {-901, 0, 0, 0, id_Start},
    {-903, 7723, 0, 0, id_Start},
    {-905, 0, 0, 0, id_Start},
    {-907, 7725, 0, 0, id_Start},
    {-909, 0, 0, 0, id_Start},
    {-911, 7727, 0, 0, id_Start},
    {-913, 0, 0, 0, id_Start},
    {-915, 7729, 0, 0, id_Start},
    {-917, 0, 0, 0, id_Start},
    {-919, 7731, 0, 0, id_Start},
    {-921, 0, 0, 0, id_Start},
    {-923, 7733, 0, 0, id_Start},
    {-925, 0, 0, 0, id_Start},
    {-927, 7735, 16255, 0, id_Start},
    {-929, 0, 16318, 0, id_Start},
    {-931, 7737, 0, 0, id_Start},
    {-933, 0, 0, 0, id_Start},
    {-935, 7739, 0, 0, id_Start},
    {-937, 0, 0, 0, id_Start},
    {-939, 7741, 0, 0, id_Start},
    {-941, 0, 0, 0, id_Start},
    {-943, 7743, 0, 0, id_Start},
    {-945, 0, 0, 0, id_Start},
    {-947, 7745, 0, 0, id_Start},
    {-949, 0, 0, 0, id_Start},
    {-951, 7747, 0, 0, id_Start},
    {-953, 0, 0, 0, id_Start},
    {-955, 7749, 0, 0, id_Start},
    {-957, 0, 0, 0, id_Start},
    {-959, 7751, 0, 0, id_Start},
    {-961, 0, 0, 0, id_Start},
    {-963, 7753, 0, 0, id_Start},
    {-965, 0, 0, 0, id_Start},
    {-967, 7755, 0, 0, id_Start},
    {-969, 0, 0, 0, id_Start},
    {-971, 7757, 0, 0, id_Start},
    {-973, 0, 0, 0, id_Start},
    {-975, 7759, 0, 0, id_Start},
    {-977, 0, 0, 0, id_Start},
    {-979, 7761, 0, 0, id_Start},
    {-981, 0, 0, 0, id_Start},
    {-983, 7763, 0, 0, id_Start},
    {-985, 0, 0, 0, id_Start},
    {-987, 7765, 0, 0, id_Start},
    {-989, 0, 0, 0, id_Start},
    {-991, 7767, 0, 0, id_Start},
    {-993, 0, 0, 0, id_Start},
    {-995, 7769, 0, 0, id_Start},
    {-997, 0, 0, 0, id_Start},
    {-999, 7771, 16759, 0, id_Start},
    {-1001, 0, 16822, 0, id_Start},
    {-1003, 7773, 0, 0, id_Start},
    {-1005, 0, 0, 0, id_Start},
    {-1007, 7775, 0, 0, id_Start},
    {-1009, 0, 0, 0, id_Start},
    {-1011, 7777, 0, 0, id_Start},
    {-1013, 0, 0, 0, id_Start},
    {-1015, 7779, 17137, 0, id_Start},
    {-1017, 0, 17200, 0, id_Start},
    {-1019, 7781, 0, 0, id_Start},
    {-1021, 0, 0, 0, id_Start},
    {-1023, 7783, 0, 0, id_Start},
    {-1025, 0, 0, 0, id_Start},
    {-1027, 7785, 0, 0, id_Start},
    {-1029, 0, 0, 0, id_Start},
    {-1031, 7787, 0, 0, id_Start},
    {-1033, 0, 0, 0, id_Start},
    {-1035, 7789, 0, 0, id_Start},
    {-1037, 0, 0, 0, id_Start},
    {-1039, 7791, 0, 0, id_Start},
    {-1041, 0, 0, 0, id_Start},
    {-1043, 7793, 0, 0, id_Start},
    {-1045, 0, 0, 0, id_Start},
    {-1047, 7795, 0, 0, id_Start},
    {-1049, 0, 0, 0, id_Start},
    {-1051, 7797, 0, 0, id_Start},
    {-1053, 0, 0, 0, id_Start},
    {-1055, 7799, 0, 0, id_Start},
    {-1057, 0, 0, 0, id_Start},
    {-1059, 7801, 0, 0, id_Start},
    {-1061, 0, 0, 0, id_Start},
    {-1063, 7803, 0, 0, id_Start},
    {-1065, 0, 0, 0, id_Start},
    {-1067, 7805, 0, 0, id_Start},
    {-1069, 0, 0, 0, id_Start},
    {-1071, 7807, 0, 0, id_Start},
    {-1073, 0, 0, 0, id_Start},
    {-1075, 7809, 0, 0, id_Start},
    {-1077, 0, 0, 0, id_Start},
    {-1079, 7811, 0, 0, id_Start},
    {-1081, 0, 0, 0, id_Start},
    {-1083, 7813, 0, 0, id_Start},
    {-1085, 0, 0, 0, id_Start},
    {-1087, 7815, 0, 0, id_Start},
    {-1089, 0, 0, 0, id_Start},
    {-1091, 7817, 0, 0, id_Start},
    {-1093, 0, 0, 0, id_Start},
    {-1095, 7819, 0, 0, id_Start},
    {-1097, 0, 0, 0, id_Start},
    {-1099, 7821, 0, 0, id_Start},
    {-1101, 0, 0, 0, id_Start},
    {-1103, 7823, 0, 0, id_Start},
    {-1105, 0, 0, 0, id_Start},
    {-1107, 7825, 0, 0, id_Start},
    {-1109, 0, 0, 0, id_Start},
    {-1111, 7827, 0, 0, id_Start},
    {-1113, 0, 0, 0, id_Start},
    {-1115, 7829, 0, 0, id_Start},
    {-1117, 0, 0, 0, id_Start},
    {-1119, 0, 0, 0, id_Start},
    {-1121, 0, 0, 0, id_Start},
    {-1123, 0, 0, 0, id_Start},
    {-1125, 0, 0, 0, id_Start},
    {-1127, 0, 0, 0, 0},
    {-1129, 7841, 17956, 0, id_Start},
    {-1131, 0, 18019, 0, id_Start},
    {-1133, 7843, 0, 0, id_Start},
    {-1135, 0, 0, 0, id_Start},
    {-1137, 7845, 0, 0, id_Start},
    {-1139, 0, 0, 0, id_Start},
    {-1141, 7847, 0, 0, id_Start},
    {-1143, 0, 0, 0, id_Start},
    {-1145, 7849, 0, 0, id_Start},
    {-1147, 0, 0, 0, id_Start},
    {-1149, 7851, 0, 0, id_Start},
    {-1151, 0, 0, 0, id_Start},
    {-1153, 7853, 0, 0, id_Start},
    {-1155, 0, 0, 0, id_Start},
    {-1157, 7855, 0, 0, id_Start},
    {-1159, 0, 0, 0, id_Start},
    {-1161, 7857, 0, 0, id_Start},
    {-1163, 0, 0, 0, id_Start},
    {-1165, 7859, 0, 0, id_Start},
    {-1167, 0, 0, 0, id_Start},
    {-1169, 7861, 0, 0, id_Start},
    {-1171, 0, 0, 0, id_Start},
    {-1173, 7863, 0, 0, id_Start},
    {-1175, 0, 0, 0, id_Start},
    {-1177, 7865, 18334, 0, id_Start},
    {-1179, 0, 18397, 0, id_Start},
    {-1181, 7867, 0, 0, id_Start},
    {-1183, 0, 0, 0, id_Start},
    {-1185, 7869, 0, 0, id_Start},
    {-1187, 0, 0, 0, id_Start},
    {-1189, 7871, 0, 0, id_Start},
    {-1191, 0, 0, 0, id_Start},
    {-1193, 7873, 0, 0, id_Start},
    {-1195, 0, 0, 0, id_Start},
    {-1197, 7875, 0, 0, id_Start},
    {-1199, 0, 0, 0, id_Start},
    {-1201, 7877, 0, 0, id_Start},
    {-1203, 0, 0, 0, id_Start},
    {-1205, 7879, 0, 0, id_Start},
    {-1207, 0, 0, 0, id_Start},
    {-1209, 7881, 0, 0, id_Start},
    {-1211, 0, 0, 0, id_Start},
    {-1213, 7883, 0, 0, id_Start},
    {-1215, 0, 0, 0, id_Start},
    {-1217, 7885, 18586, 0, id_Start},
    {-1219, 0, 18649, 0, id_Start},
    {-1221, 7887, 0, 0, id_Start},
    {-1223, 0, 0, 0, id_Start},
    {-1225, 7889, 0, 0, id_Start},
    {-1227, 0, 0, 0, id_Start},
    {-1229, 7891, 0, 0, id_Start},
    {-1231, 0, 0, 0, id_Start},
    {-1233, 7893, 0, 0, id_Start},
    {-1235, 0, 0, 0, id_Start},
    {-1237, 7895, 0, 0, id_Start},
    {-1239, 0, 0, 0, id_Start},
    {-1241, 7897, 0, 0, id_Start},
    {-1243, 0, 0, 0, id_Start},
    {-1245, 7899, 0, 0, id_Start},
    {-1247, 0, 0, 0, id_Start},
    {-1249, 7901, 0, 0, id_Start},
    {-1251, 0, 0, 0, id_Start},
    {-1253, 7903, 0, 0, id_Start},
    {-1255, 0, 0, 0, id_Start},
    {-1257, 7905, 0, 0, id_Start},
    {-1259, 0, 0, 0, id_Start},
    {-1261, 7907, 0, 0, id_Start},
    {-1263, 0, 0, 0, id_Start},
    {-1265, 7909, 0, 0, id_Start},
    {-1267, 0, 0, 0, id_Start},
    {-1269, 7911, 0, 0, id_Start},
    {-1271, 0, 0, 0, id_Start},
    {-1273, 7913, 0, 0, id_Start},
    {-1275, 0, 0, 0, id_Start},
    {-1277, 7915, 0, 0, id_Start},
    {-1279, 0, 0, 0, id_Start},
    {-1281, 7917, 0, 0, id_Start},
    {-1283, 0, 0, 0, id_Start},
    {-1285, 7919, 0, 0, id_Start},
    {-1287, 0, 0, 0, id_Start},
    {-1289, 7921, 0, 0, id_Start},
    {-1291, 0, 0, 0, id_Start},
    {-1293, 7923, 0, 0, id_Start},
    {-1295, 0, 0, 0, id_Start},
    {-1297, 7925, 0, 0, id_Start},
    {-1299, 0, 0, 0, id_Start},
    {-1301, 7927, 0, 0, id_Start},
    {-1303, 0, 0, 0, id_Start},
    {-1305, 7929, 0, 0, id_Start},
    {-1307, 0, 0, 0, id_Start},
    {-1309, 0, 18964, 0, id_Start},
    {-1311, 0, 19027, 0, id_Start},
    {-1313, 0, 20665, 0, id_Start},
    {-1315, 0, 20728, 0, id_Start},
    {-1317, 0, 20791, 0, id_Start},
    {-1319, 0, 20854, 0, id_Start},
    {-1321, 0, 20917, 0, id_Start},
    {-1323, 0, 20980, 0, id_Start},
    {-1325, 7936, 19090, 0, id_Start},
    {-1327, 7937, 19153, 0, id_Start},
    {-1329, 7938, 21043, 0, id_Start},
    {-1331, 7939, 21106, 0, id_Start},
    {-1333, 7940, 21169, 0, id_Start},
    {-1335, 7941, 21232, 0, id_Start},
    {-1337, 7942, 21295, 0, id_Start},
    {-1339, 7943, 21358, 0, id_Start},
    {-1341, 0, 19216, 0, id_Start},
    {-1343, 0, 19279, 0, id_Start},
    {-1345, 0, 0, 0, id_Start},
    {-1347, 0, 0, 0, id_Start},
    {-1349, 0, 0, 0, id_Start},
    {-1351, 0, 0, 0, id_Start},
    {-1353, 7952, 19342, 0, id_Start},
    {-1355, 7953, 19405, 0, id_Start},
    {-1357, 7954, 0, 0, id_Start},
    {-1359, 7955, 0, 0, id_Start},
    {-1361, 7956, 0, 0, id_Start},
    {-1363, 7957, 0, 0, id_Start},
    {-1365, 0, 19468, 0, id_Start},
    {-1367, 0, 19531, 0, id_Start},
    {-1369, 0, 21421, 0, id_Start},
    {-1371, 0, 21484, 0, id_Start},
    {-1373, 0, 21547, 0, id_Start},
    {-1375, 0, 21610, 0, id_Start},
    {-1377, 0, 21673, 0, id_Start},
    {-1379, 0, 21736, 0, id_Start},
    {-1381, 7968, 19594, 0, id_Start},
    {-1383, 7969, 19657, 0, id_Start},
    {-1385, 7970, 21799, 0, id_Start},
    {-1387, 7971, 21862, 0, id_Start},
    {-1389, 7972, 21925, 0, id_Start},
    {-1391, 7973, 21988, 0, id_Start},
    {-1393, 7974, 22051, 0, id_Start},
    {-1395, 7975, 22114, 0, id_Start},
    {-1397, 0, 19720, 0, id_Start},
    {-1399, 0, 19783, 0, id_Start},
    {-1401, 0, 0, 0, id_Start},
    {-1403, 0, 0, 0, id_Start},
    {-1405, 0, 0, 0, id_Start},
    {-1407, 0, 0, 0, id_Start},
    {-1409, 0, 0, 0, id_Start},
    {-1411, 0, 0, 0, id_Start},
    {-1413, 7984, 19846, 0, id_Start},
    {-1415, 7985, 19909, 0, id_Start},
    {-1417, 7986, 0, 0, id_Start},
    {-1419, 7987, 0, 0, id_Start},
    {-1421, 7988, 0, 0, id_Start},
    {-1423, 7989, 0, 0, id_Start},
    {-1425, 7990, 0, 0, id_Start},
    {-1427, 7991, 0, 0, id_Start},
    {-1429, 0, 19972, 0, id_Start},
    {-1431, 0, 20035, 0, id_Start},
    {-1433, 0, 0, 0, id_Start},
    {-1435, 0, 0, 0, id_Start},
    {-1437, 0, 0, 0, id_Start},
    {-1439, 0, 0, 0, id_Start},
    {-1441, 8000, 20098, 0, id_Start},
    {-1443, 8001, 20161, 0, id_Start},
    {-1445, 8002, 0, 0, id_Start},
    {-1447, 8003, 0, 0, id_Start},
    {-1449, 8004, 0, 0, id_Start},
    {-1451, 8005, 0, 0, id_Start},
    {-1453, 0, 20224, 0, id_Start},
    {-1455, 0, 20287, 0, id_Start},
    {-1457, 0, 0, 0, id_Start},
    {-1459, 0, 0, 0, id_Start},
    {-1461, 0, 0, 0, id_Start},
    {-1463, 0, 0, 0, id_Start},
    {-1465, 0, 0, 0, id_Start},
    {-1467, 0, 0, 0, id_Start},
    {-1469, 8017, 20350, 0, id_Start},
    {-1471, 8019, 0, 0, id_Start},
    {-1473, 8021, 0, 0, id_Start},
    {-1475, 8023, 0, 0, id_Start},
    {-1477, 0, 20413, 0, id_Start},
    {-1479, 0, 20476, 0, id_Start},
    {-1481, 0, 22177, 0, id_Start},
    {-1483, 0, 22240, 0, id_Start},
    {-1485, 0, 22303, 0, id_Start},
    {-1487, 0, 22366, 0, id_Start},
    {-1489, 0, 22429, 0, id_Start},
    {-1491, 0, 22492, 0, id_Start},
    {-1493, 8032, 20539, 0, id_Start},
    {-1495, 8033, 20602, 0, id_Start},
    {-1497, 8034, 22555, 0, id_Start},
    {-1499, 8035, 22618, 0, id_Start},
    {-1501, 8036, 22681, 0, id_Start},
    {-1503, 8037, 22744, 0, id_Start},
    {-1505, 8038, 22807, 0, id_Start},
    {-1507, 8039, 22870, 0, id_Start},
    {-1509, 0, 22933, 0, id_Start},
    {940, 0, 0, 0, qc_N},
    {-1511, 0, 0, 0, id_Start},
    {941, 0, 0, 0, qc_N},
    {-1513, 0, 23122, 0, id_Start},
    {942, 0, 0, 0, qc_N},
    {-1515, 0, 0, 0, id_Start},
    {943, 0, 0, 0, qc_N},
    {-1517, 0, 0, 0, id_Start},
    {972, 0, 0, 0, qc_N},
    {-1519, 0, 0, 0, id_Start},
    {973, 0, 0, 0, qc_N},
    {-1521, 0, 23563, 0, id_Start},
    {974, 0, 0, 0, qc_N},
    {-1523, -2001, 0, 0, id_Start},
    {-1525, -2003, 0, 0, id_Start},
    {-1527, -2005, 0, 0, id_Start},
    {-1529, -2007, 0, 0, id_Start},
    {-1531, -2009, 0, 0, id_Start},
    {-1533, -2011, 0, 0, id_Start},
    {-1535, -2013, 0, 0, id_Start},
    {-1537, -2015, 0, 0, id_Start},
    {-1539, -2001, 0, 0, id_Start},
    {-1541, -2003, 0, 0, id_Start},
    {-1543, -2005, 0, 0, id_Start},
    {-1545, -2007, 0, 0, id_Start},
    {-1547, -2009, 0, 0, id_Start},
    {-1549, -2011, 0, 0, id_Start},
    {-1551, -2013, 0, 0, id_Start},
    {-1553, -2015, 0, 0, id_Start},
    {-1555, -2017, 0, 0, id_Start},
    {-1557, -2019, 0, 0, id_Start},
    {-1559, -2021, 0, 0, id_Start},
    {-1561, -2023, 0, 0, id_Start},
    {-1563, -2025, 0, 0, id_Start},
    {-1565, -2027, 0, 0, id_Start},
    {-1567, -2029, 0, 0, id_Start},
    {-1569, -2031, 0, 0, id_Start},
    {-1571, -2017, 0, 0, id_Start},
    {-1573, -2019, 0, 0, id_Start},
    {-1575, -2021, 0, 0, id_Start},
    {-1577, -2023, 0, 0, id_Start},
    {-1579, -2025, 0, 0, id_Start},
    {-1581, -2027, 0, 0, id_Start},
    {-1583, -2029, 0, 0, id_Start},
    {-1585, -2031, 0, 0, id_Start},
    {-1587, -2033, 0, 0, id_Start},
    {-1589, -2035, 0, 0, id_Start},
    {-1591, -2037, 0, 0, id_Start},
    {-1593, -2039, 0, 0, id_Start},
    {-1595, -2041, 0, 0, id_Start},
    {-1597, -2043, 0, 0, id_Start},
    {-1599, -2045, 0, 0, id_Start},
    {-1601, -2047, 0, 0, id_Start},
    {-1603, -2033, 0, 0, id_Start},
    {-1605, -2035, 0, 0, id_Start},
    {-1607, -2037, 0, 0, id_Start},
    {-1609, -2039, 0, 0, id_Start},
    {-1611, -2041, 0, 0, id_Start},
    {-1613, -2043, 0, 0, id_Start},
    {-1615, -2045, 0, 0, id_Start},
    {-1617, -2047, 0, 0, id_Start},
    {-1619, 0, 0, 0, id_Start},
    {-1621, 0, 0, 0, id_Start},
    {-1623, -2049, 0, 0, id_Start},
    {-1625, -2051, 0, 0, id_Start},
    {-1627, -2053, 0, 0, id_Start},
    {-1629, 0, 23059, 0, id_Start},
    {-1631, -2055, 0, 0, id_Start},
    {-1633, 8112, 0, 0, id_Start},
    {-1635, 8113, 0, 0, id_Start},
    {-1637, 8048, 0, 0, id_Start},
    {902, 0, 0, 0, qc_N},
    {-1639, -2051, 0, 0, id_Start},
    {953, 0, 0, 0, qc_N},
    {0, 0, 23311, 0, pr_compat},
    {-1641, 0, 0, 0, 0},
    {-1643, -2057, 0, 0, id_Start},
    {-1645, -2059, 0, 0, id_Start},
    {-1647, -2061, 0, 0, id_Start},
    {-1649, 0, 23248, 0, id_Start},
    {-1651, -2063, 0, 0, id_Start},
    {-1653, 8050, 0, 0, id_Start},
    {904, 0, 0, 0, qc_N},
    {-1655, 8052, 0, 0, id_Start},
    {905, 0, 0, 0, qc_N},
    {-1657, -2059, 0, 0, id_Start},
    {-1659, 0, 0, 0, 0},
    {-1661, 0, 0, 0, 0},
    {-1663, 0, 0, 0, 0},
    {-1665, 0, 0, 0, id_Start},
    {-1667, 0, 0, 0, id_Start},
    {-1669, 0, 0, 0, id_Start},
    {912, 0, 0, 0, qc_N},
    {-1671, 0, 0, 0, id_Start},
    {-1673, 0, 0, 0, id_Start},
    {-1675, 8144, 0, 0, id_Start},
    {-1677, 8145, 0, 0, id_Start},
    {-1679, 8054, 0, 0, id_Start},
    {906, 0, 0, 0, qc_N},
    {-1681, 0, 0, 0, 0},
    {-1683, 0, 0, 0, 0},
    {-1685, 0, 0, 0, 0},
    {-1687, 0, 0, 0, id_Start},
    {-1689, 0, 0, 0, id_Start},
    {-1691, 0, 0, 0, id_Start},
    {944, 0, 0, 0, qc_N},
    {-1693, 0, 0, 0, id_Start},
    {-1695, 0, 0, 0, id_Start},
    {-1697, 0, 0, 0, id_Start},
    {-1699, 0, 0, 0, id_Start},
    {-1701, 8160, 0, 0, id_Start},
    {-1703, 8161, 0, 0, id_Start},
    {-1705, 8058, 0, 0, id_Start},
    {910, 0, 0, 0, qc_N},
    {-1707, 8165, 0, 0, id_Start},
    {-1709, 0, 0, 0, 0},
    {901, 0, 0, 0, qc_N},
    {96, 0, 0, 0, qc_N},
    {-1711, -2065, 0, 0, id_Start},
    {-1713, -2067, 0, 0, id_Start},
    {-1715, -2069, 0, 0, id_Start},
    {-1717, 0, 23689, 0, id_Start},
    {-1719, -2071, 0, 0, id_Start},
    {-1721, 8056, 0, 0, id_Start},
    {908, 0, 0, 0, qc_N},
    {-1723, 8060, 0, 0, id_Start},
    {911, 0, 0, 0, qc_N},
    {-1725, -2067, 0, 0, id_Start},
    {180, 0, 0, 0, qc_N},
    {0, 0, 23374, 0, pr_compat},
    {8194, 0, 0, 0, qc_N},
    {8195, 0, 0, 0, qc_N},
    {937, 0, 0, 0, qc_N},
    {75, 0, 0, 0, qc_N},
    {197, 0, 0, 0, qc_N},
    {0, 0, 2395, 0, 0},
    {0, 0, 2458, 0, 0},
    {0, 0, 2521, 0, 0},
    {-1727, 0, 0, 0, 0},
    {-1729, 0, 0, 0, 0},
    {-1731, 0, 0, 0, 0},
    {-1733, 0, 0, 0, 0},
    {-1735, 0, 0, 0, 0},
    {-1737, 0, 0, 0, 0},
    {0, 0, 9955, 0, 0},
    {0, 0, 10081, 0, 0},
    {0, 0, 10018, 0, 0},
    {0, 0, 10396, 0, 0},
    {-1739, 0, 0, 0, 0},
    {0, 0, 10459, 0, 0},
    {-1741, 0, 0, 0, 0},
    {0, 0, 10585, 0, 0},
    {-1743, 0, 0, 0, 0},
    {0, 0, 3592, 0, 0},
    {-1745, 0, 0, 0, 0},
    {0, 0, 3655, 0, 0},
    {-1747, 0, 0, 0, 0},
    {0, 0, 4096, 0, 0},
    {-1749, 0, 0, 0, 0},
    {0, 0, 4159, 0, 0},
    {-1751, 0, 0, 0, 0},
    {0, 0, 4222, 0, 0},
    {-1753, 0, 0, 0, 0},
    {0, 0, 4285, 0, 0},
    {-1755, 0, 0, 0, 0},
    {0, 0, 4474, 0, 0},
    {-1757, 0, 0, 0, 0},
    {0, 0, 4411, 0, 0},
    {-1759, 0, 0, 0, 0},
    {0, 0, 4663, 0, 0},
    {0, 0, 4726, 0, 0},
    {-1761, 0, 0, 0, 0},
    {-1763, 0, 0, 0, 0},
    {-1765, 0, 0, 0, 0},
    {-1767, 0, 0, 0, 0},
    {-1769, 0, 0, 0, 0},
    {0, 0, 4789, 0, 0},
    {0, 0, 4852, 0, 0},
    {-1771, 0, 0, 0, 0},
    {-1773, 0, 0, 0, 0},
    {0, 0, 4915, 0, 0},
    {0, 0, 4978, 0, 0},
    {-1775, 0, 0, 0, 0},
    {-1777, 0, 0, 0, 0},
    {0, 0, 5041, 0, 0},
    {0, 0, 5104, 0, 0},
    {0, 0, 5671, 0, 0},
    {0, 0, 5734, 0, 0},
    {-1779, 0, 0, 0, 0},
    {-1781, 0, 0, 0, 0},
    {0, 0, 5167, 0, 0},
    {0, 0, 5230, 0, 0},
    {-1783, 0, 0, 0, 0},
    {-1785, 0, 0, 0, 0},
    {0, 0, 5293, 0, 0},
    {0, 0, 5356, 0, 0},
    {-1787, 0, 0, 0, 0},
    {-1789, 0, 0, 0, 0},
    {0, 0, 5797, 0, 0},
    {0, 0, 5860, 0, 0},
    {0, 0, 5419, 0, 0},
    {0, 0, 5482, 0, 0},
    {0, 0, 5545, 0, 0},
    {0, 0, 5608, 0, 0},
    {-1791, 0, 0, 0, 0},
    {-1793, 0, 0, 0, 0},
    {-1795, 0, 0, 0, 0},
    {-1797, 0, 0, 0, 0},
    {0, 0, 5923, 0, 0},
    {0, 0, 5986, 0, 0},
    {0, 0, 6049, 0, 0},
    {0, 0, 6112, 0, 0},
    {-1799, 0, 0, 0, 0},
    {-1801, 0, 0, 0, 0},
    {-1803, 0, 0, 0, 0},
    {-1805, 0, 0, 0, 0},
    {-1807, 0, 0, 0, 0},
    {-1809, 0, 0, 0, 0},
    {-1811, 0, 0, 0, 0},
    {-1813, 0, 0, 0, 0},
    {12296, 0, 0, 0, qc_N},
    {12297, 0, 0, 0, qc_N},
    {-1815, 0, 0, 0, qc_N},
    {0, 0, 0, 218, 0},
    {0, 0, 12412, 0, id_Start},
    {0, 0, 11152, 0, id_Start},
    {-1817, 0, 0, 0, id_Start},
    {0, 0, 11215, 0, id_Start},
    {-1819, 0, 0, 0, id_Start},
    {0, 0, 11278, 0, id_Start},
    {-1821, 0, 0, 0, id_Start},
    {0, 0, 11341, 0, id_Start},
    {-1823, 0, 0, 0, id_Start},
    {0, 0, 11404, 0, id_Start},
    {-1825, 0, 0, 0, id_Start},
    {0, 0, 11467, 0, id_Start},
    {-1827, 0, 0, 0, id_Start},
    {0, 0, 11530, 0, id_Start},
    {-1829, 0, 0, 0, id_Start},
    {0, 0, 11593, 0, id_Start},
    {-1831, 0, 0, 0, id_Start},
    {0, 0, 11656, 0, id_Start},
    {-1833, 0, 0, 0, id_Start},
    {0, 0, 11719, 0, id_Start},
    {-1835, 0, 0, 0, id_Start},
    {0, 0, 11782, 0, id_Start},
    {-1837, 0, 0, 0, id_Start},
    {0, 0, 11845, 0, id_Start},
    {-1839, 0, 0, 0, id_Start},
    {0, 0, 11908, 0, id_Start},
    {-1841, 0, 0, 0, id_Start},
    {0, 0, 11971, 0, id_Start},
    {-1843, 0, 0, 0, id_Start},
    {0, 0, 12034, 0, id_Start},
    {-1845, 0, 0, 0, id_Start},
    {0, 0, 12097, 0, id_Start},
    {-1847, 0, 0, 0, id_Start},
    {-1849, 0, 0, 0, id_Start},
    {0, 0, 12160, 0, id_Start},
    {-1851, 0, 0, 0, id_Start},
    {-1853, 0, 0, 0, id_Start},
    {0, 0, 12223, 0, id_Start},
    {-1855, 0, 0, 0, id_Start},
    {-1857, 0, 0, 0, id_Start},
    {0, 0, 12286, 0, id_Start},
    {-1859, 0, 0, 0, id_Start},
    {-1861, 0, 0, 0, id_Start},
    {0, 0, 12349, 0, id_Start},
    {-1863, 0, 0, 0, id_Start},
    {-1865, 0, 0, 0, id_Start},
    {-1867, 0, 0, 0, id_Start},
    {0, 0, -40, 8, id_Continue | qc_M},
    {0, 0, -41, 8, id_Continue | qc_M},
    {0, 0, 12601, 0, id_Start},
    {-1869, 0, 0, 0, id_Start},
    {0, 0, 13987, 0, id_Start},
    {0, 0, 12727, 0, id_Start},
    {-1871, 0, 0, 0, id_Start},
    {0, 0, 12790, 0, id_Start},
    {-1873, 0, 0, 0, id_Start},
    {0, 0, 12853, 0, id_Start},
    {-1875, 0, 0, 0, id_Start},
    {0, 0, 12916, 0, id_Start},
    {-1877, 0, 0, 0, id_Start},
    {0, 0, 12979, 0, id_Start},
    {-1879, 0, 0, 0, id_Start},
    {0, 0, 13042, 0, id_Start},
    {-1881, 0, 0, 0, id_Start},
    {0, 0, 13105, 0, id_Start},
    {-1883, 0, 0, 0, id_Start},
    {0, 0, 13168, 0, id_Start},
    {-1885, 0, 0, 0, id_Start},
    {0, 0, 13231, 0, id_Start},
    {-1887, 0, 0, 0, id_Start},
    {0, 0, 13294, 0, id_Start},
    {-1889, 0, 0, 0, id_Start},
    {0, 0, 13357, 0, id_Start},
    {-1891, 0, 0, 0, id_Start},
    {0, 0, 13420, 0, id_Start},
    {-1893, 0, 0, 0, id_Start},
    {0, 0, 13483, 0, id_Start},
    {-1895, 0, 0, 0, id_Start},
    {0, 0, 13546, 0, id_Start},
    {-1897, 0, 0, 0, id_Start},
    {0, 0, 13609, 0, id_Start},
    {-1899, 0, 0, 0, id_Start},
    {0, 0, 13672, 0, id_Start},
    {-1901, 0, 0, 0, id_Start},
    {-1903, 0, 0, 0, id_Start},
    {0, 0, 13735, 0, id_Start},
    {-1905, 0, 0, 0, id_Start},
    {-1907, 0, 0, 0, id_Start},
    {0, 0, 13798, 0, id_Start},
    {-1909, 0, 0, 0, id_Start},
    {-1911, 0, 0, 0, id_Start},
    {0, 0, 13861, 0, id_Start},
    {-1913, 0, 0, 0, id_Start},
    {-1915, 0, 0, 0, id_Start},
    {0, 0, 13924, 0, id_Start},
    {-1917, 0, 0, 0, id_Start},
    {-1919, 0, 0, 0, id_Start},
    {0, 0, 14050, 0, id_Start},
    {0, 0, 14113, 0, id_Start},
    {0, 0, 14176, 0, id_Start},
    {0, 0, 14239, 0, id_Start},
    {-1921, 0, 0, 0, id_Start},
    {-1923, 0, 0, 0, id_Start},
    {-1925, 0, 0, 0, id_Start},
    {-1927, 0, 0, 0, id_Start},
    {-1929, 0, 0, 0, id_Start},
    {0, 0, 14302, 0, id_Start},
    {-1931, 0, 0, 0, id_Start},
    {0, 613, 0, 0, id_Start},
    {0, -16771, 0, 0, id_Start},
    {0, 614, 0, 0, id_Start},
    {0, 618, 0, 0, id_Start},
    {0, -16772, 0, 0, id_Start},
    {0, -16773, 0, 0, id_Start},
    {0, -16774, 0, 0, id_Start},
    {0, 642, 0, 0, id_Start},
    {0, 7566, 0, 0, id_Start},
    {0, -16775, 0, 0, id_Start},
    {0, -16776, 0, 0, id_Start},
    {-16385, 0, 0, 0, qc_N},
    {26356, 0, 0, 0, qc_N},
    {-16386, 0, 0, 0, qc_N},
    {-16387, 0, 0, 0, qc_N},
    {28369, 0, 0, 0, qc_N},
    {20018, 0, 0, 0, qc_N},
    {21477, 0, 0, 0, qc_N},
    {22865, 0, 0, 0, qc_N},
    {-16389, 0, 0, 0, qc_N},
    {21895, 0, 0, 0, qc_N},
    {22856, 0, 0, 0, qc_N},
    {30313, 0, 0, 0, qc_N},
    {32645, 0, 0, 0, qc_N},
    {-16390, 0, 0, 0, qc_N},
    {-16391, 0, 0, 0, qc_N},
    {-16392, 0, 0, 0, qc_N},
    {-16393, 0, 0, 0, qc_N},
    {27931, 0, 0, 0, qc_N},
    {28889, 0, 0, 0, qc_N},
    {29662, 0, 0, 0, qc_N},
    {-16394, 0, 0, 0, qc_N},
    {-16395, 0, 0, 0, qc_N},
    {-16396, 0, 0, 0, qc_N},
    {20098, 0, 0, 0, qc_N},
    {21365, 0, 0, 0, qc_N},
    {27396, 0, 0, 0, qc_N},
    {29211, 0, 0, 0, qc_N},
    {-16397, 0, 0, 0, qc_N},
    {-16398, 0, 0, 0, qc_N},
    {23888, 0, 0, 0, qc_N},
    {28651, 0, 0, 0, qc_N},
    {-16399, 0, 0, 0, qc_N},
    {-16400, 0, 0, 0, qc_N},
    {25289, 0, 0, 0, qc_N},
    {-16401, 0, 0, 0, qc_N},
    {-16402, 0, 0, 0, qc_N},
    {28010, 0, 0, 0, qc_N},
    {29436, 0, 0, 0, qc_N},
    {-16403, 0, 0, 0, qc_N},
    {20358, 0, 0, 0, qc_N},
    {20919, 0, 0, 0, qc_N},
    {21214, 0, 0, 0, qc_N},
    {25796, 0, 0, 0, qc_N},
    {27347, 0, 0, 0, qc_N},
    {29200, 0, 0, 0, qc_N},
    {30439, 0, 0, 0, qc_N},
    {-16404, 0, 0, 0, qc_N},
    {-16405, 0, 0, 0, qc_N},
    {-16407, 0, 0, 0, qc_N},
    {-16408, 0, 0, 0, qc_N},
    {-16409, 0, 0, 0, qc_N},
    {-16410, 0, 0, 0, qc_N},
    {31103, 0, 0, 0, qc_N},
    {32160, 0, 0, 0, qc_N},
    {-16411, 0, 0, 0, qc_N},
    {-16412, 0, 0, 0, qc_N},
    {-16413, 0, 0, 0, qc_N},
    {-16414, 0, 0, 0, qc_N},
    {22751, 0, 0, 0, qc_N},
    {24324, 0, 0, 0, qc_N},
    {31840, 0, 0, 0, qc_N},
    {-16415, 0, 0, 0, qc_N},
    {29282, 0, 0, 0, qc_N},
    {30922, 0, 0, 0, qc_N},
    {-16416, 0, 0, 0, qc_N},
    {-16417, 0, 0, 0, qc_N},
    {22744, 0, 0, 0, qc_N},
    {23650, 0, 0, 0, qc_N},
    {27155, 0, 0, 0, qc_N},
    {28122, 0, 0, 0, qc_N},
    {28431, 0, 0, 0, qc_N},
    {32047, 0, 0, 0, qc_N},
    {32311, 0, 0, 0, qc_N},
    {-16418, 0, 0, 0, qc_N},
    {21202, 0, 0, 0, qc_N},
    {-16419, 0, 0, 0, qc_N},
    {20956, 0, 0, 0, qc_N},
    {20940, 0, 0, 0, qc_N},
    {31260, 0, 0, 0, qc_N},
    {32190, 0, 0, 0, qc_N},
    {-16420, 0, 0, 0, qc_N},
    {-16421, 0, 0, 0, qc_N},
    {-16422, 0, 0, 0, qc_N},
    {25295, 0, 0, 0, qc_N},
    {20025, 0, 0, 0, qc_N},
    {24594, 0, 0, 0, qc_N},
    {30971, 0, 0, 0, qc_N},
    {20415, 0, 0, 0, qc_N},
    {24489, 0, 0, 0, qc_N},
    {19981, 0, 0, 0, qc_N},
    {27852, 0, 0, 0, qc_N},
    {25976, 0, 0, 0, qc_N},
    {32034, 0, 0, 0, qc_N},
    {21443, 0, 0, 0, qc_N},
    {22622, 0, 0, 0, qc_N},
    {30465, 0, 0, 0, qc_N},
    {-16424, 0, 0, 0, qc_N},
    {-16426, 0, 0, 0, qc_N},
    {27784, 0, 0, 0, qc_N},
    {25342, 0, 0, 0, qc_N},
    {25504, 0, 0, 0, qc_N},
    {30053, 0, 0, 0, qc_N},
    {20142, 0, 0, 0, qc_N},
    {20841, 0, 0, 0, qc_N},
    {20937, 0, 0, 0, qc_N},
    {26753, 0, 0, 0, qc_N},
    {31975, 0, 0, 0, qc_N},
    {-16428, 0, 0, 0, qc_N},
    {-16429, 0, 0, 0, qc_N},
    {-16430, 0, 0, 0, qc_N},
    {21237, 0, 0, 0, qc_N},
    {21570, 0, 0, 0, qc_N},
    {22899, 0, 0, 0, qc_N},
    {24300, 0, 0, 0, qc_N},
    {26053, 0, 0, 0, qc_N},
    {28670, 0, 0, 0, qc_N},
    {31018, 0, 0, 0, qc_N},
    {-16431, 0, 0, 0, qc_N},
    {-16432, 0, 0, 0, qc_N},
    {-16433, 0, 0, 0, qc_N},
    {-16434, 0, 0, 0, qc_N},
    {21147, 0, 0, 0, qc_N},
    {26310, 0, 0, 0, qc_N},
    {27511, 0, 0, 0, qc_N},
    {-16435, 0, 0, 0, qc_N},
    {24180, 0, 0, 0, qc_N},
    {24976, 0, 0, 0, qc_N},
    {25088, 0, 0, 0, qc_N},
    {25754, 0, 0, 0, qc_N},
    {28451, 0, 0, 0, qc_N},
    {29001, 0, 0, 0, qc_N},
    {29833, 0, 0, 0, qc_N},
    {31178, 0, 0, 0, qc_N},
    {-16436, 0, 0, 0, qc_N},
    {-16437, 0, 0, 0, qc_N},
    {-16438, 0, 0, 0, qc_N},
    {-16439, 0, 0, 0, qc_N},
    {-16440, 0, 0, 0, qc_N},
    {21015, 0, 0, 0, qc_N},
    {21155, 0, 0, 0, qc_N},
    {21693, 0, 0, 0, qc_N},
    {28872, 0, 0, 0, qc_N},
    {-16441, 0, 0, 0, qc_N},
    {24265, 0, 0, 0, qc_N},
    {24565, 0, 0, 0, qc_N},
    {25467, 0, 0, 0, qc_N},
    {27566, 0, 0, 0, qc_N},
    {31806, 0, 0, 0, qc_N},
    {29557, 0, 0, 0, qc_N},
    {20196, 0, 0, 0, qc_N},
    {22265, 0, 0, 0, qc_N},
    {23994, 0, 0, 0, qc_N},
    {24604, 0, 0, 0, qc_N},
    {29618, 0, 0, 0, qc_N},
    {29801, 0, 0, 0, qc_N},
    {32666, 0, 0, 0, qc_N},
    {-16442, 0, 0, 0, qc_N},
    {-16443, 0, 0, 0, qc_N},
    {-16444, 0, 0, 0, qc_N},
    {-16445, 0, 0, 0, qc_N},
    {-16446, 0, 0, 0, qc_N},
    {20363, 0, 0, 0, qc_N},
    {31150, 0, 0, 0, qc_N},
    {-16447, 0, 0, 0, qc_N},
    {-16448, 0, 0, 0, qc_N},
    {24801, 0, 0, 0, qc_N},
    {20102, 0, 0, 0, qc_N},
    {20698, 0, 0, 0, qc_N},
    {23534, 0, 0, 0, qc_N},
    {23615, 0, 0, 0, qc_N},
    {26009, 0, 0, 0, qc_N},
    {29134, 0, 0, 0, qc_N},
    {30274, 0, 0, 0, qc_N},
    {-16449, 0, 0, 0, qc_N},
    {-16450, 0, 0, 0, qc_N},
    {-16451, 0, 0, 0, qc_N},
    {26248, 0, 0, 0, qc_N},
    {-16452, 0, 0, 0, qc_N},
    {21129, 0, 0, 0, qc_N},
    {26491, 0, 0, 0, qc_N},
    {26611, 0, 0, 0, qc_N},
    {28316, 0, 0, 0, qc_N},
    {29705, 0, 0, 0, qc_N},
    {30041, 0, 0, 0, qc_N},
    {30827, 0, 0, 0, qc_N},
    {32016, 0, 0, 0, qc_N},
    {-16453, 0, 0, 0, qc_N},
    {20845, 0, 0, 0, qc_N},
    {25134, 0, 0, 0, qc_N},
    {-16454, 0, 0, 0, qc_N},
    {20523, 0, 0, 0, qc_N},
    {23833, 0, 0, 0, qc_N},
    {28138, 0, 0, 0, qc_N},
    {-16455, 0, 0, 0, qc_N},
    {24459, 0, 0, 0, qc_N},
    {24900, 0, 0, 0, qc_N},
    {26647, 0, 0, 0, qc_N},
    {-16456, 0, 0, 0, qc_N},
    {21033, 0, 0, 0, qc_N},
    {21519, 0, 0, 0, qc_N},
    {23653, 0, 0, 0, qc_N},
    {26131, 0, 0, 0, qc_N},
    {26446, 0, 0, 0, qc_N},
    {26792, 0, 0, 0, qc_N},
    {27877, 0, 0, 0, qc_N},
    {29702, 0, 0, 0, qc_N},
    {30178, 0, 0, 0, qc_N},
    {32633, 0, 0, 0, qc_N},
    {-16457, 0, 0, 0, qc_N},
    {-16458, 0, 0, 0, qc_N},
    {-16459, 0, 0, 0, qc_N},
    {-16460, 0, 0, 0, qc_N},
    {21311, 0, 0, 0, qc_N},
    {28346, 0, 0, 0, qc_N},
    {21533, 0, 0, 0, qc_N},
    {29136, 0, 0, 0, qc_N},
    {29848, 0, 0, 0, qc_N},
    {-16461, 0, 0, 0, qc_N},
    {-16462, 0, 0, 0, qc_N},
    {-16463, 0, 0, 0, qc_N},
    {-16464, 0, 0, 0, qc_N},
    {26519, 0, 0, 0, qc_N},
    {28107, 0, 0, 0, qc_N},
    {-16465, 0, 0, 0, qc_N},
    {31435, 0, 0, 0, qc_N},
    {31520, 0, 0, 0, qc_N},
    {31890, 0, 0, 0, qc_N},
    {29376, 0, 0, 0, qc_N},
    {28825, 0, 0, 0, qc_N},
    {-16466, 0, 0, 0, qc_N},
    {20160, 0, 0, 0, qc_N},
    {-16467, 0, 0, 0, qc_N},
    {21050, 0, 0, 0, qc_N},
    {24230, 0, 0, 0, qc_N},
    {25299, 0, 0, 0, qc_N},
    {31958, 0, 0, 0, qc_N},
    {23429, 0, 0, 0, qc_N},
    {27934, 0, 0, 0, qc_N},
    {26292, 0, 0, 0, qc_N},
    {-16468, 0, 0, 0, qc_N},
    {-16469, 0, 0, 0, qc_N},
    {-16470, 0, 0, 0, qc_N},
    {-16471, 0, 0, 0, qc_N},
    {24275, 0, 0, 0, qc_N},
    {20800, 0, 0, 0, qc_N},
    {21952, 0, 0, 0, qc_N},
    {20958, 0, 0, 0, qc_N},
    {31036, 0, 0, 0, qc_N},
    {31070, 0, 0, 0, qc_N},
    {31077, 0, 0, 0, qc_N},
    {31934, 0, 0, 0, qc_N},
    {32701, 0, 0, 0, qc_N},
    {-16473, 0, 0, 0, qc_N},
    {-16476, 0, 0, 0, qc_N},
    {-16477, 0, 0, 0, qc_N},
    {-16478, 0, 0, 0, qc_N},
    {-16479, 0, 0, 0, qc_N},
    {-16480, 0, 0, 0, qc_N},
    {-16481, 0, 0, 0, qc_N},
    {-16482, 0, 0, 0, qc_N},
    {22120, 0, 0, 0, qc_N},
    {22592, 0, 0, 0, qc_N},
    {22696, 0, 0, 0, qc_N},
    {23652, 0, 0, 0, qc_N},
    {24936, 0, 0, 0, qc_N},
    {26082, 0, 0, 0, qc_N},
    {28186, 0, 0, 0, qc_N},
    {29227, 0, 0, 0, qc_N},
    {29730, 0, 0, 0, qc_N},
    {30865, 0, 0, 0, qc_N},
    {31038, 0, 0, 0, qc_N},
    {31049, 0, 0, 0, qc_N},
    {31048, 0, 0, 0, qc_N},
    {31056, 0, 0, 0, qc_N},
    {31069, 0, 0, 0, qc_N},
    {31117, 0, 0, 0, qc_N},
    {31118, 0, 0, 0, qc_N},
    {31361, 0, 0, 0, qc_N},
    {32265, 0, 0, 0, qc_N},
    {32321, 0, 0, 0, qc_N},
    {32626, 0, 0, 0, qc_N},
    {-16484, 0, 0, 0, qc_N},
    {-16487, 0, 0, 0, qc_N},
    {-16491, 0, 0, 0, qc_N},
    {-16493, 0, 0, 0, qc_N},
    {24693, 0, 0, 0, qc_N},
    {-16497, 0, 0, 0, qc_N},
    {-16498, 0, 0, 0, qc_N},
    {20006, 0, 0, 0, qc_N},
    {20840, 0, 0, 0, qc_N},
    {20352, 0, 0, 0, qc_N},
    {20805, 0, 0, 0, qc_N},
    {20864, 0, 0, 0, qc_N},
    {21845, 0, 0, 0, qc_N},
    {21986, 0, 0, 0, qc_N},
    {22707, 0, 0, 0, qc_N},
    {22852, 0, 0, 0, qc_N},
    {22868, 0, 0, 0, qc_N},
    {23138, 0, 0, 0, qc_N},
    {23336, 0, 0, 0, qc_N},
    {24274, 0, 0, 0, qc_N},
    {24281, 0, 0, 0, qc_N},
    {24425, 0, 0, 0, qc_N},
    {24493, 0, 0, 0, qc_N},
    {24792, 0, 0, 0, qc_N},
    {24840, 0, 0, 0, qc_N},
    {24928, 0, 0, 0, qc_N},
    {25140, 0, 0, 0, qc_N},
    {25540, 0, 0, 0, qc_N},
    {25628, 0, 0, 0, qc_N},
    {25682, 0, 0, 0, qc_N},
    {25942, 0, 0, 0, qc_N},
    {26454, 0, 0, 0, qc_N},
    {27513, 0, 0, 0, qc_N},
    {28379, 0, 0, 0, qc_N},
    {30631, 0, 0, 0, qc_N},
    {29359, 0, 0, 0, qc_N},
    {29958, 0, 0, 0, qc_N},
    {30011, 0, 0, 0, qc_N},
    {30237, 0, 0, 0, qc_N},
    {30239, 0, 0, 0, qc_N},
    {30427, 0, 0, 0, qc_N},
    {30528, 0, 0, 0, qc_N},
    {31409, 0, 0, 0, qc_N},
    {31867, 0, 0, 0, qc_N},
    {32091, 0, 0, 0, qc_N},
    {32574, 0, 0, 0, qc_N},
    {-16499, 0, 0, 0, qc_N},
    {-16500, 0, 0, 0, qc_N},
    {-16502, 0, 0, 0, qc_N},
    {-16503, 0, 0, 0, qc_N},
    {-16504, 0, 0, 0, qc_N},
    {-16505, 0, 0, 0, qc_N},
    {-16509, 0, 0, 0, qc_N},
    {-16510, 0, 0, 0, qc_N},
    {-16511, 0, 0, 0, qc_N},
    {-16512, 0, 0, 0, qc_N},
    {-16513, 0, 0, 0, qc_N},
    {-16516, 0, 0, 0, qc_N},
    {-16517, 0, 0, 0, qc_N},
    {-16518, 0, 0, 0, qc_N},
    {16408, 0, 0, 0, qc_N},
    {-16519, 0, 0, 0, qc_N},
    {-16520, 0, 0, 0, qc_N},
    {-16521, 0, 0, 0, qc_N},
    {-16522, 0, 0, 0, qc_N},
    {-16523, 0, 0, 0, qc_N},
    {-1933, 0, 0, 0, qc_N},
    {0, 0, 0, 26, 0},
    {-1935, 0, 0, 0, qc_N},
    {-1937, 0, 0, 0, qc_N},
    {-1939, 0, 0, 0, qc_N},
    {-16524, 0, 0, 0, qc_N},
    {-16526, 0, 0, 0, qc_N},
    {-1941, 0, 0, 0, qc_N},
    {-1943, 0, 0, 0, qc_N},
    {-1945, 0, 0, 0, qc_N},
    {-1947, 0, 0, 0, qc_N},
    {-1949, 0, 0, 0, qc_N},
    {-1951, 0, 0, 0, qc_N},
    {-1953, 0, 0, 0, qc_N},
    {-1955, 0, 0, 0, qc_N},
    {-1957, 0, 0, 0, qc_N},
    {-1959, 0, 0, 0, qc_N},
    {-1961, 0, 0, 0, qc_N},
    {-1963, 0, 0, 0, qc_N},
    {-1965, 0, 0, 0, qc_N},
    {-1967, 0, 0, 0, qc_N},
    {-1969, 0, 0, 0, qc_N},
    {-1971, 0, 0, 0, qc_N},
    {-1973, 0, 0, 0, qc_N},
    {-1975, 0, 0, 0, qc_N},
    {-1977, 0, 0, 0, qc_N},
    {-1979, 0, 0, 0, qc_N},
    {-1981, 0, 0, 0, qc_N},
    {-1983, 0, 0, 0, qc_N},
    {-1985, 0, 0, 0, qc_N},
    {-1987, 0, 0, 0, qc_N},
    {-1989, 0, 0, 0, qc_N},
    {-1991, 0, 0, 0, qc_N},
    {-1993, 0, 0, 0, qc_N},
    {-1995, 0, 0, 0, qc_N},
    {0, 0, 12475, 0, 0},
    {-16528, 0, 0, 0, 0},
    {0, 0, 12538, 0, 0},
    {-16530, 0, 0, 0, 0},
    {0, 0, 12664, 0, 0},
    {-16532, 0, 0, 0, 0},
    {0, 0, -42, 7, qc_M},
    {0, 0, -43, 0, qc_M},
    {-16534, 0, 0, 0, 0},
    {-16536, 0, 0, 0, 0},
    {0, 0, 14365, 0, 0},
    {0, 0, 14428, 0, 0},
    {0, 0, -44, 0, qc_M},
    {0, 0, 14491, 0, 0},
    {-16538, 0, 0, 0, 0},
    {-16540, 0, 0, 0, 0},
    {0, 0, -45, 0, qc_M},
    {0, 0, -47, 0, qc_M},
    {0, 0, 14554, 0, 0},
    {0, 0, -46, 0, qc_M},
    {-16542, 0, 0, 0, 0},
    {-16544, 0, 0, 0, 0},
    {0, 0, -48, 0, qc_M},
    {-16546, 0, 0, 0, 0},
    {0, 0, -49, 0, qc_M},
    {0, 0, 14617, 0, 0},
    {0, 0, 14680, 0, 0},
    {-16548, 0, 0, 0, 0},
    {-16550, 0, 0, 0, 0},
    {0, 0, -50, 0, qc_M},
    {0, 0, 14743, 0, 0},
    {-16552, 0, 0, 0, 0},
    {-16554, 0, 0, 0, qc_N},
    {-16556, 0, 0, 0, qc_N},
    {-16558, 0, 0, 0, qc_N},
    {-16560, 0, 0, 0, qc_N},
    {-16562, 0, 0, 0, qc_N},
    {-16564, 0, 0, 0, qc_N},
    {-16566, 0, 0, 0, qc_N},
    {0, 0, 0, 226, 0},
    {-16568, 0, 0, 0, qc_N},
    {-16570, 0, 0, 0, qc_N},
    {-16572, 0, 0, 0, qc_N},
    {-16574, 0, 0, 0, qc_N},
    {-16576, 0, 0, 0, qc_N},
    {-16578, 0, 0, 0, qc_N},
    {20029, 0, 0, 0, qc_N},
    {20024, 0, 0, 0, qc_N},
    {20033, 0, 0, 0, qc_N},
    {-16580, 0, 0, 0, qc_N},
    {20320, 0, 0, 0, qc_N},
    {20411, 0, 0, 0, qc_N},
    {20482, 0, 0, 0, qc_N},
    {20602, 0, 0, 0, qc_N},
    {20633, 0, 0, 0, qc_N},
    {20687, 0, 0, 0, qc_N},
    {13470, 0, 0, 0, qc_N},
    {-16581, 0, 0, 0, qc_N},
    {20820, 0, 0, 0, qc_N},
    {20836, 0, 0, 0, qc_N},
    {20855, 0, 0, 0, qc_N},
    {-16582, 0, 0, 0, qc_N},
    {13497, 0, 0, 0, qc_N},
    {20839, 0, 0, 0, qc_N},
    {20877, 0, 0, 0, qc_N},
    {-16583, 0, 0, 0, qc_N},
    {20887, 0, 0, 0, qc_N},
    {20900, 0, 0, 0, qc_N},
    {20172, 0, 0, 0, qc_N},
    {20908, 0, 0, 0, qc_N},
    {-16584, 0, 0, 0, qc_N},
    {20981, 0, 0, 0, qc_N},
    {20995, 0, 0, 0, qc_N},
    {13535, 0, 0, 0, qc_N},
    {21051, 0, 0, 0, qc_N},
    {21062, 0, 0, 0, qc_N},
    {21106, 0, 0, 0, qc_N},
    {21111, 0, 0, 0, qc_N},
    {13589, 0, 0, 0, qc_N},
    {21253, 0, 0, 0, qc_N},
    {21254, 0, 0, 0, qc_N},
    {21321, 0, 0, 0, qc_N},
    {21338, 0, 0, 0, qc_N},
    {21363, 0, 0, 0, qc_N},
    {21373, 0, 0, 0, qc_N},
    {-16585, 0, 0, 0, qc_N},
    {28784, 0, 0, 0, qc_N},
    {21450, 0, 0, 0, qc_N},
    {21471, 0, 0, 0, qc_N},
    {-16586, 0, 0, 0, qc_N},
    {21483, 0, 0, 0, qc_N},
    {21489, 0, 0, 0, qc_N},
    {21510, 0, 0, 0, qc_N},
    {21662, 0, 0, 0, qc_N},
    {21560, 0, 0, 0, qc_N},
    {21576, 0, 0, 0, qc_N},
    {21608, 0, 0, 0, qc_N},
    {21666, 0, 0, 0, qc_N},
    {21750, 0, 0, 0, qc_N},
    {21776, 0, 0, 0, qc_N},
    {21843, 0, 0, 0, qc_N},
    {21859, 0, 0, 0, qc_N},
    {21931, 0, 0, 0, qc_N},
    {21939, 0, 0, 0, qc_N},
    {21954, 0, 0, 0, qc_N},
    {22294, 0, 0, 0, qc_N},
    {22295, 0, 0, 0, qc_N},
    {22097, 0, 0, 0, qc_N},
    {22132, 0, 0, 0, qc_N},
    {22766, 0, 0, 0, qc_N},
    {22478, 0, 0, 0, qc_N},
    {22516, 0, 0, 0, qc_N},
    {22541, 0, 0, 0, qc_N},
    {22411, 0, 0, 0, qc_N},
    {22578, 0, 0, 0, qc_N},
    {22577, 0, 0, 0, qc_N},
    {22700, 0, 0, 0, qc_N},
    {-16587, 0, 0, 0, qc_N},
    {22770, 0, 0, 0, qc_N},
    {22775, 0, 0, 0, qc_N},
    {22790, 0, 0, 0, qc_N},
    {22810, 0, 0, 0, qc_N},
    {22818, 0, 0, 0, qc_N},
    {22882, 0, 0, 0, qc_N},
    {-16588, 0, 0, 0, qc_N},
    {-16589, 0, 0, 0, qc_N},
    {23020, 0, 0, 0, qc_N},
    {23067, 0, 0, 0, qc_N},
    {23079, 0, 0, 0, qc_N},
    {23000, 0, 0, 0, qc_N},
    {23142, 0, 0, 0, qc_N},
    {14062, 0, 0, 0, qc_N},
    {14076, 0, 0, 0, qc_N},
    {23304, 0, 0, 0, qc_N},
    {-16590, 0, 0, 0, qc_N},
    {23491, 0, 0, 0, qc_N},
    {23512, 0, 0, 0, qc_N},
    {23539, 0, 0, 0, qc_N},
    {-16591, 0, 0, 0, qc_N},
    {23551, 0, 0, 0, qc_N},
    {23558, 0, 0, 0, qc_N},
    {24403, 0, 0, 0, qc_N},
    {23586, 0, 0, 0, qc_N},
    {14209, 0, 0, 0, qc_N},
    {23648, 0, 0, 0, qc_N},
    {23744, 0, 0, 0, qc_N},
    {23693, 0, 0, 0, qc_N},
    {-16592, 0, 0, 0, qc_N},
    {23875, 0, 0, 0, qc_N},
    {-16593, 0, 0, 0, qc_N},
    {23918, 0, 0, 0, qc_N},
    {23915, 0, 0, 0, qc_N},
    {23932, 0, 0, 0, qc_N},
    {24033, 0, 0, 0, qc_N},
    {24034, 0, 0, 0, qc_N},
    {14383, 0, 0, 0, qc_N},
    {24061, 0, 0, 0, qc_N},
    {24104, 0, 0, 0, qc_N},
    {24125, 0, 0, 0, qc_N},
    {24169, 0, 0, 0, qc_N},
    {14434, 0, 0, 0, qc_N},
    {-16594, 0, 0, 0, qc_N},
    {14460, 0, 0, 0, qc_N},
    {24240, 0, 0, 0, qc_N},
    {24243, 0, 0, 0, qc_N},
    {24246, 0, 0, 0, qc_N},
    {-16595, 0, 0, 0, qc_N},
    {24318, 0, 0, 0, qc_N},
    {14535, 0, 0, 0, qc_N},
    {-16598, 0, 0, 0, qc_N},
    {-16599, 0, 0, 0, qc_N},
    {24418, 0, 0, 0, qc_N},
    {24427, 0, 0, 0, qc_N},
    {14563, 0, 0, 0, qc_N},
    {24474, 0, 0, 0, qc_N},
    {24525, 0, 0, 0, qc_N},
    {24535, 0, 0, 0, qc_N},
    {24569, 0, 0, 0, qc_N},
    {24705, 0, 0, 0, qc_N},
    {14650, 0, 0, 0, qc_N},
    {14620, 0, 0, 0, qc_N},
    {-16600, 0, 0, 0, qc_N},
    {24775, 0, 0, 0, qc_N},
    {24904, 0, 0, 0, qc_N},
    {24954, 0, 0, 0, qc_N},
    {25010, 0, 0, 0, qc_N},
    {24996, 0, 0, 0, qc_N},
    {25007, 0, 0, 0, qc_N},
    {25054, 0, 0, 0, qc_N},
    {25104, 0, 0, 0, qc_N},
    {25115, 0, 0, 0, qc_N},
    {25181, 0, 0, 0, qc_N},
    {25265, 0, 0, 0, qc_N},
    {25300, 0, 0, 0, qc_N},
    {25424, 0, 0, 0, qc_N},
    {-16601, 0, 0, 0, qc_N},
    {25405, 0, 0, 0, qc_N},
    {25340, 0, 0, 0, qc_N},
    {25448, 0, 0, 0, qc_N},
    {25475, 0, 0, 0, qc_N},
    {25572, 0, 0, 0, qc_N},
    {-16602, 0, 0, 0, qc_N},
    {25634, 0, 0, 0, qc_N},
    {25541, 0, 0, 0, qc_N},
    {25513, 0, 0, 0, qc_N},
    {14894, 0, 0, 0, qc_N},
    {25705, 0, 0, 0, qc_N},
    {25726, 0, 0, 0, qc_N},
    {25757, 0, 0, 0, qc_N},
    {25719, 0, 0, 0, qc_N},
    {14956, 0, 0, 0, qc_N},
    {25964, 0, 0, 0, qc_N},
    {-16603, 0, 0, 0, qc_N},
    {26083, 0, 0, 0, qc_N},
    {26360, 0, 0, 0, qc_N},
    {26185, 0, 0, 0, qc_N},
    {15129, 0, 0, 0, qc_N},
    {15112, 0, 0, 0, qc_N},
    {15076, 0, 0, 0, qc_N},
    {20882, 0, 0, 0, qc_N},
    {20885, 0, 0, 0, qc_N},
    {26368, 0, 0, 0, qc_N},
    {26268, 0, 0, 0, qc_N},
    {-16604, 0, 0, 0, qc_N},
    {17369, 0, 0, 0, qc_N},
    {26401, 0, 0, 0, qc_N},
    {26462, 0, 0, 0, qc_N},
    {26451, 0, 0, 0, qc_N},
    {-16605, 0, 0, 0, qc_N},
    {15177, 0, 0, 0, qc_N},
    {26618, 0, 0, 0, qc_N},
    {26501, 0, 0, 0, qc_N},
    {26706, 0, 0, 0, qc_N},
    {-16606, 0, 0, 0, qc_N},
    {26766, 0, 0, 0, qc_N},
    {26655, 0, 0, 0, qc_N},
    {26900, 0, 0, 0, qc_N},
    {26946, 0, 0, 0, qc_N},
    {27043, 0, 0, 0, qc_N},
    {27114, 0, 0, 0, qc_N},
    {27304, 0, 0, 0, qc_N},
    {-16607, 0, 0, 0, qc_N},
    {27355, 0, 0, 0, qc_N},
    {15384, 0, 0, 0, qc_N},
    {27425, 0, 0, 0, qc_N},
    {-16608, 0, 0, 0, qc_N},
    {27476, 0, 0, 0, qc_N},
    {15438, 0, 0, 0, qc_N},
    {27506, 0, 0, 0, qc_N},
    {27551, 0, 0, 0, qc_N},
    {27579, 0, 0, 0, qc_N},
    {-16609, 0, 0, 0, qc_N},
    {-16610, 0, 0, 0, qc_N},
    {-16611, 0, 0, 0, qc_N},
    {27726, 0, 0, 0, qc_N},
    {-16612, 0, 0, 0, qc_N},
    {27839, 0, 0, 0, qc_N},
    {27853, 0, 0, 0, qc_N},
    {27751, 0, 0, 0, qc_N},
    {27926, 0, 0, 0, qc_N},
    {27966, 0, 0, 0, qc_N},
    {28009, 0, 0, 0, qc_N},
    {28024, 0, 0, 0, qc_N},
    {28037, 0, 0, 0, qc_N},
    {-16613, 0, 0, 0, qc_N},
    {27956, 0, 0, 0, qc_N},
    {28207, 0, 0, 0, qc_N},
    {28270, 0, 0, 0, qc_N},
    {15667, 0, 0, 0, qc_N},
    {28359, 0, 0, 0, qc_N},
    {-16614, 0, 0, 0, qc_N},
    {28153, 0, 0, 0, qc_N},
    {28526, 0, 0, 0, qc_N},
    {-16615, 0, 0, 0, qc_N},
    {-16616, 0, 0, 0, qc_N},
    {28614, 0, 0, 0, qc_N},
    {28729, 0, 0, 0, qc_N},
    {28699, 0, 0, 0, qc_N},
    {15766, 0, 0, 0, qc_N},
    {28746, 0, 0, 0, qc_N},
    {28797, 0, 0, 0, qc_N},
    {28791, 0, 0, 0, qc_N},
    {28845, 0, 0, 0, qc_N},
    {-16617, 0, 0, 0, qc_N},
    {28997, 0, 0, 0, qc_N},
    {-16618, 0, 0, 0, qc_N},
    {29084, 0, 0, 0, qc_N},
    {-16619, 0, 0, 0, qc_N},
    {29224, 0, 0, 0, qc_N},
    {29264, 0, 0, 0, qc_N},
    {-16620, 0, 0, 0, qc_N},
    {29312, 0, 0, 0, qc_N},
    {29333, 0, 0, 0, qc_N},
    {-16621, 0, 0, 0, qc_N},
    {-16622, 0, 0, 0, qc_N},
    {29562, 0, 0, 0, qc_N},
    {29579, 0, 0, 0, qc_N},
    {16044, 0, 0, 0, qc_N},
    {29605, 0, 0, 0, qc_N},
    {29767, 0, 0, 0, qc_N},
    {29788, 0, 0, 0, qc_N},
    {29829, 0, 0, 0, qc_N},
    {29898, 0, 0, 0, qc_N},
    {16155, 0, 0, 0, qc_N},
    {29988, 0, 0, 0, qc_N},
    {-16623, 0, 0, 0, qc_N},
    {30014, 0, 0, 0, qc_N},
    {-16624, 0, 0, 0, qc_N},
    {-16625, 0, 0, 0, qc_N},
    {30224, 0, 0, 0, qc_N},
    {-16626, 0, 0, 0, qc_N},
    {-16627, 0, 0, 0, qc_N},
    {-16628, 0, 0, 0, qc_N},
    {16380, 0, 0, 0, qc_N},
    {16392, 0, 0, 0, qc_N},
    {-16629, 0, 0, 0, qc_N},
    {-16630, 0, 0, 0, qc_N},
    {-16631, 0, 0, 0, qc_N},
    {-16632, 0, 0, 0, qc_N},
    {30494, 0, 0, 0, qc_N},
    {30603, 0, 0, 0, qc_N},
    {16454, 0, 0, 0, qc_N},
    {16534, 0, 0, 0, qc_N},
    {-16633, 0, 0, 0, qc_N},
    {30798, 0, 0, 0, qc_N},
    {16611, 0, 0, 0, qc_N},
    {-16634, 0, 0, 0, qc_N},
    {-16635, 0, 0, 0, qc_N},
    {-16636, 0, 0, 0, qc_N},
    {31211, 0, 0, 0, qc_N},
    {16687, 0, 0, 0, qc_N},
    {31306, 0, 0, 0, qc_N},
    {31311, 0, 0, 0, qc_N},
    {-16637, 0, 0, 0, qc_N},
    {31470, 0, 0, 0, qc_N},
    {16898, 0, 0, 0, qc_N},
    {-16639, 0, 0, 0, qc_N},
    {31686, 0, 0, 0, qc_N},
    {31689, 0, 0, 0, qc_N},
    {16935, 0, 0, 0, qc_N},
    {-16640, 0, 0, 0, qc_N},
    {31954, 0, 0, 0, qc_N},
    {17056, 0, 0, 0, qc_N},
    {31976, 0, 0, 0, qc_N},
    {31971, 0, 0, 0, qc_N},
    {32000, 0, 0, 0, qc_N},
    {-16641, 0, 0, 0, qc_N},
    {32099, 0, 0, 0, qc_N},
    {17153, 0, 0, 0, qc_N},
    {32199, 0, 0, 0, qc_N},
    {32258, 0, 0, 0, qc_N},
    {32325, 0, 0, 0, qc_N},
    {17204, 0, 0, 0, qc_N},
    {-16642, 0, 0, 0, qc_N},
    {-16643, 0, 0, 0, qc_N},
    {17241, 0, 0, 0, qc_N},
    {-16644, 0, 0, 0, qc_N},
    {32634, 0, 0, 0, qc_N},
    {-16645, 0, 0, 0, qc_N},
    {32661, 0, 0, 0, qc_N},
    {32762, 0, 0, 0, qc_N},
    {-16646, 0, 0, 0, qc_N},
    {-16647, 0, 0, 0, qc_N},
    {-16648, 0, 0, 0, qc_N},
    {-16649, 0, 0, 0, qc_N},
    {-16650, 0, 0, 0, qc_N},
    {-16651, 0, 0, 0, qc_N},
    {17365, 0, 0, 0, qc_N},
    {-16652, 0, 0, 0, qc_N},
    {-16653, 0, 0, 0, qc_N},
    {17419, 0, 0, 0, qc_N},
    {-16654, 0, 0, 0, qc_N},
    {23221, 0, 0, 0, qc_N},
    {-16655, 0, 0, 0, qc_N},
    {-16656, 0, 0, 0, qc_N},
    {-16657, 0, 0, 0, qc_N},
    {-16658, 0, 0, 0, qc_N},
    {-16659, 0, 0, 0, qc_N},
    {-16660, 0, 0, 0, qc_N},
    {17515, 0, 0, 0, qc_N},
    {-16661, 0, 0, 0, qc_N},
    {-16662, 0, 0, 0, qc_N},
    {-16663, 0, 0, 0, qc_N},
    {21171, 0, 0, 0, qc_N},
    {-16664, 0, 0, 0, qc_N},
    {-16665, 0, 0, 0, qc_N},
    {-16666, 0, 0, 0, qc_N},
    {-16667, 0, 0, 0, qc_N},
    {-16668, 0, 0, 0, qc_N},
    {-16669, 0, 0, 0, qc_N},
    {-16670, 0, 0, 0, qc_N},
    {-16671, 0, 0, 0, qc_N},
    {-16672, 0, 0, 0, qc_N},
    {-16673, 0, 0, 0, qc_N},
    {-16674, 0, 0, 0, qc_N},
    {-16675, 0, 0, 0, qc_N},
    {-16676, 0, 0, 0, qc_N},
    {-16677, 0, 0, 0, qc_N},
    {-16678, 0, 0, 0, qc_N},
    {-16679, 0, 0, 0, qc_N},
    {-16680, 0, 0, 0, qc_N},
    {-16681, 0, 0, 0, qc_N},
    {17707, 0, 0, 0, qc_N},
    {-16682, 0, 0, 0, qc_N},
    {-16683, 0, 0, 0, qc_N},
    {-16684, 0, 0, 0, qc_N},
    {-16685, 0, 0, 0, qc_N},
    {-16686, 0, 0, 0, qc_N},
    {-16687, 0, 0, 0, qc_N},
    {17757, 0, 0, 0, qc_N},
    {17761, 0, 0, 0, qc_N},
    {-16688, 0, 0, 0, qc_N},
    {-16689, 0, 0, 0, qc_N},
    {17771, 0, 0, 0, qc_N},
    {-16690, 0, 0, 0, qc_N},
    {-16691, 0, 0, 0, qc_N},
    {-16692, 0, 0, 0, qc_N},
    {-16693, 0, 0, 0, qc_N},
    {-16694, 0, 0, 0, qc_N},
    {-16695, 0, 0, 0, qc_N},
    {-16696, 0, 0, 0, qc_N},
    {-16697, 0, 0, 0, qc_N},
    {-16698, 0, 0, 0, qc_N},
    {-16699, 0, 0, 0, qc_N},
    {17879, 0, 0, 0, qc_N},
    {-16700, 0, 0, 0, qc_N},
    {-16701, 0, 0, 0, qc_N},
    {17913, 0, 0, 0, qc_N},
    {-16702, 0, 0, 0, qc_N},
    {-16703, 0, 0, 0, qc_N},
    {-16704, 0, 0, 0, qc_N},
    {-16705, 0, 0, 0, qc_N},
    {-16706, 0, 0, 0, qc_N},
    {17973, 0, 0, 0, qc_N},
    {-16707, 0, 0, 0, qc_N},
    {13499, 0, 0, 0, qc_N},
    {-16708, 0, 0, 0, qc_N},
    {-16709, 0, 0, 0, qc_N},
    {18110, 0, 0, 0, qc_N},
    {18119, 0, 0, 0, qc_N},
    {-16710, 0, 0, 0, qc_N},
    {-16711, 0, 0, 0, qc_N},
    {-16712, 0, 0, 0, qc_N},
    {-16713, 0, 0, 0, qc_N},
    {-16714, 0, 0, 0, qc_N},
    {-16715, 0, 0, 0, qc_N},
    {-16716, 0, 0, 0, qc_N},
    {-16717, 0, 0, 0, qc_N},
    {-16718, 0, 0, 0, qc_N},
    {-16719, 0, 0, 0, qc_N},
    {-16720, 0, 0, 0, qc_N},
    {-16721, 0, 0, 0, qc_N},
    {-16722, 0, 0, 0, qc_N},
    {-16723, 0, 0, 0, qc_N},
    {-16724, 0, 0, 0, qc_N},
    {-16725, 0, 0, 0, qc_N},
    {-16726, 0, 0, 0, qc_N},
    {-16727, 0, 0, 0, qc_N},
    {-16728, 0, 0, 0, qc_N},
    {-16729, 0, 0, 0, qc_N},
    {-16730, 0, 0, 0, qc_N},
    {-16731, 0, 0, 0, qc_N},
    {-16732, 0, 0, 0, qc_N},
    {-16733, 0, 0, 0, qc_N},
    {-16734, 0, 0, 0, qc_N},
    {-16735, 0, 0, 0, qc_N},
    {-16736, 0, 0, 0, qc_N},
    {-16737, 0, 0, 0, qc_N},
    {-16738, 0, 0, 0, qc_N},
    {18837, 0, 0, 0, qc_N},
    {-16739, 0, 0, 0, qc_N},
    {-16740, 0, 0, 0, qc_N},
    {18918, 0, 0, 0, qc_N},
    {-16741, 0, 0, 0, qc_N},
    {23986, 0, 0, 0, qc_N},
    {-16742, 0, 0, 0, qc_N},
    {-16743, 0, 0, 0, qc_N},
    {-16744, 0, 0, 0, qc_N},
    {19054, 0, 0, 0, qc_N},
    {19062, 0, 0, 0, qc_N},
    {-16745, 0, 0, 0, qc_N},
    {-16746, 0, 0, 0, qc_N},
    {19122, 0, 0, 0, qc_N},
    {-16747, 0, 0, 0, qc_N},
    {-16748, 0, 0, 0, qc_N},
    {-16749, 0, 0, 0, qc_N},
    {-16750, 0, 0, 0, qc_N},
    {19251, 0, 0, 0, qc_N},
    {-16751, 0, 0, 0, qc_N},
    {-16752, 0, 0, 0, qc_N},
    {-16753, 0, 0, 0, qc_N},
    {-16754, 0, 0, 0, qc_N},
    {19406, 0, 0, 0, qc_N},
    {-16755, 0, 0, 0, qc_N},
    {-16756, 0, 0, 0, qc_N},
    {-16757, 0, 0, 0, qc_N},
    {19662, 0, 0, 0, qc_N},
    {19693, 0, 0, 0, qc_N},
    {-16758, 0, 0, 0, qc_N},
    {-16759, 0, 0, 0, qc_N},
    {19704, 0, 0, 0, qc_N},
    {-16760, 0, 0, 0, qc_N},
    {-16761, 0, 0, 0, qc_N},
    {-16762, 0, 0, 0, qc_N},
    {-16763, 0, 0, 0, qc_N},
    {19798, 0, 0, 0, qc_N},
    {-16764, 0, 0, 0, qc_N},
    {-16765, 0, 0, 0, qc_N},
    {-16766, 0, 0, 0, qc_N},
    {-16767, 0, 0, 0, qc_N},
    {-16768, 0, 0, 0, qc_N},
    {-16769, 0, 0, 0, qc_N},
    {-16770, 0, 0, 0, qc_N},
};

const uint32_t ucomposed[14] = {
    0, 69786, 69788, 69803, 69934, 69935, 70475, 70476,
    70843, 70844, 70846, 71098, 71099, 71992,
};

const int16_t ucomposing[23751] = {
    192, 193, 194, 195, 196, 197, 0, 256,
    258, 260, 550, 461, 0, 0, 0, 512,
    514, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7680, 7840, 0, 0, 0,
    0, 0, 7842, 0, 0, 0, 0,
    0, 262, 264, 0, 0, 0, 199, 0,
    0, 0, 266, 268, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    200, 201, 202, 7868, 203, 0, 552, 274,
    276, 280, 278, 282, 0, 0, 0, 516,
    518, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7864, 0, 7704, 7706,
    0, 0, 7866, 0, 0, 0, 0,
    204, 205, 206, 296, 207, 0, 0, 298,
    300, 302, 304, 463, 0, 0, 0, 520,
    522, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7882, 0, 0, 7724,
    0, 0, 7880, 0, 0, 0, 0,
    504, 323, 0, 209, 0, 0, 325, 0,
    0, 0, 7748, 327, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7750, 7752, 7754, 0,
    0, 0, 0, 0, 0, 0, 0,
    210, 211, 212, 213, 214, 0, 0, 332,
    334, 490, 558, 465, 336, 0, 416, 524,
    526, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7884, 0, 0, 0,
    0, 0, 7886, 0, 0, 0, 0,
    217, 218, 219, 360, 220, 366, 0, 362,
    364, 370, 0, 467, 368, 0, 431, 532,
    534, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7908, 0, 7798, 7796,
    0, 7794, 7910, 0, 0, 0, 0,
    7922, 221, 374, 7928, 376, 0, 0, 562,
    0, 0, 7822, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7924, 0, 0, 0,
    0, 0, 7926, 0, 0, 0, 0,
    224, 225, 226, 227, 228, 229, 0, 257,
    259, 261, 551, 462, 0, 0, 0, 513,
    515, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7681, 7841, 0, 0, 0,
    0, 0, 7843, 0, 0, 0, 0,
    0, 263, 265, 0, 0, 0, 231, 0,
    0, 0, 267, 269, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    232, 233, 234, 7869, 235, 0, 553, 275,
    277, 281, 279, 283, 0, 0, 0, 517,
    519, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7865, 0, 7705, 7707,
    0, 0, 7867, 0, 0, 0, 0,
    236, 237, 238, 297, 239, 0, 0, 299,
    301, 303, 0, 464, 0, 0, 0, 521,
    523, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7883, 0, 0, 7725,
    0, 0, 7881, 0, 0, 0, 0,
    505, 324, 0, 241, 0, 0, 326, 0,
    0, 0, 7749, 328, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7751, 7753, 7755, 0,
    0, 0, 0, 0, 0, 0, 0,
    242, 243, 244, 245, 246, 0, 0, 333,
    335, 491, 559, 466, 337, 0, 417, 525,
    527, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7885, 0, 0, 0,
    0, 0, 7887, 0, 0, 0, 0,
    249, 250, 251, 361, 252, 367, 0, 363,
    365, 371, 0, 468, 369, 0, 432, 533,
    535, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7909, 0, 7799, 7797,
    0, 7795, 7911, 0, 0, 0, 0,
    7923, 253, 375, 7929, 255, 7833, 0, 563,
    0, 0, 7823, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7925, 0, 0, 0,
    0, 0, 7927, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 7696, 0,
    0, 0, 7690, 270, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7692, 7694, 7698, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 7697, 0,
    0, 0, 7691, 271, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7693, 7695, 7699, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 500, 284, 0, 0, 0, 290, 7712,
    286, 0, 288, 486, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 501, 285, 0, 0, 0, 291, 7713,
    287, 0, 289, 487, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 292, 0, 7718, 0, 7720, 0,
    0, 0, 7714, 542, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7716, 0, 0, 0,
    7722, 0, 0, 0, 0, 0, 0,
    0, 0, 293, 0, 7719, 0, 7721, 0,
    0, 0, 7715, 543, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7717, 7830, 0, 0,
    7723, 0, 0, 0, 0, 0, 0,
    0, 0, 308, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 309, 0, 0, 0, 0, 0,
    0, 0, 0, 496, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 7728, 0, 0, 0, 0, 310, 0,
    0, 0, 0, 488, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7730, 7732, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 7729, 0, 0, 0, 0, 311, 0,
    0, 0, 0, 489, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7731, 7733, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 313, 0, 0, 0, 0, 315, 0,
    0, 0, 0, 317, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7734, 7738, 7740, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 314, 0, 0, 0, 0, 316, 0,
    0, 0, 0, 318, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7735, 7739, 7741, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 340, 0, 0, 0, 0, 342, 0,
    0, 0, 7768, 344, 0, 0, 0, 528,
    530, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7770, 7774, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 341, 0, 0, 0, 0, 343, 0,
    0, 0, 7769, 345, 0, 0, 0, 529,
    531, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7771, 7775, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 346, 348, 0, 0, 0, 350, 0,
    0, 0, 7776, 352, 0, 0, 0, 0,
    0, 536, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7778, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 347, 349, 0, 0, 0, 351, 0,
    0, 0, 7777, 353, 0, 0, 0, 0,
    0, 537, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7779, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 354, 0,
    0, 0, 7786, 356, 0, 0, 0, 0,
    0, 538, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7788, 7790, 7792, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7831, 0, 355, 0,
    0, 0, 7787, 357, 0, 0, 0, 0,
    0, 539, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7789, 7791, 7793, 0,
    0, 0, 0, 0, 0, 0, 0,
    7808, 7810, 372, 0, 7812, 0, 0, 0,
    0, 0, 7814, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7816, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    7809, 7811, 373, 0, 7813, 7832, 0, 0,
    0, 0, 7815, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7817, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 377, 7824, 0, 0, 0, 0, 0,
    0, 0, 379, 381, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7826, 7828, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 378, 7825, 0, 0, 0, 0, 0,
    0, 0, 380, 382, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7827, 7829, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8602, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8603, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8622, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    475, 471, 0, 0, 0, 0, 0, 469,
    0, 0, 0, 473, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    476, 472, 0, 0, 0, 0, 0, 470,
    0, 0, 0, 474, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 478,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 479,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 480,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 481,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 508, 0, 0, 0, 0, 0, 482,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 509, 0, 0, 0, 0, 0, 483,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 492,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 493,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 494, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 495, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 506, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 507, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 510, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 511, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8740, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8742, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 554,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 555,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 7756, 0, 0, 7758, 0, 0, 556,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 7757, 0, 0, 7759, 0, 0, 557,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 560,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 561,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8769, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8772, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8775, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8777, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8800, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8802, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8813, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8814, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8815, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8816, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8817, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8820, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8821, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8824, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8825, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8832, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8833, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8836, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8837, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8840, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8841, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8876, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8877, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8878, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8879, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8928, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8929, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8930, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8931, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8938, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8939, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8940, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8941, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    8173, 901, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8129, 0,
    8122, 902, 0, 0, 0, 0, 0, 8121,
    8120, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7944, 7945, 0, 8124,
    8136, 904, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7960, 7961, 0, 0,
    8138, 905, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7976, 7977, 0, 8140,
    8154, 906, 0, 0, 938, 0, 0, 8153,
    8152, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7992, 7993, 0, 0,
    8184, 908, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 8008, 8009, 0, 0,
    8170, 910, 0, 0, 939, 0, 0, 8169,
    8168, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 8025, 0, 0,
    8186, 911, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 8040, 8041, 0, 8188,
    8146, 912, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8151, 0,
    8048, 940, 0, 0, 0, 0, 0, 8113,
    8112, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7936, 7937, 8118, 8115,
    8050, 941, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7952, 7953, 0, 0,
    8052, 942, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7968, 7969, 8134, 8131,
    8054, 943, 0, 0, 970, 0, 0, 8145,
    8144, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7984, 7985, 8150, 0,
    8162, 944, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8167, 0,
    8058, 973, 0, 0, 971, 0, 0, 8161,
    8160, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 8016, 8017, 8166, 0,
    8056, 972, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 8000, 8001, 0, 0,
    8060, 974, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 8032, 8033, 8182, 8179,
    0, 979, 0, 0, 980, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    1024, 0, 0, 0, 1025, 0, 0, 0,
    1238, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 1027, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1031, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 1036, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    1037, 0, 0, 0, 1252, 0, 0, 1250,
    1049, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1264, 0, 0, 1262,
    1038, 0, 0, 0, 1266, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    1117, 0, 0, 0, 1253, 0, 0, 1251,
    1081, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    1104, 0, 0, 0, 1105, 0, 0, 0,
    1239, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 1107, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1111, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 1116, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1265, 0, 0, 1263,
    1118, 0, 0, 0, 1267, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1142,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1143,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1244, 0, 0, 0,
    1217, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1245, 0, 0, 0,
    1218, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1234, 0, 0, 0,
    1232, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1235, 0, 0, 0,
    1233, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1242, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1243, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1246, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1247, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1254, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1255, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1258, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1259, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1260, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1261, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1268, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1269, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1272, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1273, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1570, 1571, 1573, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1572, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1574, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1728, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1730, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1747, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2345, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2353, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2356, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 2507, 2508,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8653, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8654, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8655, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2888, 2891, 2892, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2964, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 3020, 3018, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 3019, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8708, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8713, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 3144, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8716, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 3264, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 3271, 3272,
    3274, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 3275, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 3402, 3404, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 3403, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 3546, 3548, 3550, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 3549, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 4134, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12364,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12366,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12368,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12370,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12372,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12374,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12376,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12378,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12380,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12382,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12384,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12386,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12389,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12391,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12393,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12400,
    12401, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12403,
    12404, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12406,
    12407, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12409,
    12410, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12412,
    12413, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12436,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12446,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12460,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12462,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12464,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12466,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12468,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12470,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12472,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12474,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12476,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12478,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12480,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12482,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12485,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12487,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12489,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12496,
    12497, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12499,
    12500, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12502,
    12503, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12505,
    12506, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12508,
    12509, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12532,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12535,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12536,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12537,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12538,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12542,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -6, -7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -8, -9, -10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -11, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -12, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -13, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6918, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6920, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6922, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6924, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6926, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6930, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6971, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6973, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6976, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6977, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6979, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7682, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7684, 7686, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7683, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7685, 7687, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 7688, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 7689, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    7700, 7702, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    7701, 7703, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    7708, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    7709, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7710, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7711, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 7726, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 7727, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 7736,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 7737,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 7742, 0, 0, 0, 0, 0, 0,
    0, 0, 7744, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7746, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 7743, 0, 0, 0, 0, 0, 0,
    0, 0, 7745, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7747, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    7760, 7762, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    7761, 7763, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 7764, 0, 0, 0, 0, 0, 0,
    0, 0, 7766, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 7765, 0, 0, 0, 0, 0, 0,
    0, 0, 7767, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 7772,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 7773,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7780, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7781, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7782, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7783, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7784, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7785, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 7800, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 7801, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7802, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7803, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7804, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7806, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7805, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7807, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7820, 0, 0, 0,
    0, 0, 7818, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7821, 0, 0, 0,
    0, 0, 7819, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7835, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    7846, 7844, 0, 7850, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7848, 0, 0, 0, 0,
    7847, 7845, 0, 7851, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7849, 0, 0, 0, 0,
    0, 0, 7852, 0, 0, 0, 0, 0,
    7862, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 7853, 0, 0, 0, 0, 0,
    7863, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    7856, 7854, 0, 7860, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7858, 0, 0, 0, 0,
    7857, 7855, 0, 7861, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7859, 0, 0, 0, 0,
    7872, 7870, 0, 7876, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7874, 0, 0, 0, 0,
    7873, 7871, 0, 7877, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7875, 0, 0, 0, 0,
    0, 0, 7878, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 7879, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    7890, 7888, 0, 7894, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7892, 0, 0, 0, 0,
    7891, 7889, 0, 7895, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7893, 0, 0, 0, 0,
    0, 0, 7896, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    0, 0, 7897, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    7900, 7898, 0, 7904, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7906, 0, 0, 0,
    0, 0, 7902, 0, 0, 0, 0,
    7901, 7899, 0, 7905, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7907, 0, 0, 0,
    0, 0, 7903, 0, 0, 0, 0,
    7914, 7912, 0, 7918, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7920, 0, 0, 0,
    0, 0, 7916, 0, 0, 0, 0,
    7915, 7913, 0, 7919, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7921, 0, 0, 0,
    0, 0, 7917, 0, 0, 0, 0,
    7938, 7940, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 7942, 8064,
    7939, 7941, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 7943, 8065,
    7946, 7948, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 7950, 8072,
    7947, 7949, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 7951, 8073,
    7954, 7956, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    7955, 7957, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    7962, 7964, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    7963, 7965, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    7970, 7972, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 7974, 8080,
    7971, 7973, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 7975, 8081,
    7978, 7980, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 7982, 8088,
    7979, 7981, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 7983, 8089,
    7986, 7988, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 7990, 0,
    7987, 7989, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 7991, 0,
    7994, 7996, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 7998, 0,
    7995, 7997, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 7999, 0,
    8002, 8004, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    8003, 8005, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    8010, 8012, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    8011, 8013, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
    8018, 8020, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8022, 0,
    8019, 8021, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8023, 0,
    8027, 8029, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8031, 0,
    8034, 8036, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8038, 8096,
    8035, 8037, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8039, 8097,
    8042, 8044, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8046, 8104,
    8043, 8045, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8047, 8105,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8066,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8067,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8068,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8069,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8070,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8071,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8074,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8075,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8076,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8077,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8078,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8079,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8082,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8083,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8084,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8085,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8086,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8087,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8090,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8091,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8092,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8093,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8094,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8095,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8098,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8099,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8100,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8101,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8102,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8103,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8106,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8107,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8108,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8109,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8110,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8111,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8114,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8116,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8119,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8130,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8132,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8135,
    8141, 8142, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8143, 0,
    8157, 8158, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 8159, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 8164, 8165, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 8172, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8178,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8180,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8183,
};

