/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.Constant;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.util.InstructionSequenceMatcher;
import proguard.evaluation.TracedStack;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.PartialEvaluator;

public class ArrayInitializationMatcher {
    private static final int X = 0x40000000;
    private final PartialEvaluator partialEvaluator;
    private int arrayInitializationStart;
    private int arrayInitializationEnd;
    private Object array;
    private final Constant[] CONSTANTS = new Constant[0];
    private final Instruction[] ARRAY_PRESTORE_INSTRUCTIONS = new Instruction[]{new VariableInstruction(58, 0x40000000), new VariableInstruction(25, 0x40000000)};
    private final InstructionSequenceMatcher arrayPreStoreMatcher = new InstructionSequenceMatcher(this.CONSTANTS, this.ARRAY_PRESTORE_INSTRUCTIONS);

    public ArrayInitializationMatcher() {
        this(new PartialEvaluator());
    }

    public ArrayInitializationMatcher(PartialEvaluator partialEvaluator) {
        this.partialEvaluator = partialEvaluator;
    }

    public boolean matchesArrayInitialization(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        this.array = null;
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(n);
        IntegerValue integerValue = tracedStack.getTop(0).integerValue();
        if (!integerValue.isParticular()) {
            return false;
        }
        int n2 = integerValue.value();
        int n3 = simpleInstruction.constant;
        byte by = this.arrayStoreOpcode(n3);
        byte[] byArray = codeAttribute.code;
        int n4 = n;
        Instruction instruction = simpleInstruction;
        int n5 = this.skipPreStoreInstructions(clazz, method, codeAttribute, n4 + instruction.length(n4));
        if (n5 > 0) {
            n = n4 = n5;
            instruction = InstructionFactory.create(byArray, n4);
        }
        int n6 = n4 + instruction.length(n4);
        for (int i = 0; i < n2; ++i) {
            if ((instruction = InstructionFactory.create(byArray, n4 += instruction.length(n4))).stackPushCount(clazz) < 1 || !this.partialEvaluator.getStackAfter(n4).getTopActualProducerValue(0).instructionOffsetValue().contains(n)) {
                return false;
            }
            if ((instruction = InstructionFactory.create(byArray, n4 += instruction.length(n4))).stackPushCount(clazz) != 1) {
                return false;
            }
            Value value = this.partialEvaluator.getStackAfter(n4).getTop(0);
            if (value.computationalType() != 1 || !value.integerValue().isParticular() || value.integerValue().value() != i) {
                return false;
            }
            if ((instruction = InstructionFactory.create(byArray, n4 += instruction.length(n4))).stackPushCount(clazz) < 1 || !this.partialEvaluator.getStackAfter(n4).getTop(0).isParticular()) {
                return false;
            }
            Value value2 = this.partialEvaluator.getStackAfter(n4).getTop(0);
            n4 += instruction.length(n4);
            instruction = InstructionFactory.create(byArray, n4);
            if (instruction.opcode != by) {
                return false;
            }
            if (i == 0) {
                this.array = this.newArray(n3, n2);
            }
            this.arrayStore(n3, this.array, i, value2);
        }
        this.arrayInitializationStart = n6;
        this.arrayInitializationEnd = n4;
        return n4 > n;
    }

    private int skipPreStoreInstructions(Clazz clazz, Method method, CodeAttribute codeAttribute, int n) {
        Instruction instruction;
        int n2 = this.arrayPreStoreMatcher.instructionCount();
        this.arrayPreStoreMatcher.reset();
        int n3 = 0;
        for (int i = n; n3 < n2 && i < codeAttribute.u4codeLength; i += instruction.length(i), ++n3) {
            instruction = InstructionFactory.create(codeAttribute.code, i);
            instruction.accept(clazz, method, codeAttribute, i, this.arrayPreStoreMatcher);
        }
        if (this.arrayPreStoreMatcher.isMatching()) {
            return this.arrayPreStoreMatcher.matchedInstructionOffset(n2 - 1);
        }
        return -1;
    }

    public int arrayInitializationStart() {
        return this.arrayInitializationStart;
    }

    public int arrayInitializationEnd() {
        return this.arrayInitializationEnd;
    }

    public Object array() {
        return this.array;
    }

    private byte internalType(int n) {
        switch (n) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return 1;
            }
            case 11: {
                return 2;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Unexpected new array type [" + n + "]");
    }

    private byte arrayStoreOpcode(int n) {
        switch (n) {
            case 4: 
            case 8: {
                return 84;
            }
            case 5: {
                return 85;
            }
            case 9: {
                return 86;
            }
            case 10: {
                return 79;
            }
            case 11: {
                return 80;
            }
            case 6: {
                return 81;
            }
            case 7: {
                return 82;
            }
        }
        throw new IllegalArgumentException("Unexpected new array type [" + n + "]");
    }

    private Object newArray(int n, int n2) {
        switch (n) {
            case 4: {
                return new boolean[n2];
            }
            case 8: {
                return new byte[n2];
            }
            case 5: {
                return new char[n2];
            }
            case 9: {
                return new short[n2];
            }
            case 10: {
                return new int[n2];
            }
            case 11: {
                return new long[n2];
            }
            case 6: {
                return new float[n2];
            }
            case 7: {
                return new double[n2];
            }
        }
        throw new IllegalArgumentException("Unexpected new array type [" + n + "]");
    }

    private void arrayStore(int n, Object object, int n2, Value value) {
        switch (n) {
            case 4: {
                ((boolean[])object)[n2] = 0 != value.integerValue().value();
                break;
            }
            case 8: {
                ((byte[])object)[n2] = (byte)value.integerValue().value();
                break;
            }
            case 5: {
                ((char[])object)[n2] = (char)value.integerValue().value();
                break;
            }
            case 9: {
                ((short[])object)[n2] = (short)value.integerValue().value();
                break;
            }
            case 10: {
                ((int[])object)[n2] = value.integerValue().value();
                break;
            }
            case 11: {
                ((long[])object)[n2] = value.longValue().value();
                break;
            }
            case 6: {
                ((float[])object)[n2] = value.floatValue().value();
                break;
            }
            case 7: {
                ((double[])object)[n2] = value.doubleValue().value();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected new array type [" + n + "]");
            }
        }
    }
}

