/***************************************************************************
 *   Copyright (C) 2005-2019 by Oleksandr Shneyder                         *
 *   o.shneyder@phoca-gmbh.de                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.              *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QApplication>
#include <QTranslator>
#include <QLocale>
#include <QFrame>
#include <mb.h>
#include <QDesktopWidget>

#if QT_VERSION < 0x050000
#include <QPlastiqueStyle>
#else
#include <QStyleFactory>
#endif

using namespace std;
int main(int argc, char *argv[])
{
  QApplication app(argc,argv);

#if QT_VERSION < 0x050000
  app.setStyle(new QPlastiqueStyle());
#else
  app.setStyle(QStyleFactory::create("fusion"));
#endif

// QFrame*fr =new QFrame(0,Qt::WindowStaysOnTopHint|Qt::X11BypassWindowManagerHint);
  MPushButton*fr =new MPushButton();
  fr->setFixedSize(24,12);
  fr->move(app.desktop()->screenGeometry().width()-24,app.desktop()->screenGeometry().height()-12);
  fr->show();
  return app.exec();
}
