/*
 * Decompiled with CFR 0.152.
 */
package rene.gui;

import java.awt.BorderLayout;
import java.awt.PopupMenu;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import rene.gui.CloseFrame;
import rene.gui.DoActionListener;
import rene.gui.Global;
import rene.gui.HistoryTextFieldChoice;
import rene.gui.MenuItemAction;
import rene.gui.TextFieldAction;
import rene.util.FileName;
import rene.util.list.ListClass;
import rene.util.list.ListElement;

public class HistoryTextField
extends TextFieldAction
implements KeyListener,
DoActionListener {
    ListClass H = new ListClass();
    PopupMenu M = null;
    boolean Trigger = false;
    public int MaxLength = 48;
    String Last = "";

    public HistoryTextField(DoActionListener doActionListener, String string) {
        super(doActionListener, string);
        this.H.append(new ListElement(""));
        this.addKeyListener(this);
    }

    public HistoryTextField(DoActionListener doActionListener, String string, int n) {
        super(doActionListener, string, n);
        this.H.append(new ListElement(""));
        this.addKeyListener(this);
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 38: 
            case 40: {
                if (this.M == null) {
                    this.M = new PopupMenu();
                    ListElement listElement = this.H.last();
                    int n = Global.getParameter("history.length", 10);
                    for (int n2 = 0; listElement != null && n2 < n; listElement = listElement.previous(), ++n2) {
                        String string = (String)listElement.content();
                        if (string.equals("")) continue;
                        MenuItemAction menuItemAction = new MenuItemAction(this, FileName.chop(string, this.MaxLength), string);
                        this.M.add(menuItemAction);
                    }
                    this.add(this.M);
                }
                this.M.show(this, 10, 10);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void remember(String string) {
        if (string.equals(this.Last)) {
            return;
        }
        this.deleteFromHistory(string);
        this.Last = string;
        this.H.last().content(string);
        this.H.append(new ListElement(""));
        this.M = null;
    }

    public void deleteFromHistory(String string) {
        ListElement listElement = this.H.first();
        while (listElement != null) {
            String string2 = (String)listElement.content();
            ListElement listElement2 = listElement.next();
            if (string2.equals(string)) {
                this.H.remove(listElement);
                if (this.H.first() == null) {
                    this.H.append(new ListElement(""));
                }
            }
            listElement = listElement2;
        }
    }

    public void remember() {
        this.remember(this.getText());
    }

    public void saveHistory(String string) {
        ListElement listElement;
        int n = Global.getParameter("history.length", 10);
        Global.removeAllParameters("history." + string);
        if (listElement == null) {
            return;
        }
        int n2 = 0;
        for (listElement = this.H.last(); n2 < n && listElement != null; listElement = listElement.previous()) {
            String string2 = (String)listElement.content();
            if (string2.equals("")) continue;
            Global.setParameter("history." + string + "." + ++n2, string2);
        }
    }

    public void loadHistory(String string) {
        int n = 1;
        this.H = new ListClass();
        this.H.append(new ListElement(""));
        while (Global.haveParameter("history." + string + "." + n)) {
            String string2 = Global.getParameter("history." + string + "." + n, "");
            if (!string2.equals("") && this.filterHistory(string2)) {
                this.H.prepend(new ListElement(string2));
            }
            ++n;
        }
    }

    public boolean filterHistory(String string) {
        return true;
    }

    public ListClass getHistory() {
        return this.H;
    }

    public void setTrigger(boolean bl) {
        this.Trigger = bl;
    }

    public void doAction(String string) {
        if (!string.equals("")) {
            this.setText(string);
            if (this.Trigger) {
                this.triggerAction();
            }
        }
    }

    public void itemAction(String string, boolean bl) {
    }

    public static void main(String[] stringArray) {
        CloseFrame closeFrame = new CloseFrame("test");
        HistoryTextField historyTextField = new HistoryTextField((DoActionListener)closeFrame, "Test", 30);
        historyTextField.remember("AAAA");
        historyTextField.remember("BBBB");
        historyTextField.remember("CCCC");
        historyTextField.remember("DDDD");
        closeFrame.setLayout(new BorderLayout());
        closeFrame.add("Center", historyTextField);
        closeFrame.add("South", new HistoryTextFieldChoice(historyTextField));
        closeFrame.pack();
        closeFrame.setVisible(true);
    }
}

