/*
 * Copyright (C) 2021 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include <WebCore/PageIdentifier.h>
#include <WebCore/PasteboardContext.h>
#include <wtf/TZoneMallocInlines.h>
#include <wtf/TypeCasts.h>

namespace WebCore {

class PagePasteboardContext final : public PasteboardContext {
    WTF_MAKE_TZONE_ALLOCATED_INLINE(PagePasteboardContext);
public:
    PagePasteboardContext(std::optional<PageIdentifier>&& pageID = std::nullopt)
        : PasteboardContext()
        , m_pageID(WTF::move(pageID))
    {
    }

    ~PagePasteboardContext() { }

    static std::unique_ptr<PasteboardContext> create(std::optional<PageIdentifier>&& pageID = std::nullopt)
    {
        return makeUnique<PagePasteboardContext>(WTF::move(pageID));
    }

    std::optional<PageIdentifier> pageID() const { return m_pageID; }
    bool isPagePasteboardContext() const override { return true; }

private:
    std::optional<PageIdentifier> m_pageID;
};

} // namespace WebCore

SPECIALIZE_TYPE_TRAITS_BEGIN(WebCore::PagePasteboardContext)
    static bool isType(const WebCore::PasteboardContext& context) { return context.isPagePasteboardContext(); }
SPECIALIZE_TYPE_TRAITS_END()

