// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SQDMLSL_D_TRACE_AARCH64_H_
#define VIXL_SIM_SQDMLSL_D_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_sqdmlsl_D[] = {
  0xffffffff83f80000, 0x0000000000000000,
  0xffffffff82fc0000, 0x0000000000000000,
  0xffffff8202f40000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff0400, 0x0000000000000000,
  0xfffffffffffe0800, 0x0000000000000000,
  0xffffffffffe08000, 0x0000000000000000,
  0xffffffffff84f400, 0x0000000000000000,
  0xffffffffff83f800, 0x0000000000000000,
  0xffffffffff82fc00, 0x0000000000000000,
  0xffffffff8202f400, 0x0000000000000000,
  0xffffffff8201f800, 0x0000000000000000,
  0xffffffff8200fc00, 0x0000000000000000,
  0xffffcd999999cc00, 0x0000000000000000,
  0xffffac0000005400, 0x0000000000000000,
  0xffff82000002f400, 0x0000000000000000,
  0xffff82000001f800, 0x0000000000000000,
  0xffff82000000fc00, 0x0000000000000000,
  0x00007e0000000000, 0x0000000000000000,
  0x00007dffffff0400, 0x0000000000000000,
  0x000054000000a800, 0x0000000000000000,
  0x0000326666673000, 0x0000000000000000,
  0x000000007e000000, 0x0000000000000000,
  0x000000007dff0400, 0x0000000000000000,
  0x000000007dfe0800, 0x0000000000000000,
  0x000000007dfd0c00, 0x0000000000000000,
  0x00000000007e0000, 0x0000000000000000,
  0x00000000007d0400, 0x0000000000000000,
  0x00000000007c0800, 0x0000000000000000,
  0x00000000007b0c00, 0x0000000000000000,
  0x00000000001f8000, 0x0000000000000000,
  0x000000000002fa00, 0x0000000000000000,
  0x000000000001fc00, 0x0000000000000000,
  0x000000000000fe00, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff0200, 0x0000000000000000,
  0xfffffffffffe0400, 0x0000000000000000,
  0xffffffffffe04000, 0x0000000000000000,
  0xffffffffff83fa00, 0x0000000000000000,
  0xffffffffff82fc00, 0x0000000000000000,
  0xffffffffff81fe00, 0x0000000000000000,
  0xffffffff8102fa00, 0x0000000000000000,
  0xffffffff8101fc00, 0x0000000000000000,
  0xffffffff8100fe00, 0x0000000000000000,
  0xffffcd3333336600, 0x0000000000000000,
  0xffffab555555aa00, 0x0000000000000000,
  0xffff81000002fa00, 0x0000000000000000,
  0xffff81000001fc00, 0x0000000000000000,
  0xffff81000000fe00, 0x0000000000000000,
  0x00007f0000000000, 0x0000000000000000,
  0x00007effffff0200, 0x0000000000000000,
  0x000054aaaaab5400, 0x0000000000000000,
  0x000032cccccd9800, 0x0000000000000000,
  0x000000007f000000, 0x0000000000000000,
  0x000000007eff0200, 0x0000000000000000,
  0x000000007efe0400, 0x0000000000000000,
  0x000000007efd0600, 0x0000000000000000,
  0x00000000007f0000, 0x0000000000000000,
  0x00000000007e0200, 0x0000000000000000,
  0x00000000007d0400, 0x0000000000000000,
  0x00000000007c0600, 0x0000000000000000,
  0x00000000001fc000, 0x0000000000000000,
  0x0000000002ffee00, 0x0000000000000000,
  0x0000000001fff400, 0x0000000000000000,
  0x0000000000fffa00, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffff000600, 0x0000000000000000,
  0xfffffffffe000c00, 0x0000000000000000,
  0xffffffffe000c000, 0x0000000000000000,
  0xffffffff8302ee00, 0x0000000000000000,
  0xffffffff8202f400, 0x0000000000000000,
  0xffffffff8102fa00, 0x0000000000000000,
  0xffffff8005ffee00, 0x0000000000000000,
  0xffffff8004fff400, 0x0000000000000000,
  0xffffff8003fffa00, 0x0000000000000000,
  0xffccce0000333200, 0x0000000000000000,
  0xffaaacaaaafffe00, 0x0000000000000000,
  0xff80030002ffee00, 0x0000000000000000,
  0xff80030001fff400, 0x0000000000000000,
  0xff80030000fffa00, 0x0000000000000000,
  0x007ffd0000000000, 0x0000000000000000,
  0x007ffcffff000600, 0x0000000000000000,
  0x0055535555fffc00, 0x0000000000000000,
  0x0033320000ccc800, 0x0000000000000000,
  0x0000007ffd000000, 0x0000000000000000,
  0x0000007ffc000600, 0x0000000000000000,
  0x0000007ffb000c00, 0x0000000000000000,
  0x0000007ffa001200, 0x0000000000000000,
  0x000000007ffd0000, 0x0000000000000000,
  0x000000007efd0600, 0x0000000000000000,
  0x000000007dfd0c00, 0x0000000000000000,
  0x000000007cfd1200, 0x0000000000000000,
  0x000000001fff4000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000006, 0x0000000000000000,
  0x0000000000000004, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xfffffffffffffffc, 0x0000000000000000,
  0xffffffffffffffc0, 0x0000000000000000,
  0xffffffffffffff06, 0x0000000000000000,
  0xffffffffffffff04, 0x0000000000000000,
  0xffffffffffffff02, 0x0000000000000000,
  0xffffffffffff0006, 0x0000000000000000,
  0xffffffffffff0004, 0x0000000000000000,
  0xffffffffffff0002, 0x0000000000000000,
  0xffffffff9999999a, 0x0000000000000000,
  0xffffffff55555556, 0x0000000000000000,
  0xffffffff00000006, 0x0000000000000000,
  0xffffffff00000004, 0x0000000000000000,
  0xffffffff00000002, 0x0000000000000000,
  0x0000000100000000, 0x0000000000000000,
  0x00000000fffffffe, 0x0000000000000000,
  0x00000000aaaaaaac, 0x0000000000000000,
  0x0000000066666668, 0x0000000000000000,
  0x0000000000010000, 0x0000000000000000,
  0x000000000000fffe, 0x0000000000000000,
  0x000000000000fffc, 0x0000000000000000,
  0x000000000000fffa, 0x0000000000000000,
  0x0000000000000100, 0x0000000000000000,
  0x00000000000000fe, 0x0000000000000000,
  0x00000000000000fc, 0x0000000000000000,
  0x00000000000000fa, 0x0000000000000000,
  0x0000000000000040, 0x0000000000000000,
  0x000000000000000c, 0x0000000000000000,
  0x0000000000000008, 0x0000000000000000,
  0x0000000000000004, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xfffffffffffffffc, 0x0000000000000000,
  0xfffffffffffffff8, 0x0000000000000000,
  0xffffffffffffff80, 0x0000000000000000,
  0xfffffffffffffe0c, 0x0000000000000000,
  0xfffffffffffffe08, 0x0000000000000000,
  0xfffffffffffffe04, 0x0000000000000000,
  0xfffffffffffe000c, 0x0000000000000000,
  0xfffffffffffe0008, 0x0000000000000000,
  0xfffffffffffe0004, 0x0000000000000000,
  0xffffffff33333334, 0x0000000000000000,
  0xfffffffeaaaaaaac, 0x0000000000000000,
  0xfffffffe0000000c, 0x0000000000000000,
  0xfffffffe00000008, 0x0000000000000000,
  0xfffffffe00000004, 0x0000000000000000,
  0x0000000200000000, 0x0000000000000000,
  0x00000001fffffffc, 0x0000000000000000,
  0x0000000155555558, 0x0000000000000000,
  0x00000000ccccccd0, 0x0000000000000000,
  0x0000000000020000, 0x0000000000000000,
  0x000000000001fffc, 0x0000000000000000,
  0x000000000001fff8, 0x0000000000000000,
  0x000000000001fff4, 0x0000000000000000,
  0x0000000000000200, 0x0000000000000000,
  0x00000000000001fc, 0x0000000000000000,
  0x00000000000001f8, 0x0000000000000000,
  0x00000000000001f4, 0x0000000000000000,
  0x0000000000000080, 0x0000000000000000,
  0x00000000000000c0, 0x0000000000000000,
  0x0000000000000080, 0x0000000000000000,
  0x0000000000000040, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffc0, 0x0000000000000000,
  0xffffffffffffff80, 0x0000000000000000,
  0xfffffffffffff800, 0x0000000000000000,
  0xffffffffffffe0c0, 0x0000000000000000,
  0xffffffffffffe080, 0x0000000000000000,
  0xffffffffffffe040, 0x0000000000000000,
  0xffffffffffe000c0, 0x0000000000000000,
  0xffffffffffe00080, 0x0000000000000000,
  0xffffffffffe00040, 0x0000000000000000,
  0xfffffff333333340, 0x0000000000000000,
  0xffffffeaaaaaaac0, 0x0000000000000000,
  0xffffffe0000000c0, 0x0000000000000000,
  0xffffffe000000080, 0x0000000000000000,
  0xffffffe000000040, 0x0000000000000000,
  0x0000002000000000, 0x0000000000000000,
  0x0000001fffffffc0, 0x0000000000000000,
  0x0000001555555580, 0x0000000000000000,
  0x0000000ccccccd00, 0x0000000000000000,
  0x0000000000200000, 0x0000000000000000,
  0x00000000001fffc0, 0x0000000000000000,
  0x00000000001fff80, 0x0000000000000000,
  0x00000000001fff40, 0x0000000000000000,
  0x0000000000002000, 0x0000000000000000,
  0x0000000000001fc0, 0x0000000000000000,
  0x0000000000001f80, 0x0000000000000000,
  0x0000000000001f40, 0x0000000000000000,
  0x0000000000000800, 0x0000000000000000,
  0x00000000000002ee, 0x0000000000000000,
  0x00000000000001f4, 0x0000000000000000,
  0x00000000000000fa, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffff06, 0x0000000000000000,
  0xfffffffffffffe0c, 0x0000000000000000,
  0xffffffffffffe0c0, 0x0000000000000000,
  0xffffffffffff85ee, 0x0000000000000000,
  0xffffffffffff84f4, 0x0000000000000000,
  0xffffffffffff83fa, 0x0000000000000000,
  0xffffffffff8302ee, 0x0000000000000000,
  0xffffffffff8301f4, 0x0000000000000000,
  0xffffffffff8300fa, 0x0000000000000000,
  0xffffffce00000032, 0x0000000000000000,
  0xffffffacaaaaaafe, 0x0000000000000000,
  0xffffff83000002ee, 0x0000000000000000,
  0xffffff83000001f4, 0x0000000000000000,
  0xffffff83000000fa, 0x0000000000000000,
  0x0000007d00000000, 0x0000000000000000,
  0x0000007cffffff06, 0x0000000000000000,
  0x00000053555555fc, 0x0000000000000000,
  0x00000032000000c8, 0x0000000000000000,
  0x00000000007d0000, 0x0000000000000000,
  0x00000000007cff06, 0x0000000000000000,
  0x00000000007cfe0c, 0x0000000000000000,
  0x00000000007cfd12, 0x0000000000000000,
  0x0000000000007d00, 0x0000000000000000,
  0x0000000000007c06, 0x0000000000000000,
  0x0000000000007b0c, 0x0000000000000000,
  0x0000000000007a12, 0x0000000000000000,
  0x0000000000001f40, 0x0000000000000000,
  0x00000000000002f4, 0x0000000000000000,
  0x00000000000001f8, 0x0000000000000000,
  0x00000000000000fc, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffff04, 0x0000000000000000,
  0xfffffffffffffe08, 0x0000000000000000,
  0xffffffffffffe080, 0x0000000000000000,
  0xffffffffffff84f4, 0x0000000000000000,
  0xffffffffffff83f8, 0x0000000000000000,
  0xffffffffffff82fc, 0x0000000000000000,
  0xffffffffff8202f4, 0x0000000000000000,
  0xffffffffff8201f8, 0x0000000000000000,
  0xffffffffff8200fc, 0x0000000000000000,
  0xffffffcd999999cc, 0x0000000000000000,
  0xffffffac00000054, 0x0000000000000000,
  0xffffff82000002f4, 0x0000000000000000,
  0xffffff82000001f8, 0x0000000000000000,
  0xffffff82000000fc, 0x0000000000000000,
  0x0000007e00000000, 0x0000000000000000,
  0x0000007dffffff04, 0x0000000000000000,
  0x00000054000000a8, 0x0000000000000000,
  0x0000003266666730, 0x0000000000000000,
  0x00000000007e0000, 0x0000000000000000,
  0x00000000007dff04, 0x0000000000000000,
  0x00000000007dfe08, 0x0000000000000000,
  0x00000000007dfd0c, 0x0000000000000000,
  0x0000000000007e00, 0x0000000000000000,
  0x0000000000007d04, 0x0000000000000000,
  0x0000000000007c08, 0x0000000000000000,
  0x0000000000007b0c, 0x0000000000000000,
  0x0000000000001f80, 0x0000000000000000,
  0x00000000000002fa, 0x0000000000000000,
  0x00000000000001fc, 0x0000000000000000,
  0x00000000000000fe, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffff02, 0x0000000000000000,
  0xfffffffffffffe04, 0x0000000000000000,
  0xffffffffffffe040, 0x0000000000000000,
  0xffffffffffff83fa, 0x0000000000000000,
  0xffffffffffff82fc, 0x0000000000000000,
  0xffffffffffff81fe, 0x0000000000000000,
  0xffffffffff8102fa, 0x0000000000000000,
  0xffffffffff8101fc, 0x0000000000000000,
  0xffffffffff8100fe, 0x0000000000000000,
  0xffffffcd33333366, 0x0000000000000000,
  0xffffffab555555aa, 0x0000000000000000,
  0xffffff81000002fa, 0x0000000000000000,
  0xffffff81000001fc, 0x0000000000000000,
  0xffffff81000000fe, 0x0000000000000000,
  0x0000007f00000000, 0x0000000000000000,
  0x0000007effffff02, 0x0000000000000000,
  0x00000054aaaaab54, 0x0000000000000000,
  0x00000032cccccd98, 0x0000000000000000,
  0x00000000007f0000, 0x0000000000000000,
  0x00000000007eff02, 0x0000000000000000,
  0x00000000007efe04, 0x0000000000000000,
  0x00000000007efd06, 0x0000000000000000,
  0x0000000000007f00, 0x0000000000000000,
  0x0000000000007e02, 0x0000000000000000,
  0x0000000000007d04, 0x0000000000000000,
  0x0000000000007c06, 0x0000000000000000,
  0x0000000000001fc0, 0x0000000000000000,
  0x000000000002ffee, 0x0000000000000000,
  0x000000000001fff4, 0x0000000000000000,
  0x000000000000fffa, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff0006, 0x0000000000000000,
  0xfffffffffffe000c, 0x0000000000000000,
  0xffffffffffe000c0, 0x0000000000000000,
  0xffffffffff8302ee, 0x0000000000000000,
  0xffffffffff8202f4, 0x0000000000000000,
  0xffffffffff8102fa, 0x0000000000000000,
  0xffffffff8005ffee, 0x0000000000000000,
  0xffffffff8004fff4, 0x0000000000000000,
  0xffffffff8003fffa, 0x0000000000000000,
  0xffffccce00003332, 0x0000000000000000,
  0xffffaaacaaaafffe, 0x0000000000000000,
  0xffff80030002ffee, 0x0000000000000000,
  0xffff80030001fff4, 0x0000000000000000,
  0xffff80030000fffa, 0x0000000000000000,
  0x00007ffd00000000, 0x0000000000000000,
  0x00007ffcffff0006, 0x0000000000000000,
  0x000055535555fffc, 0x0000000000000000,
  0x000033320000ccc8, 0x0000000000000000,
  0x000000007ffd0000, 0x0000000000000000,
  0x000000007ffc0006, 0x0000000000000000,
  0x000000007ffb000c, 0x0000000000000000,
  0x000000007ffa0012, 0x0000000000000000,
  0x00000000007ffd00, 0x0000000000000000,
  0x00000000007efd06, 0x0000000000000000,
  0x00000000007dfd0c, 0x0000000000000000,
  0x00000000007cfd12, 0x0000000000000000,
  0x00000000001fff40, 0x0000000000000000,
  0x000000000002fff4, 0x0000000000000000,
  0x000000000001fff8, 0x0000000000000000,
  0x000000000000fffc, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff0004, 0x0000000000000000,
  0xfffffffffffe0008, 0x0000000000000000,
  0xffffffffffe00080, 0x0000000000000000,
  0xffffffffff8301f4, 0x0000000000000000,
  0xffffffffff8201f8, 0x0000000000000000,
  0xffffffffff8101fc, 0x0000000000000000,
  0xffffffff8004fff4, 0x0000000000000000,
  0xffffffff8003fff8, 0x0000000000000000,
  0xffffffff8002fffc, 0x0000000000000000,
  0xffffcccd9999cccc, 0x0000000000000000,
  0xffffaaac00005554, 0x0000000000000000,
  0xffff80020002fff4, 0x0000000000000000,
  0xffff80020001fff8, 0x0000000000000000,
  0xffff80020000fffc, 0x0000000000000000,
  0x00007ffe00000000, 0x0000000000000000,
  0x00007ffdffff0004, 0x0000000000000000,
  0x000055540000aaa8, 0x0000000000000000,
  0x0000333266673330, 0x0000000000000000,
  0x000000007ffe0000, 0x0000000000000000,
  0x000000007ffd0004, 0x0000000000000000,
  0x000000007ffc0008, 0x0000000000000000,
  0x000000007ffb000c, 0x0000000000000000,
  0x00000000007ffe00, 0x0000000000000000,
  0x00000000007efe04, 0x0000000000000000,
  0x00000000007dfe08, 0x0000000000000000,
  0x00000000007cfe0c, 0x0000000000000000,
  0x00000000001fff80, 0x0000000000000000,
  0x000000000002fffa, 0x0000000000000000,
  0x000000000001fffc, 0x0000000000000000,
  0x000000000000fffe, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff0002, 0x0000000000000000,
  0xfffffffffffe0004, 0x0000000000000000,
  0xffffffffffe00040, 0x0000000000000000,
  0xffffffffff8300fa, 0x0000000000000000,
  0xffffffffff8200fc, 0x0000000000000000,
  0xffffffffff8100fe, 0x0000000000000000,
  0xffffffff8003fffa, 0x0000000000000000,
  0xffffffff8002fffc, 0x0000000000000000,
  0xffffffff8001fffe, 0x0000000000000000,
  0xffffcccd33336666, 0x0000000000000000,
  0xffffaaab5555aaaa, 0x0000000000000000,
  0xffff80010002fffa, 0x0000000000000000,
  0xffff80010001fffc, 0x0000000000000000,
  0xffff80010000fffe, 0x0000000000000000,
  0x00007fff00000000, 0x0000000000000000,
  0x00007ffeffff0002, 0x0000000000000000,
  0x00005554aaab5554, 0x0000000000000000,
  0x00003332cccd9998, 0x0000000000000000,
  0x000000007fff0000, 0x0000000000000000,
  0x000000007ffe0002, 0x0000000000000000,
  0x000000007ffd0004, 0x0000000000000000,
  0x000000007ffc0006, 0x0000000000000000,
  0x00000000007fff00, 0x0000000000000000,
  0x00000000007eff02, 0x0000000000000000,
  0x00000000007dff04, 0x0000000000000000,
  0x00000000007cff06, 0x0000000000000000,
  0x00000000001fffc0, 0x0000000000000000,
  0x0000000133333332, 0x0000000000000000,
  0x00000000cccccccc, 0x0000000000000000,
  0x0000000066666666, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffff9999999a, 0x0000000000000000,
  0xffffffff33333334, 0x0000000000000000,
  0xfffffff333333340, 0x0000000000000000,
  0xffffffce00000032, 0x0000000000000000,
  0xffffffcd999999cc, 0x0000000000000000,
  0xffffffcd33333366, 0x0000000000000000,
  0xffffccce00003332, 0x0000000000000000,
  0xffffcccd9999cccc, 0x0000000000000000,
  0xffffcccd33336666, 0x0000000000000000,
  0xeb851eb87ae147ae, 0x0000000000000000,
  0xddddddde22222222, 0x0000000000000000,
  0xccccccce33333332, 0x0000000000000000,
  0xcccccccdcccccccc, 0x0000000000000000,
  0xcccccccd66666666, 0x0000000000000000,
  0x3333333300000000, 0x0000000000000000,
  0x333333329999999a, 0x0000000000000000,
  0x2222222244444444, 0x0000000000000000,
  0x147ae147eb851eb8, 0x0000000000000000,
  0x0000333333330000, 0x0000000000000000,
  0x00003332cccc999a, 0x0000000000000000,
  0x0000333266663334, 0x0000000000000000,
  0x00003331ffffccce, 0x0000000000000000,
  0x0000003333333300, 0x0000000000000000,
  0x00000032cccccc9a, 0x0000000000000000,
  0x0000003266666634, 0x0000000000000000,
  0x00000031ffffffce, 0x0000000000000000,
  0x0000000cccccccc0, 0x0000000000000000,
  0x00000001fffffffe, 0x0000000000000000,
  0x0000000155555554, 0x0000000000000000,
  0x00000000aaaaaaaa, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffff55555556, 0x0000000000000000,
  0xfffffffeaaaaaaac, 0x0000000000000000,
  0xffffffeaaaaaaac0, 0x0000000000000000,
  0xffffffacaaaaaafe, 0x0000000000000000,
  0xffffffac00000054, 0x0000000000000000,
  0xffffffab555555aa, 0x0000000000000000,
  0xffffaaacaaaafffe, 0x0000000000000000,
  0xffffaaac00005554, 0x0000000000000000,
  0xffffaaab5555aaaa, 0x0000000000000000,
  0xddddddde22222222, 0x0000000000000000,
  0xc71c71c78e38e38e, 0x0000000000000000,
  0xaaaaaaacfffffffe, 0x0000000000000000,
  0xaaaaaaac55555554, 0x0000000000000000,
  0xaaaaaaabaaaaaaaa, 0x0000000000000000,
  0x5555555500000000, 0x0000000000000000,
  0x5555555455555556, 0x0000000000000000,
  0x38e38e391c71c71c, 0x0000000000000000,
  0x2222222288888888, 0x0000000000000000,
  0x0000555555550000, 0x0000000000000000,
  0x00005554aaaa5556, 0x0000000000000000,
  0x00005553ffffaaac, 0x0000000000000000,
  0x0000555355550002, 0x0000000000000000,
  0x0000005555555500, 0x0000000000000000,
  0x00000054aaaaaa56, 0x0000000000000000,
  0x00000053ffffffac, 0x0000000000000000,
  0x0000005355555502, 0x0000000000000000,
  0x0000001555555540, 0x0000000000000000,
  0x00000002ffffffee, 0x0000000000000000,
  0x00000001fffffff4, 0x0000000000000000,
  0x00000000fffffffa, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffff00000006, 0x0000000000000000,
  0xfffffffe0000000c, 0x0000000000000000,
  0xffffffe0000000c0, 0x0000000000000000,
  0xffffff83000002ee, 0x0000000000000000,
  0xffffff82000002f4, 0x0000000000000000,
  0xffffff81000002fa, 0x0000000000000000,
  0xffff80030002ffee, 0x0000000000000000,
  0xffff80020002fff4, 0x0000000000000000,
  0xffff80010002fffa, 0x0000000000000000,
  0xccccccce33333332, 0x0000000000000000,
  0xaaaaaaacfffffffe, 0x0000000000000000,
  0x80000005ffffffee, 0x0000000000000000,
  0x80000004fffffff4, 0x0000000000000000,
  0x80000003fffffffa, 0x0000000000000000,
  0x7ffffffd00000000, 0x0000000000000000,
  0x7ffffffc00000006, 0x0000000000000000,
  0x55555553fffffffc, 0x0000000000000000,
  0x33333332ccccccc8, 0x0000000000000000,
  0x00007ffffffd0000, 0x0000000000000000,
  0x00007ffefffd0006, 0x0000000000000000,
  0x00007ffdfffd000c, 0x0000000000000000,
  0x00007ffcfffd0012, 0x0000000000000000,
  0x0000007ffffffd00, 0x0000000000000000,
  0x0000007efffffd06, 0x0000000000000000,
  0x0000007dfffffd0c, 0x0000000000000000,
  0x0000007cfffffd12, 0x0000000000000000,
  0x0000001fffffff40, 0x0000000000000000,
  0x00000002fffffff4, 0x0000000000000000,
  0x00000001fffffff8, 0x0000000000000000,
  0x00000000fffffffc, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffff00000004, 0x0000000000000000,
  0xfffffffe00000008, 0x0000000000000000,
  0xffffffe000000080, 0x0000000000000000,
  0xffffff83000001f4, 0x0000000000000000,
  0xffffff82000001f8, 0x0000000000000000,
  0xffffff81000001fc, 0x0000000000000000,
  0xffff80030001fff4, 0x0000000000000000,
  0xffff80020001fff8, 0x0000000000000000,
  0xffff80010001fffc, 0x0000000000000000,
  0xcccccccdcccccccc, 0x0000000000000000,
  0xaaaaaaac55555554, 0x0000000000000000,
  0x80000004fffffff4, 0x0000000000000000,
  0x80000003fffffff8, 0x0000000000000000,
  0x80000002fffffffc, 0x0000000000000000,
  0x7ffffffe00000000, 0x0000000000000000,
  0x7ffffffd00000004, 0x0000000000000000,
  0x55555554aaaaaaa8, 0x0000000000000000,
  0x3333333333333330, 0x0000000000000000,
  0x00007ffffffe0000, 0x0000000000000000,
  0x00007ffefffe0004, 0x0000000000000000,
  0x00007ffdfffe0008, 0x0000000000000000,
  0x00007ffcfffe000c, 0x0000000000000000,
  0x0000007ffffffe00, 0x0000000000000000,
  0x0000007efffffe04, 0x0000000000000000,
  0x0000007dfffffe08, 0x0000000000000000,
  0x0000007cfffffe0c, 0x0000000000000000,
  0x0000001fffffff80, 0x0000000000000000,
  0x00000002fffffffa, 0x0000000000000000,
  0x00000001fffffffc, 0x0000000000000000,
  0x00000000fffffffe, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffff00000002, 0x0000000000000000,
  0xfffffffe00000004, 0x0000000000000000,
  0xffffffe000000040, 0x0000000000000000,
  0xffffff83000000fa, 0x0000000000000000,
  0xffffff82000000fc, 0x0000000000000000,
  0xffffff81000000fe, 0x0000000000000000,
  0xffff80030000fffa, 0x0000000000000000,
  0xffff80020000fffc, 0x0000000000000000,
  0xffff80010000fffe, 0x0000000000000000,
  0xcccccccd66666666, 0x0000000000000000,
  0xaaaaaaabaaaaaaaa, 0x0000000000000000,
  0x80000003fffffffa, 0x0000000000000000,
  0x80000002fffffffc, 0x0000000000000000,
  0x80000001fffffffe, 0x0000000000000000,
  0x7fffffff00000000, 0x0000000000000000,
  0x7ffffffe00000002, 0x0000000000000000,
  0x5555555555555554, 0x0000000000000000,
  0x3333333399999998, 0x0000000000000000,
  0x00007fffffff0000, 0x0000000000000000,
  0x00007ffeffff0002, 0x0000000000000000,
  0x00007ffdffff0004, 0x0000000000000000,
  0x00007ffcffff0006, 0x0000000000000000,
  0x0000007fffffff00, 0x0000000000000000,
  0x0000007effffff02, 0x0000000000000000,
  0x0000007dffffff04, 0x0000000000000000,
  0x0000007cffffff06, 0x0000000000000000,
  0x0000001fffffffc0, 0x0000000000000000,
  0xfffffffd00000000, 0x0000000000000000,
  0xfffffffe00000000, 0x0000000000000000,
  0xffffffff00000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000100000000, 0x0000000000000000,
  0x0000000200000000, 0x0000000000000000,
  0x0000002000000000, 0x0000000000000000,
  0x0000007d00000000, 0x0000000000000000,
  0x0000007e00000000, 0x0000000000000000,
  0x0000007f00000000, 0x0000000000000000,
  0x00007ffd00000000, 0x0000000000000000,
  0x00007ffe00000000, 0x0000000000000000,
  0x00007fff00000000, 0x0000000000000000,
  0x3333333300000000, 0x0000000000000000,
  0x5555555500000000, 0x0000000000000000,
  0x7ffffffd00000000, 0x0000000000000000,
  0x7ffffffe00000000, 0x0000000000000000,
  0x7fffffff00000000, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0x8000000100000000, 0x0000000000000000,
  0xaaaaaaaa00000000, 0x0000000000000000,
  0xcccccccc00000000, 0x0000000000000000,
  0xffff800000000000, 0x0000000000000000,
  0xffff800100000000, 0x0000000000000000,
  0xffff800200000000, 0x0000000000000000,
  0xffff800300000000, 0x0000000000000000,
  0xffffff8000000000, 0x0000000000000000,
  0xffffff8100000000, 0x0000000000000000,
  0xffffff8200000000, 0x0000000000000000,
  0xffffff8300000000, 0x0000000000000000,
  0xffffffe000000000, 0x0000000000000000,
  0xfffffffd00000006, 0x0000000000000000,
  0xfffffffe00000004, 0x0000000000000000,
  0xffffffff00000002, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x00000000fffffffe, 0x0000000000000000,
  0x00000001fffffffc, 0x0000000000000000,
  0x0000001fffffffc0, 0x0000000000000000,
  0x0000007cffffff06, 0x0000000000000000,
  0x0000007dffffff04, 0x0000000000000000,
  0x0000007effffff02, 0x0000000000000000,
  0x00007ffcffff0006, 0x0000000000000000,
  0x00007ffdffff0004, 0x0000000000000000,
  0x00007ffeffff0002, 0x0000000000000000,
  0x333333329999999a, 0x0000000000000000,
  0x5555555455555556, 0x0000000000000000,
  0x7ffffffc00000006, 0x0000000000000000,
  0x7ffffffd00000004, 0x0000000000000000,
  0x7ffffffe00000002, 0x0000000000000000,
  0x8000000100000000, 0x0000000000000000,
  0x80000001fffffffe, 0x0000000000000000,
  0xaaaaaaaaaaaaaaac, 0x0000000000000000,
  0xcccccccc66666668, 0x0000000000000000,
  0xffff800000010000, 0x0000000000000000,
  0xffff80010000fffe, 0x0000000000000000,
  0xffff80020000fffc, 0x0000000000000000,
  0xffff80030000fffa, 0x0000000000000000,
  0xffffff8000000100, 0x0000000000000000,
  0xffffff81000000fe, 0x0000000000000000,
  0xffffff82000000fc, 0x0000000000000000,
  0xffffff83000000fa, 0x0000000000000000,
  0xffffffe000000040, 0x0000000000000000,
  0xfffffffdfffffffc, 0x0000000000000000,
  0xfffffffeaaaaaaa8, 0x0000000000000000,
  0xffffffff55555554, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x00000000aaaaaaac, 0x0000000000000000,
  0x0000000155555558, 0x0000000000000000,
  0x0000001555555580, 0x0000000000000000,
  0x00000053555555fc, 0x0000000000000000,
  0x00000054000000a8, 0x0000000000000000,
  0x00000054aaaaab54, 0x0000000000000000,
  0x000055535555fffc, 0x0000000000000000,
  0x000055540000aaa8, 0x0000000000000000,
  0x00005554aaab5554, 0x0000000000000000,
  0x2222222244444444, 0x0000000000000000,
  0x38e38e391c71c71c, 0x0000000000000000,
  0x55555553fffffffc, 0x0000000000000000,
  0x55555554aaaaaaa8, 0x0000000000000000,
  0x5555555555555554, 0x0000000000000000,
  0xaaaaaaaa00000000, 0x0000000000000000,
  0xaaaaaaaaaaaaaaac, 0x0000000000000000,
  0xc71c71c638e38e38, 0x0000000000000000,
  0xdddddddd11111110, 0x0000000000000000,
  0xffffaaaaaaaa0000, 0x0000000000000000,
  0xffffaaab5554aaac, 0x0000000000000000,
  0xffffaaabffff5558, 0x0000000000000000,
  0xffffaaacaaaa0004, 0x0000000000000000,
  0xffffffaaaaaaaa00, 0x0000000000000000,
  0xffffffab555554ac, 0x0000000000000000,
  0xffffffabffffff58, 0x0000000000000000,
  0xffffffacaaaaaa04, 0x0000000000000000,
  0xffffffeaaaaaaa80, 0x0000000000000000,
  0xfffffffeccccccc8, 0x0000000000000000,
  0xffffffff33333330, 0x0000000000000000,
  0xffffffff99999998, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000066666668, 0x0000000000000000,
  0x00000000ccccccd0, 0x0000000000000000,
  0x0000000ccccccd00, 0x0000000000000000,
  0x00000032000000c8, 0x0000000000000000,
  0x0000003266666730, 0x0000000000000000,
  0x00000032cccccd98, 0x0000000000000000,
  0x000033320000ccc8, 0x0000000000000000,
  0x0000333266673330, 0x0000000000000000,
  0x00003332cccd9998, 0x0000000000000000,
  0x147ae147eb851eb8, 0x0000000000000000,
  0x2222222288888888, 0x0000000000000000,
  0x33333332ccccccc8, 0x0000000000000000,
  0x3333333333333330, 0x0000000000000000,
  0x3333333399999998, 0x0000000000000000,
  0xcccccccc00000000, 0x0000000000000000,
  0xcccccccc66666668, 0x0000000000000000,
  0xdddddddd11111110, 0x0000000000000000,
  0xeb851eb7ae147ae0, 0x0000000000000000,
  0xffffcccccccc0000, 0x0000000000000000,
  0xffffcccd33326668, 0x0000000000000000,
  0xffffcccd9998ccd0, 0x0000000000000000,
  0xffffcccdffff3338, 0x0000000000000000,
  0xffffffcccccccc00, 0x0000000000000000,
  0xffffffcd33333268, 0x0000000000000000,
  0xffffffcd999998d0, 0x0000000000000000,
  0xffffffcdffffff38, 0x0000000000000000,
  0xfffffff333333300, 0x0000000000000000,
  0xfffffffffffd0000, 0x0000000000000000,
  0xfffffffffffe0000, 0x0000000000000000,
  0xffffffffffff0000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000010000, 0x0000000000000000,
  0x0000000000020000, 0x0000000000000000,
  0x0000000000200000, 0x0000000000000000,
  0x00000000007d0000, 0x0000000000000000,
  0x00000000007e0000, 0x0000000000000000,
  0x00000000007f0000, 0x0000000000000000,
  0x000000007ffd0000, 0x0000000000000000,
  0x000000007ffe0000, 0x0000000000000000,
  0x000000007fff0000, 0x0000000000000000,
  0x0000333333330000, 0x0000000000000000,
  0x0000555555550000, 0x0000000000000000,
  0x00007ffffffd0000, 0x0000000000000000,
  0x00007ffffffe0000, 0x0000000000000000,
  0x00007fffffff0000, 0x0000000000000000,
  0xffff800000000000, 0x0000000000000000,
  0xffff800000010000, 0x0000000000000000,
  0xffffaaaaaaaa0000, 0x0000000000000000,
  0xffffcccccccc0000, 0x0000000000000000,
  0xffffffff80000000, 0x0000000000000000,
  0xffffffff80010000, 0x0000000000000000,
  0xffffffff80020000, 0x0000000000000000,
  0xffffffff80030000, 0x0000000000000000,
  0xffffffffff800000, 0x0000000000000000,
  0xffffffffff810000, 0x0000000000000000,
  0xffffffffff820000, 0x0000000000000000,
  0xffffffffff830000, 0x0000000000000000,
  0xffffffffffe00000, 0x0000000000000000,
  0xfffffffffffd0006, 0x0000000000000000,
  0xfffffffffffe0004, 0x0000000000000000,
  0xffffffffffff0002, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000fffe, 0x0000000000000000,
  0x000000000001fffc, 0x0000000000000000,
  0x00000000001fffc0, 0x0000000000000000,
  0x00000000007cff06, 0x0000000000000000,
  0x00000000007dff04, 0x0000000000000000,
  0x00000000007eff02, 0x0000000000000000,
  0x000000007ffc0006, 0x0000000000000000,
  0x000000007ffd0004, 0x0000000000000000,
  0x000000007ffe0002, 0x0000000000000000,
  0x00003332cccc999a, 0x0000000000000000,
  0x00005554aaaa5556, 0x0000000000000000,
  0x00007ffefffd0006, 0x0000000000000000,
  0x00007ffefffe0004, 0x0000000000000000,
  0x00007ffeffff0002, 0x0000000000000000,
  0xffff800100000000, 0x0000000000000000,
  0xffff80010000fffe, 0x0000000000000000,
  0xffffaaab5554aaac, 0x0000000000000000,
  0xffffcccd33326668, 0x0000000000000000,
  0xffffffff80010000, 0x0000000000000000,
  0xffffffff8001fffe, 0x0000000000000000,
  0xffffffff8002fffc, 0x0000000000000000,
  0xffffffff8003fffa, 0x0000000000000000,
  0xffffffffff800100, 0x0000000000000000,
  0xffffffffff8100fe, 0x0000000000000000,
  0xffffffffff8200fc, 0x0000000000000000,
  0xffffffffff8300fa, 0x0000000000000000,
  0xffffffffffe00040, 0x0000000000000000,
  0xfffffffffffd000c, 0x0000000000000000,
  0xfffffffffffe0008, 0x0000000000000000,
  0xffffffffffff0004, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000fffc, 0x0000000000000000,
  0x000000000001fff8, 0x0000000000000000,
  0x00000000001fff80, 0x0000000000000000,
  0x00000000007cfe0c, 0x0000000000000000,
  0x00000000007dfe08, 0x0000000000000000,
  0x00000000007efe04, 0x0000000000000000,
  0x000000007ffb000c, 0x0000000000000000,
  0x000000007ffc0008, 0x0000000000000000,
  0x000000007ffd0004, 0x0000000000000000,
  0x0000333266663334, 0x0000000000000000,
  0x00005553ffffaaac, 0x0000000000000000,
  0x00007ffdfffd000c, 0x0000000000000000,
  0x00007ffdfffe0008, 0x0000000000000000,
  0x00007ffdffff0004, 0x0000000000000000,
  0xffff800200000000, 0x0000000000000000,
  0xffff80020000fffc, 0x0000000000000000,
  0xffffaaabffff5558, 0x0000000000000000,
  0xffffcccd9998ccd0, 0x0000000000000000,
  0xffffffff80020000, 0x0000000000000000,
  0xffffffff8002fffc, 0x0000000000000000,
  0xffffffff8003fff8, 0x0000000000000000,
  0xffffffff8004fff4, 0x0000000000000000,
  0xffffffffff800200, 0x0000000000000000,
  0xffffffffff8101fc, 0x0000000000000000,
  0xffffffffff8201f8, 0x0000000000000000,
  0xffffffffff8301f4, 0x0000000000000000,
  0xffffffffffe00080, 0x0000000000000000,
  0xfffffffffffd0012, 0x0000000000000000,
  0xfffffffffffe000c, 0x0000000000000000,
  0xffffffffffff0006, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000fffa, 0x0000000000000000,
  0x000000000001fff4, 0x0000000000000000,
  0x00000000001fff40, 0x0000000000000000,
  0x00000000007cfd12, 0x0000000000000000,
  0x00000000007dfd0c, 0x0000000000000000,
  0x00000000007efd06, 0x0000000000000000,
  0x000000007ffa0012, 0x0000000000000000,
  0x000000007ffb000c, 0x0000000000000000,
  0x000000007ffc0006, 0x0000000000000000,
  0x00003331ffffccce, 0x0000000000000000,
  0x0000555355550002, 0x0000000000000000,
  0x00007ffcfffd0012, 0x0000000000000000,
  0x00007ffcfffe000c, 0x0000000000000000,
  0x00007ffcffff0006, 0x0000000000000000,
  0xffff800300000000, 0x0000000000000000,
  0xffff80030000fffa, 0x0000000000000000,
  0xffffaaacaaaa0004, 0x0000000000000000,
  0xffffcccdffff3338, 0x0000000000000000,
  0xffffffff80030000, 0x0000000000000000,
  0xffffffff8003fffa, 0x0000000000000000,
  0xffffffff8004fff4, 0x0000000000000000,
  0xffffffff8005ffee, 0x0000000000000000,
  0xffffffffff800300, 0x0000000000000000,
  0xffffffffff8102fa, 0x0000000000000000,
  0xffffffffff8202f4, 0x0000000000000000,
  0xffffffffff8302ee, 0x0000000000000000,
  0xffffffffffe000c0, 0x0000000000000000,
  0xfffffffffffffd00, 0x0000000000000000,
  0xfffffffffffffe00, 0x0000000000000000,
  0xffffffffffffff00, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000100, 0x0000000000000000,
  0x0000000000000200, 0x0000000000000000,
  0x0000000000002000, 0x0000000000000000,
  0x0000000000007d00, 0x0000000000000000,
  0x0000000000007e00, 0x0000000000000000,
  0x0000000000007f00, 0x0000000000000000,
  0x00000000007ffd00, 0x0000000000000000,
  0x00000000007ffe00, 0x0000000000000000,
  0x00000000007fff00, 0x0000000000000000,
  0x0000003333333300, 0x0000000000000000,
  0x0000005555555500, 0x0000000000000000,
  0x0000007ffffffd00, 0x0000000000000000,
  0x0000007ffffffe00, 0x0000000000000000,
  0x0000007fffffff00, 0x0000000000000000,
  0xffffff8000000000, 0x0000000000000000,
  0xffffff8000000100, 0x0000000000000000,
  0xffffffaaaaaaaa00, 0x0000000000000000,
  0xffffffcccccccc00, 0x0000000000000000,
  0xffffffffff800000, 0x0000000000000000,
  0xffffffffff800100, 0x0000000000000000,
  0xffffffffff800200, 0x0000000000000000,
  0xffffffffff800300, 0x0000000000000000,
  0xffffffffffff8000, 0x0000000000000000,
  0xffffffffffff8100, 0x0000000000000000,
  0xffffffffffff8200, 0x0000000000000000,
  0xffffffffffff8300, 0x0000000000000000,
  0xffffffffffffe000, 0x0000000000000000,
  0xfffffffffffffd06, 0x0000000000000000,
  0xfffffffffffffe04, 0x0000000000000000,
  0xffffffffffffff02, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x00000000000000fe, 0x0000000000000000,
  0x00000000000001fc, 0x0000000000000000,
  0x0000000000001fc0, 0x0000000000000000,
  0x0000000000007c06, 0x0000000000000000,
  0x0000000000007d04, 0x0000000000000000,
  0x0000000000007e02, 0x0000000000000000,
  0x00000000007efd06, 0x0000000000000000,
  0x00000000007efe04, 0x0000000000000000,
  0x00000000007eff02, 0x0000000000000000,
  0x00000032cccccc9a, 0x0000000000000000,
  0x00000054aaaaaa56, 0x0000000000000000,
  0x0000007efffffd06, 0x0000000000000000,
  0x0000007efffffe04, 0x0000000000000000,
  0x0000007effffff02, 0x0000000000000000,
  0xffffff8100000000, 0x0000000000000000,
  0xffffff81000000fe, 0x0000000000000000,
  0xffffffab555554ac, 0x0000000000000000,
  0xffffffcd33333268, 0x0000000000000000,
  0xffffffffff810000, 0x0000000000000000,
  0xffffffffff8100fe, 0x0000000000000000,
  0xffffffffff8101fc, 0x0000000000000000,
  0xffffffffff8102fa, 0x0000000000000000,
  0xffffffffffff8100, 0x0000000000000000,
  0xffffffffffff81fe, 0x0000000000000000,
  0xffffffffffff82fc, 0x0000000000000000,
  0xffffffffffff83fa, 0x0000000000000000,
  0xffffffffffffe040, 0x0000000000000000,
  0xfffffffffffffd0c, 0x0000000000000000,
  0xfffffffffffffe08, 0x0000000000000000,
  0xffffffffffffff04, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x00000000000000fc, 0x0000000000000000,
  0x00000000000001f8, 0x0000000000000000,
  0x0000000000001f80, 0x0000000000000000,
  0x0000000000007b0c, 0x0000000000000000,
  0x0000000000007c08, 0x0000000000000000,
  0x0000000000007d04, 0x0000000000000000,
  0x00000000007dfd0c, 0x0000000000000000,
  0x00000000007dfe08, 0x0000000000000000,
  0x00000000007dff04, 0x0000000000000000,
  0x0000003266666634, 0x0000000000000000,
  0x00000053ffffffac, 0x0000000000000000,
  0x0000007dfffffd0c, 0x0000000000000000,
  0x0000007dfffffe08, 0x0000000000000000,
  0x0000007dffffff04, 0x0000000000000000,
  0xffffff8200000000, 0x0000000000000000,
  0xffffff82000000fc, 0x0000000000000000,
  0xffffffabffffff58, 0x0000000000000000,
  0xffffffcd999998d0, 0x0000000000000000,
  0xffffffffff820000, 0x0000000000000000,
  0xffffffffff8200fc, 0x0000000000000000,
  0xffffffffff8201f8, 0x0000000000000000,
  0xffffffffff8202f4, 0x0000000000000000,
  0xffffffffffff8200, 0x0000000000000000,
  0xffffffffffff82fc, 0x0000000000000000,
  0xffffffffffff83f8, 0x0000000000000000,
  0xffffffffffff84f4, 0x0000000000000000,
  0xffffffffffffe080, 0x0000000000000000,
  0xfffffffffffffd12, 0x0000000000000000,
  0xfffffffffffffe0c, 0x0000000000000000,
  0xffffffffffffff06, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x00000000000000fa, 0x0000000000000000,
  0x00000000000001f4, 0x0000000000000000,
  0x0000000000001f40, 0x0000000000000000,
  0x0000000000007a12, 0x0000000000000000,
  0x0000000000007b0c, 0x0000000000000000,
  0x0000000000007c06, 0x0000000000000000,
  0x00000000007cfd12, 0x0000000000000000,
  0x00000000007cfe0c, 0x0000000000000000,
  0x00000000007cff06, 0x0000000000000000,
  0x00000031ffffffce, 0x0000000000000000,
  0x0000005355555502, 0x0000000000000000,
  0x0000007cfffffd12, 0x0000000000000000,
  0x0000007cfffffe0c, 0x0000000000000000,
  0x0000007cffffff06, 0x0000000000000000,
  0xffffff8300000000, 0x0000000000000000,
  0xffffff83000000fa, 0x0000000000000000,
  0xffffffacaaaaaa04, 0x0000000000000000,
  0xffffffcdffffff38, 0x0000000000000000,
  0xffffffffff830000, 0x0000000000000000,
  0xffffffffff8300fa, 0x0000000000000000,
  0xffffffffff8301f4, 0x0000000000000000,
  0xffffffffff8302ee, 0x0000000000000000,
  0xffffffffffff8300, 0x0000000000000000,
  0xffffffffffff83fa, 0x0000000000000000,
  0xffffffffffff84f4, 0x0000000000000000,
  0xffffffffffff85ee, 0x0000000000000000,
  0xffffffffffffe0c0, 0x0000000000000000,
  0xffffffffffffff40, 0x0000000000000000,
  0xffffffffffffff80, 0x0000000000000000,
  0xffffffffffffffc0, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000040, 0x0000000000000000,
  0x0000000000000080, 0x0000000000000000,
  0x0000000000000800, 0x0000000000000000,
  0x0000000000001f40, 0x0000000000000000,
  0x0000000000001f80, 0x0000000000000000,
  0x0000000000001fc0, 0x0000000000000000,
  0x00000000001fff40, 0x0000000000000000,
  0x00000000001fff80, 0x0000000000000000,
  0x00000000001fffc0, 0x0000000000000000,
  0x0000000cccccccc0, 0x0000000000000000,
  0x0000001555555540, 0x0000000000000000,
  0x0000001fffffff40, 0x0000000000000000,
  0x0000001fffffff80, 0x0000000000000000,
  0x0000001fffffffc0, 0x0000000000000000,
  0xffffffe000000000, 0x0000000000000000,
  0xffffffe000000040, 0x0000000000000000,
  0xffffffeaaaaaaa80, 0x0000000000000000,
  0xfffffff333333300, 0x0000000000000000,
  0xffffffffffe00000, 0x0000000000000000,
  0xffffffffffe00040, 0x0000000000000000,
  0xffffffffffe00080, 0x0000000000000000,
  0xffffffffffe000c0, 0x0000000000000000,
  0xffffffffffffe000, 0x0000000000000000,
  0xffffffffffffe040, 0x0000000000000000,
  0xffffffffffffe080, 0x0000000000000000,
  0xffffffffffffe0c0, 0x0000000000000000,
  0xfffffffffffff800, 0x0000000000000000,
};
const unsigned kExpectedCount_NEON_sqdmlsl_D = 961;

#endif  // VIXL_SIM_SQDMLSL_D_TRACE_AARCH64_H_
