macro(clear_var var)
    unset(${var})
    unset(${var} CACHE)
endmacro()

macro(clear_pkg_vars pkg)
  foreach(var FOUND INCLUDE_DIR INCLUDE_DIRS LIBRARY LIBRARIES VERSION)
    clear_var(${pkg}_${var})
  endforeach()
endmacro()

macro(find_package)
  if(NOT "${ARGV0}" IN_LIST BUILTINS)
    _find_package(${ARGV})
  endif()
endmacro()

if(BUILD_GOOGLETEST)
  list(APPEND BUILTINS GTest)
  add_subdirectory(builtins/googletest EXCLUDE_FROM_ALL)
else()
  clear_pkg_vars(GTest)
endif()

if(BUILD_GOOGLEBENCH)
  list(APPEND BUILTINS benchmark)
  add_subdirectory(builtins/benchmark EXCLUDE_FROM_ALL)
else()
  clear_pkg_vars(benchmark)
endif()

if(BUILD_VC)
  list(APPEND BUILTINS Vc)
  add_subdirectory(builtins/Vc)
  set(VC ON CACHE BOOL "" FORCE)
else()
  clear_pkg_vars(Vc)
endif()

if(BUILD_UMESIMD)
  list(APPEND BUILTINS UMESIMD)
  add_subdirectory(builtins/umesimd)
  set(UMESIMD ON CACHE BOOL "" FORCE)
else()
  clear_pkg_vars(UMESIMD)
endif()
