/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.id;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;

public final class ModuleId
implements Comparable {
    private static final Map CACHE = new WeakHashMap();
    private String organisation;
    private String name;
    private int hash;
    private Map attributes = new HashMap();

    public static ModuleId newInstance(String string, String string2) {
        ModuleId moduleId = new ModuleId(string, string2);
        ModuleId moduleId2 = (ModuleId)CACHE.get(moduleId);
        if (moduleId2 == null) {
            moduleId2 = moduleId;
            CACHE.put(moduleId2, moduleId2);
        }
        return moduleId2;
    }

    public ModuleId(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("null name not allowed");
        }
        this.organisation = string;
        this.name = string2;
        this.attributes.put("organisation", string);
        this.attributes.put("module", string2);
    }

    public final String getName() {
        return this.name;
    }

    public final String getOrganisation() {
        return this.organisation;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof ModuleId)) {
            return false;
        }
        ModuleId moduleId = (ModuleId)object;
        if (moduleId.organisation == null) {
            return this.organisation == null && moduleId.name.equals(this.name);
        }
        return moduleId.organisation.equals(this.organisation) && moduleId.name.equals(this.name);
    }

    public final int hashCode() {
        if (this.hash == 0) {
            this.hash = 31;
            this.hash = this.hash * 13 + (this.organisation == null ? 0 : this.organisation.hashCode());
            this.hash = this.hash * 13 + this.name.hashCode();
        }
        return this.hash;
    }

    public final String toString() {
        return this.organisation + "#" + this.name;
    }

    public final int compareTo(Object object) {
        ModuleId moduleId = (ModuleId)object;
        int n = this.organisation.compareTo(moduleId.organisation);
        if (n == 0) {
            n = this.name.compareTo(moduleId.name);
        }
        return n;
    }

    public final Map getAttributes() {
        return this.attributes;
    }

    static {
        Pattern.compile("([a-zA-Z0-9\\-/\\._+=]*)#([a-zA-Z0-9\\-/\\._+=]+)");
    }
}

