
GribTable centers[] = {
	{1, "Melbourne (WMC)"},
	{2, "Melbourne (WMC)"},
	{3, "Melbourne (WMC)"},
	{4, "Moscow (WMC)"},
	{5, "Moscow (WMC)"},
	{6, "Moscow (WMC)"},
	{7, "US National Weather Service - NCEP (WMC)"},
	{8, "US National Weather Service - NWSTG (WMC)"},
	{9, "US National Weather Service - Other (WMC)"},
	{10, "Cairo (RSMC/RAFC)"},
	{11, "Cairo (RSMC/RAFC)"},
	{12, "Dakar (RSMC/RAFC)"},
	{13, "Dakar (RSMC/RAFC)"},
	{14, "Nairobi (RSMC/RAFC)"},
	{15, "Nairobi (RSMC/RAFC)"},
	{16, "Casablanca (RSMC)"},
        {17, "Tunis (RSMC)"},
	{18, "Tunis-Casablanca (RSMC)"},
	{19, "Tunis-Casablanca (RSMC)"},
	{20, "Las Palmas (RAFC)"},
	{21, "Algiers (RSMC)"},
	{22, "ACMAD"},
	{23, "Mozambique (NMC)"},
        {24, "Pretoria (RSMC)"},
        {25, "La Reunion (RSMC)"},
	{26, "Khabarovsk (RSMC)"},
	{27, "Khabarovsk (RSMC)"},
	{28, "New Delhi (RSMC/RAFC)"},
	{29, "New Delhi (RSMC/RAFC)"},
	{30, "Novosibirsk (RSMC)"},
	{31, "Novosibirsk (RSMC)"},
	{32, "Tashkent (RSMC)"},
	{33, "Jeddah (RSMC)"},
	{34, "Japanese Meteorological Agency - Tokyo (RSMC)"},
	{35, "Japanese Meteorological Agency - Tokyo (RSMC)"},
	{36, "Bankok"},
	{37, "Ulan Bator"},
	{38, "Beijing (RSMC)"},
	{39, "Beijing (RSMC)"},
	{40, "Seoul"},
	{41, "Buenos Aires (RSMC/RAFC)"},
	{42, "Buenos Aires (RSMC/RAFC)"},
	{43, "Brasilia (RSMC/RAFC)"},
	{44, "Brasilia (RSMC/RAFC)"},
	{45, "Santiago"},
	{46, "Brasilian Space Agency - INPE"},
	{47, "Columbia (NMC)"},
	{48, "Ecuador (NMC)"},
	{49, "Peru (NMC)"},
	{50, "Venezuela (NMC)"},
	{51, "Miami (RSMC/RAFC)"},
	{52, "Tropical Prediction Center (NHC), Miami (RMSC)"},
	{53, "Canadian Meteorological Service - Montreal (RSMC)"},
	{54, "Canadian Meteorological Service - Montreal (RSMC)"},
	{55, "San Francisco"},
	{56, "ARINC Center"},
	{57, "U.S. Air Force - Global Weather Center"},
	{58, "US Navy  - Fleet Numerical Oceanography Center"},
	{59, "NOAA Forecast Systems Lab, Boulder CO"},
	{60, "National Center for Atmospheric Research (NCAR), Boulder, CO"},
	{61, "Service ARGOS - Landover, MD, USA"},
	{62, "US Naval Oceanographic Office"},
	{63, "International Research Institude for Climate and Society"},
	{64, "Honolulu"},
	{65, "Darwin (RSMC)"},
	{66, "Darwin (RSMC)"},
	{67, "Melbourne (RSMC)"},
	{68, "Reserved"},
	{69, "Wellington (RSMC/RAFC)"},
	{70, "Wellington (RSMC/RAFC)"},
	{71, "Nadi (RSMC)"},
	{72, "Singapore"},
	{73, "Malaysia (NMC)"},
	{74, "U.K. Met Office - Exeter (RSMC)"},
	{75, "U.K. Met Office - Exeter (RSMC)"},
	{76, "Moscow (RSMC/RAFC)"},
	{77, "Reserved"},
	{78, "Offenbach (RSMC)"},
	{79, "Offenbach (RSMC)"},
	{80, "Rome (RSMC)"},
	{81, "Rome (RSMC)"},
	{82, "Norrkoping"},
	{83, "Norrkoping"},
	{84, "French Weather Service - Toulouse"},
	{85, "French Weather Service - Toulouse"},
	{86, "Helsinki"},
	{87, "Belgrade"},
	{88, "Oslo"},
	{89, "Prague"},
	{90, "Episkopi"},
	{91, "Ankara"},
	{92, "Frankfurt/Main (RAFC)"},
	{93, "London (WAFC)"},
	{94, "Copenhagen"},
	{95, "Rota"},
	{96, "Athens"},
	{97, "European Space Agency (ESA)"},
	{98, "European Center for Medium-Range Weather Forecasts (RSMC)"},
	{99, "DeBilt, Netherlands"},
	{100, "Brazzaville"},
	{101, "Abidjan"},
	{102, "Libyan Arab Jamahiriya (NMC)"},
	{103, "Madagascar (NMC)"},
	{104, "Mauritius (NMC)"},
	{105, "Niger (NMC)"},
	{106, "Seychelles (NMC)"},
	{107, "Uganda (NMC)"},
	{108, "Tanzania (NMC)"},
	{109, "Zimbabwe (NMC)"},
	{110, "Hong-Kong"},
	{111, "Afghanistan (NMC)"},
	{112, "Bahrain (NMC)"},
	{113, "Bangladesh (NMC)"},
	{114, "Bhutan (NMC)"},
	{115, "Cambodia (NMC)"},
	{116, "Democratic People's Republic of Korea (NMC)"},
	{117, "Islamic Republic of Iran (NMC)"},
	{118, "Iraq (NMC)"},
	{119, "Kazakhstan (NMC)"},
	{120, "Kuwait (NMC)"},
	{121, "Kyrgyz Republic (NMC)"},
	{122, "Lao People's Democratic Republic (NMC)"},
	{123, "Macao, China"},
	{124, "Maldives (NMC)"},
	{125, "Myanmar (NMC)"},
	{126, "Nepal (NMC)"},
	{127, "Oman (NMC) "},
	{128, "Pakistan (NMC)"},
	{129, "Qatar (NMC)"},
	{130, "Republic of Yemen (NMC)"},
	{131, "Sri Lanka (NMC)"},
	{132, "Tajikistan (NMC)"},
	{133, "Turkmenistan (NMC)"},
	{134, "United Arab Emirates (NMC)"},
	{135, "Uzbekistan (NMC)"},
	{136, "Viet Nam (NMC)"},
	{140, "Bolivia (NMC)"},
	{141, "Guyana (NMC)"},
	{142, "Paraguay (NMC)"},
	{143, "Suriname (NMC)"},
	{144, "Uruguay (NMC)"},
	{145, "French Guyana"},
	{146, "Brazilian Navy Hydrographic Center"},
	{147, "National Commission on Space Activities - Argentina"},
	{150, "Antigua and Barbuda (NMC)"},
	{151, "Bahamas (NMC)"},
	{152, "Barbados (NMC)"},
	{153, "Belize (NMC)"},
	{154, "British Caribbean Territories Center"},
	{155, "San Jose"},
	{156, "Cuba (NMC)"},
	{157, "Dominica (NMC)"},
	{158, "Dominican Republic (NMC)"},
	{159, "El Salvador (NMC)"},
	{160, "US NOAA/NESDIS"},
	{161, "US NOAA Office of Oceanic and Atmospheric Research"},
	{162, "Guatemala (NMC)"},
	{163, "Haiti (NMC)"},
	{164, "Honduras (NMC)"},
	{165, "Jamaica (NMC)"},
	{166, "Mexico City"},
	{167, "Netherlands Antilles and Aruba (NMC)"},
	{168, "Nicaragua (NMC)"},
	{169, "Panama (NMC)"},
	{170, "Saint Lucia (NMC)"},
	{171, "Trinidad and Tobago (NMC)"},
	{172, "French Departments in RA IV"},
	{173, "US National Aeronautics and Space Administration (NASA)"},
	{174, "Integrated System Data Management/Marine Environmental Data Service (ISDM/MEDS) - Canada"},
	{176, "US Cooperative Institude for Meteorological Satellite Studies"},
	{190, "Cook Islands (NMC)"},
	{191, "French Polynesia (NMC)"},
	{192, "Tonga (NMC)"},
	{193, "Vanuatu (NMC)"},
	{194, "Brunei (NMC)"},
	{195, "Indonesia (NMC)"},
	{196, "Kiribati (NMC)"},
	{197, "Federated States of Micronesia (NMC)"},
	{198, "New Caledonia (NMC)"},
	{199, "Niue"},
	{200, "Papua New Guinea (NMC)"},
	{201, "Philippines (NMC)"},
	{202, "Samoa (NMC)"},
	{203, "Solomon Islands (NMC)"},
	{204, "Narional Institude of Water and Atmospheric Research - New Zealand"},
	{210, "Frascati"},
	{211, "Lanion"},
	{212, "Lisbon"},
	{213, "Reykjavik"},
	{214, "Madrid"},
	{215, "Zurich"},
	{216, "Service ARGOS - Toulouse, FR"},
	{217, "Bratislava"},
	{218, "Budapest"},
	{219, "Ljubljana"},
	{220, "Warsaw"},
	{221, "Zagreb"},
	{222, "Albania (NMC)"},
	{223, "Armenia (NMC)"},
	{224, "Austria (NMC)"},
	{225, "Azerbaijan (NMC)"},
	{226, "Belarus (NMC)"},
	{227, "Belgium (NMC)"},
	{228, "Bosnia and Herzegovina (NMC)"},
	{229, "Bulgaria (NMC)"},
	{230, "Cyprus (NMC)"},
	{231, "Estonia (NMC)"},
	{232, "Georgia (NMC)"},
	{233, "Dublin"},
	{234, "Israel (NMC)"},
	{235, "Jordan (NMC)"},
	{236, "Latvia (NMC)"},
	{237, "Lebanon (NMC)"},
	{238, "Lithuania (NMC)"},
	{239, "Luxembourg"},
	{240, "Malta (NMC)"},
	{241, "Monaco"},
	{242, "Romania (NMC)"},
	{243, "Syrian Arab Republic (NMC)"},
	{244, "The former Yugoslav Republic of Macedonia (NMC)"},
	{245, "Ukraine (NMC)"},
	{246, "Republic of Moldova"},
	{247, "Operational Programme for the Exchange of Weather RAdar Information (OPERA) - EUMETNET"},
	{250, "COnsortium for Small scale MOdelling (COSMO)"},
	{254, "EUMETSAT Operations Center"},
	{255, "Missing Value"}
};

int ecmwf_members[] = { 74, 78, 80, 84, 85, 86, 88, 91, 92, 93, 94, 96, 98, 99, 214, 215, 216, 224, 227, 233, 239, 
			22, 87, 89, 97, 213, 218, 221, 231, 238, 242, 254 };

/* Table 0 Part 2 */

GribTable sub_centers[] = {
        {1, "NCEP Re-Analysis Project"},
        {2, "NCEP Ensemble Products"},
        {3, "NCEP Central Operations"},
        {4, "Environmental Modeling Center"},
        {5, "Hydrometeorological Prediction Center"},
        {6, "Marine Prediction Center"},
        {7, "Climate Prediction Center"},
        {8, "Aviation Weather Center"},
        {9, "Storm Prediction Center"},
        {10, "National Hurricane Prediction Center"},
        {11, "NWS Techniques Development Laboratory"},
        {12, "NESDIS Office of Research and Applications"},
        {13, "Federal Aviation Administration"},
        {14, "NWS Meteorological Development Laboratory (MDL)"},
        {15, "The North American Regional Reanalysis (NARR) Project"},
	{16, "Space Weather Prediction Center"},
	{150, "ABRFC - Arkansas-Red River RFC, Tulsa OK"},
	{151, "Alaska RFC, Anchorage, AK"}, 
	{152, "CBRFC - Colorado Basin RFC, Salt Lake City, UT"},
	{153, "CNRFC - California-Nevada RFC, Sacramento, CA"}, 
	{154, "LMRFC - Lower Mississippi RFC, Slidel, LA"},
	{155, "MARFC - Middle Atlantic RFC, State College, PA"},
	{156, "MBRFC - Missouri Basin RFC, Kansas City, MO"},
	{157, "NCRFC - North Central RFC, Minneapolic, MN"},
	{158, "NERFC - Northeast RFC, Hartford, CT"},
	{159, "NWRFC - Northwest RFC, Portland, OR"},
	{160, "OHRFC - Ohio Basin RFC, Cincinnati, OH"},
	{161, "SERFC - Southeast RFC, Atlanta, GA"},
	{162, "WGRFC - West Gulf RFC, Fort Worth, TX"},
	{170, "OUN - Norman OK WFO"} 
};


/* Table A */
GribTable models[] = {
	{02, "Ultra Violet Index Model"},
	{03, "NCEP/ARL Transport and Dispersion Model"},
	{04, "NCEP/ARL Smoke Model"},
	{05, "Satellite Derived Precipitation and temperatures, from IR"},
	{06, "NCEP/ARL Dust Model"},
	{10, "Global Wind-Wave Forecast Model"},
	{11, "Global Multi-Grid Wave Model (Static Grids)"},
	{12, "Probabilistic Storm Surge"},
	{13, "Hurricane Multi-Grid Wave Model"},
	{14, "Extratropical Storm Surge Model"},
	{15, "Nearshore Wave Prediction System (NWPS)"},
	{19, "Limited-area Fine Mesh (LFM) analysis"},
	{25, "Snow Cover Analysis"},
	{30, "Forecaster generated field"},
        {39, "Nested Grid Forecast Model (NGM)"},
	{31, "Value added post processed field"},
	{42, "Global Optimum Interpolation Analysis (GOI) from GFS model"},
	{43, "Global Optimum Interpolation Analysis (GOI) from \"Final\" run"},
	{44, "Sea Surface Temperature Analysis"},
	{45, "Coastal Ocean Circulation Model"},
	{46, "HYCOM - Global"},
	{47, "HYCOM - North Pacific basin"},
	{48, "HYCOM - North Atlantic basin"},
	{49, "Ozone Analysis from TIROS Observations"},
	{52, "Ozone Analysis from Nimbus 7 Observations"},
	{53, "LFM-Fourth Order Forecast Model"},
	{64, "Regional Optimum Interpolation Analysis (ROI)"},
	{68, "80 wave triangular, 18-layer Spectral model from GFS model"},
	{69, "80 wave triangular, 18 layer Spectral model from \"Medium Range Forecast\" run"},
	{70, "Quasi-Lagrangian Hurricane Model (QLM)"},
	{73, "Fog Forecast model - Ocean Prod. Center"},
	{74, "Gulf of Mexico Wind/Wave"},
	{75, "Gulf of Alaska Wind/Wave"},
	{76, "Bias corrected Medium Range Forecast"},
	{77, "126 wave triangular, 28 layer Spectral model from GFS model"},
	{78, "126 wave triangular, 28 layer Spectral model from \"Medium Range Forecast\" run"},
	{79, "Backup from the previous run"},
	{80, "62 wave triangular, 28 layer Spectral model from \"Medium Range Forecast\" run"},
	{81, "Analysis from GFS (Global Forecast System)"},
	{82, "Analysis from GDAS (Global Data Assimilation System)"},
	{83, "High Resolution Rapid Refresh (HRRR)"},
	{84, "MESO NAM Model (currently 12 km)"},
	{85, "Real Time Ocean Forecast System (RTOFS)"},
	{86, "RUC Model, from Forecast Systems Lab (isentropic; scale 60km at 40N)"},
	{87, "CAC Ensemble Forecasts from Spectral (ENSMB)"},
	{88, "NOAA Wave Watch III (NWW3) Ocean Wave Model"},
	{89, "Non-hydrostatic Meso Model (NMM) (Currently 8 km)"},
	{90, "62 wave triangular, 28 layer spectral model extension of the \"Medium Range Forecast\" run"},
	{91, "62 wave triangular, 28 layer spectral model extension of the GFS model"},
	{92, "62 wave triangular, 28 layer spectral model run from the \"Medium Range Forecast\" final analysis"},
	{93, "62 wave triangular, 28 layer spectral model run from the T62 GDAS analysis of the \"Medium Range Forecast\" run"},
	{94, "T170/L42 Global Spectral Model from MRF run"},
	{95, "T126/L42 Global Spectral Model from MRF run"},
	{96, "Global Forecast System Model (T1534 - Forecast hours 00-384, T574 - Forecast hours 00-192, T190 - Forecast hours 204-384)"},
	{98, "Climate Forecast System Model -- Atmospheric model (GFS) coupled to a multi level ocean model (Currently GFS spectral model at T62, 64 levels coupled to 40 level MOM3 ocean model)"},
	{99, "Miscellaneous Test ID"},
        {100, "RUC Surface Analysis (scale: 60km at 40N)"},
        {101, "RUC Surface Analysis (scale: 40km at 40N)"},
	{105, "Rapid Refresh (RAP)"},
	{107, "Global Ensemble Forecast System (GEFS)"},
	{108, "LAMP"},
	{109, "RTMA (Real Time Mesoscale Analysis)"},
	{110, "NAM Model - 15km version"},
	{111, "NAM model, generic resolution (Used in SREF processing)"},
	{112, "WRF-NMM model, generic resolution (Used in various runs) NMM=Nondydrostatic Mesoscale Model (NCEP)"},
	{113, "Products from NCEP SREF processing"},
	{114, "NAEFS Products from joined NCEP, CMC global ensembles"},
	{115, "Downscaled GFS from NAM eXtension"},
	{116, "WRF-EM model, generic resolution (Used in various runs) EM - Eulerian Mass-core (NCAR - aka Advanced Research WRF)"},
	{117, "NEMS GFS Aerosol Component"},
	{118, "URMA (UnRestricted Mesoscale Analysis)"},
	{119, "WAM (Whole Atmosphere Model)"},
	{120, "Ice Concentration Analysis"},
	{121, "Western North Atlantic Regional Wave Model"},
	{122, "Alaska Waters Regional Wave Model"},
	{123, "North Atlantic Hurricane Wave Model"},
	{124, "Eastern North Pacific Regional Wave Model"},
	{125, "North Pacific Hurricane Wave Model"},
	{126, "Sea Ice Forecast Model"},
	{127, "Lake Ice Forecast Model"},
	{128, "Global Ocean Forecast Model"},
	{129, "Global Ocean Data Analysis System (GODAS)"},
	{130, "Merge of fields from the RUC, NAM, and Spectral Model"},
	{131, "Great Lakes Wave Model"},
	{140, "North American Regional Reanalysis (NARR)"},
	{141, "Land Data Assimilation and Forecast System"},
	{150, "NWS River Forecast System (NWSRFS)"},
	{151, "NWS Flash Flood Guidance System (NWSFFGS)"},
	{152, "WSR-88D Stage II Precipitation Analysis"},
	{153, "WSR-88D Stage III Precipitation Analysis"},
	{180, "Quantitative Precipitation Forecast generated by NCEP"},
	{181, "River Forecast Center Quantitative Precipitation Forecast mosaic generated by NCEP"},
	{182, "River Forecast Center Quantitative Precipitation estimate mosaic generated by NCEP"},
	{183, "NDFD product generated by NCEP/HPC"},
	{184, "Climatological Calibrated Precipitation Analysis - CCPA"},
	{190, "National Convective Weather Diagnostic generated by NCEP/AWC"},
	{191, "Current Icing Potential automated product generated by NCEP/AWC"},
	{192, "Analysis product from NCEP/AWC"},
	{193, "Forecast product from NCEP/AWC"},
	{195, "Climate Data Assimilation System 2 (CDAS2)"},
	{196, "Climate Data Assimilation System 2 (CDAS2) - used for regeneration runs"},
	{197, "Climate Data Assimilation System (CDAS)"},
	{198, "Climate Data Assimilation System (CDAS) - used for regeneration runs"},
	{199, "Climate Forecast System Reanalysis (CFSR) -- Atmospheric model (GFS) coupled to a multi level ocean, land and seaice model (Currently GFS spectral model at T382, 64 levels coupled to 40 level MOM4 ocean model)"},
	{200, "CPC Manual Forecast Product"},
	{201, "CPC Automated Product"},
	{210, "EPA Air Quality Forecast - Currently North East US domain"},
	{211, "EPA Air Quality Forecast - Currently Eastern US domain"},
	{215, "SPC Manual Forecast Product"},
	{220, "NCEP/OPC automated product"},
	{255, "Missing"}
};

int level_index[] = {1,2,3,4,5,6,7,8,9,20,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,
		     115,116,117,119,120,121,125,128,141,160,200,201,204,206,207,209,210,211,212,213,214,
		     215,216,217,220,222,223,224,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,251,252};

int ecmwf_local_level[] = {210};
int ecmwf_local_start_index = sizeof(level_index) / sizeof(int);

int jra55_local_level[] = {211, 212, 213};
int jra55_local_start_index = sizeof(level_index) / sizeof(int)  + sizeof(ecmwf_local_level) / sizeof(int);

char *level_str[] = {
	"SFC",		/*1*/
	"CBL",		/*2*/
	"CTL",		/*3*/
	"0DEG",		/*4*/
	"ADCL",		/*5*/
	"MWSL",		/*6*/
	"TRO",		/*7*/
	"NTAT",		/*8*/
	"SEAB",		/*9*/
	"TMPL",		/*20*/
        "ISBL", 	/*100*/
        "ISBY", 	/*101*/
        "MSL", 	/*102*/
        "GPML",	/*103*/
        "GPMY",	/*104*/
        "HTGL",	/*105*/
        "HTGY",/*106*/
	"SIGL",		/*107*/
	"SIGY",	/*108*/
	"HYBL",		/*109*/ /* If you change this you better change _Get109A in NclGRIB.c */
	"HYBY",/*110*/
	"DBLL",	/*111*/
	"DBLY", /*112*/
	"THEL",	/*113*/
	"THEY", /*114*/
	"SPDL",	/*115*/
	"SPDY", /*116*/
	"PVL", /*117*/
	"NAML", /*119*/
	"NAMY", /*120*/
	"IBYH", 	/*121*/
	"HGLH",	/*125*/
	"SGYH", /*128*/
	"IBYM", /*141*/
	"DBSL",	/*160*/
	"EATM",	/*200*/
	"EOCN",	/*201*/
	"HTFL", /*204*/
	"GCBL", /*206*/
	"GCTL", /*207*/
	"BCBL", /*209*/
	"BCTL", /*210*/
	"BCY",  /*211*/
	"LCBL", /*212*/
	"LCTL", /*213*/
	"LCY",  /*214*/
	"CEIL", /*215*/
	"CBB",  /*216*/
	"CBT",  /*217*/
	"PBLRI", /*220*/
	"MCBL", /*222*/
	"MCTL", /*223*/
	"MCY",  /*224*/
	"HCBL", /*232*/
	"HCTL", /*233*/
	"HCY",  /*234*/
	"OITL", /*235*/
	"OLYR", /*236*/
	"OBML", /*237*/
	"OBIL", /*238*/
	"S26CY", /*239*/
	"OMXL", /*240*/
	"OSEQD",/*241*/
	"CCBL", /*242*/
	"CCTL", /*243*/
	"CCY",  /*244*/
	"LLTW", /*245*/
	"MTHE", /*246*/
	"EHLT", /*247*/
	"SCBL", /*248*/
	"SCTL", /*249*/
	"DCBL", /*251*/
	"DCTL",  /*252*/
	/* ecmwf local */
	"ISBH", /* 210 */
	/* jra55 local */
	"ESOIL", /* 211 */
	"BLSM", /* 212 */
	"ULN"  /* 213 */
};
char *level_units_str[] = {
	"none", /*"SFC",	1*/
	"none", /*"CBL",	2*/
	"none", /*"CTL",	3*/
	"none", /*"0DEG",	4*/
	"none", /*"ADCL",	5*/
	"none", /*"MWSL",	6*/
	"none", /*"TRO",	7*/
	"none", /*"NTAT",	8*/
	"none", /*"SEAB",	9*/
	"(1/100) K", /*"TMPL",	20*/
        "hPa", /*"ISBL", 	100*/
        "hPa", /*"ISBY", 	101*/
        "hPa", /*"MSL", 	102*/
        "m", /*"GPML",	103*/
        "hm", /*"GPMY",	104*/
        "m", /*"HTGL",	105*/
        "hm", /*"HTGY",106*/
	"sigma", /*"SIGL",		107*/
	"sigma", /*"SIGY",	108*/
	"number", /*"HYBL",		109*/ /* If you change this you better change _Get109A in NclGRIB.c */
	"number", /*"HYBY", 110*/
	"cm", /*"DBLL",	111*/
	"cm", /*"DBLY", 112*/
	"K", /*"THEL",	113*/
	"K", /*"THEY", 114*/
	"hPa", /*"SPDL",	115*/
	"hPa", /*"SPDY", 116*/
	"10^-6Km^2/kgs", /*"PVL", 117*/
	"NAM value in 1/10000", /*"NAML", 119*/
	"NAM value in 1/100", /*"NAMY", 120*/
	"hPa", /*"IBYH", 	121*/
	"cm", /*"HGLH",	125*/
	"1.1 - sigma", /*"SGYH", 128*/
	"hPa", /*"IBYM", 141*/
	"m", /*"DBSL",	160*/
	"none", /*"EATM",	200*/
	"none", /*"EOCN",		201*/
	"none", /*"HTFL", 204*/
	"none", /*"GCBL", 206*/
	"none", /*"GCTL", 207*/
	"none", /*"BCBL", 209*/
	"none", /*"BCTL", 210*/
	"none", /*"BCY",  211*/
	"none", /*"LCBL", 212*/
	"none", /*"LCTL", 213*/
	"none", /*"LCY",  214*/
	"none", /*"CEIL",  215*/
	"m",    /*"CBB",  216*/
	"m",    /*"CBT",  217*/
        "none", /*PBLRI,  220*/
	"none", /*"MCBL", 222*/
	"none", /*"MCTL", 223*/
	"none", /*"MCY",  224*/
	"none", /*"HCBL", 232*/
	"none", /*"HCTL", 233*/
	"none", /*"HCY",  234*/
	"1/10 degC", /*"OITL", 235*/
	"none", /*"OLYR", 236*/
	"m",    /*"OBML", 237*/
	"m",    /*"OBIL", 238*/
        "none", /*S26CY, 239*/
	"none", /*OMXL, 240*/
	"none", /*OSEQD, 241*/
	"none", /*"CCBL", 242*/
	"none", /*"CCTL", 243*/
	"none", /*"CCY",  244*/
	"none", /*"LLTW", 245*/
	"none", /*"MTHE", 246*/
	"none", /*"EHLT", 247*/
	"none", /*"SCBL", 248*/
	"none", /*"SCTL", 249*/
	"none", /*"DCBL", 251*/
	"none",  /*"DCTL"  252*/
	/* ecmwf local */
	"Pa", /* "ISBH",  210 */
	/* jra55 local */
	"none", /* "ESOIL", 211 */
	"none",  /*"BLSM",  212 */
	"number" /* "ULN"   213 */
};
char *level_str_long_name[] = {    
	"surface of the earth including sea surface", /*1*/
	"cloud base level",	/*2*/
	"cloud top level",	/*3*/
	"0 deg (C) isotherm level (lowest)", /*4*/
	"adiabatic condensation level (parcel lifted from surface)", /*5*/
	"maximum wind speed level", /*6*/
	"tropopause level",	/*7*/
	"nominal top of atmosphere", /*8*/
	"sea bottom", /*9*/
	"temperature in 1/100 K", /*20*/
	"isobaric level",	/*100*/
	"layer between two isobaric levels",	/*101*/
	"mean sea level",	/*102*/
	"fixed height level",	/*103*/
	"layer between two height levels above msl",	/*104*/
	"fixed height above ground",	/*105*/
	"layer between two height levels above ground",	/*106*/
	"sigma level",	/*107*/
	"layer between two sigma levels",	/*108*/
	"hybrid level",	/*109*/
	"layer between two hybrid levels",	/*110*/
	"depth below land surface",	/*111*/
	"layer between two depths below land surface",	/*112*/
	"isentropic (theta) level",	/*113*/
	"layer between two isentropic levels",	/*114*/
	"level at specified pressure difference from ground to level",	/*115*/
	"layer between two levels at specified pressure difference from ground to level",	/*116*/
	"potential vorticity (pv) level",	/*117*/
	"NAM level",	/*119*/
	"layer between two NAM levels",	/*120*/
	"layer between two isobaric surfaces (high precision)",	/*121*/
	"height level above ground (high precision)",	/*125*/
	"layer between two sigma levels (high precision)",	/*128*/
	"layer between two isobaric surfaces (mixed precision)",	/*141*/
	"depth below sea level",	/*160*/
	"entire atmosphere considered as a single layer",	/*200*/
	"entire ocean considered as a single layer",	/*201*/
	"highest tropospheric freezing level", /*"HTFL", 204*/
	"grid scale cloud bottom level", /*"GCBL", 206*/
	"grid scale cloud top level", /*"GCTL", 207*/
	"boundary layer cloud bottom level", /*"BCBL", 209*/
	"boundary layer cloud top level", /*"BCTL", 210*/
	"boundary layer cloud layer", /*"BCY",  211*/
	"low cloud bottom level", /*"LCBL", 212*/
	"low cloud top level", /*"LCTL", 213*/
	"low cloud layer", /*"LCY",  214*/
	"cloud ceiling",  /*"CEIL", 215*/
	"cumulonimbus base", /*"CBB",216*/
        "cumulonimbus top", /*CBT,217*/
	"planetary boundary layer (derived from Richardson number)", /*PBLRI, 220*/
	"middle cloud bottom level", /*"MCBL", 222*/
	"middle cloud top level", /*"MCTL", 223*/
	"middle cloud layer", /*"MCY",  224*/
	"high cloud bottom level", /*"HCBL", 232*/
	"high cloud top level", /*"HCTL", 233*/
	"high cloud layer", /*"HCY",  234*/
	"ocean isotherm level", /*"OITL", 235*/
	"layer between two depths below ocean surface", /*"OLYR", 236*/
	"bottom of ocean mixed layer", /*"OBML", 237*/
	"bottom of ocean isothermal layer", /*"OBIL", 238*/
	"layer ocean surface and 26C ocean isothermal level", /*"S26CY", 239*/
	"ocean mixed layer", /* "OMXL", 240*/
	"ordered sequence of data", /*"OSEQD",241*/
	"convective cloud bottom level", /*"CCBL", 242*/
	"convective cloud top level", /*"CCTL", 243*/
	"convective cloud layer", /*"CCY",  244*/
	"lowest level of the web bulb zero", /*"LLTW", 245*/
	"maximum equivalent potential temperature level", /*"MTHE", 246*/
	"equilibrium level", /*"EHLT", 247*/
	"shallow convective cloud bottom level", /*"SCBL", 248*/
	"shallow convective cloud top level", /*"SCTL", 249*/
	"deep convective cloud bottom level", /*"DCBL", 251*/
	"deep convective cloud top level",  /*"DCTL"  252*/
	/* ecmwf local */
	"isobaric surface (high precision)", /* "ISBH",  210 */
	/* jra55 local */
	"entire soil (considered as a single layer)", /* "ESOIL", 211 */
	"bottom of land surface model",  /*"BLSM",  212 */
	"underground layer number of land surface model" /* "ULN"   213 */
};
	
int time_range_indicator[] = {0,1,2,3,4,5,6,7,10,51,113,114,115,116,117,118,119,123,124,125,128,129,130,131,132,133,134,135,136,137,138,139,140};

int jra55_local_time_range_indicator[] = {128,129,130,131,132};
int jra55_local_time_range_indicator_start = sizeof(time_range_indicator) / sizeof(int);

char *time_range_descriptor[] = {
	"forecast product or uninitialized analysis product", /* 0 */
	"initialized analysis product", /* 1 */
	"product with specified valid time range", /* 2 */
	"average", /* 3 */
	"accumulation", /* 4 */
	"difference (value at the end of the time range minus value at the beginning)", /* 5 */
	"average", /* 6  */
	"accumulation", /* 7  */
	"product with specified valid time", /* 10  */
	"climatological mean value: multiple year averages of quantities which are themselves means over some period of time less than a year", /* 51  */
	"average of N forecasts (or initialized analyses)", /* 113 */
	"accumulation of N forecasts (or initialized analyses)", /* 114 */
	"average of N forecasts all with the same reference time", /* 115 */
	"accumulation of N forecasts all with the same reference time", /* 116 */
	"average of N forecasts with the varying initial time, but the same valid time", /* 117 */
	"temporal variance, or covariance, of N initialized analyses", /* 118 */
	"standard deviation of N forecasts", /* 119 */
	"average of N uninitialized analyses", /* 123 */
	"accumulation of N uninitialized analyses", /* 124 */
	"standard deviation of N forecasts", /* 125 */
	"Average of forecast accumulations, forecasts at 24-hour intervals.", /* 128  */
	"Average of successive forecast accumulations, forecasts at specified intervals.", /* 129  */
	"Average of forecast averages, forecasts at 24-hour intervals.", /* 130  */
	"Average of successive forecast averages, forecasts at specified intervals.", /* 131  */
	"climatological average of N analyses, each a year apart and each of an equal specified duration.", /* 132 */
	"climatological average of N forecasts, each a year apart and each of an equal specified duration.", /* 133 */
	"climatological root mean square difference between N forecasts and their verifying analyses, each a year apart, each of an equal specified duration.", /* 134 */
	"climatological standard deviation of N forecasts from the mean of the same N forecasts, for forecasts one year apart, each of an equal specified duration.", /* 135 */
	"climatological standard deviation of N analyses from the mean of the same N analyses, for analyses one year apart, each of an equal specified duration.", /* 136 */
	"average of forecast accumulations, each of an equal specified duration, with 6-hour intervals between forecasts.", /* 137 */
	"average of forecast averages, each of an equal specified duration, with 6-hour intervals between forecasts.", /* 138 */
	"average of forecast accumulations, each of an equal specified duration, with 12-hour intervals between forecasts.", /* 139 */
	"average of forecast averages, each of an equal specified duration, with 12-hour intervals between forecasts.", /* 140 */
	/* start of JRA55 */
	"average of N forecast products with a valid time of a specified duration; products have reference times at 24-hour intervals.", /* 128 */
	"temporal variance of N forecasts; each product has valid time of a specified duration; products have reference times at 24-hour intervals; unit of measurement is square of units given for parameter.", /* 129 */
	"average of N forecast products; valid time of equal specified duration with all N products covering a continuous time span.", /* 130 */
	"temporal variance of N forecasts; valid time of equal specified duration with all N products covering a continuous time span; unit of measurement is square of units given for parameter.", /* 131 */
	"temporal variance of N uninitialized analyses or instantaneous forecasts with valid times at equal specified intervals; unit of measurement is square of units given for parameter." /* 132 */
};
