/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.fabric;

import com.mysql.cj.fabric.ShardIndex;
import com.mysql.cj.fabric.ShardTable;
import com.mysql.cj.fabric.ShardingType;
import java.util.Collections;
import java.util.Set;

public abstract class ShardMapping {
    private int mappingId;
    private ShardingType shardingType;
    private String globalGroupName;
    protected Set<ShardTable> shardTables;
    protected Set<ShardIndex> shardIndices;

    public ShardMapping(int mappingId, ShardingType shardingType, String globalGroupName, Set<ShardTable> shardTables, Set<ShardIndex> shardIndices) {
        this.mappingId = mappingId;
        this.shardingType = shardingType;
        this.globalGroupName = globalGroupName;
        this.shardTables = shardTables;
        this.shardIndices = shardIndices;
    }

    public String getGroupNameForKey(String key) {
        return this.getShardIndexForKey(key).getGroupName();
    }

    protected abstract ShardIndex getShardIndexForKey(String var1);

    public int getMappingId() {
        return this.mappingId;
    }

    public ShardingType getShardingType() {
        return this.shardingType;
    }

    public String getGlobalGroupName() {
        return this.globalGroupName;
    }

    public Set<ShardTable> getShardTables() {
        return Collections.unmodifiableSet(this.shardTables);
    }

    public Set<ShardIndex> getShardIndices() {
        return Collections.unmodifiableSet(this.shardIndices);
    }
}

