/*
 * This file is part of system-settings
 *
 * Copyright (C) 2014-2016 Canonical Ltd.
 *
 * Contact: Jonas G. Drange <jonas.drange@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.12
import QtQuick.Layouts 1.1
import SystemSettings 1.0
import SystemSettings.ListItems 1.0 as SettingsListItems
import Lomiri.Components 1.3
import Lomiri.SystemSettings.Wifi 1.0

ItemPage {
    id: root
    property string networkName
    property var accessPoint

    title: i18n.tr("Network details")
    flickable: networkDetailBriefFlickable

    property var networkProperties: DbusHelper.networkPropertiesModel

    Flickable {
        id: networkDetailBriefFlickable
        anchors.fill: parent
        contentHeight: contentItem.childrenRect.height
        boundsBehavior: (contentHeight > root.height) ?
                            Flickable.DragAndOvershootBounds :
                            Flickable.StopAtBounds
        /* Set the direction to workaround
           https://bugreports.qt-project.org/browse/QTBUG-31905 otherwise the UI
           might end up in a situation where scrolling doesn't work */
        flickableDirection: Flickable.VerticalFlick

        Column {
            anchors.left: parent.left
            anchors.right: parent.right

            SettingsListItems.SingleValue {
                text: i18n.tr("Name")
                value: networkName
            }

            SettingsListItems.Standard {
                id: passwordLabel
                text: i18n.tr("Password")
                visible: networkProperties.password.length !== 0

                TextInput {
                    id: passwordField
                    color: theme.palette.normal.foregroundText
                    readOnly: true
                    text: networkProperties.password
                    echoMode: passwordVisibleSwitch.checked ?
                        TextInput.Normal : TextInput.Password
                }
            }

            SettingsListItems.Standard {
                id: passwordVisible
                text: i18n.tr("Show password")
                visible: networkProperties.password.length !== 0

                Switch {
                    id: passwordVisibleSwitch
                }
            }

            Repeater {
                id: ipAddressRepeater
                model: networkProperties.ipAddress

                delegate: SettingsListItems.SingleValue {
                    text: i18n.tr("IP address")
                    value: networkProperties.ipAddress[index]
                }
            }

            SettingsListItems.SingleValue {
                text: i18n.tr("Netmask")
                id: netmaskItem
                value: networkProperties.netmask
            }

            SettingsListItems.SingleValue {
                text: i18n.tr("Gateway")
                id: gatewayItem
                value: networkProperties.gateway
            }

            SettingsListItems.SingleControl {
                Button {
                    text : i18n.tr("Forget this network")
                    color: theme.palette.normal.negative
                    anchors {
                        left: parent.left
                        right: parent.right
                        margins: units.gu(2)
                    }
                    onClicked: {
                        if (DbusHelper.forgetActiveDevice()) {
                            accessPoint.checked = false;
                            accessPoint.checkedChanged(false);
                            pageStack.removePages(root);
                        }
                    }
                }
            }
        }
    }
}
