; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-max-iterations-verify -attributor-annotate-decl-cs -attributor-max-iterations=1 -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

declare void @unknown()

declare void @bar(ptr)

define void @foo() {
; CHECK-LABEL: define {{[^@]+}}@foo() {
; CHECK-NEXT:    [[X:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @unknown()
; CHECK-NEXT:    call void @bar(ptr noundef nonnull align 4 dereferenceable(4) [[X]])
; CHECK-NEXT:    ret void
;
  %x = alloca i32
  call void @unknown()
  call void @bar(ptr %x)
  ret void
}

define internal ptr @returned_dead() {
; CHECK-LABEL: define {{[^@]+}}@returned_dead() {
; CHECK-NEXT:    call void @unknown()
; CHECK-NEXT:    ret ptr undef
;
  call void @unknown()
  ret ptr null
}

define void @caller1() {
; CHECK-LABEL: define {{[^@]+}}@caller1() {
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @returned_dead()
; CHECK-NEXT:    ret void
;
  call ptr @returned_dead()
  ret void
}

define internal void @argument_dead_callback_callee(ptr %c) {
; CHECK-LABEL: define {{[^@]+}}@argument_dead_callback_callee
; CHECK-SAME: (ptr noalias nocapture nofree readnone align 4294967296 [[C:%.*]]) {
; CHECK-NEXT:    call void @unknown()
; CHECK-NEXT:    ret void
;
  call void @unknown()
  ret void
}

define void @callback_caller() {
; TUNIT-LABEL: define {{[^@]+}}@callback_caller() {
; TUNIT-NEXT:    call void @callback_broker(ptr noundef @argument_dead_callback_callee, ptr noalias nocapture nofree readnone align 4294967296 undef)
; TUNIT-NEXT:    ret void
;
; CGSCC-LABEL: define {{[^@]+}}@callback_caller() {
; CGSCC-NEXT:    call void @callback_broker(ptr noundef @argument_dead_callback_callee, ptr noalias nocapture nofree noundef readnone align 4294967296 null)
; CGSCC-NEXT:    ret void
;
  call void @callback_broker(ptr @argument_dead_callback_callee, ptr null)
  ret void
}

; Drop the noundef if when we replace the call argument with `undef`. We use a
; varargs function as we cannot (yet) rewrite their signature. If we ever can,
; try to come up with a different scheme to verify the `noundef` is dropped if
; signature rewriting is not happening.
define internal void @callee_with_dead_noundef_arg(i1 noundef %create, ...) {
; TUNIT-LABEL: define {{[^@]+}}@callee_with_dead_noundef_arg
; TUNIT-SAME: (i1 [[CREATE:%.*]], ...) {
; TUNIT-NEXT:    call void @unknown()
; TUNIT-NEXT:    ret void
;
; CGSCC-LABEL: define {{[^@]+}}@callee_with_dead_noundef_arg
; CGSCC-SAME: (i1 noundef [[CREATE:%.*]], ...) {
; CGSCC-NEXT:    call void @unknown()
; CGSCC-NEXT:    ret void
;
  call void @unknown()
  ret void
}

define void @caller_with_unused_arg(i1 %c) {
; TUNIT-LABEL: define {{[^@]+}}@caller_with_unused_arg
; TUNIT-SAME: (i1 [[C:%.*]]) {
; TUNIT-NEXT:    call void (i1, ...) @callee_with_dead_noundef_arg(i1 undef)
; TUNIT-NEXT:    ret void
;
; CGSCC-LABEL: define {{[^@]+}}@caller_with_unused_arg
; CGSCC-SAME: (i1 noundef [[C:%.*]]) {
; CGSCC-NEXT:    call void (i1, ...) @callee_with_dead_noundef_arg(i1 noundef [[C]])
; CGSCC-NEXT:    ret void
;
  call void (i1, ...) @callee_with_dead_noundef_arg(i1 %c)
  ret void
}

define internal void @callee_with_dead_arg(i1 %create, ...) {
;
; CHECK-LABEL: define {{[^@]+}}@callee_with_dead_arg
; CHECK-SAME: (i1 [[CREATE:%.*]], ...) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[IF_THEN3:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    unreachable
; CHECK:       if.then3:
; CHECK-NEXT:    call void @unknown()
; CHECK-NEXT:    ret void
;
entry:
  br i1 %create, label %if.then3, label %if.then

if.then:                                          ; preds = %entry
  ret void

if.then3:                                         ; preds = %entry
  call void @unknown()
  ret void
}

; Drop the noundef if when we replace the call argument with `undef`. We use a
; varargs function as we cannot (yet) rewrite their signature. If we ever can,
; try to come up with a different scheme to verify the `noundef` is dropped if
; signature rewriting is not happening.
define void @caller_with_noundef_arg() {
;
; TUNIT-LABEL: define {{[^@]+}}@caller_with_noundef_arg() {
; TUNIT-NEXT:    call void (i1, ...) @callee_with_dead_arg(i1 undef)
; TUNIT-NEXT:    ret void
;
; CGSCC-LABEL: define {{[^@]+}}@caller_with_noundef_arg() {
; CGSCC-NEXT:    call void (i1, ...) @callee_with_dead_arg(i1 noundef true)
; CGSCC-NEXT:    ret void
;
  call void (i1, ...) @callee_with_dead_arg(i1 noundef true)
  ret void
}

declare !callback !0 void @callback_broker(ptr, ptr)
!1 = !{i64 0, i64 1, i1 false}
!0 = !{!1}
;.
; CHECK: [[META0:![0-9]+]] = !{!1}
; CHECK: [[META1:![0-9]+]] = !{i64 0, i64 1, i1 false}
;.
