/* GTK - The GIMP Tool Kit
 * Copyright (C) 2007, 2008 GNOME Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * File auto-generated from script found at http://bugzilla.gnome.org/show_bug.cgi?id=321896
 * using the input files
 *  Input   : http://cgit.freedesktop.org/xorg/lib/libX11/plain/nls/en_US.UTF-8/Compose.pre
 *  Input   : http://www.cl.cam.ac.uk/~mgk25/ucs/keysyms.txt
 *  Input   : http://www.unicode.org/Public/UNIDATA/UnicodeData.txt
 *
 * This table is optimised for space and requires special handling to access the content.
 * This table is used solely by http://svn.gnome.org/viewcvs/gtk%2B/trunk/gtk/gtkimcontextsimple.c
 * 
 * The resulting file is placed at http://svn.gnome.org/viewcvs/gtk%2B/trunk/gtk/gtkimcontextsimpleseqs.h
 * This file is described in bug report http://bugzilla.gnome.org/show_bug.cgi?id=321896
 */

/*
 * Modified by the GTK+ Team and others 2007, 2008.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_IM_CONTEXT_SIMPLE_SEQS_H__
#define __GTK_IM_CONTEXT_SIMPLE_SEQS_H__

/* === These are the original comments of the file; we keep for historical purposes ===
 *
 * The following table was generated from the X compose tables include with
 * XFree86 4.0 using a set of Perl scripts. Contact Owen Taylor <otaylor@redhat.com>
 * to obtain the relevant perl scripts.
 *
 * The following compose letter letter sequences confliced
 *   Dstroke/dstroke and ETH/eth; resolved to Dstroke (Croation, Vietnamese, Lappish), over
 *                                ETH (Icelandic, Faroese, old English, IPA)  [ D- -D d- -d ]
 *   Amacron/amacron and ordfeminine; resolved to ordfeminine                 [ _A A_ a_ _a ]
 *   Amacron/amacron and Atilde/atilde; resolved to atilde                    [ -A A- a- -a ]
 *   Omacron/Omacron and masculine; resolved to masculine                     [ _O O_ o_ _o ]
 *   Omacron/omacron and Otilde/atilde; resolved to otilde                    [ -O O- o- -o ]
 *
 * [ Amacron and Omacron are in Latin-4 (Baltic). ordfeminine and masculine are used for
 *   spanish. atilde and otilde are used at least for Portuguese ]
 *
 *   at and Aring; resolved to Aring                                          [ AA ]
 *   guillemotleft and caron; resolved to guillemotleft                       [ << ]
 *   ogonek and cedilla; resolved to cedilla                                  [ ,, ]
 *
 * This probably should be resolved by first checking an additional set of compose tables
 * that depend on the locale or selected input method.
 */

static const guint16 gtk_compose_seqs_compact[] = {
IBUS_KEY_Greek_accentdieresis, 180, 184, 184, 184, 184, 
IBUS_KEY_dead_grave, 184, 246, 333, 545, 545, 
IBUS_KEY_dead_acute, 545, 609, 705, 981, 981, 
IBUS_KEY_dead_circumflex, 981, 1105, 1105, 1305, 1305, 
IBUS_KEY_dead_tilde, 1305, 1389, 1452, 1592, 1592, 
IBUS_KEY_dead_macron, 1592, 1638, 1656, 1728, 1728, 
IBUS_KEY_dead_breve, 1728, 1778, 1778, 1802, 1802, 
IBUS_KEY_dead_abovedot, 1802, 1832, 1835, 1871, 1871, 
IBUS_KEY_dead_diaeresis, 1871, 1959, 1971, 1995, 1995, 
IBUS_KEY_dead_abovering, 1995, 2005, 2005, 2005, 2005, 
IBUS_KEY_dead_doubleacute, 2005, 2015, 2015, 2015, 2015, 
IBUS_KEY_dead_caron, 2015, 2057, 2057, 2065, 2065, 
IBUS_KEY_dead_cedilla, 2065, 2077, 2083, 2083, 2083, 
IBUS_KEY_dead_ogonek, 2083, 2093, 2093, 2093, 2093, 
IBUS_KEY_dead_iota, 2093, 2115, 2214, 2646, 3306, 
IBUS_KEY_dead_voiced_sound, 3306, 3352, 3352, 3352, 3352, 
IBUS_KEY_dead_semivoiced_sound, 3352, 3362, 3362, 3362, 3362, 
IBUS_KEY_dead_belowdot, 3362, 3378, 3378, 3394, 3394, 
IBUS_KEY_dead_hook, 3394, 3472, 3475, 3531, 3531, 
IBUS_KEY_dead_horn, 3531, 3541, 3541, 3541, 3541, 
IBUS_KEY_dead_stroke, 3541, 3629, 3641, 3641, 3641, 
IBUS_KEY_dead_psili, 3641, 3669, 3669, 3669, 3669, 
IBUS_KEY_dead_dasia, 3669, 3701, 3701, 3701, 3701, 
IBUS_KEY_dead_belowring, 3701, 3703, 3703, 3703, 3703, 
IBUS_KEY_dead_belowtilde, 3703, 3705, 3705, 3705, 3705, 
IBUS_KEY_dead_belowdiaeresis, 3705, 3705, 3708, 3708, 3708, 
IBUS_KEY_dead_belowcomma, 3708, 3722, 3722, 3722, 3722, 
IBUS_KEY_dead_currency, 3722, 3820, 3826, 3826, 3826, 
IBUS_KEY_dead_greek, 3826, 3928, 3952, 3952, 3952, 
IBUS_KEY_Multi_key, 3952, 3952, 10495, 14203, 16083, 
IBUS_KEY_Greek_iota,  0x0390, 
IBUS_KEY_Greek_upsilon,  0x03B0, 
IBUS_KEY_space,  0x0060, 
IBUS_KEY_V,  0x01DB, 
IBUS_KEY_v,  0x01DC, 
IBUS_KEY_nobreakspace,  0x0300, 
IBUS_KEY_Abreve,  0x1EB0, 
IBUS_KEY_abreve,  0x1EB1, 
IBUS_KEY_Emacron,  0x1E14, 
IBUS_KEY_emacron,  0x1E15, 
IBUS_KEY_Omacron,  0x1E50, 
IBUS_KEY_omacron,  0x1E51, 
IBUS_KEY_Cyrillic_ie,  0x0450, 
IBUS_KEY_Cyrillic_i,  0x045D, 
IBUS_KEY_Cyrillic_IE,  0x0400, 
IBUS_KEY_Cyrillic_I,  0x040D, 
IBUS_KEY_Greek_iotadieresis,  0x1FD2, 
IBUS_KEY_Greek_upsilondieresis,  0x1FE2, 
IBUS_KEY_Greek_ALPHA,  0x1FBA, 
IBUS_KEY_Greek_EPSILON,  0x1FC8, 
IBUS_KEY_Greek_ETA,  0x1FCA, 
IBUS_KEY_Greek_IOTA,  0x1FDA, 
IBUS_KEY_Greek_OMICRON,  0x1FF8, 
IBUS_KEY_Greek_UPSILON,  0x1FEA, 
IBUS_KEY_Greek_OMEGA,  0x1FFA, 
IBUS_KEY_Greek_alpha,  0x1F70, 
IBUS_KEY_Greek_epsilon,  0x1F72, 
IBUS_KEY_Greek_eta,  0x1F74, 
IBUS_KEY_Greek_iota,  0x1F76, 
IBUS_KEY_Greek_omicron,  0x1F78, 
IBUS_KEY_Greek_upsilon,  0x1F7A, 
IBUS_KEY_Greek_omega,  0x1F7C, 
IBUS_KEY_dead_grave,  0x0060, 
IBUS_KEY_dead_diaeresis, IBUS_KEY_Greek_iota,  0x1FD2, 
IBUS_KEY_dead_diaeresis, IBUS_KEY_Greek_upsilon,  0x1FE2, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_ALPHA,  0x1F0A, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_EPSILON,  0x1F1A, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_ETA,  0x1F2A, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_IOTA,  0x1F3A, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMICRON,  0x1F4A, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMEGA,  0x1F6A, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_alpha,  0x1F02, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_epsilon,  0x1F12, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_eta,  0x1F22, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_iota,  0x1F32, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_omicron,  0x1F42, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_upsilon,  0x1F52, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_omega,  0x1F62, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ALPHA,  0x1F0B, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_EPSILON,  0x1F1B, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ETA,  0x1F2B, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_IOTA,  0x1F3B, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMICRON,  0x1F4B, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_UPSILON,  0x1F5B, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMEGA,  0x1F6B, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_alpha,  0x1F03, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_epsilon,  0x1F13, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_eta,  0x1F23, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_iota,  0x1F33, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omicron,  0x1F43, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_upsilon,  0x1F53, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omega,  0x1F63, 
IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_U,  0x01DB, 
IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_u,  0x01DC, 
IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_Greek_iota,  0x1FD2, 
IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_Greek_upsilon,  0x1FE2, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F0B, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_EPSILON,  0x1F1B, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F2B, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_IOTA,  0x1F3B, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMICRON,  0x1F4B, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_UPSILON,  0x1F5B, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1F6B, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F03, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_epsilon,  0x1F13, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F23, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_iota,  0x1F33, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_omicron,  0x1F43, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_upsilon,  0x1F53, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1F63, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F0A, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_EPSILON,  0x1F1A, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F2A, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_IOTA,  0x1F3A, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_OMICRON,  0x1F4A, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1F6A, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F02, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_epsilon,  0x1F12, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F22, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_iota,  0x1F32, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_omicron,  0x1F42, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_upsilon,  0x1F52, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1F62, 
IBUS_KEY_Multi_key, IBUS_KEY_plus, IBUS_KEY_O,  0x1EDC, 
IBUS_KEY_Multi_key, IBUS_KEY_plus, IBUS_KEY_U,  0x1EEA, 
IBUS_KEY_Multi_key, IBUS_KEY_plus, IBUS_KEY_o,  0x1EDD, 
IBUS_KEY_Multi_key, IBUS_KEY_plus, IBUS_KEY_u,  0x1EEB, 
IBUS_KEY_Multi_key, IBUS_KEY_U, IBUS_KEY_A,  0x1EB0, 
IBUS_KEY_Multi_key, IBUS_KEY_U, IBUS_KEY_a,  0x1EB1, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_A,  0x1EA6, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_E,  0x1EC0, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_O,  0x1ED2, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_a,  0x1EA7, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_e,  0x1EC1, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_o,  0x1ED3, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_E,  0x1E14, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_O,  0x1E50, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_e,  0x1E15, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_o,  0x1E51, 
IBUS_KEY_Multi_key, IBUS_KEY_b, IBUS_KEY_A,  0x1EB0, 
IBUS_KEY_Multi_key, IBUS_KEY_b, IBUS_KEY_a,  0x1EB1, 
IBUS_KEY_Multi_key, IBUS_KEY_macron, IBUS_KEY_E,  0x1E14, 
IBUS_KEY_Multi_key, IBUS_KEY_macron, IBUS_KEY_O,  0x1E50, 
IBUS_KEY_Multi_key, IBUS_KEY_macron, IBUS_KEY_e,  0x1E15, 
IBUS_KEY_Multi_key, IBUS_KEY_macron, IBUS_KEY_o,  0x1E51, 
IBUS_KEY_space,  0x0027, 
IBUS_KEY_V,  0x01D7, 
IBUS_KEY_v,  0x01D8, 
IBUS_KEY_nobreakspace,  0x0301, 
IBUS_KEY_Abreve,  0x1EAE, 
IBUS_KEY_abreve,  0x1EAF, 
IBUS_KEY_Emacron,  0x1E16, 
IBUS_KEY_emacron,  0x1E17, 
IBUS_KEY_Utilde,  0x1E78, 
IBUS_KEY_omacron,  0x1E53, 
IBUS_KEY_utilde,  0x1E79, 
IBUS_KEY_Cyrillic_ghe,  0x0453, 
IBUS_KEY_Cyrillic_ka,  0x045C, 
IBUS_KEY_Cyrillic_GHE,  0x0403, 
IBUS_KEY_Cyrillic_KA,  0x040C, 
IBUS_KEY_Greek_iotadieresis,  0x0390, 
IBUS_KEY_Greek_upsilondieresis,  0x03B0, 
IBUS_KEY_Greek_ALPHA,  0x0386, 
IBUS_KEY_Greek_EPSILON,  0x0388, 
IBUS_KEY_Greek_ETA,  0x0389, 
IBUS_KEY_Greek_IOTA,  0x038A, 
IBUS_KEY_Greek_OMICRON,  0x038C, 
IBUS_KEY_Greek_UPSILON,  0x038E, 
IBUS_KEY_Greek_OMEGA,  0x038F, 
IBUS_KEY_Greek_alpha,  0x03AC, 
IBUS_KEY_Greek_epsilon,  0x03AD, 
IBUS_KEY_Greek_eta,  0x03AE, 
IBUS_KEY_Greek_iota,  0x03AF, 
IBUS_KEY_Greek_omicron,  0x03CC, 
IBUS_KEY_Greek_upsilon,  0x03CD, 
IBUS_KEY_Greek_omega,  0x03CE, 
IBUS_KEY_dead_acute,  0x00B4, 
IBUS_KEY_dead_diaeresis, IBUS_KEY_space,  0x0385, 
IBUS_KEY_dead_diaeresis, IBUS_KEY_Greek_iota,  0x0390, 
IBUS_KEY_dead_diaeresis, IBUS_KEY_Greek_upsilon,  0x03B0, 
IBUS_KEY_dead_stroke, IBUS_KEY_O,  0x01FE, 
IBUS_KEY_dead_stroke, IBUS_KEY_o,  0x01FF, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_ALPHA,  0x1F0C, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_EPSILON,  0x1F1C, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_ETA,  0x1F2C, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_IOTA,  0x1F3C, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMICRON,  0x1F4C, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMEGA,  0x1F6C, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_alpha,  0x1F04, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_epsilon,  0x1F14, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_eta,  0x1F24, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_iota,  0x1F34, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_omicron,  0x1F44, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_upsilon,  0x1F54, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_omega,  0x1F64, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ALPHA,  0x1F0D, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_EPSILON,  0x1F1D, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ETA,  0x1F2D, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_IOTA,  0x1F3D, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMICRON,  0x1F4D, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_UPSILON,  0x1F5D, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMEGA,  0x1F6D, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_alpha,  0x1F05, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_epsilon,  0x1F15, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_eta,  0x1F25, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_iota,  0x1F35, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omicron,  0x1F45, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_upsilon,  0x1F55, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omega,  0x1F65, 
IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_I,  0x1E2E, 
IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_U,  0x01D7, 
IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_i,  0x1E2F, 
IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_u,  0x01D8, 
IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_Greek_iota,  0x0390, 
IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_Greek_upsilon,  0x03B0, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F0D, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_EPSILON,  0x1F1D, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F2D, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_IOTA,  0x1F3D, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMICRON,  0x1F4D, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_UPSILON,  0x1F5D, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1F6D, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F05, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_epsilon,  0x1F15, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F25, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_iota,  0x1F35, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_omicron,  0x1F45, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_upsilon,  0x1F55, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1F65, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F0C, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_EPSILON,  0x1F1C, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F2C, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_IOTA,  0x1F3C, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_OMICRON,  0x1F4C, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1F6C, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F04, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_epsilon,  0x1F14, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F24, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_iota,  0x1F34, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_omicron,  0x1F44, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_upsilon,  0x1F54, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1F64, 
IBUS_KEY_Multi_key, IBUS_KEY_plus, IBUS_KEY_O,  0x1EDA, 
IBUS_KEY_Multi_key, IBUS_KEY_plus, IBUS_KEY_U,  0x1EE8, 
IBUS_KEY_Multi_key, IBUS_KEY_plus, IBUS_KEY_o,  0x1EDB, 
IBUS_KEY_Multi_key, IBUS_KEY_plus, IBUS_KEY_u,  0x1EE9, 
IBUS_KEY_Multi_key, IBUS_KEY_comma, IBUS_KEY_C,  0x1E08, 
IBUS_KEY_Multi_key, IBUS_KEY_comma, IBUS_KEY_c,  0x1E09, 
IBUS_KEY_Multi_key, IBUS_KEY_slash, IBUS_KEY_O,  0x01FE, 
IBUS_KEY_Multi_key, IBUS_KEY_slash, IBUS_KEY_o,  0x01FF, 
IBUS_KEY_Multi_key, IBUS_KEY_U, IBUS_KEY_A,  0x1EAE, 
IBUS_KEY_Multi_key, IBUS_KEY_U, IBUS_KEY_a,  0x1EAF, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_A,  0x1EA4, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_E,  0x1EBE, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_O,  0x1ED0, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_a,  0x1EA5, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_e,  0x1EBF, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_o,  0x1ED1, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_E,  0x1E16, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_O,  0x1E52, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_e,  0x1E17, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_o,  0x1E53, 
IBUS_KEY_Multi_key, IBUS_KEY_b, IBUS_KEY_A,  0x1EAE, 
IBUS_KEY_Multi_key, IBUS_KEY_b, IBUS_KEY_a,  0x1EAF, 
IBUS_KEY_Multi_key, IBUS_KEY_o, IBUS_KEY_A,  0x01FA, 
IBUS_KEY_Multi_key, IBUS_KEY_o, IBUS_KEY_a,  0x01FB, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_O,  0x1E4C, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_U,  0x1E78, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_o,  0x1E4D, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_u,  0x1E79, 
IBUS_KEY_Multi_key, IBUS_KEY_macron, IBUS_KEY_E,  0x1E16, 
IBUS_KEY_Multi_key, IBUS_KEY_macron, IBUS_KEY_O,  0x1E52, 
IBUS_KEY_Multi_key, IBUS_KEY_macron, IBUS_KEY_e,  0x1E17, 
IBUS_KEY_Multi_key, IBUS_KEY_macron, IBUS_KEY_o,  0x1E53, 
IBUS_KEY_Multi_key, IBUS_KEY_cedilla, IBUS_KEY_C,  0x1E08, 
IBUS_KEY_Multi_key, IBUS_KEY_cedilla, IBUS_KEY_c,  0x1E09, 
IBUS_KEY_Multi_key, IBUS_KEY_KP_Divide, IBUS_KEY_O,  0x01FE, 
IBUS_KEY_Multi_key, IBUS_KEY_KP_Divide, IBUS_KEY_o,  0x01FF, 
IBUS_KEY_space,  0x005E, 
IBUS_KEY_parenleft,  0x207D, 
IBUS_KEY_parenright,  0x207E, 
IBUS_KEY_plus,  0x207A, 
IBUS_KEY_minus,  0x207B, 
IBUS_KEY_0,  0x2070, 
IBUS_KEY_1,  0x00B9, 
IBUS_KEY_2,  0x00B2, 
IBUS_KEY_3,  0x00B3, 
IBUS_KEY_4,  0x2074, 
IBUS_KEY_5,  0x2075, 
IBUS_KEY_6,  0x2076, 
IBUS_KEY_7,  0x2077, 
IBUS_KEY_8,  0x2078, 
IBUS_KEY_9,  0x2079, 
IBUS_KEY_equal,  0x207C, 
IBUS_KEY_nobreakspace,  0x0302, 
IBUS_KEY_Agrave,  0x1EA6, 
IBUS_KEY_Aacute,  0x1EA4, 
IBUS_KEY_Atilde,  0x1EAA, 
IBUS_KEY_Egrave,  0x1EC0, 
IBUS_KEY_Eacute,  0x1EBE, 
IBUS_KEY_Ograve,  0x1ED2, 
IBUS_KEY_Oacute,  0x1ED0, 
IBUS_KEY_Otilde,  0x1ED6, 
IBUS_KEY_agrave,  0x1EA7, 
IBUS_KEY_aacute,  0x1EA5, 
IBUS_KEY_atilde,  0x1EAB, 
IBUS_KEY_egrave,  0x1EC1, 
IBUS_KEY_eacute,  0x1EBF, 
IBUS_KEY_ograve,  0x1ED3, 
IBUS_KEY_oacute,  0x1ED1, 
IBUS_KEY_otilde,  0x1ED7, 
0x2212,  0x207B, 
0x4E00,  0x3192, 
0x4E01,  0x319C, 
0x4E09,  0x3194, 
0x4E0A,  0x3196, 
0x4E0B,  0x3198, 
0x4E19,  0x319B, 
0x4E2D,  0x3197, 
0x4E59,  0x319A, 
0x4E8C,  0x3193, 
0x4EBA,  0x319F, 
0x56DB,  0x3195, 
0x5730,  0x319E, 
0x5929,  0x319D, 
0x7532,  0x3199, 
IBUS_KEY_dead_circumflex,  0x005E, 
IBUS_KEY_KP_Space,  0x00B2, 
IBUS_KEY_KP_Add,  0x207A, 
IBUS_KEY_KP_0,  0x2070, 
IBUS_KEY_KP_1,  0x00B9, 
IBUS_KEY_KP_2,  0x00B2, 
IBUS_KEY_KP_3,  0x00B3, 
IBUS_KEY_KP_4,  0x2074, 
IBUS_KEY_KP_5,  0x2075, 
IBUS_KEY_KP_6,  0x2076, 
IBUS_KEY_KP_7,  0x2077, 
IBUS_KEY_KP_8,  0x2078, 
IBUS_KEY_KP_9,  0x2079, 
IBUS_KEY_KP_Equal,  0x207C, 
IBUS_KEY_Multi_key, IBUS_KEY_exclam, IBUS_KEY_A,  0x1EAC, 
IBUS_KEY_Multi_key, IBUS_KEY_exclam, IBUS_KEY_E,  0x1EC6, 
IBUS_KEY_Multi_key, IBUS_KEY_exclam, IBUS_KEY_O,  0x1ED8, 
IBUS_KEY_Multi_key, IBUS_KEY_exclam, IBUS_KEY_a,  0x1EAD, 
IBUS_KEY_Multi_key, IBUS_KEY_exclam, IBUS_KEY_e,  0x1EC7, 
IBUS_KEY_Multi_key, IBUS_KEY_exclam, IBUS_KEY_o,  0x1ED9, 
IBUS_KEY_Multi_key, IBUS_KEY_S, IBUS_KEY_M,  0x2120, 
IBUS_KEY_Multi_key, IBUS_KEY_S, IBUS_KEY_m,  0x2120, 
IBUS_KEY_Multi_key, IBUS_KEY_T, IBUS_KEY_M,  0x2122, 
IBUS_KEY_Multi_key, IBUS_KEY_T, IBUS_KEY_m,  0x2122, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_a,  0x00AA, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_h,  0x02B0, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_i,  0x2071, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_j,  0x02B2, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_l,  0x02E1, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_n,  0x207F, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_o,  0x00BA, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_r,  0x02B3, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_s,  0x02E2, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_w,  0x02B7, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_x,  0x02E3, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_y,  0x02B8, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, 0x0263,  0x02E0, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, 0x0266,  0x02B1, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, 0x0279,  0x02B4, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, 0x027B,  0x02B5, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, 0x0281,  0x02B6, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, 0x0295,  0x02E4, 
IBUS_KEY_Multi_key, IBUS_KEY_s, IBUS_KEY_M,  0x2120, 
IBUS_KEY_Multi_key, IBUS_KEY_s, IBUS_KEY_m,  0x2120, 
IBUS_KEY_Multi_key, IBUS_KEY_t, IBUS_KEY_M,  0x2122, 
IBUS_KEY_Multi_key, IBUS_KEY_t, IBUS_KEY_m,  0x2122, 
IBUS_KEY_Multi_key, IBUS_KEY_underbar, IBUS_KEY_a,  0x00AA, 
IBUS_KEY_Multi_key, IBUS_KEY_underbar, IBUS_KEY_h,  0x02B0, 
IBUS_KEY_Multi_key, IBUS_KEY_underbar, IBUS_KEY_i,  0x2071, 
IBUS_KEY_Multi_key, IBUS_KEY_underbar, IBUS_KEY_j,  0x02B2, 
IBUS_KEY_Multi_key, IBUS_KEY_underbar, IBUS_KEY_l,  0x02E1, 
IBUS_KEY_Multi_key, IBUS_KEY_underbar, IBUS_KEY_n,  0x207F, 
IBUS_KEY_Multi_key, IBUS_KEY_underbar, IBUS_KEY_o,  0x00BA, 
IBUS_KEY_Multi_key, IBUS_KEY_underbar, IBUS_KEY_r,  0x02B3, 
IBUS_KEY_Multi_key, IBUS_KEY_underbar, IBUS_KEY_s,  0x02E2, 
IBUS_KEY_Multi_key, IBUS_KEY_underbar, IBUS_KEY_w,  0x02B7, 
IBUS_KEY_Multi_key, IBUS_KEY_underbar, IBUS_KEY_x,  0x02E3, 
IBUS_KEY_Multi_key, IBUS_KEY_underbar, IBUS_KEY_y,  0x02B8, 
IBUS_KEY_Multi_key, IBUS_KEY_underbar, 0x0263,  0x02E0, 
IBUS_KEY_Multi_key, IBUS_KEY_underbar, 0x0266,  0x02B1, 
IBUS_KEY_Multi_key, IBUS_KEY_underbar, 0x0279,  0x02B4, 
IBUS_KEY_Multi_key, IBUS_KEY_underbar, 0x027B,  0x02B5, 
IBUS_KEY_Multi_key, IBUS_KEY_underbar, 0x0281,  0x02B6, 
IBUS_KEY_Multi_key, IBUS_KEY_underbar, 0x0295,  0x02E4, 
IBUS_KEY_space,  0x007E, 
IBUS_KEY_less,  0x2272, 
IBUS_KEY_equal,  0x2243, 
IBUS_KEY_greater,  0x2273, 
IBUS_KEY_nobreakspace,  0x0303, 
IBUS_KEY_Oacute,  0x1E4C, 
IBUS_KEY_Odiaeresis,  0x1E4E, 
IBUS_KEY_Uacute,  0x1E78, 
IBUS_KEY_oacute,  0x1E4D, 
IBUS_KEY_odiaeresis,  0x1E4F, 
IBUS_KEY_uacute,  0x1E79, 
IBUS_KEY_Abreve,  0x1EB4, 
IBUS_KEY_abreve,  0x1EB5, 
IBUS_KEY_Omacron,  0x022C, 
IBUS_KEY_omacron,  0x022D, 
IBUS_KEY_Greek_iotadieresis,  0x1FD7, 
IBUS_KEY_Greek_upsilondieresis,  0x1FE7, 
IBUS_KEY_Greek_alpha,  0x1FB6, 
IBUS_KEY_Greek_eta,  0x1FC6, 
IBUS_KEY_Greek_iota,  0x1FD6, 
IBUS_KEY_Greek_upsilon,  0x1FE6, 
IBUS_KEY_Greek_omega,  0x1FF6, 
0x1F00,  0x1F06, 
0x1F01,  0x1F07, 
0x1F08,  0x1F0E, 
0x1F09,  0x1F0F, 
0x1F20,  0x1F26, 
0x1F21,  0x1F27, 
0x1F28,  0x1F2E, 
0x1F29,  0x1F2F, 
0x1F30,  0x1F36, 
0x1F31,  0x1F37, 
0x1F38,  0x1F3E, 
0x1F39,  0x1F3F, 
0x1F50,  0x1F56, 
0x1F51,  0x1F57, 
0x1F59,  0x1F5F, 
0x1F60,  0x1F66, 
0x1F61,  0x1F67, 
0x1F68,  0x1F6E, 
0x1F69,  0x1F6F, 
IBUS_KEY_dead_tilde,  0x007E, 
IBUS_KEY_dead_diaeresis, IBUS_KEY_Greek_iota,  0x1FD7, 
IBUS_KEY_dead_diaeresis, IBUS_KEY_Greek_upsilon,  0x1FE7, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_ALPHA,  0x1F0E, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_ETA,  0x1F2E, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_IOTA,  0x1F3E, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMEGA,  0x1F6E, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_alpha,  0x1F06, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_eta,  0x1F26, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_iota,  0x1F36, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_upsilon,  0x1F56, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_omega,  0x1F66, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ALPHA,  0x1F0F, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ETA,  0x1F2F, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_IOTA,  0x1F3F, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_UPSILON,  0x1F5F, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMEGA,  0x1F6F, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_alpha,  0x1F07, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_eta,  0x1F27, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_iota,  0x1F37, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_upsilon,  0x1F57, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omega,  0x1F67, 
IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_Greek_iota,  0x1FD7, 
IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_Greek_upsilon,  0x1FE7, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F0F, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F2F, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_IOTA,  0x1F3F, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_UPSILON,  0x1F5F, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1F6F, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F07, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F27, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_iota,  0x1F37, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_upsilon,  0x1F57, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1F67, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F0E, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F2E, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_IOTA,  0x1F3E, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1F6E, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F06, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F26, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_iota,  0x1F36, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_upsilon,  0x1F56, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1F66, 
IBUS_KEY_Multi_key, IBUS_KEY_plus, IBUS_KEY_O,  0x1EE0, 
IBUS_KEY_Multi_key, IBUS_KEY_plus, IBUS_KEY_U,  0x1EEE, 
IBUS_KEY_Multi_key, IBUS_KEY_plus, IBUS_KEY_o,  0x1EE1, 
IBUS_KEY_Multi_key, IBUS_KEY_plus, IBUS_KEY_u,  0x1EEF, 
IBUS_KEY_Multi_key, IBUS_KEY_U, IBUS_KEY_A,  0x1EB4, 
IBUS_KEY_Multi_key, IBUS_KEY_U, IBUS_KEY_a,  0x1EB5, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_A,  0x1EAA, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_E,  0x1EC4, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_O,  0x1ED6, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_a,  0x1EAB, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_e,  0x1EC5, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_o,  0x1ED7, 
IBUS_KEY_Multi_key, IBUS_KEY_b, IBUS_KEY_A,  0x1EB4, 
IBUS_KEY_Multi_key, IBUS_KEY_b, IBUS_KEY_a,  0x1EB5, 
IBUS_KEY_space,  0x00AF, 
IBUS_KEY_V,  0x01D5, 
IBUS_KEY_v,  0x01D6, 
IBUS_KEY_nobreakspace,  0x0304, 
IBUS_KEY_Egrave,  0x1E14, 
IBUS_KEY_Eacute,  0x1E16, 
IBUS_KEY_Ograve,  0x1E50, 
IBUS_KEY_Oacute,  0x1E52, 
IBUS_KEY_egrave,  0x1E15, 
IBUS_KEY_eacute,  0x1E17, 
IBUS_KEY_ograve,  0x1E51, 
IBUS_KEY_oacute,  0x1E53, 
IBUS_KEY_Cyrillic_i,  0x04E3, 
IBUS_KEY_Cyrillic_u,  0x04EF, 
IBUS_KEY_Cyrillic_I,  0x04E2, 
IBUS_KEY_Cyrillic_U,  0x04EE, 
IBUS_KEY_Greek_ALPHA,  0x1FB9, 
IBUS_KEY_Greek_IOTA,  0x1FD9, 
IBUS_KEY_Greek_UPSILON,  0x1FE9, 
IBUS_KEY_Greek_alpha,  0x1FB1, 
IBUS_KEY_Greek_iota,  0x1FD1, 
IBUS_KEY_Greek_upsilon,  0x1FE1, 
IBUS_KEY_dead_macron,  0x00AF, 
IBUS_KEY_dead_greek, IBUS_KEY_A,  0x1FB9, 
IBUS_KEY_dead_greek, IBUS_KEY_I,  0x1FD9, 
IBUS_KEY_dead_greek, IBUS_KEY_U,  0x1FE9, 
IBUS_KEY_dead_greek, IBUS_KEY_a,  0x1FB1, 
IBUS_KEY_dead_greek, IBUS_KEY_i,  0x1FD1, 
IBUS_KEY_dead_greek, IBUS_KEY_u,  0x1FE1, 
IBUS_KEY_Multi_key, IBUS_KEY_exclam, IBUS_KEY_L,  0x1E38, 
IBUS_KEY_Multi_key, IBUS_KEY_exclam, IBUS_KEY_R,  0x1E5C, 
IBUS_KEY_Multi_key, IBUS_KEY_exclam, IBUS_KEY_l,  0x1E39, 
IBUS_KEY_Multi_key, IBUS_KEY_exclam, IBUS_KEY_r,  0x1E5D, 
IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_A,  0x01DE, 
IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_O,  0x022A, 
IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_U,  0x01D5, 
IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_a,  0x01DF, 
IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_o,  0x022B, 
IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_u,  0x01D6, 
IBUS_KEY_Multi_key, IBUS_KEY_period, IBUS_KEY_A,  0x01E0, 
IBUS_KEY_Multi_key, IBUS_KEY_period, IBUS_KEY_O,  0x0230, 
IBUS_KEY_Multi_key, IBUS_KEY_period, IBUS_KEY_a,  0x01E1, 
IBUS_KEY_Multi_key, IBUS_KEY_period, IBUS_KEY_o,  0x0231, 
IBUS_KEY_Multi_key, IBUS_KEY_semicolon, IBUS_KEY_O,  0x01EC, 
IBUS_KEY_Multi_key, IBUS_KEY_semicolon, IBUS_KEY_o,  0x01ED, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_O,  0x022C, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_o,  0x022D, 
IBUS_KEY_space,  0x02D8, 
IBUS_KEY_nobreakspace,  0x0306, 
IBUS_KEY_Agrave,  0x1EB0, 
IBUS_KEY_Aacute,  0x1EAE, 
IBUS_KEY_Atilde,  0x1EB4, 
IBUS_KEY_agrave,  0x1EB1, 
IBUS_KEY_aacute,  0x1EAF, 
IBUS_KEY_atilde,  0x1EB5, 
IBUS_KEY_Cyrillic_a,  0x04D1, 
IBUS_KEY_Cyrillic_ie,  0x04D7, 
IBUS_KEY_Cyrillic_i,  0x0439, 
IBUS_KEY_Cyrillic_u,  0x045E, 
IBUS_KEY_Cyrillic_zhe,  0x04C2, 
IBUS_KEY_Cyrillic_A,  0x04D0, 
IBUS_KEY_Cyrillic_IE,  0x04D6, 
IBUS_KEY_Cyrillic_I,  0x0419, 
IBUS_KEY_Cyrillic_U,  0x040E, 
IBUS_KEY_Cyrillic_ZHE,  0x04C1, 
IBUS_KEY_Greek_ALPHA,  0x1FB8, 
IBUS_KEY_Greek_IOTA,  0x1FD8, 
IBUS_KEY_Greek_UPSILON,  0x1FE8, 
IBUS_KEY_Greek_alpha,  0x1FB0, 
IBUS_KEY_Greek_iota,  0x1FD0, 
IBUS_KEY_Greek_upsilon,  0x1FE0, 
IBUS_KEY_dead_breve,  0x02D8, 
IBUS_KEY_Multi_key, IBUS_KEY_exclam, IBUS_KEY_A,  0x1EB6, 
IBUS_KEY_Multi_key, IBUS_KEY_exclam, IBUS_KEY_a,  0x1EB7, 
IBUS_KEY_Multi_key, IBUS_KEY_comma, IBUS_KEY_E,  0x1E1C, 
IBUS_KEY_Multi_key, IBUS_KEY_comma, IBUS_KEY_e,  0x1E1D, 
IBUS_KEY_Multi_key, IBUS_KEY_cedilla, IBUS_KEY_E,  0x1E1C, 
IBUS_KEY_Multi_key, IBUS_KEY_cedilla, IBUS_KEY_e,  0x1E1D, 
IBUS_KEY_space,  0x02D9, 
IBUS_KEY_L,  0x013F, 
IBUS_KEY_i,  0x0131, 
IBUS_KEY_j,  0x0237, 
IBUS_KEY_l,  0x0140, 
IBUS_KEY_nobreakspace,  0x0307, 
IBUS_KEY_Sacute,  0x1E64, 
IBUS_KEY_Scaron,  0x1E66, 
IBUS_KEY_sacute,  0x1E65, 
IBUS_KEY_scaron,  0x1E67, 
IBUS_KEY_Amacron,  0x01E0, 
IBUS_KEY_Omacron,  0x0230, 
IBUS_KEY_amacron,  0x01E1, 
IBUS_KEY_omacron,  0x0231, 
IBUS_KEY_dead_abovedot,  0x02D9, 
IBUS_KEY_dead_stroke, IBUS_KEY_j,  0x025F, 
IBUS_KEY_Multi_key, IBUS_KEY_exclam, IBUS_KEY_S,  0x1E68, 
IBUS_KEY_Multi_key, IBUS_KEY_exclam, IBUS_KEY_s,  0x1E69, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_S,  0x1E64, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_s,  0x1E65, 
IBUS_KEY_Multi_key, IBUS_KEY_c, IBUS_KEY_S,  0x1E66, 
IBUS_KEY_Multi_key, IBUS_KEY_c, IBUS_KEY_s,  0x1E67, 
IBUS_KEY_Multi_key, IBUS_KEY_f, IBUS_KEY_s,  0x1E9B, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_S,  0x1E64, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_s,  0x1E65, 
IBUS_KEY_space,  0x0022, 
IBUS_KEY_apostrophe,  0x0344, 
IBUS_KEY_nobreakspace,  0x0308, 
IBUS_KEY_acute,  0x0344, 
IBUS_KEY_Iacute,  0x1E2E, 
IBUS_KEY_Ugrave,  0x01DB, 
IBUS_KEY_Uacute,  0x01D7, 
IBUS_KEY_iacute,  0x1E2F, 
IBUS_KEY_ugrave,  0x01DC, 
IBUS_KEY_uacute,  0x01D8, 
0x01D3,  0x01D9, 
0x01D4,  0x01DA, 
IBUS_KEY_Amacron,  0x01DE, 
IBUS_KEY_Umacron,  0x1E7A, 
IBUS_KEY_amacron,  0x01DF, 
IBUS_KEY_omacron,  0x022B, 
IBUS_KEY_umacron,  0x1E7B, 
IBUS_KEY_Ukrainian_i,  0x0457, 
IBUS_KEY_Ukrainian_I,  0x0407, 
IBUS_KEY_Cyrillic_a,  0x04D3, 
IBUS_KEY_Cyrillic_ie,  0x0451, 
IBUS_KEY_Cyrillic_i,  0x04E5, 
IBUS_KEY_Cyrillic_o,  0x04E7, 
IBUS_KEY_Cyrillic_u,  0x04F1, 
IBUS_KEY_Cyrillic_zhe,  0x04DD, 
IBUS_KEY_Cyrillic_yeru,  0x04F9, 
IBUS_KEY_Cyrillic_ze,  0x04DF, 
IBUS_KEY_Cyrillic_e,  0x04ED, 
IBUS_KEY_Cyrillic_che,  0x04F5, 
IBUS_KEY_Cyrillic_A,  0x04D2, 
IBUS_KEY_Cyrillic_IE,  0x0401, 
IBUS_KEY_Cyrillic_I,  0x04E4, 
IBUS_KEY_Cyrillic_O,  0x04E6, 
IBUS_KEY_Cyrillic_U,  0x04F0, 
IBUS_KEY_Cyrillic_ZHE,  0x04DC, 
IBUS_KEY_Cyrillic_YERU,  0x04F8, 
IBUS_KEY_Cyrillic_ZE,  0x04DE, 
IBUS_KEY_Cyrillic_E,  0x04EC, 
IBUS_KEY_Cyrillic_CHE,  0x04F4, 
IBUS_KEY_Greek_IOTA,  0x03AA, 
IBUS_KEY_Greek_UPSILON,  0x03AB, 
IBUS_KEY_Greek_iota,  0x03CA, 
IBUS_KEY_Greek_upsilon,  0x03CB, 
IBUS_KEY_dead_diaeresis,  0x00A8, 
IBUS_KEY_dead_acute, IBUS_KEY_space,  0x0385, 
IBUS_KEY_dead_acute, IBUS_KEY_Greek_iota,  0x0390, 
IBUS_KEY_dead_acute, IBUS_KEY_Greek_upsilon,  0x03B0, 
IBUS_KEY_dead_belowdiaeresis, IBUS_KEY_equal,  0x2A77, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_U,  0x1E7A, 
IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_u,  0x1E7B, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_O,  0x1E4E, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_o,  0x1E4F, 
IBUS_KEY_Multi_key, IBUS_KEY_macron, IBUS_KEY_U,  0x1E7A, 
IBUS_KEY_Multi_key, IBUS_KEY_macron, IBUS_KEY_u,  0x1E7B, 
IBUS_KEY_space,  0x00B0, 
IBUS_KEY_nobreakspace,  0x030A, 
IBUS_KEY_Aacute,  0x01FA, 
IBUS_KEY_aacute,  0x01FB, 
IBUS_KEY_dead_abovering,  0x00B0, 
IBUS_KEY_space,  0x02DD, 
IBUS_KEY_nobreakspace,  0x030B, 
IBUS_KEY_Cyrillic_u,  0x04F3, 
IBUS_KEY_Cyrillic_U,  0x04F2, 
IBUS_KEY_dead_doubleacute,  0x02DD, 
IBUS_KEY_space,  0x02C7, 
IBUS_KEY_parenleft,  0x208D, 
IBUS_KEY_parenright,  0x208E, 
IBUS_KEY_plus,  0x208A, 
IBUS_KEY_minus,  0x208B, 
IBUS_KEY_0,  0x2080, 
IBUS_KEY_1,  0x2081, 
IBUS_KEY_2,  0x2082, 
IBUS_KEY_3,  0x2083, 
IBUS_KEY_4,  0x2084, 
IBUS_KEY_5,  0x2085, 
IBUS_KEY_6,  0x2086, 
IBUS_KEY_7,  0x2087, 
IBUS_KEY_8,  0x2088, 
IBUS_KEY_9,  0x2089, 
IBUS_KEY_equal,  0x208C, 
IBUS_KEY_V,  0x01D9, 
IBUS_KEY_v,  0x01DA, 
IBUS_KEY_nobreakspace,  0x030C, 
0x01F2,  0x01C5, 
IBUS_KEY_dead_caron,  0x02C7, 
IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_U,  0x01D9, 
IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_u,  0x01DA, 
IBUS_KEY_space,  0x00B8, 
IBUS_KEY_nobreakspace,  0x0327, 
IBUS_KEY_cent,  0x20B5, 
IBUS_KEY_Cacute,  0x1E08, 
IBUS_KEY_cacute,  0x1E09, 
IBUS_KEY_dead_cedilla,  0x00B8, 
IBUS_KEY_dead_currency, IBUS_KEY_C,  0x20B5, 
IBUS_KEY_dead_currency, IBUS_KEY_c,  0x20B5, 
IBUS_KEY_space,  0x02DB, 
IBUS_KEY_nobreakspace,  0x0328, 
IBUS_KEY_Omacron,  0x01EC, 
IBUS_KEY_omacron,  0x01ED, 
IBUS_KEY_dead_ogonek,  0x02DB, 
IBUS_KEY_space,  0x037A, 
IBUS_KEY_Greek_alphaaccent,  0x1FB4, 
IBUS_KEY_Greek_etaaccent,  0x1FC4, 
IBUS_KEY_Greek_omegaaccent,  0x1FF4, 
IBUS_KEY_Greek_ALPHA,  0x1FBC, 
IBUS_KEY_Greek_ETA,  0x1FCC, 
IBUS_KEY_Greek_OMEGA,  0x1FFC, 
IBUS_KEY_Greek_alpha,  0x1FB3, 
IBUS_KEY_Greek_eta,  0x1FC3, 
IBUS_KEY_Greek_omega,  0x1FF3, 
IBUS_KEY_dead_iota,  0x037A, 
IBUS_KEY_dead_grave, IBUS_KEY_Greek_alpha,  0x1FB2, 
IBUS_KEY_dead_grave, IBUS_KEY_Greek_eta,  0x1FC2, 
IBUS_KEY_dead_grave, IBUS_KEY_Greek_omega,  0x1FF2, 
IBUS_KEY_dead_acute, IBUS_KEY_Greek_alpha,  0x1FB4, 
IBUS_KEY_dead_acute, IBUS_KEY_Greek_eta,  0x1FC4, 
IBUS_KEY_dead_acute, IBUS_KEY_Greek_omega,  0x1FF4, 
IBUS_KEY_dead_tilde, IBUS_KEY_Greek_alpha,  0x1FB7, 
IBUS_KEY_dead_tilde, IBUS_KEY_Greek_eta,  0x1FC7, 
IBUS_KEY_dead_tilde, IBUS_KEY_Greek_omega,  0x1FF7, 
IBUS_KEY_dead_tilde, 0x1F00,  0x1F86, 
IBUS_KEY_dead_tilde, 0x1F01,  0x1F87, 
IBUS_KEY_dead_tilde, 0x1F08,  0x1F8E, 
IBUS_KEY_dead_tilde, 0x1F09,  0x1F8F, 
IBUS_KEY_dead_tilde, 0x1F20,  0x1F96, 
IBUS_KEY_dead_tilde, 0x1F21,  0x1F97, 
IBUS_KEY_dead_tilde, 0x1F28,  0x1F9E, 
IBUS_KEY_dead_tilde, 0x1F29,  0x1F9F, 
IBUS_KEY_dead_tilde, 0x1F60,  0x1FA6, 
IBUS_KEY_dead_tilde, 0x1F61,  0x1FA7, 
IBUS_KEY_dead_tilde, 0x1F68,  0x1FAE, 
IBUS_KEY_dead_tilde, 0x1F69,  0x1FAF, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_ALPHA,  0x1F88, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_ETA,  0x1F98, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMEGA,  0x1FA8, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_alpha,  0x1F80, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_eta,  0x1F90, 
IBUS_KEY_dead_psili, IBUS_KEY_Greek_omega,  0x1FA0, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ALPHA,  0x1F89, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ETA,  0x1F99, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMEGA,  0x1FA9, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_alpha,  0x1F81, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_eta,  0x1F91, 
IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omega,  0x1FA1, 
IBUS_KEY_dead_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ALPHA,  0x1F8A, 
IBUS_KEY_dead_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ETA,  0x1F9A, 
IBUS_KEY_dead_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMEGA,  0x1FAA, 
IBUS_KEY_dead_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_alpha,  0x1F82, 
IBUS_KEY_dead_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_eta,  0x1F92, 
IBUS_KEY_dead_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_omega,  0x1FA2, 
IBUS_KEY_dead_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ALPHA,  0x1F8B, 
IBUS_KEY_dead_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ETA,  0x1F9B, 
IBUS_KEY_dead_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMEGA,  0x1FAB, 
IBUS_KEY_dead_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_alpha,  0x1F83, 
IBUS_KEY_dead_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_eta,  0x1F93, 
IBUS_KEY_dead_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omega,  0x1FA3, 
IBUS_KEY_dead_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ALPHA,  0x1F8C, 
IBUS_KEY_dead_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ETA,  0x1F9C, 
IBUS_KEY_dead_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMEGA,  0x1FAC, 
IBUS_KEY_dead_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_alpha,  0x1F84, 
IBUS_KEY_dead_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_eta,  0x1F94, 
IBUS_KEY_dead_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_omega,  0x1FA4, 
IBUS_KEY_dead_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ALPHA,  0x1F8D, 
IBUS_KEY_dead_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ETA,  0x1F9D, 
IBUS_KEY_dead_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMEGA,  0x1FAD, 
IBUS_KEY_dead_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_alpha,  0x1F85, 
IBUS_KEY_dead_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_eta,  0x1F95, 
IBUS_KEY_dead_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omega,  0x1FA5, 
IBUS_KEY_dead_tilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ALPHA,  0x1F8E, 
IBUS_KEY_dead_tilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ETA,  0x1F9E, 
IBUS_KEY_dead_tilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMEGA,  0x1FAE, 
IBUS_KEY_dead_tilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_alpha,  0x1F86, 
IBUS_KEY_dead_tilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_eta,  0x1F96, 
IBUS_KEY_dead_tilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_omega,  0x1FA6, 
IBUS_KEY_dead_tilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ALPHA,  0x1F8F, 
IBUS_KEY_dead_tilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ETA,  0x1F9F, 
IBUS_KEY_dead_tilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMEGA,  0x1FAF, 
IBUS_KEY_dead_tilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_alpha,  0x1F87, 
IBUS_KEY_dead_tilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_eta,  0x1F97, 
IBUS_KEY_dead_tilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omega,  0x1FA7, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_Greek_alpha,  0x1FB4, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_Greek_eta,  0x1FC4, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_Greek_omega,  0x1FF4, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, 0x1F00,  0x1F84, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, 0x1F01,  0x1F85, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, 0x1F08,  0x1F8C, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, 0x1F09,  0x1F8D, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, 0x1F20,  0x1F94, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, 0x1F21,  0x1F95, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, 0x1F28,  0x1F9C, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, 0x1F29,  0x1F9D, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, 0x1F60,  0x1FA4, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, 0x1F61,  0x1FA5, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, 0x1F68,  0x1FAC, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, 0x1F69,  0x1FAD, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F89, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F99, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1FA9, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F81, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F91, 
IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1FA1, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F88, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F98, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1FA8, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F80, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F90, 
IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1FA0, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_Greek_alpha,  0x1FB2, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_Greek_eta,  0x1FC2, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_Greek_omega,  0x1FF2, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, 0x1F00,  0x1F82, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, 0x1F01,  0x1F83, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, 0x1F08,  0x1F8A, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, 0x1F09,  0x1F8B, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, 0x1F20,  0x1F92, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, 0x1F21,  0x1F93, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, 0x1F28,  0x1F9A, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, 0x1F29,  0x1F9B, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, 0x1F60,  0x1FA2, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, 0x1F61,  0x1FA3, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, 0x1F68,  0x1FAA, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, 0x1F69,  0x1FAB, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_Greek_alpha,  0x1FB7, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_Greek_eta,  0x1FC7, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_Greek_omega,  0x1FF7, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, 0x1F00,  0x1F86, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, 0x1F01,  0x1F87, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, 0x1F08,  0x1F8E, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, 0x1F09,  0x1F8F, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, 0x1F20,  0x1F96, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, 0x1F21,  0x1F97, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, 0x1F28,  0x1F9E, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, 0x1F29,  0x1F9F, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, 0x1F60,  0x1FA6, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, 0x1F61,  0x1FA7, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, 0x1F68,  0x1FAE, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, 0x1F69,  0x1FAF, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_Greek_alpha,  0x1FB4, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_Greek_eta,  0x1FC4, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_Greek_omega,  0x1FF4, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, 0x1F00,  0x1F84, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, 0x1F01,  0x1F85, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, 0x1F08,  0x1F8C, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, 0x1F09,  0x1F8D, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, 0x1F20,  0x1F94, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, 0x1F21,  0x1F95, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, 0x1F28,  0x1F9C, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, 0x1F29,  0x1F9D, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, 0x1F60,  0x1FA4, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, 0x1F61,  0x1FA5, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, 0x1F68,  0x1FAC, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, 0x1F69,  0x1FAD, 
IBUS_KEY_dead_grave, IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F8B, 
IBUS_KEY_dead_grave, IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F9B, 
IBUS_KEY_dead_grave, IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1FAB, 
IBUS_KEY_dead_grave, IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F83, 
IBUS_KEY_dead_grave, IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F93, 
IBUS_KEY_dead_grave, IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1FA3, 
IBUS_KEY_dead_grave, IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F8A, 
IBUS_KEY_dead_grave, IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F9A, 
IBUS_KEY_dead_grave, IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1FAA, 
IBUS_KEY_dead_grave, IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F82, 
IBUS_KEY_dead_grave, IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F92, 
IBUS_KEY_dead_grave, IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1FA2, 
IBUS_KEY_dead_acute, IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F8D, 
IBUS_KEY_dead_acute, IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F9D, 
IBUS_KEY_dead_acute, IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1FAD, 
IBUS_KEY_dead_acute, IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F85, 
IBUS_KEY_dead_acute, IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F95, 
IBUS_KEY_dead_acute, IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1FA5, 
IBUS_KEY_dead_acute, IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F8C, 
IBUS_KEY_dead_acute, IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F9C, 
IBUS_KEY_dead_acute, IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1FAC, 
IBUS_KEY_dead_acute, IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F84, 
IBUS_KEY_dead_acute, IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F94, 
IBUS_KEY_dead_acute, IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1FA4, 
IBUS_KEY_dead_tilde, IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F8F, 
IBUS_KEY_dead_tilde, IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F9F, 
IBUS_KEY_dead_tilde, IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1FAF, 
IBUS_KEY_dead_tilde, IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F87, 
IBUS_KEY_dead_tilde, IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F97, 
IBUS_KEY_dead_tilde, IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1FA7, 
IBUS_KEY_dead_tilde, IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F8E, 
IBUS_KEY_dead_tilde, IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F9E, 
IBUS_KEY_dead_tilde, IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1FAE, 
IBUS_KEY_dead_tilde, IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F86, 
IBUS_KEY_dead_tilde, IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F96, 
IBUS_KEY_dead_tilde, IBUS_KEY_Multi_key, IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1FA6, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F8D, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F9D, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1FAD, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F85, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F95, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1FA5, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F8C, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F9C, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1FAC, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F84, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F94, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1FA4, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ALPHA,  0x1F8C, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ETA,  0x1F9C, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMEGA,  0x1FAC, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_alpha,  0x1F84, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_eta,  0x1F94, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_omega,  0x1FA4, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ALPHA,  0x1F8D, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ETA,  0x1F9D, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMEGA,  0x1FAD, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_alpha,  0x1F85, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_eta,  0x1F95, 
IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omega,  0x1FA5, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F8B, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F9B, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1FAB, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F83, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F93, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1FA3, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F8A, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F9A, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1FAA, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F82, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F92, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1FA2, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ALPHA,  0x1F8A, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ETA,  0x1F9A, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMEGA,  0x1FAA, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_alpha,  0x1F82, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_eta,  0x1F92, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_omega,  0x1FA2, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ALPHA,  0x1F8B, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ETA,  0x1F9B, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMEGA,  0x1FAB, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_alpha,  0x1F83, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_eta,  0x1F93, 
IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omega,  0x1FA3, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F8F, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F9F, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1FAF, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F87, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F97, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1FA7, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F8E, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F9E, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1FAE, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F86, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F96, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1FA6, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ALPHA,  0x1F8E, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ETA,  0x1F9E, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMEGA,  0x1FAE, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_alpha,  0x1F86, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_eta,  0x1F96, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_omega,  0x1FA6, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ALPHA,  0x1F8F, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ETA,  0x1F9F, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMEGA,  0x1FAF, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_alpha,  0x1F87, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_eta,  0x1F97, 
IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omega,  0x1FA7, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F8D, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F9D, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1FAD, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F85, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F95, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1FA5, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F8C, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F9C, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1FAC, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F84, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F94, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1FA4, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ALPHA,  0x1F8C, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ETA,  0x1F9C, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMEGA,  0x1FAC, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_alpha,  0x1F84, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_eta,  0x1F94, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_omega,  0x1FA4, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ALPHA,  0x1F8D, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ETA,  0x1F9D, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMEGA,  0x1FAD, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_alpha,  0x1F85, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_eta,  0x1F95, 
IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omega,  0x1FA5, 
IBUS_KEY_kana_WO,  0x30FA, 
IBUS_KEY_kana_U,  0x30F4, 
IBUS_KEY_kana_KA,  0x30AC, 
IBUS_KEY_kana_KI,  0x30AE, 
IBUS_KEY_kana_KU,  0x30B0, 
IBUS_KEY_kana_KE,  0x30B2, 
IBUS_KEY_kana_KO,  0x30B4, 
IBUS_KEY_kana_SA,  0x30B6, 
IBUS_KEY_kana_SHI,  0x30B8, 
IBUS_KEY_kana_SU,  0x30BA, 
IBUS_KEY_kana_SE,  0x30BC, 
IBUS_KEY_kana_SO,  0x30BE, 
IBUS_KEY_kana_TA,  0x30C0, 
IBUS_KEY_kana_CHI,  0x30C2, 
IBUS_KEY_kana_TSU,  0x30C5, 
IBUS_KEY_kana_TE,  0x30C7, 
IBUS_KEY_kana_TO,  0x30C9, 
IBUS_KEY_kana_HA,  0x30D0, 
IBUS_KEY_kana_HI,  0x30D3, 
IBUS_KEY_kana_FU,  0x30D6, 
IBUS_KEY_kana_HE,  0x30D9, 
IBUS_KEY_kana_HO,  0x30DC, 
IBUS_KEY_kana_WA,  0x30F7, 
IBUS_KEY_kana_HA,  0x30D1, 
IBUS_KEY_kana_HI,  0x30D4, 
IBUS_KEY_kana_FU,  0x30D7, 
IBUS_KEY_kana_HE,  0x30DA, 
IBUS_KEY_kana_HO,  0x30DD, 
IBUS_KEY_space,  0x0323, 
IBUS_KEY_plus,  0x2A25, 
IBUS_KEY_minus,  0x2A2A, 
IBUS_KEY_equal,  0x2A66, 
IBUS_KEY_nobreakspace,  0x0323, 
IBUS_KEY_Abreve,  0x1EB6, 
IBUS_KEY_abreve,  0x1EB7, 
IBUS_KEY_dead_belowdot,  0x0323, 
IBUS_KEY_Multi_key, IBUS_KEY_plus, IBUS_KEY_O,  0x1EE2, 
IBUS_KEY_Multi_key, IBUS_KEY_plus, IBUS_KEY_U,  0x1EF0, 
IBUS_KEY_Multi_key, IBUS_KEY_plus, IBUS_KEY_o,  0x1EE3, 
IBUS_KEY_Multi_key, IBUS_KEY_plus, IBUS_KEY_u,  0x1EF1, 
IBUS_KEY_space,  0x0309, 
IBUS_KEY_B,  0x0181, 
IBUS_KEY_C,  0x0187, 
IBUS_KEY_D,  0x018A, 
IBUS_KEY_F,  0x0191, 
IBUS_KEY_G,  0x0193, 
IBUS_KEY_K,  0x0198, 
IBUS_KEY_M,  0x2C6E, 
IBUS_KEY_N,  0x019D, 
IBUS_KEY_P,  0x01A4, 
IBUS_KEY_T,  0x01AC, 
IBUS_KEY_V,  0x01B2, 
IBUS_KEY_W,  0x2C72, 
IBUS_KEY_Z,  0x0224, 
IBUS_KEY_b,  0x0253, 
IBUS_KEY_c,  0x0188, 
IBUS_KEY_d,  0x0257, 
IBUS_KEY_f,  0x0192, 
IBUS_KEY_g,  0x0260, 
IBUS_KEY_h,  0x0266, 
IBUS_KEY_k,  0x0199, 
IBUS_KEY_m,  0x0271, 
IBUS_KEY_n,  0x0272, 
IBUS_KEY_p,  0x01A5, 
IBUS_KEY_q,  0x02A0, 
IBUS_KEY_r,  0x027C, 
IBUS_KEY_s,  0x0282, 
IBUS_KEY_t,  0x01AD, 
IBUS_KEY_v,  0x028B, 
IBUS_KEY_w,  0x2C73, 
IBUS_KEY_z,  0x0225, 
IBUS_KEY_nobreakspace,  0x0309, 
IBUS_KEY_Abreve,  0x1EB2, 
IBUS_KEY_abreve,  0x1EB3, 
0x0256,  0x1D91, 
0x025C,  0x025D, 
0x025F,  0x0284, 
0x0279,  0x027B, 
IBUS_KEY_dead_hook,  0x0309, 
IBUS_KEY_dead_greek, IBUS_KEY_U,  0x03D2, 
IBUS_KEY_Multi_key, IBUS_KEY_plus, IBUS_KEY_O,  0x1EDE, 
IBUS_KEY_Multi_key, IBUS_KEY_plus, IBUS_KEY_U,  0x1EEC, 
IBUS_KEY_Multi_key, IBUS_KEY_plus, IBUS_KEY_o,  0x1EDF, 
IBUS_KEY_Multi_key, IBUS_KEY_plus, IBUS_KEY_u,  0x1EED, 
IBUS_KEY_Multi_key, IBUS_KEY_U, IBUS_KEY_A,  0x1EB2, 
IBUS_KEY_Multi_key, IBUS_KEY_U, IBUS_KEY_a,  0x1EB3, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_A,  0x1EA8, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_E,  0x1EC2, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_O,  0x1ED4, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_a,  0x1EA9, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_e,  0x1EC3, 
IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_o,  0x1ED5, 
IBUS_KEY_Multi_key, IBUS_KEY_b, IBUS_KEY_A,  0x1EB2, 
IBUS_KEY_Multi_key, IBUS_KEY_b, IBUS_KEY_a,  0x1EB3, 
IBUS_KEY_space,  0x031B, 
IBUS_KEY_nobreakspace,  0x031B, 
IBUS_KEY_Utilde,  0x1EEE, 
IBUS_KEY_utilde,  0x1EEF, 
IBUS_KEY_dead_horn,  0x031B, 
IBUS_KEY_space,  0x002F, 
IBUS_KEY_2,  0x01BB, 
IBUS_KEY_A,  0x023A, 
IBUS_KEY_B,  0x0243, 
IBUS_KEY_C,  0x023B, 
IBUS_KEY_D,  0x0110, 
IBUS_KEY_E,  0x0246, 
IBUS_KEY_G,  0x01E4, 
IBUS_KEY_H,  0x0126, 
IBUS_KEY_I,  0x0197, 
IBUS_KEY_J,  0x0248, 
IBUS_KEY_L,  0x0141, 
IBUS_KEY_O,  0x00D8, 
IBUS_KEY_P,  0x2C63, 
IBUS_KEY_R,  0x024C, 
IBUS_KEY_T,  0x0166, 
IBUS_KEY_U,  0x0244, 
IBUS_KEY_Y,  0x024E, 
IBUS_KEY_Z,  0x01B5, 
IBUS_KEY_a,  0x2C65, 
IBUS_KEY_b,  0x0180, 
IBUS_KEY_c,  0x023C, 
IBUS_KEY_d,  0x0111, 
IBUS_KEY_e,  0x0247, 
IBUS_KEY_g,  0x01E5, 
IBUS_KEY_h,  0x0127, 
IBUS_KEY_i,  0x0268, 
IBUS_KEY_j,  0x0249, 
IBUS_KEY_l,  0x0142, 
IBUS_KEY_o,  0x00F8, 
IBUS_KEY_p,  0x1D7D, 
IBUS_KEY_r,  0x024D, 
IBUS_KEY_t,  0x0167, 
IBUS_KEY_u,  0x0289, 
IBUS_KEY_y,  0x024F, 
IBUS_KEY_z,  0x01B6, 
IBUS_KEY_nobreakspace,  0x0338, 
IBUS_KEY_Oacute,  0x01FE, 
IBUS_KEY_oacute,  0x01FF, 
0x0237,  0x025F, 
0x0269,  0x1D7C, 
IBUS_KEY_lessthanequal,  0x2270, 
IBUS_KEY_greaterthanequal,  0x2271, 
IBUS_KEY_dead_stroke,  0x002F, 
IBUS_KEY_dead_acute, IBUS_KEY_O,  0x01FE, 
IBUS_KEY_dead_acute, IBUS_KEY_o,  0x01FF, 
IBUS_KEY_dead_abovedot, IBUS_KEY_j,  0x025F, 
IBUS_KEY_dead_greek, IBUS_KEY_r,  0x03FC, 
IBUS_KEY_Greek_ALPHA,  0x1F08, 
IBUS_KEY_Greek_EPSILON,  0x1F18, 
IBUS_KEY_Greek_ETA,  0x1F28, 
IBUS_KEY_Greek_IOTA,  0x1F38, 
IBUS_KEY_Greek_OMICRON,  0x1F48, 
IBUS_KEY_Greek_OMEGA,  0x1F68, 
IBUS_KEY_Greek_alpha,  0x1F00, 
IBUS_KEY_Greek_epsilon,  0x1F10, 
IBUS_KEY_Greek_eta,  0x1F20, 
IBUS_KEY_Greek_iota,  0x1F30, 
IBUS_KEY_Greek_omicron,  0x1F40, 
IBUS_KEY_Greek_rho,  0x1FE4, 
IBUS_KEY_Greek_upsilon,  0x1F50, 
IBUS_KEY_Greek_omega,  0x1F60, 
IBUS_KEY_Greek_ALPHA,  0x1F09, 
IBUS_KEY_Greek_EPSILON,  0x1F19, 
IBUS_KEY_Greek_ETA,  0x1F29, 
IBUS_KEY_Greek_IOTA,  0x1F39, 
IBUS_KEY_Greek_OMICRON,  0x1F49, 
IBUS_KEY_Greek_RHO,  0x1FEC, 
IBUS_KEY_Greek_UPSILON,  0x1F59, 
IBUS_KEY_Greek_OMEGA,  0x1F69, 
IBUS_KEY_Greek_alpha,  0x1F01, 
IBUS_KEY_Greek_epsilon,  0x1F11, 
IBUS_KEY_Greek_eta,  0x1F21, 
IBUS_KEY_Greek_iota,  0x1F31, 
IBUS_KEY_Greek_omicron,  0x1F41, 
IBUS_KEY_Greek_rho,  0x1FE5, 
IBUS_KEY_Greek_upsilon,  0x1F51, 
IBUS_KEY_Greek_omega,  0x1F61, 
IBUS_KEY_bar,  0x2AF0, 
IBUS_KEY_plus,  0x2A26, 
IBUS_KEY_dead_diaeresis, IBUS_KEY_equal,  0x2A77, 
IBUS_KEY_space,  0x002C, 
IBUS_KEY_S,  0x0218, 
IBUS_KEY_T,  0x021A, 
IBUS_KEY_s,  0x0219, 
IBUS_KEY_t,  0x021B, 
IBUS_KEY_nobreakspace,  0x0326, 
IBUS_KEY_dead_belowcomma,  0x002C, 
IBUS_KEY_space,  0x00A4, 
IBUS_KEY_A,  0x20B3, 
IBUS_KEY_B,  0x20B1, 
IBUS_KEY_C,  0x20A1, 
IBUS_KEY_D,  0x20AF, 
IBUS_KEY_E,  0x20A0, 
IBUS_KEY_F,  0x20A3, 
IBUS_KEY_G,  0x20B2, 
IBUS_KEY_H,  0x20B4, 
IBUS_KEY_I,  0x17DB, 
IBUS_KEY_K,  0x20AD, 
IBUS_KEY_L,  0x20A4, 
IBUS_KEY_M,  0x2133, 
IBUS_KEY_N,  0x20A6, 
IBUS_KEY_O,  0x0AF1, 
IBUS_KEY_P,  0x20A7, 
IBUS_KEY_R,  0x20A8, 
IBUS_KEY_S,  0x0024, 
IBUS_KEY_T,  0x20AE, 
IBUS_KEY_U,  0x5713, 
IBUS_KEY_W,  0x20A9, 
IBUS_KEY_Y,  0x5186, 
IBUS_KEY_a,  0x060B, 
IBUS_KEY_b,  0x0E3F, 
IBUS_KEY_c,  0x00A2, 
IBUS_KEY_d,  0x20AB, 
IBUS_KEY_e,  0x20AC, 
IBUS_KEY_f,  0x0192, 
IBUS_KEY_g,  0x20B2, 
IBUS_KEY_h,  0x20B4, 
IBUS_KEY_i,  0xFDFC, 
IBUS_KEY_k,  0x20AD, 
IBUS_KEY_l,  0x00A3, 
IBUS_KEY_m,  0x20A5, 
IBUS_KEY_n,  0x20A6, 
IBUS_KEY_o,  0x0BF9, 
IBUS_KEY_p,  0x20B0, 
IBUS_KEY_r,  0x20A2, 
IBUS_KEY_s,  0x20AA, 
IBUS_KEY_t,  0x09F3, 
IBUS_KEY_u,  0x5143, 
IBUS_KEY_w,  0x20A9, 
IBUS_KEY_y,  0x00A5, 
IBUS_KEY_nobreakspace,  0x00A4, 
IBUS_KEY_Ccedilla,  0x20B5, 
IBUS_KEY_THORN,  0x09F2, 
IBUS_KEY_ccedilla,  0x20B5, 
IBUS_KEY_thorn,  0x09F2, 
IBUS_KEY_dead_currency,  0x00A4, 
IBUS_KEY_dead_cedilla, IBUS_KEY_C,  0x20B5, 
IBUS_KEY_dead_cedilla, IBUS_KEY_c,  0x20B5, 
IBUS_KEY_space,  0x00B5, 
IBUS_KEY_A,  0x0391, 
IBUS_KEY_B,  0x0392, 
IBUS_KEY_D,  0x0394, 
IBUS_KEY_E,  0x0395, 
IBUS_KEY_F,  0x03A6, 
IBUS_KEY_G,  0x0393, 
IBUS_KEY_H,  0x0397, 
IBUS_KEY_I,  0x0399, 
IBUS_KEY_J,  0x0398, 
IBUS_KEY_K,  0x039A, 
IBUS_KEY_L,  0x039B, 
IBUS_KEY_M,  0x039C, 
IBUS_KEY_N,  0x039D, 
IBUS_KEY_O,  0x039F, 
IBUS_KEY_P,  0x03A0, 
IBUS_KEY_Q,  0x03A7, 
IBUS_KEY_R,  0x03A1, 
IBUS_KEY_S,  0x03A3, 
IBUS_KEY_T,  0x03A4, 
IBUS_KEY_U,  0x03A5, 
IBUS_KEY_W,  0x03A9, 
IBUS_KEY_X,  0x039E, 
IBUS_KEY_Y,  0x03A8, 
IBUS_KEY_Z,  0x0396, 
IBUS_KEY_a,  0x03B1, 
IBUS_KEY_b,  0x03B2, 
IBUS_KEY_d,  0x03B4, 
IBUS_KEY_e,  0x03B5, 
IBUS_KEY_f,  0x03C6, 
IBUS_KEY_g,  0x03B3, 
IBUS_KEY_h,  0x03B7, 
IBUS_KEY_i,  0x03B9, 
IBUS_KEY_j,  0x03B8, 
IBUS_KEY_k,  0x03BA, 
IBUS_KEY_l,  0x03BB, 
IBUS_KEY_m,  0x03BC, 
IBUS_KEY_n,  0x03BD, 
IBUS_KEY_o,  0x03BF, 
IBUS_KEY_p,  0x03C0, 
IBUS_KEY_q,  0x03C7, 
IBUS_KEY_r,  0x03C1, 
IBUS_KEY_s,  0x03C3, 
IBUS_KEY_t,  0x03C4, 
IBUS_KEY_u,  0x03C5, 
IBUS_KEY_w,  0x03C9, 
IBUS_KEY_x,  0x03BE, 
IBUS_KEY_y,  0x03C8, 
IBUS_KEY_z,  0x03B6, 
IBUS_KEY_nobreakspace,  0x00B5, 
IBUS_KEY_dead_greek,  0x00B5, 
IBUS_KEY_dead_macron, IBUS_KEY_A,  0x1FB9, 
IBUS_KEY_dead_macron, IBUS_KEY_I,  0x1FD9, 
IBUS_KEY_dead_macron, IBUS_KEY_U,  0x1FE9, 
IBUS_KEY_dead_macron, IBUS_KEY_a,  0x1FB1, 
IBUS_KEY_dead_macron, IBUS_KEY_i,  0x1FD1, 
IBUS_KEY_dead_macron, IBUS_KEY_u,  0x1FE1, 
IBUS_KEY_dead_hook, IBUS_KEY_U,  0x03D2, 
IBUS_KEY_dead_stroke, IBUS_KEY_r,  0x03FC, 
IBUS_KEY_space, IBUS_KEY_space,  0x00A0, 
IBUS_KEY_space, IBUS_KEY_apostrophe,  0x0027, 
IBUS_KEY_space, IBUS_KEY_parenleft,  0x02D8, 
IBUS_KEY_space, IBUS_KEY_comma,  0x00B8, 
IBUS_KEY_space, IBUS_KEY_minus,  0x007E, 
IBUS_KEY_space, IBUS_KEY_period,  0x2008, 
IBUS_KEY_space, IBUS_KEY_less,  0x02C7, 
IBUS_KEY_space, IBUS_KEY_greater,  0x005E, 
IBUS_KEY_space, IBUS_KEY_asciicircum,  0x005E, 
IBUS_KEY_space, IBUS_KEY_grave,  0x0060, 
IBUS_KEY_space, IBUS_KEY_asciitilde,  0x007E, 
IBUS_KEY_exclam, IBUS_KEY_exclam,  0x00A1, 
IBUS_KEY_exclam, IBUS_KEY_question,  0x203D, 
IBUS_KEY_exclam, IBUS_KEY_A,  0x1EA0, 
IBUS_KEY_exclam, IBUS_KEY_B,  0x1E04, 
IBUS_KEY_exclam, IBUS_KEY_D,  0x1E0C, 
IBUS_KEY_exclam, IBUS_KEY_E,  0x1EB8, 
IBUS_KEY_exclam, IBUS_KEY_H,  0x1E24, 
IBUS_KEY_exclam, IBUS_KEY_I,  0x1ECA, 
IBUS_KEY_exclam, IBUS_KEY_K,  0x1E32, 
IBUS_KEY_exclam, IBUS_KEY_L,  0x1E36, 
IBUS_KEY_exclam, IBUS_KEY_M,  0x1E42, 
IBUS_KEY_exclam, IBUS_KEY_N,  0x1E46, 
IBUS_KEY_exclam, IBUS_KEY_O,  0x1ECC, 
IBUS_KEY_exclam, IBUS_KEY_P,  0x00B6, 
IBUS_KEY_exclam, IBUS_KEY_R,  0x1E5A, 
IBUS_KEY_exclam, IBUS_KEY_S,  0x1E62, 
IBUS_KEY_exclam, IBUS_KEY_T,  0x1E6C, 
IBUS_KEY_exclam, IBUS_KEY_U,  0x1EE4, 
IBUS_KEY_exclam, IBUS_KEY_V,  0x1E7E, 
IBUS_KEY_exclam, IBUS_KEY_W,  0x1E88, 
IBUS_KEY_exclam, IBUS_KEY_Y,  0x1EF4, 
IBUS_KEY_exclam, IBUS_KEY_Z,  0x1E92, 
IBUS_KEY_exclam, IBUS_KEY_asciicircum,  0x00A6, 
IBUS_KEY_exclam, IBUS_KEY_a,  0x1EA1, 
IBUS_KEY_exclam, IBUS_KEY_b,  0x1E05, 
IBUS_KEY_exclam, IBUS_KEY_d,  0x1E0D, 
IBUS_KEY_exclam, IBUS_KEY_e,  0x1EB9, 
IBUS_KEY_exclam, IBUS_KEY_h,  0x1E25, 
IBUS_KEY_exclam, IBUS_KEY_i,  0x1ECB, 
IBUS_KEY_exclam, IBUS_KEY_k,  0x1E33, 
IBUS_KEY_exclam, IBUS_KEY_l,  0x1E37, 
IBUS_KEY_exclam, IBUS_KEY_m,  0x1E43, 
IBUS_KEY_exclam, IBUS_KEY_n,  0x1E47, 
IBUS_KEY_exclam, IBUS_KEY_o,  0x1ECD, 
IBUS_KEY_exclam, IBUS_KEY_p,  0x00B6, 
IBUS_KEY_exclam, IBUS_KEY_r,  0x1E5B, 
IBUS_KEY_exclam, IBUS_KEY_s,  0x1E63, 
IBUS_KEY_exclam, IBUS_KEY_t,  0x1E6D, 
IBUS_KEY_exclam, IBUS_KEY_u,  0x1EE5, 
IBUS_KEY_exclam, IBUS_KEY_v,  0x1E7F, 
IBUS_KEY_exclam, IBUS_KEY_w,  0x1E89, 
IBUS_KEY_exclam, IBUS_KEY_y,  0x1EF5, 
IBUS_KEY_exclam, IBUS_KEY_z,  0x1E93, 
IBUS_KEY_quotedbl, IBUS_KEY_quotedbl,  0x00A8, 
IBUS_KEY_quotedbl, IBUS_KEY_apostrophe,  0x0344, 
IBUS_KEY_quotedbl, IBUS_KEY_comma,  0x201E, 
IBUS_KEY_quotedbl, IBUS_KEY_less,  0x201C, 
IBUS_KEY_quotedbl, IBUS_KEY_greater,  0x201D, 
IBUS_KEY_quotedbl, IBUS_KEY_A,  0x00C4, 
IBUS_KEY_quotedbl, IBUS_KEY_E,  0x00CB, 
IBUS_KEY_quotedbl, IBUS_KEY_H,  0x1E26, 
IBUS_KEY_quotedbl, IBUS_KEY_I,  0x00CF, 
IBUS_KEY_quotedbl, IBUS_KEY_O,  0x00D6, 
IBUS_KEY_quotedbl, IBUS_KEY_U,  0x00DC, 
IBUS_KEY_quotedbl, IBUS_KEY_W,  0x1E84, 
IBUS_KEY_quotedbl, IBUS_KEY_X,  0x1E8C, 
IBUS_KEY_quotedbl, IBUS_KEY_Y,  0x0178, 
IBUS_KEY_quotedbl, IBUS_KEY_a,  0x00E4, 
IBUS_KEY_quotedbl, IBUS_KEY_e,  0x00EB, 
IBUS_KEY_quotedbl, IBUS_KEY_h,  0x1E27, 
IBUS_KEY_quotedbl, IBUS_KEY_i,  0x00EF, 
IBUS_KEY_quotedbl, IBUS_KEY_o,  0x00F6, 
IBUS_KEY_quotedbl, IBUS_KEY_t,  0x1E97, 
IBUS_KEY_quotedbl, IBUS_KEY_u,  0x00FC, 
IBUS_KEY_quotedbl, IBUS_KEY_w,  0x1E85, 
IBUS_KEY_quotedbl, IBUS_KEY_x,  0x1E8D, 
IBUS_KEY_quotedbl, IBUS_KEY_y,  0x00FF, 
IBUS_KEY_quotedbl, IBUS_KEY_acute,  0x0344, 
IBUS_KEY_quotedbl, IBUS_KEY_Otilde,  0x1E4E, 
IBUS_KEY_quotedbl, IBUS_KEY_otilde,  0x1E4F, 
IBUS_KEY_quotedbl, 0x03D2,  0x03D4, 
IBUS_KEY_quotedbl, IBUS_KEY_Umacron,  0x1E7A, 
IBUS_KEY_quotedbl, IBUS_KEY_umacron,  0x1E7B, 
IBUS_KEY_quotedbl, 0x04D8,  0x04DA, 
IBUS_KEY_quotedbl, 0x04D9,  0x04DB, 
IBUS_KEY_quotedbl, 0x04E8,  0x04EA, 
IBUS_KEY_quotedbl, 0x04E9,  0x04EB, 
IBUS_KEY_quotedbl, IBUS_KEY_Ukrainian_i,  0x0457, 
IBUS_KEY_quotedbl, IBUS_KEY_Ukrainian_I,  0x0407, 
IBUS_KEY_quotedbl, IBUS_KEY_Cyrillic_a,  0x04D3, 
IBUS_KEY_quotedbl, IBUS_KEY_Cyrillic_ie,  0x0451, 
IBUS_KEY_quotedbl, IBUS_KEY_Cyrillic_i,  0x04E5, 
IBUS_KEY_quotedbl, IBUS_KEY_Cyrillic_o,  0x04E7, 
IBUS_KEY_quotedbl, IBUS_KEY_Cyrillic_u,  0x04F1, 
IBUS_KEY_quotedbl, IBUS_KEY_Cyrillic_zhe,  0x04DD, 
IBUS_KEY_quotedbl, IBUS_KEY_Cyrillic_yeru,  0x04F9, 
IBUS_KEY_quotedbl, IBUS_KEY_Cyrillic_ze,  0x04DF, 
IBUS_KEY_quotedbl, IBUS_KEY_Cyrillic_e,  0x04ED, 
IBUS_KEY_quotedbl, IBUS_KEY_Cyrillic_che,  0x04F5, 
IBUS_KEY_quotedbl, IBUS_KEY_Cyrillic_A,  0x04D2, 
IBUS_KEY_quotedbl, IBUS_KEY_Cyrillic_IE,  0x0401, 
IBUS_KEY_quotedbl, IBUS_KEY_Cyrillic_I,  0x04E4, 
IBUS_KEY_quotedbl, IBUS_KEY_Cyrillic_O,  0x04E6, 
IBUS_KEY_quotedbl, IBUS_KEY_Cyrillic_U,  0x04F0, 
IBUS_KEY_quotedbl, IBUS_KEY_Cyrillic_ZHE,  0x04DC, 
IBUS_KEY_quotedbl, IBUS_KEY_Cyrillic_YERU,  0x04F8, 
IBUS_KEY_quotedbl, IBUS_KEY_Cyrillic_ZE,  0x04DE, 
IBUS_KEY_quotedbl, IBUS_KEY_Cyrillic_E,  0x04EC, 
IBUS_KEY_quotedbl, IBUS_KEY_Cyrillic_CHE,  0x04F4, 
IBUS_KEY_quotedbl, IBUS_KEY_Greek_IOTA,  0x03AA, 
IBUS_KEY_quotedbl, IBUS_KEY_Greek_UPSILON,  0x03AB, 
IBUS_KEY_quotedbl, IBUS_KEY_Greek_iota,  0x03CA, 
IBUS_KEY_quotedbl, IBUS_KEY_Greek_upsilon,  0x03CB, 
IBUS_KEY_quotedbl, IBUS_KEY_dead_acute,  0x0344, 
IBUS_KEY_numbersign, IBUS_KEY_numbersign,  0x266F, 
IBUS_KEY_numbersign, IBUS_KEY_E,  0x266B, 
IBUS_KEY_numbersign, IBUS_KEY_S,  0x266C, 
IBUS_KEY_numbersign, IBUS_KEY_b,  0x266D, 
IBUS_KEY_numbersign, IBUS_KEY_e,  0x266A, 
IBUS_KEY_numbersign, IBUS_KEY_f,  0x266E, 
IBUS_KEY_numbersign, IBUS_KEY_q,  0x2669, 
IBUS_KEY_percent, IBUS_KEY_o,  0x2030, 
IBUS_KEY_apostrophe, IBUS_KEY_space,  0x0027, 
IBUS_KEY_apostrophe, IBUS_KEY_apostrophe,  0x00B4, 
IBUS_KEY_apostrophe, IBUS_KEY_comma,  0x201A, 
IBUS_KEY_apostrophe, IBUS_KEY_less,  0x2018, 
IBUS_KEY_apostrophe, IBUS_KEY_greater,  0x2019, 
IBUS_KEY_apostrophe, IBUS_KEY_A,  0x00C1, 
IBUS_KEY_apostrophe, IBUS_KEY_C,  0x0106, 
IBUS_KEY_apostrophe, IBUS_KEY_E,  0x00C9, 
IBUS_KEY_apostrophe, IBUS_KEY_G,  0x01F4, 
IBUS_KEY_apostrophe, IBUS_KEY_I,  0x00CD, 
IBUS_KEY_apostrophe, IBUS_KEY_K,  0x1E30, 
IBUS_KEY_apostrophe, IBUS_KEY_L,  0x0139, 
IBUS_KEY_apostrophe, IBUS_KEY_M,  0x1E3E, 
IBUS_KEY_apostrophe, IBUS_KEY_N,  0x0143, 
IBUS_KEY_apostrophe, IBUS_KEY_O,  0x00D3, 
IBUS_KEY_apostrophe, IBUS_KEY_P,  0x1E54, 
IBUS_KEY_apostrophe, IBUS_KEY_R,  0x0154, 
IBUS_KEY_apostrophe, IBUS_KEY_S,  0x015A, 
IBUS_KEY_apostrophe, IBUS_KEY_U,  0x00DA, 
IBUS_KEY_apostrophe, IBUS_KEY_W,  0x1E82, 
IBUS_KEY_apostrophe, IBUS_KEY_Y,  0x00DD, 
IBUS_KEY_apostrophe, IBUS_KEY_Z,  0x0179, 
IBUS_KEY_apostrophe, IBUS_KEY_a,  0x00E1, 
IBUS_KEY_apostrophe, IBUS_KEY_c,  0x0107, 
IBUS_KEY_apostrophe, IBUS_KEY_e,  0x00E9, 
IBUS_KEY_apostrophe, IBUS_KEY_g,  0x01F5, 
IBUS_KEY_apostrophe, IBUS_KEY_i,  0x00ED, 
IBUS_KEY_apostrophe, IBUS_KEY_k,  0x1E31, 
IBUS_KEY_apostrophe, IBUS_KEY_l,  0x013A, 
IBUS_KEY_apostrophe, IBUS_KEY_m,  0x1E3F, 
IBUS_KEY_apostrophe, IBUS_KEY_n,  0x0144, 
IBUS_KEY_apostrophe, IBUS_KEY_o,  0x00F3, 
IBUS_KEY_apostrophe, IBUS_KEY_p,  0x1E55, 
IBUS_KEY_apostrophe, IBUS_KEY_r,  0x0155, 
IBUS_KEY_apostrophe, IBUS_KEY_s,  0x015B, 
IBUS_KEY_apostrophe, IBUS_KEY_u,  0x00FA, 
IBUS_KEY_apostrophe, IBUS_KEY_w,  0x1E83, 
IBUS_KEY_apostrophe, IBUS_KEY_y,  0x00FD, 
IBUS_KEY_apostrophe, IBUS_KEY_z,  0x017A, 
IBUS_KEY_apostrophe, IBUS_KEY_Acircumflex,  0x1EA4, 
IBUS_KEY_apostrophe, IBUS_KEY_Aring,  0x01FA, 
IBUS_KEY_apostrophe, IBUS_KEY_AE,  0x01FC, 
IBUS_KEY_apostrophe, IBUS_KEY_Ccedilla,  0x1E08, 
IBUS_KEY_apostrophe, IBUS_KEY_Ecircumflex,  0x1EBE, 
IBUS_KEY_apostrophe, IBUS_KEY_Idiaeresis,  0x1E2E, 
IBUS_KEY_apostrophe, IBUS_KEY_Ocircumflex,  0x1ED0, 
IBUS_KEY_apostrophe, IBUS_KEY_Otilde,  0x1E4C, 
IBUS_KEY_apostrophe, IBUS_KEY_Ooblique,  0x01FE, 
IBUS_KEY_apostrophe, IBUS_KEY_Udiaeresis,  0x01D7, 
IBUS_KEY_apostrophe, IBUS_KEY_acircumflex,  0x1EA5, 
IBUS_KEY_apostrophe, IBUS_KEY_aring,  0x01FB, 
IBUS_KEY_apostrophe, IBUS_KEY_ae,  0x01FD, 
IBUS_KEY_apostrophe, IBUS_KEY_ccedilla,  0x1E09, 
IBUS_KEY_apostrophe, IBUS_KEY_ecircumflex,  0x1EBF, 
IBUS_KEY_apostrophe, IBUS_KEY_idiaeresis,  0x1E2F, 
IBUS_KEY_apostrophe, IBUS_KEY_ocircumflex,  0x1ED1, 
IBUS_KEY_apostrophe, IBUS_KEY_otilde,  0x1E4D, 
IBUS_KEY_apostrophe, IBUS_KEY_oslash,  0x01FF, 
IBUS_KEY_apostrophe, IBUS_KEY_udiaeresis,  0x01D8, 
IBUS_KEY_apostrophe, IBUS_KEY_Abreve,  0x1EAE, 
IBUS_KEY_apostrophe, IBUS_KEY_abreve,  0x1EAF, 
IBUS_KEY_apostrophe, IBUS_KEY_Emacron,  0x1E16, 
IBUS_KEY_apostrophe, IBUS_KEY_emacron,  0x1E17, 
IBUS_KEY_apostrophe, IBUS_KEY_Omacron,  0x1E52, 
IBUS_KEY_apostrophe, IBUS_KEY_Utilde,  0x1E78, 
IBUS_KEY_apostrophe, IBUS_KEY_omacron,  0x1E53, 
IBUS_KEY_apostrophe, IBUS_KEY_utilde,  0x1E79, 
IBUS_KEY_apostrophe, IBUS_KEY_Cyrillic_ghe,  0x0453, 
IBUS_KEY_apostrophe, IBUS_KEY_Cyrillic_ka,  0x045C, 
IBUS_KEY_apostrophe, IBUS_KEY_Cyrillic_GHE,  0x0403, 
IBUS_KEY_apostrophe, IBUS_KEY_Cyrillic_KA,  0x040C, 
IBUS_KEY_apostrophe, IBUS_KEY_Greek_iotadieresis,  0x0390, 
IBUS_KEY_apostrophe, IBUS_KEY_Greek_upsilondieresis,  0x03B0, 
IBUS_KEY_apostrophe, IBUS_KEY_Greek_ALPHA,  0x0386, 
IBUS_KEY_apostrophe, IBUS_KEY_Greek_EPSILON,  0x0388, 
IBUS_KEY_apostrophe, IBUS_KEY_Greek_ETA,  0x0389, 
IBUS_KEY_apostrophe, IBUS_KEY_Greek_IOTA,  0x038A, 
IBUS_KEY_apostrophe, IBUS_KEY_Greek_OMICRON,  0x038C, 
IBUS_KEY_apostrophe, IBUS_KEY_Greek_UPSILON,  0x038E, 
IBUS_KEY_apostrophe, IBUS_KEY_Greek_OMEGA,  0x038F, 
IBUS_KEY_apostrophe, IBUS_KEY_Greek_alpha,  0x03AC, 
IBUS_KEY_apostrophe, IBUS_KEY_Greek_epsilon,  0x03AD, 
IBUS_KEY_apostrophe, IBUS_KEY_Greek_eta,  0x03AE, 
IBUS_KEY_apostrophe, IBUS_KEY_Greek_iota,  0x03AF, 
IBUS_KEY_apostrophe, IBUS_KEY_Greek_omicron,  0x03CC, 
IBUS_KEY_apostrophe, IBUS_KEY_Greek_upsilon,  0x03CD, 
IBUS_KEY_apostrophe, IBUS_KEY_Greek_omega,  0x03CE, 
IBUS_KEY_apostrophe, 0x1F00,  0x1F04, 
IBUS_KEY_apostrophe, 0x1F01,  0x1F05, 
IBUS_KEY_apostrophe, 0x1F08,  0x1F0C, 
IBUS_KEY_apostrophe, 0x1F09,  0x1F0D, 
IBUS_KEY_apostrophe, 0x1F10,  0x1F14, 
IBUS_KEY_apostrophe, 0x1F11,  0x1F15, 
IBUS_KEY_apostrophe, 0x1F18,  0x1F1C, 
IBUS_KEY_apostrophe, 0x1F19,  0x1F1D, 
IBUS_KEY_apostrophe, 0x1F20,  0x1F24, 
IBUS_KEY_apostrophe, 0x1F21,  0x1F25, 
IBUS_KEY_apostrophe, 0x1F28,  0x1F2C, 
IBUS_KEY_apostrophe, 0x1F29,  0x1F2D, 
IBUS_KEY_apostrophe, 0x1F30,  0x1F34, 
IBUS_KEY_apostrophe, 0x1F31,  0x1F35, 
IBUS_KEY_apostrophe, 0x1F38,  0x1F3C, 
IBUS_KEY_apostrophe, 0x1F39,  0x1F3D, 
IBUS_KEY_apostrophe, 0x1F40,  0x1F44, 
IBUS_KEY_apostrophe, 0x1F41,  0x1F45, 
IBUS_KEY_apostrophe, 0x1F48,  0x1F4C, 
IBUS_KEY_apostrophe, 0x1F49,  0x1F4D, 
IBUS_KEY_apostrophe, 0x1F50,  0x1F54, 
IBUS_KEY_apostrophe, 0x1F51,  0x1F55, 
IBUS_KEY_apostrophe, 0x1F59,  0x1F5D, 
IBUS_KEY_apostrophe, 0x1F60,  0x1F64, 
IBUS_KEY_apostrophe, 0x1F61,  0x1F65, 
IBUS_KEY_apostrophe, 0x1F68,  0x1F6C, 
IBUS_KEY_apostrophe, 0x1F69,  0x1F6D, 
IBUS_KEY_apostrophe, 0x2395,  0x235E, 
IBUS_KEY_parenleft, IBUS_KEY_space,  0x02D8, 
IBUS_KEY_parenleft, IBUS_KEY_parenleft,  0x005B, 
IBUS_KEY_parenleft, IBUS_KEY_minus,  0x007B, 
IBUS_KEY_parenleft, IBUS_KEY_A,  0x0102, 
IBUS_KEY_parenleft, IBUS_KEY_G,  0x011E, 
IBUS_KEY_parenleft, IBUS_KEY_a,  0x0103, 
IBUS_KEY_parenleft, IBUS_KEY_c,  0x00A9, 
IBUS_KEY_parenleft, IBUS_KEY_g,  0x011F, 
IBUS_KEY_parenleft, IBUS_KEY_r,  0x00AE, 
IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F09, 
IBUS_KEY_parenleft, IBUS_KEY_Greek_EPSILON,  0x1F19, 
IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F29, 
IBUS_KEY_parenleft, IBUS_KEY_Greek_IOTA,  0x1F39, 
IBUS_KEY_parenleft, IBUS_KEY_Greek_OMICRON,  0x1F49, 
IBUS_KEY_parenleft, IBUS_KEY_Greek_RHO,  0x1FEC, 
IBUS_KEY_parenleft, IBUS_KEY_Greek_UPSILON,  0x1F59, 
IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1F69, 
IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F01, 
IBUS_KEY_parenleft, IBUS_KEY_Greek_epsilon,  0x1F11, 
IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F21, 
IBUS_KEY_parenleft, IBUS_KEY_Greek_iota,  0x1F31, 
IBUS_KEY_parenleft, IBUS_KEY_Greek_omicron,  0x1F41, 
IBUS_KEY_parenleft, IBUS_KEY_Greek_rho,  0x1FE5, 
IBUS_KEY_parenleft, IBUS_KEY_Greek_upsilon,  0x1F51, 
IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1F61, 
IBUS_KEY_parenright, IBUS_KEY_parenright,  0x005D, 
IBUS_KEY_parenright, IBUS_KEY_minus,  0x007D, 
IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F08, 
IBUS_KEY_parenright, IBUS_KEY_Greek_EPSILON,  0x1F18, 
IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F28, 
IBUS_KEY_parenright, IBUS_KEY_Greek_IOTA,  0x1F38, 
IBUS_KEY_parenright, IBUS_KEY_Greek_OMICRON,  0x1F48, 
IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1F68, 
IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F00, 
IBUS_KEY_parenright, IBUS_KEY_Greek_epsilon,  0x1F10, 
IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F20, 
IBUS_KEY_parenright, IBUS_KEY_Greek_iota,  0x1F30, 
IBUS_KEY_parenright, IBUS_KEY_Greek_omicron,  0x1F40, 
IBUS_KEY_parenright, IBUS_KEY_Greek_rho,  0x1FE4, 
IBUS_KEY_parenright, IBUS_KEY_Greek_upsilon,  0x1F50, 
IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1F60, 
IBUS_KEY_asterisk, IBUS_KEY_0,  0x00B0, 
IBUS_KEY_asterisk, IBUS_KEY_A,  0x00C5, 
IBUS_KEY_asterisk, IBUS_KEY_U,  0x016E, 
IBUS_KEY_asterisk, IBUS_KEY_a,  0x00E5, 
IBUS_KEY_asterisk, IBUS_KEY_u,  0x016F, 
IBUS_KEY_asterisk, IBUS_KEY_diaeresis,  0x2363, 
IBUS_KEY_asterisk, IBUS_KEY_emopencircle,  0x235F, 
IBUS_KEY_plus, IBUS_KEY_plus,  0x0023, 
IBUS_KEY_plus, IBUS_KEY_minus,  0x00B1, 
IBUS_KEY_plus, IBUS_KEY_O,  0x01A0, 
IBUS_KEY_plus, IBUS_KEY_U,  0x01AF, 
IBUS_KEY_plus, IBUS_KEY_o,  0x01A1, 
IBUS_KEY_plus, IBUS_KEY_u,  0x01B0, 
IBUS_KEY_comma, IBUS_KEY_space,  0x00B8, 
IBUS_KEY_comma, IBUS_KEY_quotedbl,  0x201E, 
IBUS_KEY_comma, IBUS_KEY_apostrophe,  0x201A, 
IBUS_KEY_comma, IBUS_KEY_comma,  0x00B8, 
IBUS_KEY_comma, IBUS_KEY_minus,  0x00AC, 
IBUS_KEY_comma, IBUS_KEY_A,  0x0104, 
IBUS_KEY_comma, IBUS_KEY_C,  0x00C7, 
IBUS_KEY_comma, IBUS_KEY_D,  0x1E10, 
IBUS_KEY_comma, IBUS_KEY_E,  0x0118, 
IBUS_KEY_comma, IBUS_KEY_G,  0x0122, 
IBUS_KEY_comma, IBUS_KEY_H,  0x1E28, 
IBUS_KEY_comma, IBUS_KEY_I,  0x012E, 
IBUS_KEY_comma, IBUS_KEY_K,  0x0136, 
IBUS_KEY_comma, IBUS_KEY_L,  0x013B, 
IBUS_KEY_comma, IBUS_KEY_N,  0x0145, 
IBUS_KEY_comma, IBUS_KEY_O,  0x01EA, 
IBUS_KEY_comma, IBUS_KEY_R,  0x0156, 
IBUS_KEY_comma, IBUS_KEY_S,  0x015E, 
IBUS_KEY_comma, IBUS_KEY_T,  0x0162, 
IBUS_KEY_comma, IBUS_KEY_U,  0x0172, 
IBUS_KEY_comma, IBUS_KEY_a,  0x0105, 
IBUS_KEY_comma, IBUS_KEY_c,  0x00E7, 
IBUS_KEY_comma, IBUS_KEY_d,  0x1E11, 
IBUS_KEY_comma, IBUS_KEY_e,  0x0119, 
IBUS_KEY_comma, IBUS_KEY_g,  0x0123, 
IBUS_KEY_comma, IBUS_KEY_h,  0x1E29, 
IBUS_KEY_comma, IBUS_KEY_i,  0x012F, 
IBUS_KEY_comma, IBUS_KEY_k,  0x0137, 
IBUS_KEY_comma, IBUS_KEY_l,  0x013C, 
IBUS_KEY_comma, IBUS_KEY_n,  0x0146, 
IBUS_KEY_comma, IBUS_KEY_o,  0x01EB, 
IBUS_KEY_comma, IBUS_KEY_r,  0x0157, 
IBUS_KEY_comma, IBUS_KEY_s,  0x015F, 
IBUS_KEY_comma, IBUS_KEY_t,  0x0163, 
IBUS_KEY_comma, IBUS_KEY_u,  0x0173, 
IBUS_KEY_minus, IBUS_KEY_space,  0x007E, 
IBUS_KEY_minus, IBUS_KEY_parenleft,  0x007B, 
IBUS_KEY_minus, IBUS_KEY_parenright,  0x007D, 
IBUS_KEY_minus, IBUS_KEY_plus,  0x00B1, 
IBUS_KEY_minus, IBUS_KEY_comma,  0x00AC, 
IBUS_KEY_minus, IBUS_KEY_slash,  0x233F, 
IBUS_KEY_minus, IBUS_KEY_colon,  0x00F7, 
IBUS_KEY_minus, IBUS_KEY_greater,  0x2192, 
IBUS_KEY_minus, IBUS_KEY_A,  0x0100, 
IBUS_KEY_minus, IBUS_KEY_D,  0x0110, 
IBUS_KEY_minus, IBUS_KEY_E,  0x0112, 
IBUS_KEY_minus, IBUS_KEY_I,  0x012A, 
IBUS_KEY_minus, IBUS_KEY_L,  0x00A3, 
IBUS_KEY_minus, IBUS_KEY_N,  0x00D1, 
IBUS_KEY_minus, IBUS_KEY_O,  0x014C, 
IBUS_KEY_minus, IBUS_KEY_U,  0x016A, 
IBUS_KEY_minus, IBUS_KEY_Y,  0x00A5, 
IBUS_KEY_minus, IBUS_KEY_backslash,  0x2340, 
IBUS_KEY_minus, IBUS_KEY_asciicircum,  0x00AF, 
IBUS_KEY_minus, IBUS_KEY_a,  0x0101, 
IBUS_KEY_minus, IBUS_KEY_d,  0x0111, 
IBUS_KEY_minus, IBUS_KEY_e,  0x0113, 
IBUS_KEY_minus, IBUS_KEY_i,  0x012B, 
IBUS_KEY_minus, IBUS_KEY_l,  0x00A3, 
IBUS_KEY_minus, IBUS_KEY_n,  0x00F1, 
IBUS_KEY_minus, IBUS_KEY_o,  0x014D, 
IBUS_KEY_minus, IBUS_KEY_u,  0x016B, 
IBUS_KEY_minus, IBUS_KEY_y,  0x00A5, 
IBUS_KEY_minus, 0x2191,  0x234F, 
IBUS_KEY_minus, 0x2193,  0x2356, 
IBUS_KEY_minus, IBUS_KEY_emopencircle,  0x2296, 
IBUS_KEY_period, IBUS_KEY_minus,  0x00B7, 
IBUS_KEY_period, IBUS_KEY_period,  0x2026, 
IBUS_KEY_period, IBUS_KEY_colon,  0x2235, 
IBUS_KEY_period, IBUS_KEY_less,  0x2039, 
IBUS_KEY_period, IBUS_KEY_equal,  0x2022, 
IBUS_KEY_period, IBUS_KEY_greater,  0x203A, 
IBUS_KEY_period, IBUS_KEY_A,  0x0226, 
IBUS_KEY_period, IBUS_KEY_B,  0x1E02, 
IBUS_KEY_period, IBUS_KEY_C,  0x010A, 
IBUS_KEY_period, IBUS_KEY_D,  0x1E0A, 
IBUS_KEY_period, IBUS_KEY_E,  0x0116, 
IBUS_KEY_period, IBUS_KEY_F,  0x1E1E, 
IBUS_KEY_period, IBUS_KEY_G,  0x0120, 
IBUS_KEY_period, IBUS_KEY_H,  0x1E22, 
IBUS_KEY_period, IBUS_KEY_I,  0x0130, 
IBUS_KEY_period, IBUS_KEY_M,  0x1E40, 
IBUS_KEY_period, IBUS_KEY_N,  0x1E44, 
IBUS_KEY_period, IBUS_KEY_O,  0x022E, 
IBUS_KEY_period, IBUS_KEY_P,  0x1E56, 
IBUS_KEY_period, IBUS_KEY_R,  0x1E58, 
IBUS_KEY_period, IBUS_KEY_S,  0x1E60, 
IBUS_KEY_period, IBUS_KEY_T,  0x1E6A, 
IBUS_KEY_period, IBUS_KEY_W,  0x1E86, 
IBUS_KEY_period, IBUS_KEY_X,  0x1E8A, 
IBUS_KEY_period, IBUS_KEY_Y,  0x1E8E, 
IBUS_KEY_period, IBUS_KEY_Z,  0x017B, 
IBUS_KEY_period, IBUS_KEY_asciicircum,  0x00B7, 
IBUS_KEY_period, IBUS_KEY_a,  0x0227, 
IBUS_KEY_period, IBUS_KEY_b,  0x1E03, 
IBUS_KEY_period, IBUS_KEY_c,  0x010B, 
IBUS_KEY_period, IBUS_KEY_d,  0x1E0B, 
IBUS_KEY_period, IBUS_KEY_e,  0x0117, 
IBUS_KEY_period, IBUS_KEY_f,  0x1E1F, 
IBUS_KEY_period, IBUS_KEY_g,  0x0121, 
IBUS_KEY_period, IBUS_KEY_h,  0x1E23, 
IBUS_KEY_period, IBUS_KEY_i,  0x0131, 
IBUS_KEY_period, IBUS_KEY_m,  0x1E41, 
IBUS_KEY_period, IBUS_KEY_n,  0x1E45, 
IBUS_KEY_period, IBUS_KEY_o,  0x022F, 
IBUS_KEY_period, IBUS_KEY_p,  0x1E57, 
IBUS_KEY_period, IBUS_KEY_r,  0x1E59, 
IBUS_KEY_period, IBUS_KEY_s,  0x1E61, 
IBUS_KEY_period, IBUS_KEY_t,  0x1E6B, 
IBUS_KEY_period, IBUS_KEY_w,  0x1E87, 
IBUS_KEY_period, IBUS_KEY_x,  0x1E8B, 
IBUS_KEY_period, IBUS_KEY_y,  0x1E8F, 
IBUS_KEY_period, IBUS_KEY_z,  0x017C, 
IBUS_KEY_period, 0x017F,  0x1E9B, 
IBUS_KEY_period, IBUS_KEY_Sacute,  0x1E64, 
IBUS_KEY_period, IBUS_KEY_Scaron,  0x1E66, 
IBUS_KEY_period, IBUS_KEY_sacute,  0x1E65, 
IBUS_KEY_period, IBUS_KEY_scaron,  0x1E67, 
IBUS_KEY_period, 0x1E62,  0x1E68, 
IBUS_KEY_period, 0x1E63,  0x1E69, 
IBUS_KEY_period, IBUS_KEY_emopencircle,  0x2299, 
IBUS_KEY_slash, IBUS_KEY_minus,  0x233F, 
IBUS_KEY_slash, IBUS_KEY_slash,  0x005C, 
IBUS_KEY_slash, IBUS_KEY_less,  0x005C, 
IBUS_KEY_slash, IBUS_KEY_equal,  0x2260, 
IBUS_KEY_slash, IBUS_KEY_C,  0x20A1, 
IBUS_KEY_slash, IBUS_KEY_D,  0x0110, 
IBUS_KEY_slash, IBUS_KEY_G,  0x01E4, 
IBUS_KEY_slash, IBUS_KEY_H,  0x0126, 
IBUS_KEY_slash, IBUS_KEY_I,  0x0197, 
IBUS_KEY_slash, IBUS_KEY_L,  0x0141, 
IBUS_KEY_slash, IBUS_KEY_O,  0x00D8, 
IBUS_KEY_slash, IBUS_KEY_T,  0x0166, 
IBUS_KEY_slash, IBUS_KEY_U,  0x00B5, 
IBUS_KEY_slash, IBUS_KEY_Z,  0x01B5, 
IBUS_KEY_slash, IBUS_KEY_asciicircum,  0x007C, 
IBUS_KEY_slash, IBUS_KEY_b,  0x0180, 
IBUS_KEY_slash, IBUS_KEY_c,  0x00A2, 
IBUS_KEY_slash, IBUS_KEY_d,  0x0111, 
IBUS_KEY_slash, IBUS_KEY_g,  0x01E5, 
IBUS_KEY_slash, IBUS_KEY_h,  0x0127, 
IBUS_KEY_slash, IBUS_KEY_i,  0x0268, 
IBUS_KEY_slash, IBUS_KEY_l,  0x0142, 
IBUS_KEY_slash, IBUS_KEY_m,  0x20A5, 
IBUS_KEY_slash, IBUS_KEY_o,  0x00F8, 
IBUS_KEY_slash, IBUS_KEY_t,  0x0167, 
IBUS_KEY_slash, IBUS_KEY_u,  0x00B5, 
IBUS_KEY_slash, IBUS_KEY_v,  0x221A, 
IBUS_KEY_slash, IBUS_KEY_z,  0x01B6, 
IBUS_KEY_slash, 0x0294,  0x02A1, 
IBUS_KEY_slash, 0x04AE,  0x04B0, 
IBUS_KEY_slash, 0x04AF,  0x04B1, 
IBUS_KEY_slash, IBUS_KEY_Cyrillic_ghe,  0x0493, 
IBUS_KEY_slash, IBUS_KEY_Cyrillic_ka,  0x049F, 
IBUS_KEY_slash, IBUS_KEY_Cyrillic_GHE,  0x0492, 
IBUS_KEY_slash, IBUS_KEY_Cyrillic_KA,  0x049E, 
IBUS_KEY_slash, IBUS_KEY_leftarrow,  0x219A, 
IBUS_KEY_slash, IBUS_KEY_rightarrow,  0x219B, 
IBUS_KEY_slash, 0x2194,  0x21AE, 
IBUS_KEY_slash, 0x2395,  0x2341, 
IBUS_KEY_0, IBUS_KEY_asterisk,  0x00B0, 
IBUS_KEY_0, IBUS_KEY_3,  0x2189, 
IBUS_KEY_0, IBUS_KEY_C,  0x00A9, 
IBUS_KEY_0, IBUS_KEY_S,  0x00A7, 
IBUS_KEY_0, IBUS_KEY_X,  0x00A4, 
IBUS_KEY_0, IBUS_KEY_asciicircum,  0x00B0, 
IBUS_KEY_0, IBUS_KEY_c,  0x00A9, 
IBUS_KEY_0, IBUS_KEY_s,  0x00A7, 
IBUS_KEY_0, IBUS_KEY_x,  0x00A4, 
IBUS_KEY_0, IBUS_KEY_asciitilde,  0x236C, 
IBUS_KEY_1, IBUS_KEY_2,  0x00BD, 
IBUS_KEY_1, IBUS_KEY_3,  0x2153, 
IBUS_KEY_1, IBUS_KEY_4,  0x00BC, 
IBUS_KEY_1, IBUS_KEY_5,  0x2155, 
IBUS_KEY_1, IBUS_KEY_6,  0x2159, 
IBUS_KEY_1, IBUS_KEY_7,  0x2150, 
IBUS_KEY_1, IBUS_KEY_8,  0x215B, 
IBUS_KEY_1, IBUS_KEY_9,  0x2151, 
IBUS_KEY_1, IBUS_KEY_S,  0x00B9, 
IBUS_KEY_1, IBUS_KEY_asciicircum,  0x00B9, 
IBUS_KEY_1, IBUS_KEY_s,  0x00B9, 
IBUS_KEY_2, IBUS_KEY_3,  0x2154, 
IBUS_KEY_2, IBUS_KEY_5,  0x2156, 
IBUS_KEY_2, IBUS_KEY_S,  0x00B2, 
IBUS_KEY_2, IBUS_KEY_asciicircum,  0x00B2, 
IBUS_KEY_2, IBUS_KEY_s,  0x00B2, 
IBUS_KEY_3, IBUS_KEY_4,  0x00BE, 
IBUS_KEY_3, IBUS_KEY_5,  0x2157, 
IBUS_KEY_3, IBUS_KEY_8,  0x215C, 
IBUS_KEY_3, IBUS_KEY_S,  0x00B3, 
IBUS_KEY_3, IBUS_KEY_asciicircum,  0x00B3, 
IBUS_KEY_3, IBUS_KEY_s,  0x00B3, 
IBUS_KEY_4, IBUS_KEY_5,  0x2158, 
IBUS_KEY_5, IBUS_KEY_6,  0x215A, 
IBUS_KEY_5, IBUS_KEY_8,  0x215D, 
IBUS_KEY_7, IBUS_KEY_8,  0x215E, 
IBUS_KEY_8, IBUS_KEY_8,  0x221E, 
IBUS_KEY_colon, IBUS_KEY_parenleft,  0x2639, 
IBUS_KEY_colon, IBUS_KEY_parenright,  0x263A, 
IBUS_KEY_colon, IBUS_KEY_minus,  0x00F7, 
IBUS_KEY_colon, IBUS_KEY_period,  0x2234, 
IBUS_KEY_colon, 0x2395,  0x2360, 
IBUS_KEY_semicolon, IBUS_KEY_A,  0x0104, 
IBUS_KEY_semicolon, IBUS_KEY_E,  0x0118, 
IBUS_KEY_semicolon, IBUS_KEY_I,  0x012E, 
IBUS_KEY_semicolon, IBUS_KEY_O,  0x01EA, 
IBUS_KEY_semicolon, IBUS_KEY_S,  0x0218, 
IBUS_KEY_semicolon, IBUS_KEY_T,  0x021A, 
IBUS_KEY_semicolon, IBUS_KEY_U,  0x0172, 
IBUS_KEY_semicolon, IBUS_KEY_underscore,  0x236E, 
IBUS_KEY_semicolon, IBUS_KEY_a,  0x0105, 
IBUS_KEY_semicolon, IBUS_KEY_e,  0x0119, 
IBUS_KEY_semicolon, IBUS_KEY_i,  0x012F, 
IBUS_KEY_semicolon, IBUS_KEY_o,  0x01EB, 
IBUS_KEY_semicolon, IBUS_KEY_s,  0x0219, 
IBUS_KEY_semicolon, IBUS_KEY_t,  0x021B, 
IBUS_KEY_semicolon, IBUS_KEY_u,  0x0173, 
IBUS_KEY_less, IBUS_KEY_space,  0x02C7, 
IBUS_KEY_less, IBUS_KEY_quotedbl,  0x201C, 
IBUS_KEY_less, IBUS_KEY_apostrophe,  0x2018, 
IBUS_KEY_less, IBUS_KEY_minus,  0x2190, 
IBUS_KEY_less, IBUS_KEY_slash,  0x005C, 
IBUS_KEY_less, IBUS_KEY_3,  0x2665, 
IBUS_KEY_less, IBUS_KEY_less,  0x00AB, 
IBUS_KEY_less, IBUS_KEY_equal,  0x2264, 
IBUS_KEY_less, IBUS_KEY_greater,  0x22C4, 
IBUS_KEY_less, IBUS_KEY_C,  0x010C, 
IBUS_KEY_less, IBUS_KEY_D,  0x010E, 
IBUS_KEY_less, IBUS_KEY_E,  0x011A, 
IBUS_KEY_less, IBUS_KEY_L,  0x013D, 
IBUS_KEY_less, IBUS_KEY_N,  0x0147, 
IBUS_KEY_less, IBUS_KEY_R,  0x0158, 
IBUS_KEY_less, IBUS_KEY_S,  0x0160, 
IBUS_KEY_less, IBUS_KEY_T,  0x0164, 
IBUS_KEY_less, IBUS_KEY_Z,  0x017D, 
IBUS_KEY_less, IBUS_KEY_underscore,  0x2264, 
IBUS_KEY_less, IBUS_KEY_c,  0x010D, 
IBUS_KEY_less, IBUS_KEY_d,  0x010F, 
IBUS_KEY_less, IBUS_KEY_e,  0x011B, 
IBUS_KEY_less, IBUS_KEY_l,  0x013E, 
IBUS_KEY_less, IBUS_KEY_n,  0x0148, 
IBUS_KEY_less, IBUS_KEY_r,  0x0159, 
IBUS_KEY_less, IBUS_KEY_s,  0x0161, 
IBUS_KEY_less, IBUS_KEY_t,  0x0165, 
IBUS_KEY_less, IBUS_KEY_z,  0x017E, 
IBUS_KEY_less, 0x0338,  0x226E, 
IBUS_KEY_less, 0x2395,  0x2343, 
IBUS_KEY_equal, IBUS_KEY_slash,  0x2260, 
IBUS_KEY_equal, IBUS_KEY_greater,  0x21D2, 
IBUS_KEY_equal, IBUS_KEY_C,  0x20AC, 
IBUS_KEY_equal, IBUS_KEY_E,  0x20AC, 
IBUS_KEY_equal, IBUS_KEY_L,  0x20A4, 
IBUS_KEY_equal, IBUS_KEY_N,  0x20A6, 
IBUS_KEY_equal, IBUS_KEY_O,  0x0150, 
IBUS_KEY_equal, IBUS_KEY_R,  0x20B9, 
IBUS_KEY_equal, IBUS_KEY_U,  0x0170, 
IBUS_KEY_equal, IBUS_KEY_W,  0x20A9, 
IBUS_KEY_equal, IBUS_KEY_Y,  0x00A5, 
IBUS_KEY_equal, IBUS_KEY_underscore,  0x2261, 
IBUS_KEY_equal, IBUS_KEY_c,  0x20AC, 
IBUS_KEY_equal, IBUS_KEY_d,  0x20AB, 
IBUS_KEY_equal, IBUS_KEY_e,  0x20AC, 
IBUS_KEY_equal, IBUS_KEY_l,  0x00A3, 
IBUS_KEY_equal, IBUS_KEY_o,  0x0151, 
IBUS_KEY_equal, IBUS_KEY_r,  0x20B9, 
IBUS_KEY_equal, IBUS_KEY_u,  0x0171, 
IBUS_KEY_equal, IBUS_KEY_y,  0x00A5, 
IBUS_KEY_equal, 0x0338,  0x2260, 
IBUS_KEY_equal, IBUS_KEY_Cyrillic_u,  0x04F3, 
IBUS_KEY_equal, IBUS_KEY_Cyrillic_IE,  0x20AC, 
IBUS_KEY_equal, IBUS_KEY_Cyrillic_ES,  0x20AC, 
IBUS_KEY_equal, IBUS_KEY_Cyrillic_U,  0x04F2, 
IBUS_KEY_equal, 0x2395,  0x2338, 
IBUS_KEY_greater, IBUS_KEY_space,  0x005E, 
IBUS_KEY_greater, IBUS_KEY_quotedbl,  0x201D, 
IBUS_KEY_greater, IBUS_KEY_apostrophe,  0x2019, 
IBUS_KEY_greater, IBUS_KEY_less,  0x22C4, 
IBUS_KEY_greater, IBUS_KEY_equal,  0x2265, 
IBUS_KEY_greater, IBUS_KEY_greater,  0x00BB, 
IBUS_KEY_greater, IBUS_KEY_A,  0x00C2, 
IBUS_KEY_greater, IBUS_KEY_E,  0x00CA, 
IBUS_KEY_greater, IBUS_KEY_I,  0x00CE, 
IBUS_KEY_greater, IBUS_KEY_O,  0x00D4, 
IBUS_KEY_greater, IBUS_KEY_U,  0x00DB, 
IBUS_KEY_greater, IBUS_KEY_underscore,  0x2265, 
IBUS_KEY_greater, IBUS_KEY_a,  0x00E2, 
IBUS_KEY_greater, IBUS_KEY_e,  0x00EA, 
IBUS_KEY_greater, IBUS_KEY_i,  0x00EE, 
IBUS_KEY_greater, IBUS_KEY_o,  0x00F4, 
IBUS_KEY_greater, IBUS_KEY_u,  0x00FB, 
IBUS_KEY_greater, IBUS_KEY_diaeresis,  0x2369, 
IBUS_KEY_greater, 0x0338,  0x226F, 
IBUS_KEY_greater, 0x2395,  0x2344, 
IBUS_KEY_question, IBUS_KEY_exclam,  0x2E18, 
IBUS_KEY_question, IBUS_KEY_question,  0x00BF, 
IBUS_KEY_question, IBUS_KEY_A,  0x1EA2, 
IBUS_KEY_question, IBUS_KEY_E,  0x1EBA, 
IBUS_KEY_question, IBUS_KEY_I,  0x1EC8, 
IBUS_KEY_question, IBUS_KEY_O,  0x1ECE, 
IBUS_KEY_question, IBUS_KEY_U,  0x1EE6, 
IBUS_KEY_question, IBUS_KEY_Y,  0x1EF6, 
IBUS_KEY_question, IBUS_KEY_a,  0x1EA3, 
IBUS_KEY_question, IBUS_KEY_e,  0x1EBB, 
IBUS_KEY_question, IBUS_KEY_i,  0x1EC9, 
IBUS_KEY_question, IBUS_KEY_o,  0x1ECF, 
IBUS_KEY_question, IBUS_KEY_u,  0x1EE7, 
IBUS_KEY_question, IBUS_KEY_y,  0x1EF7, 
IBUS_KEY_question, IBUS_KEY_Acircumflex,  0x1EA8, 
IBUS_KEY_question, IBUS_KEY_Ecircumflex,  0x1EC2, 
IBUS_KEY_question, IBUS_KEY_Ocircumflex,  0x1ED4, 
IBUS_KEY_question, IBUS_KEY_acircumflex,  0x1EA9, 
IBUS_KEY_question, IBUS_KEY_ecircumflex,  0x1EC3, 
IBUS_KEY_question, IBUS_KEY_ocircumflex,  0x1ED5, 
IBUS_KEY_question, IBUS_KEY_Abreve,  0x1EB2, 
IBUS_KEY_question, IBUS_KEY_abreve,  0x1EB3, 
IBUS_KEY_question, 0x2395,  0x2370, 
IBUS_KEY_A, IBUS_KEY_quotedbl,  0x00C4, 
IBUS_KEY_A, IBUS_KEY_apostrophe,  0x00C1, 
IBUS_KEY_A, IBUS_KEY_parenleft,  0x0102, 
IBUS_KEY_A, IBUS_KEY_asterisk,  0x00C5, 
IBUS_KEY_A, IBUS_KEY_comma,  0x0104, 
IBUS_KEY_A, IBUS_KEY_minus,  0x0100, 
IBUS_KEY_A, IBUS_KEY_semicolon,  0x0104, 
IBUS_KEY_A, IBUS_KEY_greater,  0x00C2, 
IBUS_KEY_A, IBUS_KEY_A,  0x00C5, 
IBUS_KEY_A, IBUS_KEY_E,  0x00C6, 
IBUS_KEY_A, IBUS_KEY_T,  0x0040, 
IBUS_KEY_A, IBUS_KEY_asciicircum,  0x00C2, 
IBUS_KEY_A, IBUS_KEY_underscore,  0x0100, 
IBUS_KEY_A, IBUS_KEY_grave,  0x00C0, 
IBUS_KEY_A, IBUS_KEY_asciitilde,  0x00C3, 
IBUS_KEY_A, IBUS_KEY_diaeresis,  0x00C4, 
IBUS_KEY_A, IBUS_KEY_acute,  0x00C1, 
IBUS_KEY_B, IBUS_KEY_period,  0x1E02, 
IBUS_KEY_C, IBUS_KEY_apostrophe,  0x0106, 
IBUS_KEY_C, IBUS_KEY_comma,  0x00C7, 
IBUS_KEY_C, IBUS_KEY_period,  0x010A, 
IBUS_KEY_C, IBUS_KEY_slash,  0x20A1, 
IBUS_KEY_C, IBUS_KEY_0,  0x00A9, 
IBUS_KEY_C, IBUS_KEY_less,  0x010C, 
IBUS_KEY_C, IBUS_KEY_equal,  0x20AC, 
IBUS_KEY_C, IBUS_KEY_E,  0x20A0, 
IBUS_KEY_C, IBUS_KEY_O,  0x00A9, 
IBUS_KEY_C, IBUS_KEY_o,  0x00A9, 
IBUS_KEY_C, IBUS_KEY_r,  0x20A2, 
IBUS_KEY_C, IBUS_KEY_bar,  0x00A2, 
IBUS_KEY_D, IBUS_KEY_comma,  0x1E10, 
IBUS_KEY_D, IBUS_KEY_minus,  0x0110, 
IBUS_KEY_D, IBUS_KEY_period,  0x1E0A, 
IBUS_KEY_D, IBUS_KEY_less,  0x010E, 
IBUS_KEY_D, IBUS_KEY_H,  0x00D0, 
IBUS_KEY_E, IBUS_KEY_quotedbl,  0x00CB, 
IBUS_KEY_E, IBUS_KEY_apostrophe,  0x00C9, 
IBUS_KEY_E, IBUS_KEY_comma,  0x0118, 
IBUS_KEY_E, IBUS_KEY_minus,  0x0112, 
IBUS_KEY_E, IBUS_KEY_period,  0x0116, 
IBUS_KEY_E, IBUS_KEY_semicolon,  0x0118, 
IBUS_KEY_E, IBUS_KEY_less,  0x011A, 
IBUS_KEY_E, IBUS_KEY_equal,  0x20AC, 
IBUS_KEY_E, IBUS_KEY_greater,  0x00CA, 
IBUS_KEY_E, IBUS_KEY_asciicircum,  0x00CA, 
IBUS_KEY_E, IBUS_KEY_underscore,  0x0112, 
IBUS_KEY_E, IBUS_KEY_grave,  0x00C8, 
IBUS_KEY_E, IBUS_KEY_diaeresis,  0x00CB, 
IBUS_KEY_E, IBUS_KEY_acute,  0x00C9, 
IBUS_KEY_F, IBUS_KEY_period,  0x1E1E, 
IBUS_KEY_F, IBUS_KEY_i,  0xFB03, 
IBUS_KEY_F, IBUS_KEY_l,  0xFB04, 
IBUS_KEY_F, IBUS_KEY_r,  0x20A3, 
IBUS_KEY_G, IBUS_KEY_parenleft,  0x011E, 
IBUS_KEY_G, IBUS_KEY_comma,  0x0122, 
IBUS_KEY_G, IBUS_KEY_period,  0x0120, 
IBUS_KEY_G, IBUS_KEY_U,  0x011E, 
IBUS_KEY_G, IBUS_KEY_breve,  0x011E, 
IBUS_KEY_H, IBUS_KEY_comma,  0x1E28, 
IBUS_KEY_I, IBUS_KEY_quotedbl,  0x00CF, 
IBUS_KEY_I, IBUS_KEY_apostrophe,  0x00CD, 
IBUS_KEY_I, IBUS_KEY_comma,  0x012E, 
IBUS_KEY_I, IBUS_KEY_minus,  0x012A, 
IBUS_KEY_I, IBUS_KEY_period,  0x0130, 
IBUS_KEY_I, IBUS_KEY_semicolon,  0x012E, 
IBUS_KEY_I, IBUS_KEY_greater,  0x00CE, 
IBUS_KEY_I, IBUS_KEY_J,  0x0132, 
IBUS_KEY_I, IBUS_KEY_asciicircum,  0x00CE, 
IBUS_KEY_I, IBUS_KEY_underscore,  0x012A, 
IBUS_KEY_I, IBUS_KEY_grave,  0x00CC, 
IBUS_KEY_I, IBUS_KEY_j,  0x0132, 
IBUS_KEY_I, IBUS_KEY_asciitilde,  0x0128, 
IBUS_KEY_I, IBUS_KEY_diaeresis,  0x00CF, 
IBUS_KEY_I, IBUS_KEY_acute,  0x00CD, 
IBUS_KEY_K, IBUS_KEY_comma,  0x0136, 
IBUS_KEY_L, IBUS_KEY_apostrophe,  0x0139, 
IBUS_KEY_L, IBUS_KEY_comma,  0x013B, 
IBUS_KEY_L, IBUS_KEY_minus,  0x00A3, 
IBUS_KEY_L, IBUS_KEY_slash,  0x0141, 
IBUS_KEY_L, IBUS_KEY_less,  0x013D, 
IBUS_KEY_L, IBUS_KEY_equal,  0x20A4, 
IBUS_KEY_L, IBUS_KEY_V,  0x007C, 
IBUS_KEY_M, IBUS_KEY_period,  0x1E40, 
IBUS_KEY_N, IBUS_KEY_apostrophe,  0x0143, 
IBUS_KEY_N, IBUS_KEY_comma,  0x0145, 
IBUS_KEY_N, IBUS_KEY_minus,  0x00D1, 
IBUS_KEY_N, IBUS_KEY_less,  0x0147, 
IBUS_KEY_N, IBUS_KEY_equal,  0x20A6, 
IBUS_KEY_N, IBUS_KEY_G,  0x014A, 
IBUS_KEY_N, IBUS_KEY_O,  0x2116, 
IBUS_KEY_N, IBUS_KEY_o,  0x2116, 
IBUS_KEY_N, IBUS_KEY_asciitilde,  0x00D1, 
IBUS_KEY_O, IBUS_KEY_quotedbl,  0x00D6, 
IBUS_KEY_O, IBUS_KEY_apostrophe,  0x00D3, 
IBUS_KEY_O, IBUS_KEY_comma,  0x01EA, 
IBUS_KEY_O, IBUS_KEY_minus,  0x014C, 
IBUS_KEY_O, IBUS_KEY_slash,  0x00D8, 
IBUS_KEY_O, IBUS_KEY_semicolon,  0x01EA, 
IBUS_KEY_O, IBUS_KEY_greater,  0x00D4, 
IBUS_KEY_O, IBUS_KEY_A,  0x24B6, 
IBUS_KEY_O, IBUS_KEY_C,  0x00A9, 
IBUS_KEY_O, IBUS_KEY_E,  0x0152, 
IBUS_KEY_O, IBUS_KEY_R,  0x00AE, 
IBUS_KEY_O, IBUS_KEY_S,  0x00A7, 
IBUS_KEY_O, IBUS_KEY_X,  0x00A4, 
IBUS_KEY_O, IBUS_KEY_asciicircum,  0x00D4, 
IBUS_KEY_O, IBUS_KEY_underscore,  0x014C, 
IBUS_KEY_O, IBUS_KEY_grave,  0x00D2, 
IBUS_KEY_O, IBUS_KEY_c,  0x00A9, 
IBUS_KEY_O, IBUS_KEY_r,  0x00AE, 
IBUS_KEY_O, IBUS_KEY_x,  0x00A4, 
IBUS_KEY_O, IBUS_KEY_asciitilde,  0x00D5, 
IBUS_KEY_O, IBUS_KEY_diaeresis,  0x00D6, 
IBUS_KEY_O, IBUS_KEY_acute,  0x00D3, 
IBUS_KEY_P, IBUS_KEY_exclam,  0x00B6, 
IBUS_KEY_P, IBUS_KEY_period,  0x1E56, 
IBUS_KEY_P, IBUS_KEY_P,  0x00B6, 
IBUS_KEY_P, IBUS_KEY_t,  0x20A7, 
IBUS_KEY_R, IBUS_KEY_apostrophe,  0x0154, 
IBUS_KEY_R, IBUS_KEY_comma,  0x0156, 
IBUS_KEY_R, IBUS_KEY_less,  0x0158, 
IBUS_KEY_R, IBUS_KEY_equal,  0x20B9, 
IBUS_KEY_R, IBUS_KEY_O,  0x00AE, 
IBUS_KEY_R, IBUS_KEY_o,  0x00AE, 
IBUS_KEY_R, IBUS_KEY_s,  0x20A8, 
IBUS_KEY_S, IBUS_KEY_exclam,  0x00A7, 
IBUS_KEY_S, IBUS_KEY_apostrophe,  0x015A, 
IBUS_KEY_S, IBUS_KEY_comma,  0x015E, 
IBUS_KEY_S, IBUS_KEY_period,  0x1E60, 
IBUS_KEY_S, IBUS_KEY_0,  0x00A7, 
IBUS_KEY_S, IBUS_KEY_1,  0x00B9, 
IBUS_KEY_S, IBUS_KEY_2,  0x00B2, 
IBUS_KEY_S, IBUS_KEY_3,  0x00B3, 
IBUS_KEY_S, IBUS_KEY_semicolon,  0x0218, 
IBUS_KEY_S, IBUS_KEY_less,  0x0160, 
IBUS_KEY_S, IBUS_KEY_M,  0x2120, 
IBUS_KEY_S, IBUS_KEY_O,  0x00A7, 
IBUS_KEY_S, IBUS_KEY_S,  0x1E9E, 
IBUS_KEY_S, IBUS_KEY_m,  0x2120, 
IBUS_KEY_S, IBUS_KEY_cedilla,  0x015E, 
IBUS_KEY_T, IBUS_KEY_comma,  0x0162, 
IBUS_KEY_T, IBUS_KEY_minus,  0x0166, 
IBUS_KEY_T, IBUS_KEY_period,  0x1E6A, 
IBUS_KEY_T, IBUS_KEY_slash,  0x0166, 
IBUS_KEY_T, IBUS_KEY_semicolon,  0x021A, 
IBUS_KEY_T, IBUS_KEY_less,  0x0164, 
IBUS_KEY_T, IBUS_KEY_H,  0x00DE, 
IBUS_KEY_T, IBUS_KEY_M,  0x2122, 
IBUS_KEY_T, IBUS_KEY_m,  0x2122, 
IBUS_KEY_U, IBUS_KEY_quotedbl,  0x00DC, 
IBUS_KEY_U, IBUS_KEY_apostrophe,  0x00DA, 
IBUS_KEY_U, IBUS_KEY_asterisk,  0x016E, 
IBUS_KEY_U, IBUS_KEY_comma,  0x0172, 
IBUS_KEY_U, IBUS_KEY_minus,  0x016A, 
IBUS_KEY_U, IBUS_KEY_slash,  0x00B5, 
IBUS_KEY_U, IBUS_KEY_semicolon,  0x0172, 
IBUS_KEY_U, IBUS_KEY_greater,  0x00DB, 
IBUS_KEY_U, IBUS_KEY_A,  0x0102, 
IBUS_KEY_U, IBUS_KEY_E,  0x0114, 
IBUS_KEY_U, IBUS_KEY_G,  0x011E, 
IBUS_KEY_U, IBUS_KEY_I,  0x012C, 
IBUS_KEY_U, IBUS_KEY_O,  0x014E, 
IBUS_KEY_U, IBUS_KEY_U,  0x016C, 
IBUS_KEY_U, IBUS_KEY_asciicircum,  0x00DB, 
IBUS_KEY_U, IBUS_KEY_underscore,  0x016A, 
IBUS_KEY_U, IBUS_KEY_grave,  0x00D9, 
IBUS_KEY_U, IBUS_KEY_a,  0x0103, 
IBUS_KEY_U, IBUS_KEY_e,  0x0115, 
IBUS_KEY_U, IBUS_KEY_g,  0x011F, 
IBUS_KEY_U, IBUS_KEY_i,  0x012D, 
IBUS_KEY_U, IBUS_KEY_o,  0x014F, 
IBUS_KEY_U, IBUS_KEY_u,  0x016D, 
IBUS_KEY_U, IBUS_KEY_asciitilde,  0x0168, 
IBUS_KEY_U, IBUS_KEY_diaeresis,  0x00DC, 
IBUS_KEY_U, IBUS_KEY_acute,  0x00DA, 
IBUS_KEY_U, 0x0228,  0x1E1C, 
IBUS_KEY_U, 0x0229,  0x1E1D, 
IBUS_KEY_U, IBUS_KEY_Cyrillic_a,  0x04D1, 
IBUS_KEY_U, IBUS_KEY_Cyrillic_ie,  0x04D7, 
IBUS_KEY_U, IBUS_KEY_Cyrillic_i,  0x0439, 
IBUS_KEY_U, IBUS_KEY_Cyrillic_u,  0x045E, 
IBUS_KEY_U, IBUS_KEY_Cyrillic_zhe,  0x04C2, 
IBUS_KEY_U, IBUS_KEY_Cyrillic_A,  0x04D0, 
IBUS_KEY_U, IBUS_KEY_Cyrillic_IE,  0x04D6, 
IBUS_KEY_U, IBUS_KEY_Cyrillic_I,  0x0419, 
IBUS_KEY_U, IBUS_KEY_Cyrillic_U,  0x040E, 
IBUS_KEY_U, IBUS_KEY_Cyrillic_ZHE,  0x04C1, 
IBUS_KEY_U, IBUS_KEY_Greek_ALPHA,  0x1FB8, 
IBUS_KEY_U, IBUS_KEY_Greek_IOTA,  0x1FD8, 
IBUS_KEY_U, IBUS_KEY_Greek_UPSILON,  0x1FE8, 
IBUS_KEY_U, IBUS_KEY_Greek_alpha,  0x1FB0, 
IBUS_KEY_U, IBUS_KEY_Greek_iota,  0x1FD0, 
IBUS_KEY_U, IBUS_KEY_Greek_upsilon,  0x1FE0, 
IBUS_KEY_U, 0x1EA0,  0x1EB6, 
IBUS_KEY_U, 0x1EA1,  0x1EB7, 
IBUS_KEY_V, IBUS_KEY_L,  0x007C, 
IBUS_KEY_W, IBUS_KEY_equal,  0x20A9, 
IBUS_KEY_W, IBUS_KEY_asciicircum,  0x0174, 
IBUS_KEY_X, IBUS_KEY_0,  0x00A4, 
IBUS_KEY_X, IBUS_KEY_O,  0x00A4, 
IBUS_KEY_X, IBUS_KEY_o,  0x00A4, 
IBUS_KEY_Y, IBUS_KEY_quotedbl,  0x0178, 
IBUS_KEY_Y, IBUS_KEY_apostrophe,  0x00DD, 
IBUS_KEY_Y, IBUS_KEY_minus,  0x00A5, 
IBUS_KEY_Y, IBUS_KEY_equal,  0x00A5, 
IBUS_KEY_Y, IBUS_KEY_asciicircum,  0x0176, 
IBUS_KEY_Y, IBUS_KEY_diaeresis,  0x0178, 
IBUS_KEY_Y, IBUS_KEY_acute,  0x00DD, 
IBUS_KEY_Z, IBUS_KEY_apostrophe,  0x0179, 
IBUS_KEY_Z, IBUS_KEY_period,  0x017B, 
IBUS_KEY_Z, IBUS_KEY_less,  0x017D, 
IBUS_KEY_bracketleft, IBUS_KEY_bracketright,  0x2337, 
IBUS_KEY_backslash, IBUS_KEY_minus,  0x2340, 
IBUS_KEY_backslash, 0x2395,  0x2342, 
IBUS_KEY_backslash, IBUS_KEY_emopencircle,  0x2349, 
IBUS_KEY_bracketright, IBUS_KEY_bracketleft,  0x2337, 
IBUS_KEY_asciicircum, IBUS_KEY_space,  0x005E, 
IBUS_KEY_asciicircum, IBUS_KEY_parenleft,  0x207D, 
IBUS_KEY_asciicircum, IBUS_KEY_parenright,  0x207E, 
IBUS_KEY_asciicircum, IBUS_KEY_plus,  0x207A, 
IBUS_KEY_asciicircum, IBUS_KEY_minus,  0x00AF, 
IBUS_KEY_asciicircum, IBUS_KEY_period,  0x00B7, 
IBUS_KEY_asciicircum, IBUS_KEY_slash,  0x007C, 
IBUS_KEY_asciicircum, IBUS_KEY_0,  0x2070, 
IBUS_KEY_asciicircum, IBUS_KEY_1,  0x00B9, 
IBUS_KEY_asciicircum, IBUS_KEY_2,  0x00B2, 
IBUS_KEY_asciicircum, IBUS_KEY_3,  0x00B3, 
IBUS_KEY_asciicircum, IBUS_KEY_4,  0x2074, 
IBUS_KEY_asciicircum, IBUS_KEY_5,  0x2075, 
IBUS_KEY_asciicircum, IBUS_KEY_6,  0x2076, 
IBUS_KEY_asciicircum, IBUS_KEY_7,  0x2077, 
IBUS_KEY_asciicircum, IBUS_KEY_8,  0x2078, 
IBUS_KEY_asciicircum, IBUS_KEY_9,  0x2079, 
IBUS_KEY_asciicircum, IBUS_KEY_equal,  0x207C, 
IBUS_KEY_asciicircum, IBUS_KEY_A,  0x00C2, 
IBUS_KEY_asciicircum, IBUS_KEY_C,  0x0108, 
IBUS_KEY_asciicircum, IBUS_KEY_E,  0x00CA, 
IBUS_KEY_asciicircum, IBUS_KEY_G,  0x011C, 
IBUS_KEY_asciicircum, IBUS_KEY_H,  0x0124, 
IBUS_KEY_asciicircum, IBUS_KEY_I,  0x00CE, 
IBUS_KEY_asciicircum, IBUS_KEY_J,  0x0134, 
IBUS_KEY_asciicircum, IBUS_KEY_O,  0x00D4, 
IBUS_KEY_asciicircum, IBUS_KEY_S,  0x015C, 
IBUS_KEY_asciicircum, IBUS_KEY_U,  0x00DB, 
IBUS_KEY_asciicircum, IBUS_KEY_W,  0x0174, 
IBUS_KEY_asciicircum, IBUS_KEY_Y,  0x0176, 
IBUS_KEY_asciicircum, IBUS_KEY_Z,  0x1E90, 
IBUS_KEY_asciicircum, IBUS_KEY_underscore,  0x00AF, 
IBUS_KEY_asciicircum, IBUS_KEY_a,  0x00E2, 
IBUS_KEY_asciicircum, IBUS_KEY_c,  0x0109, 
IBUS_KEY_asciicircum, IBUS_KEY_e,  0x00EA, 
IBUS_KEY_asciicircum, IBUS_KEY_g,  0x011D, 
IBUS_KEY_asciicircum, IBUS_KEY_h,  0x0125, 
IBUS_KEY_asciicircum, IBUS_KEY_i,  0x00EE, 
IBUS_KEY_asciicircum, IBUS_KEY_j,  0x0135, 
IBUS_KEY_asciicircum, IBUS_KEY_o,  0x00F4, 
IBUS_KEY_asciicircum, IBUS_KEY_s,  0x015D, 
IBUS_KEY_asciicircum, IBUS_KEY_u,  0x00FB, 
IBUS_KEY_asciicircum, IBUS_KEY_w,  0x0175, 
IBUS_KEY_asciicircum, IBUS_KEY_y,  0x0177, 
IBUS_KEY_asciicircum, IBUS_KEY_z,  0x1E91, 
IBUS_KEY_asciicircum, 0x1EA0,  0x1EAC, 
IBUS_KEY_asciicircum, 0x1EA1,  0x1EAD, 
IBUS_KEY_asciicircum, 0x1EB8,  0x1EC6, 
IBUS_KEY_asciicircum, 0x1EB9,  0x1EC7, 
IBUS_KEY_asciicircum, 0x1ECC,  0x1ED8, 
IBUS_KEY_asciicircum, 0x1ECD,  0x1ED9, 
IBUS_KEY_asciicircum, 0x2212,  0x207B, 
IBUS_KEY_asciicircum, 0x4E00,  0x3192, 
IBUS_KEY_asciicircum, 0x4E01,  0x319C, 
IBUS_KEY_asciicircum, 0x4E09,  0x3194, 
IBUS_KEY_asciicircum, 0x4E0A,  0x3196, 
IBUS_KEY_asciicircum, 0x4E0B,  0x3198, 
IBUS_KEY_asciicircum, 0x4E19,  0x319B, 
IBUS_KEY_asciicircum, 0x4E2D,  0x3197, 
IBUS_KEY_asciicircum, 0x4E59,  0x319A, 
IBUS_KEY_asciicircum, 0x4E8C,  0x3193, 
IBUS_KEY_asciicircum, 0x4EBA,  0x319F, 
IBUS_KEY_asciicircum, 0x56DB,  0x3195, 
IBUS_KEY_asciicircum, 0x5730,  0x319E, 
IBUS_KEY_asciicircum, 0x5929,  0x319D, 
IBUS_KEY_asciicircum, 0x7532,  0x3199, 
IBUS_KEY_asciicircum, IBUS_KEY_KP_Space,  0x00B2, 
IBUS_KEY_asciicircum, IBUS_KEY_KP_Add,  0x207A, 
IBUS_KEY_asciicircum, IBUS_KEY_KP_0,  0x2070, 
IBUS_KEY_asciicircum, IBUS_KEY_KP_1,  0x00B9, 
IBUS_KEY_asciicircum, IBUS_KEY_KP_2,  0x00B2, 
IBUS_KEY_asciicircum, IBUS_KEY_KP_3,  0x00B3, 
IBUS_KEY_asciicircum, IBUS_KEY_KP_4,  0x2074, 
IBUS_KEY_asciicircum, IBUS_KEY_KP_5,  0x2075, 
IBUS_KEY_asciicircum, IBUS_KEY_KP_6,  0x2076, 
IBUS_KEY_asciicircum, IBUS_KEY_KP_7,  0x2077, 
IBUS_KEY_asciicircum, IBUS_KEY_KP_8,  0x2078, 
IBUS_KEY_asciicircum, IBUS_KEY_KP_9,  0x2079, 
IBUS_KEY_asciicircum, IBUS_KEY_KP_Equal,  0x207C, 
IBUS_KEY_underscore, IBUS_KEY_apostrophe,  0x2358, 
IBUS_KEY_underscore, IBUS_KEY_parenleft,  0x208D, 
IBUS_KEY_underscore, IBUS_KEY_parenright,  0x208E, 
IBUS_KEY_underscore, IBUS_KEY_plus,  0x208A, 
IBUS_KEY_underscore, IBUS_KEY_0,  0x2080, 
IBUS_KEY_underscore, IBUS_KEY_1,  0x2081, 
IBUS_KEY_underscore, IBUS_KEY_2,  0x2082, 
IBUS_KEY_underscore, IBUS_KEY_3,  0x2083, 
IBUS_KEY_underscore, IBUS_KEY_4,  0x2084, 
IBUS_KEY_underscore, IBUS_KEY_5,  0x2085, 
IBUS_KEY_underscore, IBUS_KEY_6,  0x2086, 
IBUS_KEY_underscore, IBUS_KEY_7,  0x2087, 
IBUS_KEY_underscore, IBUS_KEY_8,  0x2088, 
IBUS_KEY_underscore, IBUS_KEY_9,  0x2089, 
IBUS_KEY_underscore, IBUS_KEY_less,  0x2264, 
IBUS_KEY_underscore, IBUS_KEY_equal,  0x208C, 
IBUS_KEY_underscore, IBUS_KEY_greater,  0x2265, 
IBUS_KEY_underscore, IBUS_KEY_A,  0x0100, 
IBUS_KEY_underscore, IBUS_KEY_E,  0x0112, 
IBUS_KEY_underscore, IBUS_KEY_G,  0x1E20, 
IBUS_KEY_underscore, IBUS_KEY_I,  0x012A, 
IBUS_KEY_underscore, IBUS_KEY_O,  0x014C, 
IBUS_KEY_underscore, IBUS_KEY_U,  0x016A, 
IBUS_KEY_underscore, IBUS_KEY_Y,  0x0232, 
IBUS_KEY_underscore, IBUS_KEY_asciicircum,  0x00AF, 
IBUS_KEY_underscore, IBUS_KEY_underscore,  0x00AF, 
IBUS_KEY_underscore, IBUS_KEY_a,  0x0101, 
IBUS_KEY_underscore, IBUS_KEY_e,  0x0113, 
IBUS_KEY_underscore, IBUS_KEY_g,  0x1E21, 
IBUS_KEY_underscore, IBUS_KEY_i,  0x012B, 
IBUS_KEY_underscore, IBUS_KEY_o,  0x014D, 
IBUS_KEY_underscore, IBUS_KEY_u,  0x016B, 
IBUS_KEY_underscore, IBUS_KEY_y,  0x0233, 
IBUS_KEY_underscore, IBUS_KEY_Adiaeresis,  0x01DE, 
IBUS_KEY_underscore, IBUS_KEY_AE,  0x01E2, 
IBUS_KEY_underscore, IBUS_KEY_Otilde,  0x022C, 
IBUS_KEY_underscore, IBUS_KEY_Odiaeresis,  0x022A, 
IBUS_KEY_underscore, IBUS_KEY_Udiaeresis,  0x01D5, 
IBUS_KEY_underscore, IBUS_KEY_adiaeresis,  0x01DF, 
IBUS_KEY_underscore, IBUS_KEY_ae,  0x01E3, 
IBUS_KEY_underscore, IBUS_KEY_otilde,  0x022D, 
IBUS_KEY_underscore, IBUS_KEY_odiaeresis,  0x022B, 
IBUS_KEY_underscore, IBUS_KEY_udiaeresis,  0x01D6, 
IBUS_KEY_underscore, 0x01EA,  0x01EC, 
IBUS_KEY_underscore, 0x01EB,  0x01ED, 
IBUS_KEY_underscore, 0x0226,  0x01E0, 
IBUS_KEY_underscore, 0x0227,  0x01E1, 
IBUS_KEY_underscore, 0x022E,  0x0230, 
IBUS_KEY_underscore, 0x022F,  0x0231, 
IBUS_KEY_underscore, IBUS_KEY_Cyrillic_i,  0x04E3, 
IBUS_KEY_underscore, IBUS_KEY_Cyrillic_u,  0x04EF, 
IBUS_KEY_underscore, IBUS_KEY_Cyrillic_I,  0x04E2, 
IBUS_KEY_underscore, IBUS_KEY_Cyrillic_U,  0x04EE, 
IBUS_KEY_underscore, IBUS_KEY_Greek_ALPHA,  0x1FB9, 
IBUS_KEY_underscore, IBUS_KEY_Greek_IOTA,  0x1FD9, 
IBUS_KEY_underscore, IBUS_KEY_Greek_UPSILON,  0x1FE9, 
IBUS_KEY_underscore, IBUS_KEY_Greek_alpha,  0x1FB1, 
IBUS_KEY_underscore, IBUS_KEY_Greek_iota,  0x1FD1, 
IBUS_KEY_underscore, IBUS_KEY_Greek_upsilon,  0x1FE1, 
IBUS_KEY_underscore, 0x1E36,  0x1E38, 
IBUS_KEY_underscore, 0x1E37,  0x1E39, 
IBUS_KEY_underscore, 0x1E5A,  0x1E5C, 
IBUS_KEY_underscore, 0x1E5B,  0x1E5D, 
IBUS_KEY_underscore, 0x2206,  0x2359, 
IBUS_KEY_underscore, 0x220A,  0x2377, 
IBUS_KEY_underscore, 0x2212,  0x208B, 
IBUS_KEY_underscore, 0x2218,  0x235B, 
IBUS_KEY_underscore, 0x2260,  0x2262, 
IBUS_KEY_underscore, 0x2282,  0x2286, 
IBUS_KEY_underscore, 0x2283,  0x2287, 
IBUS_KEY_underscore, IBUS_KEY_downtack,  0x234A, 
IBUS_KEY_underscore, 0x22C4,  0x235A, 
IBUS_KEY_underscore, 0x2373,  0x2378, 
IBUS_KEY_underscore, 0x2375,  0x2379, 
IBUS_KEY_underscore, 0x237A,  0x2376, 
IBUS_KEY_underscore, IBUS_KEY_emopencircle,  0x235C, 
IBUS_KEY_underscore, IBUS_KEY_KP_Space,  0x2082, 
IBUS_KEY_underscore, IBUS_KEY_KP_Add,  0x208A, 
IBUS_KEY_underscore, IBUS_KEY_KP_0,  0x2080, 
IBUS_KEY_underscore, IBUS_KEY_KP_1,  0x2081, 
IBUS_KEY_underscore, IBUS_KEY_KP_2,  0x2082, 
IBUS_KEY_underscore, IBUS_KEY_KP_3,  0x2083, 
IBUS_KEY_underscore, IBUS_KEY_KP_4,  0x2084, 
IBUS_KEY_underscore, IBUS_KEY_KP_5,  0x2085, 
IBUS_KEY_underscore, IBUS_KEY_KP_6,  0x2086, 
IBUS_KEY_underscore, IBUS_KEY_KP_7,  0x2087, 
IBUS_KEY_underscore, IBUS_KEY_KP_8,  0x2088, 
IBUS_KEY_underscore, IBUS_KEY_KP_9,  0x2089, 
IBUS_KEY_underscore, IBUS_KEY_KP_Equal,  0x208C, 
IBUS_KEY_grave, IBUS_KEY_space,  0x0060, 
IBUS_KEY_grave, IBUS_KEY_A,  0x00C0, 
IBUS_KEY_grave, IBUS_KEY_E,  0x00C8, 
IBUS_KEY_grave, IBUS_KEY_I,  0x00CC, 
IBUS_KEY_grave, IBUS_KEY_N,  0x01F8, 
IBUS_KEY_grave, IBUS_KEY_O,  0x00D2, 
IBUS_KEY_grave, IBUS_KEY_U,  0x00D9, 
IBUS_KEY_grave, IBUS_KEY_W,  0x1E80, 
IBUS_KEY_grave, IBUS_KEY_Y,  0x1EF2, 
IBUS_KEY_grave, IBUS_KEY_a,  0x00E0, 
IBUS_KEY_grave, IBUS_KEY_e,  0x00E8, 
IBUS_KEY_grave, IBUS_KEY_i,  0x00EC, 
IBUS_KEY_grave, IBUS_KEY_n,  0x01F9, 
IBUS_KEY_grave, IBUS_KEY_o,  0x00F2, 
IBUS_KEY_grave, IBUS_KEY_u,  0x00F9, 
IBUS_KEY_grave, IBUS_KEY_w,  0x1E81, 
IBUS_KEY_grave, IBUS_KEY_y,  0x1EF3, 
IBUS_KEY_grave, IBUS_KEY_Acircumflex,  0x1EA6, 
IBUS_KEY_grave, IBUS_KEY_Ecircumflex,  0x1EC0, 
IBUS_KEY_grave, IBUS_KEY_Ocircumflex,  0x1ED2, 
IBUS_KEY_grave, IBUS_KEY_Udiaeresis,  0x01DB, 
IBUS_KEY_grave, IBUS_KEY_acircumflex,  0x1EA7, 
IBUS_KEY_grave, IBUS_KEY_ecircumflex,  0x1EC1, 
IBUS_KEY_grave, IBUS_KEY_ocircumflex,  0x1ED3, 
IBUS_KEY_grave, IBUS_KEY_udiaeresis,  0x01DC, 
IBUS_KEY_grave, IBUS_KEY_Abreve,  0x1EB0, 
IBUS_KEY_grave, IBUS_KEY_abreve,  0x1EB1, 
IBUS_KEY_grave, IBUS_KEY_Emacron,  0x1E14, 
IBUS_KEY_grave, IBUS_KEY_emacron,  0x1E15, 
IBUS_KEY_grave, IBUS_KEY_Omacron,  0x1E50, 
IBUS_KEY_grave, IBUS_KEY_omacron,  0x1E51, 
IBUS_KEY_grave, IBUS_KEY_Cyrillic_ie,  0x0450, 
IBUS_KEY_grave, IBUS_KEY_Cyrillic_i,  0x045D, 
IBUS_KEY_grave, IBUS_KEY_Cyrillic_IE,  0x0400, 
IBUS_KEY_grave, IBUS_KEY_Cyrillic_I,  0x040D, 
IBUS_KEY_grave, IBUS_KEY_Greek_iotadieresis,  0x1FD2, 
IBUS_KEY_grave, IBUS_KEY_Greek_upsilondieresis,  0x1FE2, 
IBUS_KEY_grave, IBUS_KEY_Greek_ALPHA,  0x1FBA, 
IBUS_KEY_grave, IBUS_KEY_Greek_EPSILON,  0x1FC8, 
IBUS_KEY_grave, IBUS_KEY_Greek_ETA,  0x1FCA, 
IBUS_KEY_grave, IBUS_KEY_Greek_IOTA,  0x1FDA, 
IBUS_KEY_grave, IBUS_KEY_Greek_OMICRON,  0x1FF8, 
IBUS_KEY_grave, IBUS_KEY_Greek_UPSILON,  0x1FEA, 
IBUS_KEY_grave, IBUS_KEY_Greek_OMEGA,  0x1FFA, 
IBUS_KEY_grave, IBUS_KEY_Greek_alpha,  0x1F70, 
IBUS_KEY_grave, IBUS_KEY_Greek_epsilon,  0x1F72, 
IBUS_KEY_grave, IBUS_KEY_Greek_eta,  0x1F74, 
IBUS_KEY_grave, IBUS_KEY_Greek_iota,  0x1F76, 
IBUS_KEY_grave, IBUS_KEY_Greek_omicron,  0x1F78, 
IBUS_KEY_grave, IBUS_KEY_Greek_upsilon,  0x1F7A, 
IBUS_KEY_grave, IBUS_KEY_Greek_omega,  0x1F7C, 
IBUS_KEY_grave, 0x1F00,  0x1F02, 
IBUS_KEY_grave, 0x1F01,  0x1F03, 
IBUS_KEY_grave, 0x1F08,  0x1F0A, 
IBUS_KEY_grave, 0x1F09,  0x1F0B, 
IBUS_KEY_grave, 0x1F10,  0x1F12, 
IBUS_KEY_grave, 0x1F11,  0x1F13, 
IBUS_KEY_grave, 0x1F18,  0x1F1A, 
IBUS_KEY_grave, 0x1F19,  0x1F1B, 
IBUS_KEY_grave, 0x1F20,  0x1F22, 
IBUS_KEY_grave, 0x1F21,  0x1F23, 
IBUS_KEY_grave, 0x1F28,  0x1F2A, 
IBUS_KEY_grave, 0x1F29,  0x1F2B, 
IBUS_KEY_grave, 0x1F30,  0x1F32, 
IBUS_KEY_grave, 0x1F31,  0x1F33, 
IBUS_KEY_grave, 0x1F38,  0x1F3A, 
IBUS_KEY_grave, 0x1F39,  0x1F3B, 
IBUS_KEY_grave, 0x1F40,  0x1F42, 
IBUS_KEY_grave, 0x1F41,  0x1F43, 
IBUS_KEY_grave, 0x1F48,  0x1F4A, 
IBUS_KEY_grave, 0x1F49,  0x1F4B, 
IBUS_KEY_grave, 0x1F50,  0x1F52, 
IBUS_KEY_grave, 0x1F51,  0x1F53, 
IBUS_KEY_grave, 0x1F59,  0x1F5B, 
IBUS_KEY_grave, 0x1F60,  0x1F62, 
IBUS_KEY_grave, 0x1F61,  0x1F63, 
IBUS_KEY_grave, 0x1F68,  0x1F6A, 
IBUS_KEY_grave, 0x1F69,  0x1F6B, 
IBUS_KEY_a, IBUS_KEY_quotedbl,  0x00E4, 
IBUS_KEY_a, IBUS_KEY_apostrophe,  0x00E1, 
IBUS_KEY_a, IBUS_KEY_parenleft,  0x0103, 
IBUS_KEY_a, IBUS_KEY_asterisk,  0x00E5, 
IBUS_KEY_a, IBUS_KEY_comma,  0x0105, 
IBUS_KEY_a, IBUS_KEY_minus,  0x0101, 
IBUS_KEY_a, IBUS_KEY_semicolon,  0x0105, 
IBUS_KEY_a, IBUS_KEY_greater,  0x00E2, 
IBUS_KEY_a, IBUS_KEY_asciicircum,  0x00E2, 
IBUS_KEY_a, IBUS_KEY_underscore,  0x0101, 
IBUS_KEY_a, IBUS_KEY_grave,  0x00E0, 
IBUS_KEY_a, IBUS_KEY_a,  0x00E5, 
IBUS_KEY_a, IBUS_KEY_e,  0x00E6, 
IBUS_KEY_a, IBUS_KEY_asciitilde,  0x00E3, 
IBUS_KEY_a, IBUS_KEY_diaeresis,  0x00E4, 
IBUS_KEY_a, IBUS_KEY_acute,  0x00E1, 
IBUS_KEY_b, IBUS_KEY_period,  0x1E03, 
IBUS_KEY_b, IBUS_KEY_A,  0x0102, 
IBUS_KEY_b, IBUS_KEY_E,  0x0114, 
IBUS_KEY_b, IBUS_KEY_G,  0x011E, 
IBUS_KEY_b, IBUS_KEY_I,  0x012C, 
IBUS_KEY_b, IBUS_KEY_O,  0x014E, 
IBUS_KEY_b, IBUS_KEY_U,  0x016C, 
IBUS_KEY_b, IBUS_KEY_a,  0x0103, 
IBUS_KEY_b, IBUS_KEY_e,  0x0115, 
IBUS_KEY_b, IBUS_KEY_g,  0x011F, 
IBUS_KEY_b, IBUS_KEY_i,  0x012D, 
IBUS_KEY_b, IBUS_KEY_o,  0x014F, 
IBUS_KEY_b, IBUS_KEY_u,  0x016D, 
IBUS_KEY_b, 0x0228,  0x1E1C, 
IBUS_KEY_b, 0x0229,  0x1E1D, 
IBUS_KEY_b, IBUS_KEY_Cyrillic_a,  0x04D1, 
IBUS_KEY_b, IBUS_KEY_Cyrillic_ie,  0x04D7, 
IBUS_KEY_b, IBUS_KEY_Cyrillic_i,  0x0439, 
IBUS_KEY_b, IBUS_KEY_Cyrillic_u,  0x045E, 
IBUS_KEY_b, IBUS_KEY_Cyrillic_zhe,  0x04C2, 
IBUS_KEY_b, IBUS_KEY_Cyrillic_A,  0x04D0, 
IBUS_KEY_b, IBUS_KEY_Cyrillic_IE,  0x04D6, 
IBUS_KEY_b, IBUS_KEY_Cyrillic_I,  0x0419, 
IBUS_KEY_b, IBUS_KEY_Cyrillic_U,  0x040E, 
IBUS_KEY_b, IBUS_KEY_Cyrillic_ZHE,  0x04C1, 
IBUS_KEY_b, IBUS_KEY_Greek_ALPHA,  0x1FB8, 
IBUS_KEY_b, IBUS_KEY_Greek_IOTA,  0x1FD8, 
IBUS_KEY_b, IBUS_KEY_Greek_UPSILON,  0x1FE8, 
IBUS_KEY_b, IBUS_KEY_Greek_alpha,  0x1FB0, 
IBUS_KEY_b, IBUS_KEY_Greek_iota,  0x1FD0, 
IBUS_KEY_b, IBUS_KEY_Greek_upsilon,  0x1FE0, 
IBUS_KEY_b, 0x1EA0,  0x1EB6, 
IBUS_KEY_b, 0x1EA1,  0x1EB7, 
IBUS_KEY_c, IBUS_KEY_apostrophe,  0x0107, 
IBUS_KEY_c, IBUS_KEY_comma,  0x00E7, 
IBUS_KEY_c, IBUS_KEY_period,  0x010B, 
IBUS_KEY_c, IBUS_KEY_slash,  0x00A2, 
IBUS_KEY_c, IBUS_KEY_0,  0x00A9, 
IBUS_KEY_c, IBUS_KEY_less,  0x010D, 
IBUS_KEY_c, IBUS_KEY_equal,  0x20AC, 
IBUS_KEY_c, IBUS_KEY_A,  0x01CD, 
IBUS_KEY_c, IBUS_KEY_C,  0x010C, 
IBUS_KEY_c, IBUS_KEY_D,  0x010E, 
IBUS_KEY_c, IBUS_KEY_E,  0x011A, 
IBUS_KEY_c, IBUS_KEY_G,  0x01E6, 
IBUS_KEY_c, IBUS_KEY_H,  0x021E, 
IBUS_KEY_c, IBUS_KEY_I,  0x01CF, 
IBUS_KEY_c, IBUS_KEY_K,  0x01E8, 
IBUS_KEY_c, IBUS_KEY_L,  0x013D, 
IBUS_KEY_c, IBUS_KEY_N,  0x0147, 
IBUS_KEY_c, IBUS_KEY_O,  0x01D1, 
IBUS_KEY_c, IBUS_KEY_R,  0x0158, 
IBUS_KEY_c, IBUS_KEY_S,  0x0160, 
IBUS_KEY_c, IBUS_KEY_T,  0x0164, 
IBUS_KEY_c, IBUS_KEY_U,  0x01D3, 
IBUS_KEY_c, IBUS_KEY_Z,  0x017D, 
IBUS_KEY_c, IBUS_KEY_a,  0x01CE, 
IBUS_KEY_c, IBUS_KEY_c,  0x010D, 
IBUS_KEY_c, IBUS_KEY_d,  0x010F, 
IBUS_KEY_c, IBUS_KEY_e,  0x011B, 
IBUS_KEY_c, IBUS_KEY_g,  0x01E7, 
IBUS_KEY_c, IBUS_KEY_h,  0x021F, 
IBUS_KEY_c, IBUS_KEY_i,  0x01D0, 
IBUS_KEY_c, IBUS_KEY_j,  0x01F0, 
IBUS_KEY_c, IBUS_KEY_k,  0x01E9, 
IBUS_KEY_c, IBUS_KEY_l,  0x013E, 
IBUS_KEY_c, IBUS_KEY_n,  0x0148, 
IBUS_KEY_c, IBUS_KEY_o,  0x01D2, 
IBUS_KEY_c, IBUS_KEY_r,  0x0159, 
IBUS_KEY_c, IBUS_KEY_s,  0x0161, 
IBUS_KEY_c, IBUS_KEY_t,  0x0165, 
IBUS_KEY_c, IBUS_KEY_u,  0x01D4, 
IBUS_KEY_c, IBUS_KEY_z,  0x017E, 
IBUS_KEY_c, IBUS_KEY_bar,  0x00A2, 
IBUS_KEY_c, IBUS_KEY_Udiaeresis,  0x01D9, 
IBUS_KEY_c, IBUS_KEY_udiaeresis,  0x01DA, 
IBUS_KEY_d, IBUS_KEY_comma,  0x1E11, 
IBUS_KEY_d, IBUS_KEY_minus,  0x0111, 
IBUS_KEY_d, IBUS_KEY_period,  0x1E0B, 
IBUS_KEY_d, IBUS_KEY_less,  0x010F, 
IBUS_KEY_d, IBUS_KEY_equal,  0x20AB, 
IBUS_KEY_d, IBUS_KEY_h,  0x00F0, 
IBUS_KEY_d, IBUS_KEY_i,  0x2300, 
IBUS_KEY_e, IBUS_KEY_quotedbl,  0x00EB, 
IBUS_KEY_e, IBUS_KEY_apostrophe,  0x00E9, 
IBUS_KEY_e, IBUS_KEY_comma,  0x0119, 
IBUS_KEY_e, IBUS_KEY_minus,  0x0113, 
IBUS_KEY_e, IBUS_KEY_period,  0x0117, 
IBUS_KEY_e, IBUS_KEY_semicolon,  0x0119, 
IBUS_KEY_e, IBUS_KEY_less,  0x011B, 
IBUS_KEY_e, IBUS_KEY_equal,  0x20AC, 
IBUS_KEY_e, IBUS_KEY_greater,  0x00EA, 
IBUS_KEY_e, IBUS_KEY_asciicircum,  0x00EA, 
IBUS_KEY_e, IBUS_KEY_underscore,  0x0113, 
IBUS_KEY_e, IBUS_KEY_grave,  0x00E8, 
IBUS_KEY_e, IBUS_KEY_e,  0x0259, 
IBUS_KEY_e, IBUS_KEY_diaeresis,  0x00EB, 
IBUS_KEY_e, IBUS_KEY_acute,  0x00E9, 
IBUS_KEY_f, IBUS_KEY_period,  0x1E1F, 
IBUS_KEY_f, IBUS_KEY_S,  0x017F, 
IBUS_KEY_f, IBUS_KEY_f,  0xFB00, 
IBUS_KEY_f, IBUS_KEY_i,  0xFB01, 
IBUS_KEY_f, IBUS_KEY_l,  0xFB02, 
IBUS_KEY_f, IBUS_KEY_s,  0x017F, 
IBUS_KEY_g, IBUS_KEY_parenleft,  0x011F, 
IBUS_KEY_g, IBUS_KEY_comma,  0x0123, 
IBUS_KEY_g, IBUS_KEY_period,  0x0121, 
IBUS_KEY_g, IBUS_KEY_U,  0x011F, 
IBUS_KEY_g, IBUS_KEY_breve,  0x011F, 
IBUS_KEY_h, IBUS_KEY_comma,  0x1E29, 
IBUS_KEY_i, IBUS_KEY_quotedbl,  0x00EF, 
IBUS_KEY_i, IBUS_KEY_apostrophe,  0x00ED, 
IBUS_KEY_i, IBUS_KEY_comma,  0x012F, 
IBUS_KEY_i, IBUS_KEY_minus,  0x012B, 
IBUS_KEY_i, IBUS_KEY_period,  0x0131, 
IBUS_KEY_i, IBUS_KEY_semicolon,  0x012F, 
IBUS_KEY_i, IBUS_KEY_greater,  0x00EE, 
IBUS_KEY_i, IBUS_KEY_asciicircum,  0x00EE, 
IBUS_KEY_i, IBUS_KEY_underscore,  0x012B, 
IBUS_KEY_i, IBUS_KEY_grave,  0x00EC, 
IBUS_KEY_i, IBUS_KEY_j,  0x0133, 
IBUS_KEY_i, IBUS_KEY_asciitilde,  0x0129, 
IBUS_KEY_i, IBUS_KEY_diaeresis,  0x00EF, 
IBUS_KEY_i, IBUS_KEY_acute,  0x00ED, 
IBUS_KEY_k, IBUS_KEY_comma,  0x0137, 
IBUS_KEY_k, IBUS_KEY_k,  0x0138, 
IBUS_KEY_l, IBUS_KEY_apostrophe,  0x013A, 
IBUS_KEY_l, IBUS_KEY_comma,  0x013C, 
IBUS_KEY_l, IBUS_KEY_minus,  0x00A3, 
IBUS_KEY_l, IBUS_KEY_slash,  0x0142, 
IBUS_KEY_l, IBUS_KEY_less,  0x013E, 
IBUS_KEY_l, IBUS_KEY_equal,  0x00A3, 
IBUS_KEY_l, IBUS_KEY_v,  0x007C, 
IBUS_KEY_m, IBUS_KEY_period,  0x1E41, 
IBUS_KEY_m, IBUS_KEY_slash,  0x20A5, 
IBUS_KEY_m, IBUS_KEY_u,  0x00B5, 
IBUS_KEY_n, IBUS_KEY_apostrophe,  0x0144, 
IBUS_KEY_n, IBUS_KEY_comma,  0x0146, 
IBUS_KEY_n, IBUS_KEY_minus,  0x00F1, 
IBUS_KEY_n, IBUS_KEY_less,  0x0148, 
IBUS_KEY_n, IBUS_KEY_g,  0x014B, 
IBUS_KEY_n, IBUS_KEY_asciitilde,  0x00F1, 
IBUS_KEY_o, IBUS_KEY_quotedbl,  0x00F6, 
IBUS_KEY_o, IBUS_KEY_apostrophe,  0x00F3, 
IBUS_KEY_o, IBUS_KEY_comma,  0x01EB, 
IBUS_KEY_o, IBUS_KEY_minus,  0x014D, 
IBUS_KEY_o, IBUS_KEY_slash,  0x00F8, 
IBUS_KEY_o, IBUS_KEY_semicolon,  0x01EB, 
IBUS_KEY_o, IBUS_KEY_greater,  0x00F4, 
IBUS_KEY_o, IBUS_KEY_A,  0x00C5, 
IBUS_KEY_o, IBUS_KEY_C,  0x00A9, 
IBUS_KEY_o, IBUS_KEY_R,  0x00AE, 
IBUS_KEY_o, IBUS_KEY_U,  0x016E, 
IBUS_KEY_o, IBUS_KEY_X,  0x00A4, 
IBUS_KEY_o, IBUS_KEY_asciicircum,  0x00F4, 
IBUS_KEY_o, IBUS_KEY_underscore,  0x014D, 
IBUS_KEY_o, IBUS_KEY_grave,  0x00F2, 
IBUS_KEY_o, IBUS_KEY_a,  0x00E5, 
IBUS_KEY_o, IBUS_KEY_c,  0x00A9, 
IBUS_KEY_o, IBUS_KEY_e,  0x0153, 
IBUS_KEY_o, IBUS_KEY_o,  0x00B0, 
IBUS_KEY_o, IBUS_KEY_r,  0x00AE, 
IBUS_KEY_o, IBUS_KEY_s,  0x00A7, 
IBUS_KEY_o, IBUS_KEY_u,  0x016F, 
IBUS_KEY_o, IBUS_KEY_w,  0x1E98, 
IBUS_KEY_o, IBUS_KEY_x,  0x00A4, 
IBUS_KEY_o, IBUS_KEY_y,  0x1E99, 
IBUS_KEY_o, IBUS_KEY_asciitilde,  0x00F5, 
IBUS_KEY_o, IBUS_KEY_diaeresis,  0x00F6, 
IBUS_KEY_o, IBUS_KEY_acute,  0x00F3, 
IBUS_KEY_p, IBUS_KEY_exclam,  0x00B6, 
IBUS_KEY_p, IBUS_KEY_period,  0x1E57, 
IBUS_KEY_r, IBUS_KEY_apostrophe,  0x0155, 
IBUS_KEY_r, IBUS_KEY_comma,  0x0157, 
IBUS_KEY_r, IBUS_KEY_less,  0x0159, 
IBUS_KEY_r, IBUS_KEY_equal,  0x20B9, 
IBUS_KEY_s, IBUS_KEY_exclam,  0x00A7, 
IBUS_KEY_s, IBUS_KEY_apostrophe,  0x015B, 
IBUS_KEY_s, IBUS_KEY_comma,  0x015F, 
IBUS_KEY_s, IBUS_KEY_period,  0x1E61, 
IBUS_KEY_s, IBUS_KEY_0,  0x00A7, 
IBUS_KEY_s, IBUS_KEY_1,  0x00B9, 
IBUS_KEY_s, IBUS_KEY_2,  0x00B2, 
IBUS_KEY_s, IBUS_KEY_3,  0x00B3, 
IBUS_KEY_s, IBUS_KEY_semicolon,  0x0219, 
IBUS_KEY_s, IBUS_KEY_less,  0x0161, 
IBUS_KEY_s, IBUS_KEY_M,  0x2120, 
IBUS_KEY_s, IBUS_KEY_m,  0x2120, 
IBUS_KEY_s, IBUS_KEY_o,  0x00A7, 
IBUS_KEY_s, IBUS_KEY_s,  0x00DF, 
IBUS_KEY_s, IBUS_KEY_cedilla,  0x015F, 
IBUS_KEY_t, IBUS_KEY_comma,  0x0163, 
IBUS_KEY_t, IBUS_KEY_minus,  0x0167, 
IBUS_KEY_t, IBUS_KEY_period,  0x1E6B, 
IBUS_KEY_t, IBUS_KEY_slash,  0x0167, 
IBUS_KEY_t, IBUS_KEY_semicolon,  0x021B, 
IBUS_KEY_t, IBUS_KEY_less,  0x0165, 
IBUS_KEY_t, IBUS_KEY_M,  0x2122, 
IBUS_KEY_t, IBUS_KEY_h,  0x00FE, 
IBUS_KEY_t, IBUS_KEY_m,  0x2122, 
IBUS_KEY_u, IBUS_KEY_quotedbl,  0x00FC, 
IBUS_KEY_u, IBUS_KEY_apostrophe,  0x00FA, 
IBUS_KEY_u, IBUS_KEY_asterisk,  0x016F, 
IBUS_KEY_u, IBUS_KEY_comma,  0x0173, 
IBUS_KEY_u, IBUS_KEY_minus,  0x016B, 
IBUS_KEY_u, IBUS_KEY_slash,  0x00B5, 
IBUS_KEY_u, IBUS_KEY_semicolon,  0x0173, 
IBUS_KEY_u, IBUS_KEY_greater,  0x00FB, 
IBUS_KEY_u, IBUS_KEY_A,  0x0102, 
IBUS_KEY_u, IBUS_KEY_U,  0x016C, 
IBUS_KEY_u, IBUS_KEY_asciicircum,  0x00FB, 
IBUS_KEY_u, IBUS_KEY_underscore,  0x016B, 
IBUS_KEY_u, IBUS_KEY_grave,  0x00F9, 
IBUS_KEY_u, IBUS_KEY_a,  0x0103, 
IBUS_KEY_u, IBUS_KEY_u,  0x016D, 
IBUS_KEY_u, IBUS_KEY_asciitilde,  0x0169, 
IBUS_KEY_u, IBUS_KEY_diaeresis,  0x00FC, 
IBUS_KEY_u, IBUS_KEY_acute,  0x00FA, 
IBUS_KEY_v, IBUS_KEY_slash,  0x221A, 
IBUS_KEY_v, IBUS_KEY_Z,  0x017D, 
IBUS_KEY_v, IBUS_KEY_l,  0x007C, 
IBUS_KEY_v, IBUS_KEY_z,  0x017E, 
IBUS_KEY_w, IBUS_KEY_asciicircum,  0x0175, 
IBUS_KEY_x, IBUS_KEY_0,  0x00A4, 
IBUS_KEY_x, IBUS_KEY_O,  0x00A4, 
IBUS_KEY_x, IBUS_KEY_o,  0x00A4, 
IBUS_KEY_x, IBUS_KEY_x,  0x00D7, 
IBUS_KEY_y, IBUS_KEY_quotedbl,  0x00FF, 
IBUS_KEY_y, IBUS_KEY_apostrophe,  0x00FD, 
IBUS_KEY_y, IBUS_KEY_minus,  0x00A5, 
IBUS_KEY_y, IBUS_KEY_equal,  0x00A5, 
IBUS_KEY_y, IBUS_KEY_asciicircum,  0x0177, 
IBUS_KEY_y, IBUS_KEY_diaeresis,  0x00FF, 
IBUS_KEY_y, IBUS_KEY_acute,  0x00FD, 
IBUS_KEY_z, IBUS_KEY_apostrophe,  0x017A, 
IBUS_KEY_z, IBUS_KEY_period,  0x017C, 
IBUS_KEY_z, IBUS_KEY_less,  0x017E, 
IBUS_KEY_braceleft, IBUS_KEY_braceright,  0x2205, 
IBUS_KEY_bar, IBUS_KEY_C,  0x00A2, 
IBUS_KEY_bar, IBUS_KEY_c,  0x00A2, 
IBUS_KEY_bar, IBUS_KEY_asciitilde,  0x236D, 
IBUS_KEY_bar, 0x2190,  0x2345, 
IBUS_KEY_bar, 0x2192,  0x2346, 
IBUS_KEY_bar, 0x2206,  0x234B, 
IBUS_KEY_bar, 0x2207,  0x2352, 
IBUS_KEY_bar, IBUS_KEY_union,  0x2366, 
IBUS_KEY_bar, 0x2282,  0x2367, 
IBUS_KEY_bar, IBUS_KEY_emopencircle,  0x233D, 
IBUS_KEY_asciitilde, IBUS_KEY_space,  0x007E, 
IBUS_KEY_asciitilde, IBUS_KEY_0,  0x236C, 
IBUS_KEY_asciitilde, IBUS_KEY_A,  0x00C3, 
IBUS_KEY_asciitilde, IBUS_KEY_E,  0x1EBC, 
IBUS_KEY_asciitilde, IBUS_KEY_I,  0x0128, 
IBUS_KEY_asciitilde, IBUS_KEY_N,  0x00D1, 
IBUS_KEY_asciitilde, IBUS_KEY_O,  0x00D5, 
IBUS_KEY_asciitilde, IBUS_KEY_U,  0x0168, 
IBUS_KEY_asciitilde, IBUS_KEY_V,  0x1E7C, 
IBUS_KEY_asciitilde, IBUS_KEY_Y,  0x1EF8, 
IBUS_KEY_asciitilde, IBUS_KEY_a,  0x00E3, 
IBUS_KEY_asciitilde, IBUS_KEY_e,  0x1EBD, 
IBUS_KEY_asciitilde, IBUS_KEY_i,  0x0129, 
IBUS_KEY_asciitilde, IBUS_KEY_n,  0x00F1, 
IBUS_KEY_asciitilde, IBUS_KEY_o,  0x00F5, 
IBUS_KEY_asciitilde, IBUS_KEY_u,  0x0169, 
IBUS_KEY_asciitilde, IBUS_KEY_v,  0x1E7D, 
IBUS_KEY_asciitilde, IBUS_KEY_y,  0x1EF9, 
IBUS_KEY_asciitilde, IBUS_KEY_bar,  0x236D, 
IBUS_KEY_asciitilde, IBUS_KEY_diaeresis,  0x2368, 
IBUS_KEY_asciitilde, IBUS_KEY_Acircumflex,  0x1EAA, 
IBUS_KEY_asciitilde, IBUS_KEY_Ecircumflex,  0x1EC4, 
IBUS_KEY_asciitilde, IBUS_KEY_Ocircumflex,  0x1ED6, 
IBUS_KEY_asciitilde, IBUS_KEY_acircumflex,  0x1EAB, 
IBUS_KEY_asciitilde, IBUS_KEY_ecircumflex,  0x1EC5, 
IBUS_KEY_asciitilde, IBUS_KEY_ocircumflex,  0x1ED7, 
IBUS_KEY_asciitilde, IBUS_KEY_Abreve,  0x1EB4, 
IBUS_KEY_asciitilde, IBUS_KEY_abreve,  0x1EB5, 
IBUS_KEY_asciitilde, IBUS_KEY_Greek_iotadieresis,  0x1FD7, 
IBUS_KEY_asciitilde, IBUS_KEY_Greek_upsilondieresis,  0x1FE7, 
IBUS_KEY_asciitilde, IBUS_KEY_Greek_alpha,  0x1FB6, 
IBUS_KEY_asciitilde, IBUS_KEY_Greek_eta,  0x1FC6, 
IBUS_KEY_asciitilde, IBUS_KEY_Greek_iota,  0x1FD6, 
IBUS_KEY_asciitilde, IBUS_KEY_Greek_upsilon,  0x1FE6, 
IBUS_KEY_asciitilde, IBUS_KEY_Greek_omega,  0x1FF6, 
IBUS_KEY_asciitilde, 0x1F00,  0x1F06, 
IBUS_KEY_asciitilde, 0x1F01,  0x1F07, 
IBUS_KEY_asciitilde, 0x1F08,  0x1F0E, 
IBUS_KEY_asciitilde, 0x1F09,  0x1F0F, 
IBUS_KEY_asciitilde, 0x1F20,  0x1F26, 
IBUS_KEY_asciitilde, 0x1F21,  0x1F27, 
IBUS_KEY_asciitilde, 0x1F28,  0x1F2E, 
IBUS_KEY_asciitilde, 0x1F29,  0x1F2F, 
IBUS_KEY_asciitilde, 0x1F30,  0x1F36, 
IBUS_KEY_asciitilde, 0x1F31,  0x1F37, 
IBUS_KEY_asciitilde, 0x1F38,  0x1F3E, 
IBUS_KEY_asciitilde, 0x1F39,  0x1F3F, 
IBUS_KEY_asciitilde, 0x1F50,  0x1F56, 
IBUS_KEY_asciitilde, 0x1F51,  0x1F57, 
IBUS_KEY_asciitilde, 0x1F59,  0x1F5F, 
IBUS_KEY_asciitilde, 0x1F60,  0x1F66, 
IBUS_KEY_asciitilde, 0x1F61,  0x1F67, 
IBUS_KEY_asciitilde, 0x1F68,  0x1F6E, 
IBUS_KEY_asciitilde, 0x1F69,  0x1F6F, 
IBUS_KEY_asciitilde, 0x2207,  0x236B, 
IBUS_KEY_asciitilde, 0x2227,  0x2372, 
IBUS_KEY_asciitilde, 0x2228,  0x2371, 
IBUS_KEY_diaeresis, IBUS_KEY_apostrophe,  0x0385, 
IBUS_KEY_diaeresis, IBUS_KEY_asterisk,  0x2363, 
IBUS_KEY_diaeresis, IBUS_KEY_greater,  0x2369, 
IBUS_KEY_diaeresis, IBUS_KEY_A,  0x00C4, 
IBUS_KEY_diaeresis, IBUS_KEY_E,  0x00CB, 
IBUS_KEY_diaeresis, IBUS_KEY_I,  0x00CF, 
IBUS_KEY_diaeresis, IBUS_KEY_O,  0x00D6, 
IBUS_KEY_diaeresis, IBUS_KEY_U,  0x00DC, 
IBUS_KEY_diaeresis, IBUS_KEY_Y,  0x0178, 
IBUS_KEY_diaeresis, IBUS_KEY_grave,  0x1FED, 
IBUS_KEY_diaeresis, IBUS_KEY_a,  0x00E4, 
IBUS_KEY_diaeresis, IBUS_KEY_e,  0x00EB, 
IBUS_KEY_diaeresis, IBUS_KEY_i,  0x00EF, 
IBUS_KEY_diaeresis, IBUS_KEY_o,  0x00F6, 
IBUS_KEY_diaeresis, IBUS_KEY_u,  0x00FC, 
IBUS_KEY_diaeresis, IBUS_KEY_y,  0x00FF, 
IBUS_KEY_diaeresis, IBUS_KEY_asciitilde,  0x1FC1, 
IBUS_KEY_diaeresis, IBUS_KEY_acute,  0x0385, 
IBUS_KEY_diaeresis, 0x2207,  0x2362, 
IBUS_KEY_diaeresis, 0x2218,  0x2364, 
IBUS_KEY_diaeresis, IBUS_KEY_uptack,  0x2361, 
IBUS_KEY_diaeresis, IBUS_KEY_emopencircle,  0x2365, 
IBUS_KEY_diaeresis, IBUS_KEY_dead_grave,  0x1FED, 
IBUS_KEY_diaeresis, IBUS_KEY_dead_acute,  0x0385, 
IBUS_KEY_diaeresis, IBUS_KEY_dead_tilde,  0x1FC1, 
IBUS_KEY_macron, IBUS_KEY_A,  0x0100, 
IBUS_KEY_macron, IBUS_KEY_E,  0x0112, 
IBUS_KEY_macron, IBUS_KEY_G,  0x1E20, 
IBUS_KEY_macron, IBUS_KEY_I,  0x012A, 
IBUS_KEY_macron, IBUS_KEY_O,  0x014C, 
IBUS_KEY_macron, IBUS_KEY_U,  0x016A, 
IBUS_KEY_macron, IBUS_KEY_Y,  0x0232, 
IBUS_KEY_macron, IBUS_KEY_a,  0x0101, 
IBUS_KEY_macron, IBUS_KEY_e,  0x0113, 
IBUS_KEY_macron, IBUS_KEY_g,  0x1E21, 
IBUS_KEY_macron, IBUS_KEY_i,  0x012B, 
IBUS_KEY_macron, IBUS_KEY_o,  0x014D, 
IBUS_KEY_macron, IBUS_KEY_u,  0x016B, 
IBUS_KEY_macron, IBUS_KEY_y,  0x0233, 
IBUS_KEY_macron, IBUS_KEY_Adiaeresis,  0x01DE, 
IBUS_KEY_macron, IBUS_KEY_AE,  0x01E2, 
IBUS_KEY_macron, IBUS_KEY_Otilde,  0x022C, 
IBUS_KEY_macron, IBUS_KEY_Odiaeresis,  0x022A, 
IBUS_KEY_macron, IBUS_KEY_Udiaeresis,  0x01D5, 
IBUS_KEY_macron, IBUS_KEY_adiaeresis,  0x01DF, 
IBUS_KEY_macron, IBUS_KEY_ae,  0x01E3, 
IBUS_KEY_macron, IBUS_KEY_otilde,  0x022D, 
IBUS_KEY_macron, IBUS_KEY_odiaeresis,  0x022B, 
IBUS_KEY_macron, IBUS_KEY_udiaeresis,  0x01D6, 
IBUS_KEY_macron, 0x01EA,  0x01EC, 
IBUS_KEY_macron, 0x01EB,  0x01ED, 
IBUS_KEY_macron, 0x0226,  0x01E0, 
IBUS_KEY_macron, 0x0227,  0x01E1, 
IBUS_KEY_macron, 0x022E,  0x0230, 
IBUS_KEY_macron, 0x022F,  0x0231, 
IBUS_KEY_macron, IBUS_KEY_Cyrillic_i,  0x04E3, 
IBUS_KEY_macron, IBUS_KEY_Cyrillic_u,  0x04EF, 
IBUS_KEY_macron, IBUS_KEY_Cyrillic_I,  0x04E2, 
IBUS_KEY_macron, IBUS_KEY_Cyrillic_U,  0x04EE, 
IBUS_KEY_macron, IBUS_KEY_Greek_ALPHA,  0x1FB9, 
IBUS_KEY_macron, IBUS_KEY_Greek_IOTA,  0x1FD9, 
IBUS_KEY_macron, IBUS_KEY_Greek_UPSILON,  0x1FE9, 
IBUS_KEY_macron, IBUS_KEY_Greek_alpha,  0x1FB1, 
IBUS_KEY_macron, IBUS_KEY_Greek_iota,  0x1FD1, 
IBUS_KEY_macron, IBUS_KEY_Greek_upsilon,  0x1FE1, 
IBUS_KEY_macron, 0x1E36,  0x1E38, 
IBUS_KEY_macron, 0x1E37,  0x1E39, 
IBUS_KEY_macron, 0x1E5A,  0x1E5C, 
IBUS_KEY_macron, 0x1E5B,  0x1E5D, 
IBUS_KEY_macron, IBUS_KEY_uptack,  0x2351, 
IBUS_KEY_acute, IBUS_KEY_A,  0x00C1, 
IBUS_KEY_acute, IBUS_KEY_C,  0x0106, 
IBUS_KEY_acute, IBUS_KEY_E,  0x00C9, 
IBUS_KEY_acute, IBUS_KEY_G,  0x01F4, 
IBUS_KEY_acute, IBUS_KEY_I,  0x00CD, 
IBUS_KEY_acute, IBUS_KEY_K,  0x1E30, 
IBUS_KEY_acute, IBUS_KEY_L,  0x0139, 
IBUS_KEY_acute, IBUS_KEY_M,  0x1E3E, 
IBUS_KEY_acute, IBUS_KEY_N,  0x0143, 
IBUS_KEY_acute, IBUS_KEY_O,  0x00D3, 
IBUS_KEY_acute, IBUS_KEY_P,  0x1E54, 
IBUS_KEY_acute, IBUS_KEY_R,  0x0154, 
IBUS_KEY_acute, IBUS_KEY_S,  0x015A, 
IBUS_KEY_acute, IBUS_KEY_U,  0x00DA, 
IBUS_KEY_acute, IBUS_KEY_W,  0x1E82, 
IBUS_KEY_acute, IBUS_KEY_Y,  0x00DD, 
IBUS_KEY_acute, IBUS_KEY_Z,  0x0179, 
IBUS_KEY_acute, IBUS_KEY_a,  0x00E1, 
IBUS_KEY_acute, IBUS_KEY_c,  0x0107, 
IBUS_KEY_acute, IBUS_KEY_e,  0x00E9, 
IBUS_KEY_acute, IBUS_KEY_g,  0x01F5, 
IBUS_KEY_acute, IBUS_KEY_i,  0x00ED, 
IBUS_KEY_acute, IBUS_KEY_k,  0x1E31, 
IBUS_KEY_acute, IBUS_KEY_l,  0x013A, 
IBUS_KEY_acute, IBUS_KEY_m,  0x1E3F, 
IBUS_KEY_acute, IBUS_KEY_n,  0x0144, 
IBUS_KEY_acute, IBUS_KEY_o,  0x00F3, 
IBUS_KEY_acute, IBUS_KEY_p,  0x1E55, 
IBUS_KEY_acute, IBUS_KEY_r,  0x0155, 
IBUS_KEY_acute, IBUS_KEY_s,  0x015B, 
IBUS_KEY_acute, IBUS_KEY_u,  0x00FA, 
IBUS_KEY_acute, IBUS_KEY_w,  0x1E83, 
IBUS_KEY_acute, IBUS_KEY_y,  0x00FD, 
IBUS_KEY_acute, IBUS_KEY_z,  0x017A, 
IBUS_KEY_acute, IBUS_KEY_Acircumflex,  0x1EA4, 
IBUS_KEY_acute, IBUS_KEY_Aring,  0x01FA, 
IBUS_KEY_acute, IBUS_KEY_AE,  0x01FC, 
IBUS_KEY_acute, IBUS_KEY_Ccedilla,  0x1E08, 
IBUS_KEY_acute, IBUS_KEY_Ecircumflex,  0x1EBE, 
IBUS_KEY_acute, IBUS_KEY_Idiaeresis,  0x1E2E, 
IBUS_KEY_acute, IBUS_KEY_Ocircumflex,  0x1ED0, 
IBUS_KEY_acute, IBUS_KEY_Otilde,  0x1E4C, 
IBUS_KEY_acute, IBUS_KEY_Ooblique,  0x01FE, 
IBUS_KEY_acute, IBUS_KEY_Udiaeresis,  0x01D7, 
IBUS_KEY_acute, IBUS_KEY_acircumflex,  0x1EA5, 
IBUS_KEY_acute, IBUS_KEY_aring,  0x01FB, 
IBUS_KEY_acute, IBUS_KEY_ae,  0x01FD, 
IBUS_KEY_acute, IBUS_KEY_ccedilla,  0x1E09, 
IBUS_KEY_acute, IBUS_KEY_ecircumflex,  0x1EBF, 
IBUS_KEY_acute, IBUS_KEY_idiaeresis,  0x1E2F, 
IBUS_KEY_acute, IBUS_KEY_ocircumflex,  0x1ED1, 
IBUS_KEY_acute, IBUS_KEY_otilde,  0x1E4D, 
IBUS_KEY_acute, IBUS_KEY_oslash,  0x01FF, 
IBUS_KEY_acute, IBUS_KEY_udiaeresis,  0x01D8, 
IBUS_KEY_acute, IBUS_KEY_Abreve,  0x1EAE, 
IBUS_KEY_acute, IBUS_KEY_abreve,  0x1EAF, 
IBUS_KEY_acute, IBUS_KEY_Emacron,  0x1E16, 
IBUS_KEY_acute, IBUS_KEY_emacron,  0x1E17, 
IBUS_KEY_acute, IBUS_KEY_Omacron,  0x1E52, 
IBUS_KEY_acute, IBUS_KEY_Utilde,  0x1E78, 
IBUS_KEY_acute, IBUS_KEY_omacron,  0x1E53, 
IBUS_KEY_acute, IBUS_KEY_utilde,  0x1E79, 
IBUS_KEY_acute, IBUS_KEY_Cyrillic_ghe,  0x0453, 
IBUS_KEY_acute, IBUS_KEY_Cyrillic_ka,  0x045C, 
IBUS_KEY_acute, IBUS_KEY_Cyrillic_GHE,  0x0403, 
IBUS_KEY_acute, IBUS_KEY_Cyrillic_KA,  0x040C, 
IBUS_KEY_acute, IBUS_KEY_Greek_iotadieresis,  0x0390, 
IBUS_KEY_acute, IBUS_KEY_Greek_upsilondieresis,  0x03B0, 
IBUS_KEY_acute, IBUS_KEY_Greek_ALPHA,  0x0386, 
IBUS_KEY_acute, IBUS_KEY_Greek_EPSILON,  0x0388, 
IBUS_KEY_acute, IBUS_KEY_Greek_ETA,  0x0389, 
IBUS_KEY_acute, IBUS_KEY_Greek_IOTA,  0x038A, 
IBUS_KEY_acute, IBUS_KEY_Greek_OMICRON,  0x038C, 
IBUS_KEY_acute, IBUS_KEY_Greek_UPSILON,  0x038E, 
IBUS_KEY_acute, IBUS_KEY_Greek_OMEGA,  0x038F, 
IBUS_KEY_acute, IBUS_KEY_Greek_alpha,  0x03AC, 
IBUS_KEY_acute, IBUS_KEY_Greek_epsilon,  0x03AD, 
IBUS_KEY_acute, IBUS_KEY_Greek_eta,  0x03AE, 
IBUS_KEY_acute, IBUS_KEY_Greek_iota,  0x03AF, 
IBUS_KEY_acute, IBUS_KEY_Greek_omicron,  0x03CC, 
IBUS_KEY_acute, IBUS_KEY_Greek_upsilon,  0x03CD, 
IBUS_KEY_acute, IBUS_KEY_Greek_omega,  0x03CE, 
IBUS_KEY_acute, 0x1F00,  0x1F04, 
IBUS_KEY_acute, 0x1F01,  0x1F05, 
IBUS_KEY_acute, 0x1F08,  0x1F0C, 
IBUS_KEY_acute, 0x1F09,  0x1F0D, 
IBUS_KEY_acute, 0x1F10,  0x1F14, 
IBUS_KEY_acute, 0x1F11,  0x1F15, 
IBUS_KEY_acute, 0x1F18,  0x1F1C, 
IBUS_KEY_acute, 0x1F19,  0x1F1D, 
IBUS_KEY_acute, 0x1F20,  0x1F24, 
IBUS_KEY_acute, 0x1F21,  0x1F25, 
IBUS_KEY_acute, 0x1F28,  0x1F2C, 
IBUS_KEY_acute, 0x1F29,  0x1F2D, 
IBUS_KEY_acute, 0x1F30,  0x1F34, 
IBUS_KEY_acute, 0x1F31,  0x1F35, 
IBUS_KEY_acute, 0x1F38,  0x1F3C, 
IBUS_KEY_acute, 0x1F39,  0x1F3D, 
IBUS_KEY_acute, 0x1F40,  0x1F44, 
IBUS_KEY_acute, 0x1F41,  0x1F45, 
IBUS_KEY_acute, 0x1F48,  0x1F4C, 
IBUS_KEY_acute, 0x1F49,  0x1F4D, 
IBUS_KEY_acute, 0x1F50,  0x1F54, 
IBUS_KEY_acute, 0x1F51,  0x1F55, 
IBUS_KEY_acute, 0x1F59,  0x1F5D, 
IBUS_KEY_acute, 0x1F60,  0x1F64, 
IBUS_KEY_acute, 0x1F61,  0x1F65, 
IBUS_KEY_acute, 0x1F68,  0x1F6C, 
IBUS_KEY_acute, 0x1F69,  0x1F6D, 
IBUS_KEY_cedilla, IBUS_KEY_C,  0x00C7, 
IBUS_KEY_cedilla, IBUS_KEY_D,  0x1E10, 
IBUS_KEY_cedilla, IBUS_KEY_E,  0x0228, 
IBUS_KEY_cedilla, IBUS_KEY_G,  0x0122, 
IBUS_KEY_cedilla, IBUS_KEY_H,  0x1E28, 
IBUS_KEY_cedilla, IBUS_KEY_K,  0x0136, 
IBUS_KEY_cedilla, IBUS_KEY_L,  0x013B, 
IBUS_KEY_cedilla, IBUS_KEY_N,  0x0145, 
IBUS_KEY_cedilla, IBUS_KEY_R,  0x0156, 
IBUS_KEY_cedilla, IBUS_KEY_S,  0x015E, 
IBUS_KEY_cedilla, IBUS_KEY_T,  0x0162, 
IBUS_KEY_cedilla, IBUS_KEY_c,  0x00E7, 
IBUS_KEY_cedilla, IBUS_KEY_d,  0x1E11, 
IBUS_KEY_cedilla, IBUS_KEY_e,  0x0229, 
IBUS_KEY_cedilla, IBUS_KEY_g,  0x0123, 
IBUS_KEY_cedilla, IBUS_KEY_h,  0x1E29, 
IBUS_KEY_cedilla, IBUS_KEY_k,  0x0137, 
IBUS_KEY_cedilla, IBUS_KEY_l,  0x013C, 
IBUS_KEY_cedilla, IBUS_KEY_n,  0x0146, 
IBUS_KEY_cedilla, IBUS_KEY_r,  0x0157, 
IBUS_KEY_cedilla, IBUS_KEY_s,  0x015F, 
IBUS_KEY_cedilla, IBUS_KEY_t,  0x0163, 
IBUS_KEY_division, 0x2395,  0x2339, 
IBUS_KEY_breve, IBUS_KEY_G,  0x011E, 
IBUS_KEY_breve, IBUS_KEY_g,  0x011F, 
0x05B4, IBUS_KEY_hebrew_yod,  0xFB1D, 
0x05B7, 0x05F2,  0xFB1F, 
0x05B7, IBUS_KEY_hebrew_aleph,  0xFB2E, 
0x05B8, IBUS_KEY_hebrew_aleph,  0xFB2F, 
0x05B9, IBUS_KEY_hebrew_waw,  0xFB4B, 
0x05BC, IBUS_KEY_hebrew_aleph,  0xFB30, 
0x05BC, IBUS_KEY_hebrew_bet,  0xFB31, 
0x05BC, IBUS_KEY_hebrew_gimel,  0xFB32, 
0x05BC, IBUS_KEY_hebrew_dalet,  0xFB33, 
0x05BC, IBUS_KEY_hebrew_he,  0xFB34, 
0x05BC, IBUS_KEY_hebrew_waw,  0xFB35, 
0x05BC, IBUS_KEY_hebrew_zain,  0xFB36, 
0x05BC, IBUS_KEY_hebrew_tet,  0xFB38, 
0x05BC, IBUS_KEY_hebrew_yod,  0xFB39, 
0x05BC, IBUS_KEY_hebrew_finalkaph,  0xFB3A, 
0x05BC, IBUS_KEY_hebrew_kaph,  0xFB3B, 
0x05BC, IBUS_KEY_hebrew_lamed,  0xFB3C, 
0x05BC, IBUS_KEY_hebrew_mem,  0xFB3E, 
0x05BC, IBUS_KEY_hebrew_nun,  0xFB40, 
0x05BC, IBUS_KEY_hebrew_samech,  0xFB41, 
0x05BC, IBUS_KEY_hebrew_finalpe,  0xFB43, 
0x05BC, IBUS_KEY_hebrew_pe,  0xFB44, 
0x05BC, IBUS_KEY_hebrew_zade,  0xFB46, 
0x05BC, IBUS_KEY_hebrew_kuf,  0xFB47, 
0x05BC, IBUS_KEY_hebrew_resh,  0xFB48, 
0x05BC, IBUS_KEY_hebrew_shin,  0xFB49, 
0x05BC, IBUS_KEY_hebrew_taf,  0xFB4A, 
0x05BF, IBUS_KEY_hebrew_bet,  0xFB4C, 
0x05BF, IBUS_KEY_hebrew_kaph,  0xFB4D, 
0x05BF, IBUS_KEY_hebrew_pe,  0xFB4E, 
0x05C1, IBUS_KEY_hebrew_shin,  0xFB2A, 
0x05C1, 0xFB49,  0xFB2C, 
0x05C2, IBUS_KEY_hebrew_shin,  0xFB2B, 
0x05C2, 0xFB49,  0xFB2D, 
0x0653, IBUS_KEY_Arabic_alef,  0x0622, 
0x0654, IBUS_KEY_Arabic_alef,  0x0623, 
0x0654, IBUS_KEY_Arabic_waw,  0x0624, 
0x0654, IBUS_KEY_Arabic_yeh,  0x0626, 
0x0654, 0x06C1,  0x06C2, 
0x0654, 0x06D2,  0x06D3, 
0x0654, 0x06D5,  0x06C0, 
0x0655, IBUS_KEY_Arabic_alef,  0x0625, 
IBUS_KEY_Cyrillic_pe, IBUS_KEY_Cyrillic_a,  0x00A7, 
IBUS_KEY_Cyrillic_IE, IBUS_KEY_equal,  0x20AC, 
IBUS_KEY_Cyrillic_EN, IBUS_KEY_Cyrillic_o,  0x2116, 
IBUS_KEY_Cyrillic_EN, IBUS_KEY_Cyrillic_O,  0x2116, 
IBUS_KEY_Cyrillic_ES, IBUS_KEY_equal,  0x20AC, 
IBUS_KEY_Greek_ALPHA, IBUS_KEY_apostrophe,  0x0386, 
IBUS_KEY_Greek_EPSILON, IBUS_KEY_apostrophe,  0x0388, 
IBUS_KEY_Greek_ETA, IBUS_KEY_apostrophe,  0x0389, 
IBUS_KEY_Greek_IOTA, IBUS_KEY_quotedbl,  0x03AA, 
IBUS_KEY_Greek_IOTA, IBUS_KEY_apostrophe,  0x038A, 
IBUS_KEY_Greek_OMICRON, IBUS_KEY_apostrophe,  0x038C, 
IBUS_KEY_Greek_UPSILON, IBUS_KEY_quotedbl,  0x03AB, 
IBUS_KEY_Greek_UPSILON, IBUS_KEY_apostrophe,  0x038E, 
IBUS_KEY_Greek_OMEGA, IBUS_KEY_apostrophe,  0x038F, 
IBUS_KEY_Greek_alpha, IBUS_KEY_apostrophe,  0x03AC, 
IBUS_KEY_Greek_epsilon, IBUS_KEY_apostrophe,  0x03AD, 
IBUS_KEY_Greek_eta, IBUS_KEY_apostrophe,  0x03AE, 
IBUS_KEY_Greek_iota, IBUS_KEY_quotedbl,  0x03CA, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe,  0x03AF, 
IBUS_KEY_Greek_iota, IBUS_KEY_Greek_alphaaccent,  0x1FB4, 
IBUS_KEY_Greek_iota, IBUS_KEY_Greek_etaaccent,  0x1FC4, 
IBUS_KEY_Greek_iota, IBUS_KEY_Greek_omegaaccent,  0x1FF4, 
IBUS_KEY_Greek_iota, IBUS_KEY_Greek_ALPHA,  0x1FBC, 
IBUS_KEY_Greek_iota, IBUS_KEY_Greek_ETA,  0x1FCC, 
IBUS_KEY_Greek_iota, IBUS_KEY_Greek_OMEGA,  0x1FFC, 
IBUS_KEY_Greek_iota, IBUS_KEY_Greek_alpha,  0x1FB3, 
IBUS_KEY_Greek_iota, IBUS_KEY_Greek_eta,  0x1FC3, 
IBUS_KEY_Greek_iota, IBUS_KEY_Greek_omega,  0x1FF3, 
IBUS_KEY_Greek_iota, 0x1F00,  0x1F80, 
IBUS_KEY_Greek_iota, 0x1F01,  0x1F81, 
IBUS_KEY_Greek_iota, 0x1F02,  0x1F82, 
IBUS_KEY_Greek_iota, 0x1F03,  0x1F83, 
IBUS_KEY_Greek_iota, 0x1F04,  0x1F84, 
IBUS_KEY_Greek_iota, 0x1F05,  0x1F85, 
IBUS_KEY_Greek_iota, 0x1F06,  0x1F86, 
IBUS_KEY_Greek_iota, 0x1F07,  0x1F87, 
IBUS_KEY_Greek_iota, 0x1F08,  0x1F88, 
IBUS_KEY_Greek_iota, 0x1F09,  0x1F89, 
IBUS_KEY_Greek_iota, 0x1F0A,  0x1F8A, 
IBUS_KEY_Greek_iota, 0x1F0B,  0x1F8B, 
IBUS_KEY_Greek_iota, 0x1F0C,  0x1F8C, 
IBUS_KEY_Greek_iota, 0x1F0D,  0x1F8D, 
IBUS_KEY_Greek_iota, 0x1F0E,  0x1F8E, 
IBUS_KEY_Greek_iota, 0x1F0F,  0x1F8F, 
IBUS_KEY_Greek_iota, 0x1F20,  0x1F90, 
IBUS_KEY_Greek_iota, 0x1F21,  0x1F91, 
IBUS_KEY_Greek_iota, 0x1F22,  0x1F92, 
IBUS_KEY_Greek_iota, 0x1F23,  0x1F93, 
IBUS_KEY_Greek_iota, 0x1F24,  0x1F94, 
IBUS_KEY_Greek_iota, 0x1F25,  0x1F95, 
IBUS_KEY_Greek_iota, 0x1F26,  0x1F96, 
IBUS_KEY_Greek_iota, 0x1F27,  0x1F97, 
IBUS_KEY_Greek_iota, 0x1F28,  0x1F98, 
IBUS_KEY_Greek_iota, 0x1F29,  0x1F99, 
IBUS_KEY_Greek_iota, 0x1F2A,  0x1F9A, 
IBUS_KEY_Greek_iota, 0x1F2B,  0x1F9B, 
IBUS_KEY_Greek_iota, 0x1F2C,  0x1F9C, 
IBUS_KEY_Greek_iota, 0x1F2D,  0x1F9D, 
IBUS_KEY_Greek_iota, 0x1F2E,  0x1F9E, 
IBUS_KEY_Greek_iota, 0x1F2F,  0x1F9F, 
IBUS_KEY_Greek_iota, 0x1F60,  0x1FA0, 
IBUS_KEY_Greek_iota, 0x1F61,  0x1FA1, 
IBUS_KEY_Greek_iota, 0x1F62,  0x1FA2, 
IBUS_KEY_Greek_iota, 0x1F63,  0x1FA3, 
IBUS_KEY_Greek_iota, 0x1F64,  0x1FA4, 
IBUS_KEY_Greek_iota, 0x1F65,  0x1FA5, 
IBUS_KEY_Greek_iota, 0x1F66,  0x1FA6, 
IBUS_KEY_Greek_iota, 0x1F67,  0x1FA7, 
IBUS_KEY_Greek_iota, 0x1F68,  0x1FA8, 
IBUS_KEY_Greek_iota, 0x1F69,  0x1FA9, 
IBUS_KEY_Greek_iota, 0x1F6A,  0x1FAA, 
IBUS_KEY_Greek_iota, 0x1F6B,  0x1FAB, 
IBUS_KEY_Greek_iota, 0x1F6C,  0x1FAC, 
IBUS_KEY_Greek_iota, 0x1F6D,  0x1FAD, 
IBUS_KEY_Greek_iota, 0x1F6E,  0x1FAE, 
IBUS_KEY_Greek_iota, 0x1F6F,  0x1FAF, 
IBUS_KEY_Greek_iota, 0x1F70,  0x1FB2, 
IBUS_KEY_Greek_iota, 0x1F74,  0x1FC2, 
IBUS_KEY_Greek_iota, 0x1F7C,  0x1FF2, 
IBUS_KEY_Greek_iota, 0x1FB6,  0x1FB7, 
IBUS_KEY_Greek_iota, 0x1FC6,  0x1FC7, 
IBUS_KEY_Greek_iota, 0x1FF6,  0x1FF7, 
IBUS_KEY_Greek_omicron, IBUS_KEY_apostrophe,  0x03CC, 
IBUS_KEY_Greek_upsilon, IBUS_KEY_quotedbl,  0x03CB, 
IBUS_KEY_Greek_upsilon, IBUS_KEY_apostrophe,  0x03CD, 
IBUS_KEY_Greek_omega, IBUS_KEY_apostrophe,  0x03CE, 
IBUS_KEY_lessthanequal, 0x0338,  0x2270, 
IBUS_KEY_greaterthanequal, 0x0338,  0x2271, 
IBUS_KEY_approximate, 0x0338,  0x2247, 
IBUS_KEY_identical, 0x0338,  0x2262, 
IBUS_KEY_includedin, 0x0338,  0x2284, 
IBUS_KEY_includes, 0x0338,  0x2285, 
0x093C, 0x0915,  0x0958, 
0x093C, 0x0916,  0x0959, 
0x093C, 0x0917,  0x095A, 
0x093C, 0x091C,  0x095B, 
0x093C, 0x0921,  0x095C, 
0x093C, 0x0922,  0x095D, 
0x093C, 0x0928,  0x0929, 
0x093C, 0x092B,  0x095E, 
0x093C, 0x092F,  0x095F, 
0x093C, 0x0930,  0x0931, 
0x093C, 0x0933,  0x0934, 
0x09BC, 0x09A1,  0x09DC, 
0x09BC, 0x09A2,  0x09DD, 
0x09BC, 0x09AF,  0x09DF, 
0x09C7, 0x09BE,  0x09CB, 
0x09C7, 0x09D7,  0x09CC, 
0x0A3C, 0x0A16,  0x0A59, 
0x0A3C, 0x0A17,  0x0A5A, 
0x0A3C, 0x0A1C,  0x0A5B, 
0x0A3C, 0x0A2B,  0x0A5E, 
0x0A3C, 0x0A32,  0x0A33, 
0x0A3C, 0x0A38,  0x0A36, 
0x0B3C, 0x0B21,  0x0B5C, 
0x0B3C, 0x0B22,  0x0B5D, 
0x0B47, 0x0B3E,  0x0B4B, 
0x0B47, 0x0B56,  0x0B48, 
0x0B47, 0x0B57,  0x0B4C, 
IBUS_KEY_leftcaret, 0x0338,  0x226E, 
IBUS_KEY_rightcaret, 0x0338,  0x226F, 
IBUS_KEY_underbar, IBUS_KEY_parenleft,  0x208D, 
IBUS_KEY_underbar, IBUS_KEY_parenright,  0x208E, 
IBUS_KEY_underbar, IBUS_KEY_plus,  0x208A, 
IBUS_KEY_underbar, IBUS_KEY_0,  0x2080, 
IBUS_KEY_underbar, IBUS_KEY_1,  0x2081, 
IBUS_KEY_underbar, IBUS_KEY_2,  0x2082, 
IBUS_KEY_underbar, IBUS_KEY_3,  0x2083, 
IBUS_KEY_underbar, IBUS_KEY_4,  0x2084, 
IBUS_KEY_underbar, IBUS_KEY_5,  0x2085, 
IBUS_KEY_underbar, IBUS_KEY_6,  0x2086, 
IBUS_KEY_underbar, IBUS_KEY_7,  0x2087, 
IBUS_KEY_underbar, IBUS_KEY_8,  0x2088, 
IBUS_KEY_underbar, IBUS_KEY_9,  0x2089, 
IBUS_KEY_underbar, IBUS_KEY_equal,  0x208C, 
0x0BC6, 0x0BBE,  0x0BCA, 
0x0BC6, 0x0BD7,  0x0BCC, 
IBUS_KEY_underbar, 0x2212,  0x208B, 
IBUS_KEY_underbar, IBUS_KEY_KP_Space,  0x2082, 
IBUS_KEY_underbar, IBUS_KEY_KP_Add,  0x208A, 
IBUS_KEY_underbar, IBUS_KEY_KP_0,  0x2080, 
IBUS_KEY_underbar, IBUS_KEY_KP_1,  0x2081, 
IBUS_KEY_underbar, IBUS_KEY_KP_2,  0x2082, 
IBUS_KEY_underbar, IBUS_KEY_KP_3,  0x2083, 
IBUS_KEY_underbar, IBUS_KEY_KP_4,  0x2084, 
IBUS_KEY_underbar, IBUS_KEY_KP_5,  0x2085, 
IBUS_KEY_underbar, IBUS_KEY_KP_6,  0x2086, 
IBUS_KEY_underbar, IBUS_KEY_KP_7,  0x2087, 
IBUS_KEY_underbar, IBUS_KEY_KP_8,  0x2088, 
IBUS_KEY_underbar, IBUS_KEY_KP_9,  0x2089, 
IBUS_KEY_underbar, IBUS_KEY_KP_Equal,  0x208C, 
0x0BC7, 0x0BBE,  0x0BCB, 
0x0BD7, 0x0B92,  0x0B94, 
IBUS_KEY_rightshoe, 0x0338,  0x2285, 
IBUS_KEY_leftshoe, 0x0338,  0x2284, 
IBUS_KEY_righttack, 0x0338,  0x22AC, 
0x0C46, 0x0C56,  0x0C48, 
0x0CBF, 0x0CD5,  0x0CC0, 
0x0CC6, 0x0CC2,  0x0CCA, 
0x0CC6, 0x0CD5,  0x0CC7, 
0x0CC6, 0x0CD6,  0x0CC8, 
0x0CCA, 0x0CD5,  0x0CCB, 
0x0D46, 0x0D3E,  0x0D4A, 
0x0D46, 0x0D57,  0x0D4C, 
0x0D47, 0x0D3E,  0x0D4B, 
0x0DD9, 0x0DCA,  0x0DDA, 
0x0DD9, 0x0DCF,  0x0DDC, 
0x0DD9, 0x0DDF,  0x0DDE, 
0x0DDC, 0x0DCA,  0x0DDD, 
0x0F71, 0x0F72,  0x0F73, 
0x0F71, 0x0F74,  0x0F75, 
0x0F71, 0x0F80,  0x0F81, 
0x0F90, 0x0FB5,  0x0FB9, 
0x0F92, 0x0FB7,  0x0F93, 
0x0F9C, 0x0FB7,  0x0F9D, 
0x0FA1, 0x0FB7,  0x0FA2, 
0x0FA6, 0x0FB7,  0x0FA7, 
0x0FAB, 0x0FB7,  0x0FAC, 
0x0FB2, 0x0F80,  0x0F76, 
0x0FB3, 0x0F80,  0x0F78, 
0x0FB5, 0x0F40,  0x0F69, 
0x0FB7, 0x0F42,  0x0F43, 
0x0FB7, 0x0F4C,  0x0F4D, 
0x0FB7, 0x0F51,  0x0F52, 
0x0FB7, 0x0F56,  0x0F57, 
0x0FB7, 0x0F5B,  0x0F5C, 
0x102E, 0x1025,  0x1026, 
0x1100, 0x1100,  0x1101, 
0x1102, 0x1100,  0x1113, 
0x1102, 0x1102,  0x1114, 
0x1102, 0x1103,  0x1115, 
0x1102, 0x1107,  0x1116, 
0x1103, 0x1100,  0x1117, 
0x1103, 0x1103,  0x1104, 
0x1105, 0x1102,  0x1118, 
0x1105, 0x1105,  0x1119, 
0x1105, 0x110B,  0x111B, 
0x1105, 0x1112,  0x111A, 
0x1106, 0x1107,  0x111C, 
0x1106, 0x110B,  0x111D, 
0x1107, 0x1100,  0x111E, 
0x1107, 0x1102,  0x111F, 
0x1107, 0x1103,  0x1120, 
0x1107, 0x1107,  0x1108, 
0x1107, 0x1109,  0x1121, 
0x1107, 0x110A,  0x1125, 
0x1107, 0x110B,  0x112B, 
0x1107, 0x110C,  0x1127, 
0x1107, 0x110E,  0x1128, 
0x1107, 0x1110,  0x1129, 
0x1107, 0x1111,  0x112A, 
0x1107, 0x112B,  0x112C, 
0x1107, 0x112D,  0x1122, 
0x1107, 0x112F,  0x1123, 
0x1107, 0x1132,  0x1124, 
0x1107, 0x1136,  0x1126, 
0x1108, 0x110B,  0x112C, 
0x1109, 0x1100,  0x112D, 
0x1109, 0x1102,  0x112E, 
0x1109, 0x1103,  0x112F, 
0x1109, 0x1105,  0x1130, 
0x1109, 0x1106,  0x1131, 
0x1109, 0x1107,  0x1132, 
0x1109, 0x1109,  0x110A, 
0x1109, 0x110A,  0x1134, 
0x1109, 0x110B,  0x1135, 
0x1109, 0x110C,  0x1136, 
0x1109, 0x110E,  0x1137, 
0x1109, 0x110F,  0x1138, 
0x1109, 0x1110,  0x1139, 
0x1109, 0x1111,  0x113A, 
0x1109, 0x1112,  0x113B, 
0x1109, 0x111E,  0x1133, 
0x110A, 0x1109,  0x1134, 
0x110B, 0x1100,  0x1141, 
0x110B, 0x1103,  0x1142, 
0x110B, 0x1106,  0x1143, 
0x110B, 0x1107,  0x1144, 
0x110B, 0x1109,  0x1145, 
0x110B, 0x110B,  0x1147, 
0x110B, 0x110C,  0x1148, 
0x110B, 0x110E,  0x1149, 
0x110B, 0x1110,  0x114A, 
0x110B, 0x1111,  0x114B, 
0x110B, 0x1140,  0x1146, 
0x110C, 0x110B,  0x114D, 
0x110C, 0x110C,  0x110D, 
0x110E, 0x110F,  0x1152, 
0x110E, 0x1112,  0x1153, 
0x1111, 0x1107,  0x1156, 
0x1111, 0x110B,  0x1157, 
0x1112, 0x1112,  0x1158, 
0x1121, 0x1100,  0x1122, 
0x1121, 0x1103,  0x1123, 
0x1121, 0x1107,  0x1124, 
0x1121, 0x1109,  0x1125, 
0x1121, 0x110C,  0x1126, 
0x1132, 0x1100,  0x1133, 
0x113C, 0x113C,  0x113D, 
0x113E, 0x113E,  0x113F, 
0x114E, 0x114E,  0x114F, 
0x1150, 0x1150,  0x1151, 
0x1161, 0x1169,  0x1176, 
0x1161, 0x116E,  0x1177, 
0x1161, 0x1175,  0x1162, 
0x1163, 0x1169,  0x1178, 
0x1163, 0x116D,  0x1179, 
0x1163, 0x1175,  0x1164, 
0x1165, 0x1169,  0x117A, 
0x1165, 0x116E,  0x117B, 
0x1165, 0x1173,  0x117C, 
0x1165, 0x1175,  0x1166, 
0x1167, 0x1169,  0x117D, 
0x1167, 0x116E,  0x117E, 
0x1167, 0x1175,  0x1168, 
0x1169, 0x1161,  0x116A, 
0x1169, 0x1162,  0x116B, 
0x1169, 0x1165,  0x117F, 
0x1169, 0x1166,  0x1180, 
0x1169, 0x1168,  0x1181, 
0x1169, 0x1169,  0x1182, 
0x1169, 0x116E,  0x1183, 
0x1169, 0x1175,  0x116C, 
0x116A, 0x1175,  0x116B, 
0x116D, 0x1163,  0x1184, 
0x116D, 0x1164,  0x1185, 
0x116D, 0x1167,  0x1186, 
0x116D, 0x1169,  0x1187, 
0x116D, 0x1175,  0x1188, 
0x116E, 0x1161,  0x1189, 
0x116E, 0x1162,  0x118A, 
0x116E, 0x1165,  0x116F, 
0x116E, 0x1166,  0x1170, 
0x116E, 0x1168,  0x118C, 
0x116E, 0x116E,  0x118D, 
0x116E, 0x1175,  0x1171, 
0x116E, 0x117C,  0x118B, 
0x116F, 0x1173,  0x118B, 
0x116F, 0x1175,  0x1170, 
0x1172, 0x1161,  0x118E, 
0x1172, 0x1165,  0x118F, 
0x1172, 0x1166,  0x1190, 
0x1172, 0x1167,  0x1191, 
0x1172, 0x1168,  0x1192, 
0x1172, 0x116E,  0x1193, 
0x1172, 0x1175,  0x1194, 
0x1173, 0x116E,  0x1195, 
0x1173, 0x1173,  0x1196, 
0x1173, 0x1175,  0x1174, 
0x1174, 0x116E,  0x1197, 
0x1175, 0x1161,  0x1198, 
0x1175, 0x1163,  0x1199, 
0x1175, 0x1169,  0x119A, 
0x1175, 0x116E,  0x119B, 
0x1175, 0x1173,  0x119C, 
0x1175, 0x119E,  0x119D, 
0x119E, 0x1165,  0x119F, 
0x119E, 0x116E,  0x11A0, 
0x119E, 0x1175,  0x11A1, 
0x119E, 0x119E,  0x11A2, 
0x11A8, 0x11A8,  0x11A9, 
0x11A8, 0x11AF,  0x11C3, 
0x11A8, 0x11BA,  0x11AA, 
0x11A8, 0x11E7,  0x11C4, 
0x11AA, 0x11A8,  0x11C4, 
0x11AB, 0x11A8,  0x11C5, 
0x11AB, 0x11AE,  0x11C6, 
0x11AB, 0x11BA,  0x11C7, 
0x11AB, 0x11BD,  0x11AC, 
0x11AB, 0x11C0,  0x11C9, 
0x11AB, 0x11C2,  0x11AD, 
0x11AB, 0x11EB,  0x11C8, 
0x11AE, 0x11A8,  0x11CA, 
0x11AE, 0x11AF,  0x11CB, 
0x11AF, 0x11A8,  0x11B0, 
0x11AF, 0x11AA,  0x11CC, 
0x11AF, 0x11AB,  0x11CD, 
0x11AF, 0x11AE,  0x11CE, 
0x11AF, 0x11AF,  0x11D0, 
0x11AF, 0x11B7,  0x11B1, 
0x11AF, 0x11B8,  0x11B2, 
0x11AF, 0x11B9,  0x11D3, 
0x11AF, 0x11BA,  0x11B3, 
0x11AF, 0x11BB,  0x11D6, 
0x11AF, 0x11BF,  0x11D8, 
0x11AF, 0x11C0,  0x11B4, 
0x11AF, 0x11C1,  0x11B5, 
0x11AF, 0x11C2,  0x11B6, 
0x11AF, 0x11DA,  0x11D1, 
0x11AF, 0x11DD,  0x11D2, 
0x11AF, 0x11E5,  0x11D4, 
0x11AF, 0x11E6,  0x11D5, 
0x11AF, 0x11EB,  0x11D7, 
0x11AF, 0x11F9,  0x11D9, 
0x11B0, 0x11BA,  0x11CC, 
0x11B1, 0x11A8,  0x11D1, 
0x11B1, 0x11BA,  0x11D2, 
0x11B2, 0x11BA,  0x11D3, 
0x11B2, 0x11BC,  0x11D5, 
0x11B2, 0x11C2,  0x11D4, 
0x11B3, 0x11BA,  0x11D6, 
0x11B7, 0x11A8,  0x11DA, 
0x11B7, 0x11AF,  0x11DB, 
0x11B7, 0x11B8,  0x11DC, 
0x11B7, 0x11BA,  0x11DD, 
0x11B7, 0x11BB,  0x11DE, 
0x11B7, 0x11BC,  0x11E2, 
0x11B7, 0x11BE,  0x11E0, 
0x11B7, 0x11C2,  0x11E1, 
0x11B7, 0x11EB,  0x11DF, 
0x11B8, 0x11AF,  0x11E3, 
0x11B8, 0x11BA,  0x11B9, 
0x11B8, 0x11BC,  0x11E6, 
0x11B8, 0x11C1,  0x11E4, 
0x11B8, 0x11C2,  0x11E5, 
0x11BA, 0x11A8,  0x11E7, 
0x11BA, 0x11AE,  0x11E8, 
0x11BA, 0x11AF,  0x11E9, 
0x11BA, 0x11B8,  0x11EA, 
0x11BA, 0x11BA,  0x11BB, 
0x11BC, 0x11A8,  0x11EC, 
0x11BC, 0x11A9,  0x11ED, 
0x11BC, 0x11BC,  0x11EE, 
0x11BC, 0x11BF,  0x11EF, 
0x11C1, 0x11B8,  0x11F3, 
0x11C1, 0x11BC,  0x11F4, 
0x11C2, 0x11AB,  0x11F5, 
0x11C2, 0x11AF,  0x11F6, 
0x11C2, 0x11B7,  0x11F7, 
0x11C2, 0x11B8,  0x11F8, 
0x11CE, 0x11C2,  0x11CF, 
0x11DD, 0x11BA,  0x11DE, 
0x11EC, 0x11A8,  0x11ED, 
0x11F0, 0x11BA,  0x11F1, 
0x11F0, 0x11EB,  0x11F2, 
0x1FBF, IBUS_KEY_apostrophe,  0x1FCE, 
0x1FBF, IBUS_KEY_grave,  0x1FCD, 
0x1FBF, IBUS_KEY_asciitilde,  0x1FCF, 
0x1FBF, IBUS_KEY_acute,  0x1FCE, 
0x1FBF, IBUS_KEY_dead_grave,  0x1FCD, 
0x1FBF, IBUS_KEY_dead_acute,  0x1FCE, 
0x1FBF, IBUS_KEY_dead_tilde,  0x1FCF, 
0x1FFE, IBUS_KEY_apostrophe,  0x1FDE, 
0x1FFE, IBUS_KEY_grave,  0x1FDD, 
0x1FFE, IBUS_KEY_asciitilde,  0x1FDF, 
0x1FFE, IBUS_KEY_acute,  0x1FDE, 
0x1FFE, IBUS_KEY_dead_grave,  0x1FDD, 
0x1FFE, IBUS_KEY_dead_acute,  0x1FDE, 
0x1FFE, IBUS_KEY_dead_tilde,  0x1FDF, 
0x2190, IBUS_KEY_bar,  0x2345, 
0x2190, 0x2395,  0x2347, 
0x2191, IBUS_KEY_minus,  0x234F, 
0x2191, 0x2395,  0x2350, 
0x2192, IBUS_KEY_bar,  0x2346, 
0x2192, 0x2395,  0x2348, 
0x2193, IBUS_KEY_minus,  0x2356, 
0x2193, 0x2395,  0x2357, 
0x2203, 0x0338,  0x2204, 
0x2206, IBUS_KEY_underscore,  0x2359, 
0x2206, IBUS_KEY_bar,  0x234B, 
0x2206, 0x2395,  0x234D, 
0x2207, IBUS_KEY_bar,  0x2352, 
0x2207, IBUS_KEY_asciitilde,  0x236B, 
0x2207, IBUS_KEY_diaeresis,  0x2362, 
0x2207, 0x2395,  0x2354, 
0x2208, 0x0338,  0x2209, 
0x220A, IBUS_KEY_underscore,  0x2377, 
0x220B, 0x0338,  0x220C, 
0x2218, IBUS_KEY_underscore,  0x235B, 
0x2218, IBUS_KEY_diaeresis,  0x2364, 
0x2218, 0x2229,  0x235D, 
0x2218, IBUS_KEY_uptack,  0x2355, 
0x2218, IBUS_KEY_downtack,  0x234E, 
0x2218, 0x2395,  0x233B, 
0x2218, IBUS_KEY_emopencircle,  0x233E, 
0x2223, 0x0338,  0x2224, 
0x2225, 0x0338,  0x2226, 
0x2227, IBUS_KEY_asciitilde,  0x2372, 
0x2227, 0x2228,  0x22C4, 
0x2227, 0x2395,  0x2353, 
0x2228, IBUS_KEY_asciitilde,  0x2371, 
0x2228, 0x2227,  0x22C4, 
0x2228, 0x2395,  0x234C, 
0x2229, 0x2218,  0x235D, 
IBUS_KEY_union, IBUS_KEY_bar,  0x2366, 
0x223C, 0x0338,  0x2241, 
0x2243, 0x0338,  0x2244, 
0x2248, 0x0338,  0x2249, 
0x224D, 0x0338,  0x226D, 
0x2260, IBUS_KEY_underscore,  0x2262, 
0x2260, 0x2395,  0x236F, 
0x2272, 0x0338,  0x2274, 
0x2273, 0x0338,  0x2275, 
0x2276, 0x0338,  0x2278, 
0x2277, 0x0338,  0x2279, 
0x227A, 0x0338,  0x2280, 
0x227B, 0x0338,  0x2281, 
0x227C, 0x0338,  0x22E0, 
0x227D, 0x0338,  0x22E1, 
0x2282, IBUS_KEY_underscore,  0x2286, 
0x2282, IBUS_KEY_bar,  0x2367, 
0x2283, IBUS_KEY_underscore,  0x2287, 
0x2286, 0x0338,  0x2288, 
0x2287, 0x0338,  0x2289, 
0x2291, 0x0338,  0x22E2, 
0x2292, 0x0338,  0x22E3, 
IBUS_KEY_uptack, IBUS_KEY_diaeresis,  0x2361, 
IBUS_KEY_uptack, IBUS_KEY_macron,  0x2351, 
IBUS_KEY_uptack, 0x2218,  0x2355, 
IBUS_KEY_uptack, IBUS_KEY_downtack,  0x2336, 
IBUS_KEY_downtack, IBUS_KEY_underscore,  0x234A, 
IBUS_KEY_downtack, 0x2218,  0x234E, 
IBUS_KEY_downtack, IBUS_KEY_uptack,  0x2336, 
0x22A8, 0x0338,  0x22AD, 
0x22A9, 0x0338,  0x22AE, 
0x22AB, 0x0338,  0x22AF, 
0x22B2, 0x0338,  0x22EA, 
0x22B3, 0x0338,  0x22EB, 
0x22B4, 0x0338,  0x22EC, 
0x22B5, 0x0338,  0x22ED, 
0x22C4, IBUS_KEY_underscore,  0x235A, 
0x22C4, 0x2395,  0x233A, 
0x2373, IBUS_KEY_underscore,  0x2378, 
0x2375, IBUS_KEY_underscore,  0x2379, 
0x237A, IBUS_KEY_underscore,  0x2376, 
0x2395, IBUS_KEY_apostrophe,  0x235E, 
0x2395, IBUS_KEY_slash,  0x2341, 
0x2395, IBUS_KEY_colon,  0x2360, 
0x2395, IBUS_KEY_less,  0x2343, 
0x2395, IBUS_KEY_equal,  0x2338, 
0x2395, IBUS_KEY_greater,  0x2344, 
0x2395, IBUS_KEY_question,  0x2370, 
0x2395, IBUS_KEY_backslash,  0x2342, 
0x2395, IBUS_KEY_division,  0x2339, 
0x2395, 0x2190,  0x2347, 
0x2395, 0x2191,  0x2350, 
0x2395, 0x2192,  0x2348, 
0x2395, 0x2193,  0x2357, 
0x2395, 0x2206,  0x234D, 
0x2395, 0x2207,  0x2354, 
0x2395, 0x2218,  0x233B, 
0x2395, 0x2227,  0x2353, 
0x2395, 0x2228,  0x234C, 
0x2395, 0x2260,  0x236F, 
0x2395, 0x22C4,  0x233A, 
0x2395, IBUS_KEY_emopencircle,  0x233C, 
IBUS_KEY_emopencircle, IBUS_KEY_asterisk,  0x235F, 
IBUS_KEY_emopencircle, IBUS_KEY_minus,  0x2296, 
IBUS_KEY_emopencircle, IBUS_KEY_period,  0x2299, 
IBUS_KEY_emopencircle, IBUS_KEY_backslash,  0x2349, 
IBUS_KEY_emopencircle, IBUS_KEY_underscore,  0x235C, 
IBUS_KEY_emopencircle, IBUS_KEY_bar,  0x233D, 
IBUS_KEY_emopencircle, IBUS_KEY_diaeresis,  0x2365, 
IBUS_KEY_emopencircle, 0x2218,  0x233E, 
IBUS_KEY_emopencircle, 0x2395,  0x233C, 
0x2ADD, 0x0338,  0x2ADC, 
IBUS_KEY_KP_Divide, IBUS_KEY_D,  0x0110, 
IBUS_KEY_KP_Divide, IBUS_KEY_G,  0x01E4, 
IBUS_KEY_KP_Divide, IBUS_KEY_H,  0x0126, 
IBUS_KEY_KP_Divide, IBUS_KEY_I,  0x0197, 
IBUS_KEY_KP_Divide, IBUS_KEY_L,  0x0141, 
IBUS_KEY_KP_Divide, IBUS_KEY_O,  0x00D8, 
IBUS_KEY_KP_Divide, IBUS_KEY_T,  0x0166, 
IBUS_KEY_KP_Divide, IBUS_KEY_Z,  0x01B5, 
IBUS_KEY_KP_Divide, IBUS_KEY_b,  0x0180, 
IBUS_KEY_KP_Divide, IBUS_KEY_d,  0x0111, 
IBUS_KEY_KP_Divide, IBUS_KEY_g,  0x01E5, 
IBUS_KEY_KP_Divide, IBUS_KEY_h,  0x0127, 
IBUS_KEY_KP_Divide, IBUS_KEY_i,  0x0268, 
IBUS_KEY_KP_Divide, IBUS_KEY_l,  0x0142, 
IBUS_KEY_KP_Divide, IBUS_KEY_o,  0x00F8, 
IBUS_KEY_KP_Divide, IBUS_KEY_t,  0x0167, 
IBUS_KEY_KP_Divide, IBUS_KEY_z,  0x01B6, 
IBUS_KEY_KP_Divide, 0x0294,  0x02A1, 
IBUS_KEY_KP_Divide, 0x04AE,  0x04B0, 
IBUS_KEY_KP_Divide, 0x04AF,  0x04B1, 
IBUS_KEY_KP_Divide, IBUS_KEY_Cyrillic_ghe,  0x0493, 
IBUS_KEY_KP_Divide, IBUS_KEY_Cyrillic_ka,  0x049F, 
IBUS_KEY_KP_Divide, IBUS_KEY_Cyrillic_GHE,  0x0492, 
IBUS_KEY_KP_Divide, IBUS_KEY_Cyrillic_KA,  0x049E, 
IBUS_KEY_KP_Divide, IBUS_KEY_leftarrow,  0x219A, 
IBUS_KEY_KP_Divide, IBUS_KEY_rightarrow,  0x219B, 
IBUS_KEY_KP_Divide, 0x2194,  0x21AE, 
IBUS_KEY_KP_Equal, 0x0338,  0x2260, 
IBUS_KEY_exclam, IBUS_KEY_plus, IBUS_KEY_O,  0x1EE2, 
IBUS_KEY_exclam, IBUS_KEY_plus, IBUS_KEY_U,  0x1EF0, 
IBUS_KEY_exclam, IBUS_KEY_plus, IBUS_KEY_o,  0x1EE3, 
IBUS_KEY_exclam, IBUS_KEY_plus, IBUS_KEY_u,  0x1EF1, 
IBUS_KEY_exclam, IBUS_KEY_dead_horn, IBUS_KEY_O,  0x1EE2, 
IBUS_KEY_exclam, IBUS_KEY_dead_horn, IBUS_KEY_U,  0x1EF0, 
IBUS_KEY_exclam, IBUS_KEY_dead_horn, IBUS_KEY_o,  0x1EE3, 
IBUS_KEY_exclam, IBUS_KEY_dead_horn, IBUS_KEY_u,  0x1EF1, 
IBUS_KEY_quotedbl, IBUS_KEY_apostrophe, IBUS_KEY_space,  0x0385, 
IBUS_KEY_quotedbl, IBUS_KEY_apostrophe, IBUS_KEY_Greek_iota,  0x0390, 
IBUS_KEY_quotedbl, IBUS_KEY_apostrophe, IBUS_KEY_Greek_upsilon,  0x03B0, 
IBUS_KEY_quotedbl, IBUS_KEY_underscore, IBUS_KEY_U,  0x1E7A, 
IBUS_KEY_quotedbl, IBUS_KEY_underscore, IBUS_KEY_u,  0x1E7B, 
IBUS_KEY_quotedbl, IBUS_KEY_asciitilde, IBUS_KEY_O,  0x1E4E, 
IBUS_KEY_quotedbl, IBUS_KEY_asciitilde, IBUS_KEY_o,  0x1E4F, 
IBUS_KEY_quotedbl, IBUS_KEY_macron, IBUS_KEY_U,  0x1E7A, 
IBUS_KEY_quotedbl, IBUS_KEY_macron, IBUS_KEY_u,  0x1E7B, 
IBUS_KEY_quotedbl, IBUS_KEY_dead_tilde, IBUS_KEY_O,  0x1E4E, 
IBUS_KEY_quotedbl, IBUS_KEY_dead_tilde, IBUS_KEY_o,  0x1E4F, 
IBUS_KEY_quotedbl, IBUS_KEY_dead_macron, IBUS_KEY_U,  0x1E7A, 
IBUS_KEY_quotedbl, IBUS_KEY_dead_macron, IBUS_KEY_u,  0x1E7B, 
IBUS_KEY_apostrophe, IBUS_KEY_quotedbl, IBUS_KEY_space,  0x0385, 
IBUS_KEY_apostrophe, IBUS_KEY_quotedbl, IBUS_KEY_I,  0x1E2E, 
IBUS_KEY_apostrophe, IBUS_KEY_quotedbl, IBUS_KEY_U,  0x01D7, 
IBUS_KEY_apostrophe, IBUS_KEY_quotedbl, IBUS_KEY_i,  0x1E2F, 
IBUS_KEY_apostrophe, IBUS_KEY_quotedbl, IBUS_KEY_u,  0x01D8, 
IBUS_KEY_apostrophe, IBUS_KEY_quotedbl, IBUS_KEY_Greek_iota,  0x0390, 
IBUS_KEY_apostrophe, IBUS_KEY_quotedbl, IBUS_KEY_Greek_upsilon,  0x03B0, 
IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F0D, 
IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_EPSILON,  0x1F1D, 
IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F2D, 
IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_IOTA,  0x1F3D, 
IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMICRON,  0x1F4D, 
IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_UPSILON,  0x1F5D, 
IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1F6D, 
IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F05, 
IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_epsilon,  0x1F15, 
IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F25, 
IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_iota,  0x1F35, 
IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_omicron,  0x1F45, 
IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_upsilon,  0x1F55, 
IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1F65, 
IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F0C, 
IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_EPSILON,  0x1F1C, 
IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F2C, 
IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_IOTA,  0x1F3C, 
IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_OMICRON,  0x1F4C, 
IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1F6C, 
IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F04, 
IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_epsilon,  0x1F14, 
IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F24, 
IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_iota,  0x1F34, 
IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_omicron,  0x1F44, 
IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_upsilon,  0x1F54, 
IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1F64, 
IBUS_KEY_apostrophe, IBUS_KEY_plus, IBUS_KEY_O,  0x1EDA, 
IBUS_KEY_apostrophe, IBUS_KEY_plus, IBUS_KEY_U,  0x1EE8, 
IBUS_KEY_apostrophe, IBUS_KEY_plus, IBUS_KEY_o,  0x1EDB, 
IBUS_KEY_apostrophe, IBUS_KEY_plus, IBUS_KEY_u,  0x1EE9, 
IBUS_KEY_apostrophe, IBUS_KEY_slash, IBUS_KEY_O,  0x01FE, 
IBUS_KEY_apostrophe, IBUS_KEY_slash, IBUS_KEY_o,  0x01FF, 
IBUS_KEY_apostrophe, IBUS_KEY_asciicircum, IBUS_KEY_A,  0x1EA4, 
IBUS_KEY_apostrophe, IBUS_KEY_asciicircum, IBUS_KEY_E,  0x1EBE, 
IBUS_KEY_apostrophe, IBUS_KEY_asciicircum, IBUS_KEY_O,  0x1ED0, 
IBUS_KEY_apostrophe, IBUS_KEY_asciicircum, IBUS_KEY_a,  0x1EA5, 
IBUS_KEY_apostrophe, IBUS_KEY_asciicircum, IBUS_KEY_e,  0x1EBF, 
IBUS_KEY_apostrophe, IBUS_KEY_asciicircum, IBUS_KEY_o,  0x1ED1, 
IBUS_KEY_apostrophe, IBUS_KEY_underscore, IBUS_KEY_E,  0x1E16, 
IBUS_KEY_apostrophe, IBUS_KEY_underscore, IBUS_KEY_O,  0x1E52, 
IBUS_KEY_apostrophe, IBUS_KEY_underscore, IBUS_KEY_e,  0x1E17, 
IBUS_KEY_apostrophe, IBUS_KEY_underscore, IBUS_KEY_o,  0x1E53, 
IBUS_KEY_apostrophe, IBUS_KEY_b, IBUS_KEY_A,  0x1EAE, 
IBUS_KEY_apostrophe, IBUS_KEY_b, IBUS_KEY_a,  0x1EAF, 
IBUS_KEY_apostrophe, IBUS_KEY_asciitilde, IBUS_KEY_O,  0x1E4C, 
IBUS_KEY_apostrophe, IBUS_KEY_asciitilde, IBUS_KEY_U,  0x1E78, 
IBUS_KEY_apostrophe, IBUS_KEY_asciitilde, IBUS_KEY_o,  0x1E4D, 
IBUS_KEY_apostrophe, IBUS_KEY_asciitilde, IBUS_KEY_u,  0x1E79, 
IBUS_KEY_apostrophe, IBUS_KEY_macron, IBUS_KEY_E,  0x1E16, 
IBUS_KEY_apostrophe, IBUS_KEY_macron, IBUS_KEY_O,  0x1E52, 
IBUS_KEY_apostrophe, IBUS_KEY_macron, IBUS_KEY_e,  0x1E17, 
IBUS_KEY_apostrophe, IBUS_KEY_macron, IBUS_KEY_o,  0x1E53, 
IBUS_KEY_apostrophe, IBUS_KEY_cedilla, IBUS_KEY_C,  0x1E08, 
IBUS_KEY_apostrophe, IBUS_KEY_cedilla, IBUS_KEY_c,  0x1E09, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_circumflex, IBUS_KEY_A,  0x1EA4, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_circumflex, IBUS_KEY_E,  0x1EBE, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_circumflex, IBUS_KEY_O,  0x1ED0, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_circumflex, IBUS_KEY_a,  0x1EA5, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_circumflex, IBUS_KEY_e,  0x1EBF, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_circumflex, IBUS_KEY_o,  0x1ED1, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_tilde, IBUS_KEY_O,  0x1E4C, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_tilde, IBUS_KEY_U,  0x1E78, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_tilde, IBUS_KEY_o,  0x1E4D, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_tilde, IBUS_KEY_u,  0x1E79, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_macron, IBUS_KEY_E,  0x1E16, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_macron, IBUS_KEY_O,  0x1E52, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_macron, IBUS_KEY_e,  0x1E17, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_macron, IBUS_KEY_o,  0x1E53, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_breve, IBUS_KEY_A,  0x1EAE, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_breve, IBUS_KEY_a,  0x1EAF, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_diaeresis, IBUS_KEY_I,  0x1E2E, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_diaeresis, IBUS_KEY_U,  0x01D7, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_diaeresis, IBUS_KEY_i,  0x1E2F, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_diaeresis, IBUS_KEY_u,  0x01D8, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_diaeresis, IBUS_KEY_Greek_iota,  0x0390, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_diaeresis, IBUS_KEY_Greek_upsilon,  0x03B0, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_abovering, IBUS_KEY_A,  0x01FA, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_abovering, IBUS_KEY_a,  0x01FB, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_cedilla, IBUS_KEY_C,  0x1E08, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_cedilla, IBUS_KEY_c,  0x1E09, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_horn, IBUS_KEY_O,  0x1EDA, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_horn, IBUS_KEY_U,  0x1EE8, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_horn, IBUS_KEY_o,  0x1EDB, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_horn, IBUS_KEY_u,  0x1EE9, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ALPHA,  0x1F0C, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_EPSILON,  0x1F1C, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ETA,  0x1F2C, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_IOTA,  0x1F3C, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMICRON,  0x1F4C, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMEGA,  0x1F6C, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_alpha,  0x1F04, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_epsilon,  0x1F14, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_eta,  0x1F24, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_iota,  0x1F34, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_omicron,  0x1F44, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_upsilon,  0x1F54, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_omega,  0x1F64, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ALPHA,  0x1F0D, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_EPSILON,  0x1F1D, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ETA,  0x1F2D, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_IOTA,  0x1F3D, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMICRON,  0x1F4D, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_UPSILON,  0x1F5D, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMEGA,  0x1F6D, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_alpha,  0x1F05, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_epsilon,  0x1F15, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_eta,  0x1F25, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_iota,  0x1F35, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omicron,  0x1F45, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_upsilon,  0x1F55, 
IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omega,  0x1F65, 
IBUS_KEY_apostrophe, IBUS_KEY_KP_Divide, IBUS_KEY_O,  0x01FE, 
IBUS_KEY_apostrophe, IBUS_KEY_KP_Divide, IBUS_KEY_o,  0x01FF, 
IBUS_KEY_parenleft, IBUS_KEY_0, IBUS_KEY_parenright,  0x24EA, 
IBUS_KEY_parenleft, IBUS_KEY_1, IBUS_KEY_parenright,  0x2460, 
IBUS_KEY_parenleft, IBUS_KEY_2, IBUS_KEY_parenright,  0x2461, 
IBUS_KEY_parenleft, IBUS_KEY_3, IBUS_KEY_parenright,  0x2462, 
IBUS_KEY_parenleft, IBUS_KEY_4, IBUS_KEY_parenright,  0x2463, 
IBUS_KEY_parenleft, IBUS_KEY_5, IBUS_KEY_parenright,  0x2464, 
IBUS_KEY_parenleft, IBUS_KEY_6, IBUS_KEY_parenright,  0x2465, 
IBUS_KEY_parenleft, IBUS_KEY_7, IBUS_KEY_parenright,  0x2466, 
IBUS_KEY_parenleft, IBUS_KEY_8, IBUS_KEY_parenright,  0x2467, 
IBUS_KEY_parenleft, IBUS_KEY_9, IBUS_KEY_parenright,  0x2468, 
IBUS_KEY_parenleft, IBUS_KEY_A, IBUS_KEY_parenright,  0x24B6, 
IBUS_KEY_parenleft, IBUS_KEY_B, IBUS_KEY_parenright,  0x24B7, 
IBUS_KEY_parenleft, IBUS_KEY_C, IBUS_KEY_parenright,  0x24B8, 
IBUS_KEY_parenleft, IBUS_KEY_D, IBUS_KEY_parenright,  0x24B9, 
IBUS_KEY_parenleft, IBUS_KEY_E, IBUS_KEY_parenright,  0x24BA, 
IBUS_KEY_parenleft, IBUS_KEY_F, IBUS_KEY_parenright,  0x24BB, 
IBUS_KEY_parenleft, IBUS_KEY_G, IBUS_KEY_parenright,  0x24BC, 
IBUS_KEY_parenleft, IBUS_KEY_H, IBUS_KEY_parenright,  0x24BD, 
IBUS_KEY_parenleft, IBUS_KEY_I, IBUS_KEY_parenright,  0x24BE, 
IBUS_KEY_parenleft, IBUS_KEY_J, IBUS_KEY_parenright,  0x24BF, 
IBUS_KEY_parenleft, IBUS_KEY_K, IBUS_KEY_parenright,  0x24C0, 
IBUS_KEY_parenleft, IBUS_KEY_L, IBUS_KEY_parenright,  0x24C1, 
IBUS_KEY_parenleft, IBUS_KEY_M, IBUS_KEY_parenright,  0x24C2, 
IBUS_KEY_parenleft, IBUS_KEY_N, IBUS_KEY_parenright,  0x24C3, 
IBUS_KEY_parenleft, IBUS_KEY_O, IBUS_KEY_parenright,  0x24C4, 
IBUS_KEY_parenleft, IBUS_KEY_P, IBUS_KEY_parenright,  0x24C5, 
IBUS_KEY_parenleft, IBUS_KEY_Q, IBUS_KEY_parenright,  0x24C6, 
IBUS_KEY_parenleft, IBUS_KEY_R, IBUS_KEY_parenright,  0x24C7, 
IBUS_KEY_parenleft, IBUS_KEY_S, IBUS_KEY_parenright,  0x24C8, 
IBUS_KEY_parenleft, IBUS_KEY_T, IBUS_KEY_parenright,  0x24C9, 
IBUS_KEY_parenleft, IBUS_KEY_U, IBUS_KEY_parenright,  0x24CA, 
IBUS_KEY_parenleft, IBUS_KEY_V, IBUS_KEY_parenright,  0x24CB, 
IBUS_KEY_parenleft, IBUS_KEY_W, IBUS_KEY_parenright,  0x24CC, 
IBUS_KEY_parenleft, IBUS_KEY_X, IBUS_KEY_parenright,  0x24CD, 
IBUS_KEY_parenleft, IBUS_KEY_Y, IBUS_KEY_parenright,  0x24CE, 
IBUS_KEY_parenleft, IBUS_KEY_Z, IBUS_KEY_parenright,  0x24CF, 
IBUS_KEY_parenleft, IBUS_KEY_a, IBUS_KEY_parenright,  0x24D0, 
IBUS_KEY_parenleft, IBUS_KEY_b, IBUS_KEY_parenright,  0x24D1, 
IBUS_KEY_parenleft, IBUS_KEY_c, IBUS_KEY_parenright,  0x24D2, 
IBUS_KEY_parenleft, IBUS_KEY_d, IBUS_KEY_parenright,  0x24D3, 
IBUS_KEY_parenleft, IBUS_KEY_e, IBUS_KEY_parenright,  0x24D4, 
IBUS_KEY_parenleft, IBUS_KEY_f, IBUS_KEY_parenright,  0x24D5, 
IBUS_KEY_parenleft, IBUS_KEY_g, IBUS_KEY_parenright,  0x24D6, 
IBUS_KEY_parenleft, IBUS_KEY_h, IBUS_KEY_parenright,  0x24D7, 
IBUS_KEY_parenleft, IBUS_KEY_i, IBUS_KEY_parenright,  0x24D8, 
IBUS_KEY_parenleft, IBUS_KEY_j, IBUS_KEY_parenright,  0x24D9, 
IBUS_KEY_parenleft, IBUS_KEY_k, IBUS_KEY_parenright,  0x24DA, 
IBUS_KEY_parenleft, IBUS_KEY_l, IBUS_KEY_parenright,  0x24DB, 
IBUS_KEY_parenleft, IBUS_KEY_m, IBUS_KEY_parenright,  0x24DC, 
IBUS_KEY_parenleft, IBUS_KEY_n, IBUS_KEY_parenright,  0x24DD, 
IBUS_KEY_parenleft, IBUS_KEY_o, IBUS_KEY_parenright,  0x24DE, 
IBUS_KEY_parenleft, IBUS_KEY_p, IBUS_KEY_parenright,  0x24DF, 
IBUS_KEY_parenleft, IBUS_KEY_q, IBUS_KEY_parenright,  0x24E0, 
IBUS_KEY_parenleft, IBUS_KEY_r, IBUS_KEY_parenright,  0x24E1, 
IBUS_KEY_parenleft, IBUS_KEY_s, IBUS_KEY_parenright,  0x24E2, 
IBUS_KEY_parenleft, IBUS_KEY_t, IBUS_KEY_parenright,  0x24E3, 
IBUS_KEY_parenleft, IBUS_KEY_u, IBUS_KEY_parenright,  0x24E4, 
IBUS_KEY_parenleft, IBUS_KEY_v, IBUS_KEY_parenright,  0x24E5, 
IBUS_KEY_parenleft, IBUS_KEY_w, IBUS_KEY_parenright,  0x24E6, 
IBUS_KEY_parenleft, IBUS_KEY_x, IBUS_KEY_parenright,  0x24E7, 
IBUS_KEY_parenleft, IBUS_KEY_y, IBUS_KEY_parenright,  0x24E8, 
IBUS_KEY_parenleft, IBUS_KEY_z, IBUS_KEY_parenright,  0x24E9, 
IBUS_KEY_parenleft, IBUS_KEY_kana_WO, IBUS_KEY_parenright,  0x32FE, 
IBUS_KEY_parenleft, IBUS_KEY_kana_A, IBUS_KEY_parenright,  0x32D0, 
IBUS_KEY_parenleft, IBUS_KEY_kana_I, IBUS_KEY_parenright,  0x32D1, 
IBUS_KEY_parenleft, IBUS_KEY_kana_U, IBUS_KEY_parenright,  0x32D2, 
IBUS_KEY_parenleft, IBUS_KEY_kana_E, IBUS_KEY_parenright,  0x32D3, 
IBUS_KEY_parenleft, IBUS_KEY_kana_O, IBUS_KEY_parenright,  0x32D4, 
IBUS_KEY_parenleft, IBUS_KEY_kana_KA, IBUS_KEY_parenright,  0x32D5, 
IBUS_KEY_parenleft, IBUS_KEY_kana_KI, IBUS_KEY_parenright,  0x32D6, 
IBUS_KEY_parenleft, IBUS_KEY_kana_KU, IBUS_KEY_parenright,  0x32D7, 
IBUS_KEY_parenleft, IBUS_KEY_kana_KE, IBUS_KEY_parenright,  0x32D8, 
IBUS_KEY_parenleft, IBUS_KEY_kana_KO, IBUS_KEY_parenright,  0x32D9, 
IBUS_KEY_parenleft, IBUS_KEY_kana_SA, IBUS_KEY_parenright,  0x32DA, 
IBUS_KEY_parenleft, IBUS_KEY_kana_SHI, IBUS_KEY_parenright,  0x32DB, 
IBUS_KEY_parenleft, IBUS_KEY_kana_SU, IBUS_KEY_parenright,  0x32DC, 
IBUS_KEY_parenleft, IBUS_KEY_kana_SE, IBUS_KEY_parenright,  0x32DD, 
IBUS_KEY_parenleft, IBUS_KEY_kana_SO, IBUS_KEY_parenright,  0x32DE, 
IBUS_KEY_parenleft, IBUS_KEY_kana_TA, IBUS_KEY_parenright,  0x32DF, 
IBUS_KEY_parenleft, IBUS_KEY_kana_CHI, IBUS_KEY_parenright,  0x32E0, 
IBUS_KEY_parenleft, IBUS_KEY_kana_TSU, IBUS_KEY_parenright,  0x32E1, 
IBUS_KEY_parenleft, IBUS_KEY_kana_TE, IBUS_KEY_parenright,  0x32E2, 
IBUS_KEY_parenleft, IBUS_KEY_kana_TO, IBUS_KEY_parenright,  0x32E3, 
IBUS_KEY_parenleft, IBUS_KEY_kana_NA, IBUS_KEY_parenright,  0x32E4, 
IBUS_KEY_parenleft, IBUS_KEY_kana_NI, IBUS_KEY_parenright,  0x32E5, 
IBUS_KEY_parenleft, IBUS_KEY_kana_NU, IBUS_KEY_parenright,  0x32E6, 
IBUS_KEY_parenleft, IBUS_KEY_kana_NE, IBUS_KEY_parenright,  0x32E7, 
IBUS_KEY_parenleft, IBUS_KEY_kana_NO, IBUS_KEY_parenright,  0x32E8, 
IBUS_KEY_parenleft, IBUS_KEY_kana_HA, IBUS_KEY_parenright,  0x32E9, 
IBUS_KEY_parenleft, IBUS_KEY_kana_HI, IBUS_KEY_parenright,  0x32EA, 
IBUS_KEY_parenleft, IBUS_KEY_kana_FU, IBUS_KEY_parenright,  0x32EB, 
IBUS_KEY_parenleft, IBUS_KEY_kana_HE, IBUS_KEY_parenright,  0x32EC, 
IBUS_KEY_parenleft, IBUS_KEY_kana_HO, IBUS_KEY_parenright,  0x32ED, 
IBUS_KEY_parenleft, IBUS_KEY_kana_MA, IBUS_KEY_parenright,  0x32EE, 
IBUS_KEY_parenleft, IBUS_KEY_kana_MI, IBUS_KEY_parenright,  0x32EF, 
IBUS_KEY_parenleft, IBUS_KEY_kana_MU, IBUS_KEY_parenright,  0x32F0, 
IBUS_KEY_parenleft, IBUS_KEY_kana_ME, IBUS_KEY_parenright,  0x32F1, 
IBUS_KEY_parenleft, IBUS_KEY_kana_MO, IBUS_KEY_parenright,  0x32F2, 
IBUS_KEY_parenleft, IBUS_KEY_kana_YA, IBUS_KEY_parenright,  0x32F3, 
IBUS_KEY_parenleft, IBUS_KEY_kana_YU, IBUS_KEY_parenright,  0x32F4, 
IBUS_KEY_parenleft, IBUS_KEY_kana_YO, IBUS_KEY_parenright,  0x32F5, 
IBUS_KEY_parenleft, IBUS_KEY_kana_RA, IBUS_KEY_parenright,  0x32F6, 
IBUS_KEY_parenleft, IBUS_KEY_kana_RI, IBUS_KEY_parenright,  0x32F7, 
IBUS_KEY_parenleft, IBUS_KEY_kana_RU, IBUS_KEY_parenright,  0x32F8, 
IBUS_KEY_parenleft, IBUS_KEY_kana_RE, IBUS_KEY_parenright,  0x32F9, 
IBUS_KEY_parenleft, IBUS_KEY_kana_RO, IBUS_KEY_parenright,  0x32FA, 
IBUS_KEY_parenleft, IBUS_KEY_kana_WA, IBUS_KEY_parenright,  0x32FB, 
IBUS_KEY_parenleft, 0x1100, IBUS_KEY_parenright,  0x3260, 
IBUS_KEY_parenleft, 0x1102, IBUS_KEY_parenright,  0x3261, 
IBUS_KEY_parenleft, 0x1103, IBUS_KEY_parenright,  0x3262, 
IBUS_KEY_parenleft, 0x1105, IBUS_KEY_parenright,  0x3263, 
IBUS_KEY_parenleft, 0x1106, IBUS_KEY_parenright,  0x3264, 
IBUS_KEY_parenleft, 0x1107, IBUS_KEY_parenright,  0x3265, 
IBUS_KEY_parenleft, 0x1109, IBUS_KEY_parenright,  0x3266, 
IBUS_KEY_parenleft, 0x110B, IBUS_KEY_parenright,  0x3267, 
IBUS_KEY_parenleft, 0x110C, IBUS_KEY_parenright,  0x3268, 
IBUS_KEY_parenleft, 0x110E, IBUS_KEY_parenright,  0x3269, 
IBUS_KEY_parenleft, 0x110F, IBUS_KEY_parenright,  0x326A, 
IBUS_KEY_parenleft, 0x1110, IBUS_KEY_parenright,  0x326B, 
IBUS_KEY_parenleft, 0x1111, IBUS_KEY_parenright,  0x326C, 
IBUS_KEY_parenleft, 0x1112, IBUS_KEY_parenright,  0x326D, 
IBUS_KEY_parenleft, 0x30F0, IBUS_KEY_parenright,  0x32FC, 
IBUS_KEY_parenleft, 0x30F1, IBUS_KEY_parenright,  0x32FD, 
IBUS_KEY_parenleft, 0x4E00, IBUS_KEY_parenright,  0x3280, 
IBUS_KEY_parenleft, 0x4E03, IBUS_KEY_parenright,  0x3286, 
IBUS_KEY_parenleft, 0x4E09, IBUS_KEY_parenright,  0x3282, 
IBUS_KEY_parenleft, 0x4E0A, IBUS_KEY_parenright,  0x32A4, 
IBUS_KEY_parenleft, 0x4E0B, IBUS_KEY_parenright,  0x32A6, 
IBUS_KEY_parenleft, 0x4E2D, IBUS_KEY_parenright,  0x32A5, 
IBUS_KEY_parenleft, 0x4E5D, IBUS_KEY_parenright,  0x3288, 
IBUS_KEY_parenleft, 0x4E8C, IBUS_KEY_parenright,  0x3281, 
IBUS_KEY_parenleft, 0x4E94, IBUS_KEY_parenright,  0x3284, 
IBUS_KEY_parenleft, 0x4F01, IBUS_KEY_parenright,  0x32AD, 
IBUS_KEY_parenleft, 0x4F11, IBUS_KEY_parenright,  0x32A1, 
IBUS_KEY_parenleft, 0x512A, IBUS_KEY_parenright,  0x329D, 
IBUS_KEY_parenleft, 0x516B, IBUS_KEY_parenright,  0x3287, 
IBUS_KEY_parenleft, 0x516D, IBUS_KEY_parenright,  0x3285, 
IBUS_KEY_parenleft, 0x5199, IBUS_KEY_parenright,  0x32A2, 
IBUS_KEY_parenleft, 0x52B4, IBUS_KEY_parenright,  0x3298, 
IBUS_KEY_parenleft, 0x533B, IBUS_KEY_parenright,  0x32A9, 
IBUS_KEY_parenleft, 0x5341, IBUS_KEY_parenright,  0x3289, 
IBUS_KEY_parenleft, 0x5354, IBUS_KEY_parenright,  0x32AF, 
IBUS_KEY_parenleft, 0x5370, IBUS_KEY_parenright,  0x329E, 
IBUS_KEY_parenleft, 0x53F3, IBUS_KEY_parenright,  0x32A8, 
IBUS_KEY_parenleft, 0x540D, IBUS_KEY_parenright,  0x3294, 
IBUS_KEY_parenleft, 0x56DB, IBUS_KEY_parenright,  0x3283, 
IBUS_KEY_parenleft, 0x571F, IBUS_KEY_parenright,  0x328F, 
IBUS_KEY_parenleft, 0x591C, IBUS_KEY_parenright,  0x32B0, 
IBUS_KEY_parenleft, 0x5973, IBUS_KEY_parenright,  0x329B, 
IBUS_KEY_parenleft, 0x5B66, IBUS_KEY_parenright,  0x32AB, 
IBUS_KEY_parenleft, 0x5B97, IBUS_KEY_parenright,  0x32AA, 
IBUS_KEY_parenleft, 0x5DE6, IBUS_KEY_parenright,  0x32A7, 
IBUS_KEY_parenleft, 0x65E5, IBUS_KEY_parenright,  0x3290, 
IBUS_KEY_parenleft, 0x6708, IBUS_KEY_parenright,  0x328A, 
IBUS_KEY_parenleft, 0x6709, IBUS_KEY_parenright,  0x3292, 
IBUS_KEY_parenleft, 0x6728, IBUS_KEY_parenright,  0x328D, 
IBUS_KEY_parenleft, 0x682A, IBUS_KEY_parenright,  0x3291, 
IBUS_KEY_parenleft, 0x6B63, IBUS_KEY_parenright,  0x32A3, 
IBUS_KEY_parenleft, 0x6C34, IBUS_KEY_parenright,  0x328C, 
IBUS_KEY_parenleft, 0x6CE8, IBUS_KEY_parenright,  0x329F, 
IBUS_KEY_parenleft, 0x706B, IBUS_KEY_parenright,  0x328B, 
IBUS_KEY_parenleft, 0x7279, IBUS_KEY_parenright,  0x3295, 
IBUS_KEY_parenleft, 0x7537, IBUS_KEY_parenright,  0x329A, 
IBUS_KEY_parenleft, 0x76E3, IBUS_KEY_parenright,  0x32AC, 
IBUS_KEY_parenleft, 0x793E, IBUS_KEY_parenright,  0x3293, 
IBUS_KEY_parenleft, 0x795D, IBUS_KEY_parenright,  0x3297, 
IBUS_KEY_parenleft, 0x79D8, IBUS_KEY_parenright,  0x3299, 
IBUS_KEY_parenleft, 0x8CA1, IBUS_KEY_parenright,  0x3296, 
IBUS_KEY_parenleft, 0x8CC7, IBUS_KEY_parenright,  0x32AE, 
IBUS_KEY_parenleft, 0x9069, IBUS_KEY_parenright,  0x329C, 
IBUS_KEY_parenleft, 0x91D1, IBUS_KEY_parenright,  0x328E, 
IBUS_KEY_parenleft, 0x9805, IBUS_KEY_parenright,  0x32A0, 
IBUS_KEY_parenleft, IBUS_KEY_KP_Space, IBUS_KEY_parenright,  0x2461, 
IBUS_KEY_parenleft, IBUS_KEY_KP_0, IBUS_KEY_parenright,  0x24EA, 
IBUS_KEY_parenleft, IBUS_KEY_KP_1, IBUS_KEY_parenright,  0x2460, 
IBUS_KEY_parenleft, IBUS_KEY_KP_2, IBUS_KEY_parenright,  0x2461, 
IBUS_KEY_parenleft, IBUS_KEY_KP_3, IBUS_KEY_parenright,  0x2462, 
IBUS_KEY_parenleft, IBUS_KEY_KP_4, IBUS_KEY_parenright,  0x2463, 
IBUS_KEY_parenleft, IBUS_KEY_KP_5, IBUS_KEY_parenright,  0x2464, 
IBUS_KEY_parenleft, IBUS_KEY_KP_6, IBUS_KEY_parenright,  0x2465, 
IBUS_KEY_parenleft, IBUS_KEY_KP_7, IBUS_KEY_parenright,  0x2466, 
IBUS_KEY_parenleft, IBUS_KEY_KP_8, IBUS_KEY_parenright,  0x2467, 
IBUS_KEY_parenleft, IBUS_KEY_KP_9, IBUS_KEY_parenright,  0x2468, 
IBUS_KEY_asterisk, IBUS_KEY_apostrophe, IBUS_KEY_A,  0x01FA, 
IBUS_KEY_asterisk, IBUS_KEY_apostrophe, IBUS_KEY_a,  0x01FB, 
IBUS_KEY_minus, IBUS_KEY_minus, IBUS_KEY_space,  0x00AD, 
IBUS_KEY_minus, IBUS_KEY_minus, IBUS_KEY_minus,  0x2014, 
IBUS_KEY_minus, IBUS_KEY_minus, IBUS_KEY_period,  0x2013, 
IBUS_KEY_period, IBUS_KEY_exclam, IBUS_KEY_S,  0x1E68, 
IBUS_KEY_period, IBUS_KEY_exclam, IBUS_KEY_s,  0x1E69, 
IBUS_KEY_period, IBUS_KEY_apostrophe, IBUS_KEY_S,  0x1E64, 
IBUS_KEY_period, IBUS_KEY_apostrophe, IBUS_KEY_s,  0x1E65, 
IBUS_KEY_period, IBUS_KEY_acute, IBUS_KEY_S,  0x1E64, 
IBUS_KEY_period, IBUS_KEY_acute, IBUS_KEY_s,  0x1E65, 
IBUS_KEY_period, IBUS_KEY_dead_acute, IBUS_KEY_S,  0x1E64, 
IBUS_KEY_period, IBUS_KEY_dead_acute, IBUS_KEY_s,  0x1E65, 
IBUS_KEY_period, IBUS_KEY_dead_caron, IBUS_KEY_S,  0x1E66, 
IBUS_KEY_period, IBUS_KEY_dead_caron, IBUS_KEY_s,  0x1E67, 
IBUS_KEY_period, IBUS_KEY_dead_belowdot, IBUS_KEY_S,  0x1E68, 
IBUS_KEY_period, IBUS_KEY_dead_belowdot, IBUS_KEY_s,  0x1E69, 
IBUS_KEY_1, IBUS_KEY_1, IBUS_KEY_0,  0x2152, 
IBUS_KEY_question, IBUS_KEY_plus, IBUS_KEY_O,  0x1EDE, 
IBUS_KEY_question, IBUS_KEY_plus, IBUS_KEY_U,  0x1EEC, 
IBUS_KEY_question, IBUS_KEY_plus, IBUS_KEY_o,  0x1EDF, 
IBUS_KEY_question, IBUS_KEY_plus, IBUS_KEY_u,  0x1EED, 
IBUS_KEY_question, IBUS_KEY_asciicircum, IBUS_KEY_A,  0x1EA8, 
IBUS_KEY_question, IBUS_KEY_asciicircum, IBUS_KEY_E,  0x1EC2, 
IBUS_KEY_question, IBUS_KEY_asciicircum, IBUS_KEY_O,  0x1ED4, 
IBUS_KEY_question, IBUS_KEY_asciicircum, IBUS_KEY_a,  0x1EA9, 
IBUS_KEY_question, IBUS_KEY_asciicircum, IBUS_KEY_e,  0x1EC3, 
IBUS_KEY_question, IBUS_KEY_asciicircum, IBUS_KEY_o,  0x1ED5, 
IBUS_KEY_question, IBUS_KEY_b, IBUS_KEY_A,  0x1EB2, 
IBUS_KEY_question, IBUS_KEY_b, IBUS_KEY_a,  0x1EB3, 
IBUS_KEY_question, IBUS_KEY_dead_circumflex, IBUS_KEY_A,  0x1EA8, 
IBUS_KEY_question, IBUS_KEY_dead_circumflex, IBUS_KEY_E,  0x1EC2, 
IBUS_KEY_question, IBUS_KEY_dead_circumflex, IBUS_KEY_O,  0x1ED4, 
IBUS_KEY_question, IBUS_KEY_dead_circumflex, IBUS_KEY_a,  0x1EA9, 
IBUS_KEY_question, IBUS_KEY_dead_circumflex, IBUS_KEY_e,  0x1EC3, 
IBUS_KEY_question, IBUS_KEY_dead_circumflex, IBUS_KEY_o,  0x1ED5, 
IBUS_KEY_question, IBUS_KEY_dead_breve, IBUS_KEY_A,  0x1EB2, 
IBUS_KEY_question, IBUS_KEY_dead_breve, IBUS_KEY_a,  0x1EB3, 
IBUS_KEY_question, IBUS_KEY_dead_horn, IBUS_KEY_O,  0x1EDE, 
IBUS_KEY_question, IBUS_KEY_dead_horn, IBUS_KEY_U,  0x1EEC, 
IBUS_KEY_question, IBUS_KEY_dead_horn, IBUS_KEY_o,  0x1EDF, 
IBUS_KEY_question, IBUS_KEY_dead_horn, IBUS_KEY_u,  0x1EED, 
IBUS_KEY_U, IBUS_KEY_exclam, IBUS_KEY_A,  0x1EB6, 
IBUS_KEY_U, IBUS_KEY_exclam, IBUS_KEY_a,  0x1EB7, 
IBUS_KEY_U, IBUS_KEY_cedilla, IBUS_KEY_E,  0x1E1C, 
IBUS_KEY_U, IBUS_KEY_cedilla, IBUS_KEY_e,  0x1E1D, 
IBUS_KEY_U, IBUS_KEY_dead_cedilla, IBUS_KEY_E,  0x1E1C, 
IBUS_KEY_U, IBUS_KEY_dead_cedilla, IBUS_KEY_e,  0x1E1D, 
IBUS_KEY_U, IBUS_KEY_dead_belowdot, IBUS_KEY_A,  0x1EB6, 
IBUS_KEY_U, IBUS_KEY_dead_belowdot, IBUS_KEY_a,  0x1EB7, 
IBUS_KEY_asciicircum, IBUS_KEY_exclam, IBUS_KEY_A,  0x1EAC, 
IBUS_KEY_asciicircum, IBUS_KEY_exclam, IBUS_KEY_E,  0x1EC6, 
IBUS_KEY_asciicircum, IBUS_KEY_exclam, IBUS_KEY_O,  0x1ED8, 
IBUS_KEY_asciicircum, IBUS_KEY_exclam, IBUS_KEY_a,  0x1EAD, 
IBUS_KEY_asciicircum, IBUS_KEY_exclam, IBUS_KEY_e,  0x1EC7, 
IBUS_KEY_asciicircum, IBUS_KEY_exclam, IBUS_KEY_o,  0x1ED9, 
IBUS_KEY_asciicircum, IBUS_KEY_underscore, IBUS_KEY_a,  0x00AA, 
IBUS_KEY_asciicircum, IBUS_KEY_underscore, IBUS_KEY_h,  0x02B0, 
IBUS_KEY_asciicircum, IBUS_KEY_underscore, IBUS_KEY_i,  0x2071, 
IBUS_KEY_asciicircum, IBUS_KEY_underscore, IBUS_KEY_j,  0x02B2, 
IBUS_KEY_asciicircum, IBUS_KEY_underscore, IBUS_KEY_l,  0x02E1, 
IBUS_KEY_asciicircum, IBUS_KEY_underscore, IBUS_KEY_n,  0x207F, 
IBUS_KEY_asciicircum, IBUS_KEY_underscore, IBUS_KEY_o,  0x00BA, 
IBUS_KEY_asciicircum, IBUS_KEY_underscore, IBUS_KEY_r,  0x02B3, 
IBUS_KEY_asciicircum, IBUS_KEY_underscore, IBUS_KEY_s,  0x02E2, 
IBUS_KEY_asciicircum, IBUS_KEY_underscore, IBUS_KEY_w,  0x02B7, 
IBUS_KEY_asciicircum, IBUS_KEY_underscore, IBUS_KEY_x,  0x02E3, 
IBUS_KEY_asciicircum, IBUS_KEY_underscore, IBUS_KEY_y,  0x02B8, 
IBUS_KEY_asciicircum, IBUS_KEY_underscore, 0x0263,  0x02E0, 
IBUS_KEY_asciicircum, IBUS_KEY_underscore, 0x0266,  0x02B1, 
IBUS_KEY_asciicircum, IBUS_KEY_underscore, 0x0279,  0x02B4, 
IBUS_KEY_asciicircum, IBUS_KEY_underscore, 0x027B,  0x02B5, 
IBUS_KEY_asciicircum, IBUS_KEY_underscore, 0x0281,  0x02B6, 
IBUS_KEY_asciicircum, IBUS_KEY_underscore, 0x0295,  0x02E4, 
IBUS_KEY_asciicircum, IBUS_KEY_underbar, IBUS_KEY_a,  0x00AA, 
IBUS_KEY_asciicircum, IBUS_KEY_underbar, IBUS_KEY_h,  0x02B0, 
IBUS_KEY_asciicircum, IBUS_KEY_underbar, IBUS_KEY_i,  0x2071, 
IBUS_KEY_asciicircum, IBUS_KEY_underbar, IBUS_KEY_j,  0x02B2, 
IBUS_KEY_asciicircum, IBUS_KEY_underbar, IBUS_KEY_l,  0x02E1, 
IBUS_KEY_asciicircum, IBUS_KEY_underbar, IBUS_KEY_n,  0x207F, 
IBUS_KEY_asciicircum, IBUS_KEY_underbar, IBUS_KEY_o,  0x00BA, 
IBUS_KEY_asciicircum, IBUS_KEY_underbar, IBUS_KEY_r,  0x02B3, 
IBUS_KEY_asciicircum, IBUS_KEY_underbar, IBUS_KEY_s,  0x02E2, 
IBUS_KEY_asciicircum, IBUS_KEY_underbar, IBUS_KEY_w,  0x02B7, 
IBUS_KEY_asciicircum, IBUS_KEY_underbar, IBUS_KEY_x,  0x02E3, 
IBUS_KEY_asciicircum, IBUS_KEY_underbar, IBUS_KEY_y,  0x02B8, 
IBUS_KEY_asciicircum, IBUS_KEY_underbar, 0x0263,  0x02E0, 
IBUS_KEY_asciicircum, IBUS_KEY_underbar, 0x0266,  0x02B1, 
IBUS_KEY_asciicircum, IBUS_KEY_underbar, 0x0279,  0x02B4, 
IBUS_KEY_asciicircum, IBUS_KEY_underbar, 0x027B,  0x02B5, 
IBUS_KEY_asciicircum, IBUS_KEY_underbar, 0x0281,  0x02B6, 
IBUS_KEY_asciicircum, IBUS_KEY_underbar, 0x0295,  0x02E4, 
IBUS_KEY_asciicircum, IBUS_KEY_dead_belowdot, IBUS_KEY_A,  0x1EAC, 
IBUS_KEY_asciicircum, IBUS_KEY_dead_belowdot, IBUS_KEY_E,  0x1EC6, 
IBUS_KEY_asciicircum, IBUS_KEY_dead_belowdot, IBUS_KEY_O,  0x1ED8, 
IBUS_KEY_asciicircum, IBUS_KEY_dead_belowdot, IBUS_KEY_a,  0x1EAD, 
IBUS_KEY_asciicircum, IBUS_KEY_dead_belowdot, IBUS_KEY_e,  0x1EC7, 
IBUS_KEY_asciicircum, IBUS_KEY_dead_belowdot, IBUS_KEY_o,  0x1ED9, 
IBUS_KEY_underscore, IBUS_KEY_exclam, IBUS_KEY_L,  0x1E38, 
IBUS_KEY_underscore, IBUS_KEY_exclam, IBUS_KEY_R,  0x1E5C, 
IBUS_KEY_underscore, IBUS_KEY_exclam, IBUS_KEY_l,  0x1E39, 
IBUS_KEY_underscore, IBUS_KEY_exclam, IBUS_KEY_r,  0x1E5D, 
IBUS_KEY_underscore, IBUS_KEY_quotedbl, IBUS_KEY_A,  0x01DE, 
IBUS_KEY_underscore, IBUS_KEY_quotedbl, IBUS_KEY_O,  0x022A, 
IBUS_KEY_underscore, IBUS_KEY_quotedbl, IBUS_KEY_U,  0x01D5, 
IBUS_KEY_underscore, IBUS_KEY_quotedbl, IBUS_KEY_a,  0x01DF, 
IBUS_KEY_underscore, IBUS_KEY_quotedbl, IBUS_KEY_o,  0x022B, 
IBUS_KEY_underscore, IBUS_KEY_quotedbl, IBUS_KEY_u,  0x01D6, 
IBUS_KEY_underscore, IBUS_KEY_period, IBUS_KEY_A,  0x01E0, 
IBUS_KEY_underscore, IBUS_KEY_period, IBUS_KEY_O,  0x0230, 
IBUS_KEY_underscore, IBUS_KEY_period, IBUS_KEY_a,  0x01E1, 
IBUS_KEY_underscore, IBUS_KEY_period, IBUS_KEY_o,  0x0231, 
IBUS_KEY_underscore, IBUS_KEY_semicolon, IBUS_KEY_O,  0x01EC, 
IBUS_KEY_underscore, IBUS_KEY_semicolon, IBUS_KEY_o,  0x01ED, 
IBUS_KEY_underscore, IBUS_KEY_asciitilde, IBUS_KEY_O,  0x022C, 
IBUS_KEY_underscore, IBUS_KEY_asciitilde, IBUS_KEY_o,  0x022D, 
IBUS_KEY_underscore, IBUS_KEY_dead_tilde, IBUS_KEY_O,  0x022C, 
IBUS_KEY_underscore, IBUS_KEY_dead_tilde, IBUS_KEY_o,  0x022D, 
IBUS_KEY_underscore, IBUS_KEY_dead_abovedot, IBUS_KEY_A,  0x01E0, 
IBUS_KEY_underscore, IBUS_KEY_dead_abovedot, IBUS_KEY_O,  0x0230, 
IBUS_KEY_underscore, IBUS_KEY_dead_abovedot, IBUS_KEY_a,  0x01E1, 
IBUS_KEY_underscore, IBUS_KEY_dead_abovedot, IBUS_KEY_o,  0x0231, 
IBUS_KEY_underscore, IBUS_KEY_dead_diaeresis, IBUS_KEY_A,  0x01DE, 
IBUS_KEY_underscore, IBUS_KEY_dead_diaeresis, IBUS_KEY_O,  0x022A, 
IBUS_KEY_underscore, IBUS_KEY_dead_diaeresis, IBUS_KEY_U,  0x01D5, 
IBUS_KEY_underscore, IBUS_KEY_dead_diaeresis, IBUS_KEY_a,  0x01DF, 
IBUS_KEY_underscore, IBUS_KEY_dead_diaeresis, IBUS_KEY_o,  0x022B, 
IBUS_KEY_underscore, IBUS_KEY_dead_diaeresis, IBUS_KEY_u,  0x01D6, 
IBUS_KEY_underscore, IBUS_KEY_dead_ogonek, IBUS_KEY_O,  0x01EC, 
IBUS_KEY_underscore, IBUS_KEY_dead_ogonek, IBUS_KEY_o,  0x01ED, 
IBUS_KEY_underscore, IBUS_KEY_dead_belowdot, IBUS_KEY_L,  0x1E38, 
IBUS_KEY_underscore, IBUS_KEY_dead_belowdot, IBUS_KEY_R,  0x1E5C, 
IBUS_KEY_underscore, IBUS_KEY_dead_belowdot, IBUS_KEY_l,  0x1E39, 
IBUS_KEY_underscore, IBUS_KEY_dead_belowdot, IBUS_KEY_r,  0x1E5D, 
IBUS_KEY_grave, IBUS_KEY_quotedbl, IBUS_KEY_U,  0x01DB, 
IBUS_KEY_grave, IBUS_KEY_quotedbl, IBUS_KEY_u,  0x01DC, 
IBUS_KEY_grave, IBUS_KEY_quotedbl, IBUS_KEY_Greek_iota,  0x1FD2, 
IBUS_KEY_grave, IBUS_KEY_quotedbl, IBUS_KEY_Greek_upsilon,  0x1FE2, 
IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F0B, 
IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_EPSILON,  0x1F1B, 
IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F2B, 
IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_IOTA,  0x1F3B, 
IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMICRON,  0x1F4B, 
IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_UPSILON,  0x1F5B, 
IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1F6B, 
IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F03, 
IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_epsilon,  0x1F13, 
IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F23, 
IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_iota,  0x1F33, 
IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_omicron,  0x1F43, 
IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_upsilon,  0x1F53, 
IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1F63, 
IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F0A, 
IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_EPSILON,  0x1F1A, 
IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F2A, 
IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_IOTA,  0x1F3A, 
IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_OMICRON,  0x1F4A, 
IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1F6A, 
IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F02, 
IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_epsilon,  0x1F12, 
IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F22, 
IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_iota,  0x1F32, 
IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_omicron,  0x1F42, 
IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_upsilon,  0x1F52, 
IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1F62, 
IBUS_KEY_grave, IBUS_KEY_plus, IBUS_KEY_O,  0x1EDC, 
IBUS_KEY_grave, IBUS_KEY_plus, IBUS_KEY_U,  0x1EEA, 
IBUS_KEY_grave, IBUS_KEY_plus, IBUS_KEY_o,  0x1EDD, 
IBUS_KEY_grave, IBUS_KEY_plus, IBUS_KEY_u,  0x1EEB, 
IBUS_KEY_grave, IBUS_KEY_asciicircum, IBUS_KEY_A,  0x1EA6, 
IBUS_KEY_grave, IBUS_KEY_asciicircum, IBUS_KEY_E,  0x1EC0, 
IBUS_KEY_grave, IBUS_KEY_asciicircum, IBUS_KEY_O,  0x1ED2, 
IBUS_KEY_grave, IBUS_KEY_asciicircum, IBUS_KEY_a,  0x1EA7, 
IBUS_KEY_grave, IBUS_KEY_asciicircum, IBUS_KEY_e,  0x1EC1, 
IBUS_KEY_grave, IBUS_KEY_asciicircum, IBUS_KEY_o,  0x1ED3, 
IBUS_KEY_grave, IBUS_KEY_underscore, IBUS_KEY_E,  0x1E14, 
IBUS_KEY_grave, IBUS_KEY_underscore, IBUS_KEY_O,  0x1E50, 
IBUS_KEY_grave, IBUS_KEY_underscore, IBUS_KEY_e,  0x1E15, 
IBUS_KEY_grave, IBUS_KEY_underscore, IBUS_KEY_o,  0x1E51, 
IBUS_KEY_grave, IBUS_KEY_b, IBUS_KEY_A,  0x1EB0, 
IBUS_KEY_grave, IBUS_KEY_b, IBUS_KEY_a,  0x1EB1, 
IBUS_KEY_grave, IBUS_KEY_macron, IBUS_KEY_E,  0x1E14, 
IBUS_KEY_grave, IBUS_KEY_macron, IBUS_KEY_O,  0x1E50, 
IBUS_KEY_grave, IBUS_KEY_macron, IBUS_KEY_e,  0x1E15, 
IBUS_KEY_grave, IBUS_KEY_macron, IBUS_KEY_o,  0x1E51, 
IBUS_KEY_grave, IBUS_KEY_dead_circumflex, IBUS_KEY_A,  0x1EA6, 
IBUS_KEY_grave, IBUS_KEY_dead_circumflex, IBUS_KEY_E,  0x1EC0, 
IBUS_KEY_grave, IBUS_KEY_dead_circumflex, IBUS_KEY_O,  0x1ED2, 
IBUS_KEY_grave, IBUS_KEY_dead_circumflex, IBUS_KEY_a,  0x1EA7, 
IBUS_KEY_grave, IBUS_KEY_dead_circumflex, IBUS_KEY_e,  0x1EC1, 
IBUS_KEY_grave, IBUS_KEY_dead_circumflex, IBUS_KEY_o,  0x1ED3, 
IBUS_KEY_grave, IBUS_KEY_dead_macron, IBUS_KEY_E,  0x1E14, 
IBUS_KEY_grave, IBUS_KEY_dead_macron, IBUS_KEY_O,  0x1E50, 
IBUS_KEY_grave, IBUS_KEY_dead_macron, IBUS_KEY_e,  0x1E15, 
IBUS_KEY_grave, IBUS_KEY_dead_macron, IBUS_KEY_o,  0x1E51, 
IBUS_KEY_grave, IBUS_KEY_dead_breve, IBUS_KEY_A,  0x1EB0, 
IBUS_KEY_grave, IBUS_KEY_dead_breve, IBUS_KEY_a,  0x1EB1, 
IBUS_KEY_grave, IBUS_KEY_dead_diaeresis, IBUS_KEY_U,  0x01DB, 
IBUS_KEY_grave, IBUS_KEY_dead_diaeresis, IBUS_KEY_u,  0x01DC, 
IBUS_KEY_grave, IBUS_KEY_dead_diaeresis, IBUS_KEY_Greek_iota,  0x1FD2, 
IBUS_KEY_grave, IBUS_KEY_dead_diaeresis, IBUS_KEY_Greek_upsilon,  0x1FE2, 
IBUS_KEY_grave, IBUS_KEY_dead_horn, IBUS_KEY_O,  0x1EDC, 
IBUS_KEY_grave, IBUS_KEY_dead_horn, IBUS_KEY_U,  0x1EEA, 
IBUS_KEY_grave, IBUS_KEY_dead_horn, IBUS_KEY_o,  0x1EDD, 
IBUS_KEY_grave, IBUS_KEY_dead_horn, IBUS_KEY_u,  0x1EEB, 
IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ALPHA,  0x1F0A, 
IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_EPSILON,  0x1F1A, 
IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ETA,  0x1F2A, 
IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_IOTA,  0x1F3A, 
IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMICRON,  0x1F4A, 
IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMEGA,  0x1F6A, 
IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_alpha,  0x1F02, 
IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_epsilon,  0x1F12, 
IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_eta,  0x1F22, 
IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_iota,  0x1F32, 
IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_omicron,  0x1F42, 
IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_upsilon,  0x1F52, 
IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_omega,  0x1F62, 
IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ALPHA,  0x1F0B, 
IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_EPSILON,  0x1F1B, 
IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ETA,  0x1F2B, 
IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_IOTA,  0x1F3B, 
IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMICRON,  0x1F4B, 
IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_UPSILON,  0x1F5B, 
IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMEGA,  0x1F6B, 
IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_alpha,  0x1F03, 
IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_epsilon,  0x1F13, 
IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_eta,  0x1F23, 
IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_iota,  0x1F33, 
IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omicron,  0x1F43, 
IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_upsilon,  0x1F53, 
IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omega,  0x1F63, 
IBUS_KEY_b, IBUS_KEY_exclam, IBUS_KEY_A,  0x1EB6, 
IBUS_KEY_b, IBUS_KEY_exclam, IBUS_KEY_a,  0x1EB7, 
IBUS_KEY_b, IBUS_KEY_comma, IBUS_KEY_E,  0x1E1C, 
IBUS_KEY_b, IBUS_KEY_comma, IBUS_KEY_e,  0x1E1D, 
IBUS_KEY_b, IBUS_KEY_cedilla, IBUS_KEY_E,  0x1E1C, 
IBUS_KEY_b, IBUS_KEY_cedilla, IBUS_KEY_e,  0x1E1D, 
IBUS_KEY_b, IBUS_KEY_dead_cedilla, IBUS_KEY_E,  0x1E1C, 
IBUS_KEY_b, IBUS_KEY_dead_cedilla, IBUS_KEY_e,  0x1E1D, 
IBUS_KEY_b, IBUS_KEY_dead_belowdot, IBUS_KEY_A,  0x1EB6, 
IBUS_KEY_b, IBUS_KEY_dead_belowdot, IBUS_KEY_a,  0x1EB7, 
IBUS_KEY_c, IBUS_KEY_quotedbl, IBUS_KEY_U,  0x01D9, 
IBUS_KEY_c, IBUS_KEY_quotedbl, IBUS_KEY_u,  0x01DA, 
IBUS_KEY_c, IBUS_KEY_dead_diaeresis, IBUS_KEY_U,  0x01D9, 
IBUS_KEY_c, IBUS_KEY_dead_diaeresis, IBUS_KEY_u,  0x01DA, 
IBUS_KEY_asciitilde, IBUS_KEY_quotedbl, IBUS_KEY_Greek_iota,  0x1FD7, 
IBUS_KEY_asciitilde, IBUS_KEY_quotedbl, IBUS_KEY_Greek_upsilon,  0x1FE7, 
IBUS_KEY_asciitilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F0F, 
IBUS_KEY_asciitilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F2F, 
IBUS_KEY_asciitilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_IOTA,  0x1F3F, 
IBUS_KEY_asciitilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_UPSILON,  0x1F5F, 
IBUS_KEY_asciitilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1F6F, 
IBUS_KEY_asciitilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F07, 
IBUS_KEY_asciitilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F27, 
IBUS_KEY_asciitilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_iota,  0x1F37, 
IBUS_KEY_asciitilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_upsilon,  0x1F57, 
IBUS_KEY_asciitilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1F67, 
IBUS_KEY_asciitilde, IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F0E, 
IBUS_KEY_asciitilde, IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F2E, 
IBUS_KEY_asciitilde, IBUS_KEY_parenright, IBUS_KEY_Greek_IOTA,  0x1F3E, 
IBUS_KEY_asciitilde, IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1F6E, 
IBUS_KEY_asciitilde, IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F06, 
IBUS_KEY_asciitilde, IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F26, 
IBUS_KEY_asciitilde, IBUS_KEY_parenright, IBUS_KEY_Greek_iota,  0x1F36, 
IBUS_KEY_asciitilde, IBUS_KEY_parenright, IBUS_KEY_Greek_upsilon,  0x1F56, 
IBUS_KEY_asciitilde, IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1F66, 
IBUS_KEY_asciitilde, IBUS_KEY_plus, IBUS_KEY_O,  0x1EE0, 
IBUS_KEY_asciitilde, IBUS_KEY_plus, IBUS_KEY_U,  0x1EEE, 
IBUS_KEY_asciitilde, IBUS_KEY_plus, IBUS_KEY_o,  0x1EE1, 
IBUS_KEY_asciitilde, IBUS_KEY_plus, IBUS_KEY_u,  0x1EEF, 
IBUS_KEY_asciitilde, IBUS_KEY_asciicircum, IBUS_KEY_A,  0x1EAA, 
IBUS_KEY_asciitilde, IBUS_KEY_asciicircum, IBUS_KEY_E,  0x1EC4, 
IBUS_KEY_asciitilde, IBUS_KEY_asciicircum, IBUS_KEY_O,  0x1ED6, 
IBUS_KEY_asciitilde, IBUS_KEY_asciicircum, IBUS_KEY_a,  0x1EAB, 
IBUS_KEY_asciitilde, IBUS_KEY_asciicircum, IBUS_KEY_e,  0x1EC5, 
IBUS_KEY_asciitilde, IBUS_KEY_asciicircum, IBUS_KEY_o,  0x1ED7, 
IBUS_KEY_asciitilde, IBUS_KEY_b, IBUS_KEY_A,  0x1EB4, 
IBUS_KEY_asciitilde, IBUS_KEY_b, IBUS_KEY_a,  0x1EB5, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_circumflex, IBUS_KEY_A,  0x1EAA, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_circumflex, IBUS_KEY_E,  0x1EC4, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_circumflex, IBUS_KEY_O,  0x1ED6, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_circumflex, IBUS_KEY_a,  0x1EAB, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_circumflex, IBUS_KEY_e,  0x1EC5, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_circumflex, IBUS_KEY_o,  0x1ED7, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_breve, IBUS_KEY_A,  0x1EB4, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_breve, IBUS_KEY_a,  0x1EB5, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_diaeresis, IBUS_KEY_Greek_iota,  0x1FD7, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_diaeresis, IBUS_KEY_Greek_upsilon,  0x1FE7, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_horn, IBUS_KEY_O,  0x1EE0, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_horn, IBUS_KEY_U,  0x1EEE, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_horn, IBUS_KEY_o,  0x1EE1, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_horn, IBUS_KEY_u,  0x1EEF, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ALPHA,  0x1F0E, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ETA,  0x1F2E, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_IOTA,  0x1F3E, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMEGA,  0x1F6E, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_alpha,  0x1F06, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_eta,  0x1F26, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_iota,  0x1F36, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_upsilon,  0x1F56, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_omega,  0x1F66, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ALPHA,  0x1F0F, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ETA,  0x1F2F, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_IOTA,  0x1F3F, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_UPSILON,  0x1F5F, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMEGA,  0x1F6F, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_alpha,  0x1F07, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_eta,  0x1F27, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_iota,  0x1F37, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_upsilon,  0x1F57, 
IBUS_KEY_asciitilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omega,  0x1F67, 
IBUS_KEY_macron, IBUS_KEY_exclam, IBUS_KEY_L,  0x1E38, 
IBUS_KEY_macron, IBUS_KEY_exclam, IBUS_KEY_R,  0x1E5C, 
IBUS_KEY_macron, IBUS_KEY_exclam, IBUS_KEY_l,  0x1E39, 
IBUS_KEY_macron, IBUS_KEY_exclam, IBUS_KEY_r,  0x1E5D, 
IBUS_KEY_macron, IBUS_KEY_quotedbl, IBUS_KEY_A,  0x01DE, 
IBUS_KEY_macron, IBUS_KEY_quotedbl, IBUS_KEY_O,  0x022A, 
IBUS_KEY_macron, IBUS_KEY_quotedbl, IBUS_KEY_U,  0x01D5, 
IBUS_KEY_macron, IBUS_KEY_quotedbl, IBUS_KEY_a,  0x01DF, 
IBUS_KEY_macron, IBUS_KEY_quotedbl, IBUS_KEY_o,  0x022B, 
IBUS_KEY_macron, IBUS_KEY_quotedbl, IBUS_KEY_u,  0x01D6, 
IBUS_KEY_macron, IBUS_KEY_period, IBUS_KEY_A,  0x01E0, 
IBUS_KEY_macron, IBUS_KEY_period, IBUS_KEY_O,  0x0230, 
IBUS_KEY_macron, IBUS_KEY_period, IBUS_KEY_a,  0x01E1, 
IBUS_KEY_macron, IBUS_KEY_period, IBUS_KEY_o,  0x0231, 
IBUS_KEY_macron, IBUS_KEY_semicolon, IBUS_KEY_O,  0x01EC, 
IBUS_KEY_macron, IBUS_KEY_semicolon, IBUS_KEY_o,  0x01ED, 
IBUS_KEY_macron, IBUS_KEY_asciitilde, IBUS_KEY_O,  0x022C, 
IBUS_KEY_macron, IBUS_KEY_asciitilde, IBUS_KEY_o,  0x022D, 
IBUS_KEY_macron, IBUS_KEY_dead_tilde, IBUS_KEY_O,  0x022C, 
IBUS_KEY_macron, IBUS_KEY_dead_tilde, IBUS_KEY_o,  0x022D, 
IBUS_KEY_macron, IBUS_KEY_dead_abovedot, IBUS_KEY_A,  0x01E0, 
IBUS_KEY_macron, IBUS_KEY_dead_abovedot, IBUS_KEY_O,  0x0230, 
IBUS_KEY_macron, IBUS_KEY_dead_abovedot, IBUS_KEY_a,  0x01E1, 
IBUS_KEY_macron, IBUS_KEY_dead_abovedot, IBUS_KEY_o,  0x0231, 
IBUS_KEY_macron, IBUS_KEY_dead_diaeresis, IBUS_KEY_A,  0x01DE, 
IBUS_KEY_macron, IBUS_KEY_dead_diaeresis, IBUS_KEY_O,  0x022A, 
IBUS_KEY_macron, IBUS_KEY_dead_diaeresis, IBUS_KEY_U,  0x01D5, 
IBUS_KEY_macron, IBUS_KEY_dead_diaeresis, IBUS_KEY_a,  0x01DF, 
IBUS_KEY_macron, IBUS_KEY_dead_diaeresis, IBUS_KEY_o,  0x022B, 
IBUS_KEY_macron, IBUS_KEY_dead_diaeresis, IBUS_KEY_u,  0x01D6, 
IBUS_KEY_macron, IBUS_KEY_dead_ogonek, IBUS_KEY_O,  0x01EC, 
IBUS_KEY_macron, IBUS_KEY_dead_ogonek, IBUS_KEY_o,  0x01ED, 
IBUS_KEY_macron, IBUS_KEY_dead_belowdot, IBUS_KEY_L,  0x1E38, 
IBUS_KEY_macron, IBUS_KEY_dead_belowdot, IBUS_KEY_R,  0x1E5C, 
IBUS_KEY_macron, IBUS_KEY_dead_belowdot, IBUS_KEY_l,  0x1E39, 
IBUS_KEY_macron, IBUS_KEY_dead_belowdot, IBUS_KEY_r,  0x1E5D, 
IBUS_KEY_acute, IBUS_KEY_quotedbl, IBUS_KEY_I,  0x1E2E, 
IBUS_KEY_acute, IBUS_KEY_quotedbl, IBUS_KEY_U,  0x01D7, 
IBUS_KEY_acute, IBUS_KEY_quotedbl, IBUS_KEY_i,  0x1E2F, 
IBUS_KEY_acute, IBUS_KEY_quotedbl, IBUS_KEY_u,  0x01D8, 
IBUS_KEY_acute, IBUS_KEY_quotedbl, IBUS_KEY_Greek_iota,  0x0390, 
IBUS_KEY_acute, IBUS_KEY_quotedbl, IBUS_KEY_Greek_upsilon,  0x03B0, 
IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F0D, 
IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_EPSILON,  0x1F1D, 
IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F2D, 
IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_IOTA,  0x1F3D, 
IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMICRON,  0x1F4D, 
IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_UPSILON,  0x1F5D, 
IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1F6D, 
IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F05, 
IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_epsilon,  0x1F15, 
IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F25, 
IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_iota,  0x1F35, 
IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_omicron,  0x1F45, 
IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_upsilon,  0x1F55, 
IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1F65, 
IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F0C, 
IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_EPSILON,  0x1F1C, 
IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F2C, 
IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_IOTA,  0x1F3C, 
IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_OMICRON,  0x1F4C, 
IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1F6C, 
IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F04, 
IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_epsilon,  0x1F14, 
IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F24, 
IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_iota,  0x1F34, 
IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_omicron,  0x1F44, 
IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_upsilon,  0x1F54, 
IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1F64, 
IBUS_KEY_acute, IBUS_KEY_plus, IBUS_KEY_O,  0x1EDA, 
IBUS_KEY_acute, IBUS_KEY_plus, IBUS_KEY_U,  0x1EE8, 
IBUS_KEY_acute, IBUS_KEY_plus, IBUS_KEY_o,  0x1EDB, 
IBUS_KEY_acute, IBUS_KEY_plus, IBUS_KEY_u,  0x1EE9, 
IBUS_KEY_acute, IBUS_KEY_comma, IBUS_KEY_C,  0x1E08, 
IBUS_KEY_acute, IBUS_KEY_comma, IBUS_KEY_c,  0x1E09, 
IBUS_KEY_acute, IBUS_KEY_slash, IBUS_KEY_O,  0x01FE, 
IBUS_KEY_acute, IBUS_KEY_slash, IBUS_KEY_o,  0x01FF, 
IBUS_KEY_acute, IBUS_KEY_asciicircum, IBUS_KEY_A,  0x1EA4, 
IBUS_KEY_acute, IBUS_KEY_asciicircum, IBUS_KEY_E,  0x1EBE, 
IBUS_KEY_acute, IBUS_KEY_asciicircum, IBUS_KEY_O,  0x1ED0, 
IBUS_KEY_acute, IBUS_KEY_asciicircum, IBUS_KEY_a,  0x1EA5, 
IBUS_KEY_acute, IBUS_KEY_asciicircum, IBUS_KEY_e,  0x1EBF, 
IBUS_KEY_acute, IBUS_KEY_asciicircum, IBUS_KEY_o,  0x1ED1, 
IBUS_KEY_acute, IBUS_KEY_underscore, IBUS_KEY_E,  0x1E16, 
IBUS_KEY_acute, IBUS_KEY_underscore, IBUS_KEY_O,  0x1E52, 
IBUS_KEY_acute, IBUS_KEY_underscore, IBUS_KEY_e,  0x1E17, 
IBUS_KEY_acute, IBUS_KEY_underscore, IBUS_KEY_o,  0x1E53, 
IBUS_KEY_acute, IBUS_KEY_b, IBUS_KEY_A,  0x1EAE, 
IBUS_KEY_acute, IBUS_KEY_b, IBUS_KEY_a,  0x1EAF, 
IBUS_KEY_acute, IBUS_KEY_asciitilde, IBUS_KEY_O,  0x1E4C, 
IBUS_KEY_acute, IBUS_KEY_asciitilde, IBUS_KEY_U,  0x1E78, 
IBUS_KEY_acute, IBUS_KEY_asciitilde, IBUS_KEY_o,  0x1E4D, 
IBUS_KEY_acute, IBUS_KEY_asciitilde, IBUS_KEY_u,  0x1E79, 
IBUS_KEY_acute, IBUS_KEY_macron, IBUS_KEY_E,  0x1E16, 
IBUS_KEY_acute, IBUS_KEY_macron, IBUS_KEY_O,  0x1E52, 
IBUS_KEY_acute, IBUS_KEY_macron, IBUS_KEY_e,  0x1E17, 
IBUS_KEY_acute, IBUS_KEY_macron, IBUS_KEY_o,  0x1E53, 
IBUS_KEY_acute, IBUS_KEY_cedilla, IBUS_KEY_C,  0x1E08, 
IBUS_KEY_acute, IBUS_KEY_cedilla, IBUS_KEY_c,  0x1E09, 
IBUS_KEY_acute, IBUS_KEY_dead_circumflex, IBUS_KEY_A,  0x1EA4, 
IBUS_KEY_acute, IBUS_KEY_dead_circumflex, IBUS_KEY_E,  0x1EBE, 
IBUS_KEY_acute, IBUS_KEY_dead_circumflex, IBUS_KEY_O,  0x1ED0, 
IBUS_KEY_acute, IBUS_KEY_dead_circumflex, IBUS_KEY_a,  0x1EA5, 
IBUS_KEY_acute, IBUS_KEY_dead_circumflex, IBUS_KEY_e,  0x1EBF, 
IBUS_KEY_acute, IBUS_KEY_dead_circumflex, IBUS_KEY_o,  0x1ED1, 
IBUS_KEY_acute, IBUS_KEY_dead_tilde, IBUS_KEY_O,  0x1E4C, 
IBUS_KEY_acute, IBUS_KEY_dead_tilde, IBUS_KEY_U,  0x1E78, 
IBUS_KEY_acute, IBUS_KEY_dead_tilde, IBUS_KEY_o,  0x1E4D, 
IBUS_KEY_acute, IBUS_KEY_dead_tilde, IBUS_KEY_u,  0x1E79, 
IBUS_KEY_acute, IBUS_KEY_dead_macron, IBUS_KEY_E,  0x1E16, 
IBUS_KEY_acute, IBUS_KEY_dead_macron, IBUS_KEY_O,  0x1E52, 
IBUS_KEY_acute, IBUS_KEY_dead_macron, IBUS_KEY_e,  0x1E17, 
IBUS_KEY_acute, IBUS_KEY_dead_macron, IBUS_KEY_o,  0x1E53, 
IBUS_KEY_acute, IBUS_KEY_dead_breve, IBUS_KEY_A,  0x1EAE, 
IBUS_KEY_acute, IBUS_KEY_dead_breve, IBUS_KEY_a,  0x1EAF, 
IBUS_KEY_acute, IBUS_KEY_dead_diaeresis, IBUS_KEY_I,  0x1E2E, 
IBUS_KEY_acute, IBUS_KEY_dead_diaeresis, IBUS_KEY_U,  0x01D7, 
IBUS_KEY_acute, IBUS_KEY_dead_diaeresis, IBUS_KEY_i,  0x1E2F, 
IBUS_KEY_acute, IBUS_KEY_dead_diaeresis, IBUS_KEY_u,  0x01D8, 
IBUS_KEY_acute, IBUS_KEY_dead_diaeresis, IBUS_KEY_Greek_iota,  0x0390, 
IBUS_KEY_acute, IBUS_KEY_dead_diaeresis, IBUS_KEY_Greek_upsilon,  0x03B0, 
IBUS_KEY_acute, IBUS_KEY_dead_abovering, IBUS_KEY_A,  0x01FA, 
IBUS_KEY_acute, IBUS_KEY_dead_abovering, IBUS_KEY_a,  0x01FB, 
IBUS_KEY_acute, IBUS_KEY_dead_cedilla, IBUS_KEY_C,  0x1E08, 
IBUS_KEY_acute, IBUS_KEY_dead_cedilla, IBUS_KEY_c,  0x1E09, 
IBUS_KEY_acute, IBUS_KEY_dead_horn, IBUS_KEY_O,  0x1EDA, 
IBUS_KEY_acute, IBUS_KEY_dead_horn, IBUS_KEY_U,  0x1EE8, 
IBUS_KEY_acute, IBUS_KEY_dead_horn, IBUS_KEY_o,  0x1EDB, 
IBUS_KEY_acute, IBUS_KEY_dead_horn, IBUS_KEY_u,  0x1EE9, 
IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ALPHA,  0x1F0C, 
IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_EPSILON,  0x1F1C, 
IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ETA,  0x1F2C, 
IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_IOTA,  0x1F3C, 
IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMICRON,  0x1F4C, 
IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMEGA,  0x1F6C, 
IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_alpha,  0x1F04, 
IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_epsilon,  0x1F14, 
IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_eta,  0x1F24, 
IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_iota,  0x1F34, 
IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_omicron,  0x1F44, 
IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_upsilon,  0x1F54, 
IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_omega,  0x1F64, 
IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ALPHA,  0x1F0D, 
IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_EPSILON,  0x1F1D, 
IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ETA,  0x1F2D, 
IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_IOTA,  0x1F3D, 
IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMICRON,  0x1F4D, 
IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_UPSILON,  0x1F5D, 
IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMEGA,  0x1F6D, 
IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_alpha,  0x1F05, 
IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_epsilon,  0x1F15, 
IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_eta,  0x1F25, 
IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_iota,  0x1F35, 
IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omicron,  0x1F45, 
IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_upsilon,  0x1F55, 
IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omega,  0x1F65, 
IBUS_KEY_acute, IBUS_KEY_KP_Divide, IBUS_KEY_O,  0x01FE, 
IBUS_KEY_acute, IBUS_KEY_KP_Divide, IBUS_KEY_o,  0x01FF, 
0x05C1, 0x05BC, IBUS_KEY_hebrew_shin,  0xFB2C, 
0x05C2, 0x05BC, IBUS_KEY_hebrew_shin,  0xFB2D, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_Greek_alpha,  0x1FB4, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_Greek_eta,  0x1FC4, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_Greek_omega,  0x1FF4, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, 0x1F00,  0x1F84, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, 0x1F01,  0x1F85, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, 0x1F08,  0x1F8C, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, 0x1F09,  0x1F8D, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, 0x1F20,  0x1F94, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, 0x1F21,  0x1F95, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, 0x1F28,  0x1F9C, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, 0x1F29,  0x1F9D, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, 0x1F60,  0x1FA4, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, 0x1F61,  0x1FA5, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, 0x1F68,  0x1FAC, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, 0x1F69,  0x1FAD, 
IBUS_KEY_Greek_iota, IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F89, 
IBUS_KEY_Greek_iota, IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F99, 
IBUS_KEY_Greek_iota, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1FA9, 
IBUS_KEY_Greek_iota, IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F81, 
IBUS_KEY_Greek_iota, IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F91, 
IBUS_KEY_Greek_iota, IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1FA1, 
IBUS_KEY_Greek_iota, IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F88, 
IBUS_KEY_Greek_iota, IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F98, 
IBUS_KEY_Greek_iota, IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1FA8, 
IBUS_KEY_Greek_iota, IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F80, 
IBUS_KEY_Greek_iota, IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F90, 
IBUS_KEY_Greek_iota, IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1FA0, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_Greek_alpha,  0x1FB2, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_Greek_eta,  0x1FC2, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_Greek_omega,  0x1FF2, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, 0x1F00,  0x1F82, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, 0x1F01,  0x1F83, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, 0x1F08,  0x1F8A, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, 0x1F09,  0x1F8B, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, 0x1F20,  0x1F92, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, 0x1F21,  0x1F93, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, 0x1F28,  0x1F9A, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, 0x1F29,  0x1F9B, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, 0x1F60,  0x1FA2, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, 0x1F61,  0x1FA3, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, 0x1F68,  0x1FAA, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, 0x1F69,  0x1FAB, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_Greek_alpha,  0x1FB7, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_Greek_eta,  0x1FC7, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_Greek_omega,  0x1FF7, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, 0x1F00,  0x1F86, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, 0x1F01,  0x1F87, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, 0x1F08,  0x1F8E, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, 0x1F09,  0x1F8F, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, 0x1F20,  0x1F96, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, 0x1F21,  0x1F97, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, 0x1F28,  0x1F9E, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, 0x1F29,  0x1F9F, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, 0x1F60,  0x1FA6, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, 0x1F61,  0x1FA7, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, 0x1F68,  0x1FAE, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, 0x1F69,  0x1FAF, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_Greek_alpha,  0x1FB4, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_Greek_eta,  0x1FC4, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_Greek_omega,  0x1FF4, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, 0x1F00,  0x1F84, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, 0x1F01,  0x1F85, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, 0x1F08,  0x1F8C, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, 0x1F09,  0x1F8D, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, 0x1F20,  0x1F94, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, 0x1F21,  0x1F95, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, 0x1F28,  0x1F9C, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, 0x1F29,  0x1F9D, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, 0x1F60,  0x1FA4, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, 0x1F61,  0x1FA5, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, 0x1F68,  0x1FAC, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, 0x1F69,  0x1FAD, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_alpha,  0x1FB2, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_eta,  0x1FC2, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_omega,  0x1FF2, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, 0x1F00,  0x1F82, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, 0x1F01,  0x1F83, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, 0x1F08,  0x1F8A, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, 0x1F09,  0x1F8B, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, 0x1F20,  0x1F92, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, 0x1F21,  0x1F93, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, 0x1F28,  0x1F9A, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, 0x1F29,  0x1F9B, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, 0x1F60,  0x1FA2, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, 0x1F61,  0x1FA3, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, 0x1F68,  0x1FAA, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, 0x1F69,  0x1FAB, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_alpha,  0x1FB4, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_eta,  0x1FC4, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_omega,  0x1FF4, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, 0x1F00,  0x1F84, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, 0x1F01,  0x1F85, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, 0x1F08,  0x1F8C, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, 0x1F09,  0x1F8D, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, 0x1F20,  0x1F94, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, 0x1F21,  0x1F95, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, 0x1F28,  0x1F9C, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, 0x1F29,  0x1F9D, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, 0x1F60,  0x1FA4, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, 0x1F61,  0x1FA5, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, 0x1F68,  0x1FAC, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, 0x1F69,  0x1FAD, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_alpha,  0x1FB7, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_eta,  0x1FC7, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_omega,  0x1FF7, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, 0x1F00,  0x1F86, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, 0x1F01,  0x1F87, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, 0x1F08,  0x1F8E, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, 0x1F09,  0x1F8F, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, 0x1F20,  0x1F96, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, 0x1F21,  0x1F97, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, 0x1F28,  0x1F9E, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, 0x1F29,  0x1F9F, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, 0x1F60,  0x1FA6, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, 0x1F61,  0x1FA7, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, 0x1F68,  0x1FAE, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, 0x1F69,  0x1FAF, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ALPHA,  0x1F88, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ETA,  0x1F98, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMEGA,  0x1FA8, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_psili, IBUS_KEY_Greek_alpha,  0x1F80, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_psili, IBUS_KEY_Greek_eta,  0x1F90, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_psili, IBUS_KEY_Greek_omega,  0x1FA0, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ALPHA,  0x1F89, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ETA,  0x1F99, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMEGA,  0x1FA9, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_alpha,  0x1F81, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_eta,  0x1F91, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omega,  0x1FA1, 
IBUS_KEY_dead_abovedot, IBUS_KEY_f, IBUS_KEY_s,  0x1E9B, 
IBUS_KEY_parenleft, IBUS_KEY_1, IBUS_KEY_0, IBUS_KEY_parenright,  0x2469, 
IBUS_KEY_parenleft, IBUS_KEY_1, IBUS_KEY_1, IBUS_KEY_parenright,  0x246A, 
IBUS_KEY_parenleft, IBUS_KEY_1, IBUS_KEY_2, IBUS_KEY_parenright,  0x246B, 
IBUS_KEY_parenleft, IBUS_KEY_1, IBUS_KEY_3, IBUS_KEY_parenright,  0x246C, 
IBUS_KEY_parenleft, IBUS_KEY_1, IBUS_KEY_4, IBUS_KEY_parenright,  0x246D, 
IBUS_KEY_parenleft, IBUS_KEY_1, IBUS_KEY_5, IBUS_KEY_parenright,  0x246E, 
IBUS_KEY_parenleft, IBUS_KEY_1, IBUS_KEY_6, IBUS_KEY_parenright,  0x246F, 
IBUS_KEY_parenleft, IBUS_KEY_1, IBUS_KEY_7, IBUS_KEY_parenright,  0x2470, 
IBUS_KEY_parenleft, IBUS_KEY_1, IBUS_KEY_8, IBUS_KEY_parenright,  0x2471, 
IBUS_KEY_parenleft, IBUS_KEY_1, IBUS_KEY_9, IBUS_KEY_parenright,  0x2472, 
IBUS_KEY_parenleft, IBUS_KEY_1, IBUS_KEY_KP_Space, IBUS_KEY_parenright,  0x246B, 
IBUS_KEY_parenleft, IBUS_KEY_1, IBUS_KEY_KP_0, IBUS_KEY_parenright,  0x2469, 
IBUS_KEY_parenleft, IBUS_KEY_1, IBUS_KEY_KP_1, IBUS_KEY_parenright,  0x246A, 
IBUS_KEY_parenleft, IBUS_KEY_1, IBUS_KEY_KP_2, IBUS_KEY_parenright,  0x246B, 
IBUS_KEY_parenleft, IBUS_KEY_1, IBUS_KEY_KP_3, IBUS_KEY_parenright,  0x246C, 
IBUS_KEY_parenleft, IBUS_KEY_1, IBUS_KEY_KP_4, IBUS_KEY_parenright,  0x246D, 
IBUS_KEY_parenleft, IBUS_KEY_1, IBUS_KEY_KP_5, IBUS_KEY_parenright,  0x246E, 
IBUS_KEY_parenleft, IBUS_KEY_1, IBUS_KEY_KP_6, IBUS_KEY_parenright,  0x246F, 
IBUS_KEY_parenleft, IBUS_KEY_1, IBUS_KEY_KP_7, IBUS_KEY_parenright,  0x2470, 
IBUS_KEY_parenleft, IBUS_KEY_1, IBUS_KEY_KP_8, IBUS_KEY_parenright,  0x2471, 
IBUS_KEY_parenleft, IBUS_KEY_1, IBUS_KEY_KP_9, IBUS_KEY_parenright,  0x2472, 
IBUS_KEY_parenleft, IBUS_KEY_2, IBUS_KEY_0, IBUS_KEY_parenright,  0x2473, 
IBUS_KEY_parenleft, IBUS_KEY_2, IBUS_KEY_1, IBUS_KEY_parenright,  0x3251, 
IBUS_KEY_parenleft, IBUS_KEY_2, IBUS_KEY_2, IBUS_KEY_parenright,  0x3252, 
IBUS_KEY_parenleft, IBUS_KEY_2, IBUS_KEY_3, IBUS_KEY_parenright,  0x3253, 
IBUS_KEY_parenleft, IBUS_KEY_2, IBUS_KEY_4, IBUS_KEY_parenright,  0x3254, 
IBUS_KEY_parenleft, IBUS_KEY_2, IBUS_KEY_5, IBUS_KEY_parenright,  0x3255, 
IBUS_KEY_parenleft, IBUS_KEY_2, IBUS_KEY_6, IBUS_KEY_parenright,  0x3256, 
IBUS_KEY_parenleft, IBUS_KEY_2, IBUS_KEY_7, IBUS_KEY_parenright,  0x3257, 
IBUS_KEY_parenleft, IBUS_KEY_2, IBUS_KEY_8, IBUS_KEY_parenright,  0x3258, 
IBUS_KEY_parenleft, IBUS_KEY_2, IBUS_KEY_9, IBUS_KEY_parenright,  0x3259, 
IBUS_KEY_parenleft, IBUS_KEY_2, IBUS_KEY_KP_Space, IBUS_KEY_parenright,  0x3252, 
IBUS_KEY_parenleft, IBUS_KEY_2, IBUS_KEY_KP_0, IBUS_KEY_parenright,  0x2473, 
IBUS_KEY_parenleft, IBUS_KEY_2, IBUS_KEY_KP_1, IBUS_KEY_parenright,  0x3251, 
IBUS_KEY_parenleft, IBUS_KEY_2, IBUS_KEY_KP_2, IBUS_KEY_parenright,  0x3252, 
IBUS_KEY_parenleft, IBUS_KEY_2, IBUS_KEY_KP_3, IBUS_KEY_parenright,  0x3253, 
IBUS_KEY_parenleft, IBUS_KEY_2, IBUS_KEY_KP_4, IBUS_KEY_parenright,  0x3254, 
IBUS_KEY_parenleft, IBUS_KEY_2, IBUS_KEY_KP_5, IBUS_KEY_parenright,  0x3255, 
IBUS_KEY_parenleft, IBUS_KEY_2, IBUS_KEY_KP_6, IBUS_KEY_parenright,  0x3256, 
IBUS_KEY_parenleft, IBUS_KEY_2, IBUS_KEY_KP_7, IBUS_KEY_parenright,  0x3257, 
IBUS_KEY_parenleft, IBUS_KEY_2, IBUS_KEY_KP_8, IBUS_KEY_parenright,  0x3258, 
IBUS_KEY_parenleft, IBUS_KEY_2, IBUS_KEY_KP_9, IBUS_KEY_parenright,  0x3259, 
IBUS_KEY_parenleft, IBUS_KEY_3, IBUS_KEY_0, IBUS_KEY_parenright,  0x325A, 
IBUS_KEY_parenleft, IBUS_KEY_3, IBUS_KEY_1, IBUS_KEY_parenright,  0x325B, 
IBUS_KEY_parenleft, IBUS_KEY_3, IBUS_KEY_2, IBUS_KEY_parenright,  0x325C, 
IBUS_KEY_parenleft, IBUS_KEY_3, IBUS_KEY_3, IBUS_KEY_parenright,  0x325D, 
IBUS_KEY_parenleft, IBUS_KEY_3, IBUS_KEY_4, IBUS_KEY_parenright,  0x325E, 
IBUS_KEY_parenleft, IBUS_KEY_3, IBUS_KEY_5, IBUS_KEY_parenright,  0x325F, 
IBUS_KEY_parenleft, IBUS_KEY_3, IBUS_KEY_6, IBUS_KEY_parenright,  0x32B1, 
IBUS_KEY_parenleft, IBUS_KEY_3, IBUS_KEY_7, IBUS_KEY_parenright,  0x32B2, 
IBUS_KEY_parenleft, IBUS_KEY_3, IBUS_KEY_8, IBUS_KEY_parenright,  0x32B3, 
IBUS_KEY_parenleft, IBUS_KEY_3, IBUS_KEY_9, IBUS_KEY_parenright,  0x32B4, 
IBUS_KEY_parenleft, IBUS_KEY_3, IBUS_KEY_KP_Space, IBUS_KEY_parenright,  0x325C, 
IBUS_KEY_parenleft, IBUS_KEY_3, IBUS_KEY_KP_0, IBUS_KEY_parenright,  0x325A, 
IBUS_KEY_parenleft, IBUS_KEY_3, IBUS_KEY_KP_1, IBUS_KEY_parenright,  0x325B, 
IBUS_KEY_parenleft, IBUS_KEY_3, IBUS_KEY_KP_2, IBUS_KEY_parenright,  0x325C, 
IBUS_KEY_parenleft, IBUS_KEY_3, IBUS_KEY_KP_3, IBUS_KEY_parenright,  0x325D, 
IBUS_KEY_parenleft, IBUS_KEY_3, IBUS_KEY_KP_4, IBUS_KEY_parenright,  0x325E, 
IBUS_KEY_parenleft, IBUS_KEY_3, IBUS_KEY_KP_5, IBUS_KEY_parenright,  0x325F, 
IBUS_KEY_parenleft, IBUS_KEY_3, IBUS_KEY_KP_6, IBUS_KEY_parenright,  0x32B1, 
IBUS_KEY_parenleft, IBUS_KEY_3, IBUS_KEY_KP_7, IBUS_KEY_parenright,  0x32B2, 
IBUS_KEY_parenleft, IBUS_KEY_3, IBUS_KEY_KP_8, IBUS_KEY_parenright,  0x32B3, 
IBUS_KEY_parenleft, IBUS_KEY_3, IBUS_KEY_KP_9, IBUS_KEY_parenright,  0x32B4, 
IBUS_KEY_parenleft, IBUS_KEY_4, IBUS_KEY_0, IBUS_KEY_parenright,  0x32B5, 
IBUS_KEY_parenleft, IBUS_KEY_4, IBUS_KEY_1, IBUS_KEY_parenright,  0x32B6, 
IBUS_KEY_parenleft, IBUS_KEY_4, IBUS_KEY_2, IBUS_KEY_parenright,  0x32B7, 
IBUS_KEY_parenleft, IBUS_KEY_4, IBUS_KEY_3, IBUS_KEY_parenright,  0x32B8, 
IBUS_KEY_parenleft, IBUS_KEY_4, IBUS_KEY_4, IBUS_KEY_parenright,  0x32B9, 
IBUS_KEY_parenleft, IBUS_KEY_4, IBUS_KEY_5, IBUS_KEY_parenright,  0x32BA, 
IBUS_KEY_parenleft, IBUS_KEY_4, IBUS_KEY_6, IBUS_KEY_parenright,  0x32BB, 
IBUS_KEY_parenleft, IBUS_KEY_4, IBUS_KEY_7, IBUS_KEY_parenright,  0x32BC, 
IBUS_KEY_parenleft, IBUS_KEY_4, IBUS_KEY_8, IBUS_KEY_parenright,  0x32BD, 
IBUS_KEY_parenleft, IBUS_KEY_4, IBUS_KEY_9, IBUS_KEY_parenright,  0x32BE, 
IBUS_KEY_parenleft, IBUS_KEY_4, IBUS_KEY_KP_Space, IBUS_KEY_parenright,  0x32B7, 
IBUS_KEY_parenleft, IBUS_KEY_4, IBUS_KEY_KP_0, IBUS_KEY_parenright,  0x32B5, 
IBUS_KEY_parenleft, IBUS_KEY_4, IBUS_KEY_KP_1, IBUS_KEY_parenright,  0x32B6, 
IBUS_KEY_parenleft, IBUS_KEY_4, IBUS_KEY_KP_2, IBUS_KEY_parenright,  0x32B7, 
IBUS_KEY_parenleft, IBUS_KEY_4, IBUS_KEY_KP_3, IBUS_KEY_parenright,  0x32B8, 
IBUS_KEY_parenleft, IBUS_KEY_4, IBUS_KEY_KP_4, IBUS_KEY_parenright,  0x32B9, 
IBUS_KEY_parenleft, IBUS_KEY_4, IBUS_KEY_KP_5, IBUS_KEY_parenright,  0x32BA, 
IBUS_KEY_parenleft, IBUS_KEY_4, IBUS_KEY_KP_6, IBUS_KEY_parenright,  0x32BB, 
IBUS_KEY_parenleft, IBUS_KEY_4, IBUS_KEY_KP_7, IBUS_KEY_parenright,  0x32BC, 
IBUS_KEY_parenleft, IBUS_KEY_4, IBUS_KEY_KP_8, IBUS_KEY_parenright,  0x32BD, 
IBUS_KEY_parenleft, IBUS_KEY_4, IBUS_KEY_KP_9, IBUS_KEY_parenright,  0x32BE, 
IBUS_KEY_parenleft, IBUS_KEY_5, IBUS_KEY_0, IBUS_KEY_parenright,  0x32BF, 
IBUS_KEY_parenleft, 0x1100, 0x1161, IBUS_KEY_parenright,  0x326E, 
IBUS_KEY_parenleft, 0x1102, 0x1161, IBUS_KEY_parenright,  0x326F, 
IBUS_KEY_parenleft, 0x1103, 0x1161, IBUS_KEY_parenright,  0x3270, 
IBUS_KEY_parenleft, 0x1105, 0x1161, IBUS_KEY_parenright,  0x3271, 
IBUS_KEY_parenleft, 0x1106, 0x1161, IBUS_KEY_parenright,  0x3272, 
IBUS_KEY_parenleft, 0x1107, 0x1161, IBUS_KEY_parenright,  0x3273, 
IBUS_KEY_parenleft, 0x1109, 0x1161, IBUS_KEY_parenright,  0x3274, 
IBUS_KEY_parenleft, 0x110B, 0x1161, IBUS_KEY_parenright,  0x3275, 
IBUS_KEY_parenleft, 0x110C, 0x1161, IBUS_KEY_parenright,  0x3276, 
IBUS_KEY_parenleft, 0x110E, 0x1161, IBUS_KEY_parenright,  0x3277, 
IBUS_KEY_parenleft, 0x110F, 0x1161, IBUS_KEY_parenright,  0x3278, 
IBUS_KEY_parenleft, 0x1110, 0x1161, IBUS_KEY_parenright,  0x3279, 
IBUS_KEY_parenleft, 0x1111, 0x1161, IBUS_KEY_parenright,  0x327A, 
IBUS_KEY_parenleft, 0x1112, 0x1161, IBUS_KEY_parenright,  0x327B, 
IBUS_KEY_parenleft, IBUS_KEY_KP_Space, IBUS_KEY_0, IBUS_KEY_parenright,  0x2473, 
IBUS_KEY_parenleft, IBUS_KEY_KP_Space, IBUS_KEY_1, IBUS_KEY_parenright,  0x3251, 
IBUS_KEY_parenleft, IBUS_KEY_KP_Space, IBUS_KEY_2, IBUS_KEY_parenright,  0x3252, 
IBUS_KEY_parenleft, IBUS_KEY_KP_Space, IBUS_KEY_3, IBUS_KEY_parenright,  0x3253, 
IBUS_KEY_parenleft, IBUS_KEY_KP_Space, IBUS_KEY_4, IBUS_KEY_parenright,  0x3254, 
IBUS_KEY_parenleft, IBUS_KEY_KP_Space, IBUS_KEY_5, IBUS_KEY_parenright,  0x3255, 
IBUS_KEY_parenleft, IBUS_KEY_KP_Space, IBUS_KEY_6, IBUS_KEY_parenright,  0x3256, 
IBUS_KEY_parenleft, IBUS_KEY_KP_Space, IBUS_KEY_7, IBUS_KEY_parenright,  0x3257, 
IBUS_KEY_parenleft, IBUS_KEY_KP_Space, IBUS_KEY_8, IBUS_KEY_parenright,  0x3258, 
IBUS_KEY_parenleft, IBUS_KEY_KP_Space, IBUS_KEY_9, IBUS_KEY_parenright,  0x3259, 
IBUS_KEY_parenleft, IBUS_KEY_KP_Space, IBUS_KEY_KP_Space, IBUS_KEY_parenright,  0x3252, 
IBUS_KEY_parenleft, IBUS_KEY_KP_Space, IBUS_KEY_KP_0, IBUS_KEY_parenright,  0x2473, 
IBUS_KEY_parenleft, IBUS_KEY_KP_Space, IBUS_KEY_KP_1, IBUS_KEY_parenright,  0x3251, 
IBUS_KEY_parenleft, IBUS_KEY_KP_Space, IBUS_KEY_KP_2, IBUS_KEY_parenright,  0x3252, 
IBUS_KEY_parenleft, IBUS_KEY_KP_Space, IBUS_KEY_KP_3, IBUS_KEY_parenright,  0x3253, 
IBUS_KEY_parenleft, IBUS_KEY_KP_Space, IBUS_KEY_KP_4, IBUS_KEY_parenright,  0x3254, 
IBUS_KEY_parenleft, IBUS_KEY_KP_Space, IBUS_KEY_KP_5, IBUS_KEY_parenright,  0x3255, 
IBUS_KEY_parenleft, IBUS_KEY_KP_Space, IBUS_KEY_KP_6, IBUS_KEY_parenright,  0x3256, 
IBUS_KEY_parenleft, IBUS_KEY_KP_Space, IBUS_KEY_KP_7, IBUS_KEY_parenright,  0x3257, 
IBUS_KEY_parenleft, IBUS_KEY_KP_Space, IBUS_KEY_KP_8, IBUS_KEY_parenright,  0x3258, 
IBUS_KEY_parenleft, IBUS_KEY_KP_Space, IBUS_KEY_KP_9, IBUS_KEY_parenright,  0x3259, 
IBUS_KEY_parenleft, IBUS_KEY_KP_1, IBUS_KEY_0, IBUS_KEY_parenright,  0x2469, 
IBUS_KEY_parenleft, IBUS_KEY_KP_1, IBUS_KEY_1, IBUS_KEY_parenright,  0x246A, 
IBUS_KEY_parenleft, IBUS_KEY_KP_1, IBUS_KEY_2, IBUS_KEY_parenright,  0x246B, 
IBUS_KEY_parenleft, IBUS_KEY_KP_1, IBUS_KEY_3, IBUS_KEY_parenright,  0x246C, 
IBUS_KEY_parenleft, IBUS_KEY_KP_1, IBUS_KEY_4, IBUS_KEY_parenright,  0x246D, 
IBUS_KEY_parenleft, IBUS_KEY_KP_1, IBUS_KEY_5, IBUS_KEY_parenright,  0x246E, 
IBUS_KEY_parenleft, IBUS_KEY_KP_1, IBUS_KEY_6, IBUS_KEY_parenright,  0x246F, 
IBUS_KEY_parenleft, IBUS_KEY_KP_1, IBUS_KEY_7, IBUS_KEY_parenright,  0x2470, 
IBUS_KEY_parenleft, IBUS_KEY_KP_1, IBUS_KEY_8, IBUS_KEY_parenright,  0x2471, 
IBUS_KEY_parenleft, IBUS_KEY_KP_1, IBUS_KEY_9, IBUS_KEY_parenright,  0x2472, 
IBUS_KEY_parenleft, IBUS_KEY_KP_1, IBUS_KEY_KP_Space, IBUS_KEY_parenright,  0x246B, 
IBUS_KEY_parenleft, IBUS_KEY_KP_1, IBUS_KEY_KP_0, IBUS_KEY_parenright,  0x2469, 
IBUS_KEY_parenleft, IBUS_KEY_KP_1, IBUS_KEY_KP_1, IBUS_KEY_parenright,  0x246A, 
IBUS_KEY_parenleft, IBUS_KEY_KP_1, IBUS_KEY_KP_2, IBUS_KEY_parenright,  0x246B, 
IBUS_KEY_parenleft, IBUS_KEY_KP_1, IBUS_KEY_KP_3, IBUS_KEY_parenright,  0x246C, 
IBUS_KEY_parenleft, IBUS_KEY_KP_1, IBUS_KEY_KP_4, IBUS_KEY_parenright,  0x246D, 
IBUS_KEY_parenleft, IBUS_KEY_KP_1, IBUS_KEY_KP_5, IBUS_KEY_parenright,  0x246E, 
IBUS_KEY_parenleft, IBUS_KEY_KP_1, IBUS_KEY_KP_6, IBUS_KEY_parenright,  0x246F, 
IBUS_KEY_parenleft, IBUS_KEY_KP_1, IBUS_KEY_KP_7, IBUS_KEY_parenright,  0x2470, 
IBUS_KEY_parenleft, IBUS_KEY_KP_1, IBUS_KEY_KP_8, IBUS_KEY_parenright,  0x2471, 
IBUS_KEY_parenleft, IBUS_KEY_KP_1, IBUS_KEY_KP_9, IBUS_KEY_parenright,  0x2472, 
IBUS_KEY_parenleft, IBUS_KEY_KP_2, IBUS_KEY_0, IBUS_KEY_parenright,  0x2473, 
IBUS_KEY_parenleft, IBUS_KEY_KP_2, IBUS_KEY_1, IBUS_KEY_parenright,  0x3251, 
IBUS_KEY_parenleft, IBUS_KEY_KP_2, IBUS_KEY_2, IBUS_KEY_parenright,  0x3252, 
IBUS_KEY_parenleft, IBUS_KEY_KP_2, IBUS_KEY_3, IBUS_KEY_parenright,  0x3253, 
IBUS_KEY_parenleft, IBUS_KEY_KP_2, IBUS_KEY_4, IBUS_KEY_parenright,  0x3254, 
IBUS_KEY_parenleft, IBUS_KEY_KP_2, IBUS_KEY_5, IBUS_KEY_parenright,  0x3255, 
IBUS_KEY_parenleft, IBUS_KEY_KP_2, IBUS_KEY_6, IBUS_KEY_parenright,  0x3256, 
IBUS_KEY_parenleft, IBUS_KEY_KP_2, IBUS_KEY_7, IBUS_KEY_parenright,  0x3257, 
IBUS_KEY_parenleft, IBUS_KEY_KP_2, IBUS_KEY_8, IBUS_KEY_parenright,  0x3258, 
IBUS_KEY_parenleft, IBUS_KEY_KP_2, IBUS_KEY_9, IBUS_KEY_parenright,  0x3259, 
IBUS_KEY_parenleft, IBUS_KEY_KP_2, IBUS_KEY_KP_Space, IBUS_KEY_parenright,  0x3252, 
IBUS_KEY_parenleft, IBUS_KEY_KP_2, IBUS_KEY_KP_0, IBUS_KEY_parenright,  0x2473, 
IBUS_KEY_parenleft, IBUS_KEY_KP_2, IBUS_KEY_KP_1, IBUS_KEY_parenright,  0x3251, 
IBUS_KEY_parenleft, IBUS_KEY_KP_2, IBUS_KEY_KP_2, IBUS_KEY_parenright,  0x3252, 
IBUS_KEY_parenleft, IBUS_KEY_KP_2, IBUS_KEY_KP_3, IBUS_KEY_parenright,  0x3253, 
IBUS_KEY_parenleft, IBUS_KEY_KP_2, IBUS_KEY_KP_4, IBUS_KEY_parenright,  0x3254, 
IBUS_KEY_parenleft, IBUS_KEY_KP_2, IBUS_KEY_KP_5, IBUS_KEY_parenright,  0x3255, 
IBUS_KEY_parenleft, IBUS_KEY_KP_2, IBUS_KEY_KP_6, IBUS_KEY_parenright,  0x3256, 
IBUS_KEY_parenleft, IBUS_KEY_KP_2, IBUS_KEY_KP_7, IBUS_KEY_parenright,  0x3257, 
IBUS_KEY_parenleft, IBUS_KEY_KP_2, IBUS_KEY_KP_8, IBUS_KEY_parenright,  0x3258, 
IBUS_KEY_parenleft, IBUS_KEY_KP_2, IBUS_KEY_KP_9, IBUS_KEY_parenright,  0x3259, 
IBUS_KEY_parenleft, IBUS_KEY_KP_3, IBUS_KEY_0, IBUS_KEY_parenright,  0x325A, 
IBUS_KEY_parenleft, IBUS_KEY_KP_3, IBUS_KEY_1, IBUS_KEY_parenright,  0x325B, 
IBUS_KEY_parenleft, IBUS_KEY_KP_3, IBUS_KEY_2, IBUS_KEY_parenright,  0x325C, 
IBUS_KEY_parenleft, IBUS_KEY_KP_3, IBUS_KEY_3, IBUS_KEY_parenright,  0x325D, 
IBUS_KEY_parenleft, IBUS_KEY_KP_3, IBUS_KEY_4, IBUS_KEY_parenright,  0x325E, 
IBUS_KEY_parenleft, IBUS_KEY_KP_3, IBUS_KEY_5, IBUS_KEY_parenright,  0x325F, 
IBUS_KEY_parenleft, IBUS_KEY_KP_3, IBUS_KEY_6, IBUS_KEY_parenright,  0x32B1, 
IBUS_KEY_parenleft, IBUS_KEY_KP_3, IBUS_KEY_7, IBUS_KEY_parenright,  0x32B2, 
IBUS_KEY_parenleft, IBUS_KEY_KP_3, IBUS_KEY_8, IBUS_KEY_parenright,  0x32B3, 
IBUS_KEY_parenleft, IBUS_KEY_KP_3, IBUS_KEY_9, IBUS_KEY_parenright,  0x32B4, 
IBUS_KEY_parenleft, IBUS_KEY_KP_3, IBUS_KEY_KP_Space, IBUS_KEY_parenright,  0x325C, 
IBUS_KEY_parenleft, IBUS_KEY_KP_3, IBUS_KEY_KP_0, IBUS_KEY_parenright,  0x325A, 
IBUS_KEY_parenleft, IBUS_KEY_KP_3, IBUS_KEY_KP_1, IBUS_KEY_parenright,  0x325B, 
IBUS_KEY_parenleft, IBUS_KEY_KP_3, IBUS_KEY_KP_2, IBUS_KEY_parenright,  0x325C, 
IBUS_KEY_parenleft, IBUS_KEY_KP_3, IBUS_KEY_KP_3, IBUS_KEY_parenright,  0x325D, 
IBUS_KEY_parenleft, IBUS_KEY_KP_3, IBUS_KEY_KP_4, IBUS_KEY_parenright,  0x325E, 
IBUS_KEY_parenleft, IBUS_KEY_KP_3, IBUS_KEY_KP_5, IBUS_KEY_parenright,  0x325F, 
IBUS_KEY_parenleft, IBUS_KEY_KP_3, IBUS_KEY_KP_6, IBUS_KEY_parenright,  0x32B1, 
IBUS_KEY_parenleft, IBUS_KEY_KP_3, IBUS_KEY_KP_7, IBUS_KEY_parenright,  0x32B2, 
IBUS_KEY_parenleft, IBUS_KEY_KP_3, IBUS_KEY_KP_8, IBUS_KEY_parenright,  0x32B3, 
IBUS_KEY_parenleft, IBUS_KEY_KP_3, IBUS_KEY_KP_9, IBUS_KEY_parenright,  0x32B4, 
IBUS_KEY_parenleft, IBUS_KEY_KP_4, IBUS_KEY_0, IBUS_KEY_parenright,  0x32B5, 
IBUS_KEY_parenleft, IBUS_KEY_KP_4, IBUS_KEY_1, IBUS_KEY_parenright,  0x32B6, 
IBUS_KEY_parenleft, IBUS_KEY_KP_4, IBUS_KEY_2, IBUS_KEY_parenright,  0x32B7, 
IBUS_KEY_parenleft, IBUS_KEY_KP_4, IBUS_KEY_3, IBUS_KEY_parenright,  0x32B8, 
IBUS_KEY_parenleft, IBUS_KEY_KP_4, IBUS_KEY_4, IBUS_KEY_parenright,  0x32B9, 
IBUS_KEY_parenleft, IBUS_KEY_KP_4, IBUS_KEY_5, IBUS_KEY_parenright,  0x32BA, 
IBUS_KEY_parenleft, IBUS_KEY_KP_4, IBUS_KEY_6, IBUS_KEY_parenright,  0x32BB, 
IBUS_KEY_parenleft, IBUS_KEY_KP_4, IBUS_KEY_7, IBUS_KEY_parenright,  0x32BC, 
IBUS_KEY_parenleft, IBUS_KEY_KP_4, IBUS_KEY_8, IBUS_KEY_parenright,  0x32BD, 
IBUS_KEY_parenleft, IBUS_KEY_KP_4, IBUS_KEY_9, IBUS_KEY_parenright,  0x32BE, 
IBUS_KEY_parenleft, IBUS_KEY_KP_4, IBUS_KEY_KP_Space, IBUS_KEY_parenright,  0x32B7, 
IBUS_KEY_parenleft, IBUS_KEY_KP_4, IBUS_KEY_KP_0, IBUS_KEY_parenright,  0x32B5, 
IBUS_KEY_parenleft, IBUS_KEY_KP_4, IBUS_KEY_KP_1, IBUS_KEY_parenright,  0x32B6, 
IBUS_KEY_parenleft, IBUS_KEY_KP_4, IBUS_KEY_KP_2, IBUS_KEY_parenright,  0x32B7, 
IBUS_KEY_parenleft, IBUS_KEY_KP_4, IBUS_KEY_KP_3, IBUS_KEY_parenright,  0x32B8, 
IBUS_KEY_parenleft, IBUS_KEY_KP_4, IBUS_KEY_KP_4, IBUS_KEY_parenright,  0x32B9, 
IBUS_KEY_parenleft, IBUS_KEY_KP_4, IBUS_KEY_KP_5, IBUS_KEY_parenright,  0x32BA, 
IBUS_KEY_parenleft, IBUS_KEY_KP_4, IBUS_KEY_KP_6, IBUS_KEY_parenright,  0x32BB, 
IBUS_KEY_parenleft, IBUS_KEY_KP_4, IBUS_KEY_KP_7, IBUS_KEY_parenright,  0x32BC, 
IBUS_KEY_parenleft, IBUS_KEY_KP_4, IBUS_KEY_KP_8, IBUS_KEY_parenright,  0x32BD, 
IBUS_KEY_parenleft, IBUS_KEY_KP_4, IBUS_KEY_KP_9, IBUS_KEY_parenright,  0x32BE, 
IBUS_KEY_parenleft, IBUS_KEY_KP_5, IBUS_KEY_0, IBUS_KEY_parenright,  0x32BF, 
IBUS_KEY_C, IBUS_KEY_C, IBUS_KEY_C, IBUS_KEY_P,  0x262D, 
IBUS_KEY_U, IBUS_KEY_space, IBUS_KEY_comma, IBUS_KEY_E,  0x1E1C, 
IBUS_KEY_U, IBUS_KEY_space, IBUS_KEY_comma, IBUS_KEY_e,  0x1E1D, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F8D, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F9D, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1FAD, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F85, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F95, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1FA5, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F8C, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F9C, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1FAC, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F84, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F94, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1FA4, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ALPHA,  0x1F8C, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ETA,  0x1F9C, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMEGA,  0x1FAC, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_alpha,  0x1F84, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_eta,  0x1F94, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_dead_psili, IBUS_KEY_Greek_omega,  0x1FA4, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ALPHA,  0x1F8D, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ETA,  0x1F9D, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMEGA,  0x1FAD, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_alpha,  0x1F85, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_eta,  0x1F95, 
IBUS_KEY_Greek_iota, IBUS_KEY_apostrophe, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omega,  0x1FA5, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F8B, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F9B, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1FAB, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F83, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F93, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1FA3, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F8A, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F9A, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1FAA, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F82, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F92, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1FA2, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ALPHA,  0x1F8A, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ETA,  0x1F9A, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMEGA,  0x1FAA, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_alpha,  0x1F82, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_eta,  0x1F92, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_omega,  0x1FA2, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ALPHA,  0x1F8B, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ETA,  0x1F9B, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMEGA,  0x1FAB, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_alpha,  0x1F83, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_eta,  0x1F93, 
IBUS_KEY_Greek_iota, IBUS_KEY_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omega,  0x1FA3, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F8F, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F9F, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1FAF, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F87, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F97, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1FA7, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F8E, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F9E, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1FAE, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F86, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F96, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1FA6, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ALPHA,  0x1F8E, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ETA,  0x1F9E, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMEGA,  0x1FAE, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_alpha,  0x1F86, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_eta,  0x1F96, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_omega,  0x1FA6, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ALPHA,  0x1F8F, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ETA,  0x1F9F, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMEGA,  0x1FAF, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_alpha,  0x1F87, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_eta,  0x1F97, 
IBUS_KEY_Greek_iota, IBUS_KEY_asciitilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omega,  0x1FA7, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F8D, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F9D, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1FAD, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F85, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F95, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1FA5, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F8C, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F9C, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1FAC, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F84, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F94, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1FA4, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ALPHA,  0x1F8C, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ETA,  0x1F9C, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMEGA,  0x1FAC, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_alpha,  0x1F84, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_eta,  0x1F94, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_omega,  0x1FA4, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ALPHA,  0x1F8D, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ETA,  0x1F9D, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMEGA,  0x1FAD, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_alpha,  0x1F85, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_eta,  0x1F95, 
IBUS_KEY_Greek_iota, IBUS_KEY_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omega,  0x1FA5, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F8B, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F9B, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1FAB, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F83, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F93, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1FA3, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F8A, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F9A, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1FAA, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F82, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F92, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1FA2, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ALPHA,  0x1F8A, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ETA,  0x1F9A, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMEGA,  0x1FAA, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_alpha,  0x1F82, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_eta,  0x1F92, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_psili, IBUS_KEY_Greek_omega,  0x1FA2, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ALPHA,  0x1F8B, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ETA,  0x1F9B, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMEGA,  0x1FAB, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_alpha,  0x1F83, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_eta,  0x1F93, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omega,  0x1FA3, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F8D, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F9D, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1FAD, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F85, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F95, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1FA5, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F8C, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F9C, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1FAC, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F84, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F94, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1FA4, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ALPHA,  0x1F8C, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ETA,  0x1F9C, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMEGA,  0x1FAC, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_alpha,  0x1F84, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_eta,  0x1F94, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_psili, IBUS_KEY_Greek_omega,  0x1FA4, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ALPHA,  0x1F8D, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ETA,  0x1F9D, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMEGA,  0x1FAD, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_alpha,  0x1F85, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_eta,  0x1F95, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omega,  0x1FA5, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_ALPHA,  0x1F8F, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_ETA,  0x1F9F, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_OMEGA,  0x1FAF, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_alpha,  0x1F87, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_eta,  0x1F97, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_parenleft, IBUS_KEY_Greek_omega,  0x1FA7, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_parenright, IBUS_KEY_Greek_ALPHA,  0x1F8E, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_parenright, IBUS_KEY_Greek_ETA,  0x1F9E, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_parenright, IBUS_KEY_Greek_OMEGA,  0x1FAE, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_parenright, IBUS_KEY_Greek_alpha,  0x1F86, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_parenright, IBUS_KEY_Greek_eta,  0x1F96, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_parenright, IBUS_KEY_Greek_omega,  0x1FA6, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ALPHA,  0x1F8E, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_ETA,  0x1F9E, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_OMEGA,  0x1FAE, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_alpha,  0x1F86, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_eta,  0x1F96, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_psili, IBUS_KEY_Greek_omega,  0x1FA6, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ALPHA,  0x1F8F, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_ETA,  0x1F9F, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_OMEGA,  0x1FAF, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_alpha,  0x1F87, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_eta,  0x1F97, 
IBUS_KEY_Greek_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_dasia, IBUS_KEY_Greek_omega,  0x1FA7, 
};

static const guint16 gtk_compose_seqs_compact_32bit_first[] = {
IBUS_KEY_dead_grave, 54, 123, 187, 187, 187, 
IBUS_KEY_dead_acute, 187, 268, 316, 316, 316, 
IBUS_KEY_dead_circumflex, 316, 388, 388, 388, 388, 
IBUS_KEY_dead_tilde, 388, 406, 406, 406, 406, 
IBUS_KEY_dead_macron, 406, 466, 466, 466, 466, 
IBUS_KEY_dead_caron, 466, 502, 502, 502, 502, 
IBUS_KEY_dead_doublegrave, 502, 538, 538, 538, 538, 
IBUS_KEY_dead_invertedbreve, 538, 574, 574, 574, 574, 
IBUS_KEY_Multi_key, 574, 574, 850, 920, 926, 
IBUS_KEY_M,  0, 2,
IBUS_KEY_m,  2, 2,
0x0186,  4, 2,
0x018E,  6, 2,
0x0190,  8, 2,
0x0196,  10, 2,
0x01B1,  12, 2,
0x01B2,  14, 2,
0x01DD,  16, 2,
0x0254,  18, 2,
0x025B,  20, 2,
0x0269,  22, 2,
0x028A,  24, 2,
0x028B,  26, 2,
IBUS_KEY_ENG,  28, 2,
IBUS_KEY_Cyrillic_a,  30, 2,
IBUS_KEY_Cyrillic_o,  32, 2,
IBUS_KEY_Cyrillic_er,  34, 2,
IBUS_KEY_Cyrillic_u,  36, 2,
IBUS_KEY_Cyrillic_A,  38, 2,
IBUS_KEY_Cyrillic_O,  40, 2,
IBUS_KEY_Cyrillic_ER,  42, 2,
IBUS_KEY_Cyrillic_U,  44, 2,
IBUS_KEY_dead_tilde, IBUS_KEY_A,  46, 3,
IBUS_KEY_dead_tilde, IBUS_KEY_E,  49, 3,
IBUS_KEY_dead_tilde, IBUS_KEY_I,  52, 3,
IBUS_KEY_dead_tilde, IBUS_KEY_O,  55, 3,
IBUS_KEY_dead_tilde, IBUS_KEY_U,  58, 3,
IBUS_KEY_dead_tilde, IBUS_KEY_a,  61, 3,
IBUS_KEY_dead_tilde, IBUS_KEY_e,  64, 3,
IBUS_KEY_dead_tilde, IBUS_KEY_i,  67, 3,
IBUS_KEY_dead_tilde, IBUS_KEY_o,  70, 3,
IBUS_KEY_dead_tilde, IBUS_KEY_u,  73, 3,
IBUS_KEY_dead_tilde, 0x0186,  76, 3,
IBUS_KEY_dead_tilde, 0x018E,  79, 3,
IBUS_KEY_dead_tilde, 0x0190,  82, 3,
IBUS_KEY_dead_tilde, 0x01DD,  85, 3,
IBUS_KEY_dead_tilde, 0x0254,  88, 3,
IBUS_KEY_dead_tilde, 0x025B,  91, 3,
IBUS_KEY_J,  94, 2,
IBUS_KEY_j,  96, 2,
0x0186,  98, 2,
0x018E,  100, 2,
0x0190,  102, 2,
0x0196,  104, 2,
0x01B1,  106, 2,
0x01B2,  108, 2,
0x01DD,  110, 2,
0x0254,  112, 2,
0x025B,  114, 2,
0x0269,  116, 2,
0x028A,  118, 2,
0x028B,  120, 2,
IBUS_KEY_ENG,  122, 2,
IBUS_KEY_Cyrillic_a,  124, 2,
IBUS_KEY_Cyrillic_ie,  126, 2,
IBUS_KEY_Cyrillic_i,  128, 2,
IBUS_KEY_Cyrillic_o,  130, 2,
IBUS_KEY_Cyrillic_er,  132, 2,
IBUS_KEY_Cyrillic_u,  134, 2,
IBUS_KEY_Cyrillic_A,  136, 2,
IBUS_KEY_Cyrillic_IE,  138, 2,
IBUS_KEY_Cyrillic_I,  140, 2,
IBUS_KEY_Cyrillic_O,  142, 2,
IBUS_KEY_Cyrillic_ER,  144, 2,
IBUS_KEY_Cyrillic_U,  146, 2,
IBUS_KEY_dead_tilde, IBUS_KEY_A,  148, 3,
IBUS_KEY_dead_tilde, IBUS_KEY_E,  151, 3,
IBUS_KEY_dead_tilde, IBUS_KEY_I,  154, 3,
IBUS_KEY_dead_tilde, IBUS_KEY_a,  157, 3,
IBUS_KEY_dead_tilde, IBUS_KEY_e,  160, 3,
IBUS_KEY_dead_tilde, IBUS_KEY_i,  163, 3,
IBUS_KEY_dead_tilde, 0x0186,  166, 3,
IBUS_KEY_dead_tilde, 0x018E,  169, 3,
IBUS_KEY_dead_tilde, 0x0190,  172, 3,
IBUS_KEY_dead_tilde, 0x01DD,  175, 3,
IBUS_KEY_dead_tilde, 0x0254,  178, 3,
IBUS_KEY_dead_tilde, 0x025B,  181, 3,
0x0186,  184, 2,
0x018E,  186, 2,
0x0190,  188, 2,
0x0196,  190, 2,
0x01B1,  192, 2,
0x01B2,  194, 2,
0x01DD,  196, 2,
0x0254,  198, 2,
0x025B,  200, 2,
0x0269,  202, 2,
0x028A,  204, 2,
0x028B,  206, 2,
IBUS_KEY_Cyrillic_a,  208, 2,
IBUS_KEY_Cyrillic_ie,  210, 2,
IBUS_KEY_Cyrillic_i,  212, 2,
IBUS_KEY_Cyrillic_o,  214, 2,
IBUS_KEY_Cyrillic_er,  216, 2,
IBUS_KEY_Cyrillic_u,  218, 2,
IBUS_KEY_Cyrillic_A,  220, 2,
IBUS_KEY_Cyrillic_IE,  222, 2,
IBUS_KEY_Cyrillic_I,  224, 2,
IBUS_KEY_Cyrillic_O,  226, 2,
IBUS_KEY_Cyrillic_ER,  228, 2,
IBUS_KEY_Cyrillic_U,  230, 2,
0x0186,  232, 2,
0x018E,  234, 2,
0x0190,  236, 2,
0x01DD,  238, 2,
0x0254,  240, 2,
0x025B,  242, 2,
0x0186,  244, 2,
0x018E,  246, 2,
0x0190,  248, 2,
0x0196,  250, 2,
0x01B1,  252, 2,
0x01B2,  254, 2,
0x01DD,  256, 2,
0x0254,  258, 2,
0x025B,  260, 2,
0x0269,  262, 2,
0x028A,  264, 2,
0x028B,  266, 2,
IBUS_KEY_Cyrillic_a,  268, 2,
IBUS_KEY_Cyrillic_ie,  270, 2,
IBUS_KEY_Cyrillic_o,  272, 2,
IBUS_KEY_Cyrillic_er,  274, 2,
IBUS_KEY_Cyrillic_A,  276, 2,
IBUS_KEY_Cyrillic_IE,  278, 2,
IBUS_KEY_Cyrillic_O,  280, 2,
IBUS_KEY_Cyrillic_ER,  282, 2,
0x0186,  284, 2,
0x018E,  286, 2,
0x0190,  288, 2,
0x0196,  290, 2,
0x01B1,  292, 2,
0x01B2,  294, 2,
0x01DD,  296, 2,
0x0254,  298, 2,
0x025B,  300, 2,
0x0269,  302, 2,
0x028A,  304, 2,
0x028B,  306, 2,
IBUS_KEY_Cyrillic_a,  308, 2,
IBUS_KEY_Cyrillic_ie,  310, 2,
IBUS_KEY_Cyrillic_i,  312, 2,
IBUS_KEY_Cyrillic_o,  314, 2,
IBUS_KEY_Cyrillic_er,  316, 2,
IBUS_KEY_Cyrillic_u,  318, 2,
IBUS_KEY_Cyrillic_A,  320, 2,
IBUS_KEY_Cyrillic_IE,  322, 2,
IBUS_KEY_Cyrillic_I,  324, 2,
IBUS_KEY_Cyrillic_O,  326, 2,
IBUS_KEY_Cyrillic_ER,  328, 2,
IBUS_KEY_Cyrillic_U,  330, 2,
IBUS_KEY_Cyrillic_a,  332, 2,
IBUS_KEY_Cyrillic_ie,  334, 2,
IBUS_KEY_Cyrillic_i,  336, 2,
IBUS_KEY_Cyrillic_o,  338, 2,
IBUS_KEY_Cyrillic_er,  340, 2,
IBUS_KEY_Cyrillic_u,  342, 2,
IBUS_KEY_Cyrillic_A,  344, 2,
IBUS_KEY_Cyrillic_IE,  346, 2,
IBUS_KEY_Cyrillic_I,  348, 2,
IBUS_KEY_Cyrillic_O,  350, 2,
IBUS_KEY_Cyrillic_ER,  352, 2,
IBUS_KEY_Cyrillic_U,  354, 2,
IBUS_KEY_apostrophe, IBUS_KEY_J,  356, 2,
IBUS_KEY_apostrophe, IBUS_KEY_j,  358, 2,
IBUS_KEY_apostrophe, IBUS_KEY_Cyrillic_a,  360, 2,
IBUS_KEY_apostrophe, IBUS_KEY_Cyrillic_ie,  362, 2,
IBUS_KEY_apostrophe, IBUS_KEY_Cyrillic_i,  364, 2,
IBUS_KEY_apostrophe, IBUS_KEY_Cyrillic_o,  366, 2,
IBUS_KEY_apostrophe, IBUS_KEY_Cyrillic_er,  368, 2,
IBUS_KEY_apostrophe, IBUS_KEY_Cyrillic_u,  370, 2,
IBUS_KEY_apostrophe, IBUS_KEY_Cyrillic_A,  372, 2,
IBUS_KEY_apostrophe, IBUS_KEY_Cyrillic_IE,  374, 2,
IBUS_KEY_apostrophe, IBUS_KEY_Cyrillic_I,  376, 2,
IBUS_KEY_apostrophe, IBUS_KEY_Cyrillic_O,  378, 2,
IBUS_KEY_apostrophe, IBUS_KEY_Cyrillic_ER,  380, 2,
IBUS_KEY_apostrophe, IBUS_KEY_Cyrillic_U,  382, 2,
IBUS_KEY_F, IBUS_KEY_U,  384, 1,
IBUS_KEY_J, IBUS_KEY_apostrophe,  385, 2,
IBUS_KEY_J, IBUS_KEY_acute,  387, 2,
IBUS_KEY_asciicircum, IBUS_KEY_Cyrillic_a,  389, 2,
IBUS_KEY_asciicircum, IBUS_KEY_Cyrillic_ie,  391, 2,
IBUS_KEY_asciicircum, IBUS_KEY_Cyrillic_i,  393, 2,
IBUS_KEY_asciicircum, IBUS_KEY_Cyrillic_o,  395, 2,
IBUS_KEY_asciicircum, IBUS_KEY_Cyrillic_er,  397, 2,
IBUS_KEY_asciicircum, IBUS_KEY_Cyrillic_u,  399, 2,
IBUS_KEY_asciicircum, IBUS_KEY_Cyrillic_A,  401, 2,
IBUS_KEY_asciicircum, IBUS_KEY_Cyrillic_IE,  403, 2,
IBUS_KEY_asciicircum, IBUS_KEY_Cyrillic_I,  405, 2,
IBUS_KEY_asciicircum, IBUS_KEY_Cyrillic_O,  407, 2,
IBUS_KEY_asciicircum, IBUS_KEY_Cyrillic_ER,  409, 2,
IBUS_KEY_asciicircum, IBUS_KEY_Cyrillic_U,  411, 2,
IBUS_KEY_underscore, IBUS_KEY_Cyrillic_a,  413, 2,
IBUS_KEY_underscore, IBUS_KEY_Cyrillic_ie,  415, 2,
IBUS_KEY_underscore, IBUS_KEY_Cyrillic_o,  417, 2,
IBUS_KEY_underscore, IBUS_KEY_Cyrillic_er,  419, 2,
IBUS_KEY_underscore, IBUS_KEY_Cyrillic_A,  421, 2,
IBUS_KEY_underscore, IBUS_KEY_Cyrillic_IE,  423, 2,
IBUS_KEY_underscore, IBUS_KEY_Cyrillic_O,  425, 2,
IBUS_KEY_underscore, IBUS_KEY_Cyrillic_ER,  427, 2,
IBUS_KEY_grave, IBUS_KEY_Cyrillic_a,  429, 2,
IBUS_KEY_grave, IBUS_KEY_Cyrillic_o,  431, 2,
IBUS_KEY_grave, IBUS_KEY_Cyrillic_er,  433, 2,
IBUS_KEY_grave, IBUS_KEY_Cyrillic_u,  435, 2,
IBUS_KEY_grave, IBUS_KEY_Cyrillic_A,  437, 2,
IBUS_KEY_grave, IBUS_KEY_Cyrillic_O,  439, 2,
IBUS_KEY_grave, IBUS_KEY_Cyrillic_ER,  441, 2,
IBUS_KEY_grave, IBUS_KEY_Cyrillic_U,  443, 2,
IBUS_KEY_j, IBUS_KEY_apostrophe,  445, 2,
IBUS_KEY_j, IBUS_KEY_acute,  447, 2,
IBUS_KEY_macron, IBUS_KEY_Cyrillic_a,  449, 2,
IBUS_KEY_macron, IBUS_KEY_Cyrillic_ie,  451, 2,
IBUS_KEY_macron, IBUS_KEY_Cyrillic_o,  453, 2,
IBUS_KEY_macron, IBUS_KEY_Cyrillic_er,  455, 2,
IBUS_KEY_macron, IBUS_KEY_Cyrillic_A,  457, 2,
IBUS_KEY_macron, IBUS_KEY_Cyrillic_IE,  459, 2,
IBUS_KEY_macron, IBUS_KEY_Cyrillic_O,  461, 2,
IBUS_KEY_macron, IBUS_KEY_Cyrillic_ER,  463, 2,
IBUS_KEY_acute, IBUS_KEY_J,  465, 2,
IBUS_KEY_acute, IBUS_KEY_j,  467, 2,
IBUS_KEY_acute, IBUS_KEY_Cyrillic_a,  469, 2,
IBUS_KEY_acute, IBUS_KEY_Cyrillic_ie,  471, 2,
IBUS_KEY_acute, IBUS_KEY_Cyrillic_i,  473, 2,
IBUS_KEY_acute, IBUS_KEY_Cyrillic_o,  475, 2,
IBUS_KEY_acute, IBUS_KEY_Cyrillic_er,  477, 2,
IBUS_KEY_acute, IBUS_KEY_Cyrillic_u,  479, 2,
IBUS_KEY_acute, IBUS_KEY_Cyrillic_A,  481, 2,
IBUS_KEY_acute, IBUS_KEY_Cyrillic_IE,  483, 2,
IBUS_KEY_acute, IBUS_KEY_Cyrillic_I,  485, 2,
IBUS_KEY_acute, IBUS_KEY_Cyrillic_O,  487, 2,
IBUS_KEY_acute, IBUS_KEY_Cyrillic_ER,  489, 2,
IBUS_KEY_acute, IBUS_KEY_Cyrillic_U,  491, 2,
IBUS_KEY_backslash, IBUS_KEY_o, IBUS_KEY_slash,  493, 1,
IBUS_KEY_grave, IBUS_KEY_grave, IBUS_KEY_Cyrillic_a,  494, 2,
IBUS_KEY_grave, IBUS_KEY_grave, IBUS_KEY_Cyrillic_ie,  496, 2,
IBUS_KEY_grave, IBUS_KEY_grave, IBUS_KEY_Cyrillic_i,  498, 2,
IBUS_KEY_grave, IBUS_KEY_grave, IBUS_KEY_Cyrillic_o,  500, 2,
IBUS_KEY_grave, IBUS_KEY_grave, IBUS_KEY_Cyrillic_er,  502, 2,
IBUS_KEY_grave, IBUS_KEY_grave, IBUS_KEY_Cyrillic_u,  504, 2,
IBUS_KEY_grave, IBUS_KEY_grave, IBUS_KEY_Cyrillic_A,  506, 2,
IBUS_KEY_grave, IBUS_KEY_grave, IBUS_KEY_Cyrillic_IE,  508, 2,
IBUS_KEY_grave, IBUS_KEY_grave, IBUS_KEY_Cyrillic_I,  510, 2,
IBUS_KEY_grave, IBUS_KEY_grave, IBUS_KEY_Cyrillic_O,  512, 2,
IBUS_KEY_grave, IBUS_KEY_grave, IBUS_KEY_Cyrillic_ER,  514, 2,
IBUS_KEY_grave, IBUS_KEY_grave, IBUS_KEY_Cyrillic_U,  516, 2,
IBUS_KEY_p, IBUS_KEY_o, IBUS_KEY_o,  518, 1,
IBUS_KEY_L, IBUS_KEY_L, IBUS_KEY_A, IBUS_KEY_P,  519, 1,
};

static const guint32 gtk_compose_seqs_compact_32bit_second[] = {
0x004D, 0x0300, 
0x006D, 0x0300, 
0x0186, 0x0300, 
0x018E, 0x0300, 
0x0190, 0x0300, 
0x0196, 0x0300, 
0x01B1, 0x0300, 
0x01B2, 0x0300, 
0x01DD, 0x0300, 
0x0254, 0x0300, 
0x025B, 0x0300, 
0x0269, 0x0300, 
0x028A, 0x0300, 
0x028B, 0x0300, 
0x014A, 0x0300, 
0x0430, 0x0300, 
0x043E, 0x0300, 
0x0440, 0x0300, 
0x0443, 0x0300, 
0x0410, 0x0300, 
0x041E, 0x0300, 
0x0420, 0x0300, 
0x0423, 0x0300, 
0x0041, 0x0303, 0x0300, 
0x0045, 0x0303, 0x0300, 
0x0049, 0x0303, 0x0300, 
0x004F, 0x0303, 0x0300, 
0x0055, 0x0303, 0x0300, 
0x0061, 0x0303, 0x0300, 
0x0065, 0x0303, 0x0300, 
0x0069, 0x0303, 0x0300, 
0x006F, 0x0303, 0x0300, 
0x0075, 0x0303, 0x0300, 
0x0186, 0x0303, 0x0300, 
0x018E, 0x0303, 0x0300, 
0x0190, 0x0303, 0x0300, 
0x01DD, 0x0303, 0x0300, 
0x0254, 0x0303, 0x0300, 
0x025B, 0x0303, 0x0300, 
0x004A, 0x0301, 
0x006A, 0x0301, 
0x0186, 0x0301, 
0x018E, 0x0301, 
0x0190, 0x0301, 
0x0196, 0x0301, 
0x01B1, 0x0301, 
0x01B2, 0x0301, 
0x01DD, 0x0301, 
0x0254, 0x0301, 
0x025B, 0x0301, 
0x0269, 0x0301, 
0x028A, 0x0301, 
0x028B, 0x0301, 
0x014A, 0x0301, 
0x0430, 0x0301, 
0x0435, 0x0301, 
0x0438, 0x0301, 
0x043E, 0x0301, 
0x0440, 0x0301, 
0x0443, 0x0301, 
0x0410, 0x0301, 
0x0415, 0x0301, 
0x0418, 0x0301, 
0x041E, 0x0301, 
0x0420, 0x0301, 
0x0423, 0x0301, 
0x0041, 0x0303, 0x0301, 
0x0045, 0x0303, 0x0301, 
0x0049, 0x0303, 0x0301, 
0x0061, 0x0303, 0x0301, 
0x0065, 0x0303, 0x0301, 
0x0069, 0x0303, 0x0301, 
0x0186, 0x0303, 0x0301, 
0x018E, 0x0303, 0x0301, 
0x0190, 0x0303, 0x0301, 
0x01DD, 0x0303, 0x0301, 
0x0254, 0x0303, 0x0301, 
0x025B, 0x0303, 0x0301, 
0x0186, 0x0302, 
0x018E, 0x0302, 
0x0190, 0x0302, 
0x0196, 0x0302, 
0x01B1, 0x0302, 
0x01B2, 0x0302, 
0x01DD, 0x0302, 
0x0254, 0x0302, 
0x025B, 0x0302, 
0x0269, 0x0302, 
0x028A, 0x0302, 
0x028B, 0x0302, 
0x0430, 0x0302, 
0x0435, 0x0302, 
0x0438, 0x0302, 
0x043E, 0x0302, 
0x0440, 0x0302, 
0x0443, 0x0302, 
0x0410, 0x0302, 
0x0415, 0x0302, 
0x0418, 0x0302, 
0x041E, 0x0302, 
0x0420, 0x0302, 
0x0423, 0x0302, 
0x0186, 0x0303, 
0x018E, 0x0303, 
0x0190, 0x0303, 
0x01DD, 0x0303, 
0x0254, 0x0303, 
0x025B, 0x0303, 
0x0186, 0x0304, 
0x018E, 0x0304, 
0x0190, 0x0304, 
0x0196, 0x0304, 
0x01B1, 0x0304, 
0x01B2, 0x0304, 
0x01DD, 0x0304, 
0x0254, 0x0304, 
0x025B, 0x0304, 
0x0269, 0x0304, 
0x028A, 0x0304, 
0x028B, 0x0304, 
0x0430, 0x0304, 
0x0435, 0x0304, 
0x043E, 0x0304, 
0x0440, 0x0304, 
0x0410, 0x0304, 
0x0415, 0x0304, 
0x041E, 0x0304, 
0x0420, 0x0304, 
0x0186, 0x030C, 
0x018E, 0x030C, 
0x0190, 0x030C, 
0x0196, 0x030C, 
0x01B1, 0x030C, 
0x01B2, 0x030C, 
0x01DD, 0x030C, 
0x0254, 0x030C, 
0x025B, 0x030C, 
0x0269, 0x030C, 
0x028A, 0x030C, 
0x028B, 0x030C, 
0x0430, 0x030F, 
0x0435, 0x030F, 
0x0438, 0x030F, 
0x043E, 0x030F, 
0x0440, 0x030F, 
0x0443, 0x030F, 
0x0410, 0x030F, 
0x0415, 0x030F, 
0x0418, 0x030F, 
0x041E, 0x030F, 
0x0420, 0x030F, 
0x0423, 0x030F, 
0x0430, 0x0311, 
0x0435, 0x0311, 
0x0438, 0x0311, 
0x043E, 0x0311, 
0x0440, 0x0311, 
0x0443, 0x0311, 
0x0410, 0x0311, 
0x0415, 0x0311, 
0x0418, 0x0311, 
0x041E, 0x0311, 
0x0420, 0x0311, 
0x0423, 0x0311, 
0x004A, 0x0301, 
0x006A, 0x0301, 
0x0430, 0x0301, 
0x0435, 0x0301, 
0x0438, 0x0301, 
0x043E, 0x0301, 
0x0440, 0x0301, 
0x0443, 0x0301, 
0x0410, 0x0301, 
0x0415, 0x0301, 
0x0418, 0x0301, 
0x041E, 0x0301, 
0x0420, 0x0301, 
0x0423, 0x0301, 
0x1F595, 
0x004A, 0x0301, 
0x004A, 0x0301, 
0x0430, 0x0302, 
0x0435, 0x0302, 
0x0438, 0x0302, 
0x043E, 0x0302, 
0x0440, 0x0302, 
0x0443, 0x0302, 
0x0410, 0x0302, 
0x0415, 0x0302, 
0x0418, 0x0302, 
0x041E, 0x0302, 
0x0420, 0x0302, 
0x0423, 0x0302, 
0x0430, 0x0304, 
0x0435, 0x0304, 
0x043E, 0x0304, 
0x0440, 0x0304, 
0x0410, 0x0304, 
0x0415, 0x0304, 
0x041E, 0x0304, 
0x0420, 0x0304, 
0x0430, 0x0300, 
0x043E, 0x0300, 
0x0440, 0x0300, 
0x0443, 0x0300, 
0x0410, 0x0300, 
0x041E, 0x0300, 
0x0420, 0x0300, 
0x0423, 0x0300, 
0x006A, 0x0301, 
0x006A, 0x0301, 
0x0430, 0x0304, 
0x0435, 0x0304, 
0x043E, 0x0304, 
0x0440, 0x0304, 
0x0410, 0x0304, 
0x0415, 0x0304, 
0x041E, 0x0304, 
0x0420, 0x0304, 
0x004A, 0x0301, 
0x006A, 0x0301, 
0x0430, 0x0301, 
0x0435, 0x0301, 
0x0438, 0x0301, 
0x043E, 0x0301, 
0x0440, 0x0301, 
0x0443, 0x0301, 
0x0410, 0x0301, 
0x0415, 0x0301, 
0x0418, 0x0301, 
0x041E, 0x0301, 
0x0420, 0x0301, 
0x0423, 0x0301, 
0x1F64C, 
0x0430, 0x030F, 
0x0435, 0x030F, 
0x0438, 0x030F, 
0x043E, 0x030F, 
0x0440, 0x030F, 
0x0443, 0x030F, 
0x0410, 0x030F, 
0x0415, 0x030F, 
0x0418, 0x030F, 
0x041E, 0x030F, 
0x0420, 0x030F, 
0x0423, 0x030F, 
0x1F4A9, 
0x1F596, 
};

#endif /* __GTK_IM_CONTEXT_SIMPLE_SEQS_H__ */

