# Millimetre

![specimen1](documentation/specimen/web/specimen_millimetre_web.png)

## English

Millimetre is a series of fonts constructed on a grid based on the metric system distributed by [Velvetyne Type Foundry](http://velvetyne.fr/fonts/millimetre/). It follows the decimal logic of the latter. In this spirit, when you typeset Millimetre, please don’t use the archaic unit of the point but the millimetre, centimetre, decimeter or the meter itself for the really big sizes.

In this typeface, each em-square1 is vertically and horizontally divided in 10 units (decimal, remember?). Printed at a 1 cm size, the strokes of the regular weight will be 1 mm thick. Both white spaces and black stems fit on this grid. Half of the lines and columns of this 10x10 grid receive the stems and the strokes of this font whereas the other half is there to receive the white spaces inside the letters and between them, making Millimetre rhythm quite unique, totally settled, like a barcode. To make it clearer, when you typeset two m lowercases, the thickness of the stems of the m will be equal to the counters between its legs, to the thins and to the space between the two letters. This grid-based design, aligned to a pixel grid, makes Millimetre works quite well on screen too. When typesetted with a leading equal to its size, the grid appears in the perfect alignment of the stems between the different lines of text. No corrections needed.

From a stylistic point of view, Millimetre is a geometric, constructed sans serif, with quite wide proportions even if the width of several glyphs could contradict this statement. With its rectangular look and closed terminals, Millimetre reminds us of 60’s sans such as Aldo Novarese's Eurostile. Far from running away from this graphic universe, Millimetre embraces the retro-futuristic, architectural, technological and science-fictional connotations that come with it. Due to the grid on the top of which it's constructed, the rhythm of this typeface can remind us of the one created by a monospace. Even though it shares  a certain regularity in the widths of its glyphs, Millimetre isn't a monospace, it creates is own grey. Began as a truly monolinear sans, the drawing of this typeface is finally more subtle, with thinner stroke joins and tiny variations of weight to balance the shapes. This becomes even clearer in the bolder weights where some thins appear in several glyphs to avoid making them too dark regarding the rest of the font.

If the regular never leaves the grid, the other weights are more sensible whereas keeping a really close rhythm. Millimetre Bold is 1,5 times bolder than the regular and the lighter weight will be half the one of the regular. Set together, the different weights share the same grid and allow to create a constructed layout altogether. The system never gives up.

Finally, this type family comes with a wide range of technic and geometric ornaments allowing to create patterns dialoguing with the text. These ornaments are inspired by the early age of the computer era and by the technical graphs used in the printing business. Therefore, they can be really useful to layout technical documents, maps, or to accompany and put the emphasis on the technological look of the font on graphical documents.

Millimetre is a libre and open-source font currently still
in development. Contribute or download it on [Velvetyne Type Foundry](http://velvetyne.fr/fonts/millimetre/).

## Specimen

![specimen2](https://github.com/jjjlllnnn/Millimetre/blob/master/documentation/specimen/web/specimen_millimetre_web2.png)

## Français


#### Voir plus grand en millimètre
Millimetre est une famille typographique basée sur le système métrique et distribuée par [Velvetyne Type Foundry](http://velvetyne.fr). Elle suit la logique décimale de ce dernier. Dans cette esprit, lorsque vous composerez un texte en Millimetre, s'il vous plait n'utilisez pas l'unité archaïque du point. Pensez plutôt à ces unités modernes et cohérentes que sont le millimètre, le centimètre, le décimètre ou le mètre lui-même, pour les très grandes tailles.

#### Mise au point
Le point est apparu avant le système métrique. Il a été créé spécifiquement pour mesurer la taille des caractères dans l'imprimerie et sa valeur a évolué à travers les siècles. Avant le mètres, chaque aspect du monde avait sa propre unité de mesure, sans aucune correspondance entre ces différentes unités. L'once, le point, le pied, la lieue, le pouce, autant d'ordres de grandeur différents à travers lesquels voir le monde. Avec l'apparition du système métrique à la fin du XVIIIe siècle (devenu Système International par la suite), la volonté est apparue de pouvoir mesurer l'ensemble des aspects du monde avec un système unique. Du micro-mètre, à l'hectolitre en passant par la mole, le milligramme, l'ampère ou le kelvin, on construit une image cohérente du monde physique. 1 kilogramme d'eau, 1 décimètre cubique d'eau, 1 litre d'eau, autant de manières de dire la même réalité sous deux angles différents : la masse, et le volume, exprimé selon deux unités. Le Millimetre se place dans cet héritage universaliste, utilisable du micron au kilomètre, pour les domaines de la sciences moléculaire ou de l'automobile, il vise à embrasser le monde et n'est pas cantoné au monde du livre qui a vu naitre le point.

#### Principe métrique, grilles et alignement divin
Dans cette typographie, chaque cadratin (un carré de la hauteur du corps) est divisé verticalement et horizontalement en 10 unités (le système décimal, dac ?). Imprimé à un corps d'1cm, les futs du regular feront 1 millimetre d'épaisseur. Autant les espaces blancs que les fut ou traverses se calent sur cette grille. La moitié des lignes et la moitié des colonne de cette grille de 10x10 sont prévus pour recevoir les futs, les courbes et les traverses de la fonte alors que l'autre moitié est prévu pour recevoir les espaces blancs intérieurs aux lettres et entre elles, ce qui rend le rythme du Millimetre unique et totalement réglé, comme un code barre. Pour être encore plus clair, quand on écrit deux m bas-de-casse, l'épaisseur des futs des m sera égale à celle des contreformes entre ses jambes, à celle des courbes et à l'espace entre les deux lettres. Ce dessin contraint, aligné sur un grille pixellaire, permet au  Millimetre de fonctionner décemment à l'écran. Quand on compose du texte avec un interlignage égal à la hauteur du corps, la grille apparait dans l'alignement parfait des futs entre les différentes lignes de texte. Pas besoin d'artifices ni de corrections.

#### Un coup d'œil dans le rétro futur du faux monospace
D'un point de vue stylistique, Millimetre est une linéale construite et géométrique, aux proportions relativement larges même si la structure de certaines lettres pourraient contredire cette généralité. Avec son aspect rectangulaires et ses terminaisons fermées, Millimetre rappelle les linéales des années 60 comme l'Eurostile d'Aldo Novarese. N'essayant pas de fuir cet univers graphique, cette typographie embrasses les connotations retro-futuristes, architecturales, technologiques et science-fictionnelles qui l'accompagnent. À cause de la grille sur laquelle elle est construite, le rythme de cette fonte peut rappeler celui créer par une monospace. Même s'il partage avec cette famille typographique une certaine régularité dans les largeurs de ses glyphes, Millimetre n'est pas une monospace, elle crée son propre gris typo. Si le dessin de cette famille a été commencé sur une base purement monolinéaire, il s'en est finalement éloigné pour devenir plus subtile, avec des jointures plus fines et de petites variations de graisses qui apportent de l'équilibre aux formes. Cela devient évident dans les versions plus grasses du Millimetre où la création de déliés a été nécessaire pour le dessin de certains glyphes, évitant ainsi qu'il n'apparaissent trop gras comparés au reste de la fonte.

#### Du stricto regular aux graisses flexibles
Si le regular ne quitte jamais la grille, les autres graisses s'en éloignent pour gagner en sensibilité tout en gardant leurs rythmes les plus proches possible. Le bold est 1,5 fois plus gras que le regular quand le light aura lui une graisse égale à la moitié celle du regular. Composées ensemble, ces différentes graisses partagent la même grille, ce qui permet de créer des mises-en pages très construites et maitrisées. Le système n'abandonne jamais jamais.

#### Ornementalité techniciste
Enfin, cette famille est accompagnée d'un bel ensemble d'ornements géométriques permettant de créer des motifs dialoguant avec le gris du texte. Ces ornements sont inspirés par les débuts de l'ère informatique et par les mires utilisées dans l'imprimerie. Ils seront utiles pour la créations de documents techniques, de cartes ou pour mettre l'emphase sur la dimension technologique de ces documents graphiques.

#### Ouvrir la grille
Millimetre est une famille typographique libre et open-source encore en développement. Contribuez sur github.

![specimen3](documentation/specimen/web/specimen_millimetre_web3.png)
![specimen4](documentation/specimen/web/specimen_millimetre_web4.png)
![specimen5](documentation/specimen/web/specimen_millimetre_web5.png)
![specimen6](documentation/specimen/web/specimen_millimetre_web6.png)
![specimen7](documentation/specimen/web/specimen_millimetre_web7.png)
![specimen8](documentation/specimen/web/specimen_millimetre_web8.png)
![specimen9](documentation/specimen/web/specimen_millimetre_web9.png)
![specimen10](documentation/specimen/web/specimen_millimetre_web10.png)
![specimen11](documentation/specimen/web/specimen_millimetre_web11.png)
![specimen12](documentation/specimen/web/specimen_millimetre_web12.png)
![specimen13](documentation/specimen/web/specimen_millimetre_web13.png)

## License

Millimetre is licensed under the SIL Open Font License, Version 1.1.
This license is copied below, and is also available with a FAQ at
http://scripts.sil.org/OFL

## Repository Layout

This font repository follows the Unified Font Repository v2.0,
a standard way to organize font project source files. Learn more at
https://github.com/raphaelbastide/Unified-Font-Repository
