#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _
from fenrirscreenreader.utils import line_utils
from fenrirscreenreader.utils import word_utils


class command:
    def __init__(self):
        self.lastIdent = -1

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return ""

    def run(self):
        if not self.env["runtime"]["SettingsManager"].get_setting_as_bool(
            "focus", "cursor"
        ):
            return
        if self.env["runtime"]["ScreenManager"].is_screen_change():
            self.lastIdent = 0
            return

        # is a vertical change?
        if not self.env["runtime"][
            "CursorManager"
        ].is_cursor_horizontal_move():
            return
        x, y, curr_line = line_utils.get_current_line(
            self.env["screen"]["new_cursor"]["x"],
            self.env["screen"]["new_cursor"]["y"],
            self.env["screen"]["new_content_text"],
        )
        curr_ident = self.env["screen"]["new_cursor"]["x"]

        if not curr_line.isspace():
            # ident
            lastIdent, lastY, last_line = line_utils.get_current_line(
                self.env["screen"]["new_cursor"]["x"],
                self.env["screen"]["new_cursor"]["y"],
                self.env["screen"]["old_content_text"],
            )
            if curr_line.strip() != last_line.strip():
                return
            if len(curr_line.lstrip()) == len(last_line.lstrip()):
                return

            curr_ident = len(curr_line) - len(curr_line.lstrip())

            if self.lastIdent == -1:
                self.lastIdent = curr_ident
            if curr_ident <= 0:
                return
        if self.env["runtime"]["SettingsManager"].get_setting_as_bool(
            "general", "autoPresentIndent"
        ):
            if self.env["runtime"]["SettingsManager"].get_setting_as_int(
                "general", "autoPresentIndentMode"
            ) in [0, 1]:
                self.env["runtime"]["OutputManager"].play_frequence(
                    curr_ident * 50, 0.1, interrupt=False
                )
            if self.env["runtime"]["SettingsManager"].get_setting_as_int(
                "general", "autoPresentIndentMode"
            ) in [0, 2]:
                if self.lastIdent != curr_ident:
                    self.env["runtime"]["OutputManager"].present_text(
                        _("indented ") + str(curr_ident) + " ",
                        interrupt=False,
                        flush=False,
                    )
        self.lastIdent = curr_ident

    def set_callback(self, callback):
        pass
