/*****************************************************************************/

/*
 *      epp_firmware.h  -- HDLC packet radio modem for EPP using FPGA utility.
 *
 *      Copyright (C) 1998  Thomas Sailer (sailer@ife.ee.ethz.ch)
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Please note that the GPL allows you to use the driver, NOT the radio.
 *  In order to use the radio, you need a license from the communications
 *  authority of your country.
 *
 */

/*****************************************************************************/
/* automatically generated, do not edit */

#define EPP_FIRMWAREDATE "19990628"

/* firmware */
static const unsigned char epp_firmware[] = {
	0xff, 0x04, 0xe8, 0x8c, 0xf9, 0xde, 0xff, 0xde, 
	0xfd, 0xfd, 0xd7, 0xdb, 0xdf, 0xfd, 0xed, 0x7d, 
	0xef, 0xfe, 0xfe, 0xae, 0x6f, 0xef, 0xfe, 0xfe, 
	0xfe, 0x9b, 0xff, 0xff, 0xaf, 0xff, 0xfd, 0xfb, 
	0xfe, 0xaf, 0xff, 0x7f, 0xfe, 0xd7, 0xff, 0x7f, 
	0xed, 0xff, 0xd7, 0xff, 0x7f, 0xff, 0xe6, 0xff, 
	0xfd, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xbf, 0xb9, 0xff, 0xfc, 0xed, 0xcf, 
	0xff, 0xfe, 0xfc, 0xed, 0xcf, 0x5f, 0xfe, 0xf6, 
	0xe7, 0x6f, 0x7f, 0xfe, 0xf6, 0xe7, 0xef, 0x6f, 
	0xfe, 0xbf, 0x77, 0x5f, 0x7b, 0xfd, 0xb5, 0x77, 
	0x5f, 0x7b, 0xd7, 0xbb, 0xaf, 0xbd, 0xfb, 0xda, 
	0xbb, 0xaf, 0xbd, 0xfb, 0x9b, 0xff, 0x3f, 0xfd, 
	0xf5, 0xd2, 0x5f, 0x2f, 0xfd, 0xf5, 0xd3, 0x9f, 
	0xfe, 0x7a, 0xe9, 0xaf, 0x9f, 0xfe, 0x7a, 0xe9, 
	0xff, 0xc6, 0xff, 0x3f, 0xff, 0xfc, 0xf3, 0xcf, 
	0x3f, 0xff, 0xfc, 0xf3, 0x9e, 0x7f, 0xfe, 0xf9, 
	0xe7, 0x9f, 0x7f, 0xfe, 0xf9, 0xbf, 0xf9, 0xff, 
	0xaf, 0xbf, 0xff, 0xfe, 0xfb, 0xaf, 0xbf, 0xff, 
	0xfa, 0xd7, 0xdf, 0x7f, 0xfd, 0xfd, 0xd7, 0xdf, 
	0x7f, 0xfd, 0x6f, 0xfe, 0xff, 0xba, 0xaf, 0xae, 
	0xfa, 0xfe, 0xfa, 0xaf, 0xae, 0x7f, 0xfd, 0xd7, 
	0xd7, 0x7d, 0x7d, 0xfd, 0xd7, 0xd7, 0x7f, 0x9b, 
	0xff, 0xff, 0xfe, 0xbb, 0xef, 0xbf, 0xff, 0xfe, 
	0xfb, 0xef, 0x7f, 0xff, 0xfd, 0xf7, 0xdf, 0x7f, 
	0xff, 0xfd, 0xf7, 0xff, 0xc6, 0xff, 0xdf, 0x7b, 
	0xff, 0xbd, 0xf7, 0xdd, 0x7f, 0xef, 0xfd, 0xef, 
	0xbf, 0xff, 0xde, 0xfb, 0xef, 0xbf, 0xff, 0xfe, 
	0xbf, 0xf9, 0xff, 0x9f, 0x7f, 0xff, 0xfd, 0xf7, 
	0x9f, 0x7f, 0xff, 0xf9, 0xcf, 0xbf, 0xfb, 0xfc, 
	0xfb, 0xcf, 0xbf, 0xfb, 0xfc, 0x6f, 0xf4, 0xff, 
	0xed, 0xb7, 0xdd, 0x7e, 0xfb, 0xed, 0xb7, 0xdf, 
	0xfe, 0xb6, 0xdb, 0x6f, 0xbf, 0xfd, 0xf6, 0xdb, 
	0x6f, 0xff, 0x9b, 0xff, 0x7f, 0xfe, 0xfd, 0xf7, 
	0xdf, 0x7f, 0xfd, 0x7d, 0xf7, 0xbf, 0xff, 0xfe, 
	0xf3, 0xef, 0xbf, 0xfe, 0xfe, 0xfb, 0xff, 0xe6, 
	0xff, 0xdf, 0x7f, 0xff, 0xfd, 0xf7, 0xdf, 0x7f, 
	0xff, 0xfd, 0xef, 0xbb, 0xff, 0xbe, 0xfb, 0xee, 
	0xbb, 0xff, 0xfe, 0xbf, 0xf9, 0xff, 0xfc, 0xf3, 
	0xce, 0x3b, 0x7f, 0xfc, 0xf3, 0xce, 0x7f, 0xfe, 
	0xf9, 0xe7, 0x9f, 0x7e, 0xfe, 0xf9, 0xe7, 0xf7, 
	0x6f, 0xfe, 0xff, 0xfd, 0xf7, 0xdf, 0x7f, 0xff, 
	0xfd, 0x77, 0xdf, 0xff, 0xfc, 0xfb, 0xee, 0xbf, 
	0xff, 0xfe, 0xfb, 0xef, 0xff, 0x9b, 0xdd, 0xcf, 
	0x3d, 0xff, 0xfc, 0xf3, 0xcf, 0x3f, 0xbf, 0x7c, 
	0xe7, 0x9f, 0x7f, 0xee, 0xf9, 0xe7, 0x9f, 0x7f, 
	0xbe, 0xdd, 0x66, 0xff, 0xef, 0xbf, 0xff, 0xfe, 
	0xfb, 0xef, 0xbf, 0xff, 0xfe, 0xf7, 0xdf, 0x7f, 
	0xff, 0xfd, 0xf7, 0xdf, 0x7f, 0xff, 0xb7, 0xf9, 
	0xf7, 0xfe, 0xfa, 0xef, 0xbc, 0xef, 0xbe, 0xfb, 
	0xef, 0x7f, 0xff, 0xfd, 0xf7, 0xdf, 0x7f, 0xff, 
	0xfd, 0xf7, 0xff, 0x6f, 0xfe, 0xbf, 0x7d, 0xf6, 
	0x5b, 0x67, 0xbf, 0x7d, 0xf6, 0xdb, 0xdf, 0x3e, 
	0xfb, 0xec, 0xb7, 0xdf, 0x3e, 0xfb, 0xed, 0xfd, 
	0x9b, 0xff, 0xff, 0xdf, 0xff, 0xff, 0x9f, 0xff, 
	0xff, 0xfd, 0xf7, 0xfb, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0x7b, 0xff, 0xe6, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xf7, 0xff, 0x7f, 0xff, 0xfe, 
	0xbf, 0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0x7f, 
	0xdf, 0xbf, 0xf9, 0x7f, 0xff, 0xff, 0xff, 0xff, 
	0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6f, 0xfe, 
	0xff, 0xff, 0xff, 0xfd, 0xff, 0xdf, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 
	0xff, 0xff, 0xf7, 0x9b, 0xfe, 0x7f, 0xff, 0xfd, 
	0xf7, 0xdf, 0x7f, 0xfd, 0xf5, 0xf7, 0xbf, 0xef, 
	0xfe, 0xfb, 0xef, 0xbf, 0xff, 0xfe, 0xfb, 0xff, 
	0xe6, 0xff, 0xd3, 0xff, 0xff, 0xff, 0xff, 0xde, 
	0xfb, 0xbf, 0xfc, 0xe5, 0xff, 0xdf, 0xff, 0xf7, 
	0xed, 0xff, 0xdb, 0xff, 0xbf, 0xf9, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xbf, 0xff, 0x7f, 0xef, 0x6f, 
	0xff, 0xff, 0xed, 0xf7, 0xff, 0xfe, 0xff, 0xf7, 
	0xff, 0x6f, 0xfc, 0x7f, 0xff, 0xff, 0xfd, 0xff, 
	0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0x1b, 0xff, 
	0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xe9, 0x7f, 
	0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 
	0xff, 0xff, 0xf7, 0xe6, 0xff, 0xff, 0xff, 0xff, 
	0x7d, 0xcf, 0xff, 0xff, 0xfb, 0xff, 0xff, 0x7b, 
	0xff, 0xff, 0xff, 0xff, 0x7b, 0xff, 0xef, 0xbd, 
	0xf9, 0xff, 0xfa, 0xff, 0xf5, 0xff, 0xff, 0xef, 
	0xff, 0xaf, 0xfb, 0xbf, 0xff, 0xfe, 0xff, 0x7f, 
	0xdd, 0xff, 0xff, 0x7f, 0x6f, 0xfe, 0x7f, 0x7d, 
	0xff, 0xff, 0xff, 0xef, 0xfb, 0xff, 0xdf, 0xfd, 
	0xf7, 0xff, 0xff, 0xff, 0xbf, 0xfc, 0xff, 0xff, 
	0xff, 0x9b, 0xff, 0xff, 0xff, 0xff, 0x5b, 0xff, 
	0x9f, 0xff, 0xff, 0xfe, 0xfb, 0x7f, 0xff, 0xfd, 
	0x77, 0xdf, 0x7f, 0xff, 0xff, 0xff, 0xa6, 0x7f, 
	0x7d, 0xff, 0xff, 0xff, 0xff, 0xeb, 0x6f, 0xff, 
	0xfb, 0xfe, 0xff, 0xff, 0xf5, 0xfe, 0xff, 0xff, 
	0xff, 0xff, 0xbf, 0xf1, 0xff, 0xff, 0xff, 0x7f, 
	0xfd, 0xff, 0xdf, 0xef, 0xff, 0xbd, 0xff, 0xef, 
	0xbf, 0xff, 0xff, 0xcb, 0xef, 0x7f, 0xff, 0x6e, 
	0xea, 0xf7, 0xff, 0xfc, 0xff, 0xf7, 0xff, 0xff, 
	0x7f, 0xff, 0xfe, 0xdf, 0xff, 0x7f, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0x1b, 0xff, 0xff, 0xbf, 
	0xfd, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 
	0xff, 0xe6, 0xff, 0xff, 0x7f, 0xff, 0xfe, 0xfb, 
	0xef, 0x7b, 0xff, 0xff, 0xef, 0xbf, 0xff, 0xfe, 
	0xff, 0xef, 0xbf, 0x7f, 0xff, 0xbf, 0xf9, 0xff, 
	0xff, 0xff, 0xdf, 0xff, 0xfe, 0x7b, 0xed, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xc3, 0xfb, 0x6f, 0xfe, 0xff, 0xef, 0xff, 0xff, 
	0xcf, 0x3f, 0xff, 0xfb, 0xff, 0xfe, 0xf7, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0x9b, 
	0xfe, 0xf9, 0xf3, 0xfb, 0xfa, 0xff, 0xff, 0xbf, 
	0xf6, 0xff, 0xdf, 0xff, 0xff, 0x3f, 0xf5, 0xff, 
	0xff, 0xff, 0xfd, 0xbf, 0x66, 0xff, 0xff, 0xf5, 
	0xbf, 0xfe, 0xff, 0xeb, 0xaf, 0xbf, 0xf7, 0xfd, 
	0xff, 0xff, 0x4b, 0xfd, 0xff, 0xff, 0xff, 0xff, 
	0xb7, 0x49, 0xff, 0xff, 0xbf, 0xa5, 0xff, 0xfc, 
	0x7f, 0xed, 0xb5, 0x67, 0xbf, 0xfc, 0xf2, 0xf9, 
	0xaf, 0xbd, 0xf6, 0xdf, 0xfe, 0x6f, 0xd4, 0xff, 
	0xff, 0xff, 0xeb, 0xdc, 0xbe, 0x9e, 0x3b, 0xeb, 
	0xdc, 0xe7, 0x9d, 0xf7, 0xdf, 0x79, 0xe7, 0xfd, 
	0xff, 0x5f, 0x99, 0xdb, 0xf7, 0xfd, 0xf7, 0xf6, 
	0xff, 0xef, 0xbf, 0x56, 0x5f, 0xdd, 0x6d, 0xfb, 
	0xed, 0xa5, 0xf7, 0xde, 0x7b, 0xcd, 0xee, 0x06, 
	0x7e, 0xfc, 0xff, 0xff, 0x6e, 0xe6, 0xb9, 0xaf, 
	0x9d, 0x73, 0x5d, 0x73, 0xde, 0x79, 0xb9, 0x9c, 
	0x77, 0xde, 0xb1, 0x93, 0x99, 0xff, 0x0f, 0xff, 
	0x7f, 0xff, 0x9e, 0xfe, 0x6f, 0xbb, 0x6d, 0xff, 
	0xf5, 0xd7, 0xff, 0x7e, 0xfd, 0xf5, 0xd7, 0xff, 
	0x66, 0xec, 0xff, 0x57, 0xcf, 0xcf, 0xef, 0xaf, 
	0xff, 0xfa, 0xeb, 0xdf, 0x7f, 0xfd, 0xf5, 0x7f, 
	0x5f, 0x7f, 0xfd, 0xfd, 0xbf, 0x19, 0xf7, 0x7f, 
	0xff, 0xfd, 0xf7, 0xff, 0xf6, 0xdb, 0xcf, 0x3f, 
	0xfb, 0xed, 0xe7, 0x9f, 0xff, 0xff, 0xf9, 0xe7, 
	0xff, 0x77, 0xe6, 0xfd, 0x9f, 0x7f, 0xfe, 0xdd, 
	0xf7, 0xff, 0xfd, 0xff, 0xdf, 0xdf, 0xfe, 0xfb, 
	0xef, 0xf7, 0xff, 0xfe, 0xfb, 0xff, 0xbd, 0xb9, 
	0xfe, 0xe3, 0xcf, 0xb5, 0xd1, 0xfc, 0xfb, 0xee, 
	0xb7, 0xcf, 0x6d, 0xf7, 0xd9, 0x63, 0xbc, 0x2d, 
	0xf6, 0xd9, 0xaf, 0x6e, 0xee, 0xff, 0xff, 0xff, 
	0xfd, 0xf7, 0xff, 0xff, 0xff, 0xfe, 0xf3, 0xbf, 
	0x7f, 0xfe, 0xfb, 0xed, 0xbf, 0x7f, 0xfe, 0x3d, 
	0x9b, 0xf9, 0xff, 0xff, 0xeb, 0xff, 0xfe, 0xff, 
	0xff, 0xff, 0x7f, 0xff, 0xfb, 0xdf, 0xdf, 0x7f, 
	0xff, 0xf7, 0xef, 0xff, 0xef, 0xe6, 0xf6, 0x1f, 
	0x7d, 0xfd, 0xfc, 0xeb, 0xeb, 0xbf, 0xbf, 0x7e, 
	0xf7, 0xd3, 0x6f, 0x2f, 0xf1, 0xf5, 0xd7, 0x7f, 
	0x7f, 0xbb, 0x79, 0xff, 0xef, 0xbf, 0xef, 0xff, 
	0xfe, 0x72, 0xaf, 0x2f, 0xfe, 0xd1, 0xc5, 0x37, 
	0x5f, 0x7c, 0xf1, 0xc5, 0x13, 0x7f, 0x6f, 0xea, 
	0xff, 0xff, 0xff, 0xef, 0xf7, 0xfe, 0xfe, 0xbe, 
	0xef, 0x7f, 0xff, 0xbd, 0xf7, 0xd7, 0x7f, 0xbf, 
	0xfd, 0xf7, 0xff, 0x9b, 0xf6, 0x7f, 0xcf, 0x3f, 
	0xfe, 0xfc, 0xb3, 0x8f, 0x3f, 0xfe, 0xf4, 0xc7, 
	0x1f, 0x7f, 0xe4, 0xf1, 0xc7, 0x1f, 0x7d, 0xfe, 
	0xe6, 0xff, 0xdf, 0x7f, 0xbf, 0xfe, 0xfb, 0xeb, 
	0xbf, 0xbf, 0xff, 0xf7, 0xf7, 0x5f, 0x7f, 0xff, 
	0xfd, 0xf7, 0xff, 0xff, 0xbf, 0x61, 0xff, 0xff, 
	0xdf, 0xaf, 0xbf, 0xfe, 0xfa, 0xef, 0xbf, 0xff, 
	0xfd, 0xf7, 0xd7, 0x7f, 0xff, 0xfd, 0xf7, 0xf7, 
	0xff, 0x6f, 0xfe, 0xdf, 0xf9, 0xef, 0xef, 0xbf, 
	0xbf, 0xfe, 0xeb, 0xbf, 0x7f, 0xfd, 0xf7, 0xdf, 
	0x77, 0xff, 0xfd, 0xf7, 0xdf, 0xff, 0x9b, 0xff, 
	0xff, 0xff, 0xff, 0xfa, 0xeb, 0xaf, 0xff, 0xfe, 
	0xff, 0xf3, 0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 
	0x7f, 0xff, 0xdf, 0xe6, 0xff, 0xff, 0xff, 0xbf, 
	0xfd, 0xf2, 0xd3, 0x2d, 0xbf, 0xff, 0xec, 0xff, 
	0xff, 0x7f, 0xbb, 0xe7, 0xf7, 0xd7, 0xff, 0xbf, 
	0xf9, 0xff, 0x2f, 0xbf, 0xdc, 0x7a, 0xeb, 0xae, 
	0xb7, 0xfe, 0xf2, 0x97, 0x5f, 0x7e, 0xfd, 0xf5, 
	0x97, 0x4d, 0x77, 0xf5, 0x6f, 0x2e, 0xff, 0xff, 
	0xf3, 0xfb, 0x3f, 0xff, 0xf7, 0xef, 0xb7, 0x9f, 
	0xfd, 0xff, 0xff, 0x67, 0xff, 0xff, 0xff, 0xff, 
	0xe7, 0x9b, 0xff, 0x7f, 0x7f, 0xff, 0x7f, 0xe8, 
	0xfb, 0xf6, 0xff, 0xff, 0xfe, 0xf7, 0xff, 0x6f, 
	0xff, 0x7f, 0xf6, 0xdf, 0xff, 0xbf, 0xa6, 0x7d, 
	0xfd, 0xd3, 0xff, 0x9f, 0xdf, 0x7d, 0xff, 0xf5, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 
	0xf7, 0xff, 0xbf, 0xf1, 0xff, 0xff, 0xff, 0xad, 
	0xdf, 0xef, 0xe0, 0x91, 0x3f, 0xff, 0xf3, 0xc9, 
	0xd7, 0x1f, 0x5d, 0xfe, 0xb8, 0x67, 0xff, 0x67, 
	0xfc, 0xff, 0xbf, 0xff, 0xeb, 0xf7, 0x6f, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x6e, 0xff, 
	0xff, 0xff, 0xfe, 0xff, 0x99, 0xf7, 0x7e, 0xff, 
	0x2e, 0xdf, 0xef, 0xfe, 0x7b, 0xfe, 0xfa, 0xdb, 
	0x7f, 0x7f, 0xfd, 0xb7, 0xde, 0x6f, 0xaf, 0xff, 
	0xff, 0x46, 0xef, 0xff, 0x7f, 0xff, 0xdf, 0xf7, 
	0x8b, 0xef, 0x3f, 0xfd, 0xd9, 0xa7, 0x9f, 0x5b, 
	0xfc, 0xe1, 0xc7, 0xdf, 0xfe, 0x9f, 0xb1, 0xdb, 
	0xff, 0xdf, 0xff, 0xff, 0xf9, 0xdf, 0xef, 0xef, 
	0x7f, 0xff, 0xfd, 0xf7, 0xff, 0xff, 0xbf, 0xbf, 
	0xf7, 0xff, 0x6f, 0xfc, 0x7f, 0xff, 0xff, 0xf5, 
	0xff, 0xbf, 0xfb, 0xff, 0x9f, 0xff, 0xbf, 0xff, 
	0xff, 0xe7, 0x9f, 0x3e, 0xfe, 0xfe, 0xff, 0x98, 
	0xff, 0x7f, 0xff, 0xff, 0xfd, 0x7d, 0xef, 0xff, 
	0xcf, 0xff, 0xfe, 0xf7, 0x9f, 0xff, 0xee, 0xbf, 
	0x7f, 0xff, 0xff, 0xef, 0x66, 0x7d, 0xff, 0xff, 
	0xef, 0xfa, 0xf7, 0xed, 0xaf, 0xbf, 0xe6, 0xf5, 
	0xd7, 0x7f, 0xbf, 0xac, 0xf3, 0xce, 0xfb, 0xff, 
	0xbf, 0xf9, 0xf7, 0xd7, 0x6f, 0xbf, 0xff, 0xff, 
	0xbd, 0xcf, 0xfd, 0xfe, 0xdf, 0xef, 0xc7, 0x1f, 
	0x1f, 0xf8, 0xa1, 0x3f, 0xfb, 0x6f, 0xfe, 0xf7, 
	0xff, 0xfb, 0xeb, 0xff, 0xff, 0xff, 0xed, 0xff, 
	0xff, 0xfb, 0xff, 0xff, 0x7f, 0xfd, 0xff, 0xef, 
	0xff, 0xff, 0x1b, 0xfe, 0xaf, 0xfe, 0xc1, 0x0e, 
	0xeb, 0xb5, 0xfe, 0xff, 0xee, 0x77, 0xdf, 0x7d, 
	0x37, 0xdd, 0x74, 0xdf, 0xfd, 0xff, 0x3f, 0x66, 
	0xff, 0x2b, 0xbf, 0xb2, 0xf7, 0x3a, 0xcb, 0xbf, 
	0xff, 0x52, 0xd7, 0x5f, 0x6b, 0xa9, 0xb9, 0xe6, 
	0x9f, 0x7f, 0xff, 0xb7, 0xf9, 0x9f, 0x7f, 0xee, 
	0x6f, 0xa6, 0x9f, 0x7a, 0xea, 0x3d, 0xf5, 0xa9, 
	0xa7, 0x9e, 0x7b, 0xee, 0xa9, 0xa7, 0xba, 0xff, 
	0x6f, 0xd6, 0xff, 0xcf, 0xfa, 0xb3, 0xef, 0xb7, 
	0xde, 0x7a, 0xf9, 0xd5, 0x2e, 0xbf, 0xec, 0xb2, 
	0xcb, 0x2e, 0xbf, 0xdf, 0x5f, 0x9b, 0xfb, 0xaf, 
	0xfd, 0xff, 0xde, 0x4b, 0xa3, 0xad, 0x7e, 0xab, 
	0xdd, 0x6f, 0xb5, 0xdd, 0xf6, 0xda, 0x6c, 0x9d, 
	0xff, 0xef, 0x66, 0xfe, 0xab, 0x3f, 0x9a, 0xfd, 
	0x72, 0xa8, 0xa5, 0xae, 0x6b, 0xdd, 0x70, 0xcd, 
	0x35, 0xd7, 0x1c, 0x73, 0xe3, 0xbd, 0xb3, 0xb1, 
	0xff, 0xef, 0xdf, 0x6f, 0xb6, 0x58, 0x6a, 0xe9, 
	0xef, 0x7f, 0xff, 0xfd, 0xf7, 0xdf, 0x7f, 0xef, 
	0xbd, 0xff, 0xf7, 0x66, 0xee, 0xff, 0xf7, 0xfb, 
	0x5b, 0xeb, 0xb5, 0xd6, 0xfa, 0x6f, 0x75, 0xfb, 
	0xad, 0xb6, 0xdf, 0x7e, 0xfb, 0xad, 0xfe, 0x3a, 
	0x9b, 0xf7, 0x7f, 0xff, 0x6d, 0xb7, 0xdd, 0x72, 
	0xef, 0xff, 0xde, 0xf3, 0xdc, 0x73, 0xcf, 0x3d, 
	0xf7, 0xdc, 0xf3, 0xdf, 0xb7, 0xe6, 0xdd, 0x9f, 
	0x79, 0xff, 0xd9, 0x67, 0x9f, 0xff, 0xb7, 0xfb, 
	0x5d, 0x76, 0xd9, 0x65, 0x97, 0x7d, 0x76, 0x59, 
	0xe7, 0xbd, 0xa1, 0xff, 0xe3, 0x4f, 0x3f, 0xfb, 
	0xb8, 0xe3, 0xef, 0xab, 0x7f, 0xed, 0xf5, 0xd7, 
	0x5f, 0x7f, 0xfd, 0xf5, 0xda, 0xff, 0x66, 0xe6, 
	0xff, 0xff, 0xff, 0xff, 0xf7, 0xdf, 0x7f, 0xff, 
	0x7b, 0xdf, 0x7b, 0xef, 0xbd, 0xf7, 0xde, 0x7b, 
	0xef, 0xbe, 0x3f, 0x9b, 0xfb, 0xff, 0xff, 0xff, 
	0xbf, 0xff, 0xfb, 0xef, 0xff, 0xfe, 0xb7, 0xdf, 
	0x7e, 0xfb, 0xed, 0xb7, 0xdf, 0xde, 0xff, 0xef, 
	0xa6, 0xfe, 0x1d, 0x2f, 0xff, 0x71, 0xe2, 0x1f, 
	0xaf, 0xff, 0x77, 0xbd, 0xf7, 0xde, 0x7b, 0xef, 
	0xbd, 0xf7, 0xde, 0xfb, 0xab, 0x79, 0xff, 0xe7, 
	0xeb, 0x7d, 0xb2, 0xf8, 0xe6, 0xcb, 0x77, 0x5a, 
	0xd3, 0x4c, 0x37, 0xdd, 0x74, 0xb3, 0x4c, 0x1e, 
	0x7f, 0x6f, 0xfe, 0xbf, 0xfc, 0xfa, 0xbb, 0xef, 
	0xfb, 0xfb, 0xfa, 0xfd, 0x7f, 0xff, 0xfd, 0xf6, 
	0xdf, 0x6b, 0xef, 0xbd, 0xf7, 0xff, 0x9b, 0xff, 
	0xaf, 0x83, 0x1e, 0x7e, 0xcc, 0xe3, 0xc3, 0x3f, 
	0x3f, 0xdc, 0x61, 0x87, 0x1d, 0x76, 0xd9, 0x61, 
	0x17, 0x7f, 0xfe, 0xe6, 0xff, 0x9f, 0xaf, 0xff, 
	0xfd, 0xf2, 0xff, 0x2f, 0xbf, 0xfe, 0xf7, 0xdf, 
	0x7f, 0xff, 0xfd, 0xf7, 0xdf, 0x7f, 0xff, 0xbf, 
	0xf9, 0xff, 0x7f, 0xe9, 0x77, 0x9f, 0xfe, 0xba, 
	0xe9, 0xaf, 0xd7, 0xdd, 0xf6, 0xda, 0x6b, 0x9f, 
	0xfd, 0xf6, 0xf3, 0xef, 0x6f, 0xf6, 0xbf, 0xaa, 
	0x7a, 0xbe, 0x29, 0xfe, 0x9b, 0xf2, 0xab, 0xda, 
	0x4d, 0x57, 0x5d, 0x75, 0xdd, 0x45, 0x57, 0xdd, 
	0xfd, 0x9b, 0xff, 0xaf, 0x87, 0x0f, 0x3f, 0xe8, 
	0xaf, 0xcb, 0xfd, 0x7a, 0xf4, 0xc5, 0x0f, 0x3f, 
	0xfc, 0xf2, 0xc1, 0x87, 0x1d, 0xfe, 0xe6, 0xff, 
	0xff, 0x2f, 0xbf, 0xfc, 0x76, 0xbb, 0x3f, 0xfe, 
	0xff, 0xfe, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xdf, 0xef, 0xbf, 0xe9, 0xff, 0xa7, 0xb7, 0xfa, 
	0xda, 0xeb, 0xae, 0xbf, 0xf6, 0xd8, 0x47, 0x1f, 
	0x7f, 0xf5, 0xf5, 0x57, 0x5f, 0x76, 0xfd, 0x69, 
	0xfe, 0xff, 0xfc, 0xfb, 0xc5, 0x0e, 0xff, 0xef, 
	0xcb, 0x4f, 0x7f, 0xea, 0xf9, 0xe7, 0xfd, 0xf3, 
	0xf7, 0xdf, 0xef, 0xff, 0x1b, 0xff, 0x96, 0xdb, 
	0xef, 0xb9, 0xea, 0x75, 0xdb, 0xbb, 0xea, 0xf7, 
	0x5f, 0x7d, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 
	0x7f, 0x66, 0xff, 0x7e, 0xd7, 0xf7, 0x7b, 0xdf, 
	0xff, 0xbf, 0xfd, 0xef, 0xf7, 0xff, 0x7d, 0xbf, 
	0xef, 0xbf, 0xff, 0xef, 0xff, 0xbf, 0xf9, 0xff, 
	0xff, 0x6b, 0x67, 0xf7, 0x9c, 0xfb, 0xfe, 0xad, 
	0x73, 0xfe, 0xf5, 0xd7, 0x53, 0x5f, 0xf9, 0xf9, 
	0x97, 0xfb, 0x6f, 0xfe, 0xff, 0xaf, 0x7b, 0xdf, 
	0xef, 0x7f, 0xdb, 0xff, 0xdf, 0xff, 0xff, 0xfb, 
	0x6f, 0xbf, 0xff, 0xfe, 0xff, 0xeb, 0xff, 0x9b, 
	0xff, 0xff, 0xbf, 0xff, 0xfb, 0xef, 0x97, 0xff, 
	0x75, 0xfe, 0xfd, 0xcd, 0x3b, 0xff, 0xb1, 0xf3, 
	0xff, 0xfb, 0xff, 0xff, 0xe6, 0xbf, 0xfb, 0x2f, 
	0x7f, 0xff, 0xf7, 0xeb, 0xfe, 0xff, 0xf7, 0xef, 
	0xff, 0xf7, 0xfe, 0xf3, 0xbf, 0xfc, 0xfb, 0xf7, 
	0xbf, 0xb9, 0xdf, 0xfb, 0xff, 0xff, 0xf7, 0xfd, 
	0x5f, 0xbf, 0xfd, 0xbf, 0xff, 0xff, 0xff, 0xff, 
	0xab, 0xff, 0xdf, 0xff, 0xf7, 0x6b, 0xfe, 0x3f, 
	0xee, 0xef, 0xf3, 0xfe, 0x37, 0xfe, 0xbf, 0xff, 
	0x9e, 0x7f, 0xfe, 0x59, 0xff, 0x1f, 0x7d, 0xe4, 
	0xf1, 0xfe, 0x9b, 0xff, 0x7f, 0xe7, 0x5f, 0xcb, 
	0xfe, 0xbf, 0xfe, 0xff, 0xff, 0xbf, 0xff, 0xdc, 
	0xfb, 0xde, 0xdf, 0xff, 0xfe, 0xf6, 0xfe, 0x66, 
	0xfe, 0x7f, 0xaf, 0x7f, 0xce, 0xf2, 0xad, 0xfb, 
	0xdf, 0x7f, 0xfb, 0xeb, 0xbf, 0x3d, 0xfd, 0xdf, 
	0xfb, 0xfd, 0xff, 0xbf, 0xb1, 0x6f, 0xff, 0xaf, 
	0x93, 0x9f, 0x72, 0xed, 0x6f, 0xff, 0xf9, 0xef, 
	0xff, 0xff, 0x6f, 0xde, 0x7f, 0xff, 0xff, 0x7f, 
	0x65, 0x7e, 0xff, 0xff, 0xfd, 0xf7, 0xf7, 0xff, 
	0xff, 0xfb, 0xff, 0xff, 0xff, 0xef, 0xff, 0xef, 
	0xff, 0xff, 0xff, 0xdf, 0xff, 0x9b, 0xf2, 0x7f, 
	0xfe, 0xf1, 0x6f, 0xf9, 0xa9, 0xbf, 0x5e, 0x6f, 
	0x7e, 0xf3, 0xad, 0xf7, 0xf5, 0x5c, 0xf2, 0xe5, 
	0xff, 0xbf, 0x66, 0xff, 0xcf, 0xff, 0xbe, 0x5b, 
	0xff, 0xfb, 0xaf, 0xd7, 0x9f, 0xef, 0xbc, 0xf9, 
	0x7e, 0x3d, 0x2d, 0xbe, 0xff, 0xff, 0xb7, 0xc9, 
	0x9f, 0x5b, 0x7e, 0xa5, 0xb3, 0x9e, 0xfa, 0xeb, 
	0x7f, 0xfe, 0xfb, 0xef, 0xbf, 0x5f, 0xfa, 0xf9, 
	0xef, 0xff, 0xff, 0x6f, 0xd4, 0x37, 0x9f, 0x7f, 
	0xeb, 0xef, 0xa7, 0xff, 0xfa, 0xff, 0xff, 0xff, 
	0xff, 0xef, 0x46, 0xdf, 0xfd, 0xf7, 0xff, 0x5f, 
	0x99, 0xfb, 0xf1, 0xd7, 0xbd, 0xdf, 0x5f, 0x65, 
	0xfd, 0xff, 0xcf, 0x7f, 0xfe, 0xf9, 0x6f, 0xaf, 
	0xda, 0xec, 0xfb, 0xef, 0xef, 0x06, 0xfe, 0xbf, 
	0x76, 0xfe, 0xfb, 0xa7, 0x59, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xcf, 0xdc, 0xff, 0xff, 
	0xff, 0x93, 0x99, 0xff, 0x7a, 0xdf, 0xac, 0xff, 
	0xc8, 0xd2, 0xff, 0xff, 0xd7, 0xbf, 0xfe, 0xfa, 
	0x79, 0xe3, 0xfd, 0xff, 0x7f, 0xeb, 0x66, 0xec, 
	0xbf, 0x1f, 0x7b, 0x29, 0x6c, 0x97, 0xfd, 0xff, 
	0x3f, 0xfc, 0xe1, 0x87, 0x9f, 0xf7, 0xd9, 0xe9, 
	0xa7, 0xbf, 0xba, 0x19, 0xf7, 0xfe, 0xff, 0x6f, 
	0xb7, 0xdd, 0x7e, 0xdb, 0xff, 0xd7, 0xbb, 0xfe, 
	0xf2, 0xeb, 0xff, 0xbf, 0xf6, 0xda, 0xeb, 0x77, 
	0xe6, 0x7d, 0xfd, 0x7d, 0xf7, 0xd9, 0xef, 0x7d, 
	0xff, 0xe6, 0xf9, 0xcf, 0x3f, 0xe3, 0xfc, 0xa3, 
	0xcf, 0x3f, 0xff, 0xfc, 0xbd, 0xb9, 0xee, 0xfb, 
	0xce, 0x31, 0xcf, 0xf8, 0x7b, 0xed, 0x3f, 0xff, 
	0xf9, 0xe7, 0x9f, 0x6f, 0xdc, 0xf9, 0xe7, 0x1f, 
	0xab, 0x6e, 0xee, 0xdf, 0xff, 0xff, 0xfd, 0xf6, 
	0xdf, 0xff, 0xef, 0x7f, 0xff, 0xfb, 0xef, 0x3f, 
	0xfb, 0xff, 0xfb, 0xef, 0xbf, 0x3b, 0x9b, 0xf9, 
	0xfb, 0xff, 0xbf, 0xef, 0xfe, 0xfd, 0xff, 0xff, 
	0xef, 0x7f, 0xff, 0xfd, 0xb7, 0xff, 0x7f, 0xff, 
	0xfd, 0xbf, 0xef, 0xe6, 0xf6, 0x9f, 0xef, 0xfe, 
	0xd0, 0xe2, 0x9d, 0xff, 0xfd, 0xf1, 0x8f, 0x17, 
	0xfe, 0x38, 0xf1, 0x8f, 0x3e, 0xfe, 0x78, 0xbb, 
	0x61, 0x7f, 0xff, 0xfb, 0x7d, 0xfe, 0xfa, 0x63, 
	0xbf, 0xfe, 0xfe, 0xf7, 0xc5, 0x7f, 0x4f, 0xfc, 
	0xf7, 0xdf, 0x7f, 0x7f, 0x6f, 0xfe, 0xff, 0xeb, 
	0xea, 0xcd, 0xee, 0xfb, 0xfd, 0xbf, 0xdf, 0xff, 
	0xff, 0xff, 0xdf, 0x57, 0xff, 0xfd, 0xf7, 0xff, 
	0xff, 0x9b, 0xff, 0xff, 0x8f, 0x3e, 0xfe, 0xcc, 
	0xf3, 0xcf, 0x3f, 0x3f, 0xbc, 0xe1, 0x86, 0x1f, 
	0xfe, 0xf9, 0xe5, 0x8f, 0x1b, 0xfe, 0xe6, 0xff, 
	0xfb, 0xef, 0xff, 0xf8, 0xe2, 0xff, 0xff, 0xff, 
	0xfd, 0xef, 0x97, 0xff, 0x7e, 0xfd, 0xff, 0xff, 
	0xff, 0xfe, 0xbf, 0xf9, 0xff, 0xfb, 0xfb, 0xff, 
	0xff, 0xfe, 0xff, 0xff, 0xff, 0xdb, 0xbf, 0x74, 
	0xfb, 0x4d, 0xbf, 0xff, 0xfe, 0xfb, 0xed, 0x6f, 
	0xfe, 0xff, 0xff, 0xfe, 0xbf, 0xef, 0xfe, 0xfb, 
	0xef, 0x9f, 0xf9, 0xd4, 0x33, 0xcf, 0x54, 0xff, 
	0xd5, 0x37, 0xcf, 0xfc, 0x1b, 0xfe, 0xfe, 0xbf, 
	0xff, 0xff, 0xef, 0x7f, 0xbf, 0xff, 0xbf, 0xfc, 
	0xe3, 0x97, 0x5f, 0xfe, 0xfb, 0xe1, 0x87, 0x5f, 
	0xfe, 0x66, 0xff, 0xdb, 0x7b, 0xbf, 0xfd, 0xc2, 
	0xcf, 0xff, 0xff, 0xbf, 0xfe, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xf9, 0xbf, 
	0xad, 0xbe, 0xfa, 0x72, 0xcb, 0xaf, 0x9f, 0xfe, 
	0xfa, 0xd7, 0x5f, 0x7f, 0xfd, 0xe5, 0x97, 0x5f, 
	0x7f, 0xfc, 0x6f, 0x3e, 0x9f, 0xef, 0xb2, 0xe3, 
	0xff, 0xff, 0xef, 0xbf, 0xcd, 0x7f, 0xb6, 0xf9, 
	0xe6, 0xbb, 0x7f, 0xf6, 0xd9, 0xf7, 0xfb, 0x9b, 
	0xff, 0xff, 0xbf, 0xab, 0xb3, 0xfd, 0xf7, 0xfe, 
	0x77, 0xfa, 0xcd, 0x2f, 0x3f, 0xbd, 0xfd, 0xdf, 
	0x78, 0xb7, 0xff, 0x7f, 0xe6, 0xff, 0x7f, 0xdf, 
	0xf5, 0xfd, 0xdf, 0xfd, 0xf7, 0xff, 0xf5, 0xff, 
	0xff, 0xfe, 0xff, 0xfb, 0xfd, 0xf7, 0x7f, 0xff, 
	0x97, 0xf1, 0xff, 0xbb, 0x2a, 0xb7, 0xff, 0xf9, 
	0xfc, 0x63, 0x7f, 0xf7, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0x67, 0xf8, 0xbf, 
	0x77, 0xf7, 0xfb, 0xfb, 0xeb, 0xff, 0xed, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xfb, 0x99, 0x75, 0x7f, 0xbd, 0xef, 0xfb, 
	0xef, 0xff, 0xfb, 0xfa, 0xbf, 0xfb, 0xff, 0xf7, 
	0xff, 0xfe, 0xff, 0x7f, 0xf7, 0xdf, 0x7f, 0xc6, 
	0xff, 0xbf, 0x6f, 0x2f, 0xfd, 0xbf, 0xfd, 0x49, 
	0xfd, 0xfd, 0xce, 0xfe, 0xff, 0xfe, 0xff, 0xff, 
	0xe7, 0xef, 0xdf, 0xbf, 0xb1, 0xcd, 0xff, 0xba, 
	0xee, 0xf7, 0x7d, 0xcf, 0xfb, 0xfd, 0xff, 0xff, 
	0xff, 0xff, 0xf3, 0xf7, 0xff, 0xf7, 0xff, 0xff, 
	0x6f, 0xfc, 0x3f, 0xeb, 0xff, 0xff, 0x8f, 0xff, 
	0xdf, 0xff, 0xf3, 0x9e, 0x77, 0xfe, 0x79, 0x07, 
	0x9b, 0x6f, 0xfe, 0xb9, 0xff, 0x9b, 0xfb, 0x6f, 
	0xff, 0xff, 0xff, 0xf7, 0xff, 0xef, 0x3f, 0xf7, 
	0xe4, 0xe7, 0xfc, 0xfb, 0xef, 0xbf, 0xff, 0xfa, 
	0xfb, 0xef, 0xe6, 0xdf, 0xdf, 0xbe, 0xd7, 0xce, 
	0x77, 0xff, 0xaf, 0x73, 0xcf, 0x7f, 0xef, 0xbf, 
	0xff, 0xf7, 0x7b, 0xeb, 0xbf, 0x9f, 0xbf, 0xf9, 
	0xf7, 0xff, 0x7f, 0xdb, 0x9d, 0xbe, 0xd7, 0xcf, 
	0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 
	0xdf, 0xff, 0xff, 0x6f, 0xf6, 0xff, 0xff, 0x9e, 
	0xff, 0xff, 0xfe, 0x7f, 0xdd, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0x7f, 0xff, 0xfd, 0xff, 0xff, 0xff, 
	0x1b, 0xfe, 0xff, 0xb1, 0x9b, 0xea, 0xbf, 0xbc, 
	0xfe, 0xcf, 0x2f, 0x7f, 0xf3, 0xad, 0x37, 0xdf, 
	0x7c, 0xf3, 0xe5, 0xf7, 0x3f, 0x66, 0xff, 0xff, 
	0xe5, 0x97, 0xf7, 0x2f, 0x6f, 0xef, 0xff, 0xcd, 
	0xff, 0xbf, 0xf9, 0xce, 0xbf, 0xee, 0xbf, 0xff, 
	0xfe, 0xb7, 0xf9, 0xff, 0xff, 0xab, 0xac, 0xd6, 
	0xf7, 0x6b, 0xfe, 0x7f, 0xff, 0xf3, 0xef, 0xbf, 
	0xff, 0xfc, 0xfb, 0xef, 0xbf, 0xff, 0x6f, 0xd6, 
	0xff, 0xff, 0x7e, 0xfa, 0xff, 0xff, 0xde, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xef, 0x7f, 0xff, 0xfe, 
	0xf7, 0xdf, 0x5f, 0x9b, 0xfb, 0xff, 0xfd, 0x57, 
	0x92, 0xf9, 0xbf, 0xed, 0x6f, 0xcf, 0x7f, 0xfe, 
	0xf9, 0xef, 0xbf, 0xff, 0x5e, 0xfb, 0xef, 0xef, 
	0x66, 0xfe, 0xff, 0xff, 0x9e, 0x7b, 0xaf, 0xad, 
	0xff, 0xd7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0x57, 0xff, 0xff, 0xb3, 0xb1, 0xff, 0x3f, 
	0x7f, 0xe1, 0xef, 0xff, 0x6b, 0x7d, 0xff, 0xd6, 
	0xb7, 0xde, 0x7a, 0xf9, 0xfb, 0xff, 0xf5, 0xff, 
	0xff, 0x66, 0xee, 0xff, 0x53, 0x6f, 0x19, 0xff, 
	0xff, 0xc6, 0xff, 0x7f, 0xfc, 0xe3, 0x8f, 0xbf, 
	0x7f, 0xf8, 0x69, 0x85, 0x9f, 0xbf, 0x9b, 0xf7, 
	0x7f, 0xff, 0x6d, 0xf7, 0xff, 0x76, 0xff, 0x6f, 
	0xd7, 0xbb, 0xfe, 0xfa, 0xeb, 0xaf, 0xbf, 0xf6, 
	0xfa, 0xeb, 0xf7, 0xe6, 0xfd, 0x9f, 0x7f, 0xe6, 
	0x9b, 0x6f, 0x9e, 0xff, 0xf4, 0xf9, 0xcf, 0x3f, 
	0xff, 0xfc, 0xf3, 0xcf, 0x3f, 0xff, 0xfc, 0xbd, 
	0xa1, 0xff, 0xf3, 0xcd, 0xb5, 0xdf, 0xfe, 0xe3, 
	0xef, 0x3e, 0xfe, 0xf1, 0xc7, 0x1f, 0x7f, 0xfe, 
	0xf9, 0xe7, 0x9f, 0xff, 0x66, 0xe6, 0xff, 0x6f, 
	0xff, 0xfd, 0xf6, 0xff, 0x7f, 0xff, 0x7f, 0xff, 
	0xfb, 0xef, 0xbf, 0xff, 0xfe, 0xfb, 0xef, 0xbf, 
	0x3f, 0x9b, 0x7b, 0xff, 0xf6, 0xbb, 0xef, 0xbe, 
	0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xdf, 0x7f, 0xff, 0xfd, 0xf7, 0xef, 0xa6, 0x7e, 
	0x5f, 0x2f, 0x9d, 0xf4, 0xda, 0x1d, 0xff, 0xff, 
	0xf1, 0x85, 0x3f, 0xfe, 0xf8, 0xe3, 0x8f, 0x3f, 
	0xfe, 0xf8, 0xab, 0x79, 0xff, 0xef, 0x8b, 0x7f, 
	0xbe, 0xfa, 0xe7, 0xaf, 0xfe, 0x7e, 0xf1, 0xdf, 
	0x7f, 0xff, 0xfd, 0xf7, 0xdf, 0x7f, 0x7f, 0x6f, 
	0xfe, 0xff, 0xdf, 0xba, 0xeb, 0xaf, 0xff, 0xdb, 
	0xfa, 0xff, 0x5f, 0xfe, 0xff, 0xdf, 0xbe, 0xff, 
	0xfd, 0xff, 0xff, 0xff, 0x9b, 0xff, 0xff, 0x8b, 
	0x1e, 0x3f, 0xe8, 0xf3, 0x8b, 0x1e, 0x37, 0xd4, 
	0xe1, 0x86, 0x1f, 0xfe, 0xf9, 0xe1, 0x86, 0x1b, 
	0xfe, 0xe6, 0xff, 0xdf, 0x2f, 0xfe, 0xfd, 0xf3, 
	0xcb, 0xef, 0xdf, 0xfd, 0xef, 0xbf, 0xff, 0xfe, 
	0xf3, 0xef, 0x3f, 0xff, 0xfc, 0xbf, 0xf9, 0xff, 
	0xf7, 0xe9, 0xa7, 0x97, 0xfd, 0xfa, 0xed, 0xfd, 
	0xd7, 0xdf, 0xfe, 0xfa, 0xeb, 0xbf, 0xdf, 0x7e, 
	0xfb, 0xeb, 0x6f, 0xfe, 0xff, 0xab, 0x6e, 0x9e, 
	0xaa, 0xbe, 0xa8, 0xea, 0x9f, 0xfa, 0xcc, 0x53, 
	0x4f, 0x7d, 0xff, 0xcc, 0x37, 0x5f, 0xfd, 0x9b, 
	0xfd, 0xff, 0x83, 0x0e, 0x7a, 0xf8, 0xaf, 0x83, 
	0xde, 0x7f, 0xfc, 0xe5, 0x8f, 0x3f, 0xfe, 0xfb, 
	0xe5, 0x97, 0x3f, 0xfe, 0xe6, 0xff, 0xff, 0x6f, 
	0xbe, 0xdc, 0xd6, 0xfb, 0x6f, 0xfd, 0xff, 0xfe, 
	0xfd, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xfb, 
	0xbf, 0xe9, 0xbf, 0xaf, 0x3f, 0xde, 0x72, 0xc9, 
	0x2e, 0xbf, 0xf6, 0xba, 0xd7, 0x5f, 0x7f, 0xfd, 
	0xf5, 0xd7, 0x5f, 0x7d, 0xfd, 0x6b, 0xf6, 0xff, 
	0x6c, 0xd0, 0xed, 0xa6, 0xef, 0xfd, 0xfc, 0xcf, 
	0x7f, 0xf6, 0xfd, 0xb7, 0x9f, 0x7f, 0xf7, 0xdb, 
	0xef, 0xff, 0x1b, 0xef, 0x9f, 0xf7, 0xfb, 0xb7, 
	0x6f, 0xe7, 0xdf, 0xff, 0xdd, 0x6f, 0xff, 0xff, 
	0xff, 0xed, 0xfd, 0xbf, 0xff, 0xfe, 0x7f, 0xe6, 
	0xff, 0xff, 0xae, 0x5f, 0x6f, 0xff, 0xdf, 0xff, 
	0x7f, 0xdb, 0xd7, 0xef, 0x7e, 0xff, 0xfe, 0xf7, 
	0xbb, 0xef, 0xff, 0xbf, 0xc9, 0xff, 0xff, 0xde, 
	0xef, 0x3f, 0xfe, 0xea, 0xef, 0xff, 0x77, 0xf8, 
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0x6d, 0xfe, 0xdf, 0xff, 0x7f, 0xef, 0xfb, 0x6b, 
	0xbe, 0xfe, 0xff, 0xf7, 0xff, 0xff, 0xdf, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0x9b, 0xff, 0xff, 
	0xff, 0xff, 0xbb, 0xeb, 0xff, 0xfd, 0xbf, 0xd7, 
	0xf7, 0xfd, 0xfe, 0xff, 0xff, 0xfd, 0xfd, 0xf7, 
	0xef, 0xff, 0x66, 0xfd, 0xff, 0xff, 0xf5, 0xbf, 
	0xfe, 0xab, 0x7e, 0xff, 0xff, 0xee, 0xfb, 0xfb, 
	0xfe, 0xfb, 0xef, 0xbd, 0xff, 0xff, 0xb7, 0xf9, 
	0xbf, 0x7f, 0xff, 0x7e, 0xde, 0xec, 0xdf, 0xff, 
	0xfd, 0xff, 0xff, 0xbf, 0xff, 0xff, 0xff, 0x7f, 
	0xff, 0xff, 0xff, 0x6e, 0xfe, 0xff, 0xef, 0xf7, 
	0xff, 0x5b, 0xff, 0x7b, 0xff, 0xd3, 0x9e, 0x77, 
	0xde, 0x79, 0xff, 0x9f, 0x5f, 0xfe, 0xf9, 0xff, 
	0x9b, 0xff, 0xff, 0xfd, 0xbf, 0xff, 0xef, 0xfd, 
	0xfb, 0xff, 0xfb, 0xdf, 0x7f, 0xff, 0xfd, 0xff, 
	0xdf, 0x77, 0xbf, 0xfd, 0xff, 0xe6, 0xfe, 0xdf, 
	0xfd, 0xef, 0xff, 0xff, 0xef, 0x7f, 0x5f, 0x7f, 
	0xfb, 0xeb, 0xbf, 0xff, 0xff, 0xfb, 0xef, 0xbf, 
	0xbf, 0xbf, 0xf1, 0xff, 0xff, 0xff, 0xfb, 0xfe, 
	0x7f, 0xd3, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x67, 0x6e, 
	0xff, 0xff, 0xef, 0xff, 0xff, 0xb6, 0xfe, 0xff, 
	0xff, 0xff, 0xff, 0xdf, 0xbf, 0xff, 0xff, 0xeb, 
	0xff, 0xff, 0xfb, 0x9b, 0xfe, 0xf5, 0xff, 0xf6, 
	0x2e, 0xab, 0xaf, 0xa6, 0x5e, 0x6f, 0x7e, 0xf3, 
	0xcd, 0xf7, 0xc5, 0x5f, 0xf3, 0xcd, 0xf7, 0xbf, 
	0x66, 0x7f, 0xfe, 0xef, 0xff, 0x5a, 0xf2, 0xab, 
	0xaf, 0xe7, 0x9d, 0xef, 0xbc, 0xf3, 0x7e, 0x35, 
	0xad, 0xbc, 0xf9, 0xfe, 0xb7, 0x49, 0xff, 0x7f, 
	0xfd, 0xef, 0x97, 0xfe, 0xfa, 0xcb, 0x25, 0x67, 
	0xf9, 0xef, 0xbf, 0x5f, 0xff, 0xf9, 0xef, 0xbf, 
	0xeb, 0x6f, 0xd4, 0xff, 0x9f, 0x7f, 0xff, 0xaf, 
	0xbf, 0xfe, 0xf0, 0xab, 0x5c, 0xfd, 0xf7, 0xdf, 
	0xd7, 0xdf, 0xfe, 0xf7, 0xdf, 0x5e, 0x99, 0xfb, 
	0xf5, 0xfd, 0xbe, 0xde, 0x69, 0xf5, 0xff, 0xf5, 
	0xdf, 0xff, 0xfe, 0xfb, 0xef, 0xf5, 0xdf, 0xec, 
	0xfb, 0x6f, 0x6f, 0x06, 0xfe, 0xff, 0xef, 0xff, 
	0xba, 0xea, 0xbd, 0x7f, 0xff, 0xfb, 0xdf, 0xff, 
	0xff, 0x7f, 0xf5, 0xdd, 0xfb, 0xff, 0xff, 0xb3, 
	0x99, 0xff, 0x2f, 0xff, 0xef, 0xbf, 0xba, 0x5f, 
	0x5f, 0xad, 0x76, 0xb5, 0x5f, 0x7e, 0x59, 0xff, 
	0x7d, 0xff, 0xff, 0xff, 0x66, 0xec, 0xff, 0x57, 
	0xff, 0x2f, 0xaf, 0xfd, 0x1f, 0x27, 0x6a, 0x5b, 
	0xdb, 0xaf, 0xbf, 0xd7, 0xdf, 0xe9, 0xa7, 0x9e, 
	0x3e, 0x1a, 0xf7, 0x7e, 0xff, 0xcf, 0xb7, 0xdf, 
	0xff, 0xff, 0xef, 0xd7, 0xbb, 0xfe, 0xda, 0xeb, 
	0xff, 0xbf, 0xf6, 0xfa, 0x6b, 0x77, 0xe6, 0x7d, 
	0x9d, 0xff, 0xe6, 0x59, 0xe7, 0x3f, 0x7f, 0xc4, 
	0xf9, 0xcf, 0x3f, 0xff, 0xfc, 0xff, 0xcf, 0x3f, 
	0xff, 0xfc, 0x9d, 0xa9, 0xee, 0xe3, 0xed, 0x35, 
	0xef, 0xf8, 0xfb, 0xef, 0x3f, 0xfe, 0xf1, 0xc7, 
	0x1f, 0x7f, 0xff, 0xf9, 0xe7, 0x9f, 0xff, 0x64, 
	0xee, 0xff, 0xbf, 0xff, 0xfd, 0xff, 0xdf, 0x7f, 
	0xff, 0x7d, 0xff, 0xfb, 0xef, 0xbf, 0xff, 0xff, 
	0xfb, 0xef, 0xbf, 0x3f, 0x9b, 0xf9, 0xff, 0xff, 
	0xef, 0xef, 0xff, 0xfd, 0xf6, 0xbf, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xfd, 0xf7, 
	0xef, 0xe6, 0xf6, 0x5f, 0xef, 0xff, 0xf0, 0xc7, 
	0x6f, 0xff, 0xde, 0xf0, 0x8f, 0x3f, 0xfe, 0xf8, 
	0xff, 0x8f, 0x3f, 0xfe, 0xf8, 0xbb, 0x61, 0xff, 
	0xef, 0xaf, 0x3c, 0xfe, 0xf9, 0xef, 0x9f, 0x6e, 
	0xfe, 0xf7, 0xdf, 0x7f, 0xff, 0xff, 0xf7, 0xdf, 
	0x7f, 0x7f, 0x6f, 0xfa, 0xf7, 0xff, 0xff, 0xab, 
	0xff, 0xff, 0xfe, 0xef, 0xef, 0xff, 0xff, 0xff, 
	0xdf, 0xff, 0xfd, 0xfd, 0xff, 0xdf, 0xff, 0x9b, 
	0xfe, 0xff, 0xcf, 0x3f, 0xfa, 0xdc, 0xf0, 0xcf, 
	0x2f, 0x36, 0xbc, 0xe1, 0x86, 0x1f, 0xfe, 0xf8, 
	0xe1, 0x86, 0x1f, 0xfe, 0xe6, 0xff, 0xff, 0xef, 
	0xff, 0xff, 0xb2, 0x8d, 0xff, 0xff, 0xf8, 0xcf, 
	0x3f, 0xff, 0xff, 0xbf, 0xef, 0x3f, 0xff, 0xff, 
	0xbf, 0xe1, 0xff, 0xff, 0xef, 0xbf, 0xbf, 0xbe, 
	0xff, 0xff, 0xea, 0xd7, 0xdf, 0xfe, 0xfa, 0xeb, 
	0xbf, 0xdf, 0x7e, 0xfb, 0xeb, 0x6f, 0xfe, 0xff, 
	0xfb, 0xef, 0xab, 0x2f, 0xf6, 0xfa, 0xeb, 0xaf, 
	0xfa, 0xcd, 0x57, 0x5f, 0xfd, 0xff, 0xcc, 0x37, 
	0x5f, 0xfd, 0x9b, 0xfb, 0xff, 0xff, 0xff, 0xfa, 
	0xeb, 0xff, 0xbf, 0xef, 0x7e, 0xfc, 0xe5, 0x8f, 
	0x3f, 0xfe, 0xfb, 0xe5, 0x97, 0x3f, 0xfe, 0xe6, 
	0xff, 0xff, 0xfd, 0xbc, 0xbf, 0xf6, 0xff, 0xff, 
	0xfe, 0xf7, 0xfe, 0xff, 0xf6, 0xfd, 0xff, 0x9f, 
	0x7d, 0xff, 0xff, 0xbf, 0xf9, 0xff, 0x2f, 0xbf, 
	0xde, 0x90, 0xa9, 0xaf, 0xbe, 0xfe, 0xba, 0x17, 
	0x5f, 0x7f, 0xfc, 0xf5, 0xd7, 0x5f, 0x7f, 0xfd, 
	0x6f, 0x3e, 0xff, 0xfc, 0xff, 0x6f, 0xaf, 0xfb, 
	0xfa, 0xaf, 0xef, 0xf7, 0xf6, 0xfd, 0xef, 0xdf, 
	0x7f, 0xbf, 0xdd, 0xef, 0xff, 0x9b, 0xff, 0x1f, 
	0xf7, 0xcf, 0xf3, 0xfd, 0xbe, 0xff, 0xab, 0x3f, 
	0xf7, 0xfd, 0x67, 0xdf, 0x7e, 0xfd, 0xfb, 0x3f, 
	0xff, 0x7f, 0x66, 0x7f, 0xdf, 0xf7, 0xf4, 0xef, 
	0xdb, 0x7f, 0xf7, 0x4d, 0x7f, 0xff, 0x6f, 0xee, 
	0x9b, 0xfe, 0xf7, 0xef, 0xff, 0xff, 0x9f, 0xe1, 
	0xbf, 0x7f, 0xdf, 0xfe, 0xaf, 0xff, 0x7f, 0xd3, 
	0x7d, 0xf7, 0xfb, 0xee, 0xff, 0xff, 0xff, 0xef, 
	0xff, 0xff, 0xff, 0x67, 0xfc, 0xff, 0xff, 0xff, 
	0xff, 0x7f, 0xff, 0xef, 0xef, 0xff, 0xfa, 0xff, 
	0x9f, 0xff, 0xff, 0xfd, 0xff, 0xdf, 0x7f, 0xff, 
	0x99, 0xb5, 0xbf, 0xd9, 0xef, 0xff, 0xff, 0xfb, 
	0xff, 0xf7, 0xff, 0xdf, 0xfe, 0xff, 0xef, 0xff, 
	0xfe, 0xff, 0xff, 0xff, 0x7f, 0xc6, 0xff, 0xab, 
	0xff, 0xff, 0xef, 0xf7, 0xff, 0x77, 0xff, 0xfd, 
	0xe5, 0xbf, 0xef, 0x76, 0xfb, 0xef, 0xbf, 0xff, 
	0xff, 0xbf, 0xb1, 0xef, 0xf7, 0xfe, 0xfd, 0xfd, 
	0xd3, 0x5f, 0xff, 0xff, 0xff, 0xf3, 0xbf, 0xff, 
	0x7f, 0xff, 0x37, 0xff, 0xff, 0xfb, 0x6f, 0xfc, 
	0xff, 0xff, 0xbd, 0xa3, 0xf7, 0xff, 0xef, 0xfc, 
	0xf3, 0x9e, 0x7f, 0xdd, 0x79, 0xe7, 0x9f, 0x77, 
	0xfe, 0xf1, 0xff, 0x9b, 0xff, 0xff, 0x7f, 0xbf, 
	0xf7, 0xbf, 0xf7, 0xbf, 0xfd, 0xfb, 0xdf, 0xff, 
	0xbf, 0xbd, 0xf7, 0xdf, 0x7f, 0xff, 0xfd, 0xef, 
	0xe6, 0xfe, 0xef, 0xbf, 0xfb, 0xce, 0xfb, 0xef, 
	0x77, 0x53, 0xe5, 0x6b, 0xff, 0xbd, 0xf7, 0xfe, 
	0xfb, 0xef, 0xef, 0xbf, 0xbb, 0xf9, 0x77, 0xdd, 
	0x47, 0x9f, 0x7f, 0xb6, 0xd9, 0x4f, 0xff, 0xde, 
	0xdf, 0xff, 0xff, 0x7f, 0xdd, 0xff, 0xff, 0xff, 
	0xff, 0x6d, 0xaa, 0xff, 0xff, 0xfd, 0xf7, 0xdf, 
	0x76, 0xdf, 0xed, 0x7f, 0xff, 0xfb, 0xff, 0xff, 
	0xdf, 0xff, 0xfb, 0xff, 0xff, 0xbf, 0x1b, 0xfe, 
	0xbf, 0xd5, 0xfa, 0xfb, 0xef, 0xb9, 0x94, 0x5f, 
	0x2a, 0x7f, 0xff, 0xe4, 0xf7, 0xc5, 0x7f, 0xf9, 
	0xf9, 0xff, 0x3f, 0x66, 0xff, 0xfb, 0xec, 0xbe, 
	0x57, 0xfe, 0xbb, 0xe9, 0x97, 0xfc, 0xaf, 0x7f, 
	0xff, 0x7e, 0x9b, 0xef, 0xbf, 0xff, 0xff, 0xb7, 
	0xf9, 0xff, 0x7b, 0xfb, 0xed, 0xb7, 0xd7, 0x5e, 
	0xef, 0x2f, 0xff, 0xfb, 0xff, 0xbf, 0x4b, 0xfe, 
	0xfb, 0x6f, 0xd6, 0xff, 0x6f, 0xd6, 0xbf, 0x5f, 
	0x7b, 0xed, 0xb5, 0xd7, 0x5e, 0xfb, 0xeb, 0xff, 
	0xfe, 0xfe, 0xef, 0xd4, 0xff, 0xfe, 0xbb, 0xf5, 
	0x5f, 0x9b, 0xfb, 0xff, 0xd7, 0x66, 0xdb, 0x6d, 
	0xb6, 0xbd, 0xf7, 0xca, 0xd7, 0xfe, 0xff, 0xef, 
	0xd5, 0xfa, 0xfe, 0xdb, 0xff, 0xef, 0x66, 0xfe, 
	0xff, 0xe6, 0xbe, 0x2b, 0xee, 0xbb, 0xe7, 0xbe, 
	0xfa, 0xd5, 0xff, 0xff, 0x7f, 0xf5, 0xfe, 0xff, 
	0xff, 0xfd, 0xb3, 0xb1, 0xff, 0xff, 0xbb, 0xef, 
	0xb5, 0xdb, 0x6e, 0xae, 0xaf, 0x7d, 0xfd, 0xef, 
	0xff, 0x59, 0xc7, 0x97, 0xdf, 0xd2, 0xff, 0x66, 
	0xee, 0xff, 0xff, 0xdb, 0x2f, 0xb1, 0xc5, 0x16, 
	0xdb, 0x2b, 0x5d, 0xe1, 0xff, 0x9f, 0xd7, 0xff, 
	0xfb, 0xaf, 0xf5, 0xbf, 0x9b, 0xf7, 0xff, 0xbb, 
	0xfd, 0xb6, 0xdb, 0x6e, 0xfb, 0xed, 0x97, 0xb8, 
	0xfe, 0xfe, 0xeb, 0x7f, 0xbb, 0xfe, 0xda, 0xff, 
	0xf7, 0xe6, 0xfd, 0xbf, 0x65, 0xbe, 0xc9, 0x26, 
	0x9b, 0x6c, 0xf2, 0xd9, 0xcf, 0xbc, 0xff, 0xfc, 
	0x37, 0xcf, 0x3f, 0xff, 0xff, 0xbd, 0xb1, 0xff, 
	0xbb, 0x8b, 0x2f, 0xbf, 0xf8, 0xe2, 0x0b, 0x3f, 
	0xef, 0xf9, 0xe7, 0x9f, 0x6b, 0xff, 0xf1, 0xc7, 
	0xdf, 0xff, 0x66, 0xe6, 0xff, 0xff, 0xfe, 0xfb, 
	0xef, 0xbf, 0xff, 0xfe, 0x7d, 0xff, 0xfb, 0xff, 
	0xbf, 0xff, 0xfe, 0xfb, 0xef, 0xff, 0x3f, 0x9b, 
	0xfb, 0xff, 0xbf, 0xff, 0xe6, 0xdb, 0x6f, 0xbf, 
	0xed, 0xef, 0x7f, 0xff, 0xff, 0xf7, 0xdf, 0xff, 
	0xff, 0xff, 0xff, 0xef, 0xa6, 0xfe, 0xff, 0x7f, 
	0xfc, 0xf1, 0xc7, 0x1f, 0x7f, 0xbc, 0xf4, 0x85, 
	0xbf, 0xff, 0x78, 0xed, 0x8f, 0x3e, 0xfe, 0xff, 
	0xab, 0x61, 0xff, 0x2f, 0x9f, 0x7f, 0xde, 0x79, 
	0xe7, 0x9f, 0x2f, 0x7e, 0xb1, 0xee, 0x7f, 0x4f, 
	0xec, 0xf7, 0xdf, 0xff, 0x7f, 0x6f, 0xfe, 0xff, 
	0xfe, 0x7f, 0xcb, 0xaf, 0xb7, 0xfe, 0x72, 0xeb, 
	0xf7, 0xfd, 0xdf, 0xdf, 0xd7, 0xfd, 0xfd, 0xb7, 
	0xff, 0xff, 0x9b, 0xff, 0xbf, 0xcf, 0x3d, 0xfa, 
	0xc8, 0x23, 0x8f, 0x3e, 0x3a, 0xfc, 0xe1, 0x87, 
	0x1f, 0xf4, 0xf8, 0xe1, 0x87, 0x5f, 0xfe, 0xe6, 
	0xff, 0xff, 0x2f, 0xbf, 0xfc, 0xf2, 0x8b, 0xaf, 
	0xbf, 0xfe, 0xe5, 0xb7, 0xff, 0xfe, 0xf9, 0xef, 
	0xbf, 0xff, 0xf6, 0xbf, 0xf9, 0xff, 0xff, 0xcb, 
	0xaf, 0xbf, 0xfe, 0xfa, 0xeb, 0xaf, 0x5b, 0xbd, 
	0xfc, 0xfb, 0xed, 0xaf, 0xbf, 0xfe, 0xba, 0xef, 
	0x6f, 0xfe, 0xff, 0xfa, 0xea, 0x9f, 0x7f, 0xfe, 
	0xfb, 0xef, 0xaf, 0xf9, 0xd4, 0x1b, 0xcf, 0x3c, 
	0xff, 0xd4, 0x53, 0xff, 0xfd, 0x9b, 0xff, 0xbf, 
	0xbf, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xba, 
	0xfc, 0xe3, 0x86, 0x5f, 0xfe, 0xfa, 0xe3, 0x8f, 
	0x3b, 0xfe, 0x66, 0xff, 0x7f, 0xff, 0xf7, 0xff, 
	0xdf, 0xbf, 0xef, 0xfe, 0xff, 0xfe, 0xff, 0xff, 
	0x7f, 0xfb, 0xdf, 0x7f, 0xff, 0xff, 0xbf, 0xe9, 
	0xff, 0xaf, 0xbf, 0x7c, 0xfa, 0xab, 0xaf, 0xbb, 
	0xfe, 0xfa, 0xd3, 0x5f, 0x7f, 0xdd, 0xe5, 0x57, 
	0x5f, 0x7e, 0xfd, 0x6b, 0xfe, 0xff, 0x7b, 0xbb, 
	0xce, 0x36, 0xff, 0xee, 0xbf, 0xff, 0x7f, 0xfe, 
	0xf9, 0x77, 0xb7, 0x7e, 0xff, 0x75, 0xff, 0xff, 
	0x1b, 0xff, 0xfd, 0xf3, 0xcc, 0x7b, 0x7b, 0xf7, 
	0xdf, 0x7f, 0x6f, 0xef, 0xdb, 0xef, 0x7f, 0xed, 
	0xfb, 0xed, 0xff, 0xff, 0x7f, 0xe6, 0xff, 0xff, 
	0xfd, 0x9f, 0xff, 0xfd, 0x75, 0xf7, 0xff, 0x17, 
	0xa7, 0xdf, 0x7a, 0xfb, 0xff, 0xb7, 0xab, 0xef, 
	0xff, 0xbf, 0xd9, 0xff, 0xff, 0xff, 0xbf, 0xd5, 
	0xfe, 0x7c, 0xe3, 0x27, 0xf2, 0xfb, 0xe0, 0xbf, 
	0x9b, 0xcf, 0xfb, 0x6f, 0xff, 0xff, 0x6f, 0xfe, 
	0xfd, 0xbf, 0xff, 0xff, 0xdd, 0xff, 0xbb, 0xfe, 
	0xdb, 0xfb, 0x7f, 0xbf, 0xff, 0xfb, 0xef, 0xe7, 
	0xdf, 0xfe, 0xfe, 0x9b, 0xff, 0x75, 0xfe, 0xff, 
	0xba, 0xfe, 0x1b, 0xfd, 0xef, 0xd7, 0xff, 0xff, 
	0xff, 0xef, 0x73, 0xff, 0xff, 0xf7, 0xdc, 0xbf, 
	0x66, 0xff, 0xff, 0x77, 0xff, 0xff, 0xff, 0xff, 
	0xef, 0xfe, 0xff, 0xef, 0xff, 0xff, 0x7d, 0xff, 
	0xfd, 0xff, 0xf7, 0xff, 0xbf, 0xf9, 0xff, 0x7f, 
	0xff, 0x7e, 0xdf, 0xeb, 0xff, 0x6d, 0xfd, 0xbf, 
	0xdf, 0xdf, 0xff, 0xdb, 0xcd, 0xfd, 0xdf, 0xff, 
	0xeb, 0x6f, 0x3e, 0x3f, 0xee, 0xf7, 0xff, 0xda, 
	0xff, 0xef, 0xff, 0xe3, 0x1f, 0x7e, 0xfa, 0xf9, 
	0xd7, 0xff, 0xef, 0xff, 0xf9, 0xff, 0x9b, 0xff, 
	0x7a, 0xfd, 0xdb, 0xef, 0xf7, 0xff, 0xff, 0xeb, 
	0xfd, 0xef, 0x9b, 0xf5, 0xfd, 0xff, 0xff, 0xff, 
	0x7f, 0xfe, 0xff, 0x66, 0xff, 0xdf, 0xfe, 0xff, 
	0xee, 0xdb, 0xfe, 0x7f, 0xdf, 0xff, 0xbf, 0xfb, 
	0x26, 0x2f, 0xad, 0xff, 0xbf, 0x6d, 0xfe, 0xbf, 
	0xf1, 0xff, 0xff, 0xeb, 0xff, 0xff, 0x5c, 0xdf, 
	0x8b, 0xfe, 0xf9, 0x7b, 0xff, 0xbf, 0x7f, 0xde, 
	0xd7, 0xdf, 0x9f, 0xff, 0x67, 0xfe, 0xff, 0xff, 
	0x7f, 0xfb, 0xaf, 0xff, 0xff, 0xbf, 0xbf, 0xff, 
	0xbf, 0xff, 0x1d, 0xdf, 0xff, 0xfb, 0xff, 0xf5, 
	0xfb, 0x9b, 0xfe, 0xe5, 0xd7, 0xf1, 0xff, 0xff, 
	0xff, 0xb1, 0xff, 0x4f, 0xfd, 0xff, 0xe5, 0x2f, 
	0x45, 0x7e, 0x4a, 0x4d, 0xe5, 0xbf, 0x66, 0x7f, 
	0xfa, 0xf9, 0xfd, 0xff, 0xff, 0xff, 0xec, 0xe7, 
	0x5f, 0xff, 0xfc, 0xf9, 0x4f, 0x9f, 0x5f, 0x56, 
	0xd9, 0xf9, 0xb7, 0x49, 0xff, 0xfe, 0xbf, 0xff, 
	0xff, 0xff, 0x7f, 0xfd, 0xaf, 0xfe, 0xff, 0xcf, 
	0xbf, 0x4b, 0x65, 0x39, 0xef, 0x92, 0xf3, 0x6f, 
	0xd4, 0xbf, 0xff, 0xff, 0xff, 0xfc, 0xf3, 0x9f, 
	0x3f, 0xeb, 0xff, 0xff, 0xff, 0xdf, 0xd6, 0x7b, 
	0xe7, 0x3b, 0xf5, 0x5e, 0x9b, 0xfb, 0xe7, 0xfd, 
	0xff, 0xde, 0xed, 0xaf, 0xbf, 0xff, 0xdf, 0xff, 
	0xfe, 0xf9, 0x6f, 0xf5, 0x79, 0x4e, 0x7b, 0x45, 
	0xee, 0x06, 0x7e, 0xb8, 0xff, 0xfe, 0x16, 0xeb, 
	0xeb, 0xef, 0xfe, 0xfb, 0xff, 0xff, 0xff, 0x7f, 
	0x7d, 0x5f, 0x51, 0x5f, 0xfd, 0xb3, 0x99, 0xff, 
	0xee, 0xff, 0xef, 0xfd, 0xff, 0xff, 0xeb, 0xaf, 
	0xf7, 0xff, 0xff, 0xfe, 0x5f, 0xee, 0xbd, 0xde, 
	0x57, 0xfb, 0x66, 0xec, 0xbf, 0xf7, 0xff, 0xef, 
	0xff, 0xff, 0xff, 0xfa, 0x2b, 0xf1, 0xe1, 0x27, 
	0x1e, 0xd6, 0x63, 0xe1, 0xaf, 0xb4, 0xb8, 0x1b, 
	0xf7, 0x7f, 0xff, 0x6f, 0xff, 0xff, 0xf6, 0xf3, 
	0xff, 0xd7, 0xbb, 0xfe, 0xfa, 0xeb, 0x7f, 0xbe, 
	0xfe, 0xb2, 0xcb, 0x77, 0x66, 0xfd, 0x9f, 0xff, 
	0xf7, 0xff, 0x67, 0xbf, 0xf9, 0xf7, 0xf9, 0xcf, 
	0x3f, 0xff, 0xfc, 0x3f, 0xcf, 0x3f, 0xff, 0xac, 
	0xbd, 0xb9, 0xfe, 0x43, 0xed, 0xbe, 0xdf, 0x40, 
	0xfb, 0xef, 0x3e, 0xff, 0xf9, 0xe7, 0x9f, 0x6b, 
	0xff, 0xf9, 0xc6, 0x1b, 0xfd, 0x66, 0xee, 0xff, 
	0xff, 0xff, 0xff, 0xf3, 0xdf, 0xff, 0xff, 0x7f, 
	0xff, 0xfb, 0xef, 0xbf, 0xfb, 0xef, 0x9b, 0x6f, 
	0xbe, 0x3b, 0x9b, 0xf9, 0xff, 0xff, 0xff, 0x7f, 
	0xff, 0xfb, 0xff, 0xff, 0xef, 0x7f, 0xff, 0xfd, 
	0xd7, 0xff, 0x7e, 0xf7, 0xdf, 0xbf, 0xef, 0xe6, 
	0xf6, 0x0b, 0xaf, 0xbf, 0x7f, 0xea, 0xfb, 0xed, 
	0xff, 0xf5, 0xa5, 0x12, 0x7e, 0x78, 0xf5, 0x8d, 
	0x17, 0x4e, 0xf8, 0xbb, 0x61, 0xff, 0xe2, 0xcb, 
	0xef, 0xb6, 0xd8, 0xab, 0xbb, 0xff, 0x5e, 0xf1, 
	0xc5, 0x1f, 0x5f, 0xff, 0xb1, 0xc5, 0x17, 0x7f, 
	0x6f, 0xfe, 0xb7, 0xfc, 0x7a, 0xff, 0x2f, 0xfb, 
	0xff, 0xff, 0xff, 0x5d, 0x77, 0x99, 0xe7, 0x97, 
	0xdf, 0xee, 0xbb, 0xe5, 0xff, 0x9b, 0xff, 0xaf, 
	0x8f, 0x3e, 0xff, 0xe8, 0xf3, 0xcf, 0x3f, 0x3f, 
	0xd5, 0x41, 0x87, 0x1d, 0xf4, 0xd8, 0xe1, 0x07, 
	0x1d, 0xfe, 0xe6, 0xff, 0xeb, 0x2f, 0xbf, 0xff, 
	0xfa, 0xfb, 0xef, 0xff, 0xf9, 0xff, 0xbf, 0x7f, 
	0x7f, 0xf1, 0xfd, 0x1f, 0x5f, 0xff, 0xbf, 0xe1, 
	0xff, 0xfa, 0xeb, 0xef, 0xbf, 0xfe, 0xfb, 0xfb, 
	0xff, 0xdb, 0xbf, 0x7e, 0xdb, 0x4d, 0xaf, 0xdd, 
	0xf4, 0xd2, 0xed, 0x6f, 0xfe, 0xbf, 0xfa, 0xf2, 
	0xbf, 0xaf, 0xfe, 0xfb, 0xef, 0xbf, 0xf1, 0xd5, 
	0x33, 0xd7, 0xdc, 0xdf, 0xcd, 0x57, 0xd7, 0xfc, 
	0x9b, 0xfb, 0xaf, 0xbf, 0xfc, 0xff, 0xeb, 0xff, 
	0xff, 0xfd, 0xbf, 0xfb, 0xe3, 0x97, 0x5d, 0xe4, 
	0xda, 0xe5, 0x0f, 0x5d, 0xfe, 0xe6, 0xff, 0xca, 
	0xff, 0xff, 0xff, 0xd4, 0x7f, 0x3f, 0xf7, 0xfb, 
	0xdf, 0xff, 0xff, 0xfb, 0xff, 0xed, 0xff, 0xdf, 
	0xfe, 0xbf, 0xf9, 0xff, 0xaf, 0xbe, 0xfe, 0x7a, 
	0xeb, 0xaf, 0xbf, 0xfa, 0xfa, 0xd7, 0x5f, 0x7b, 
	0xfd, 0x31, 0x57, 0x5f, 0x77, 0xfd, 0x6f, 0x36, 
	0x7f, 0xbf, 0xfb, 0xfd, 0xf6, 0xdf, 0xbf, 0xbf, 
	0xff, 0x7f, 0xbc, 0xf9, 0xef, 0xff, 0x5e, 0xfd, 
	0xfb, 0xf5, 0xff, 0x9b, 0xbf, 0xff, 0xdf, 0xff, 
	0x3f, 0xff, 0xfd, 0xef, 0x7f, 0xff, 0xd7, 0xbd, 
	0xd3, 0xb6, 0xff, 0x7f, 0xcf, 0xfd, 0xff, 0x7e, 
	0xe6, 0xff, 0xbf, 0x3f, 0xff, 0xff, 0xb7, 0xfd, 
	0xff, 0xdb, 0xf7, 0x3f, 0xed, 0xf7, 0xea, 0xf7, 
	0xbb, 0xfd, 0xaf, 0xf7, 0xaf, 0x71, 0xff, 0xdf, 
	0xeb, 0xff, 0x2f, 0xdf, 0x7f, 0xdd, 0xff, 0xdb, 
	0xbd, 0xb7, 0xfe, 0x5f, 0xa9, 0xbf, 0xe9, 0xc7, 
	0xf3, 0x67, 0xec, 0xdf, 0xbb, 0xfa, 0xff, 0xf6, 
	0xff, 0xf7, 0xff, 0xfe, 0xbf, 0x7d, 0x5f, 0xfe, 
	0xad, 0xfd, 0xdf, 0x3f, 0xff, 0xff, 0x9b, 0xff, 
	0xff, 0xff, 0xbc, 0xff, 0xff, 0x9e, 0xef, 0xff, 
	0xfb, 0xff, 0xf7, 0xff, 0xf3, 0xff, 0xff, 0xff, 
	0x7f, 0xff, 0xbf, 0xc6, 0x5f, 0x7f, 0xcf, 0xff, 
	0xff, 0xf6, 0xff, 0xfd, 0x3f, 0xe3, 0xcf, 0xf7, 
	0xdf, 0xef, 0xef, 0x6f, 0xbf, 0xff, 0xbf, 0xbf, 
	0xd1, 0xff, 0xcf, 0xef, 0xff, 0xfe, 0x1e, 0xff, 
	0x7f, 0xec, 0x97, 0xff, 0xfd, 0xf6, 0xfe, 0xed, 
	0xbf, 0xde, 0xff, 0xfe, 0x6f, 0xfc, 0x3d, 0xe7, 
	0xac, 0xd0, 0x57, 0x3e, 0xef, 0xfc, 0xff, 0x9e, 
	0xee, 0xdf, 0x6f, 0x6b, 0xec, 0xff, 0xff, 0x7f, 
	0xff, 0x9b, 0xfa, 0xaf, 0xfe, 0xd6, 0xfa, 0xdf, 
	0x7e, 0x9f, 0xfd, 0xdf, 0xb7, 0xfd, 0x9f, 0xbf, 
	0xfb, 0xff, 0xfe, 0xff, 0xbf, 0xbf, 0xe6, 0xfe, 
	0xab, 0x5f, 0xfb, 0xef, 0x7f, 0x67, 0x7e, 0x9f, 
	0xfe, 0xa7, 0xbb, 0x59, 0xbe, 0x7f, 0x76, 0x7f, 
	0xfd, 0xbf, 0xbf, 0xf9, 0xbf, 0xfb, 0xdf, 0xff, 
	0xfe, 0x7a, 0xfb, 0xff, 0xff, 0xff, 0xfc, 0xff, 
	0x9f, 0xfb, 0xff, 0xf9, 0xf7, 0xff, 0xff, 0x6f, 
	0xee, 0xfd, 0xfe, 0xff, 0xff, 0xbf, 0xbb, 0xee, 
	0xff, 0xbf, 0xbf, 0xff, 0xff, 0xf7, 0xff, 0x5f, 
	0xff, 0xfd, 0xdf, 0xff, 0x1b, 0x7e, 0x75, 0xf7, 
	0x95, 0x7f, 0x7f, 0xfd, 0xf1, 0xb5, 0xd7, 0xbe, 
	0xf6, 0xda, 0xfb, 0xff, 0xbe, 0xf7, 0xdf, 0x0b, 
	0xef, 0xa6, 0xff, 0xaf, 0xff, 0xb3, 0x5b, 0xcf, 
	0x6b, 0xff, 0xd7, 0xc3, 0xf7, 0xf7, 0x53, 0x2f, 
	0xf5, 0xb7, 0x72, 0xff, 0xff, 0xbf, 0xd9, 0xff, 
	0xee, 0xff, 0xec, 0xff, 0xfd, 0xfe, 0x7f, 0xf5, 
	0x7c, 0xff, 0xfd, 0xf2, 0x4b, 0x7e, 0x9f, 0xfd, 
	0xff, 0xff, 0x6d, 0xfe, 0xb7, 0x5f, 0xff, 0xbb, 
	0xff, 0xbf, 0xfc, 0xff, 0xff, 0xdd, 0x4f, 0xff, 
	0xe5, 0x97, 0xdb, 0xef, 0xf5, 0xff, 0x7f, 0x1b, 
	0xf5, 0xb5, 0xe7, 0xff, 0x7e, 0xfe, 0x8f, 0xff, 
	0xff, 0x7f, 0xdd, 0xd3, 0x6f, 0xf9, 0xf5, 0xda, 
	0x6b, 0xff, 0xff, 0x57, 0xe6, 0xbe, 0x6d, 0xff, 
	0x95, 0xf7, 0xdb, 0x0b, 0xf5, 0xfd, 0xf6, 0x37, 
	0xf3, 0x44, 0x33, 0xe5, 0x37, 0xf3, 0xfe, 0xff, 
	0xbb, 0x91, 0xff, 0xee, 0x7f, 0xe7, 0xfe, 0x5b, 
	0xfe, 0xbd, 0xbf, 0x7e, 0xf7, 0xbd, 0xd3, 0x4f, 
	0x7d, 0xef, 0xbd, 0xff, 0xff, 0x6c, 0xec, 0xbf, 
	0xcb, 0xff, 0xfa, 0xfd, 0x97, 0xbe, 0x3f, 0xff, 
	0xdf, 0x6d, 0x7f, 0x65, 0xd4, 0xdf, 0xab, 0xed, 
	0xff, 0xbf, 0x19, 0xf9, 0xbf, 0xbd, 0x57, 0x4e, 
	0x3c, 0xec, 0xfe, 0xc3, 0xcf, 0xdf, 0xf2, 0x7b, 
	0xf5, 0x15, 0xde, 0x78, 0xfb, 0xff, 0x6f, 0x86, 
	0xbd, 0xd9, 0xff, 0xfb, 0xfd, 0xb7, 0xfd, 0x7e, 
	0xdb, 0xfd, 0xec, 0xfd, 0xfd, 0xb3, 0xeb, 0xfd, 
	0xff, 0xfd, 0xff, 0xbd, 0x79, 0x9f, 0xe6, 0x6b, 
	0x7c, 0xfe, 0xd9, 0x67, 0x9c, 0x79, 0x7e, 0xf3, 
	0x55, 0xfe, 0xf2, 0x7c, 0xff, 0x7d, 0xfe, 0x7f, 
	0x6d, 0xa6, 0xbf, 0xf8, 0xfb, 0xcf, 0x35, 0xd3, 
	0xfc, 0x73, 0xcd, 0x5f, 0xfc, 0xfd, 0xf6, 0x9f, 
	0x5f, 0x7f, 0xfd, 0xf7, 0xbf, 0x99, 0xf8, 0xef, 
	0xff, 0xff, 0xff, 0xfd, 0xf7, 0xff, 0xff, 0xff, 
	0xf7, 0xff, 0x9f, 0xff, 0xbf, 0xf7, 0xdf, 0xff, 
	0xff, 0xee, 0xe6, 0xfe, 0xfb, 0xff, 0xff, 0xeb, 
	0x6f, 0xff, 0xff, 0xfe, 0xfb, 0xfd, 0xff, 0xf7, 
	0xff, 0xf7, 0xfd, 0xb7, 0xff, 0xdf, 0xbb, 0xb9, 
	0xfd, 0x47, 0xff, 0x2d, 0xdc, 0xd1, 0xe7, 0x4b, 
	0x7f, 0xfc, 0xe3, 0xbf, 0xd7, 0xff, 0xf8, 0xef, 
	0xbf, 0xff, 0xff, 0x6e, 0xde, 0xff, 0xf9, 0xe7, 
	0x8b, 0x7f, 0xd6, 0xc9, 0xe2, 0x9d, 0xfd, 0xec, 
	0xd3, 0xd5, 0x7f, 0xff, 0xfd, 0xf7, 0xff, 0xdf, 
	0x9b, 0xff, 0x7f, 0xbb, 0xfe, 0xea, 0xfb, 0x6f, 
	0xff, 0xff, 0xff, 0xbf, 0x5f, 0x7f, 0xbd, 0xff, 
	0xfe, 0x5d, 0xff, 0xff, 0xff, 0xe6, 0xff, 0xff, 
	0xa3, 0x8f, 0x2e, 0xf7, 0xfc, 0xfb, 0xcf, 0x3d, 
	0x7f, 0xd4, 0x55, 0xd7, 0x1b, 0x7f, 0xd1, 0xe1, 
	0x9f, 0xbf, 0xf9, 0xff, 0xe2, 0xcb, 0x7f, 0xfb, 
	0xf9, 0xfe, 0xcb, 0x6f, 0x7e, 0xdd, 0xf5, 0x15, 
	0xf7, 0x5e, 0xfd, 0xf5, 0xfb, 0xef, 0x6f, 0xfe, 
	0xbf, 0xfe, 0xf2, 0xdf, 0xfb, 0xff, 0x7f, 0xf2, 
	0xff, 0x5f, 0x1f, 0xfd, 0x74, 0xfb, 0x4b, 0x57, 
	0x3d, 0xff, 0xff, 0x9b, 0xff, 0xaf, 0xfe, 0xfb, 
	0xef, 0xbf, 0xff, 0xfe, 0xfb, 0xee, 0x57, 0xfb, 
	0xd5, 0x75, 0x4f, 0x55, 0xff, 0xf5, 0xff, 0xff, 
	0xe6, 0xff, 0xeb, 0x7f, 0xff, 0xef, 0xff, 0xff, 
	0xfd, 0xff, 0xff, 0xf4, 0xfe, 0x59, 0xe6, 0xbf, 
	0x75, 0xff, 0xfb, 0xef, 0xbf, 0xf9, 0xbf, 0xff, 
	0xdb, 0x4f, 0xbf, 0xfd, 0xfe, 0xff, 0xef, 0xbf, 
	0xff, 0xe7, 0x27, 0xf7, 0xff, 0xe7, 0xe9, 0xff, 
	0xff, 0x6f, 0xf6, 0xff, 0xeb, 0xa6, 0xba, 0xde, 
	0x7a, 0xe3, 0xa7, 0x37, 0xfe, 0xe5, 0xd3, 0x5d, 
	0x7f, 0xec, 0xd5, 0xd6, 0x5f, 0xfb, 0x9b, 0xff, 
	0xb7, 0xbe, 0xff, 0xbf, 0xf9, 0xff, 0xd7, 0x6c, 
	0xdb, 0xff, 0xff, 0xf7, 0xe9, 0xbf, 0x7e, 0xff, 
	0xff, 0xff, 0xff, 0xc6, 0xff, 0xff, 0xfe, 0xf9, 
	0xef, 0x3f, 0xff, 0x1e, 0xf2, 0x7d, 0xff, 0xbd, 
	0x6f, 0xbf, 0x6f, 0x7f, 0xfb, 0xfe, 0xfb, 0x9f, 
	0xf9, 0xff, 0x7b, 0xff, 0xff, 0xff, 0xf7, 0xff, 
	0xfd, 0xb5, 0xd3, 0xef, 0xfe, 0xf3, 0xee, 0xff, 
	0xe7, 0xff, 0xff, 0xff, 0x6f, 0xf8, 0x3e, 0xe7, 
	0xfa, 0x63, 0xfd, 0x37, 0xf9, 0xff, 0xbb, 0x7f, 
	0x6e, 0xbd, 0xf5, 0xff, 0x7f, 0xff, 0xbd, 0xff, 
	0xfe, 0x99, 0xff, 0xf9, 0xef, 0xfd, 0xfd, 0x7f, 
	0xf6, 0xff, 0xbf, 0x7b, 0xff, 0x77, 0x5b, 0x7d, 
	0xff, 0x7b, 0xd7, 0xdf, 0xff, 0xff, 0xe6, 0xff, 
	0xef, 0xad, 0xff, 0xef, 0xb3, 0xdd, 0xff, 0x7f, 
	0xf4, 0xe5, 0xd3, 0x3f, 0xff, 0xbf, 0xf5, 0xcf, 
	0xff, 0xf7, 0xbf, 0xf9, 0xeb, 0xff, 0xdf, 0x7f, 
	0x0f, 0xff, 0xff, 0x7f, 0xef, 0xfa, 0xff, 0xeb, 
	0xbf, 0xf9, 0x7e, 0xfd, 0xe5, 0x7f, 0xff, 0x6f, 
	0xfa, 0xee, 0x75, 0xe7, 0xff, 0xef, 0xf5, 0xdf, 
	0xbf, 0xaf, 0xfd, 0xfa, 0xff, 0xfe, 0xff, 0xfb, 
	0xee, 0xff, 0xbf, 0xf9, 0x9a, 0xff, 0xff, 0x7f, 
	0xc3, 0x7f, 0xdf, 0xfe, 0xfb, 0xdf, 0xf8, 0x7f, 
	0xfd, 0x7d, 0xf8, 0x6d, 0xe7, 0xef, 0xfb, 0xff, 
	0xff, 0xe6, 0xff, 0xbf, 0x7e, 0xdf, 0xef, 0xff, 
	0xbf, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0x56, 
	0x7f, 0xb5, 0xff, 0xff, 0xff, 0xbf, 0xb9, 0xf7, 
	0xe2, 0xcf, 0xff, 0xfe, 0x7d, 0xf7, 0x48, 0xbf, 
	0xf7, 0x9b, 0xf4, 0x5f, 0xff, 0xfd, 0xff, 0xc7, 
	0xfd, 0xff, 0x6e, 0xee, 0xff, 0xbe, 0xf9, 0x7f, 
	0x7f, 0xff, 0xfd, 0xfb, 0xef, 0x57, 0x7f, 0xdd, 
	0xf3, 0x7f, 0x7f, 0xff, 0x71, 0xfe, 0xff, 0x9b, 
	0xfd, 0xbf, 0x7f, 0xdf, 0xbf, 0xff, 0xfe, 0xff, 
	0xfe, 0xea, 0xff, 0xff, 0xff, 0xfe, 0x7f, 0xdf, 
	0x9f, 0xf5, 0xff, 0xef, 0x86, 0xff, 0xff, 0xb9, 
	0xf2, 0xf2, 0xef, 0x6f, 0xff, 0xb2, 0xca, 0x9f, 
	0xf7, 0x5f, 0xcf, 0x93, 0x5d, 0x36, 0xeb, 0xfc, 
	0x8f, 0xd9, 0xff, 0x3f, 0xfb, 0xf9, 0xff, 0xfb, 
	0xfe, 0xff, 0xfc, 0xf3, 0x3f, 0xff, 0xd4, 0xf3, 
	0xe7, 0xb7, 0x76, 0xfe, 0xff, 0x6d, 0xfe, 0xa7, 
	0xce, 0x23, 0xab, 0xbf, 0x97, 0xff, 0x6f, 0x9e, 
	0x55, 0x7d, 0xfb, 0xf5, 0x7c, 0xeb, 0xae, 0xf7, 
	0xdf, 0xff, 0x9b, 0xf5, 0xa9, 0x3f, 0xff, 0x3e, 
	0xef, 0xec, 0xff, 0xcf, 0x38, 0xd7, 0xbf, 0x7d, 
	0x3c, 0xff, 0xfe, 0xf9, 0xff, 0xff, 0xd7, 0xe6, 
	0xfe, 0x7f, 0x37, 0xd8, 0xfe, 0xde, 0xef, 0xf6, 
	0xbd, 0x52, 0xbf, 0xd7, 0xeb, 0xfb, 0x7f, 0x94, 
	0xf2, 0xed, 0xff, 0xbb, 0x99, 0xff, 0x5f, 0x78, 
	0xff, 0xbf, 0xf7, 0xee, 0xff, 0xff, 0xfd, 0xaf, 
	0xfc, 0xff, 0xff, 0x5f, 0xd7, 0xd4, 0xff, 0xff, 
	0x6c, 0xec, 0xbf, 0xd6, 0x7b, 0xe9, 0xaf, 0xbf, 
	0x5f, 0xef, 0xdf, 0x5f, 0x7f, 0xf9, 0xaf, 0xbf, 
	0x59, 0x6f, 0xfd, 0xff, 0xbf, 0x99, 0xfb, 0xbf, 
	0xed, 0x57, 0xde, 0x6b, 0xef, 0xf7, 0xc7, 0x1a, 
	0xdf, 0xde, 0xaf, 0xf7, 0xed, 0x57, 0x76, 0xff, 
	0xff, 0xef, 0xe6, 0xfd, 0xff, 0x7f, 0xff, 0x6f, 
	0xbf, 0xfd, 0x78, 0xff, 0xff, 0x7e, 0xfb, 0xfd, 
	0xfe, 0xdf, 0xaf, 0xff, 0xff, 0xff, 0xbd, 0x79, 
	0xff, 0x7f, 0x9f, 0xff, 0xe6, 0xff, 0x6f, 0x9f, 
	0x7f, 0xe7, 0xbf, 0xdf, 0x38, 0xfa, 0xaf, 0xb3, 
	0xff, 0xff, 0x7f, 0x6f, 0xec, 0xd7, 0x6e, 0xd3, 
	0xed, 0xbf, 0xff, 0xbe, 0x63, 0xcd, 0x7f, 0xf7, 
	0xfd, 0x66, 0xdf, 0x63, 0x9e, 0xfd, 0xf7, 0xbf, 
	0x99, 0xf9, 0xf7, 0xcf, 0x3f, 0xff, 0xff, 0xf7, 
	0xff, 0xff, 0xff, 0xfd, 0xef, 0x9f, 0xff, 0xff, 
	0xff, 0xec, 0xff, 0xff, 0xcf, 0xe6, 0xbe, 0xff, 
	0xfb, 0xee, 0xff, 0x7f, 0xbf, 0xff, 0xff, 0xdf, 
	0xff, 0xfe, 0xf7, 0xff, 0xff, 0xdf, 0xfe, 0xff, 
	0xff, 0xbb, 0xa9, 0xff, 0xdf, 0x8f, 0xaf, 0xbd, 
	0xf6, 0xda, 0x0f, 0xef, 0xfe, 0xef, 0x95, 0x37, 
	0xff, 0x7d, 0xe1, 0xfd, 0xff, 0xff, 0x6a, 0xde, 
	0xff, 0x7a, 0xe3, 0xab, 0xac, 0xfe, 0xfa, 0x63, 
	0x8b, 0x7f, 0x7d, 0x95, 0x4f, 0xb7, 0x4f, 0x7c, 
	0xfb, 0xff, 0xdf, 0x9b, 0xff, 0xbf, 0xd3, 0xcc, 
	0xff, 0xff, 0xbd, 0xdf, 0xfa, 0xf3, 0xdf, 0x5f, 
	0xaf, 0xff, 0xdf, 0xdf, 0xff, 0xff, 0xdf, 0xff, 
	0xe6, 0xff, 0xef, 0xb3, 0xc7, 0x3f, 0xff, 0xfc, 
	0xb3, 0x8f, 0x2e, 0xf7, 0xb0, 0xef, 0xa6, 0xbf, 
	0xe4, 0xf1, 0xe7, 0x9f, 0xbf, 0xf9, 0xff, 0xfb, 
	0xcf, 0xb5, 0xff, 0xfe, 0xf2, 0xcf, 0x67, 0xff, 
	0xfd, 0xf5, 0xf7, 0xff, 0xfe, 0xfb, 0xf6, 0xff, 
	0xff, 0x6f, 0xfe, 0xff, 0xfe, 0xfb, 0xfb, 0xbf, 
	0xff, 0x7e, 0xfb, 0xeb, 0x7b, 0x3f, 0xfd, 0xfe, 
	0xbb, 0xef, 0xfe, 0xff, 0xff, 0xff, 0x9b, 0xff, 
	0xbf, 0xfe, 0xf8, 0xeb, 0xaf, 0x3f, 0xde, 0xf8, 
	0xa3, 0x5f, 0x4b, 0x9d, 0x17, 0xfe, 0x78, 0x5f, 
	0xff, 0xff, 0xff, 0xe6, 0xff, 0xef, 0xbf, 0xb7, 
	0xff, 0xfb, 0xff, 0xbd, 0xb7, 0xfc, 0xf7, 0xf6, 
	0xf9, 0xe7, 0xdb, 0xf7, 0xf6, 0xff, 0xff, 0xbf, 
	0xf9, 0xff, 0xf6, 0x5b, 0xef, 0xa7, 0xff, 0xf3, 
	0xff, 0xef, 0x7e, 0xfb, 0xe5, 0xff, 0x5f, 0x7e, 
	0xf9, 0xed, 0x7f, 0xff, 0x6f, 0xfa, 0xff, 0xe9, 
	0xaf, 0xbe, 0xf8, 0xea, 0xeb, 0xaf, 0xbe, 0xfe, 
	0xf5, 0xc7, 0x5f, 0x74, 0xbd, 0x35, 0xd7, 0x5f, 
	0xfb, 0x9a, 0xbd, 0xc7, 0x1e, 0xff, 0xbd, 0xe7, 
	0x7b, 0xff, 0xff, 0xd9, 0x67, 0x37, 0xfe, 0xdf, 
	0x7f, 0xdf, 0xdf, 0xef, 0xff, 0xff, 0xc6, 0xff, 
	0xdf, 0xfe, 0xff, 0x7f, 0xdf, 0xd7, 0xf7, 0xff, 
	0xbe, 0x7f, 0xde, 0xef, 0xff, 0x77, 0xff, 0x7f, 
	0xf7, 0xff, 0x9f, 0xf9, 0xff, 0xff, 0x7f, 0x7f, 
	0x7d, 0xdb, 0xff, 0xff, 0x7e, 0xdf, 0xaf, 0xbd, 
	0xfe, 0xf7, 0xff, 0xf2, 0xff, 0xff, 0xff, 0x6f, 
	0xfe, 0x3f, 0xdf, 0x74, 0xe9, 0xa9, 0xef, 0x7f, 
	0xff, 0xfd, 0x7e, 0xdd, 0xff, 0xff, 0x94, 0x53, 
	0x7b, 0xfd, 0x5f, 0xfe, 0x9b, 0xff, 0xff, 0xff, 
	0xf7, 0xb7, 0xdf, 0xff, 0xfe, 0xff, 0xff, 0xff, 
	0xff, 0xf7, 0xef, 0x73, 0xb3, 0xf7, 0xfe, 0xf7, 
	0xff, 0xe6, 0xef, 0xff, 0xbb, 0x37, 0xfe, 0xf6, 
	0xff, 0xfb, 0x73, 0xfe, 0x7d, 0xdf, 0xff, 0xff, 
	0xfd, 0x7f, 0xc7, 0x7f, 0xfb, 0xbf, 0xf9, 0x7f, 
	0xf7, 0xd3, 0xef, 0xbf, 0xff, 0xff, 0x9f, 0x6f, 
	0xfb, 0xfb, 0xf4, 0x97, 0x1f, 0x7d, 0xfb, 0xe5, 
	0xf7, 0xfd, 0x6f, 0xf6, 0xfe, 0xff, 0xfe, 0xfb, 
	0xb7, 0xfd, 0xbf, 0x8f, 0x7b, 0xff, 0xef, 0xfb, 
	0xff, 0xff, 0x73, 0xff, 0xff, 0xe6, 0xff, 0x9b, 
	0xfd, 0xfb, 0xff, 0x73, 0xbf, 0xff, 0xc7, 0x0b, 
	0x7f, 0x2f, 0xfd, 0xef, 0xb5, 0x9f, 0xee, 0xff, 
	0xd7, 0xf7, 0xee, 0xff, 0x66, 0xff, 0xff, 0xff, 
	0xfe, 0xff, 0x7f, 0xeb, 0xaf, 0xff, 0xfb, 0x7f, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xbf, 0xff, 
	0xbf, 0xf9, 0xff, 0xff, 0xcf, 0xa6, 0xff, 0xbe, 
	0xff, 0xbd, 0xb7, 0xdf, 0xbf, 0xd7, 0xde, 0x5c, 
	0xab, 0x7f, 0xa6, 0xff, 0xff, 0x6f, 0xfc, 0xfb, 
	0xed, 0xf9, 0xff, 0xb7, 0xfb, 0xff, 0xd7, 0x8f, 
	0xff, 0xf7, 0xf8, 0xfb, 0x9f, 0xff, 0xff, 0xdd, 
	0xff, 0xff, 0x98, 0xff, 0xff, 0x7f, 0xff, 0xff, 
	0xf3, 0xff, 0xfd, 0xff, 0xfa, 0xff, 0xbf, 0xff, 
	0xff, 0xf7, 0x7f, 0x9f, 0xff, 0xff, 0xff, 0xa6, 
	0xfc, 0xfb, 0xf9, 0xf2, 0x93, 0x6f, 0xfa, 0xfc, 
	0xfe, 0xff, 0xdd, 0x5f, 0xff, 0xfd, 0xf7, 0xff, 
	0x5c, 0xd9, 0xfd, 0xaf, 0xd9, 0xff, 0x7f, 0xfe, 
	0xf9, 0xff, 0x9d, 0x3f, 0xff, 0xff, 0xff, 0xf5, 
	0xdf, 0x77, 0xff, 0xfd, 0xff, 0x6d, 0xb6, 0xff, 
	0x6d, 0xde, 0xa7, 0x56, 0x6f, 0x9a, 0xff, 0xbf, 
	0xff, 0x2f, 0xff, 0x5f, 0xff, 0xfd, 0x7f, 0xde, 
	0xeb, 0x7f, 0x8b, 0xe7, 0xdf, 0x1b, 0xf5, 0xbd, 
	0xe7, 0x9f, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x7f, 
	0xd7, 0xff, 0x7f, 0xff, 0xf7, 0xfe, 0xd3, 0x4f, 
	0xf7, 0x57, 0xe6, 0xfe, 0xfa, 0xff, 0xdb, 0xf0, 
	0xd2, 0x7b, 0xff, 0xfd, 0xb7, 0xfd, 0x97, 0x7e, 
	0x32, 0x6b, 0x77, 0x73, 0x6a, 0xb3, 0xbb, 0x99, 
	0xff, 0xef, 0xfd, 0xb7, 0xbf, 0xf4, 0xef, 0xff, 
	0xff, 0xfe, 0xd5, 0xbc, 0xd3, 0xce, 0x7b, 0xb7, 
	0xdc, 0x73, 0xff, 0x6c, 0xec, 0xbf, 0xbe, 0xff, 
	0xea, 0x2f, 0xbd, 0xc7, 0xff, 0xbf, 0x5d, 0x7b, 
	0x7d, 0xf7, 0xd5, 0x5f, 0x7f, 0x37, 0xd7, 0xbf, 
	0x19, 0xf8, 0xbf, 0xbf, 0xf7, 0x0a, 0x4b, 0xff, 
	0xfc, 0xf3, 0x3e, 0xd6, 0xdb, 0x7a, 0xe9, 0xa5, 
	0xd7, 0xcb, 0x5b, 0xef, 0x6f, 0xe6, 0x3d, 0xff, 
	0xf6, 0xfb, 0xff, 0x3f, 0xdf, 0x7f, 0xff, 0xff, 
	0x7e, 0xb9, 0xff, 0xb6, 0xdb, 0xff, 0xbf, 0xfc, 
	0xfb, 0xbd, 0x79, 0xdf, 0x7f, 0xbe, 0x75, 0xfe, 
	0xf9, 0x67, 0x9f, 0xff, 0xe6, 0xe7, 0xdf, 0x7f, 
	0xff, 0xad, 0xbf, 0xcf, 0xfa, 0x7e, 0x6f, 0xec, 
	0xfb, 0xfe, 0x3b, 0xcd, 0x37, 0xd7, 0xe4, 0xf3, 
	0x6f, 0x77, 0xff, 0xf5, 0xd7, 0x5f, 0x63, 0xa7, 
	0xd1, 0xf7, 0xbf, 0x99, 0xf9, 0xf7, 0xff, 0xff, 
	0xbf, 0xfd, 0xf7, 0xff, 0xff, 0xff, 0xfc, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xef, 0xfb, 0xff, 0xce, 
	0xe6, 0x7e, 0xff, 0xff, 0xff, 0xbf, 0xaf, 0xbf, 
	0xff, 0xfe, 0xef, 0xdf, 0xff, 0xff, 0xff, 0xff, 
	0x7f, 0xff, 0xff, 0xef, 0xbb, 0xb9, 0xff, 0xff, 
	0x6f, 0x37, 0xf5, 0xf7, 0xc2, 0x5f, 0xaf, 0xfd, 
	0xed, 0xa7, 0x97, 0x7e, 0x7a, 0xfd, 0xa4, 0xff, 
	0xff, 0x6e, 0xde, 0xff, 0xfd, 0xab, 0x9f, 0x7e, 
	0x96, 0xf8, 0xe7, 0x8b, 0xde, 0xfd, 0xf5, 0xd5, 
	0x5f, 0x5f, 0x7e, 0xf1, 0xce, 0xdf, 0x9b, 0xff, 
	0xaf, 0xbf, 0xde, 0xfb, 0xff, 0x3f, 0xff, 0xff, 
	0xff, 0xff, 0x5f, 0xff, 0xff, 0xf7, 0xdf, 0x7f, 
	0xff, 0xff, 0xff, 0xe6, 0xff, 0xeb, 0xa3, 0xcf, 
	0x3f, 0xff, 0xf8, 0xf3, 0xcf, 0x3f, 0xff, 0xd0, 
	0xe1, 0x87, 0x1d, 0xfc, 0xd1, 0xe7, 0x9f, 0xbf, 
	0xf9, 0xff, 0xfb, 0xef, 0xff, 0xff, 0xff, 0xfa, 
	0xdf, 0x2f, 0xff, 0xf1, 0xf7, 0xdf, 0x5f, 0xff, 
	0xf3, 0xfd, 0xd7, 0xff, 0x6f, 0xfe, 0xbf, 0xff, 
	0xfb, 0xff, 0xff, 0xbf, 0xfe, 0xf7, 0xeb, 0xdf, 
	0xbf, 0xbd, 0xf6, 0xd2, 0xed, 0xff, 0xff, 0xf5, 
	0xff, 0x9b, 0xff, 0xbf, 0xff, 0xfb, 0xef, 0xbf, 
	0xaf, 0xfe, 0xfb, 0xe7, 0x7f, 0xfb, 0xd5, 0x55, 
	0xdf, 0xfc, 0xff, 0x7d, 0xf5, 0xff, 0xe6, 0xff, 
	0xfb, 0xff, 0xff, 0xff, 0xfb, 0xeb, 0xff, 0xff, 
	0xff, 0xff, 0xfa, 0x63, 0x8f, 0x5f, 0xee, 0xff, 
	0x5f, 0xff, 0xbf, 0xf9, 0xff, 0xf5, 0x9b, 0x3f, 
	0xff, 0xff, 0xfe, 0xff, 0x6f, 0xbe, 0xff, 0xe5, 
	0x97, 0x5f, 0xde, 0xff, 0xe7, 0x97, 0xff, 0x6f, 
	0xfe, 0xff, 0xeb, 0xad, 0xbf, 0xfe, 0xf2, 0xeb, 
	0xaf, 0x3f, 0xee, 0xe5, 0xd7, 0x5f, 0x7d, 0xfd, 
	0xb5, 0xc7, 0x5b, 0xff, 0x9b, 0xcd, 0xf7, 0xbb, 
	0xff, 0xbb, 0xcf, 0xdf, 0xfd, 0xf8, 0xd8, 0x5f, 
	0x3d, 0xfb, 0xba, 0xf3, 0x7e, 0x7e, 0xdf, 0xfd, 
	0xff, 0xe6, 0xff, 0xbf, 0xff, 0xff, 0xfd, 0xdd, 
	0xff, 0x27, 0xde, 0x7a, 0xff, 0xff, 0xdf, 0xf7, 
	0x5f, 0xde, 0xff, 0xf7, 0xfb, 0x9f, 0xf9, 0xff, 
	0xbf, 0xfd, 0xdf, 0xff, 0xfe, 0xff, 0xbd, 0xfa, 
	0xf4, 0xdd, 0xba, 0xfb, 0xaf, 0xff, 0xef, 0xb7, 
	0xdf, 0xff, 0x6f, 0xfc, 0x3f, 0xfe, 0xf8, 0xeb, 
	0xbc, 0xbf, 0xf6, 0x7f, 0x6b, 0xff, 0x77, 0xff, 
	0xf5, 0xd7, 0xdf, 0xef, 0xbf, 0xf1, 0xff, 0x19, 
	0xff, 0xef, 0xff, 0xef, 0xfb, 0xbb, 0x76, 0xef, 
	0xbf, 0x7a, 0xff, 0xff, 0xf6, 0xda, 0xeb, 0xbd, 
	0xef, 0xff, 0xff, 0xff, 0xe6, 0xed, 0xff, 0xef, 
	0xbf, 0xff, 0xb9, 0xdb, 0xff, 0xfb, 0xff, 0xff, 
	0x7f, 0x3f, 0xff, 0xfc, 0xf3, 0xdf, 0x5f, 0xfb, 
	0xbf, 0xf1, 0xbf, 0xff, 0x7f, 0xff, 0xb9, 0xfb, 
	0xff, 0xff, 0x7f, 0xef, 0xfb, 0xef, 0xf3, 0xdf, 
	0xfb, 0xff, 0xf9, 0xf7, 0xff, 0x6f, 0xfc, 0xff, 
	0xff, 0xdf, 0xfe, 0xbe, 0xf6, 0xf7, 0xef, 0xfd, 
	0xff, 0xfb, 0xb7, 0x9d, 0x77, 0xf2, 0xff, 0xed, 
	0xe6, 0xfb, 0x1b, 0xfe, 0xff, 0xff, 0xff, 0xee, 
	0x33, 0xce, 0x1f, 0xfd, 0xa7, 0xff, 0xf7, 0xfb, 
	0xdf, 0xff, 0xff, 0xff, 0xf7, 0xf6, 0xff, 0xe6, 
	0xff, 0xfe, 0xff, 0xa7, 0xff, 0xf7, 0xdb, 0xaf, 
	0xff, 0x5f, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xfd, 0x7f, 0xff, 0xb7, 0xf9, 0xf7, 0xf7, 0xff, 
	0xfb, 0x5d, 0x7f, 0x57, 0xfd, 0xad, 0xff, 0xfd, 
	0xe7, 0xdf, 0x7f, 0x3f, 0xed, 0xf5, 0x97, 0xff, 
	0x6f, 0xf6, 0xbf, 0xf6, 0xfa, 0xbf, 0xff, 0xff, 
	0xff, 0xff, 0xe9, 0x3f, 0xb3, 0xfc, 0xfb, 0xef, 
	0x7f, 0xff, 0xfd, 0xf5, 0xfb, 0x9b, 0xfe, 0xff, 
	0xff, 0xfb, 0xff, 0xff, 0xff, 0xf7, 0xff, 0xef, 
	0xef, 0x6f, 0xff, 0xff, 0xff, 0xef, 0x7f, 0xfd, 
	0xff, 0xfb, 0x86, 0xff, 0xab, 0xaf, 0xbf, 0xc9, 
	0x2f, 0xbf, 0xfc, 0xe4, 0x9b, 0xbf, 0xf7, 0xff, 
	0xcb, 0xe7, 0x9f, 0x7f, 0x7e, 0xff, 0x8f, 0xd9, 
	0x5f, 0xff, 0xff, 0x6f, 0xf1, 0x95, 0x3f, 0xff, 
	0xf9, 0xf2, 0xff, 0xfd, 0xd7, 0x4b, 0x7f, 0xf5, 
	0xd5, 0xf4, 0xff, 0x6d, 0xfe, 0xf7, 0xdb, 0x3f, 
	0xef, 0x7f, 0xbf, 0xfa, 0xef, 0xff, 0x5f, 0xe3, 
	0xbd, 0xf5, 0x56, 0x5b, 0x6f, 0x9d, 0xbd, 0xff, 
	0x9b, 0xf5, 0xa5, 0x97, 0xce, 0xfb, 0xff, 0xac, 
	0xff, 0xff, 0x3b, 0xd7, 0x7f, 0xaf, 0xbf, 0xfe, 
	0xfa, 0xeb, 0x4f, 0xff, 0xd7, 0xe6, 0xfe, 0x6b, 
	0xa5, 0x9f, 0xff, 0xc7, 0x7f, 0xff, 0xfd, 0x77, 
	0xff, 0xf7, 0x5f, 0x3b, 0xdd, 0x34, 0xd3, 0xde, 
	0xab, 0xbb, 0x99, 0xff, 0xdf, 0xfd, 0xe2, 0xfe, 
	0x58, 0xef, 0xbf, 0xef, 0xca, 0xf7, 0xfd, 0xff, 
	0xf6, 0xbf, 0xef, 0x3e, 0x73, 0xef, 0x6c, 0xec, 
	0xff, 0xbf, 0xff, 0x6f, 0xff, 0x95, 0xfe, 0xff, 
	0x9f, 0x5f, 0xef, 0xfd, 0xff, 0xfe, 0xf7, 0xdf, 
	0xff, 0xfd, 0xbd, 0x99, 0xf9, 0xaf, 0xbd, 0x56, 
	0xfb, 0x17, 0xad, 0xf4, 0x53, 0x52, 0xd7, 0x70, 
	0x7f, 0x2d, 0xb4, 0xd7, 0x5e, 0x7b, 0x87, 0xef, 
	0x66, 0xfd, 0xfb, 0xee, 0xfb, 0xef, 0xdf, 0xde, 
	0x7b, 0xff, 0xbf, 0x7e, 0xfb, 0xdf, 0x77, 0xdf, 
	0x7d, 0xff, 0xfd, 0xb2, 0xbd, 0x79, 0xff, 0x3e, 
	0xbb, 0xac, 0xf3, 0xd1, 0xe7, 0x9f, 0xff, 0xf7, 
	0xbf, 0xdd, 0xf7, 0xd9, 0x65, 0x9f, 0x7d, 0x3e, 
	0x7b, 0x6f, 0xec, 0x9f, 0x7e, 0xfa, 0xef, 0xbf, 
	0xec, 0xf4, 0xf3, 0xed, 0x73, 0x77, 0xfd, 0xf5, 
	0xd7, 0x4f, 0x3f, 0xfd, 0xe6, 0xbd, 0x99, 0xf9, 
	0x66, 0x8f, 0xfd, 0xff, 0x3f, 0xff, 0xff, 0xef, 
	0xbf, 0xfd, 0xcf, 0x3f, 0xfb, 0x6c, 0xb3, 0xdd, 
	0xb6, 0xef, 0xcf, 0xe6, 0xfe, 0xda, 0x6e, 0xff, 
	0xff, 0xff, 0xbf, 0xff, 0xfe, 0xdf, 0xff, 0xfe, 
	0xdd, 0x76, 0xbb, 0xed, 0xb7, 0xfd, 0xfd, 0xab, 
	0xa9, 0xdf, 0x5b, 0x6f, 0xfd, 0xfd, 0xd7, 0xc2, 
	0x1f, 0xbf, 0xfc, 0xbf, 0xff, 0xd7, 0x5e, 0x7b, 
	0xad, 0xb5, 0x97, 0xfe, 0x6e, 0xd8, 0xbf, 0xfb, 
	0x2e, 0xbf, 0x77, 0xbe, 0xf8, 0xef, 0xad, 0xfd, 
	0x7d, 0x95, 0xdf, 0x7f, 0xfd, 0xed, 0xf7, 0xc5, 
	0xdf, 0x98, 0xff, 0xef, 0xbf, 0xff, 0xfa, 0xeb, 
	0xaf, 0xfe, 0xfb, 0xfb, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xe6, 0xff, 
	0xef, 0xb3, 0x8f, 0x3e, 0xfa, 0xe8, 0xf3, 0xcf, 
	0x3c, 0xff, 0xd1, 0x47, 0x1f, 0x7d, 0xf4, 0xd1, 
	0x47, 0x9f, 0xbf, 0xf9, 0xef, 0xfe, 0xfb, 0xaf, 
	0xbf, 0xfe, 0xf2, 0xdf, 0x6f, 0x7e, 0xfd, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff, 0x6f, 
	0xf8, 0xff, 0xfe, 0xfb, 0xeb, 0xaf, 0xbf, 0xfc, 
	0xf7, 0xfb, 0x5f, 0x7f, 0xfd, 0xf5, 0xd7, 0x5f, 
	0x7f, 0xfd, 0xff, 0xff, 0x9b, 0xff, 0xbf, 0xfe, 
	0xfa, 0xef, 0xab, 0xaf, 0xfe, 0xfb, 0xee, 0x57, 
	0xff, 0x7d, 0xf5, 0xd5, 0x57, 0x5f, 0xfd, 0xf7, 
	0xff, 0xe6, 0xfe, 0xfb, 0xef, 0xff, 0xff, 0xfa, 
	0xeb, 0xff, 0xbf, 0xff, 0xe4, 0xd7, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xf9, 0xff, 
	0xde, 0xfb, 0x6f, 0xff, 0xfc, 0xff, 0xff, 0xeb, 
	0xbf, 0xff, 0xef, 0xf6, 0x9f, 0x7c, 0xff, 0xfd, 
	0xa7, 0xf7, 0x6f, 0xfa, 0xff, 0xab, 0xae, 0xbb, 
	0xfe, 0xfa, 0xe9, 0x8f, 0xb7, 0xfa, 0xe5, 0x93, 
	0x5d, 0x6f, 0xad, 0x75, 0xd7, 0x1d, 0xff, 0x9a, 
	0xff, 0xdf, 0xff, 0xff, 0xfe, 0x8f, 0xff, 0xff, 
	0xd3, 0xbb, 0xff, 0xdf, 0xf7, 0xff, 0xff, 0x9f, 
	0x7f, 0xfe, 0xfd, 0xff, 0xc6, 0xff, 0xfd, 0xf7, 
	0xdf, 0x7f, 0xfe, 0x7d, 0xf7, 0xdf, 0xef, 0x7f, 
	0xff, 0xfa, 0xff, 0x7f, 0x75, 0xf6, 0xfd, 0xfb, 
	0x9f, 0xf9, 0xff, 0xf7, 0xff, 0xff, 0x7d, 0xff, 
	0xff, 0xbf, 0xbf, 0xfd, 0xff, 0xbf, 0xff, 0xff, 
	0xf6, 0xbf, 0xb7, 0xee, 0xff, 0x6f, 0xfe, 0xff, 
	0xfe, 0xbb, 0xeb, 0xbf, 0xff, 0xf7, 0xf7, 0xd3, 
	0x7d, 0xbb, 0x75, 0xfd, 0xd7, 0x5f, 0x7b, 0xf9, 
	0xb7, 0xff, 0x9b, 0xff, 0xff, 0xf7, 0xfb, 0xfb, 
	0xff, 0xff, 0xff, 0xaf, 0xff, 0xef, 0xff, 0xff, 
	0x7d, 0xf7, 0xb5, 0xfb, 0x76, 0xef, 0xff, 0xe6, 
	0xff, 0xfb, 0xef, 0xbf, 0xf7, 0xfe, 0xef, 0xfb, 
	0xff, 0xae, 0x7f, 0xc7, 0xff, 0x7d, 0xdd, 0xf6, 
	0xd7, 0x7f, 0xff, 0xbf, 0xf9, 0xe7, 0xdf, 0x7f, 
	0xff, 0xff, 0xed, 0xec, 0xff, 0xcf, 0xff, 0xff, 
	0xed, 0xff, 0x9f, 0xff, 0xda, 0xeb, 0x6b, 0xff, 
	0x6f, 0xfe, 0xfe, 0xff, 0xff, 0xbf, 0xff, 0xbf, 
	0xbf, 0xcf, 0x2f, 0xed, 0x7f, 0xbf, 0xdf, 0xdf, 
	0xeb, 0xff, 0xff, 0x5f, 0x7f, 0x9b, 0xff, 0xff, 
	0xff, 0xff, 0xbf, 0xff, 0xff, 0x6b, 0x7f, 0xfd, 
	0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0xe7, 
	0xf7, 0xff, 0xe6, 0xdf, 0xff, 0xf7, 0xdf, 0xff, 
	0xff, 0x3f, 0xbb, 0xff, 0x6e, 0xef, 0xff, 0xff, 
	0xbf, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xbf, 0xf9, 
	0xff, 0xff, 0xea, 0xbf, 0xbf, 0x7e, 0xff, 0xff, 
	0xbf, 0xff, 0x7b, 0x77, 0xdf, 0x5f, 0xff, 0xfd, 
	0xf7, 0xdf, 0xff, 0x6f, 0xfc, 0x9f, 0xfe, 0xb3, 
	0x4d, 0xbf, 0xff, 0xfb, 0xdf, 0xdf, 0xfe, 0x77, 
	0xfd, 0xf3, 0xdf, 0x2f, 0xfb, 0xec, 0xe3, 0xfd, 
	0x99, 0xfe, 0xff, 0xff, 0xfe, 0xda, 0xf7, 0xff, 
	0xff, 0xfb, 0xfe, 0x7d, 0xdb, 0xfd, 0xfd, 0xd7, 
	0x6f, 0xbf, 0xff, 0xde, 0xff, 0xa6, 0xff, 0xab, 
	0xbf, 0xbd, 0xfb, 0xda, 0x7b, 0xff, 0xd6, 0x93, 
	0xdf, 0xf7, 0xff, 0xff, 0x3f, 0xdf, 0x7f, 0xf3, 
	0xfd, 0xaf, 0xd9, 0xff, 0xef, 0xef, 0xe9, 0xff, 
	0xff, 0x7e, 0xdd, 0x7c, 0x57, 0xfb, 0xff, 0xff, 
	0x5f, 0x7f, 0xfd, 0xe5, 0xd7, 0xff, 0x6d, 0xfe, 
	0xf7, 0xff, 0x7b, 0xaf, 0xfd, 0xa7, 0xfd, 0xfa, 
	0xff, 0xff, 0xe7, 0xbf, 0xf6, 0xd6, 0x5b, 0x6d, 
	0xbd, 0x55, 0xfe, 0x1b, 0xf5, 0xa5, 0xff, 0x5e, 
	0x7b, 0xe9, 0xed, 0xbf, 0xfe, 0xff, 0xf7, 0xff, 
	0xe7, 0xbd, 0xfe, 0xfa, 0xeb, 0xaf, 0x9f, 0xd7, 
	0xc6, 0xbe, 0xe9, 0xb6, 0xfd, 0xf6, 0x9a, 0x38, 
	0xff, 0xbd, 0xf4, 0x37, 0xd3, 0xcf, 0x7b, 0xed, 
	0xb5, 0xd7, 0x5e, 0xff, 0xbb, 0x99, 0xff, 0xff, 
	0x6f, 0xbf, 0xfd, 0xf7, 0xee, 0xbf, 0xaf, 0x7f, 
	0xf5, 0x5d, 0xf1, 0xfe, 0xab, 0xaf, 0xbe, 0xfa, 
	0xff, 0x6c, 0xec, 0xff, 0xf7, 0xdb, 0xfb, 0xff, 
	0xbf, 0x51, 0xea, 0xab, 0x7f, 0x7d, 0xfd, 0xf5, 
	0xff, 0xfb, 0xfb, 0xef, 0xff, 0xbf, 0x99, 0xf9, 
	0xaf, 0xfd, 0xfe, 0xde, 0x6b, 0x6c, 0xbf, 0xf6, 
	0xd2, 0xd7, 0x5e, 0x7f, 0xfd, 0x35, 0xd4, 0x5e, 
	0x7b, 0xed, 0xef, 0x46, 0xfd, 0xfb, 0xfe, 0xdb, 
	0xef, 0xbe, 0x5f, 0x7f, 0xff, 0xed, 0xee, 0xff, 
	0xff, 0x7f, 0xdf, 0x7d, 0xf7, 0xfd, 0xf7, 0x9d, 
	0x71, 0xff, 0x2f, 0xbf, 0xff, 0xf3, 0xcf, 0xc7, 
	0x9f, 0x7f, 0xde, 0xf3, 0xff, 0xf4, 0xdf, 0x67, 
	0x9f, 0x7d, 0x76, 0x79, 0x6f, 0xec, 0x9f, 0xfe, 
	0xfa, 0xeb, 0xaf, 0xbf, 0xfe, 0xe3, 0x4d, 0x7f, 
	0xf8, 0xfd, 0xf5, 0xd2, 0x4b, 0x7f, 0xbd, 0xf4, 
	0xbb, 0x99, 0xf9, 0x6b, 0x9f, 0xff, 0xf6, 0xd9, 
	0xef, 0xfc, 0xef, 0xff, 0xff, 0xff, 0x3f, 0xff, 
	0xec, 0xb7, 0xcf, 0x3e, 0xdb, 0xce, 0xe6, 0xfe, 
	0xdb, 0xfd, 0xbe, 0xbd, 0xf6, 0xbf, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xfb, 0x77, 0xfb, 0xed, 0xb5, 
	0xdb, 0xee, 0xbb, 0xb9, 0xff, 0xdb, 0xeb, 0xbf, 
	0xfd, 0xf6, 0xff, 0x1f, 0x6f, 0xf4, 0xe1, 0xf5, 
	0xdf, 0x5f, 0x6b, 0xed, 0xb5, 0xd6, 0xfe, 0x6e, 
	0xde, 0xbf, 0xeb, 0xe2, 0xbb, 0xef, 0xfe, 0xfb, 
	0xef, 0x8f, 0x7e, 0x7c, 0xf9, 0xd5, 0x7f, 0xff, 
	0xfd, 0xf7, 0x5f, 0xdf, 0x9b, 0xff, 0xef, 0xbf, 
	0xfe, 0xbe, 0xfb, 0xfe, 0xff, 0x7f, 0xfb, 0xdf, 
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xf7, 0xdf, 
	0xff, 0xe6, 0xff, 0xef, 0xa3, 0xcf, 0x3e, 0xfb, 
	0xfc, 0x71, 0xcf, 0x3d, 0xe7, 0xd8, 0x6d, 0x37, 
	0x9d, 0xf4, 0xd1, 0x47, 0x9f, 0xbf, 0xf9, 0xff, 
	0xfe, 0x0b, 0xef, 0xbf, 0xff, 0x77, 0xdf, 0x7f, 
	0x7f, 0xf9, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0x6f, 0xfe, 0xff, 0xfe, 0xfa, 0xef, 
	0xbf, 0xff, 0x7f, 0xff, 0xff, 0x5f, 0xbf, 0xff, 
	0xf4, 0xd3, 0x4f, 0x7f, 0xfd, 0xf5, 0xff, 0x9b, 
	0xff, 0xbf, 0xbe, 0xfe, 0xeb, 0xaf, 0x7f, 0xde, 
	0xf9, 0xe3, 0x3f, 0xeb, 0x97, 0x57, 0x54, 0x50, 
	0x5f, 0x7d, 0xf5, 0xff, 0xe6, 0xff, 0xfb, 0xaf, 
	0xbf, 0xff, 0xfe, 0xff, 0xfd, 0xff, 0xff, 0xfe, 
	0xfe, 0x79, 0xe7, 0x9f, 0xff, 0xff, 0xff, 0xff, 
	0xbf, 0xb9, 0xff, 0xfe, 0xdb, 0x6f, 0xbf, 0xff, 
	0xf2, 0xff, 0xff, 0x7f, 0xe9, 0xed, 0x9f, 0xdf, 
	0x7e, 0xba, 0xe9, 0x97, 0xfe, 0x6f, 0xfa, 0xef, 
	0xcb, 0xaf, 0xb5, 0xd2, 0xfa, 0xeb, 0xaf, 0xbf, 
	0xbe, 0xa5, 0xd7, 0x5f, 0x2d, 0xd9, 0x35, 0x57, 
	0x5b, 0xff, 0x9b, 0x3f, 0x5f, 0x3a, 0xf3, 0xee, 
	0xfe, 0x9f, 0xdb, 0xe8, 0xe3, 0xdf, 0x9f, 0xf7, 
	0x7f, 0x5d, 0xfd, 0xff, 0xff, 0xf7, 0xff, 0x46, 
	0xff, 0xfb, 0xff, 0xfe, 0xff, 0xff, 0xfd, 0xe7, 
	0x9d, 0xbf, 0xf7, 0xff, 0xed, 0xb7, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0x9f, 0xe9, 0xff, 0x5f, 0xff, 
	0xff, 0xdd, 0xfb, 0xfb, 0xb7, 0x5f, 0xf4, 0xff, 
	0xff, 0xff, 0xff, 0xfb, 0xff, 0xdf, 0x7f, 0xff, 
	0x6f, 0xfe, 0xbe, 0xfc, 0xee, 0xaf, 0x4f, 0x37, 
	0xec, 0xff, 0xaf, 0xdf, 0xfb, 0xf5, 0xe5, 0xc7, 
	0x6f, 0x7d, 0xfd, 0xf5, 0xff, 0x99, 0xff, 0xbf, 
	0xff, 0xce, 0xfe, 0xbf, 0xdf, 0xdf, 0xef, 0x5f, 
	0xbf, 0xfe, 0xff, 0x7b, 0xfb, 0xef, 0x7b, 0xef, 
	0xf5, 0xff, 0xe6, 0xef, 0xfb, 0xbb, 0x6f, 0xee, 
	0xdb, 0xff, 0xbd, 0xaf, 0xef, 0xaf, 0xd7, 0x5f, 
	0xfb, 0xdf, 0xbe, 0xd1, 0x56, 0xff, 0xbf, 0xf9, 
	0xff, 0xff, 0xf6, 0xff, 0x7c, 0xff, 0xff, 0xf3, 
	0xfc, 0xff, 0xff, 0xed, 0xf7, 0xff, 0xff, 0xff, 
	0x5d, 0xb7, 0xff, 0x6f, 0xfe, 0xdf, 0xf7, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xeb, 0xff, 0xef, 0xf3, 
	0xf1, 0xc7, 0xff, 0xf3, 0xff, 0xf9, 0xe7, 0xff, 
	0x9b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 
	0x5b, 0x7d, 0xbc, 0xfd, 0x8f, 0xbf, 0xff, 0xbe, 
	0xff, 0xff, 0xff, 0xff, 0xdf, 0xe6, 0xfc, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xee, 0xbf, 0xbf, 0xfe, 
	0xdf, 0x5f, 0xff, 0xff, 0xef, 0xff, 0xff, 0xff, 
	0xff, 0xbf, 0xf9, 0xff, 0x7f, 0xef, 0xa7, 0xbf, 
	0xf6, 0x3f, 0xeb, 0xba, 0xd3, 0xff, 0x31, 0xd3, 
	0x6f, 0xb7, 0xf5, 0xf7, 0xd7, 0xef, 0x6f, 0xf8, 
	0xdf, 0xff, 0xfa, 0xef, 0x3f, 0xff, 0xfc, 0xfa, 
	0xef, 0xff, 0x6f, 0xbd, 0x65, 0xff, 0xff, 0xbf, 
	0xf8, 0xf4, 0xff, 0x9b, 0xff, 0xff, 0xb7, 0x7f, 
	0xed, 0xef, 0xdf, 0xff, 0xff, 0x7a, 0xff, 0xff, 
	0xef, 0xbf, 0xbd, 0xf6, 0x7f, 0xfd, 0xff, 0xff, 
	0x86, 0xff, 0xfb, 0xac, 0xbe, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0x9f, 0x37, 0x3e, 0x7f, 0xfc, 0xff, 
	0xff, 0xff, 0xff, 0xfe, 0x8f, 0xd9, 0xff, 0x7f, 
	0xed, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0x65, 
	0xef, 0xff, 0xda, 0xdf, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0x6d, 0xfe, 0xa7, 0xf6, 0x6b, 0xfe, 0xff, 
	0xff, 0xff, 0xff, 0xdf, 0xd5, 0xcf, 0xb7, 0xdc, 
	0xd4, 0xf8, 0x4f, 0x9f, 0xfd, 0xff, 0x9b, 0xf5, 
	0xbd, 0xb7, 0x9e, 0x7b, 0xf3, 0xff, 0xff, 0xff, 
	0xed, 0xf7, 0xfb, 0xcf, 0xbf, 0x7f, 0xfe, 0xdf, 
	0x4f, 0xff, 0xd7, 0xe6, 0xfe, 0xfa, 0xeb, 0x9b, 
	0x1f, 0xbf, 0xdd, 0xaf, 0xfd, 0xff, 0xb7, 0xdd, 
	0xcf, 0x97, 0xbf, 0xfc, 0xf3, 0xdf, 0xff, 0xbb, 
	0x99, 0xff, 0xaf, 0xa9, 0xe7, 0xda, 0x5b, 0xf7, 
	0xcb, 0xff, 0x7f, 0xf7, 0xd5, 0x70, 0xdf, 0x7d, 
	0x75, 0xdc, 0x77, 0xff, 0x6c, 0xec, 0xbf, 0xfe, 
	0xfa, 0xee, 0xbf, 0xff, 0x5d, 0x62, 0xff, 0xdc, 
	0x2f, 0xfd, 0xf7, 0xf7, 0x5f, 0x5f, 0xff, 0x3d, 
	0xbe, 0x99, 0xfb, 0xbf, 0xbf, 0xf7, 0xfb, 0xff, 
	0x7f, 0xbf, 0xb6, 0x3f, 0x77, 0x7a, 0xff, 0xff, 
	0xff, 0xdf, 0xdf, 0x7f, 0x9f, 0xef, 0xe6, 0xfd, 
	0xff, 0xf6, 0xfb, 0xff, 0xff, 0xdf, 0xff, 0xf3, 
	0xef, 0x6e, 0xf9, 0xfd, 0xe7, 0xff, 0x7f, 0xff, 
	0xff, 0xff, 0xbd, 0x79, 0xff, 0xff, 0xff, 0xf7, 
	0xf7, 0xdf, 0xff, 0xbf, 0xff, 0xde, 0xb3, 0xff, 
	0xfa, 0xff, 0xff, 0x3f, 0xfe, 0xff, 0x7b, 0x6f, 
	0xec, 0xd7, 0xfe, 0xfb, 0xef, 0xb3, 0xcf, 0x7e, 
	0xdb, 0xef, 0x7f, 0xf6, 0xdd, 0xb6, 0xdf, 0x6f, 
	0xbf, 0xfd, 0xf6, 0xbd, 0x99, 0xf9, 0xff, 0xdf, 
	0xff, 0xbf, 0xfd, 0xfe, 0xef, 0xff, 0xff, 0xfd, 
	0xef, 0xdf, 0xff, 0x7e, 0xfb, 0xf7, 0xb7, 0xff, 
	0xcf, 0xa6, 0xfe, 0xff, 0xfe, 0xff, 0xdf, 0xff, 
	0xff, 0xff, 0xff, 0xeb, 0xdf, 0xfd, 0xff, 0xdf, 
	0x7f, 0xff, 0xff, 0xfd, 0xff, 0xbb, 0xb9, 0xff, 
	0xff, 0xeb, 0xbf, 0xff, 0x78, 0xe3, 0x6f, 0x3f, 
	0x7c, 0xa9, 0xfd, 0xf7, 0x7f, 0x7f, 0xff, 0xf7, 
	0xdf, 0xff, 0x6a, 0xde, 0xff, 0xfd, 0xe2, 0xcf, 
	0xff, 0xff, 0xfd, 0x27, 0x8d, 0x5f, 0x7c, 0xf9, 
	0xe7, 0x97, 0xcf, 0xbe, 0xf9, 0xe4, 0xdf, 0x9b, 
	0xfe, 0xaf, 0xbf, 0x6e, 0xfe, 0xff, 0x3f, 0xff, 
	0xde, 0xf7, 0xdf, 0x5f, 0xbf, 0xff, 0xfe, 0xff, 
	0x7f, 0xff, 0xff, 0xff, 0xa6, 0xff, 0xeb, 0xa3, 
	0x8f, 0x3f, 0xf7, 0xfc, 0xf3, 0xcf, 0x3f, 0xfd, 
	0xf9, 0xc7, 0x9f, 0x7f, 0xfc, 0xd9, 0xe7, 0x9f, 
	0xbf, 0xf9, 0xff, 0xfb, 0xff, 0xbf, 0xff, 0xfe, 
	0xe7, 0xdb, 0xff, 0x7f, 0xff, 0xef, 0xdf, 0x7f, 
	0x7f, 0xfd, 0xf7, 0xdf, 0xff, 0x6f, 0xfe, 0xbf, 
	0xff, 0xff, 0xef, 0xff, 0xbf, 0xff, 0xf6, 0xff, 
	0x7f, 0x7f, 0xfb, 0xf5, 0xf7, 0xff, 0xff, 0xff, 
	0xf5, 0xff, 0x9b, 0xff, 0xbf, 0xff, 0xfb, 0xfe, 
	0xff, 0xff, 0xff, 0xfb, 0xef, 0x7f, 0xdf, 0x7f, 
	0xff, 0xfd, 0xf7, 0x7f, 0xff, 0xff, 0xff, 0x86, 
	0xbf, 0xfb, 0xff, 0xbf, 0xff, 0xff, 0xdb, 0xff, 
	0xff, 0xff, 0xfe, 0xbf, 0x7f, 0xff, 0xfd, 0xff, 
	0xff, 0xff, 0xff, 0xbf, 0xf9, 0xff, 0xf2, 0xcb, 
	0x2b, 0xbf, 0xfc, 0xff, 0xff, 0xff, 0xbf, 0xf9, 
	0xfd, 0x97, 0x7f, 0x7e, 0xf7, 0xcf, 0xbe, 0xff, 
	0x6f, 0xfe, 0x7f, 0x6b, 0xae, 0xb9, 0x6c, 0xf2, 
	0x8b, 0x2f, 0xbf, 0xe6, 0xf5, 0x46, 0x5f, 0x7e, 
	0xb5, 0xe5, 0xd7, 0x5f, 0xff, 0x9a, 0xfe, 0xff, 
	0xff, 0xff, 0xff, 0xfd, 0xf7, 0xfb, 0xec, 0xf3, 
	0x9f, 0xfb, 0xbf, 0xfe, 0xfe, 0xff, 0xdf, 0x7f, 
	0xdf, 0xff, 0xc6, 0xff, 0xfe, 0xff, 0xff, 0xff, 
	0xcf, 0xff, 0x97, 0xeb, 0xee, 0x5d, 0xfd, 0xff, 
	0xff, 0xff, 0xfe, 0xfb, 0xef, 0xff, 0x9f, 0xf9, 
	0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 
	0xe7, 0xc7, 0xfd, 0x7f, 0xff, 0xff, 0xf9, 0xff, 
	0xff, 0xff, 0xff, 0x6f, 0xfe, 0xbf, 0xff, 0x5a, 
	0xff, 0xff, 0xbf, 0xfe, 0x7b, 0xef, 0x9f, 0x7e, 
	0xff, 0xf4, 0xd7, 0x55, 0x7f, 0xfd, 0xff, 0xef, 
	0x9b, 0xff, 0x7f, 0x7f, 0xfe, 0xdf, 0xff, 0x9f, 
	0xff, 0xbf, 0x3f, 0xff, 0x7d, 0xff, 0x7a, 0x6d, 
	0xdf, 0xdf, 0xfe, 0xff, 0xff, 0xe6, 0xff, 0xff, 
	0xff, 0xdb, 0xff, 0xff, 0xff, 0xea, 0xbb, 0xfe, 
	0xfe, 0xfd, 0x7b, 0xbf, 0xfd, 0xe0, 0xbf, 0xff, 
	0xff, 0xbf, 0xf9, 0xef, 0xff, 0xff, 0xff, 0xfd, 
	0xff, 0xf7, 0xdf, 0xdf, 0xdf, 0xff, 0xef, 0xff, 
	0xdf, 0x7f, 0xff, 0xdf, 0xff, 0xfd, 0x6f, 0xfe, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 
	0xff, 0xef, 0xff, 0xff, 0xef, 0x9f, 0x75, 0xff, 
	0xff, 0xff, 0xfb, 0x9b, 0xff, 0x7f, 0xfe, 0xdf, 
	0xff, 0xff, 0x8f, 0x7f, 0xfb, 0xfd, 0xff, 0xf5, 
	0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xe6, 0xfe, 0xff, 0xff, 0xfe, 0xff, 0xef, 0xdf, 
	0xbd, 0xff, 0xbd, 0xff, 0x79, 0xff, 0xfb, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xbf, 0xf9, 0x7e, 0xfb, 
	0xeb, 0xa7, 0xff, 0xff, 0xff, 0xeb, 0xf7, 0xf5, 
	0x6f, 0xff, 0x9b, 0x4f, 0xff, 0xc9, 0xf7, 0xd7, 
	0xff, 0x6f, 0x7c, 0xff, 0xfe, 0xfb, 0xaf, 0xff, 
	0xff, 0x7f, 0xf2, 0xfe, 0xff, 0xfe, 0xff, 0xf7, 
	0xd7, 0x3e, 0xfb, 0xdf, 0xf4, 0xff, 0x99, 0xef, 
	0xaf, 0xff, 0xfe, 0xfd, 0xff, 0xff, 0xfe, 0xdf, 
	0xff, 0xff, 0xfb, 0x7f, 0xfd, 0xfe, 0xdf, 0xdf, 
	0xfb, 0xff, 0xff, 0xa6, 0xff, 0xff, 0xfc, 0xfe, 
	0x5f, 0x27, 0xbf, 0xe9, 0xfd, 0x52, 0x8f, 0xf7, 
	0xdf, 0x7f, 0xfd, 0xed, 0xbf, 0xff, 0xff, 0x8d, 
	0xd9, 0xff, 0x7f, 0xfd, 0xff, 0xf3, 0x9f, 0xff, 
	0xfb, 0x79, 0xd5, 0xff, 0xfd, 0xf7, 0x5f, 0xff, 
	0xfd, 0xff, 0xff, 0xff, 0x6d, 0xfe, 0xff, 0xff, 
	0xef, 0xff, 0xff, 0xfe, 0xfb, 0xde, 0xef, 0xff, 
	0xcd, 0x3d, 0xff, 0xff, 0xeb, 0xaf, 0xff, 0xff, 
	0xbf, 0x9b, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xbf, 0xff, 0xff, 0xff, 0xd9, 0xe7, 0x9f, 
	0x7d, 0xd6, 0x79, 0xff, 0xff, 0xd7, 0xe6, 0xfe, 
	0xfd, 0xff, 0xfd, 0xff, 0xff, 0x7f, 0x6f, 0xbd, 
	0x66, 0xff, 0xf7, 0xcc, 0xfb, 0xfd, 0x7c, 0xf3, 
	0xed, 0xff, 0xba, 0xb9, 0x3f, 0xef, 0xff, 0xff, 
	0xfe, 0xff, 0xff, 0x7b, 0xef, 0xd6, 0xff, 0xbd, 
	0xf2, 0x5e, 0x8d, 0xf7, 0xd5, 0xff, 0xff, 0x6c, 
	0xee, 0xef, 0xff, 0xef, 0xff, 0xff, 0xfd, 0xfb, 
	0x7e, 0xeb, 0xff, 0xff, 0xfd, 0xf5, 0xd7, 0x5f, 
	0x2f, 0x9d, 0xff, 0xbf, 0x99, 0xf9, 0xff, 0xff, 
	0xf7, 0xff, 0xff, 0xff, 0xbd, 0xb5, 0xce, 0xff, 
	0xdf, 0x7f, 0xfd, 0xff, 0xff, 0x7f, 0xaf, 0xff, 
	0xef, 0x86, 0xbd, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xdf, 0x7f, 0xff, 0xcd, 0xfe, 0xff, 0xfd, 0xe7, 
	0xdf, 0x7f, 0xfe, 0xf9, 0xe7, 0xbd, 0x79, 0x57, 
	0x7f, 0xfe, 0xfd, 0xe7, 0xff, 0xe7, 0x9f, 0x7f, 
	0xe6, 0xff, 0xff, 0xfa, 0xfb, 0xaf, 0xff, 0xff, 
	0xfe, 0x73, 0x6f, 0xec, 0xfb, 0x76, 0xfb, 0x6e, 
	0xbf, 0xff, 0x58, 0xf3, 0xcd, 0x7f, 0xff, 0xdd, 
	0xf7, 0xd8, 0x6d, 0xab, 0x6d, 0xf6, 0xbf, 0x99, 
	0xf9, 0xf7, 0xdb, 0x7f, 0xff, 0xff, 0xff, 0xdf, 
	0x3f, 0xff, 0xff, 0xef, 0xff, 0xff, 0xfe, 0xf9, 
	0xef, 0xb7, 0xff, 0x4f, 0xe6, 0xbe, 0xff, 0xfd, 
	0xef, 0xff, 0xff, 0xff, 0xfb, 0xee, 0xfb, 0xff, 
	0xfe, 0xff, 0xdf, 0xbf, 0xff, 0xfd, 0xfd, 0xff, 
	0xbb, 0xb9, 0xff, 0xfe, 0x6f, 0xb7, 0xff, 0xff, 
	0xc7, 0x1f, 0x3f, 0xfc, 0xff, 0xf5, 0xd7, 0xdf, 
	0x7f, 0xfd, 0xf5, 0xd7, 0xfb, 0x68, 0xde, 0x9f, 
	0xdc, 0xeb, 0xcd, 0xff, 0xff, 0x7b, 0xe2, 0x9b, 
	0xff, 0x7f, 0xb5, 0xdd, 0xbb, 0xff, 0x7e, 0xfb, 
	0xe4, 0xcf, 0x9b, 0xff, 0xff, 0xbf, 0xef, 0xfb, 
	0xff, 0x7f, 0xfb, 0xdd, 0xfb, 0xff, 0x7f, 0xf7, 
	0xfd, 0xff, 0xff, 0xef, 0x7f, 0xff, 0xff, 0xe6, 
	0xff, 0xfb, 0xe3, 0x8f, 0x3f, 0x7f, 0xfc, 0xb3, 
	0x8f, 0x3d, 0xff, 0xf1, 0xe7, 0x9f, 0x7f, 0xf6, 
	0xf1, 0xe7, 0x9f, 0xbf, 0xf9, 0xff, 0xfe, 0xcf, 
	0xbf, 0xff, 0x7f, 0xf7, 0xff, 0x2f, 0xff, 0xff, 
	0xfd, 0xd7, 0xff, 0xff, 0xfd, 0xf7, 0xd7, 0xdf, 
	0x6f, 0xfe, 0x9f, 0xfe, 0xfb, 0xfb, 0xff, 0xff, 
	0xff, 0xfe, 0xeb, 0xff, 0xff, 0xfd, 0xfd, 0xd7, 
	0xff, 0xff, 0xff, 0xf5, 0xff, 0x9b, 0xff, 0xff, 
	0xbf, 0xf9, 0xfb, 0xff, 0x7d, 0xfe, 0xfb, 0xe7, 
	0xff, 0xff, 0xfd, 0xf5, 0xf5, 0xf7, 0xdf, 0x7f, 
	0xff, 0xff, 0xe6, 0xfd, 0xfb, 0xef, 0xff, 0xfe, 
	0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 
	0x7f, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xbf, 0x79, 
	0xdf, 0xff, 0xfe, 0xfd, 0xff, 0xff, 0xef, 0x7a, 
	0xef, 0xff, 0xbf, 0xed, 0xb7, 0x5f, 0x6e, 0xff, 
	0xed, 0xfe, 0xff, 0x6f, 0xee, 0xff, 0xeb, 0xaf, 
	0xbe, 0xfe, 0xda, 0xa9, 0x2f, 0xb7, 0xf6, 0x75, 
	0xd7, 0x5d, 0x7f, 0xfd, 0x65, 0x57, 0x5f, 0xff, 
	0x9a, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 
	0x7f, 0x7f, 0xf3, 0xff, 0xdf, 0x7d, 0xff, 0xfb, 
	0xef, 0xdf, 0xff, 0xff, 0xfe, 0xc6, 0xff, 0xff, 
	0xe7, 0xff, 0xfb, 0xf7, 0xff, 0x77, 0xff, 0xfe, 
	0x7f, 0xbf, 0xff, 0xff, 0xfb, 0xdf, 0xff, 0xff, 
	0xff, 0x9b, 0xe9, 0xff, 0xff, 0x7f, 0xf3, 0xff, 
	0xbf, 0xf7, 0xfe, 0x65, 0xdf, 0xdf, 0xfe, 0x7b, 
	0xff, 0xef, 0x7f, 0xff, 0xfd, 0xf3, 0x6c, 0xfc, 
	0xff, 0xfb, 0xf2, 0xe3, 0xff, 0xff, 0x7d, 0xfc, 
	0xdb, 0xff, 0xff, 0xfd, 0xff, 0xd7, 0x5f, 0x7d, 
	0xdd, 0xfe, 0xfb, 0x9b, 0xff, 0xff, 0xff, 0xf6, 
	0xfe, 0xff, 0xff, 0xff, 0xaf, 0xeb, 0xff, 0xf6, 
	0xf7, 0xff, 0x6b, 0xbf, 0xff, 0xfe, 0xf7, 0xff, 
	0xa6, 0xff, 0xff, 0xeb, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0x5f, 0xfc, 0xef, 0xf7, 0xff, 0xf7, 0xff, 
	0xf5, 0xf3, 0xff, 0xbf, 0xbf, 0xf9, 0xdb, 0xff, 
	0xdf, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xee, 0xff, 
	0xff, 0xbf, 0xbf, 0xff, 0x7f, 0xff, 0xdf, 0xff, 
	0xff, 0x6f, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xbf, 0xff, 0xef, 0xef, 0xff, 0xff, 0xfe, 
	0xff, 0x7f, 0xfe, 0xff, 0xff, 0xff, 0x9b, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xef, 0xff, 0xfd, 0xff, 0xef, 0xff, 0xff, 0xff, 
	0xfe, 0xef, 0xff, 0xe6, 0xff, 0xff, 0xff, 0xf7, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xfd, 
	0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xef, 0xbf, 
	0xf9, 0xff, 0xdf, 0x9f, 0xfe, 0xf9, 0xfb, 0xff, 
	0xff, 0xfb, 0xff, 0x5f, 0xff, 0xd7, 0xfd, 0x7f, 
	0xfd, 0xff, 0x7f, 0xff, 0x6f, 0xfe, 0xfb, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xf9, 0xf7, 0x6f, 0x5e, 
	0xfd, 0xff, 0xff, 0xff, 0x7e, 0xf9, 0xdf, 0xff, 
	0xff, 0x99, 0xfd, 0xff, 0xff, 0xfb, 0x7f, 0xff, 
	0xff, 0xfb, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xef, 
	0xff, 0xdf, 0xfd, 0xbb, 0xff, 0xff, 0x66, 0xff, 
	0xcf, 0x3f, 0xdf, 0xfc, 0xf3, 0xc3, 0x3f, 0xff, 
	0xfc, 0xef, 0x9e, 0xfb, 0xee, 0xf9, 0xef, 0x9f, 
	0x7f, 0xfe, 0x9f, 0xf9, 0xff, 0xf7, 0xcf, 0x7f, 
	0xdf, 0xfd, 0xf1, 0x8f, 0x3f, 0xdb, 0xdd, 0xef, 
	0xff, 0x7f, 0xfe, 0xff, 0xef, 0xbf, 0xf7, 0x6f, 
	0xfe, 0xdf, 0xfe, 0xfb, 0xef, 0x9f, 0x1b, 0xfe, 
	0xfb, 0xcf, 0x6f, 0xbf, 0xfd, 0x77, 0xdf, 0x7f, 
	0xff, 0xfd, 0xf7, 0xff, 0x9b, 0xff, 0xff, 0xfd, 
	0xfd, 0xdf, 0x7f, 0xb7, 0xfd, 0x7d, 0xd7, 0xff, 
	0xff, 0xfb, 0xef, 0xff, 0xff, 0xfe, 0xff, 0xff, 
	0xff, 0xa6, 0xff, 0xee, 0xbf, 0xff, 0xfe, 0xfb, 
	0xe7, 0xbf, 0xff, 0xfb, 0xe6, 0xdf, 0x7f, 0xef, 
	0xf9, 0xb7, 0xde, 0x7f, 0xff, 0xbf, 0xf9, 0xff, 
	0x7c, 0xf3, 0xcf, 0x7f, 0xff, 0xfd, 0xf3, 0xcf, 
	0x7f, 0xfe, 0xf9, 0xe3, 0x8f, 0x7f, 0xfe, 0xb9, 
	0x67, 0xf7, 0x6f, 0xfe, 0xbf, 0xfb, 0xbe, 0xfb, 
	0xef, 0xbf, 0xff, 0xbe, 0xfb, 0xdb, 0x76, 0xff, 
	0xed, 0xf7, 0xdd, 0x7a, 0xff, 0xbd, 0xff, 0x9b, 
	0xff, 0x9f, 0x7e, 0xfa, 0xe9, 0xa7, 0x9f, 0x7e, 
	0xfa, 0xfd, 0xef, 0x3f, 0xfd, 0xfe, 0xd3, 0xef, 
	0x3f, 0xfd, 0xf4, 0xff, 0xe6, 0xff, 0xf7, 0xdf, 
	0x7f, 0xfb, 0xfd, 0xf7, 0xde, 0x7d, 0xef, 0x9b, 
	0xef, 0xbf, 0xff, 0xee, 0xfb, 0xef, 0xbf, 0xff, 
	0xbf, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xbf, 0x7f, 0xff, 0xf3, 0xff, 0xbf, 0xef, 
	0xff, 0xfb, 0xff, 0xff, 0xff, 0x6f, 0xfe, 0x7f, 
	0xff, 0xfd, 0xff, 0xdf, 0x7e, 0xff, 0xf5, 0xfe, 
	0xbf, 0xff, 0xfe, 0xfb, 0xef, 0xbf, 0xff, 0x7e, 
	0xfb, 0xff, 0x9b, 0xff, 0xff, 0xdf, 0xff, 0xfc, 
	0xfd, 0xff, 0xf7, 0x7f, 0xf5, 0xfd, 0xfb, 0xab, 
	0xb7, 0xff, 0xfa, 0xef, 0xff, 0xff, 0xff, 0xe6, 
	0xff, 0xdf, 0x7f, 0xff, 0xfd, 0xf7, 0x9f, 0x75, 
	0xfe, 0xfd, 0xef, 0xbf, 0xff, 0xfe, 0xfb, 0xef, 
	0xbf, 0xff, 0xfe, 0xbf, 0xb9, 0xff, 0x37, 0xdf, 
	0x6e, 0xf3, 0xed, 0xb7, 0xdf, 0x4e, 0xfb, 0xdb, 
	0x6f, 0xbf, 0xfd, 0xf6, 0x5b, 0x6f, 0xbf, 0xf9, 
	0x6f, 0xfe, 0xff, 0xf7, 0xdf, 0x7f, 0xff, 0xfd, 
	0xb5, 0xdf, 0x7e, 0xef, 0xfb, 0xef, 0xbf, 0xff, 
	0xfe, 0xfb, 0xef, 0xbf, 0xff, 0x9b, 0xff, 0x7f, 
	0xff, 0xfd, 0xf7, 0xdf, 0x7f, 0xff, 0xbd, 0xf7, 
	0xbf, 0xef, 0xfe, 0xfb, 0xef, 0xbf, 0xff, 0xbe, 
	0xfb, 0xee, 0xe6, 0xff, 0xbf, 0xff, 0xfe, 0xfb, 
	0xef, 0xbf, 0xfb, 0xfe, 0xfb, 0xdf, 0x7f, 0xff, 
	0xfd, 0xf7, 0xdf, 0x7f, 0xff, 0xfd, 0xbf, 0xf9, 
	0xff, 0x2f, 0xbf, 0xff, 0xf2, 0xfb, 0xaf, 0xbf, 
	0xfe, 0xfa, 0xd7, 0x5f, 0x7f, 0xfd, 0xf5, 0xd7, 
	0x5f, 0x7f, 0xf9, 0x6f, 0xfe, 0xff, 0xfb, 0xef, 
	0xbf, 0xff, 0xfe, 0xf9, 0xef, 0xbf, 0xff, 0xfd, 
	0xf7, 0xdf, 0x7f, 0xff, 0xfd, 0xf7, 0xdf, 0xff, 
	0x9b, 0xff, 0xff, 0xfc, 0xf3, 0xcf, 0x3f, 0xff, 
	0xfc, 0xf3, 0xcf, 0x7b, 0xfe, 0xf9, 0xe7, 0x9f, 
	0x7f, 0xfe, 0xf9, 0xe7, 0xf7, 0xe6, 0xff, 0x5f, 
	0x7f, 0xfd, 0xf5, 0xd7, 0x5f, 0x7f, 0xfd, 0xf5, 
	0xaf, 0xbb, 0xfe, 0xba, 0xeb, 0xaf, 0xbf, 0xfe, 
	0xfa, 0xbf, 0xf9, 0xff, 0x1f, 0x7f, 0xfd, 0xf1, 
	0xd7, 0x5b, 0x7f, 0xfd, 0xf5, 0x2f, 0xbf, 0xfe, 
	0xf2, 0xeb, 0xaf, 0xbf, 0xfe, 0xf8, 0x6f, 0xee, 
	0xff, 0xfe, 0xfb, 0xef, 0xbf, 0xff, 0xfe, 0xfb, 
	0xaf, 0x7f, 0xbf, 0xfd, 0xb7, 0xdb, 0x7f, 0xfb, 
	0xfd, 0xd7, 0xff, 0x9b, 0xff, 0xff, 0xff, 0xdf, 
	0xff, 0xff, 0xfd, 0xff, 0xff, 0xef, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff, 
	0xe6, 0xfe, 0xdb, 0xef, 0xbb, 0xff, 0xbe, 0xfb, 
	0xee, 0xbf, 0xed, 0x6d, 0xf7, 0xdf, 0x72, 0xff, 
	0xad, 0xf7, 0xdf, 0xff, 0xbf, 0xf9, 0xbf, 0xf5, 
	0xf5, 0xd6, 0x5f, 0x6f, 0xbd, 0xf5, 0x17, 0xd3, 
	0xd8, 0xfa, 0x8b, 0xad, 0xbf, 0xb8, 0xfa, 0xeb, 
	0xef, 0x6f, 0xfe, 0xff
};


/* rom names */

#define EPP_ROM_CROM0_R_0            0
#define EPP_ROM_CROM0_R_1            16
#define EPP_ROM_CROM0_R_2            32
#define EPP_ROM_CROM0_R_3            48
#define EPP_ROM_CROM0_R_4            64
#define EPP_ROM_CROM0_R_5            80
#define EPP_ROM_CROM0_R_6            96
#define EPP_ROM_CROM0_R_7            112
#define EPP_ROM_CROM1_R_0            128
#define EPP_ROM_CROM1_R_1            144
#define EPP_ROM_CROM1_R_2            160
#define EPP_ROM_CROM1_R_3            176
#define EPP_ROM_CROM1_R_4            192
#define EPP_ROM_CROM1_R_5            208
#define EPP_ROM_CROM1_R_6            224
#define EPP_ROM_CROM1_R_7            240
#define EPP_ROM_DIVROM0              256
#define EPP_ROM_DIVROM1              272
#define EPP_ROM_DIVROM2              288
#define EPP_ROM_SWROMID              304
#define EPP_ROM_SWROMIE              320
#define EPP_ROM_SWROMIS              336
#define EPP_ROM_SWROMOE              352
#define EPP_ROM_SWROMOS              368
#define EPP_ROM_SWROMIC              384
#define EPP_ROM_SWROMOC              400
#define EPP_ROM_SWROMDCD             416
#define EPP_ROM_CLKSELROM            432
#define EPP_ROM_PTTMUTEROM           448
#define EPP_ROM_STIROM               464
#define EPP_ROM_STOROM               480


/* rom locations */
static const unsigned long epp_roms[496] = {
	 81983,  81319,  82149,  81485,  82151,  81487,  81985,  81321,
	 81651,  80987,  81817,  81153,  81819,  81155,  81653,  80989,
	 87969,  87305,  87637,  86973,  88137,  87473,  87805,  87141,
	 88135,  87471,  87803,  87139,  87971,  87307,  87639,  86975,
	 81993,  81661,  82159,  81827,  82161,  81829,  81995,  81663,
	 81329,  80997,  81495,  81163,  81497,  81165,  81331,  80999,
	 87979,  88147,  87315,  87483,  88145,  87981,  87481,  87317,
	 87647,  87815,  86983,  87151,  87813,  87649,  87149,  86985,
	 81973,  82139,  81641,  81807,  82141,  81975,  81809,  81643,
	 81309,  81475,  80977,  81143,  81477,  81311,  81145,  80979,
	 87989,  87657,  87325,  86993,  88157,  87825,  87493,  87161,
	 88155,  87823,  87491,  87159,  87991,  87659,  87327,  86995,
	 58109,  57777,  57445,  57113,  58277,  57945,  57613,  57281,
	 58275,  57943,  57611,  57279,  58111,  57779,  57447,  57115,
	 82003,  82169,  81339,  81505,  82171,  82005,  81507,  81341,
	 81671,  81837,  81007,  81173,  81839,  81673,  81175,  81009,
	 78997,  78829,  79329,  79161,  79661,  79493,  79993,  79825,
	 78831,  78995,  79163,  79327,  79495,  79659,  79827,  79991,
	 84983,  84815,  84817,  84981,  85647,  85479,  85481,  85645,
	 85315,  85147,  85149,  85313,  85979,  85811,  85813,  85977,
	 79007,  78841,  79339,  79173,  79671,  79505,  80003,  79837,
	 78839,  79005,  79171,  79337,  79503,  79669,  79835,  80001,
	 84993,  85657,  84825,  85489,  85325,  85989,  85157,  85821,
	 84827,  85491,  84991,  85655,  85159,  85823,  85323,  85987,
	 78987,  79319,  78821,  79153,  79651,  79983,  79485,  79817,
	 78819,  79151,  78985,  79317,  79483,  79815,  79649,  79981,
	 85003,  84835,  85335,  85167,  85667,  85499,  85999,  85831,
	 84837,  85001,  85169,  85333,  85501,  85665,  85833,  85997,
	 55123,  54955,  55455,  55287,  55787,  55619,  56119,  55951,
	 54957,  55121,  55289,  55453,  55621,  55785,  55953,  56117,
	 79017,  79349,  78849,  79181,  79681,  80013,  79513,  79845,
	 78851,  79183,  79015,  79347,  79515,  79847,  79679,  80011,
	 45880,  45548,  46048,  45716,  46046,  45714,  45882,  45550,
	 45216,  44884,  45384,  45052,  45382,  45050,  45218,  44886,
	 30962,  30796,  31626,  31460,  30794,  30960,  31458,  31624,
	 31294,  31128,  31958,  31792,  31126,  31292,  31790,  31956,
	 45900,  45568,  46068,  45736,  45236,  44904,  45404,  45072,
	 46066,  45734,  45902,  45570,  45402,  45070,  45238,  44906,
	 81902,  81238,  82068,  81404,  82070,  81406,  81904,  81240,
	 81570,  80906,  81736,  81072,  81738,  81074,  81572,  80908,
	 87878,  87546,  88046,  87714,  87214,  86882,  87382,  87050,
	 88044,  87712,  87880,  87548,  87380,  87048,  87216,  86884,
	 27962,  28130,  28128,  27964,  27298,  27466,  27464,  27300,
	 27630,  27798,  27796,  27632,  26966,  27134,  27132,  26968,
	 70000,  70168,  69336,  69504,  70166,  70002,  69502,  69338,
	 69668,  69836,  69004,  69172,  69834,  69670,  69170,  69006,
	 55062,  54896,  55394,  55228,  54894,  55060,  55226,  55392,
	 55726,  55560,  56058,  55892,  55558,  55724,  55890,  56056,
	 64024,  63692,  63360,  63028,  64192,  63860,  63528,  63196,
	 64190,  63858,  63526,  63194,  64026,  63694,  63362,  63030,
	 57998,  58166,  57334,  57502,  58164,  58000,  57500,  57336,
	 57666,  57834,  57002,  57170,  57832,  57668,  57168,  57004,
	 72970,  72802,  73302,  73134,  73634,  73466,  73966,  73798,
	 72804,  72968,  73136,  73300,  73468,  73632,  73800,  73964,
	 75926,  75262,  76092,  75428,  76094,  75430,  75928,  75264,
	 75594,  74930,  75760,  75096,  75762,  75098,  75596,  74932,
	 70011,  69347,  70177,  69513,  70179,  69515,  70013,  69349,
	 69679,  69015,  69845,  69181,  69847,  69183,  69681,  69017,
	 66984,  67648,  67316,  67980,  66816,  67480,  67148,  67812,
	 66818,  67482,  67150,  67814,  66982,  67646,  67314,  67978,
	 63994,  64160,  64162,  63996,  63662,  63828,  63830,  63664,
	 63330,  63496,  63498,  63332,  62998,  63164,  63166,  63000
};

