---
name:  Build problems
about: Report a problem compiling or installing ANTs from source
---

<!--
Text in these brackets are comments, and won't be visible when you submit your
issue. Please read before submitting.

Before opening an issue, please review the build documentation here

https://github.com/ANTsX/ANTs/wiki/Compiling-ANTs-on-Linux-and-Mac-OS

You can also search the wiki and previous issues using the main Github search
bar. Enter search terms and select "In this repository".

If you are using system ITK or VTK, please verify you have the correct
versions (see the Wiki link above). If you can, please also attempt a
Superbuild and let us know if that compiles successfully.
-->

**When did the error occur?**
<!-- place X in the appropriate box -->
[ ] CMake configuration (cmake / ccmake)
[ ] Compilation (make)
[ ] Installation (make install)

**Build environment**
 - OS: [e.g. Mac OS]
 - OS version: [e.g. 10.15.1]
 - Type of system: [Desktop, laptop, HPC cluster, cloud instance,
   other]

<!--
If you are building inside a virtual machine, container, Cygwin, Windows
Subsystem for Linux, or other non-native environment, please let us know and
include details of both the virtual Linux and the host OS.
-->

**ANTs version**
<!--
Specify the release tag or commit hash of the code you are building
from with `git show` in your source directory. If you downloaded a snapshot as a
ZIP file, please provide the tag version (if applicable) or date of the download.
-->

**Build configuration and logs**
<!--
Please attach the following files (relative to your build directory)

  - build.log (the terminal output from make, eg `make | tee build.log`)
  - CMakeCache.txt
  - CMakeFiles/CMakeError.log
  - CMakeFiles/CMakeOutput.log
-->

**Additional context**
<!--Add any other context about the problem here.-->
